/*
 * @Author: jifgao
 * @Date:   2020-08-13 17:00:51
 * @Last Modified by:   jifgao
 * @Last Modified time: 2020-08-21 15:46:05
 */
// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;
import BaseScene from "../BaseScene"
@ccclass
export default class TestNumber extends BaseScene {
    

    @property(cc.Node)
    btnAdd:cc.Node = null;

    @property(cc.Node)
    tempNode:cc.Node = null;

    @property(cc.Label)
    lbCount:cc.Node = null;

    _count:number = 0;
    _spriteFrame:cc.SpriteFrame = null;

    onLoad(){
        super.onLoad();
        this.btnAdd.on("click",this._onAddClick,this);
        cc.resources.load("sprite",cc.SpriteFrame,function(error,asset){
            this._spriteFrame = asset;
            this._spriteFrame.addRef();
        }.bind(this))
        this._count = 0;

        this.lbCount.getComponent(cc.Label).string = "总共:" + this._count;
    }

    _onAddClick(){
        this._genSprites(50);

        
    }

    _genSprites(__addNum:number){
        let count = 100;
       for (let index = 0; index < count; index++) {
            let node:cc.Node = new cc.Node();
            node.parent = this.node;
            let sp:cc.Sprite = node.addComponent(cc.Sprite);
            sp.spriteFrame = this._spriteFrame
            //let bound = this.node.getComponent(PhysicsBound);
            let x = (this.node.width  - 200) * (Math.random() - 0.5)  ;
            let y = (this.node.height - 180) * (Math.random() - 0.5) ;

            node.x = x ; node.y = y;
            node.scale = 0.2;
            
            let toX = 123 * (Math.random() - 0.5) ;
            let toY = 100 * (Math.random() - 0.5);
            node.runAction(cc.repeatForever(cc.sequence( cc.moveBy(Math.random() * 10,cc.v2(toX,toY)),cc.moveBy(Math.random() * 10,cc.v2(-toX,-toY)) )))
       }
       this._count = this._count + count;
       this.lbCount.getComponent(cc.Label).string = "总共:" + this._count;
    }
    

    start () {

    }

    onDestroy(){
        this._spriteFrame.decRef();
    }

    // update (dt) {}
}
