import Utils from "./Utils";

const {ccclass, property} = cc._decorator;


class clipData{
    public name; 
    public clip;
    public sound;
}

@ccclass
export default class SoundManager extends cc.Component {
    public static m_instance: SoundManager;    
    public constructor(){
        super();
        SoundManager.m_instance = this;
    }
    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    private soundList:clipData[] = [];

    start () {

    }

    playMusic(name:string){
        SoundManager.m_instance.stopAll();
        SoundManager.m_instance.play(name + ".mp3", true, 1);
    }
    playSound(name:string){ //消失
        this.play(name + ".mp3", false, 1);
    }
    // update (dt) {},
    play(name, loop, volume){
        if(loop == undefined){
            loop = false;
        }
        if(volume == undefined){
            volume = 1;
        }
        var sound = this.hasSound(name);
        if(sound){
            var res = cc.audioEngine.play(sound.clip, loop, volume);
            let obj:clipData = new clipData();
            obj.name = name; 
            obj.clip = res;
            obj.sound = res;
            this.soundList.push(obj);
            return;
        }
        var url = 'resources/sound/' + name;
        cc.loader.load(cc.url.raw(url), function(err, res){
            var sound = cc.audioEngine.play(res, loop, volume);
            let obj:clipData = new clipData();
            obj.name = name; 
            obj.clip = res;
            obj.sound = sound;
            this.soundList.push(obj);
        }.bind(this));
    }
    stopSound(name){
        for(var i = 0; i < this.soundList.length; i++){
            if(this.soundList[i].name == name){
                cc.audioEngine.stop(this.soundList[i].sound);
                break;
            }
        }
    }
    stopAll(){
        cc.audioEngine.stopAll();
    }
    hasSound(name){
        for(var i = 0; i < this.soundList.length; i++){
            if(this.soundList[i].name == name){
                return this.soundList[i];
            }
        }
        return null;
    }
    getIdx(name){
        for(var i = 0; i < this.soundList.length; i++){
            if(this.soundList[i].name == name){
                return i;
            }
        }
        return -1;
    }

    // update (dt) {}
}
