import SoundManager from "./SoundManager";

const {ccclass, property} = cc._decorator;
@ccclass
export default class Utils extends cc.Component {
    public static m_instance: Utils;    
    public constructor(){
        super();
        Utils.m_instance = this;
    }

    @property
    m_musicEnabled:boolean = true;
    
    @property
    m_soundEnabled:boolean = true;
    onLoad(){

    }
    onDisable(){
        // cc.director.getPhysicsManager().debugDrawFlags = 1;
    }
    start () {
        cc.game.addPersistRootNode(this.node); 
        cc.debug.setDisplayStats(false);
    }

    playKeySound(){
        this.playSound("key2");
    }
    playMusic(id:number){
        if(Utils.m_instance.m_musicEnabled){
            SoundManager.m_instance.playMusic("bjmusic");
        }
    }
    stopMusic(){
        SoundManager.m_instance.stopAll();
    }
    private m_playSountCount:number = 0;
    playSound(id:string){
        if(Utils.m_instance.m_musicEnabled){
            SoundManager.m_instance.playSound(id);
        }
    }
}
