import { _decorator, Component, Node, ColliderComponent, ICollisionEvent, RigidBodyComponent, Vec2, Vec3, CCFloat } from "cc";
const { ccclass, property } = _decorator;

@ccclass("Pai")
export class Pai extends Component {

    // @property ({type:CCFloat})

    private isStand = true;  
    private Imp = 20;  
    private paiInfo =null;


    public setInfo(info){
        this.paiInfo = info;
    }
 
    public start () {
        let Collider = this.getComponent(ColliderComponent);
        Collider.on('onCollisionEnter', this.onCollision, this);

        this.getComponent(RigidBodyComponent).sleep();
    }
    
    private onCollision (event: ICollisionEvent) {
        if(this.isStand && event.otherCollider.node.name !='desk'){
            
            this.isStand = false;

            let posOther = new Vec2(event.otherCollider.node.getPosition().x,event.otherCollider.node.getPosition().z);
            let posSelf = new Vec2(event.selfCollider.node.getPosition().x,event.selfCollider.node.getPosition().z);
            posSelf.subtract(posOther);
            let ang = posSelf.angle(new Vec2(0,10));      
            
            let imp = new Vec3(Math.sin(ang)*this.Imp,0,Math.cos(ang)*this.Imp);
            // console.log(`坐标：(${posSelf}----${posOther})，计算：方向(${posSelf}),角度(${ang}),力(${imp})`);
            this.getComponent(RigidBodyComponent).applyImpulse(imp)


            this.node.emit('fall',this.paiInfo);
        }
    }

}
