import { _decorator, Component, Node, systemEvent, SystemEvent, Prefab, RigidBodyComponent,PhysicsSystem, Vec3, CCFloat, director, find, color, instantiate, quat, Quat, loader, LabelComponent } from "cc";
import { dangBan } from "./dangBan";
import { dangZhu } from "./dangZhu";
import { boom } from "./boom";
import { Pai } from "./Pai";
const { ccclass, property } = _decorator;

// GameManager 游戏管理类

@ccclass("gm")
export class gm extends Component {

    @property({type:Node})
    public uiCan:Node = null;  

    @property({type:Node})
    public ball:Node = null; 
    @property({type:Node})
    public layPais:Node = null; 
    @property({type:Prefab})
    public gupai:Prefab = null; 
   

    @property({type:CCFloat})
    public ballImp = 250  //球的发射冲量

    //游戏关卡相关数据
    private levelData = null;
    private paiNodes:Node[] = [];  
    private paiFallCount = 0; 
       
    start () {
        // PhysicsSystem.instance.enable = false;       

        var that = this;
        loader.loadResDir('levels', function (err, objects, urls) {
            window.LevelCfg = objects[0].json;
            that.loadLevelData();
        });

          
        systemEvent.on(SystemEvent.EventType.TOUCH_START,()=>{      
            // PhysicsSystem.instance.enable = true;       
         })

        
        systemEvent.on(SystemEvent.EventType.TOUCH_END,()=>{       
            this.fireBall();
         })

         this.ball.on('hit',this.OnBallHit,this);

    }

    fireBall(){
        this.ball.getComponent(RigidBodyComponent).applyImpulse(new Vec3(0,0,this.ballImp));
    }

    OnBallHit(eve){
        if(eve.name === 'DangZhu'){
            this.GameOver();
        }        
    }

 
    OnPaiFall(param){
        console.log('牌倒下 === ',param);        
        this.paiFallCount++;
        if(this.paiFallCount === this.paiNodes.length){
            this.scheduleOnce(this.GamePass,1.0)
        }
    }
    scheduleOnce(GamePass: () => void, arg1: number) {
        throw new Error("Method not implemented.");
    }

    GamePass(){
        console.log('游戏过关！！！');   
        window.levelIndex++;    

        this.uiCan.active = true;
        find('pass',this.uiCan).active = true;
        find('fail',this.uiCan).active = false;
        find('pass/tit',this.uiCan).getComponent(LabelComponent).string = `[ ${this.levelData.name} ]`;

    }

    GameOver(){
        this.uiCan.active = true;

        find('pass',this.uiCan).active = false;
        find('fail',this.uiCan).active = true;
    }
    
    btnClick(btn,param){
        if(param === 'regame'){
            director.loadScene('Domino',()=>{},()=>{});
        }
        else if(param === 'next'){
            director.loadScene('Domino',()=>{},()=>{});
        }

    }

    onDestroy(){
        systemEvent.off(SystemEvent.EventType.TOUCH_END);
    }

    loadLevelData(){
        if(window.levelIndex > window.LevelCfg.length-1){
            return;
        }
        this.paiNodes = [];
        this.levelData = window.LevelCfg[window.levelIndex];

        for (let p = 0; p < this.levelData.pais.length; p++) {
            if(this.levelData.pais[p][1] === 1){
                let pai:Node = instantiate(this.gupai);
                pai.setPosition(new Vec3(this.levelData.pais[p][2]*-1,1.35,this.levelData.pais[p][3]*-1));

                this.layPais.addChild(pai);

                this.paiNodes.push(pai);

                let paiCom:Pai = pai.getComponent('Pai');

                pai.on('fall',this.OnPaiFall,this);
            }
        }

    }

    



}

