"use strict";
cc._RF.push(module, 'a0304ch19ZKXIxxOKzA/oCO', 'draw');
// draw.js

"use strict";

cc.Class({
				extends: cc.Component,

				properties: {
								mainCanvas: cc.Node
				},

				// LIFE-CYCLE CALLBACKS:

				onLoad: function onLoad() {
								this.initPath();

								this.mainContext = this.mainCanvas.getComponent(cc.Graphics);
								this.mainContext.lineJoin = cc.Graphics.LineJoin.ROUND;
								this.mainContext.lineCap = cc.Graphics.LineCap.ROUND;
								this.mainContext.strokeColor = cc.color(0, 0, 0, 100);;
								this.mainContext.lineWidth = 60;
								this.mainContext.fillColor = cc.Color.WHITE;
								this.mainContext.fillRect(0, 0, 1080, 1440);

								//console.log(tmpPath)
								this.drawLine();
				},
				start: function start() {},


				// update (dt) {},

				drawLine: function drawLine() {
								var tmpPath = this.path;
								var p1 = tmpPath.points[0];
								var p2 = tmpPath.points[1];

								this.mainContext.moveTo(p1.x, p1.y);

								var len = tmpPath.points.length;

								for (var i = 1; i < len; i++) {
												var midPoint = this.midPointBtw(p1, p2);
												this.mainContext.quadraticCurveTo(p1.x, p1.y, midPoint.x, midPoint.y);

												p1 = tmpPath.points[i];
												p2 = tmpPath.points[i + 1];
								}

								this.mainContext.lineTo(p1.x, p1.y);
								this.mainContext.stroke();
				},
				midPointBtw: function midPointBtw(p1, p2) {
								return {
												x: (p2.x + p1.x) / 2,
												y: (p2.y + p1.y) / 2
								};
				},
				initPath: function initPath() {
								this.path = { "points": [{ "x": 360, "y": 879.84 }, { "x": 362.88, "y": 879.84 }, { "x": 385.92, "y": 879.84 }, { "x": 432, "y": 871.2 }, { "x": 480.96, "y": 853.92 }, { "x": 509.76, "y": 842.4 }, { "x": 532.8, "y": 830.88 }, { "x": 561.6, "y": 819.36 }, { "x": 576, "y": 813.6 }, { "x": 601.92, "y": 796.32 }, { "x": 622.08, "y": 793.44 }, { "x": 642.24, "y": 779.04 }, { "x": 662.4, "y": 761.76 }, { "x": 682.56, "y": 750.24 }, { "x": 705.6, "y": 732.96 }, { "x": 728.64, "y": 715.68 }, { "x": 745.92, "y": 698.4 }, { "x": 757.44, "y": 686.88 }, { "x": 768.96, "y": 675.36 }, { "x": 774.72, "y": 669.6 }, { "x": 780.48, "y": 658.08 }, { "x": 794.88, "y": 640.8 }, { "x": 803.52, "y": 623.52 }, { "x": 809.28, "y": 612 }, { "x": 815.04, "y": 600.48 }, { "x": 817.92, "y": 588.96 }, { "x": 820.8, "y": 580.32 }, { "x": 823.68, "y": 560.16 }, { "x": 826.56, "y": 545.76 }, { "x": 826.56, "y": 525.6 }, { "x": 826.56, "y": 508.32 }, { "x": 826.56, "y": 496.8 }, { "x": 826.56, "y": 485.28 }, { "x": 826.56, "y": 468 }, { "x": 826.56, "y": 453.6 }, { "x": 826.56, "y": 442.08 }, { "x": 826.56, "y": 430.56 }, { "x": 826.56, "y": 419.04 }, { "x": 820.8, "y": 401.76 }, { "x": 815.04, "y": 384.48 }, { "x": 812.16, "y": 370.08 }, { "x": 803.52, "y": 352.8 }, { "x": 794.88, "y": 335.52 }, { "x": 789.12, "y": 329.76 }, { "x": 780.48, "y": 318.24 }, { "x": 766.08, "y": 306.72 }, { "x": 760.32, "y": 300.96 }, { "x": 748.8, "y": 295.2 }, { "x": 737.28, "y": 289.44 }, { "x": 722.88, "y": 283.68 }, { "x": 711.36, "y": 277.92 }, { "x": 705.6, "y": 277.92 }, { "x": 694.08, "y": 272.16 }, { "x": 682.56, "y": 269.28 }, { "x": 671.04, "y": 266.4 }, { "x": 645.12, "y": 260.64 }, { "x": 622.08, "y": 260.64 }, { "x": 604.8, "y": 260.64 }, { "x": 593.28, "y": 260.64 }, { "x": 567.36, "y": 260.64 }, { "x": 529.92, "y": 260.64 }, { "x": 512.64, "y": 266.4 }, { "x": 495.36, "y": 272.16 }, { "x": 483.84, "y": 272.16 }, { "x": 469.44, "y": 277.92 }, { "x": 452.16, "y": 283.68 }, { "x": 437.76, "y": 289.44 }, { "x": 426.24, "y": 298.08 }, { "x": 414.72, "y": 306.72 }, { "x": 403.2, "y": 315.36 }, { "x": 397.44, "y": 321.12 }, { "x": 391.68, "y": 329.76 }, { "x": 377.28, "y": 349.92 }, { "x": 377.28, "y": 358.56 }, { "x": 374.4, "y": 370.08 }, { "x": 374.4, "y": 390.24 }, { "x": 374.4, "y": 396 }, { "x": 374.4, "y": 424.8 }, { "x": 374.4, "y": 444.96 }, { "x": 377.28, "y": 468 }, { "x": 385.92, "y": 493.92 }, { "x": 394.56, "y": 514.08 }, { "x": 406.08, "y": 540 }, { "x": 420.48, "y": 563.04 }, { "x": 434.88, "y": 583.2 }, { "x": 455.04, "y": 603.36 }, { "x": 469.44, "y": 623.52 }, { "x": 498.24, "y": 658.08 }, { "x": 504, "y": 660.96 }, { "x": 532.8, "y": 684 }, { "x": 541.44, "y": 689.76 }, { "x": 564.48, "y": 701.28 }, { "x": 593.28, "y": 712.8 }, { "x": 622.08, "y": 727.2 }, { "x": 650.88, "y": 738.72 }, { "x": 676.8, "y": 747.36 }, { "x": 705.6, "y": 753.12 }, { "x": 734.4, "y": 756 }, { "x": 757.44, "y": 758.88 }, { "x": 783.36, "y": 761.76 }, { "x": 794.88, "y": 761.76 }, { "x": 800.64, "y": 761.76 }, { "x": 809.28, "y": 761.76 }, { "x": 815.04, "y": 761.76 }, { "x": 823.68, "y": 761.76 }, { "x": 838.08, "y": 761.76 }, { "x": 846.72, "y": 758.88 }, { "x": 852.48, "y": 756 }, { "x": 866.88, "y": 750.24 }, { "x": 875.52, "y": 744.48 }, { "x": 887.04, "y": 738.72 }, { "x": 889.92, "y": 732.96 }, { "x": 892.8, "y": 730.08 }, { "x": 895.68, "y": 727.2 }, { "x": 901.44, "y": 721.44 }, { "x": 904.32, "y": 718.56 }, { "x": 904.32, "y": 715.68 }, { "x": 910.08, "y": 709.92 }, { "x": 915.84, "y": 698.4 }, { "x": 918.72, "y": 695.52 }, { "x": 918.72, "y": 686.88 }, { "x": 924.48, "y": 684 }, { "x": 927.36, "y": 672.48 }, { "x": 930.24, "y": 663.84 }, { "x": 930.24, "y": 658.08 }, { "x": 936, "y": 649.44 }, { "x": 936, "y": 646.56 }, { "x": 938.88, "y": 640.8 }, { "x": 938.88, "y": 632.16 }, { "x": 941.76, "y": 629.28 }, { "x": 941.76, "y": 620.64 }, { "x": 941.76, "y": 614.88 }, { "x": 941.76, "y": 612 }, { "x": 941.76, "y": 609.12 }, { "x": 941.76, "y": 606.24 }, { "x": 941.76, "y": 600.48 }, { "x": 941.76, "y": 597.6 }, { "x": 941.76, "y": 594.72 }, { "x": 941.76, "y": 588.96 }, { "x": 941.76, "y": 586.08 }, { "x": 941.76, "y": 583.2 }, { "x": 941.76, "y": 577.44 }, { "x": 941.76, "y": 574.56 }, { "x": 941.76, "y": 571.68 }, { "x": 936, "y": 568.8 }, { "x": 936, "y": 565.92 }, { "x": 936, "y": 560.16 }, { "x": 933.12, "y": 557.28 }, { "x": 933.12, "y": 554.4 }, { "x": 930.24, "y": 551.52 }, { "x": 927.36, "y": 548.64 }, { "x": 924.48, "y": 545.76 }, { "x": 921.6, "y": 542.88 }, { "x": 921.6, "y": 540 }, { "x": 918.72, "y": 540 }, { "x": 918.72, "y": 537.12 }, { "x": 912.96, "y": 534.24 }, { "x": 910.08, "y": 534.24 }, { "x": 910.08, "y": 531.36 }, { "x": 907.2, "y": 528.48 }, { "x": 901.44, "y": 525.6 }, { "x": 901.44, "y": 522.72 }, { "x": 898.56, "y": 522.72 }, { "x": 895.68, "y": 519.84 }, { "x": 887.04, "y": 516.96 }, { "x": 881.28, "y": 514.08 }, { "x": 875.52, "y": 514.08 }, { "x": 872.64, "y": 514.08 }, { "x": 872.64, "y": 511.2 }, { "x": 866.88, "y": 511.2 }, { "x": 858.24, "y": 508.32 }, { "x": 852.48, "y": 505.44 }, { "x": 843.84, "y": 502.56 }, { "x": 835.2, "y": 502.56 }, { "x": 823.68, "y": 499.68 }, { "x": 815.04, "y": 496.8 }, { "x": 806.4, "y": 496.8 }, { "x": 797.76, "y": 496.8 }, { "x": 789.12, "y": 496.8 }, { "x": 780.48, "y": 496.8 }, { "x": 771.84, "y": 491.04 }, { "x": 766.08, "y": 491.04 }, { "x": 754.56, "y": 488.16 }, { "x": 751.68, "y": 488.16 }, { "x": 743.04, "y": 488.16 }, { "x": 737.28, "y": 488.16 }, { "x": 731.52, "y": 488.16 }, { "x": 725.76, "y": 488.16 }, { "x": 722.88, "y": 488.16 }, { "x": 717.12, "y": 488.16 }, { "x": 714.24, "y": 488.16 }, { "x": 708.48, "y": 488.16 }, { "x": 705.6, "y": 488.16 }, { "x": 702.72, "y": 488.16 }, { "x": 699.84, "y": 488.16 }, { "x": 691.2, "y": 488.16 }, { "x": 688.32, "y": 488.16 }, { "x": 685.44, "y": 488.16 }, { "x": 682.56, "y": 488.16 }, { "x": 679.68, "y": 488.16 }, { "x": 676.8, "y": 488.16 }, { "x": 673.92, "y": 488.16 }] };
				}
});

cc._RF.pop();