window.audioMgr = window.audioMgr || {extends: cc.Component};

let _effectVolume = 1;  //音效音量 0 ~ 1
let _musicVolume = 1;  //音乐音量 0 ~ 1
let _isOpenEffect = true;
let _isOpenMusic = true;
let _invaliAudioId = -1000;
let _musicId = _invaliAudioId;
let _effectIdList = [];
let _musicClip = null;
let dataLogic  = { isHide: false};
cc.game.on(cc.game.EVENT_HIDE, ()=>{
    _isOpenMusic && audioMgr.stopMusic();
});

cc.game.on(cc.game.EVENT_SHOW, ()=>{
    _isOpenMusic && audioMgr.setMusicSwitch(_isOpenMusic);
});

audioMgr.init = function () {
    let info = cc.sys.localStorage.getItem("game_pokerGameAudioInfo");
    // cc.log("pokerGameAudioInfo", info);
    if(null != info){
        let audio = JSON.parse(info);
        cc.audioEngine.setEffectsVolume(audio.effectVolume);
        cc.audioEngine.setMusicVolume(audio.musicVolume);
        _effectVolume = audio.effectVolume;
        _musicVolume = audio.musicVolume;
        _isOpenEffect = audio.isOpenEffect;
        _isOpenMusic = audio.isOpenMusic;
    }
};

audioMgr.localStorageData = function () {
    let info = {
        // effectVolume : _effectVolume,
        // musicVolume : _musicVolume,
        effectVolume : cc.audioEngine.getEffectsVolume(),
        musicVolume : cc.audioEngine.getMusicVolume(),
        isOpenEffect : _isOpenEffect,
        isOpenMusic : _isOpenMusic,
    };
    cc.sys.localStorage.setItem("game_pokerGameAudioInfo", JSON.stringify(info));
};

audioMgr.getCurMusicClipUuid = function () {
    if(null == _musicClip) return null;
    return _musicClip._uuid;
};

/************************音效******************************/

audioMgr.setEffectSwitch = function(isOpen){
    //cc.log("设置音效开关", isOpen);
    _isOpenEffect = isOpen;
    isOpen || this.stopAllEffect();
};

audioMgr.getEffectSwitch = function(){
    //cc.log("设置音效开关", isOpen);
    return _isOpenEffect;
};

audioMgr.setEffectVolume = function(volume){
    cc.audioEngine.setEffectsVolume(volume);
    /*let id, state;
    for (let key in _effectIdList) {
        id = _effectIdList[key];
        if (id === _musicId) {
            cc.log("----id和背景音乐id冲突");
            continue;
        }
        state = cc.audioEngine.getState(id);
        if (state === cc.audioEngine.AudioState.PLAYING) {
            cc.audioEngine.setVolume(id, volume);
        }
    }
    _effectVolume = volume;*/
};

audioMgr.getEffectVolume = function(){
    // return _effectVolume;
    return cc.audioEngine.getEffectsVolume();
};

audioMgr.playEffect = function(audioClip, isLoop = false){
    if(dataLogic.isHide) return;
    if (_isOpenEffect){
        return cc.audioEngine.playEffect(audioClip, isLoop);
        // let id = cc.audioEngine.play(audioClip, isLoop, _effectVolume);
        // _effectIdList.push(id);
        // return id;
    }else {
        return;
    }
};

audioMgr.stopEffect = function(audioId){
    // let state = cc.audioEngine.getState(audioId);
    // if (state === cc.audioEngine.AudioState.PLAYING) {
    // 	cc.audioEngine.stop(audioId);
    // }
    cc.audioEngine.stopEffect(audioId);
};

audioMgr.stopAllEffect = function(){
    cc.audioEngine.stopAllEffects();
    /*let state, id;
    for (let key in _effectIdList) {
        id = _effectIdList[key];
        if (id === _musicId) {
            cc.log("----id和背景音乐id冲突");
            continue;
        }
        state = cc.audioEngine.getState(id);
        if (state === cc.audioEngine.AudioState.PLAYING) {
            cc.audioEngine.stop(id);
        }
    }
    _effectIdList = [];*/
};


/************************音乐******************************/

audioMgr.setMusicSwitch = function(isOpen){
    // cc.log("设置音乐开关", isOpen, _musicClip);
    _isOpenMusic = isOpen;
    if(isOpen){
        _musicClip && this.playMusic(_musicClip);
    }else {
        this.stopMusic();
        _musicId = _invaliAudioId;
    }
};

audioMgr.getMusicSwitch = function(){
    //cc.log("设置音乐开关", isOpen);
    return _isOpenMusic;
};

audioMgr.setMusicVolume = function(volume){
    cc.log("设置音乐音量", volume);
    // _musicVolume = volume;
    // cc.audioEngine.setVolume(_musicId, volume);
    cc.audioEngine.setMusicVolume(volume);
};

audioMgr.getMusicVolume = function(){
    return cc.audioEngine.getMusicVolume();
};

audioMgr.playMusic = function(audioClip, isLoop = true){
    cc.log("播放音乐", _isOpenMusic, dataLogic.isHide);
    // if(dataLogic.isHide) return;
    if(_isOpenMusic) {
        // cc.audioEngine.stop(_musicId);
        // let v = cc.audioEngine.getMusicVolume();
        // cc.audioEngine.setMusicVolume(0);
        _musicId = cc.audioEngine.playMusic(audioClip, isLoop);
        // cc.audioEngine.setMusicVolume(v);
        // cc.log("_musicId", _musicId);
        return _musicId;
    }
};

audioMgr.stopMusic = function(){
    //isMusicPlaying
    cc.log("停止音乐");
    cc.audioEngine.stopMusic();
    // cc.audioEngine.stop(_musicId);
};

audioMgr.setMusicClip = function(clip){
    _musicClip = clip;
};

audioMgr.init();
