import * as $protobuf from "protobufjs";

/** Namespace pb. */
export namespace pb {

    /** ValType enum. */
    enum ValType {
        int = 0,
        float = 1,
        bool = 2,
        string = 3,
        ints = 4
    }

    /** Properties of an Excel. */
    interface IExcel {

        /** Excel sheetDic */
        sheetDic?: { [k: string]: pb.ISheet };
    }

    /** Represents an Excel. */
    class Excel {

        /**
         * Constructs a new Excel.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IExcel);

        /** Excel sheetDic. */
        public sheetDic: { [k: string]: pb.ISheet };

        /**
         * Creates a new Excel instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Excel instance
         */
        public static create(properties?: pb.IExcel): pb.Excel;

        /**
         * Encodes the specified Excel message. Does not implicitly {@link pb.Excel.verify|verify} messages.
         * @param message Excel message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IExcel, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified Excel message, length delimited. Does not implicitly {@link pb.Excel.verify|verify} messages.
         * @param message Excel message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IExcel, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an Excel message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Excel
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.Excel;

        /**
         * Decodes an Excel message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Excel
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.Excel;

        /**
         * Verifies an Excel message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an Excel message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Excel
         */
        public static fromObject(object: { [k: string]: any }): pb.Excel;

        /**
         * Creates a plain object from an Excel message. Also converts values to other types if specified.
         * @param message Excel
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.Excel, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Excel to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a Sheet. */
    interface ISheet {

        /** Sheet tagDic */
        tagDic?: { [k: string]: number };

        /** Sheet tags */
        tags?: pb.ITag[];

        /** Sheet rowDic */
        rowDic?: { [k: string]: pb.IRow };
    }

    /** Represents a Sheet. */
    class Sheet {

        /**
         * Constructs a new Sheet.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ISheet);

        /** Sheet tagDic. */
        public tagDic: { [k: string]: number };

        /** Sheet tags. */
        public tags: pb.ITag[];

        /** Sheet rowDic. */
        public rowDic: { [k: string]: pb.IRow };

        /**
         * Creates a new Sheet instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Sheet instance
         */
        public static create(properties?: pb.ISheet): pb.Sheet;

        /**
         * Encodes the specified Sheet message. Does not implicitly {@link pb.Sheet.verify|verify} messages.
         * @param message Sheet message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ISheet, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified Sheet message, length delimited. Does not implicitly {@link pb.Sheet.verify|verify} messages.
         * @param message Sheet message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ISheet, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a Sheet message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Sheet
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.Sheet;

        /**
         * Decodes a Sheet message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Sheet
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.Sheet;

        /**
         * Verifies a Sheet message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a Sheet message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Sheet
         */
        public static fromObject(object: { [k: string]: any }): pb.Sheet;

        /**
         * Creates a plain object from a Sheet message. Also converts values to other types if specified.
         * @param message Sheet
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.Sheet, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Sheet to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a Tag. */
    interface ITag {

        /** Tag type */
        type?: pb.ValType;

        /** Tag yinyong */
        yinyong?: string;
    }

    /** Represents a Tag. */
    class Tag {

        /**
         * Constructs a new Tag.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ITag);

        /** Tag type. */
        public type: pb.ValType;

        /** Tag yinyong. */
        public yinyong: string;

        /**
         * Creates a new Tag instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Tag instance
         */
        public static create(properties?: pb.ITag): pb.Tag;

        /**
         * Encodes the specified Tag message. Does not implicitly {@link pb.Tag.verify|verify} messages.
         * @param message Tag message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ITag, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified Tag message, length delimited. Does not implicitly {@link pb.Tag.verify|verify} messages.
         * @param message Tag message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ITag, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a Tag message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Tag
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.Tag;

        /**
         * Decodes a Tag message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Tag
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.Tag;

        /**
         * Verifies a Tag message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a Tag message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Tag
         */
        public static fromObject(object: { [k: string]: any }): pb.Tag;

        /**
         * Creates a plain object from a Tag message. Also converts values to other types if specified.
         * @param message Tag
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.Tag, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Tag to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a Row. */
    interface IRow {

        /** Row cellDic */
        cellDic?: { [k: string]: number };

        /** Row cells */
        cells?: pb.ICell[];
    }

    /** Represents a Row. */
    class Row {

        /**
         * Constructs a new Row.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IRow);

        /** Row cellDic. */
        public cellDic: { [k: string]: number };

        /** Row cells. */
        public cells: pb.ICell[];

        /**
         * Creates a new Row instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Row instance
         */
        public static create(properties?: pb.IRow): pb.Row;

        /**
         * Encodes the specified Row message. Does not implicitly {@link pb.Row.verify|verify} messages.
         * @param message Row message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IRow, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified Row message, length delimited. Does not implicitly {@link pb.Row.verify|verify} messages.
         * @param message Row message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IRow, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a Row message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Row
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.Row;

        /**
         * Decodes a Row message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Row
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.Row;

        /**
         * Verifies a Row message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a Row message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Row
         */
        public static fromObject(object: { [k: string]: any }): pb.Row;

        /**
         * Creates a plain object from a Row message. Also converts values to other types if specified.
         * @param message Row
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.Row, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Row to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a Cell. */
    interface ICell {

        /** Cell tag */
        tag?: pb.ITag;

        /** Cell valInt */
        valInt?: number;

        /** Cell valBool */
        valBool?: boolean;

        /** Cell valFloat */
        valFloat?: number;

        /** Cell valString */
        valString?: string;

        /** Cell valInts */
        valInts?: number[];
    }

    /** Represents a Cell. */
    class Cell {

        /**
         * Constructs a new Cell.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ICell);

        /** Cell tag. */
        public tag?: (pb.ITag|null);

        /** Cell valInt. */
        public valInt: number;

        /** Cell valBool. */
        public valBool: boolean;

        /** Cell valFloat. */
        public valFloat: number;

        /** Cell valString. */
        public valString: string;

        /** Cell valInts. */
        public valInts: number[];

        /**
         * Creates a new Cell instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Cell instance
         */
        public static create(properties?: pb.ICell): pb.Cell;

        /**
         * Encodes the specified Cell message. Does not implicitly {@link pb.Cell.verify|verify} messages.
         * @param message Cell message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ICell, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified Cell message, length delimited. Does not implicitly {@link pb.Cell.verify|verify} messages.
         * @param message Cell message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ICell, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a Cell message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Cell
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.Cell;

        /**
         * Decodes a Cell message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Cell
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.Cell;

        /**
         * Verifies a Cell message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a Cell message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Cell
         */
        public static fromObject(object: { [k: string]: any }): pb.Cell;

        /**
         * Creates a plain object from a Cell message. Also converts values to other types if specified.
         * @param message Cell
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.Cell, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Cell to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ResultRes. */
    interface IResultRes {

        /** ResultRes desc */
        desc?: string;
    }

    /** Represents a ResultRes. */
    class ResultRes {

        /**
         * Constructs a new ResultRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IResultRes);

        /** ResultRes desc. */
        public desc: string;

        /**
         * Creates a new ResultRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ResultRes instance
         */
        public static create(properties?: pb.IResultRes): pb.ResultRes;

        /**
         * Encodes the specified ResultRes message. Does not implicitly {@link pb.ResultRes.verify|verify} messages.
         * @param message ResultRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IResultRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ResultRes message, length delimited. Does not implicitly {@link pb.ResultRes.verify|verify} messages.
         * @param message ResultRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IResultRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ResultRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ResultRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.ResultRes;

        /**
         * Decodes a ResultRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ResultRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.ResultRes;

        /**
         * Verifies a ResultRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ResultRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ResultRes
         */
        public static fromObject(object: { [k: string]: any }): pb.ResultRes;

        /**
         * Creates a plain object from a ResultRes message. Also converts values to other types if specified.
         * @param message ResultRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.ResultRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ResultRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a RenWuRes. */
    interface IRenWuRes {
    }

    /** Represents a RenWuRes. */
    class RenWuRes {

        /**
         * Constructs a new RenWuRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IRenWuRes);

        /**
         * Creates a new RenWuRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns RenWuRes instance
         */
        public static create(properties?: pb.IRenWuRes): pb.RenWuRes;

        /**
         * Encodes the specified RenWuRes message. Does not implicitly {@link pb.RenWuRes.verify|verify} messages.
         * @param message RenWuRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IRenWuRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified RenWuRes message, length delimited. Does not implicitly {@link pb.RenWuRes.verify|verify} messages.
         * @param message RenWuRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IRenWuRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a RenWuRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns RenWuRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.RenWuRes;

        /**
         * Decodes a RenWuRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns RenWuRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.RenWuRes;

        /**
         * Verifies a RenWuRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a RenWuRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns RenWuRes
         */
        public static fromObject(object: { [k: string]: any }): pb.RenWuRes;

        /**
         * Creates a plain object from a RenWuRes message. Also converts values to other types if specified.
         * @param message RenWuRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.RenWuRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this RenWuRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a DuiHhuanAsk. */
    interface IDuiHhuanAsk {

        /** DuiHhuanAsk code */
        code?: number;
    }

    /** Represents a DuiHhuanAsk. */
    class DuiHhuanAsk {

        /**
         * Constructs a new DuiHhuanAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IDuiHhuanAsk);

        /** DuiHhuanAsk code. */
        public code: number;

        /**
         * Creates a new DuiHhuanAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns DuiHhuanAsk instance
         */
        public static create(properties?: pb.IDuiHhuanAsk): pb.DuiHhuanAsk;

        /**
         * Encodes the specified DuiHhuanAsk message. Does not implicitly {@link pb.DuiHhuanAsk.verify|verify} messages.
         * @param message DuiHhuanAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IDuiHhuanAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified DuiHhuanAsk message, length delimited. Does not implicitly {@link pb.DuiHhuanAsk.verify|verify} messages.
         * @param message DuiHhuanAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IDuiHhuanAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a DuiHhuanAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns DuiHhuanAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.DuiHhuanAsk;

        /**
         * Decodes a DuiHhuanAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns DuiHhuanAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.DuiHhuanAsk;

        /**
         * Verifies a DuiHhuanAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a DuiHhuanAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns DuiHhuanAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.DuiHhuanAsk;

        /**
         * Creates a plain object from a DuiHhuanAsk message. Also converts values to other types if specified.
         * @param message DuiHhuanAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.DuiHhuanAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this DuiHhuanAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a DuiHhuanRes. */
    interface IDuiHhuanRes {

        /** DuiHhuanRes res */
        res?: number;
    }

    /** Represents a DuiHhuanRes. */
    class DuiHhuanRes {

        /**
         * Constructs a new DuiHhuanRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IDuiHhuanRes);

        /** DuiHhuanRes res. */
        public res: number;

        /**
         * Creates a new DuiHhuanRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns DuiHhuanRes instance
         */
        public static create(properties?: pb.IDuiHhuanRes): pb.DuiHhuanRes;

        /**
         * Encodes the specified DuiHhuanRes message. Does not implicitly {@link pb.DuiHhuanRes.verify|verify} messages.
         * @param message DuiHhuanRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IDuiHhuanRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified DuiHhuanRes message, length delimited. Does not implicitly {@link pb.DuiHhuanRes.verify|verify} messages.
         * @param message DuiHhuanRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IDuiHhuanRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a DuiHhuanRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns DuiHhuanRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.DuiHhuanRes;

        /**
         * Decodes a DuiHhuanRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns DuiHhuanRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.DuiHhuanRes;

        /**
         * Verifies a DuiHhuanRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a DuiHhuanRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns DuiHhuanRes
         */
        public static fromObject(object: { [k: string]: any }): pb.DuiHhuanRes;

        /**
         * Creates a plain object from a DuiHhuanRes message. Also converts values to other types if specified.
         * @param message DuiHhuanRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.DuiHhuanRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this DuiHhuanRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a DelMailAsk. */
    interface IDelMailAsk {

        /** DelMailAsk tpe */
        tpe?: number;

        /** DelMailAsk idx */
        idx?: number;
    }

    /** Represents a DelMailAsk. */
    class DelMailAsk {

        /**
         * Constructs a new DelMailAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IDelMailAsk);

        /** DelMailAsk tpe. */
        public tpe: number;

        /** DelMailAsk idx. */
        public idx: number;

        /**
         * Creates a new DelMailAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns DelMailAsk instance
         */
        public static create(properties?: pb.IDelMailAsk): pb.DelMailAsk;

        /**
         * Encodes the specified DelMailAsk message. Does not implicitly {@link pb.DelMailAsk.verify|verify} messages.
         * @param message DelMailAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IDelMailAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified DelMailAsk message, length delimited. Does not implicitly {@link pb.DelMailAsk.verify|verify} messages.
         * @param message DelMailAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IDelMailAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a DelMailAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns DelMailAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.DelMailAsk;

        /**
         * Decodes a DelMailAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns DelMailAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.DelMailAsk;

        /**
         * Verifies a DelMailAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a DelMailAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns DelMailAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.DelMailAsk;

        /**
         * Creates a plain object from a DelMailAsk message. Also converts values to other types if specified.
         * @param message DelMailAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.DelMailAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this DelMailAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a FightAsk. */
    interface IFightAsk {

        /** FightAsk tpe */
        tpe?: number;

        /** FightAsk idx */
        idx?: number;
    }

    /** Represents a FightAsk. */
    class FightAsk {

        /**
         * Constructs a new FightAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IFightAsk);

        /** FightAsk tpe. */
        public tpe: number;

        /** FightAsk idx. */
        public idx: number;

        /**
         * Creates a new FightAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns FightAsk instance
         */
        public static create(properties?: pb.IFightAsk): pb.FightAsk;

        /**
         * Encodes the specified FightAsk message. Does not implicitly {@link pb.FightAsk.verify|verify} messages.
         * @param message FightAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IFightAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified FightAsk message, length delimited. Does not implicitly {@link pb.FightAsk.verify|verify} messages.
         * @param message FightAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IFightAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a FightAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns FightAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.FightAsk;

        /**
         * Decodes a FightAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns FightAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.FightAsk;

        /**
         * Verifies a FightAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a FightAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns FightAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.FightAsk;

        /**
         * Creates a plain object from a FightAsk message. Also converts values to other types if specified.
         * @param message FightAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.FightAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this FightAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a FightRes. */
    interface IFightRes {

        /** FightRes ste */
        ste?: number;
    }

    /** Represents a FightRes. */
    class FightRes {

        /**
         * Constructs a new FightRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IFightRes);

        /** FightRes ste. */
        public ste: number;

        /**
         * Creates a new FightRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns FightRes instance
         */
        public static create(properties?: pb.IFightRes): pb.FightRes;

        /**
         * Encodes the specified FightRes message. Does not implicitly {@link pb.FightRes.verify|verify} messages.
         * @param message FightRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IFightRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified FightRes message, length delimited. Does not implicitly {@link pb.FightRes.verify|verify} messages.
         * @param message FightRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IFightRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a FightRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns FightRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.FightRes;

        /**
         * Decodes a FightRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns FightRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.FightRes;

        /**
         * Verifies a FightRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a FightRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns FightRes
         */
        public static fromObject(object: { [k: string]: any }): pb.FightRes;

        /**
         * Creates a plain object from a FightRes message. Also converts values to other types if specified.
         * @param message FightRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.FightRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this FightRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a FightReadyAsk. */
    interface IFightReadyAsk {
    }

    /** Represents a FightReadyAsk. */
    class FightReadyAsk {

        /**
         * Constructs a new FightReadyAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IFightReadyAsk);

        /**
         * Creates a new FightReadyAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns FightReadyAsk instance
         */
        public static create(properties?: pb.IFightReadyAsk): pb.FightReadyAsk;

        /**
         * Encodes the specified FightReadyAsk message. Does not implicitly {@link pb.FightReadyAsk.verify|verify} messages.
         * @param message FightReadyAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IFightReadyAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified FightReadyAsk message, length delimited. Does not implicitly {@link pb.FightReadyAsk.verify|verify} messages.
         * @param message FightReadyAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IFightReadyAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a FightReadyAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns FightReadyAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.FightReadyAsk;

        /**
         * Decodes a FightReadyAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns FightReadyAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.FightReadyAsk;

        /**
         * Verifies a FightReadyAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a FightReadyAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns FightReadyAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.FightReadyAsk;

        /**
         * Creates a plain object from a FightReadyAsk message. Also converts values to other types if specified.
         * @param message FightReadyAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.FightReadyAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this FightReadyAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a FightReadyRes. */
    interface IFightReadyRes {
    }

    /** Represents a FightReadyRes. */
    class FightReadyRes {

        /**
         * Constructs a new FightReadyRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IFightReadyRes);

        /**
         * Creates a new FightReadyRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns FightReadyRes instance
         */
        public static create(properties?: pb.IFightReadyRes): pb.FightReadyRes;

        /**
         * Encodes the specified FightReadyRes message. Does not implicitly {@link pb.FightReadyRes.verify|verify} messages.
         * @param message FightReadyRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IFightReadyRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified FightReadyRes message, length delimited. Does not implicitly {@link pb.FightReadyRes.verify|verify} messages.
         * @param message FightReadyRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IFightReadyRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a FightReadyRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns FightReadyRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.FightReadyRes;

        /**
         * Decodes a FightReadyRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns FightReadyRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.FightReadyRes;

        /**
         * Verifies a FightReadyRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a FightReadyRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns FightReadyRes
         */
        public static fromObject(object: { [k: string]: any }): pb.FightReadyRes;

        /**
         * Creates a plain object from a FightReadyRes message. Also converts values to other types if specified.
         * @param message FightReadyRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.FightReadyRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this FightReadyRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a FightLockAsk. */
    interface IFightLockAsk {
    }

    /** Represents a FightLockAsk. */
    class FightLockAsk {

        /**
         * Constructs a new FightLockAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IFightLockAsk);

        /**
         * Creates a new FightLockAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns FightLockAsk instance
         */
        public static create(properties?: pb.IFightLockAsk): pb.FightLockAsk;

        /**
         * Encodes the specified FightLockAsk message. Does not implicitly {@link pb.FightLockAsk.verify|verify} messages.
         * @param message FightLockAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IFightLockAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified FightLockAsk message, length delimited. Does not implicitly {@link pb.FightLockAsk.verify|verify} messages.
         * @param message FightLockAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IFightLockAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a FightLockAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns FightLockAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.FightLockAsk;

        /**
         * Decodes a FightLockAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns FightLockAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.FightLockAsk;

        /**
         * Verifies a FightLockAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a FightLockAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns FightLockAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.FightLockAsk;

        /**
         * Creates a plain object from a FightLockAsk message. Also converts values to other types if specified.
         * @param message FightLockAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.FightLockAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this FightLockAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a FightLockRes. */
    interface IFightLockRes {
    }

    /** Represents a FightLockRes. */
    class FightLockRes {

        /**
         * Constructs a new FightLockRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IFightLockRes);

        /**
         * Creates a new FightLockRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns FightLockRes instance
         */
        public static create(properties?: pb.IFightLockRes): pb.FightLockRes;

        /**
         * Encodes the specified FightLockRes message. Does not implicitly {@link pb.FightLockRes.verify|verify} messages.
         * @param message FightLockRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IFightLockRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified FightLockRes message, length delimited. Does not implicitly {@link pb.FightLockRes.verify|verify} messages.
         * @param message FightLockRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IFightLockRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a FightLockRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns FightLockRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.FightLockRes;

        /**
         * Decodes a FightLockRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns FightLockRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.FightLockRes;

        /**
         * Verifies a FightLockRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a FightLockRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns FightLockRes
         */
        public static fromObject(object: { [k: string]: any }): pb.FightLockRes;

        /**
         * Creates a plain object from a FightLockRes message. Also converts values to other types if specified.
         * @param message FightLockRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.FightLockRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this FightLockRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a FightWinRes. */
    interface IFightWinRes {

        /** FightWinRes pro */
        pro?: pb.IProperty;
    }

    /** Represents a FightWinRes. */
    class FightWinRes {

        /**
         * Constructs a new FightWinRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IFightWinRes);

        /** FightWinRes pro. */
        public pro?: (pb.IProperty|null);

        /**
         * Creates a new FightWinRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns FightWinRes instance
         */
        public static create(properties?: pb.IFightWinRes): pb.FightWinRes;

        /**
         * Encodes the specified FightWinRes message. Does not implicitly {@link pb.FightWinRes.verify|verify} messages.
         * @param message FightWinRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IFightWinRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified FightWinRes message, length delimited. Does not implicitly {@link pb.FightWinRes.verify|verify} messages.
         * @param message FightWinRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IFightWinRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a FightWinRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns FightWinRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.FightWinRes;

        /**
         * Decodes a FightWinRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns FightWinRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.FightWinRes;

        /**
         * Verifies a FightWinRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a FightWinRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns FightWinRes
         */
        public static fromObject(object: { [k: string]: any }): pb.FightWinRes;

        /**
         * Creates a plain object from a FightWinRes message. Also converts values to other types if specified.
         * @param message FightWinRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.FightWinRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this FightWinRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a FightFailRes. */
    interface IFightFailRes {
    }

    /** Represents a FightFailRes. */
    class FightFailRes {

        /**
         * Constructs a new FightFailRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IFightFailRes);

        /**
         * Creates a new FightFailRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns FightFailRes instance
         */
        public static create(properties?: pb.IFightFailRes): pb.FightFailRes;

        /**
         * Encodes the specified FightFailRes message. Does not implicitly {@link pb.FightFailRes.verify|verify} messages.
         * @param message FightFailRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IFightFailRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified FightFailRes message, length delimited. Does not implicitly {@link pb.FightFailRes.verify|verify} messages.
         * @param message FightFailRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IFightFailRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a FightFailRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns FightFailRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.FightFailRes;

        /**
         * Decodes a FightFailRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns FightFailRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.FightFailRes;

        /**
         * Verifies a FightFailRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a FightFailRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns FightFailRes
         */
        public static fromObject(object: { [k: string]: any }): pb.FightFailRes;

        /**
         * Creates a plain object from a FightFailRes message. Also converts values to other types if specified.
         * @param message FightFailRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.FightFailRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this FightFailRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TipRes. */
    interface ITipRes {

        /** TipRes pro */
        pro?: pb.IProperty;
    }

    /** Represents a TipRes. */
    class TipRes {

        /**
         * Constructs a new TipRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ITipRes);

        /** TipRes pro. */
        public pro?: (pb.IProperty|null);

        /**
         * Creates a new TipRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TipRes instance
         */
        public static create(properties?: pb.ITipRes): pb.TipRes;

        /**
         * Encodes the specified TipRes message. Does not implicitly {@link pb.TipRes.verify|verify} messages.
         * @param message TipRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ITipRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TipRes message, length delimited. Does not implicitly {@link pb.TipRes.verify|verify} messages.
         * @param message TipRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ITipRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TipRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TipRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.TipRes;

        /**
         * Decodes a TipRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TipRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.TipRes;

        /**
         * Verifies a TipRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TipRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TipRes
         */
        public static fromObject(object: { [k: string]: any }): pb.TipRes;

        /**
         * Creates a plain object from a TipRes message. Also converts values to other types if specified.
         * @param message TipRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.TipRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TipRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ReceiveRewardAsk. */
    interface IReceiveRewardAsk {

        /** ReceiveRewardAsk tpe */
        tpe?: number;

        /** ReceiveRewardAsk idx */
        idx?: number;
    }

    /** Represents a ReceiveRewardAsk. */
    class ReceiveRewardAsk {

        /**
         * Constructs a new ReceiveRewardAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IReceiveRewardAsk);

        /** ReceiveRewardAsk tpe. */
        public tpe: number;

        /** ReceiveRewardAsk idx. */
        public idx: number;

        /**
         * Creates a new ReceiveRewardAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ReceiveRewardAsk instance
         */
        public static create(properties?: pb.IReceiveRewardAsk): pb.ReceiveRewardAsk;

        /**
         * Encodes the specified ReceiveRewardAsk message. Does not implicitly {@link pb.ReceiveRewardAsk.verify|verify} messages.
         * @param message ReceiveRewardAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IReceiveRewardAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ReceiveRewardAsk message, length delimited. Does not implicitly {@link pb.ReceiveRewardAsk.verify|verify} messages.
         * @param message ReceiveRewardAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IReceiveRewardAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ReceiveRewardAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ReceiveRewardAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.ReceiveRewardAsk;

        /**
         * Decodes a ReceiveRewardAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ReceiveRewardAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.ReceiveRewardAsk;

        /**
         * Verifies a ReceiveRewardAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ReceiveRewardAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ReceiveRewardAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.ReceiveRewardAsk;

        /**
         * Creates a plain object from a ReceiveRewardAsk message. Also converts values to other types if specified.
         * @param message ReceiveRewardAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.ReceiveRewardAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ReceiveRewardAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ReceiveRewardRes. */
    interface IReceiveRewardRes {

        /** ReceiveRewardRes pro */
        pro?: pb.IProperty;
    }

    /** Represents a ReceiveRewardRes. */
    class ReceiveRewardRes {

        /**
         * Constructs a new ReceiveRewardRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IReceiveRewardRes);

        /** ReceiveRewardRes pro. */
        public pro?: (pb.IProperty|null);

        /**
         * Creates a new ReceiveRewardRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ReceiveRewardRes instance
         */
        public static create(properties?: pb.IReceiveRewardRes): pb.ReceiveRewardRes;

        /**
         * Encodes the specified ReceiveRewardRes message. Does not implicitly {@link pb.ReceiveRewardRes.verify|verify} messages.
         * @param message ReceiveRewardRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IReceiveRewardRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ReceiveRewardRes message, length delimited. Does not implicitly {@link pb.ReceiveRewardRes.verify|verify} messages.
         * @param message ReceiveRewardRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IReceiveRewardRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ReceiveRewardRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ReceiveRewardRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.ReceiveRewardRes;

        /**
         * Decodes a ReceiveRewardRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ReceiveRewardRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.ReceiveRewardRes;

        /**
         * Verifies a ReceiveRewardRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ReceiveRewardRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ReceiveRewardRes
         */
        public static fromObject(object: { [k: string]: any }): pb.ReceiveRewardRes;

        /**
         * Creates a plain object from a ReceiveRewardRes message. Also converts values to other types if specified.
         * @param message ReceiveRewardRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.ReceiveRewardRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ReceiveRewardRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a QueryAsk. */
    interface IQueryAsk {

        /** QueryAsk tpe */
        tpe?: number;
    }

    /** Represents a QueryAsk. */
    class QueryAsk {

        /**
         * Constructs a new QueryAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IQueryAsk);

        /** QueryAsk tpe. */
        public tpe: number;

        /**
         * Creates a new QueryAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns QueryAsk instance
         */
        public static create(properties?: pb.IQueryAsk): pb.QueryAsk;

        /**
         * Encodes the specified QueryAsk message. Does not implicitly {@link pb.QueryAsk.verify|verify} messages.
         * @param message QueryAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IQueryAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified QueryAsk message, length delimited. Does not implicitly {@link pb.QueryAsk.verify|verify} messages.
         * @param message QueryAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IQueryAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a QueryAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns QueryAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.QueryAsk;

        /**
         * Decodes a QueryAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns QueryAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.QueryAsk;

        /**
         * Verifies a QueryAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a QueryAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns QueryAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.QueryAsk;

        /**
         * Creates a plain object from a QueryAsk message. Also converts values to other types if specified.
         * @param message QueryAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.QueryAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this QueryAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a QueryRes. */
    interface IQueryRes {

        /** QueryRes tpe */
        tpe?: number;

        /** QueryRes pro */
        pro?: pb.IProperty;
    }

    /** Represents a QueryRes. */
    class QueryRes {

        /**
         * Constructs a new QueryRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IQueryRes);

        /** QueryRes tpe. */
        public tpe: number;

        /** QueryRes pro. */
        public pro?: (pb.IProperty|null);

        /**
         * Creates a new QueryRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns QueryRes instance
         */
        public static create(properties?: pb.IQueryRes): pb.QueryRes;

        /**
         * Encodes the specified QueryRes message. Does not implicitly {@link pb.QueryRes.verify|verify} messages.
         * @param message QueryRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IQueryRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified QueryRes message, length delimited. Does not implicitly {@link pb.QueryRes.verify|verify} messages.
         * @param message QueryRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IQueryRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a QueryRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns QueryRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.QueryRes;

        /**
         * Decodes a QueryRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns QueryRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.QueryRes;

        /**
         * Verifies a QueryRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a QueryRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns QueryRes
         */
        public static fromObject(object: { [k: string]: any }): pb.QueryRes;

        /**
         * Creates a plain object from a QueryRes message. Also converts values to other types if specified.
         * @param message QueryRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.QueryRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this QueryRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a QueryFightAsk. */
    interface IQueryFightAsk {

        /** QueryFightAsk id */
        id?: string;
    }

    /** Represents a QueryFightAsk. */
    class QueryFightAsk {

        /**
         * Constructs a new QueryFightAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IQueryFightAsk);

        /** QueryFightAsk id. */
        public id: string;

        /**
         * Creates a new QueryFightAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns QueryFightAsk instance
         */
        public static create(properties?: pb.IQueryFightAsk): pb.QueryFightAsk;

        /**
         * Encodes the specified QueryFightAsk message. Does not implicitly {@link pb.QueryFightAsk.verify|verify} messages.
         * @param message QueryFightAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IQueryFightAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified QueryFightAsk message, length delimited. Does not implicitly {@link pb.QueryFightAsk.verify|verify} messages.
         * @param message QueryFightAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IQueryFightAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a QueryFightAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns QueryFightAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.QueryFightAsk;

        /**
         * Decodes a QueryFightAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns QueryFightAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.QueryFightAsk;

        /**
         * Verifies a QueryFightAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a QueryFightAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns QueryFightAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.QueryFightAsk;

        /**
         * Creates a plain object from a QueryFightAsk message. Also converts values to other types if specified.
         * @param message QueryFightAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.QueryFightAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this QueryFightAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a QueryFightRes. */
    interface IQueryFightRes {

        /** QueryFightRes pd */
        pd?: pb.IPropertyDown;
    }

    /** Represents a QueryFightRes. */
    class QueryFightRes {

        /**
         * Constructs a new QueryFightRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IQueryFightRes);

        /** QueryFightRes pd. */
        public pd?: (pb.IPropertyDown|null);

        /**
         * Creates a new QueryFightRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns QueryFightRes instance
         */
        public static create(properties?: pb.IQueryFightRes): pb.QueryFightRes;

        /**
         * Encodes the specified QueryFightRes message. Does not implicitly {@link pb.QueryFightRes.verify|verify} messages.
         * @param message QueryFightRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IQueryFightRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified QueryFightRes message, length delimited. Does not implicitly {@link pb.QueryFightRes.verify|verify} messages.
         * @param message QueryFightRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IQueryFightRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a QueryFightRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns QueryFightRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.QueryFightRes;

        /**
         * Decodes a QueryFightRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns QueryFightRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.QueryFightRes;

        /**
         * Verifies a QueryFightRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a QueryFightRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns QueryFightRes
         */
        public static fromObject(object: { [k: string]: any }): pb.QueryFightRes;

        /**
         * Creates a plain object from a QueryFightRes message. Also converts values to other types if specified.
         * @param message QueryFightRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.QueryFightRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this QueryFightRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a FightYouAsk. */
    interface IFightYouAsk {

        /** FightYouAsk id */
        id?: string;
    }

    /** Represents a FightYouAsk. */
    class FightYouAsk {

        /**
         * Constructs a new FightYouAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IFightYouAsk);

        /** FightYouAsk id. */
        public id: string;

        /**
         * Creates a new FightYouAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns FightYouAsk instance
         */
        public static create(properties?: pb.IFightYouAsk): pb.FightYouAsk;

        /**
         * Encodes the specified FightYouAsk message. Does not implicitly {@link pb.FightYouAsk.verify|verify} messages.
         * @param message FightYouAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IFightYouAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified FightYouAsk message, length delimited. Does not implicitly {@link pb.FightYouAsk.verify|verify} messages.
         * @param message FightYouAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IFightYouAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a FightYouAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns FightYouAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.FightYouAsk;

        /**
         * Decodes a FightYouAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns FightYouAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.FightYouAsk;

        /**
         * Verifies a FightYouAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a FightYouAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns FightYouAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.FightYouAsk;

        /**
         * Creates a plain object from a FightYouAsk message. Also converts values to other types if specified.
         * @param message FightYouAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.FightYouAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this FightYouAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a QueryKingAsk. */
    interface IQueryKingAsk {

        /** QueryKingAsk id */
        id?: number;

        /** QueryKingAsk uid */
        uid?: string;
    }

    /** Represents a QueryKingAsk. */
    class QueryKingAsk {

        /**
         * Constructs a new QueryKingAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IQueryKingAsk);

        /** QueryKingAsk id. */
        public id: number;

        /** QueryKingAsk uid. */
        public uid: string;

        /**
         * Creates a new QueryKingAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns QueryKingAsk instance
         */
        public static create(properties?: pb.IQueryKingAsk): pb.QueryKingAsk;

        /**
         * Encodes the specified QueryKingAsk message. Does not implicitly {@link pb.QueryKingAsk.verify|verify} messages.
         * @param message QueryKingAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IQueryKingAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified QueryKingAsk message, length delimited. Does not implicitly {@link pb.QueryKingAsk.verify|verify} messages.
         * @param message QueryKingAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IQueryKingAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a QueryKingAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns QueryKingAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.QueryKingAsk;

        /**
         * Decodes a QueryKingAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns QueryKingAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.QueryKingAsk;

        /**
         * Verifies a QueryKingAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a QueryKingAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns QueryKingAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.QueryKingAsk;

        /**
         * Creates a plain object from a QueryKingAsk message. Also converts values to other types if specified.
         * @param message QueryKingAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.QueryKingAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this QueryKingAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a FightKingAsk. */
    interface IFightKingAsk {

        /** FightKingAsk id */
        id?: number;

        /** FightKingAsk uid */
        uid?: string;
    }

    /** Represents a FightKingAsk. */
    class FightKingAsk {

        /**
         * Constructs a new FightKingAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IFightKingAsk);

        /** FightKingAsk id. */
        public id: number;

        /** FightKingAsk uid. */
        public uid: string;

        /**
         * Creates a new FightKingAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns FightKingAsk instance
         */
        public static create(properties?: pb.IFightKingAsk): pb.FightKingAsk;

        /**
         * Encodes the specified FightKingAsk message. Does not implicitly {@link pb.FightKingAsk.verify|verify} messages.
         * @param message FightKingAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IFightKingAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified FightKingAsk message, length delimited. Does not implicitly {@link pb.FightKingAsk.verify|verify} messages.
         * @param message FightKingAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IFightKingAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a FightKingAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns FightKingAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.FightKingAsk;

        /**
         * Decodes a FightKingAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns FightKingAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.FightKingAsk;

        /**
         * Verifies a FightKingAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a FightKingAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns FightKingAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.FightKingAsk;

        /**
         * Creates a plain object from a FightKingAsk message. Also converts values to other types if specified.
         * @param message FightKingAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.FightKingAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this FightKingAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ShuaRes. */
    interface IShuaRes {

        /** ShuaRes tpe */
        tpe?: number;
    }

    /** Represents a ShuaRes. */
    class ShuaRes {

        /**
         * Constructs a new ShuaRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IShuaRes);

        /** ShuaRes tpe. */
        public tpe: number;

        /**
         * Creates a new ShuaRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ShuaRes instance
         */
        public static create(properties?: pb.IShuaRes): pb.ShuaRes;

        /**
         * Encodes the specified ShuaRes message. Does not implicitly {@link pb.ShuaRes.verify|verify} messages.
         * @param message ShuaRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IShuaRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ShuaRes message, length delimited. Does not implicitly {@link pb.ShuaRes.verify|verify} messages.
         * @param message ShuaRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IShuaRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ShuaRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ShuaRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.ShuaRes;

        /**
         * Decodes a ShuaRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ShuaRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.ShuaRes;

        /**
         * Verifies a ShuaRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ShuaRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ShuaRes
         */
        public static fromObject(object: { [k: string]: any }): pb.ShuaRes;

        /**
         * Creates a plain object from a ShuaRes message. Also converts values to other types if specified.
         * @param message ShuaRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.ShuaRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ShuaRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a MoneyGoAsk. */
    interface IMoneyGoAsk {

        /** MoneyGoAsk idx */
        idx?: number;

        /** MoneyGoAsk itemid */
        itemid?: number;
    }

    /** Represents a MoneyGoAsk. */
    class MoneyGoAsk {

        /**
         * Constructs a new MoneyGoAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IMoneyGoAsk);

        /** MoneyGoAsk idx. */
        public idx: number;

        /** MoneyGoAsk itemid. */
        public itemid: number;

        /**
         * Creates a new MoneyGoAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns MoneyGoAsk instance
         */
        public static create(properties?: pb.IMoneyGoAsk): pb.MoneyGoAsk;

        /**
         * Encodes the specified MoneyGoAsk message. Does not implicitly {@link pb.MoneyGoAsk.verify|verify} messages.
         * @param message MoneyGoAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IMoneyGoAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified MoneyGoAsk message, length delimited. Does not implicitly {@link pb.MoneyGoAsk.verify|verify} messages.
         * @param message MoneyGoAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IMoneyGoAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a MoneyGoAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns MoneyGoAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.MoneyGoAsk;

        /**
         * Decodes a MoneyGoAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns MoneyGoAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.MoneyGoAsk;

        /**
         * Verifies a MoneyGoAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a MoneyGoAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns MoneyGoAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.MoneyGoAsk;

        /**
         * Creates a plain object from a MoneyGoAsk message. Also converts values to other types if specified.
         * @param message MoneyGoAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.MoneyGoAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this MoneyGoAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a MoneyChaRes. */
    interface IMoneyChaRes {

        /** MoneyChaRes idx */
        idx?: number;

        /** MoneyChaRes itemid */
        itemid?: number;

        /** MoneyChaRes val */
        val?: number;
    }

    /** Represents a MoneyChaRes. */
    class MoneyChaRes {

        /**
         * Constructs a new MoneyChaRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IMoneyChaRes);

        /** MoneyChaRes idx. */
        public idx: number;

        /** MoneyChaRes itemid. */
        public itemid: number;

        /** MoneyChaRes val. */
        public val: number;

        /**
         * Creates a new MoneyChaRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns MoneyChaRes instance
         */
        public static create(properties?: pb.IMoneyChaRes): pb.MoneyChaRes;

        /**
         * Encodes the specified MoneyChaRes message. Does not implicitly {@link pb.MoneyChaRes.verify|verify} messages.
         * @param message MoneyChaRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IMoneyChaRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified MoneyChaRes message, length delimited. Does not implicitly {@link pb.MoneyChaRes.verify|verify} messages.
         * @param message MoneyChaRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IMoneyChaRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a MoneyChaRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns MoneyChaRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.MoneyChaRes;

        /**
         * Decodes a MoneyChaRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns MoneyChaRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.MoneyChaRes;

        /**
         * Verifies a MoneyChaRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a MoneyChaRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns MoneyChaRes
         */
        public static fromObject(object: { [k: string]: any }): pb.MoneyChaRes;

        /**
         * Creates a plain object from a MoneyChaRes message. Also converts values to other types if specified.
         * @param message MoneyChaRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.MoneyChaRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this MoneyChaRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a MoneyBuyOkRes. */
    interface IMoneyBuyOkRes {

        /** MoneyBuyOkRes idx */
        idx?: number;

        /** MoneyBuyOkRes itemid */
        itemid?: number;
    }

    /** Represents a MoneyBuyOkRes. */
    class MoneyBuyOkRes {

        /**
         * Constructs a new MoneyBuyOkRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IMoneyBuyOkRes);

        /** MoneyBuyOkRes idx. */
        public idx: number;

        /** MoneyBuyOkRes itemid. */
        public itemid: number;

        /**
         * Creates a new MoneyBuyOkRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns MoneyBuyOkRes instance
         */
        public static create(properties?: pb.IMoneyBuyOkRes): pb.MoneyBuyOkRes;

        /**
         * Encodes the specified MoneyBuyOkRes message. Does not implicitly {@link pb.MoneyBuyOkRes.verify|verify} messages.
         * @param message MoneyBuyOkRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IMoneyBuyOkRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified MoneyBuyOkRes message, length delimited. Does not implicitly {@link pb.MoneyBuyOkRes.verify|verify} messages.
         * @param message MoneyBuyOkRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IMoneyBuyOkRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a MoneyBuyOkRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns MoneyBuyOkRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.MoneyBuyOkRes;

        /**
         * Decodes a MoneyBuyOkRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns MoneyBuyOkRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.MoneyBuyOkRes;

        /**
         * Verifies a MoneyBuyOkRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a MoneyBuyOkRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns MoneyBuyOkRes
         */
        public static fromObject(object: { [k: string]: any }): pb.MoneyBuyOkRes;

        /**
         * Creates a plain object from a MoneyBuyOkRes message. Also converts values to other types if specified.
         * @param message MoneyBuyOkRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.MoneyBuyOkRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this MoneyBuyOkRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a FiveChangeAsk. */
    interface IFiveChangeAsk {

        /** FiveChangeAsk index */
        index?: string;
    }

    /** Represents a FiveChangeAsk. */
    class FiveChangeAsk {

        /**
         * Constructs a new FiveChangeAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IFiveChangeAsk);

        /** FiveChangeAsk index. */
        public index: string;

        /**
         * Creates a new FiveChangeAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns FiveChangeAsk instance
         */
        public static create(properties?: pb.IFiveChangeAsk): pb.FiveChangeAsk;

        /**
         * Encodes the specified FiveChangeAsk message. Does not implicitly {@link pb.FiveChangeAsk.verify|verify} messages.
         * @param message FiveChangeAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IFiveChangeAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified FiveChangeAsk message, length delimited. Does not implicitly {@link pb.FiveChangeAsk.verify|verify} messages.
         * @param message FiveChangeAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IFiveChangeAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a FiveChangeAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns FiveChangeAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.FiveChangeAsk;

        /**
         * Decodes a FiveChangeAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns FiveChangeAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.FiveChangeAsk;

        /**
         * Verifies a FiveChangeAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a FiveChangeAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns FiveChangeAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.FiveChangeAsk;

        /**
         * Creates a plain object from a FiveChangeAsk message. Also converts values to other types if specified.
         * @param message FiveChangeAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.FiveChangeAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this FiveChangeAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a FiveChangeRes. */
    interface IFiveChangeRes {
    }

    /** Represents a FiveChangeRes. */
    class FiveChangeRes {

        /**
         * Constructs a new FiveChangeRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IFiveChangeRes);

        /**
         * Creates a new FiveChangeRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns FiveChangeRes instance
         */
        public static create(properties?: pb.IFiveChangeRes): pb.FiveChangeRes;

        /**
         * Encodes the specified FiveChangeRes message. Does not implicitly {@link pb.FiveChangeRes.verify|verify} messages.
         * @param message FiveChangeRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IFiveChangeRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified FiveChangeRes message, length delimited. Does not implicitly {@link pb.FiveChangeRes.verify|verify} messages.
         * @param message FiveChangeRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IFiveChangeRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a FiveChangeRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns FiveChangeRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.FiveChangeRes;

        /**
         * Decodes a FiveChangeRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns FiveChangeRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.FiveChangeRes;

        /**
         * Verifies a FiveChangeRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a FiveChangeRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns FiveChangeRes
         */
        public static fromObject(object: { [k: string]: any }): pb.FiveChangeRes;

        /**
         * Creates a plain object from a FiveChangeRes message. Also converts values to other types if specified.
         * @param message FiveChangeRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.FiveChangeRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this FiveChangeRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a FuckEggAsk. */
    interface IFuckEggAsk {

        /** FuckEggAsk type */
        type?: number;
    }

    /** Represents a FuckEggAsk. */
    class FuckEggAsk {

        /**
         * Constructs a new FuckEggAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IFuckEggAsk);

        /** FuckEggAsk type. */
        public type: number;

        /**
         * Creates a new FuckEggAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns FuckEggAsk instance
         */
        public static create(properties?: pb.IFuckEggAsk): pb.FuckEggAsk;

        /**
         * Encodes the specified FuckEggAsk message. Does not implicitly {@link pb.FuckEggAsk.verify|verify} messages.
         * @param message FuckEggAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IFuckEggAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified FuckEggAsk message, length delimited. Does not implicitly {@link pb.FuckEggAsk.verify|verify} messages.
         * @param message FuckEggAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IFuckEggAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a FuckEggAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns FuckEggAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.FuckEggAsk;

        /**
         * Decodes a FuckEggAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns FuckEggAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.FuckEggAsk;

        /**
         * Verifies a FuckEggAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a FuckEggAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns FuckEggAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.FuckEggAsk;

        /**
         * Creates a plain object from a FuckEggAsk message. Also converts values to other types if specified.
         * @param message FuckEggAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.FuckEggAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this FuckEggAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a FuckEggRes. */
    interface IFuckEggRes {

        /** FuckEggRes index */
        index?: string;
    }

    /** Represents a FuckEggRes. */
    class FuckEggRes {

        /**
         * Constructs a new FuckEggRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IFuckEggRes);

        /** FuckEggRes index. */
        public index: string;

        /**
         * Creates a new FuckEggRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns FuckEggRes instance
         */
        public static create(properties?: pb.IFuckEggRes): pb.FuckEggRes;

        /**
         * Encodes the specified FuckEggRes message. Does not implicitly {@link pb.FuckEggRes.verify|verify} messages.
         * @param message FuckEggRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IFuckEggRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified FuckEggRes message, length delimited. Does not implicitly {@link pb.FuckEggRes.verify|verify} messages.
         * @param message FuckEggRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IFuckEggRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a FuckEggRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns FuckEggRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.FuckEggRes;

        /**
         * Decodes a FuckEggRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns FuckEggRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.FuckEggRes;

        /**
         * Verifies a FuckEggRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a FuckEggRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns FuckEggRes
         */
        public static fromObject(object: { [k: string]: any }): pb.FuckEggRes;

        /**
         * Creates a plain object from a FuckEggRes message. Also converts values to other types if specified.
         * @param message FuckEggRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.FuckEggRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this FuckEggRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a FuckEggFreeAsk. */
    interface IFuckEggFreeAsk {
    }

    /** Represents a FuckEggFreeAsk. */
    class FuckEggFreeAsk {

        /**
         * Constructs a new FuckEggFreeAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IFuckEggFreeAsk);

        /**
         * Creates a new FuckEggFreeAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns FuckEggFreeAsk instance
         */
        public static create(properties?: pb.IFuckEggFreeAsk): pb.FuckEggFreeAsk;

        /**
         * Encodes the specified FuckEggFreeAsk message. Does not implicitly {@link pb.FuckEggFreeAsk.verify|verify} messages.
         * @param message FuckEggFreeAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IFuckEggFreeAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified FuckEggFreeAsk message, length delimited. Does not implicitly {@link pb.FuckEggFreeAsk.verify|verify} messages.
         * @param message FuckEggFreeAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IFuckEggFreeAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a FuckEggFreeAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns FuckEggFreeAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.FuckEggFreeAsk;

        /**
         * Decodes a FuckEggFreeAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns FuckEggFreeAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.FuckEggFreeAsk;

        /**
         * Verifies a FuckEggFreeAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a FuckEggFreeAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns FuckEggFreeAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.FuckEggFreeAsk;

        /**
         * Creates a plain object from a FuckEggFreeAsk message. Also converts values to other types if specified.
         * @param message FuckEggFreeAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.FuckEggFreeAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this FuckEggFreeAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a FuckEggFreeRes. */
    interface IFuckEggFreeRes {

        /** FuckEggFreeRes val */
        val?: number;
    }

    /** Represents a FuckEggFreeRes. */
    class FuckEggFreeRes {

        /**
         * Constructs a new FuckEggFreeRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IFuckEggFreeRes);

        /** FuckEggFreeRes val. */
        public val: number;

        /**
         * Creates a new FuckEggFreeRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns FuckEggFreeRes instance
         */
        public static create(properties?: pb.IFuckEggFreeRes): pb.FuckEggFreeRes;

        /**
         * Encodes the specified FuckEggFreeRes message. Does not implicitly {@link pb.FuckEggFreeRes.verify|verify} messages.
         * @param message FuckEggFreeRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IFuckEggFreeRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified FuckEggFreeRes message, length delimited. Does not implicitly {@link pb.FuckEggFreeRes.verify|verify} messages.
         * @param message FuckEggFreeRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IFuckEggFreeRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a FuckEggFreeRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns FuckEggFreeRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.FuckEggFreeRes;

        /**
         * Decodes a FuckEggFreeRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns FuckEggFreeRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.FuckEggFreeRes;

        /**
         * Verifies a FuckEggFreeRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a FuckEggFreeRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns FuckEggFreeRes
         */
        public static fromObject(object: { [k: string]: any }): pb.FuckEggFreeRes;

        /**
         * Creates a plain object from a FuckEggFreeRes message. Also converts values to other types if specified.
         * @param message FuckEggFreeRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.FuckEggFreeRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this FuckEggFreeRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an EatCardAsk. */
    interface IEatCardAsk {

        /** EatCardAsk index */
        index?: string;

        /** EatCardAsk indexCards */
        indexCards?: string[];
    }

    /** Represents an EatCardAsk. */
    class EatCardAsk {

        /**
         * Constructs a new EatCardAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IEatCardAsk);

        /** EatCardAsk index. */
        public index: string;

        /** EatCardAsk indexCards. */
        public indexCards: string[];

        /**
         * Creates a new EatCardAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns EatCardAsk instance
         */
        public static create(properties?: pb.IEatCardAsk): pb.EatCardAsk;

        /**
         * Encodes the specified EatCardAsk message. Does not implicitly {@link pb.EatCardAsk.verify|verify} messages.
         * @param message EatCardAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IEatCardAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified EatCardAsk message, length delimited. Does not implicitly {@link pb.EatCardAsk.verify|verify} messages.
         * @param message EatCardAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IEatCardAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an EatCardAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns EatCardAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.EatCardAsk;

        /**
         * Decodes an EatCardAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns EatCardAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.EatCardAsk;

        /**
         * Verifies an EatCardAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an EatCardAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns EatCardAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.EatCardAsk;

        /**
         * Creates a plain object from an EatCardAsk message. Also converts values to other types if specified.
         * @param message EatCardAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.EatCardAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this EatCardAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an EatCardRes. */
    interface IEatCardRes {
    }

    /** Represents an EatCardRes. */
    class EatCardRes {

        /**
         * Constructs a new EatCardRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IEatCardRes);

        /**
         * Creates a new EatCardRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns EatCardRes instance
         */
        public static create(properties?: pb.IEatCardRes): pb.EatCardRes;

        /**
         * Encodes the specified EatCardRes message. Does not implicitly {@link pb.EatCardRes.verify|verify} messages.
         * @param message EatCardRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IEatCardRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified EatCardRes message, length delimited. Does not implicitly {@link pb.EatCardRes.verify|verify} messages.
         * @param message EatCardRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IEatCardRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an EatCardRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns EatCardRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.EatCardRes;

        /**
         * Decodes an EatCardRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns EatCardRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.EatCardRes;

        /**
         * Verifies an EatCardRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an EatCardRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns EatCardRes
         */
        public static fromObject(object: { [k: string]: any }): pb.EatCardRes;

        /**
         * Creates a plain object from an EatCardRes message. Also converts values to other types if specified.
         * @param message EatCardRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.EatCardRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this EatCardRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a SkillUpAsk. */
    interface ISkillUpAsk {

        /** SkillUpAsk index */
        index?: string;

        /** SkillUpAsk indexSkill */
        indexSkill?: number;
    }

    /** Represents a SkillUpAsk. */
    class SkillUpAsk {

        /**
         * Constructs a new SkillUpAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ISkillUpAsk);

        /** SkillUpAsk index. */
        public index: string;

        /** SkillUpAsk indexSkill. */
        public indexSkill: number;

        /**
         * Creates a new SkillUpAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns SkillUpAsk instance
         */
        public static create(properties?: pb.ISkillUpAsk): pb.SkillUpAsk;

        /**
         * Encodes the specified SkillUpAsk message. Does not implicitly {@link pb.SkillUpAsk.verify|verify} messages.
         * @param message SkillUpAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ISkillUpAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified SkillUpAsk message, length delimited. Does not implicitly {@link pb.SkillUpAsk.verify|verify} messages.
         * @param message SkillUpAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ISkillUpAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a SkillUpAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns SkillUpAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.SkillUpAsk;

        /**
         * Decodes a SkillUpAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns SkillUpAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.SkillUpAsk;

        /**
         * Verifies a SkillUpAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a SkillUpAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns SkillUpAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.SkillUpAsk;

        /**
         * Creates a plain object from a SkillUpAsk message. Also converts values to other types if specified.
         * @param message SkillUpAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.SkillUpAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this SkillUpAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a SkillUpRes. */
    interface ISkillUpRes {
    }

    /** Represents a SkillUpRes. */
    class SkillUpRes {

        /**
         * Constructs a new SkillUpRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ISkillUpRes);

        /**
         * Creates a new SkillUpRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns SkillUpRes instance
         */
        public static create(properties?: pb.ISkillUpRes): pb.SkillUpRes;

        /**
         * Encodes the specified SkillUpRes message. Does not implicitly {@link pb.SkillUpRes.verify|verify} messages.
         * @param message SkillUpRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ISkillUpRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified SkillUpRes message, length delimited. Does not implicitly {@link pb.SkillUpRes.verify|verify} messages.
         * @param message SkillUpRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ISkillUpRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a SkillUpRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns SkillUpRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.SkillUpRes;

        /**
         * Decodes a SkillUpRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns SkillUpRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.SkillUpRes;

        /**
         * Verifies a SkillUpRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a SkillUpRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns SkillUpRes
         */
        public static fromObject(object: { [k: string]: any }): pb.SkillUpRes;

        /**
         * Creates a plain object from a SkillUpRes message. Also converts values to other types if specified.
         * @param message SkillUpRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.SkillUpRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this SkillUpRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a SkillBreakAsk. */
    interface ISkillBreakAsk {

        /** SkillBreakAsk index */
        index?: string;

        /** SkillBreakAsk indexSkill */
        indexSkill?: number;
    }

    /** Represents a SkillBreakAsk. */
    class SkillBreakAsk {

        /**
         * Constructs a new SkillBreakAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ISkillBreakAsk);

        /** SkillBreakAsk index. */
        public index: string;

        /** SkillBreakAsk indexSkill. */
        public indexSkill: number;

        /**
         * Creates a new SkillBreakAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns SkillBreakAsk instance
         */
        public static create(properties?: pb.ISkillBreakAsk): pb.SkillBreakAsk;

        /**
         * Encodes the specified SkillBreakAsk message. Does not implicitly {@link pb.SkillBreakAsk.verify|verify} messages.
         * @param message SkillBreakAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ISkillBreakAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified SkillBreakAsk message, length delimited. Does not implicitly {@link pb.SkillBreakAsk.verify|verify} messages.
         * @param message SkillBreakAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ISkillBreakAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a SkillBreakAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns SkillBreakAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.SkillBreakAsk;

        /**
         * Decodes a SkillBreakAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns SkillBreakAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.SkillBreakAsk;

        /**
         * Verifies a SkillBreakAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a SkillBreakAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns SkillBreakAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.SkillBreakAsk;

        /**
         * Creates a plain object from a SkillBreakAsk message. Also converts values to other types if specified.
         * @param message SkillBreakAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.SkillBreakAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this SkillBreakAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a SkillBreakRes. */
    interface ISkillBreakRes {

        /** SkillBreakRes res */
        res?: boolean;
    }

    /** Represents a SkillBreakRes. */
    class SkillBreakRes {

        /**
         * Constructs a new SkillBreakRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ISkillBreakRes);

        /** SkillBreakRes res. */
        public res: boolean;

        /**
         * Creates a new SkillBreakRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns SkillBreakRes instance
         */
        public static create(properties?: pb.ISkillBreakRes): pb.SkillBreakRes;

        /**
         * Encodes the specified SkillBreakRes message. Does not implicitly {@link pb.SkillBreakRes.verify|verify} messages.
         * @param message SkillBreakRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ISkillBreakRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified SkillBreakRes message, length delimited. Does not implicitly {@link pb.SkillBreakRes.verify|verify} messages.
         * @param message SkillBreakRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ISkillBreakRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a SkillBreakRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns SkillBreakRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.SkillBreakRes;

        /**
         * Decodes a SkillBreakRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns SkillBreakRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.SkillBreakRes;

        /**
         * Verifies a SkillBreakRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a SkillBreakRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns SkillBreakRes
         */
        public static fromObject(object: { [k: string]: any }): pb.SkillBreakRes;

        /**
         * Creates a plain object from a SkillBreakRes message. Also converts values to other types if specified.
         * @param message SkillBreakRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.SkillBreakRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this SkillBreakRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a LockAsk. */
    interface ILockAsk {

        /** LockAsk index */
        index?: string;
    }

    /** Represents a LockAsk. */
    class LockAsk {

        /**
         * Constructs a new LockAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ILockAsk);

        /** LockAsk index. */
        public index: string;

        /**
         * Creates a new LockAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns LockAsk instance
         */
        public static create(properties?: pb.ILockAsk): pb.LockAsk;

        /**
         * Encodes the specified LockAsk message. Does not implicitly {@link pb.LockAsk.verify|verify} messages.
         * @param message LockAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ILockAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified LockAsk message, length delimited. Does not implicitly {@link pb.LockAsk.verify|verify} messages.
         * @param message LockAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ILockAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a LockAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns LockAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.LockAsk;

        /**
         * Decodes a LockAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns LockAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.LockAsk;

        /**
         * Verifies a LockAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a LockAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns LockAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.LockAsk;

        /**
         * Creates a plain object from a LockAsk message. Also converts values to other types if specified.
         * @param message LockAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.LockAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this LockAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a LockRes. */
    interface ILockRes {
    }

    /** Represents a LockRes. */
    class LockRes {

        /**
         * Constructs a new LockRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ILockRes);

        /**
         * Creates a new LockRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns LockRes instance
         */
        public static create(properties?: pb.ILockRes): pb.LockRes;

        /**
         * Encodes the specified LockRes message. Does not implicitly {@link pb.LockRes.verify|verify} messages.
         * @param message LockRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ILockRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified LockRes message, length delimited. Does not implicitly {@link pb.LockRes.verify|verify} messages.
         * @param message LockRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ILockRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a LockRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns LockRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.LockRes;

        /**
         * Decodes a LockRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns LockRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.LockRes;

        /**
         * Verifies a LockRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a LockRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns LockRes
         */
        public static fromObject(object: { [k: string]: any }): pb.LockRes;

        /**
         * Creates a plain object from a LockRes message. Also converts values to other types if specified.
         * @param message LockRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.LockRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this LockRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a SkillChangeAsk. */
    interface ISkillChangeAsk {

        /** SkillChangeAsk index */
        index?: string;

        /** SkillChangeAsk indexSkill */
        indexSkill?: number;
    }

    /** Represents a SkillChangeAsk. */
    class SkillChangeAsk {

        /**
         * Constructs a new SkillChangeAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ISkillChangeAsk);

        /** SkillChangeAsk index. */
        public index: string;

        /** SkillChangeAsk indexSkill. */
        public indexSkill: number;

        /**
         * Creates a new SkillChangeAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns SkillChangeAsk instance
         */
        public static create(properties?: pb.ISkillChangeAsk): pb.SkillChangeAsk;

        /**
         * Encodes the specified SkillChangeAsk message. Does not implicitly {@link pb.SkillChangeAsk.verify|verify} messages.
         * @param message SkillChangeAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ISkillChangeAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified SkillChangeAsk message, length delimited. Does not implicitly {@link pb.SkillChangeAsk.verify|verify} messages.
         * @param message SkillChangeAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ISkillChangeAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a SkillChangeAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns SkillChangeAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.SkillChangeAsk;

        /**
         * Decodes a SkillChangeAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns SkillChangeAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.SkillChangeAsk;

        /**
         * Verifies a SkillChangeAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a SkillChangeAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns SkillChangeAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.SkillChangeAsk;

        /**
         * Creates a plain object from a SkillChangeAsk message. Also converts values to other types if specified.
         * @param message SkillChangeAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.SkillChangeAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this SkillChangeAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a SkillChangeRes. */
    interface ISkillChangeRes {
    }

    /** Represents a SkillChangeRes. */
    class SkillChangeRes {

        /**
         * Constructs a new SkillChangeRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ISkillChangeRes);

        /**
         * Creates a new SkillChangeRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns SkillChangeRes instance
         */
        public static create(properties?: pb.ISkillChangeRes): pb.SkillChangeRes;

        /**
         * Encodes the specified SkillChangeRes message. Does not implicitly {@link pb.SkillChangeRes.verify|verify} messages.
         * @param message SkillChangeRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ISkillChangeRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified SkillChangeRes message, length delimited. Does not implicitly {@link pb.SkillChangeRes.verify|verify} messages.
         * @param message SkillChangeRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ISkillChangeRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a SkillChangeRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns SkillChangeRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.SkillChangeRes;

        /**
         * Decodes a SkillChangeRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns SkillChangeRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.SkillChangeRes;

        /**
         * Verifies a SkillChangeRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a SkillChangeRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns SkillChangeRes
         */
        public static fromObject(object: { [k: string]: any }): pb.SkillChangeRes;

        /**
         * Creates a plain object from a SkillChangeRes message. Also converts values to other types if specified.
         * @param message SkillChangeRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.SkillChangeRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this SkillChangeRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a CreatAsk. */
    interface ICreatAsk {

        /** CreatAsk id */
        id?: number;
    }

    /** Represents a CreatAsk. */
    class CreatAsk {

        /**
         * Constructs a new CreatAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ICreatAsk);

        /** CreatAsk id. */
        public id: number;

        /**
         * Creates a new CreatAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns CreatAsk instance
         */
        public static create(properties?: pb.ICreatAsk): pb.CreatAsk;

        /**
         * Encodes the specified CreatAsk message. Does not implicitly {@link pb.CreatAsk.verify|verify} messages.
         * @param message CreatAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ICreatAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified CreatAsk message, length delimited. Does not implicitly {@link pb.CreatAsk.verify|verify} messages.
         * @param message CreatAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ICreatAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a CreatAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns CreatAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.CreatAsk;

        /**
         * Decodes a CreatAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns CreatAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.CreatAsk;

        /**
         * Verifies a CreatAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a CreatAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns CreatAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.CreatAsk;

        /**
         * Creates a plain object from a CreatAsk message. Also converts values to other types if specified.
         * @param message CreatAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.CreatAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this CreatAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a CreatRes. */
    interface ICreatRes {

        /** CreatRes res */
        res?: boolean;
    }

    /** Represents a CreatRes. */
    class CreatRes {

        /**
         * Constructs a new CreatRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ICreatRes);

        /** CreatRes res. */
        public res: boolean;

        /**
         * Creates a new CreatRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns CreatRes instance
         */
        public static create(properties?: pb.ICreatRes): pb.CreatRes;

        /**
         * Encodes the specified CreatRes message. Does not implicitly {@link pb.CreatRes.verify|verify} messages.
         * @param message CreatRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ICreatRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified CreatRes message, length delimited. Does not implicitly {@link pb.CreatRes.verify|verify} messages.
         * @param message CreatRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ICreatRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a CreatRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns CreatRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.CreatRes;

        /**
         * Decodes a CreatRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns CreatRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.CreatRes;

        /**
         * Verifies a CreatRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a CreatRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns CreatRes
         */
        public static fromObject(object: { [k: string]: any }): pb.CreatRes;

        /**
         * Creates a plain object from a CreatRes message. Also converts values to other types if specified.
         * @param message CreatRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.CreatRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this CreatRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a GGRes. */
    interface IGGRes {

        /** GGRes res */
        res?: string;
    }

    /** Represents a GGRes. */
    class GGRes {

        /**
         * Constructs a new GGRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IGGRes);

        /** GGRes res. */
        public res: string;

        /**
         * Creates a new GGRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns GGRes instance
         */
        public static create(properties?: pb.IGGRes): pb.GGRes;

        /**
         * Encodes the specified GGRes message. Does not implicitly {@link pb.GGRes.verify|verify} messages.
         * @param message GGRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IGGRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified GGRes message, length delimited. Does not implicitly {@link pb.GGRes.verify|verify} messages.
         * @param message GGRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IGGRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a GGRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns GGRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.GGRes;

        /**
         * Decodes a GGRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns GGRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.GGRes;

        /**
         * Verifies a GGRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a GGRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns GGRes
         */
        public static fromObject(object: { [k: string]: any }): pb.GGRes;

        /**
         * Creates a plain object from a GGRes message. Also converts values to other types if specified.
         * @param message GGRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.GGRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this GGRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a StartAsk. */
    interface IStartAsk {
    }

    /** Represents a StartAsk. */
    class StartAsk {

        /**
         * Constructs a new StartAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IStartAsk);

        /**
         * Creates a new StartAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns StartAsk instance
         */
        public static create(properties?: pb.IStartAsk): pb.StartAsk;

        /**
         * Encodes the specified StartAsk message. Does not implicitly {@link pb.StartAsk.verify|verify} messages.
         * @param message StartAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IStartAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified StartAsk message, length delimited. Does not implicitly {@link pb.StartAsk.verify|verify} messages.
         * @param message StartAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IStartAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a StartAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns StartAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.StartAsk;

        /**
         * Decodes a StartAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns StartAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.StartAsk;

        /**
         * Verifies a StartAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a StartAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns StartAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.StartAsk;

        /**
         * Creates a plain object from a StartAsk message. Also converts values to other types if specified.
         * @param message StartAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.StartAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this StartAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a FeedAsk. */
    interface IFeedAsk {

        /** FeedAsk index */
        index?: string;

        /** FeedAsk idItem */
        idItem?: number;

        /** FeedAsk sidItem */
        sidItem?: string;
    }

    /** Represents a FeedAsk. */
    class FeedAsk {

        /**
         * Constructs a new FeedAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IFeedAsk);

        /** FeedAsk index. */
        public index: string;

        /** FeedAsk idItem. */
        public idItem: number;

        /** FeedAsk sidItem. */
        public sidItem: string;

        /**
         * Creates a new FeedAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns FeedAsk instance
         */
        public static create(properties?: pb.IFeedAsk): pb.FeedAsk;

        /**
         * Encodes the specified FeedAsk message. Does not implicitly {@link pb.FeedAsk.verify|verify} messages.
         * @param message FeedAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IFeedAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified FeedAsk message, length delimited. Does not implicitly {@link pb.FeedAsk.verify|verify} messages.
         * @param message FeedAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IFeedAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a FeedAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns FeedAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.FeedAsk;

        /**
         * Decodes a FeedAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns FeedAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.FeedAsk;

        /**
         * Verifies a FeedAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a FeedAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns FeedAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.FeedAsk;

        /**
         * Creates a plain object from a FeedAsk message. Also converts values to other types if specified.
         * @param message FeedAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.FeedAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this FeedAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a FeedRes. */
    interface IFeedRes {
    }

    /** Represents a FeedRes. */
    class FeedRes {

        /**
         * Constructs a new FeedRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IFeedRes);

        /**
         * Creates a new FeedRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns FeedRes instance
         */
        public static create(properties?: pb.IFeedRes): pb.FeedRes;

        /**
         * Encodes the specified FeedRes message. Does not implicitly {@link pb.FeedRes.verify|verify} messages.
         * @param message FeedRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IFeedRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified FeedRes message, length delimited. Does not implicitly {@link pb.FeedRes.verify|verify} messages.
         * @param message FeedRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IFeedRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a FeedRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns FeedRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.FeedRes;

        /**
         * Decodes a FeedRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns FeedRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.FeedRes;

        /**
         * Verifies a FeedRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a FeedRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns FeedRes
         */
        public static fromObject(object: { [k: string]: any }): pb.FeedRes;

        /**
         * Creates a plain object from a FeedRes message. Also converts values to other types if specified.
         * @param message FeedRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.FeedRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this FeedRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an OpenBoxAsk. */
    interface IOpenBoxAsk {

        /** OpenBoxAsk index */
        index?: number;
    }

    /** Represents an OpenBoxAsk. */
    class OpenBoxAsk {

        /**
         * Constructs a new OpenBoxAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IOpenBoxAsk);

        /** OpenBoxAsk index. */
        public index: number;

        /**
         * Creates a new OpenBoxAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns OpenBoxAsk instance
         */
        public static create(properties?: pb.IOpenBoxAsk): pb.OpenBoxAsk;

        /**
         * Encodes the specified OpenBoxAsk message. Does not implicitly {@link pb.OpenBoxAsk.verify|verify} messages.
         * @param message OpenBoxAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IOpenBoxAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified OpenBoxAsk message, length delimited. Does not implicitly {@link pb.OpenBoxAsk.verify|verify} messages.
         * @param message OpenBoxAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IOpenBoxAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an OpenBoxAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns OpenBoxAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.OpenBoxAsk;

        /**
         * Decodes an OpenBoxAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns OpenBoxAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.OpenBoxAsk;

        /**
         * Verifies an OpenBoxAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an OpenBoxAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns OpenBoxAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.OpenBoxAsk;

        /**
         * Creates a plain object from an OpenBoxAsk message. Also converts values to other types if specified.
         * @param message OpenBoxAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.OpenBoxAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this OpenBoxAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an OpenBoxRes. */
    interface IOpenBoxRes {

        /** OpenBoxRes pro */
        pro?: pb.IProperty;
    }

    /** Represents an OpenBoxRes. */
    class OpenBoxRes {

        /**
         * Constructs a new OpenBoxRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IOpenBoxRes);

        /** OpenBoxRes pro. */
        public pro?: (pb.IProperty|null);

        /**
         * Creates a new OpenBoxRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns OpenBoxRes instance
         */
        public static create(properties?: pb.IOpenBoxRes): pb.OpenBoxRes;

        /**
         * Encodes the specified OpenBoxRes message. Does not implicitly {@link pb.OpenBoxRes.verify|verify} messages.
         * @param message OpenBoxRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IOpenBoxRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified OpenBoxRes message, length delimited. Does not implicitly {@link pb.OpenBoxRes.verify|verify} messages.
         * @param message OpenBoxRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IOpenBoxRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an OpenBoxRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns OpenBoxRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.OpenBoxRes;

        /**
         * Decodes an OpenBoxRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns OpenBoxRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.OpenBoxRes;

        /**
         * Verifies an OpenBoxRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an OpenBoxRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns OpenBoxRes
         */
        public static fromObject(object: { [k: string]: any }): pb.OpenBoxRes;

        /**
         * Creates a plain object from an OpenBoxRes message. Also converts values to other types if specified.
         * @param message OpenBoxRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.OpenBoxRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this OpenBoxRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a CardNumChangeRes. */
    interface ICardNumChangeRes {
    }

    /** Represents a CardNumChangeRes. */
    class CardNumChangeRes {

        /**
         * Constructs a new CardNumChangeRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ICardNumChangeRes);

        /**
         * Creates a new CardNumChangeRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns CardNumChangeRes instance
         */
        public static create(properties?: pb.ICardNumChangeRes): pb.CardNumChangeRes;

        /**
         * Encodes the specified CardNumChangeRes message. Does not implicitly {@link pb.CardNumChangeRes.verify|verify} messages.
         * @param message CardNumChangeRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ICardNumChangeRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified CardNumChangeRes message, length delimited. Does not implicitly {@link pb.CardNumChangeRes.verify|verify} messages.
         * @param message CardNumChangeRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ICardNumChangeRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a CardNumChangeRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns CardNumChangeRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.CardNumChangeRes;

        /**
         * Decodes a CardNumChangeRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns CardNumChangeRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.CardNumChangeRes;

        /**
         * Verifies a CardNumChangeRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a CardNumChangeRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns CardNumChangeRes
         */
        public static fromObject(object: { [k: string]: any }): pb.CardNumChangeRes;

        /**
         * Creates a plain object from a CardNumChangeRes message. Also converts values to other types if specified.
         * @param message CardNumChangeRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.CardNumChangeRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this CardNumChangeRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a FormationRes. */
    interface IFormationRes {
    }

    /** Represents a FormationRes. */
    class FormationRes {

        /**
         * Constructs a new FormationRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IFormationRes);

        /**
         * Creates a new FormationRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns FormationRes instance
         */
        public static create(properties?: pb.IFormationRes): pb.FormationRes;

        /**
         * Encodes the specified FormationRes message. Does not implicitly {@link pb.FormationRes.verify|verify} messages.
         * @param message FormationRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IFormationRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified FormationRes message, length delimited. Does not implicitly {@link pb.FormationRes.verify|verify} messages.
         * @param message FormationRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IFormationRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a FormationRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns FormationRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.FormationRes;

        /**
         * Decodes a FormationRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns FormationRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.FormationRes;

        /**
         * Verifies a FormationRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a FormationRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns FormationRes
         */
        public static fromObject(object: { [k: string]: any }): pb.FormationRes;

        /**
         * Creates a plain object from a FormationRes message. Also converts values to other types if specified.
         * @param message FormationRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.FormationRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this FormationRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a WearXAsk. */
    interface IWearXAsk {

        /** WearXAsk index */
        index?: number;
    }

    /** Represents a WearXAsk. */
    class WearXAsk {

        /**
         * Constructs a new WearXAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IWearXAsk);

        /** WearXAsk index. */
        public index: number;

        /**
         * Creates a new WearXAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns WearXAsk instance
         */
        public static create(properties?: pb.IWearXAsk): pb.WearXAsk;

        /**
         * Encodes the specified WearXAsk message. Does not implicitly {@link pb.WearXAsk.verify|verify} messages.
         * @param message WearXAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IWearXAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified WearXAsk message, length delimited. Does not implicitly {@link pb.WearXAsk.verify|verify} messages.
         * @param message WearXAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IWearXAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a WearXAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns WearXAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.WearXAsk;

        /**
         * Decodes a WearXAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns WearXAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.WearXAsk;

        /**
         * Verifies a WearXAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a WearXAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns WearXAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.WearXAsk;

        /**
         * Creates a plain object from a WearXAsk message. Also converts values to other types if specified.
         * @param message WearXAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.WearXAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this WearXAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a PassAsk. */
    interface IPassAsk {

        /** PassAsk index */
        index?: string;
    }

    /** Represents a PassAsk. */
    class PassAsk {

        /**
         * Constructs a new PassAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IPassAsk);

        /** PassAsk index. */
        public index: string;

        /**
         * Creates a new PassAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns PassAsk instance
         */
        public static create(properties?: pb.IPassAsk): pb.PassAsk;

        /**
         * Encodes the specified PassAsk message. Does not implicitly {@link pb.PassAsk.verify|verify} messages.
         * @param message PassAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IPassAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified PassAsk message, length delimited. Does not implicitly {@link pb.PassAsk.verify|verify} messages.
         * @param message PassAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IPassAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a PassAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns PassAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.PassAsk;

        /**
         * Decodes a PassAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns PassAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.PassAsk;

        /**
         * Verifies a PassAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a PassAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns PassAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.PassAsk;

        /**
         * Creates a plain object from a PassAsk message. Also converts values to other types if specified.
         * @param message PassAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.PassAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this PassAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a PassRes. */
    interface IPassRes {

        /** PassRes res */
        res?: boolean;
    }

    /** Represents a PassRes. */
    class PassRes {

        /**
         * Constructs a new PassRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IPassRes);

        /** PassRes res. */
        public res: boolean;

        /**
         * Creates a new PassRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns PassRes instance
         */
        public static create(properties?: pb.IPassRes): pb.PassRes;

        /**
         * Encodes the specified PassRes message. Does not implicitly {@link pb.PassRes.verify|verify} messages.
         * @param message PassRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IPassRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified PassRes message, length delimited. Does not implicitly {@link pb.PassRes.verify|verify} messages.
         * @param message PassRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IPassRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a PassRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns PassRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.PassRes;

        /**
         * Decodes a PassRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns PassRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.PassRes;

        /**
         * Verifies a PassRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a PassRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns PassRes
         */
        public static fromObject(object: { [k: string]: any }): pb.PassRes;

        /**
         * Creates a plain object from a PassRes message. Also converts values to other types if specified.
         * @param message PassRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.PassRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this PassRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a JianUpAsk. */
    interface IJianUpAsk {
    }

    /** Represents a JianUpAsk. */
    class JianUpAsk {

        /**
         * Constructs a new JianUpAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IJianUpAsk);

        /**
         * Creates a new JianUpAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns JianUpAsk instance
         */
        public static create(properties?: pb.IJianUpAsk): pb.JianUpAsk;

        /**
         * Encodes the specified JianUpAsk message. Does not implicitly {@link pb.JianUpAsk.verify|verify} messages.
         * @param message JianUpAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IJianUpAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified JianUpAsk message, length delimited. Does not implicitly {@link pb.JianUpAsk.verify|verify} messages.
         * @param message JianUpAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IJianUpAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a JianUpAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns JianUpAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.JianUpAsk;

        /**
         * Decodes a JianUpAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns JianUpAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.JianUpAsk;

        /**
         * Verifies a JianUpAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a JianUpAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns JianUpAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.JianUpAsk;

        /**
         * Creates a plain object from a JianUpAsk message. Also converts values to other types if specified.
         * @param message JianUpAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.JianUpAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this JianUpAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a JianUpRes. */
    interface IJianUpRes {
    }

    /** Represents a JianUpRes. */
    class JianUpRes {

        /**
         * Constructs a new JianUpRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IJianUpRes);

        /**
         * Creates a new JianUpRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns JianUpRes instance
         */
        public static create(properties?: pb.IJianUpRes): pb.JianUpRes;

        /**
         * Encodes the specified JianUpRes message. Does not implicitly {@link pb.JianUpRes.verify|verify} messages.
         * @param message JianUpRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IJianUpRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified JianUpRes message, length delimited. Does not implicitly {@link pb.JianUpRes.verify|verify} messages.
         * @param message JianUpRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IJianUpRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a JianUpRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns JianUpRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.JianUpRes;

        /**
         * Decodes a JianUpRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns JianUpRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.JianUpRes;

        /**
         * Verifies a JianUpRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a JianUpRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns JianUpRes
         */
        public static fromObject(object: { [k: string]: any }): pb.JianUpRes;

        /**
         * Creates a plain object from a JianUpRes message. Also converts values to other types if specified.
         * @param message JianUpRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.JianUpRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this JianUpRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a FaBaoKillAsk. */
    interface IFaBaoKillAsk {

        /** FaBaoKillAsk tpe */
        tpe?: number;

        /** FaBaoKillAsk index */
        index?: number;

        /** FaBaoKillAsk isMine */
        isMine?: boolean;
    }

    /** Represents a FaBaoKillAsk. */
    class FaBaoKillAsk {

        /**
         * Constructs a new FaBaoKillAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IFaBaoKillAsk);

        /** FaBaoKillAsk tpe. */
        public tpe: number;

        /** FaBaoKillAsk index. */
        public index: number;

        /** FaBaoKillAsk isMine. */
        public isMine: boolean;

        /**
         * Creates a new FaBaoKillAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns FaBaoKillAsk instance
         */
        public static create(properties?: pb.IFaBaoKillAsk): pb.FaBaoKillAsk;

        /**
         * Encodes the specified FaBaoKillAsk message. Does not implicitly {@link pb.FaBaoKillAsk.verify|verify} messages.
         * @param message FaBaoKillAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IFaBaoKillAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified FaBaoKillAsk message, length delimited. Does not implicitly {@link pb.FaBaoKillAsk.verify|verify} messages.
         * @param message FaBaoKillAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IFaBaoKillAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a FaBaoKillAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns FaBaoKillAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.FaBaoKillAsk;

        /**
         * Decodes a FaBaoKillAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns FaBaoKillAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.FaBaoKillAsk;

        /**
         * Verifies a FaBaoKillAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a FaBaoKillAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns FaBaoKillAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.FaBaoKillAsk;

        /**
         * Creates a plain object from a FaBaoKillAsk message. Also converts values to other types if specified.
         * @param message FaBaoKillAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.FaBaoKillAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this FaBaoKillAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a DingUpAsk. */
    interface IDingUpAsk {
    }

    /** Represents a DingUpAsk. */
    class DingUpAsk {

        /**
         * Constructs a new DingUpAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IDingUpAsk);

        /**
         * Creates a new DingUpAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns DingUpAsk instance
         */
        public static create(properties?: pb.IDingUpAsk): pb.DingUpAsk;

        /**
         * Encodes the specified DingUpAsk message. Does not implicitly {@link pb.DingUpAsk.verify|verify} messages.
         * @param message DingUpAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IDingUpAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified DingUpAsk message, length delimited. Does not implicitly {@link pb.DingUpAsk.verify|verify} messages.
         * @param message DingUpAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IDingUpAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a DingUpAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns DingUpAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.DingUpAsk;

        /**
         * Decodes a DingUpAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns DingUpAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.DingUpAsk;

        /**
         * Verifies a DingUpAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a DingUpAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns DingUpAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.DingUpAsk;

        /**
         * Creates a plain object from a DingUpAsk message. Also converts values to other types if specified.
         * @param message DingUpAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.DingUpAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this DingUpAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a DingUpRes. */
    interface IDingUpRes {
    }

    /** Represents a DingUpRes. */
    class DingUpRes {

        /**
         * Constructs a new DingUpRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IDingUpRes);

        /**
         * Creates a new DingUpRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns DingUpRes instance
         */
        public static create(properties?: pb.IDingUpRes): pb.DingUpRes;

        /**
         * Encodes the specified DingUpRes message. Does not implicitly {@link pb.DingUpRes.verify|verify} messages.
         * @param message DingUpRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IDingUpRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified DingUpRes message, length delimited. Does not implicitly {@link pb.DingUpRes.verify|verify} messages.
         * @param message DingUpRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IDingUpRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a DingUpRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns DingUpRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.DingUpRes;

        /**
         * Decodes a DingUpRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns DingUpRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.DingUpRes;

        /**
         * Verifies a DingUpRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a DingUpRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns DingUpRes
         */
        public static fromObject(object: { [k: string]: any }): pb.DingUpRes;

        /**
         * Creates a plain object from a DingUpRes message. Also converts values to other types if specified.
         * @param message DingUpRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.DingUpRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this DingUpRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a JianBreakAsk. */
    interface IJianBreakAsk {
    }

    /** Represents a JianBreakAsk. */
    class JianBreakAsk {

        /**
         * Constructs a new JianBreakAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IJianBreakAsk);

        /**
         * Creates a new JianBreakAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns JianBreakAsk instance
         */
        public static create(properties?: pb.IJianBreakAsk): pb.JianBreakAsk;

        /**
         * Encodes the specified JianBreakAsk message. Does not implicitly {@link pb.JianBreakAsk.verify|verify} messages.
         * @param message JianBreakAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IJianBreakAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified JianBreakAsk message, length delimited. Does not implicitly {@link pb.JianBreakAsk.verify|verify} messages.
         * @param message JianBreakAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IJianBreakAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a JianBreakAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns JianBreakAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.JianBreakAsk;

        /**
         * Decodes a JianBreakAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns JianBreakAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.JianBreakAsk;

        /**
         * Verifies a JianBreakAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a JianBreakAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns JianBreakAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.JianBreakAsk;

        /**
         * Creates a plain object from a JianBreakAsk message. Also converts values to other types if specified.
         * @param message JianBreakAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.JianBreakAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this JianBreakAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a JianBreakRes. */
    interface IJianBreakRes {

        /** JianBreakRes res */
        res?: boolean;
    }

    /** Represents a JianBreakRes. */
    class JianBreakRes {

        /**
         * Constructs a new JianBreakRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IJianBreakRes);

        /** JianBreakRes res. */
        public res: boolean;

        /**
         * Creates a new JianBreakRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns JianBreakRes instance
         */
        public static create(properties?: pb.IJianBreakRes): pb.JianBreakRes;

        /**
         * Encodes the specified JianBreakRes message. Does not implicitly {@link pb.JianBreakRes.verify|verify} messages.
         * @param message JianBreakRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IJianBreakRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified JianBreakRes message, length delimited. Does not implicitly {@link pb.JianBreakRes.verify|verify} messages.
         * @param message JianBreakRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IJianBreakRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a JianBreakRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns JianBreakRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.JianBreakRes;

        /**
         * Decodes a JianBreakRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns JianBreakRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.JianBreakRes;

        /**
         * Verifies a JianBreakRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a JianBreakRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns JianBreakRes
         */
        public static fromObject(object: { [k: string]: any }): pb.JianBreakRes;

        /**
         * Creates a plain object from a JianBreakRes message. Also converts values to other types if specified.
         * @param message JianBreakRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.JianBreakRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this JianBreakRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a DingBreakAsk. */
    interface IDingBreakAsk {
    }

    /** Represents a DingBreakAsk. */
    class DingBreakAsk {

        /**
         * Constructs a new DingBreakAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IDingBreakAsk);

        /**
         * Creates a new DingBreakAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns DingBreakAsk instance
         */
        public static create(properties?: pb.IDingBreakAsk): pb.DingBreakAsk;

        /**
         * Encodes the specified DingBreakAsk message. Does not implicitly {@link pb.DingBreakAsk.verify|verify} messages.
         * @param message DingBreakAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IDingBreakAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified DingBreakAsk message, length delimited. Does not implicitly {@link pb.DingBreakAsk.verify|verify} messages.
         * @param message DingBreakAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IDingBreakAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a DingBreakAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns DingBreakAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.DingBreakAsk;

        /**
         * Decodes a DingBreakAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns DingBreakAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.DingBreakAsk;

        /**
         * Verifies a DingBreakAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a DingBreakAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns DingBreakAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.DingBreakAsk;

        /**
         * Creates a plain object from a DingBreakAsk message. Also converts values to other types if specified.
         * @param message DingBreakAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.DingBreakAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this DingBreakAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a DingBreakRes. */
    interface IDingBreakRes {

        /** DingBreakRes res */
        res?: boolean;
    }

    /** Represents a DingBreakRes. */
    class DingBreakRes {

        /**
         * Constructs a new DingBreakRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IDingBreakRes);

        /** DingBreakRes res. */
        public res: boolean;

        /**
         * Creates a new DingBreakRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns DingBreakRes instance
         */
        public static create(properties?: pb.IDingBreakRes): pb.DingBreakRes;

        /**
         * Encodes the specified DingBreakRes message. Does not implicitly {@link pb.DingBreakRes.verify|verify} messages.
         * @param message DingBreakRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IDingBreakRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified DingBreakRes message, length delimited. Does not implicitly {@link pb.DingBreakRes.verify|verify} messages.
         * @param message DingBreakRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IDingBreakRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a DingBreakRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns DingBreakRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.DingBreakRes;

        /**
         * Decodes a DingBreakRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns DingBreakRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.DingBreakRes;

        /**
         * Verifies a DingBreakRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a DingBreakRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns DingBreakRes
         */
        public static fromObject(object: { [k: string]: any }): pb.DingBreakRes;

        /**
         * Creates a plain object from a DingBreakRes message. Also converts values to other types if specified.
         * @param message DingBreakRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.DingBreakRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this DingBreakRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a BuyAsk. */
    interface IBuyAsk {

        /** BuyAsk tpe */
        tpe?: number;

        /** BuyAsk idx */
        idx?: number;
    }

    /** Represents a BuyAsk. */
    class BuyAsk {

        /**
         * Constructs a new BuyAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IBuyAsk);

        /** BuyAsk tpe. */
        public tpe: number;

        /** BuyAsk idx. */
        public idx: number;

        /**
         * Creates a new BuyAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BuyAsk instance
         */
        public static create(properties?: pb.IBuyAsk): pb.BuyAsk;

        /**
         * Encodes the specified BuyAsk message. Does not implicitly {@link pb.BuyAsk.verify|verify} messages.
         * @param message BuyAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IBuyAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BuyAsk message, length delimited. Does not implicitly {@link pb.BuyAsk.verify|verify} messages.
         * @param message BuyAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IBuyAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BuyAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BuyAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.BuyAsk;

        /**
         * Decodes a BuyAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BuyAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.BuyAsk;

        /**
         * Verifies a BuyAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BuyAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BuyAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.BuyAsk;

        /**
         * Creates a plain object from a BuyAsk message. Also converts values to other types if specified.
         * @param message BuyAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.BuyAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BuyAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a QueryTimeAsk. */
    interface IQueryTimeAsk {

        /** QueryTimeAsk tpe */
        tpe?: number;
    }

    /** Represents a QueryTimeAsk. */
    class QueryTimeAsk {

        /**
         * Constructs a new QueryTimeAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IQueryTimeAsk);

        /** QueryTimeAsk tpe. */
        public tpe: number;

        /**
         * Creates a new QueryTimeAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns QueryTimeAsk instance
         */
        public static create(properties?: pb.IQueryTimeAsk): pb.QueryTimeAsk;

        /**
         * Encodes the specified QueryTimeAsk message. Does not implicitly {@link pb.QueryTimeAsk.verify|verify} messages.
         * @param message QueryTimeAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IQueryTimeAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified QueryTimeAsk message, length delimited. Does not implicitly {@link pb.QueryTimeAsk.verify|verify} messages.
         * @param message QueryTimeAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IQueryTimeAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a QueryTimeAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns QueryTimeAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.QueryTimeAsk;

        /**
         * Decodes a QueryTimeAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns QueryTimeAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.QueryTimeAsk;

        /**
         * Verifies a QueryTimeAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a QueryTimeAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns QueryTimeAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.QueryTimeAsk;

        /**
         * Creates a plain object from a QueryTimeAsk message. Also converts values to other types if specified.
         * @param message QueryTimeAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.QueryTimeAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this QueryTimeAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a QueryTimeRes. */
    interface IQueryTimeRes {
    }

    /** Represents a QueryTimeRes. */
    class QueryTimeRes {

        /**
         * Constructs a new QueryTimeRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IQueryTimeRes);

        /**
         * Creates a new QueryTimeRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns QueryTimeRes instance
         */
        public static create(properties?: pb.IQueryTimeRes): pb.QueryTimeRes;

        /**
         * Encodes the specified QueryTimeRes message. Does not implicitly {@link pb.QueryTimeRes.verify|verify} messages.
         * @param message QueryTimeRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IQueryTimeRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified QueryTimeRes message, length delimited. Does not implicitly {@link pb.QueryTimeRes.verify|verify} messages.
         * @param message QueryTimeRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IQueryTimeRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a QueryTimeRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns QueryTimeRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.QueryTimeRes;

        /**
         * Decodes a QueryTimeRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns QueryTimeRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.QueryTimeRes;

        /**
         * Verifies a QueryTimeRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a QueryTimeRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns QueryTimeRes
         */
        public static fromObject(object: { [k: string]: any }): pb.QueryTimeRes;

        /**
         * Creates a plain object from a QueryTimeRes message. Also converts values to other types if specified.
         * @param message QueryTimeRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.QueryTimeRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this QueryTimeRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a DoAsk. */
    interface IDoAsk {

        /** DoAsk tpe */
        tpe?: number;

        /** DoAsk idx */
        idx?: number;
    }

    /** Represents a DoAsk. */
    class DoAsk {

        /**
         * Constructs a new DoAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IDoAsk);

        /** DoAsk tpe. */
        public tpe: number;

        /** DoAsk idx. */
        public idx: number;

        /**
         * Creates a new DoAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns DoAsk instance
         */
        public static create(properties?: pb.IDoAsk): pb.DoAsk;

        /**
         * Encodes the specified DoAsk message. Does not implicitly {@link pb.DoAsk.verify|verify} messages.
         * @param message DoAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IDoAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified DoAsk message, length delimited. Does not implicitly {@link pb.DoAsk.verify|verify} messages.
         * @param message DoAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IDoAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a DoAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns DoAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.DoAsk;

        /**
         * Decodes a DoAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns DoAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.DoAsk;

        /**
         * Verifies a DoAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a DoAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns DoAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.DoAsk;

        /**
         * Creates a plain object from a DoAsk message. Also converts values to other types if specified.
         * @param message DoAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.DoAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this DoAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a DoRes. */
    interface IDoRes {
    }

    /** Represents a DoRes. */
    class DoRes {

        /**
         * Constructs a new DoRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IDoRes);

        /**
         * Creates a new DoRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns DoRes instance
         */
        public static create(properties?: pb.IDoRes): pb.DoRes;

        /**
         * Encodes the specified DoRes message. Does not implicitly {@link pb.DoRes.verify|verify} messages.
         * @param message DoRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IDoRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified DoRes message, length delimited. Does not implicitly {@link pb.DoRes.verify|verify} messages.
         * @param message DoRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IDoRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a DoRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns DoRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.DoRes;

        /**
         * Decodes a DoRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns DoRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.DoRes;

        /**
         * Verifies a DoRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a DoRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns DoRes
         */
        public static fromObject(object: { [k: string]: any }): pb.DoRes;

        /**
         * Creates a plain object from a DoRes message. Also converts values to other types if specified.
         * @param message DoRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.DoRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this DoRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a GoOutAsk. */
    interface IGoOutAsk {

        /** GoOutAsk index */
        index?: string;
    }

    /** Represents a GoOutAsk. */
    class GoOutAsk {

        /**
         * Constructs a new GoOutAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IGoOutAsk);

        /** GoOutAsk index. */
        public index: string;

        /**
         * Creates a new GoOutAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns GoOutAsk instance
         */
        public static create(properties?: pb.IGoOutAsk): pb.GoOutAsk;

        /**
         * Encodes the specified GoOutAsk message. Does not implicitly {@link pb.GoOutAsk.verify|verify} messages.
         * @param message GoOutAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IGoOutAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified GoOutAsk message, length delimited. Does not implicitly {@link pb.GoOutAsk.verify|verify} messages.
         * @param message GoOutAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IGoOutAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a GoOutAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns GoOutAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.GoOutAsk;

        /**
         * Decodes a GoOutAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns GoOutAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.GoOutAsk;

        /**
         * Verifies a GoOutAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a GoOutAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns GoOutAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.GoOutAsk;

        /**
         * Creates a plain object from a GoOutAsk message. Also converts values to other types if specified.
         * @param message GoOutAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.GoOutAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this GoOutAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a GoOutRes. */
    interface IGoOutRes {
    }

    /** Represents a GoOutRes. */
    class GoOutRes {

        /**
         * Constructs a new GoOutRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IGoOutRes);

        /**
         * Creates a new GoOutRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns GoOutRes instance
         */
        public static create(properties?: pb.IGoOutRes): pb.GoOutRes;

        /**
         * Encodes the specified GoOutRes message. Does not implicitly {@link pb.GoOutRes.verify|verify} messages.
         * @param message GoOutRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IGoOutRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified GoOutRes message, length delimited. Does not implicitly {@link pb.GoOutRes.verify|verify} messages.
         * @param message GoOutRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IGoOutRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a GoOutRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns GoOutRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.GoOutRes;

        /**
         * Decodes a GoOutRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns GoOutRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.GoOutRes;

        /**
         * Verifies a GoOutRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a GoOutRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns GoOutRes
         */
        public static fromObject(object: { [k: string]: any }): pb.GoOutRes;

        /**
         * Creates a plain object from a GoOutRes message. Also converts values to other types if specified.
         * @param message GoOutRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.GoOutRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this GoOutRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a FightBossAsk. */
    interface IFightBossAsk {
    }

    /** Represents a FightBossAsk. */
    class FightBossAsk {

        /**
         * Constructs a new FightBossAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IFightBossAsk);

        /**
         * Creates a new FightBossAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns FightBossAsk instance
         */
        public static create(properties?: pb.IFightBossAsk): pb.FightBossAsk;

        /**
         * Encodes the specified FightBossAsk message. Does not implicitly {@link pb.FightBossAsk.verify|verify} messages.
         * @param message FightBossAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IFightBossAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified FightBossAsk message, length delimited. Does not implicitly {@link pb.FightBossAsk.verify|verify} messages.
         * @param message FightBossAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IFightBossAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a FightBossAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns FightBossAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.FightBossAsk;

        /**
         * Decodes a FightBossAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns FightBossAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.FightBossAsk;

        /**
         * Verifies a FightBossAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a FightBossAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns FightBossAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.FightBossAsk;

        /**
         * Creates a plain object from a FightBossAsk message. Also converts values to other types if specified.
         * @param message FightBossAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.FightBossAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this FightBossAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a FightBossRes. */
    interface IFightBossRes {
    }

    /** Represents a FightBossRes. */
    class FightBossRes {

        /**
         * Constructs a new FightBossRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IFightBossRes);

        /**
         * Creates a new FightBossRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns FightBossRes instance
         */
        public static create(properties?: pb.IFightBossRes): pb.FightBossRes;

        /**
         * Encodes the specified FightBossRes message. Does not implicitly {@link pb.FightBossRes.verify|verify} messages.
         * @param message FightBossRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IFightBossRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified FightBossRes message, length delimited. Does not implicitly {@link pb.FightBossRes.verify|verify} messages.
         * @param message FightBossRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IFightBossRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a FightBossRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns FightBossRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.FightBossRes;

        /**
         * Decodes a FightBossRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns FightBossRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.FightBossRes;

        /**
         * Verifies a FightBossRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a FightBossRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns FightBossRes
         */
        public static fromObject(object: { [k: string]: any }): pb.FightBossRes;

        /**
         * Creates a plain object from a FightBossRes message. Also converts values to other types if specified.
         * @param message FightBossRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.FightBossRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this FightBossRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a PlayEffRes. */
    interface IPlayEffRes {

        /** PlayEffRes index */
        index?: number;

        /** PlayEffRes isMine */
        isMine?: boolean;

        /** PlayEffRes eff */
        eff?: string;
    }

    /** Represents a PlayEffRes. */
    class PlayEffRes {

        /**
         * Constructs a new PlayEffRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IPlayEffRes);

        /** PlayEffRes index. */
        public index: number;

        /** PlayEffRes isMine. */
        public isMine: boolean;

        /** PlayEffRes eff. */
        public eff: string;

        /**
         * Creates a new PlayEffRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns PlayEffRes instance
         */
        public static create(properties?: pb.IPlayEffRes): pb.PlayEffRes;

        /**
         * Encodes the specified PlayEffRes message. Does not implicitly {@link pb.PlayEffRes.verify|verify} messages.
         * @param message PlayEffRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IPlayEffRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified PlayEffRes message, length delimited. Does not implicitly {@link pb.PlayEffRes.verify|verify} messages.
         * @param message PlayEffRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IPlayEffRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a PlayEffRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns PlayEffRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.PlayEffRes;

        /**
         * Decodes a PlayEffRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns PlayEffRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.PlayEffRes;

        /**
         * Verifies a PlayEffRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a PlayEffRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns PlayEffRes
         */
        public static fromObject(object: { [k: string]: any }): pb.PlayEffRes;

        /**
         * Creates a plain object from a PlayEffRes message. Also converts values to other types if specified.
         * @param message PlayEffRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.PlayEffRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this PlayEffRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a PlayAniRes. */
    interface IPlayAniRes {

        /** PlayAniRes index */
        index?: number;

        /** PlayAniRes isMine */
        isMine?: boolean;

        /** PlayAniRes ani */
        ani?: number;
    }

    /** Represents a PlayAniRes. */
    class PlayAniRes {

        /**
         * Constructs a new PlayAniRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IPlayAniRes);

        /** PlayAniRes index. */
        public index: number;

        /** PlayAniRes isMine. */
        public isMine: boolean;

        /** PlayAniRes ani. */
        public ani: number;

        /**
         * Creates a new PlayAniRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns PlayAniRes instance
         */
        public static create(properties?: pb.IPlayAniRes): pb.PlayAniRes;

        /**
         * Encodes the specified PlayAniRes message. Does not implicitly {@link pb.PlayAniRes.verify|verify} messages.
         * @param message PlayAniRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IPlayAniRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified PlayAniRes message, length delimited. Does not implicitly {@link pb.PlayAniRes.verify|verify} messages.
         * @param message PlayAniRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IPlayAniRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a PlayAniRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns PlayAniRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.PlayAniRes;

        /**
         * Decodes a PlayAniRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns PlayAniRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.PlayAniRes;

        /**
         * Verifies a PlayAniRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a PlayAniRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns PlayAniRes
         */
        public static fromObject(object: { [k: string]: any }): pb.PlayAniRes;

        /**
         * Creates a plain object from a PlayAniRes message. Also converts values to other types if specified.
         * @param message PlayAniRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.PlayAniRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this PlayAniRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a PlayHudRes. */
    interface IPlayHudRes {

        /** PlayHudRes index */
        index?: number;

        /** PlayHudRes isMine */
        isMine?: boolean;

        /** PlayHudRes hud */
        hud?: number;

        /** PlayHudRes val */
        val?: number;
    }

    /** Represents a PlayHudRes. */
    class PlayHudRes {

        /**
         * Constructs a new PlayHudRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IPlayHudRes);

        /** PlayHudRes index. */
        public index: number;

        /** PlayHudRes isMine. */
        public isMine: boolean;

        /** PlayHudRes hud. */
        public hud: number;

        /** PlayHudRes val. */
        public val: number;

        /**
         * Creates a new PlayHudRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns PlayHudRes instance
         */
        public static create(properties?: pb.IPlayHudRes): pb.PlayHudRes;

        /**
         * Encodes the specified PlayHudRes message. Does not implicitly {@link pb.PlayHudRes.verify|verify} messages.
         * @param message PlayHudRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IPlayHudRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified PlayHudRes message, length delimited. Does not implicitly {@link pb.PlayHudRes.verify|verify} messages.
         * @param message PlayHudRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IPlayHudRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a PlayHudRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns PlayHudRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.PlayHudRes;

        /**
         * Decodes a PlayHudRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns PlayHudRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.PlayHudRes;

        /**
         * Verifies a PlayHudRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a PlayHudRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns PlayHudRes
         */
        public static fromObject(object: { [k: string]: any }): pb.PlayHudRes;

        /**
         * Creates a plain object from a PlayHudRes message. Also converts values to other types if specified.
         * @param message PlayHudRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.PlayHudRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this PlayHudRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a PlayBuffRes. */
    interface IPlayBuffRes {

        /** PlayBuffRes index */
        index?: number;

        /** PlayBuffRes isMine */
        isMine?: boolean;

        /** PlayBuffRes val */
        val?: number;

        /** PlayBuffRes isShow */
        isShow?: boolean;
    }

    /** Represents a PlayBuffRes. */
    class PlayBuffRes {

        /**
         * Constructs a new PlayBuffRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IPlayBuffRes);

        /** PlayBuffRes index. */
        public index: number;

        /** PlayBuffRes isMine. */
        public isMine: boolean;

        /** PlayBuffRes val. */
        public val: number;

        /** PlayBuffRes isShow. */
        public isShow: boolean;

        /**
         * Creates a new PlayBuffRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns PlayBuffRes instance
         */
        public static create(properties?: pb.IPlayBuffRes): pb.PlayBuffRes;

        /**
         * Encodes the specified PlayBuffRes message. Does not implicitly {@link pb.PlayBuffRes.verify|verify} messages.
         * @param message PlayBuffRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IPlayBuffRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified PlayBuffRes message, length delimited. Does not implicitly {@link pb.PlayBuffRes.verify|verify} messages.
         * @param message PlayBuffRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IPlayBuffRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a PlayBuffRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns PlayBuffRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.PlayBuffRes;

        /**
         * Decodes a PlayBuffRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns PlayBuffRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.PlayBuffRes;

        /**
         * Verifies a PlayBuffRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a PlayBuffRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns PlayBuffRes
         */
        public static fromObject(object: { [k: string]: any }): pb.PlayBuffRes;

        /**
         * Creates a plain object from a PlayBuffRes message. Also converts values to other types if specified.
         * @param message PlayBuffRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.PlayBuffRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this PlayBuffRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a DoRenWuRes. */
    interface IDoRenWuRes {

        /** DoRenWuRes tag */
        tag?: string;

        /** DoRenWuRes num */
        num?: number;

        /** DoRenWuRes id */
        id?: boolean;
    }

    /** Represents a DoRenWuRes. */
    class DoRenWuRes {

        /**
         * Constructs a new DoRenWuRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IDoRenWuRes);

        /** DoRenWuRes tag. */
        public tag: string;

        /** DoRenWuRes num. */
        public num: number;

        /** DoRenWuRes id. */
        public id: boolean;

        /**
         * Creates a new DoRenWuRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns DoRenWuRes instance
         */
        public static create(properties?: pb.IDoRenWuRes): pb.DoRenWuRes;

        /**
         * Encodes the specified DoRenWuRes message. Does not implicitly {@link pb.DoRenWuRes.verify|verify} messages.
         * @param message DoRenWuRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IDoRenWuRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified DoRenWuRes message, length delimited. Does not implicitly {@link pb.DoRenWuRes.verify|verify} messages.
         * @param message DoRenWuRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IDoRenWuRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a DoRenWuRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns DoRenWuRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.DoRenWuRes;

        /**
         * Decodes a DoRenWuRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns DoRenWuRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.DoRenWuRes;

        /**
         * Verifies a DoRenWuRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a DoRenWuRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns DoRenWuRes
         */
        public static fromObject(object: { [k: string]: any }): pb.DoRenWuRes;

        /**
         * Creates a plain object from a DoRenWuRes message. Also converts values to other types if specified.
         * @param message DoRenWuRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.DoRenWuRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this DoRenWuRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a DayLiBaoRes. */
    interface IDayLiBaoRes {

        /** DayLiBaoRes res */
        res?: boolean;
    }

    /** Represents a DayLiBaoRes. */
    class DayLiBaoRes {

        /**
         * Constructs a new DayLiBaoRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IDayLiBaoRes);

        /** DayLiBaoRes res. */
        public res: boolean;

        /**
         * Creates a new DayLiBaoRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns DayLiBaoRes instance
         */
        public static create(properties?: pb.IDayLiBaoRes): pb.DayLiBaoRes;

        /**
         * Encodes the specified DayLiBaoRes message. Does not implicitly {@link pb.DayLiBaoRes.verify|verify} messages.
         * @param message DayLiBaoRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IDayLiBaoRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified DayLiBaoRes message, length delimited. Does not implicitly {@link pb.DayLiBaoRes.verify|verify} messages.
         * @param message DayLiBaoRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IDayLiBaoRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a DayLiBaoRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns DayLiBaoRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.DayLiBaoRes;

        /**
         * Decodes a DayLiBaoRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns DayLiBaoRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.DayLiBaoRes;

        /**
         * Verifies a DayLiBaoRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a DayLiBaoRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns DayLiBaoRes
         */
        public static fromObject(object: { [k: string]: any }): pb.DayLiBaoRes;

        /**
         * Creates a plain object from a DayLiBaoRes message. Also converts values to other types if specified.
         * @param message DayLiBaoRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.DayLiBaoRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this DayLiBaoRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a XinShouAsk. */
    interface IXinShouAsk {
    }

    /** Represents a XinShouAsk. */
    class XinShouAsk {

        /**
         * Constructs a new XinShouAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IXinShouAsk);

        /**
         * Creates a new XinShouAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns XinShouAsk instance
         */
        public static create(properties?: pb.IXinShouAsk): pb.XinShouAsk;

        /**
         * Encodes the specified XinShouAsk message. Does not implicitly {@link pb.XinShouAsk.verify|verify} messages.
         * @param message XinShouAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IXinShouAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified XinShouAsk message, length delimited. Does not implicitly {@link pb.XinShouAsk.verify|verify} messages.
         * @param message XinShouAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IXinShouAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a XinShouAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns XinShouAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.XinShouAsk;

        /**
         * Decodes a XinShouAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns XinShouAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.XinShouAsk;

        /**
         * Verifies a XinShouAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a XinShouAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns XinShouAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.XinShouAsk;

        /**
         * Creates a plain object from a XinShouAsk message. Also converts values to other types if specified.
         * @param message XinShouAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.XinShouAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this XinShouAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a XinShouRes. */
    interface IXinShouRes {
    }

    /** Represents a XinShouRes. */
    class XinShouRes {

        /**
         * Constructs a new XinShouRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IXinShouRes);

        /**
         * Creates a new XinShouRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns XinShouRes instance
         */
        public static create(properties?: pb.IXinShouRes): pb.XinShouRes;

        /**
         * Encodes the specified XinShouRes message. Does not implicitly {@link pb.XinShouRes.verify|verify} messages.
         * @param message XinShouRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IXinShouRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified XinShouRes message, length delimited. Does not implicitly {@link pb.XinShouRes.verify|verify} messages.
         * @param message XinShouRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IXinShouRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a XinShouRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns XinShouRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.XinShouRes;

        /**
         * Decodes a XinShouRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns XinShouRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.XinShouRes;

        /**
         * Verifies a XinShouRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a XinShouRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns XinShouRes
         */
        public static fromObject(object: { [k: string]: any }): pb.XinShouRes;

        /**
         * Creates a plain object from a XinShouRes message. Also converts values to other types if specified.
         * @param message XinShouRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.XinShouRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this XinShouRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an HongBaoOutRes. */
    interface IHongBaoOutRes {

        /** HongBaoOutRes index */
        index?: number;
    }

    /** Represents an HongBaoOutRes. */
    class HongBaoOutRes {

        /**
         * Constructs a new HongBaoOutRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IHongBaoOutRes);

        /** HongBaoOutRes index. */
        public index: number;

        /**
         * Creates a new HongBaoOutRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns HongBaoOutRes instance
         */
        public static create(properties?: pb.IHongBaoOutRes): pb.HongBaoOutRes;

        /**
         * Encodes the specified HongBaoOutRes message. Does not implicitly {@link pb.HongBaoOutRes.verify|verify} messages.
         * @param message HongBaoOutRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IHongBaoOutRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified HongBaoOutRes message, length delimited. Does not implicitly {@link pb.HongBaoOutRes.verify|verify} messages.
         * @param message HongBaoOutRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IHongBaoOutRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an HongBaoOutRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns HongBaoOutRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.HongBaoOutRes;

        /**
         * Decodes an HongBaoOutRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns HongBaoOutRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.HongBaoOutRes;

        /**
         * Verifies an HongBaoOutRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an HongBaoOutRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns HongBaoOutRes
         */
        public static fromObject(object: { [k: string]: any }): pb.HongBaoOutRes;

        /**
         * Creates a plain object from an HongBaoOutRes message. Also converts values to other types if specified.
         * @param message HongBaoOutRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.HongBaoOutRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this HongBaoOutRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an HongBaoAsk. */
    interface IHongBaoAsk {

        /** HongBaoAsk index */
        index?: number;
    }

    /** Represents an HongBaoAsk. */
    class HongBaoAsk {

        /**
         * Constructs a new HongBaoAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IHongBaoAsk);

        /** HongBaoAsk index. */
        public index: number;

        /**
         * Creates a new HongBaoAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns HongBaoAsk instance
         */
        public static create(properties?: pb.IHongBaoAsk): pb.HongBaoAsk;

        /**
         * Encodes the specified HongBaoAsk message. Does not implicitly {@link pb.HongBaoAsk.verify|verify} messages.
         * @param message HongBaoAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IHongBaoAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified HongBaoAsk message, length delimited. Does not implicitly {@link pb.HongBaoAsk.verify|verify} messages.
         * @param message HongBaoAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IHongBaoAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an HongBaoAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns HongBaoAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.HongBaoAsk;

        /**
         * Decodes an HongBaoAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns HongBaoAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.HongBaoAsk;

        /**
         * Verifies an HongBaoAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an HongBaoAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns HongBaoAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.HongBaoAsk;

        /**
         * Creates a plain object from an HongBaoAsk message. Also converts values to other types if specified.
         * @param message HongBaoAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.HongBaoAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this HongBaoAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an HongBaoRes. */
    interface IHongBaoRes {

        /** HongBaoRes res */
        res?: number;
    }

    /** Represents an HongBaoRes. */
    class HongBaoRes {

        /**
         * Constructs a new HongBaoRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IHongBaoRes);

        /** HongBaoRes res. */
        public res: number;

        /**
         * Creates a new HongBaoRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns HongBaoRes instance
         */
        public static create(properties?: pb.IHongBaoRes): pb.HongBaoRes;

        /**
         * Encodes the specified HongBaoRes message. Does not implicitly {@link pb.HongBaoRes.verify|verify} messages.
         * @param message HongBaoRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IHongBaoRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified HongBaoRes message, length delimited. Does not implicitly {@link pb.HongBaoRes.verify|verify} messages.
         * @param message HongBaoRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IHongBaoRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an HongBaoRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns HongBaoRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.HongBaoRes;

        /**
         * Decodes an HongBaoRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns HongBaoRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.HongBaoRes;

        /**
         * Verifies an HongBaoRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an HongBaoRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns HongBaoRes
         */
        public static fromObject(object: { [k: string]: any }): pb.HongBaoRes;

        /**
         * Creates a plain object from an HongBaoRes message. Also converts values to other types if specified.
         * @param message HongBaoRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.HongBaoRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this HongBaoRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an OpenMenuRes. */
    interface IOpenMenuRes {

        /** OpenMenuRes menu */
        menu?: string;
    }

    /** Represents an OpenMenuRes. */
    class OpenMenuRes {

        /**
         * Constructs a new OpenMenuRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IOpenMenuRes);

        /** OpenMenuRes menu. */
        public menu: string;

        /**
         * Creates a new OpenMenuRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns OpenMenuRes instance
         */
        public static create(properties?: pb.IOpenMenuRes): pb.OpenMenuRes;

        /**
         * Encodes the specified OpenMenuRes message. Does not implicitly {@link pb.OpenMenuRes.verify|verify} messages.
         * @param message OpenMenuRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IOpenMenuRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified OpenMenuRes message, length delimited. Does not implicitly {@link pb.OpenMenuRes.verify|verify} messages.
         * @param message OpenMenuRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IOpenMenuRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an OpenMenuRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns OpenMenuRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.OpenMenuRes;

        /**
         * Decodes an OpenMenuRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns OpenMenuRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.OpenMenuRes;

        /**
         * Verifies an OpenMenuRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an OpenMenuRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns OpenMenuRes
         */
        public static fromObject(object: { [k: string]: any }): pb.OpenMenuRes;

        /**
         * Creates a plain object from an OpenMenuRes message. Also converts values to other types if specified.
         * @param message OpenMenuRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.OpenMenuRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this OpenMenuRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Sync enum. */
    enum Sync {
        Add = 0,
        Set = 1,
        Del = 2,
        Swp = 3,
        Sort = 4
    }

    /** Properties of a Property. */
    interface IProperty {

        /** Property vType */
        vType?: number;

        /** Property valInt */
        valInt?: number;

        /** Property valUint64 */
        valUint64?: (number|Long);

        /** Property valBool */
        valBool?: boolean;

        /** Property valFloat */
        valFloat?: number;

        /** Property valString */
        valString?: string;

        /** Property lst */
        lst?: pb.IProperty[];

        /** Property map */
        map?: { [k: string]: pb.IProperty };
    }

    /** Represents a Property. */
    class Property {

        /**
         * Constructs a new Property.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IProperty);

        /** Property vType. */
        public vType: number;

        /** Property valInt. */
        public valInt: number;

        /** Property valUint64. */
        public valUint64: (number|Long);

        /** Property valBool. */
        public valBool: boolean;

        /** Property valFloat. */
        public valFloat: number;

        /** Property valString. */
        public valString: string;

        /** Property lst. */
        public lst: pb.IProperty[];

        /** Property map. */
        public map: { [k: string]: pb.IProperty };

        /**
         * Creates a new Property instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Property instance
         */
        public static create(properties?: pb.IProperty): pb.Property;

        /**
         * Encodes the specified Property message. Does not implicitly {@link pb.Property.verify|verify} messages.
         * @param message Property message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IProperty, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified Property message, length delimited. Does not implicitly {@link pb.Property.verify|verify} messages.
         * @param message Property message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IProperty, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a Property message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Property
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.Property;

        /**
         * Decodes a Property message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Property
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.Property;

        /**
         * Verifies a Property message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a Property message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Property
         */
        public static fromObject(object: { [k: string]: any }): pb.Property;

        /**
         * Creates a plain object from a Property message. Also converts values to other types if specified.
         * @param message Property
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.Property, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Property to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a PropertyDown. */
    interface IPropertyDown {

        /** PropertyDown key */
        key?: string[];

        /** PropertyDown pro */
        pro?: pb.IProperty;
    }

    /** Represents a PropertyDown. */
    class PropertyDown {

        /**
         * Constructs a new PropertyDown.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IPropertyDown);

        /** PropertyDown key. */
        public key: string[];

        /** PropertyDown pro. */
        public pro?: (pb.IProperty|null);

        /**
         * Creates a new PropertyDown instance using the specified properties.
         * @param [properties] Properties to set
         * @returns PropertyDown instance
         */
        public static create(properties?: pb.IPropertyDown): pb.PropertyDown;

        /**
         * Encodes the specified PropertyDown message. Does not implicitly {@link pb.PropertyDown.verify|verify} messages.
         * @param message PropertyDown message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IPropertyDown, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified PropertyDown message, length delimited. Does not implicitly {@link pb.PropertyDown.verify|verify} messages.
         * @param message PropertyDown message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IPropertyDown, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a PropertyDown message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns PropertyDown
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.PropertyDown;

        /**
         * Decodes a PropertyDown message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns PropertyDown
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.PropertyDown;

        /**
         * Verifies a PropertyDown message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a PropertyDown message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns PropertyDown
         */
        public static fromObject(object: { [k: string]: any }): pb.PropertyDown;

        /**
         * Creates a plain object from a PropertyDown message. Also converts values to other types if specified.
         * @param message PropertyDown
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.PropertyDown, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this PropertyDown to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an AddLastPro. */
    interface IAddLastPro {

        /** AddLastPro key */
        key?: string[];

        /** AddLastPro pro */
        pro?: pb.IProperty;
    }

    /** Represents an AddLastPro. */
    class AddLastPro {

        /**
         * Constructs a new AddLastPro.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IAddLastPro);

        /** AddLastPro key. */
        public key: string[];

        /** AddLastPro pro. */
        public pro?: (pb.IProperty|null);

        /**
         * Creates a new AddLastPro instance using the specified properties.
         * @param [properties] Properties to set
         * @returns AddLastPro instance
         */
        public static create(properties?: pb.IAddLastPro): pb.AddLastPro;

        /**
         * Encodes the specified AddLastPro message. Does not implicitly {@link pb.AddLastPro.verify|verify} messages.
         * @param message AddLastPro message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IAddLastPro, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified AddLastPro message, length delimited. Does not implicitly {@link pb.AddLastPro.verify|verify} messages.
         * @param message AddLastPro message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IAddLastPro, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an AddLastPro message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns AddLastPro
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.AddLastPro;

        /**
         * Decodes an AddLastPro message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns AddLastPro
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.AddLastPro;

        /**
         * Verifies an AddLastPro message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an AddLastPro message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns AddLastPro
         */
        public static fromObject(object: { [k: string]: any }): pb.AddLastPro;

        /**
         * Creates a plain object from an AddLastPro message. Also converts values to other types if specified.
         * @param message AddLastPro
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.AddLastPro, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this AddLastPro to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a RemoveProAt. */
    interface IRemoveProAt {

        /** RemoveProAt key */
        key?: string[];

        /** RemoveProAt index */
        index?: number;
    }

    /** Represents a RemoveProAt. */
    class RemoveProAt {

        /**
         * Constructs a new RemoveProAt.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IRemoveProAt);

        /** RemoveProAt key. */
        public key: string[];

        /** RemoveProAt index. */
        public index: number;

        /**
         * Creates a new RemoveProAt instance using the specified properties.
         * @param [properties] Properties to set
         * @returns RemoveProAt instance
         */
        public static create(properties?: pb.IRemoveProAt): pb.RemoveProAt;

        /**
         * Encodes the specified RemoveProAt message. Does not implicitly {@link pb.RemoveProAt.verify|verify} messages.
         * @param message RemoveProAt message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IRemoveProAt, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified RemoveProAt message, length delimited. Does not implicitly {@link pb.RemoveProAt.verify|verify} messages.
         * @param message RemoveProAt message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IRemoveProAt, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a RemoveProAt message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns RemoveProAt
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.RemoveProAt;

        /**
         * Decodes a RemoveProAt message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns RemoveProAt
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.RemoveProAt;

        /**
         * Verifies a RemoveProAt message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a RemoveProAt message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns RemoveProAt
         */
        public static fromObject(object: { [k: string]: any }): pb.RemoveProAt;

        /**
         * Creates a plain object from a RemoveProAt message. Also converts values to other types if specified.
         * @param message RemoveProAt
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.RemoveProAt, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this RemoveProAt to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an AddMapPro. */
    interface IAddMapPro {

        /** AddMapPro key */
        key?: string[];

        /** AddMapPro k */
        k?: string;

        /** AddMapPro pro */
        pro?: pb.IProperty;
    }

    /** Represents an AddMapPro. */
    class AddMapPro {

        /**
         * Constructs a new AddMapPro.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IAddMapPro);

        /** AddMapPro key. */
        public key: string[];

        /** AddMapPro k. */
        public k: string;

        /** AddMapPro pro. */
        public pro?: (pb.IProperty|null);

        /**
         * Creates a new AddMapPro instance using the specified properties.
         * @param [properties] Properties to set
         * @returns AddMapPro instance
         */
        public static create(properties?: pb.IAddMapPro): pb.AddMapPro;

        /**
         * Encodes the specified AddMapPro message. Does not implicitly {@link pb.AddMapPro.verify|verify} messages.
         * @param message AddMapPro message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IAddMapPro, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified AddMapPro message, length delimited. Does not implicitly {@link pb.AddMapPro.verify|verify} messages.
         * @param message AddMapPro message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IAddMapPro, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an AddMapPro message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns AddMapPro
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.AddMapPro;

        /**
         * Decodes an AddMapPro message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns AddMapPro
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.AddMapPro;

        /**
         * Verifies an AddMapPro message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an AddMapPro message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns AddMapPro
         */
        public static fromObject(object: { [k: string]: any }): pb.AddMapPro;

        /**
         * Creates a plain object from an AddMapPro message. Also converts values to other types if specified.
         * @param message AddMapPro
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.AddMapPro, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this AddMapPro to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a DelMapPro. */
    interface IDelMapPro {

        /** DelMapPro key */
        key?: string[];

        /** DelMapPro k */
        k?: string;
    }

    /** Represents a DelMapPro. */
    class DelMapPro {

        /**
         * Constructs a new DelMapPro.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IDelMapPro);

        /** DelMapPro key. */
        public key: string[];

        /** DelMapPro k. */
        public k: string;

        /**
         * Creates a new DelMapPro instance using the specified properties.
         * @param [properties] Properties to set
         * @returns DelMapPro instance
         */
        public static create(properties?: pb.IDelMapPro): pb.DelMapPro;

        /**
         * Encodes the specified DelMapPro message. Does not implicitly {@link pb.DelMapPro.verify|verify} messages.
         * @param message DelMapPro message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IDelMapPro, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified DelMapPro message, length delimited. Does not implicitly {@link pb.DelMapPro.verify|verify} messages.
         * @param message DelMapPro message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IDelMapPro, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a DelMapPro message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns DelMapPro
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.DelMapPro;

        /**
         * Decodes a DelMapPro message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns DelMapPro
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.DelMapPro;

        /**
         * Verifies a DelMapPro message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a DelMapPro message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns DelMapPro
         */
        public static fromObject(object: { [k: string]: any }): pb.DelMapPro;

        /**
         * Creates a plain object from a DelMapPro message. Also converts values to other types if specified.
         * @param message DelMapPro
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.DelMapPro, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this DelMapPro to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** LoginEnum enum. */
    enum LoginEnum {
        VerifyOK = 0,
        DataException = 1,
        AccountBlocked = 2,
        GameUserFull = 3
    }

    /** Properties of a LoginAsk. */
    interface ILoginAsk {

        /** LoginAsk account */
        account?: string;

        /** LoginAsk code */
        code?: string;

        /** LoginAsk token */
        token?: string;
    }

    /** Represents a LoginAsk. */
    class LoginAsk {

        /**
         * Constructs a new LoginAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ILoginAsk);

        /** LoginAsk account. */
        public account: string;

        /** LoginAsk code. */
        public code: string;

        /** LoginAsk token. */
        public token: string;

        /**
         * Creates a new LoginAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns LoginAsk instance
         */
        public static create(properties?: pb.ILoginAsk): pb.LoginAsk;

        /**
         * Encodes the specified LoginAsk message. Does not implicitly {@link pb.LoginAsk.verify|verify} messages.
         * @param message LoginAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ILoginAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified LoginAsk message, length delimited. Does not implicitly {@link pb.LoginAsk.verify|verify} messages.
         * @param message LoginAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ILoginAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a LoginAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns LoginAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.LoginAsk;

        /**
         * Decodes a LoginAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns LoginAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.LoginAsk;

        /**
         * Verifies a LoginAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a LoginAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns LoginAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.LoginAsk;

        /**
         * Creates a plain object from a LoginAsk message. Also converts values to other types if specified.
         * @param message LoginAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.LoginAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this LoginAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a QuDaoLoginAsk. */
    interface IQuDaoLoginAsk {

        /** QuDaoLoginAsk quDao */
        quDao?: string;

        /** QuDaoLoginAsk code */
        code?: string;

        /** QuDaoLoginAsk openid */
        openid?: string;

        /** QuDaoLoginAsk openkey */
        openkey?: string;

        /** QuDaoLoginAsk pf */
        pf?: string;

        /** QuDaoLoginAsk platform */
        platform?: string;
    }

    /** Represents a QuDaoLoginAsk. */
    class QuDaoLoginAsk {

        /**
         * Constructs a new QuDaoLoginAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IQuDaoLoginAsk);

        /** QuDaoLoginAsk quDao. */
        public quDao: string;

        /** QuDaoLoginAsk code. */
        public code: string;

        /** QuDaoLoginAsk openid. */
        public openid: string;

        /** QuDaoLoginAsk openkey. */
        public openkey: string;

        /** QuDaoLoginAsk pf. */
        public pf: string;

        /** QuDaoLoginAsk platform. */
        public platform: string;

        /**
         * Creates a new QuDaoLoginAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns QuDaoLoginAsk instance
         */
        public static create(properties?: pb.IQuDaoLoginAsk): pb.QuDaoLoginAsk;

        /**
         * Encodes the specified QuDaoLoginAsk message. Does not implicitly {@link pb.QuDaoLoginAsk.verify|verify} messages.
         * @param message QuDaoLoginAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IQuDaoLoginAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified QuDaoLoginAsk message, length delimited. Does not implicitly {@link pb.QuDaoLoginAsk.verify|verify} messages.
         * @param message QuDaoLoginAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IQuDaoLoginAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a QuDaoLoginAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns QuDaoLoginAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.QuDaoLoginAsk;

        /**
         * Decodes a QuDaoLoginAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns QuDaoLoginAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.QuDaoLoginAsk;

        /**
         * Verifies a QuDaoLoginAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a QuDaoLoginAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns QuDaoLoginAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.QuDaoLoginAsk;

        /**
         * Creates a plain object from a QuDaoLoginAsk message. Also converts values to other types if specified.
         * @param message QuDaoLoginAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.QuDaoLoginAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this QuDaoLoginAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a LoginRes. */
    interface ILoginRes {

        /** LoginRes res */
        res?: pb.LoginEnum;
    }

    /** Represents a LoginRes. */
    class LoginRes {

        /**
         * Constructs a new LoginRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ILoginRes);

        /** LoginRes res. */
        public res: pb.LoginEnum;

        /**
         * Creates a new LoginRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns LoginRes instance
         */
        public static create(properties?: pb.ILoginRes): pb.LoginRes;

        /**
         * Encodes the specified LoginRes message. Does not implicitly {@link pb.LoginRes.verify|verify} messages.
         * @param message LoginRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ILoginRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified LoginRes message, length delimited. Does not implicitly {@link pb.LoginRes.verify|verify} messages.
         * @param message LoginRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ILoginRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a LoginRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns LoginRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.LoginRes;

        /**
         * Decodes a LoginRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns LoginRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.LoginRes;

        /**
         * Verifies a LoginRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a LoginRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns LoginRes
         */
        public static fromObject(object: { [k: string]: any }): pb.LoginRes;

        /**
         * Creates a plain object from a LoginRes message. Also converts values to other types if specified.
         * @param message LoginRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.LoginRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this LoginRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ServerRes. */
    interface IServerRes {

        /** ServerRes ModelID */
        ModelID?: string;

        /** ServerRes ModelDelete */
        ModelDelete?: boolean;

        /** ServerRes DisplayName */
        DisplayName?: string;

        /** ServerRes Address */
        Address?: string;
    }

    /** Represents a ServerRes. */
    class ServerRes {

        /**
         * Constructs a new ServerRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IServerRes);

        /** ServerRes ModelID. */
        public ModelID: string;

        /** ServerRes ModelDelete. */
        public ModelDelete: boolean;

        /** ServerRes DisplayName. */
        public DisplayName: string;

        /** ServerRes Address. */
        public Address: string;

        /**
         * Creates a new ServerRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ServerRes instance
         */
        public static create(properties?: pb.IServerRes): pb.ServerRes;

        /**
         * Encodes the specified ServerRes message. Does not implicitly {@link pb.ServerRes.verify|verify} messages.
         * @param message ServerRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IServerRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ServerRes message, length delimited. Does not implicitly {@link pb.ServerRes.verify|verify} messages.
         * @param message ServerRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IServerRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ServerRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ServerRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.ServerRes;

        /**
         * Decodes a ServerRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ServerRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.ServerRes;

        /**
         * Verifies a ServerRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ServerRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ServerRes
         */
        public static fromObject(object: { [k: string]: any }): pb.ServerRes;

        /**
         * Creates a plain object from a ServerRes message. Also converts values to other types if specified.
         * @param message ServerRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.ServerRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ServerRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ServersRes. */
    interface IServersRes {

        /** ServersRes Servers */
        Servers?: pb.IServerRes[];
    }

    /** Represents a ServersRes. */
    class ServersRes {

        /**
         * Constructs a new ServersRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IServersRes);

        /** ServersRes Servers. */
        public Servers: pb.IServerRes[];

        /**
         * Creates a new ServersRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ServersRes instance
         */
        public static create(properties?: pb.IServersRes): pb.ServersRes;

        /**
         * Encodes the specified ServersRes message. Does not implicitly {@link pb.ServersRes.verify|verify} messages.
         * @param message ServersRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IServersRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ServersRes message, length delimited. Does not implicitly {@link pb.ServersRes.verify|verify} messages.
         * @param message ServersRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IServersRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ServersRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ServersRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.ServersRes;

        /**
         * Decodes a ServersRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ServersRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.ServersRes;

        /**
         * Verifies a ServersRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ServersRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ServersRes
         */
        public static fromObject(object: { [k: string]: any }): pb.ServersRes;

        /**
         * Creates a plain object from a ServersRes message. Also converts values to other types if specified.
         * @param message ServersRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.ServersRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ServersRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a Qu. */
    interface IQu {

        /** Qu id */
        id?: number;

        /** Qu name */
        name?: string;

        /** Qu addr */
        addr?: string;

        /** Qu gm */
        gm?: string;

        /** Qu pid */
        pid?: number;

        /** Qu enable */
        enable?: boolean;

        /** Qu path */
        path?: string;

        /** Qu exe */
        exe?: string;

        /** Qu addr2 */
        addr2?: string;

        /** Qu gm2 */
        gm2?: string;

        /** Qu num */
        num?: number;
    }

    /** Represents a Qu. */
    class Qu {

        /**
         * Constructs a new Qu.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IQu);

        /** Qu id. */
        public id: number;

        /** Qu name. */
        public name: string;

        /** Qu addr. */
        public addr: string;

        /** Qu gm. */
        public gm: string;

        /** Qu pid. */
        public pid: number;

        /** Qu enable. */
        public enable: boolean;

        /** Qu path. */
        public path: string;

        /** Qu exe. */
        public exe: string;

        /** Qu addr2. */
        public addr2: string;

        /** Qu gm2. */
        public gm2: string;

        /** Qu num. */
        public num: number;

        /**
         * Creates a new Qu instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Qu instance
         */
        public static create(properties?: pb.IQu): pb.Qu;

        /**
         * Encodes the specified Qu message. Does not implicitly {@link pb.Qu.verify|verify} messages.
         * @param message Qu message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IQu, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified Qu message, length delimited. Does not implicitly {@link pb.Qu.verify|verify} messages.
         * @param message Qu message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IQu, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a Qu message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Qu
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.Qu;

        /**
         * Decodes a Qu message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Qu
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.Qu;

        /**
         * Verifies a Qu message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a Qu message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Qu
         */
        public static fromObject(object: { [k: string]: any }): pb.Qu;

        /**
         * Creates a plain object from a Qu message. Also converts values to other types if specified.
         * @param message Qu
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.Qu, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Qu to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a QuDao. */
    interface IQuDao {

        /** QuDao name */
        name?: string;

        /** QuDao qus */
        qus?: pb.IQu[];

        /** QuDao qqQun */
        qqQun?: string;

        /** QuDao num */
        num?: number;
    }

    /** Represents a QuDao. */
    class QuDao {

        /**
         * Constructs a new QuDao.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IQuDao);

        /** QuDao name. */
        public name: string;

        /** QuDao qus. */
        public qus: pb.IQu[];

        /** QuDao qqQun. */
        public qqQun: string;

        /** QuDao num. */
        public num: number;

        /**
         * Creates a new QuDao instance using the specified properties.
         * @param [properties] Properties to set
         * @returns QuDao instance
         */
        public static create(properties?: pb.IQuDao): pb.QuDao;

        /**
         * Encodes the specified QuDao message. Does not implicitly {@link pb.QuDao.verify|verify} messages.
         * @param message QuDao message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IQuDao, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified QuDao message, length delimited. Does not implicitly {@link pb.QuDao.verify|verify} messages.
         * @param message QuDao message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IQuDao, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a QuDao message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns QuDao
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.QuDao;

        /**
         * Decodes a QuDao message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns QuDao
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.QuDao;

        /**
         * Verifies a QuDao message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a QuDao message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns QuDao
         */
        public static fromObject(object: { [k: string]: any }): pb.QuDao;

        /**
         * Creates a plain object from a QuDao message. Also converts values to other types if specified.
         * @param message QuDao
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.QuDao, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this QuDao to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a YouXi. */
    interface IYouXi {

        /** YouXi name */
        name?: string;

        /** YouXi quDaoMap */
        quDaoMap?: { [k: string]: pb.IQuDao };

        /** YouXi num */
        num?: number;
    }

    /** Represents a YouXi. */
    class YouXi {

        /**
         * Constructs a new YouXi.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IYouXi);

        /** YouXi name. */
        public name: string;

        /** YouXi quDaoMap. */
        public quDaoMap: { [k: string]: pb.IQuDao };

        /** YouXi num. */
        public num: number;

        /**
         * Creates a new YouXi instance using the specified properties.
         * @param [properties] Properties to set
         * @returns YouXi instance
         */
        public static create(properties?: pb.IYouXi): pb.YouXi;

        /**
         * Encodes the specified YouXi message. Does not implicitly {@link pb.YouXi.verify|verify} messages.
         * @param message YouXi message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IYouXi, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified YouXi message, length delimited. Does not implicitly {@link pb.YouXi.verify|verify} messages.
         * @param message YouXi message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IYouXi, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a YouXi message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns YouXi
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.YouXi;

        /**
         * Decodes a YouXi message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns YouXi
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.YouXi;

        /**
         * Verifies a YouXi message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a YouXi message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns YouXi
         */
        public static fromObject(object: { [k: string]: any }): pb.YouXi;

        /**
         * Creates a plain object from a YouXi message. Also converts values to other types if specified.
         * @param message YouXi
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.YouXi, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this YouXi to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a YouXis. */
    interface IYouXis {

        /** YouXis accId */
        accId?: string;

        /** YouXis gameMap */
        gameMap?: { [k: string]: pb.IYouXi };
    }

    /** Represents a YouXis. */
    class YouXis {

        /**
         * Constructs a new YouXis.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IYouXis);

        /** YouXis accId. */
        public accId: string;

        /** YouXis gameMap. */
        public gameMap: { [k: string]: pb.IYouXi };

        /**
         * Creates a new YouXis instance using the specified properties.
         * @param [properties] Properties to set
         * @returns YouXis instance
         */
        public static create(properties?: pb.IYouXis): pb.YouXis;

        /**
         * Encodes the specified YouXis message. Does not implicitly {@link pb.YouXis.verify|verify} messages.
         * @param message YouXis message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IYouXis, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified YouXis message, length delimited. Does not implicitly {@link pb.YouXis.verify|verify} messages.
         * @param message YouXis message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IYouXis, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a YouXis message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns YouXis
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.YouXis;

        /**
         * Decodes a YouXis message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns YouXis
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.YouXis;

        /**
         * Verifies a YouXis message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a YouXis message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns YouXis
         */
        public static fromObject(object: { [k: string]: any }): pb.YouXis;

        /**
         * Creates a plain object from a YouXis message. Also converts values to other types if specified.
         * @param message YouXis
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.YouXis, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this YouXis to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a YouXiChange. */
    interface IYouXiChange {

        /** YouXiChange nameOld */
        nameOld?: string;

        /** YouXiChange yx */
        yx?: pb.IYouXi;
    }

    /** Represents a YouXiChange. */
    class YouXiChange {

        /**
         * Constructs a new YouXiChange.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IYouXiChange);

        /** YouXiChange nameOld. */
        public nameOld: string;

        /** YouXiChange yx. */
        public yx?: (pb.IYouXi|null);

        /**
         * Creates a new YouXiChange instance using the specified properties.
         * @param [properties] Properties to set
         * @returns YouXiChange instance
         */
        public static create(properties?: pb.IYouXiChange): pb.YouXiChange;

        /**
         * Encodes the specified YouXiChange message. Does not implicitly {@link pb.YouXiChange.verify|verify} messages.
         * @param message YouXiChange message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IYouXiChange, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified YouXiChange message, length delimited. Does not implicitly {@link pb.YouXiChange.verify|verify} messages.
         * @param message YouXiChange message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IYouXiChange, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a YouXiChange message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns YouXiChange
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.YouXiChange;

        /**
         * Decodes a YouXiChange message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns YouXiChange
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.YouXiChange;

        /**
         * Verifies a YouXiChange message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a YouXiChange message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns YouXiChange
         */
        public static fromObject(object: { [k: string]: any }): pb.YouXiChange;

        /**
         * Creates a plain object from a YouXiChange message. Also converts values to other types if specified.
         * @param message YouXiChange
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.YouXiChange, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this YouXiChange to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a YouXiDel. */
    interface IYouXiDel {

        /** YouXiDel name */
        name?: string;
    }

    /** Represents a YouXiDel. */
    class YouXiDel {

        /**
         * Constructs a new YouXiDel.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IYouXiDel);

        /** YouXiDel name. */
        public name: string;

        /**
         * Creates a new YouXiDel instance using the specified properties.
         * @param [properties] Properties to set
         * @returns YouXiDel instance
         */
        public static create(properties?: pb.IYouXiDel): pb.YouXiDel;

        /**
         * Encodes the specified YouXiDel message. Does not implicitly {@link pb.YouXiDel.verify|verify} messages.
         * @param message YouXiDel message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IYouXiDel, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified YouXiDel message, length delimited. Does not implicitly {@link pb.YouXiDel.verify|verify} messages.
         * @param message YouXiDel message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IYouXiDel, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a YouXiDel message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns YouXiDel
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.YouXiDel;

        /**
         * Decodes a YouXiDel message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns YouXiDel
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.YouXiDel;

        /**
         * Verifies a YouXiDel message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a YouXiDel message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns YouXiDel
         */
        public static fromObject(object: { [k: string]: any }): pb.YouXiDel;

        /**
         * Creates a plain object from a YouXiDel message. Also converts values to other types if specified.
         * @param message YouXiDel
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.YouXiDel, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this YouXiDel to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ResString. */
    interface IResString {

        /** ResString res */
        res?: string;
    }

    /** Represents a ResString. */
    class ResString {

        /**
         * Constructs a new ResString.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IResString);

        /** ResString res. */
        public res: string;

        /**
         * Creates a new ResString instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ResString instance
         */
        public static create(properties?: pb.IResString): pb.ResString;

        /**
         * Encodes the specified ResString message. Does not implicitly {@link pb.ResString.verify|verify} messages.
         * @param message ResString message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IResString, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ResString message, length delimited. Does not implicitly {@link pb.ResString.verify|verify} messages.
         * @param message ResString message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IResString, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ResString message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ResString
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.ResString;

        /**
         * Decodes a ResString message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ResString
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.ResString;

        /**
         * Verifies a ResString message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ResString message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ResString
         */
        public static fromObject(object: { [k: string]: any }): pb.ResString;

        /**
         * Creates a plain object from a ResString message. Also converts values to other types if specified.
         * @param message ResString
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.ResString, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ResString to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a GiveItem. */
    interface IGiveItem {

        /** GiveItem roleId */
        roleId?: string;

        /** GiveItem title */
        title?: string;

        /** GiveItem content */
        content?: string;

        /** GiveItem items */
        items?: string;

        /** GiveItem game */
        game?: string;

        /** GiveItem qd */
        qd?: string;

        /** GiveItem qu */
        qu?: number;

        /** GiveItem isAll */
        isAll?: boolean;
    }

    /** Represents a GiveItem. */
    class GiveItem {

        /**
         * Constructs a new GiveItem.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IGiveItem);

        /** GiveItem roleId. */
        public roleId: string;

        /** GiveItem title. */
        public title: string;

        /** GiveItem content. */
        public content: string;

        /** GiveItem items. */
        public items: string;

        /** GiveItem game. */
        public game: string;

        /** GiveItem qd. */
        public qd: string;

        /** GiveItem qu. */
        public qu: number;

        /** GiveItem isAll. */
        public isAll: boolean;

        /**
         * Creates a new GiveItem instance using the specified properties.
         * @param [properties] Properties to set
         * @returns GiveItem instance
         */
        public static create(properties?: pb.IGiveItem): pb.GiveItem;

        /**
         * Encodes the specified GiveItem message. Does not implicitly {@link pb.GiveItem.verify|verify} messages.
         * @param message GiveItem message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IGiveItem, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified GiveItem message, length delimited. Does not implicitly {@link pb.GiveItem.verify|verify} messages.
         * @param message GiveItem message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IGiveItem, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a GiveItem message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns GiveItem
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.GiveItem;

        /**
         * Decodes a GiveItem message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns GiveItem
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.GiveItem;

        /**
         * Verifies a GiveItem message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a GiveItem message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns GiveItem
         */
        public static fromObject(object: { [k: string]: any }): pb.GiveItem;

        /**
         * Creates a plain object from a GiveItem message. Also converts values to other types if specified.
         * @param message GiveItem
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.GiveItem, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this GiveItem to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a GiveLiBao. */
    interface IGiveLiBao {

        /** GiveLiBao roleId */
        roleId?: string;

        /** GiveLiBao liBaoId */
        liBaoId?: number;

        /** GiveLiBao game */
        game?: string;

        /** GiveLiBao qd */
        qd?: string;

        /** GiveLiBao qu */
        qu?: number;

        /** GiveLiBao isAll */
        isAll?: boolean;
    }

    /** Represents a GiveLiBao. */
    class GiveLiBao {

        /**
         * Constructs a new GiveLiBao.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IGiveLiBao);

        /** GiveLiBao roleId. */
        public roleId: string;

        /** GiveLiBao liBaoId. */
        public liBaoId: number;

        /** GiveLiBao game. */
        public game: string;

        /** GiveLiBao qd. */
        public qd: string;

        /** GiveLiBao qu. */
        public qu: number;

        /** GiveLiBao isAll. */
        public isAll: boolean;

        /**
         * Creates a new GiveLiBao instance using the specified properties.
         * @param [properties] Properties to set
         * @returns GiveLiBao instance
         */
        public static create(properties?: pb.IGiveLiBao): pb.GiveLiBao;

        /**
         * Encodes the specified GiveLiBao message. Does not implicitly {@link pb.GiveLiBao.verify|verify} messages.
         * @param message GiveLiBao message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IGiveLiBao, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified GiveLiBao message, length delimited. Does not implicitly {@link pb.GiveLiBao.verify|verify} messages.
         * @param message GiveLiBao message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IGiveLiBao, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a GiveLiBao message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns GiveLiBao
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.GiveLiBao;

        /**
         * Decodes a GiveLiBao message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns GiveLiBao
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.GiveLiBao;

        /**
         * Verifies a GiveLiBao message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a GiveLiBao message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns GiveLiBao
         */
        public static fromObject(object: { [k: string]: any }): pb.GiveLiBao;

        /**
         * Creates a plain object from a GiveLiBao message. Also converts values to other types if specified.
         * @param message GiveLiBao
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.GiveLiBao, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this GiveLiBao to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a Look. */
    interface ILook {

        /** Look game */
        game?: string;

        /** Look qd */
        qd?: string;
    }

    /** Represents a Look. */
    class Look {

        /**
         * Constructs a new Look.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ILook);

        /** Look game. */
        public game: string;

        /** Look qd. */
        public qd: string;

        /**
         * Creates a new Look instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Look instance
         */
        public static create(properties?: pb.ILook): pb.Look;

        /**
         * Encodes the specified Look message. Does not implicitly {@link pb.Look.verify|verify} messages.
         * @param message Look message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ILook, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified Look message, length delimited. Does not implicitly {@link pb.Look.verify|verify} messages.
         * @param message Look message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ILook, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a Look message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Look
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.Look;

        /**
         * Decodes a Look message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Look
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.Look;

        /**
         * Verifies a Look message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a Look message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Look
         */
        public static fromObject(object: { [k: string]: any }): pb.Look;

        /**
         * Creates a plain object from a Look message. Also converts values to other types if specified.
         * @param message Look
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.Look, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Look to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an OpenQu. */
    interface IOpenQu {

        /** OpenQu game */
        game?: string;

        /** OpenQu qd */
        qd?: string;

        /** OpenQu qu */
        qu?: number;

        /** OpenQu isAll */
        isAll?: boolean;
    }

    /** Represents an OpenQu. */
    class OpenQu {

        /**
         * Constructs a new OpenQu.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IOpenQu);

        /** OpenQu game. */
        public game: string;

        /** OpenQu qd. */
        public qd: string;

        /** OpenQu qu. */
        public qu: number;

        /** OpenQu isAll. */
        public isAll: boolean;

        /**
         * Creates a new OpenQu instance using the specified properties.
         * @param [properties] Properties to set
         * @returns OpenQu instance
         */
        public static create(properties?: pb.IOpenQu): pb.OpenQu;

        /**
         * Encodes the specified OpenQu message. Does not implicitly {@link pb.OpenQu.verify|verify} messages.
         * @param message OpenQu message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IOpenQu, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified OpenQu message, length delimited. Does not implicitly {@link pb.OpenQu.verify|verify} messages.
         * @param message OpenQu message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IOpenQu, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an OpenQu message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns OpenQu
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.OpenQu;

        /**
         * Decodes an OpenQu message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns OpenQu
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.OpenQu;

        /**
         * Verifies an OpenQu message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an OpenQu message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns OpenQu
         */
        public static fromObject(object: { [k: string]: any }): pb.OpenQu;

        /**
         * Creates a plain object from an OpenQu message. Also converts values to other types if specified.
         * @param message OpenQu
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.OpenQu, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this OpenQu to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a CloseQu. */
    interface ICloseQu {

        /** CloseQu game */
        game?: string;

        /** CloseQu qd */
        qd?: string;

        /** CloseQu qu */
        qu?: number;

        /** CloseQu isAll */
        isAll?: boolean;
    }

    /** Represents a CloseQu. */
    class CloseQu {

        /**
         * Constructs a new CloseQu.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ICloseQu);

        /** CloseQu game. */
        public game: string;

        /** CloseQu qd. */
        public qd: string;

        /** CloseQu qu. */
        public qu: number;

        /** CloseQu isAll. */
        public isAll: boolean;

        /**
         * Creates a new CloseQu instance using the specified properties.
         * @param [properties] Properties to set
         * @returns CloseQu instance
         */
        public static create(properties?: pb.ICloseQu): pb.CloseQu;

        /**
         * Encodes the specified CloseQu message. Does not implicitly {@link pb.CloseQu.verify|verify} messages.
         * @param message CloseQu message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ICloseQu, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified CloseQu message, length delimited. Does not implicitly {@link pb.CloseQu.verify|verify} messages.
         * @param message CloseQu message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ICloseQu, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a CloseQu message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns CloseQu
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.CloseQu;

        /**
         * Decodes a CloseQu message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns CloseQu
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.CloseQu;

        /**
         * Verifies a CloseQu message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a CloseQu message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns CloseQu
         */
        public static fromObject(object: { [k: string]: any }): pb.CloseQu;

        /**
         * Creates a plain object from a CloseQu message. Also converts values to other types if specified.
         * @param message CloseQu
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.CloseQu, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this CloseQu to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a GuangBo. */
    interface IGuangBo {

        /** GuangBo game */
        game?: string;

        /** GuangBo qd */
        qd?: string;

        /** GuangBo qu */
        qu?: number;

        /** GuangBo isAll */
        isAll?: boolean;

        /** GuangBo content */
        content?: string;
    }

    /** Represents a GuangBo. */
    class GuangBo {

        /**
         * Constructs a new GuangBo.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IGuangBo);

        /** GuangBo game. */
        public game: string;

        /** GuangBo qd. */
        public qd: string;

        /** GuangBo qu. */
        public qu: number;

        /** GuangBo isAll. */
        public isAll: boolean;

        /** GuangBo content. */
        public content: string;

        /**
         * Creates a new GuangBo instance using the specified properties.
         * @param [properties] Properties to set
         * @returns GuangBo instance
         */
        public static create(properties?: pb.IGuangBo): pb.GuangBo;

        /**
         * Encodes the specified GuangBo message. Does not implicitly {@link pb.GuangBo.verify|verify} messages.
         * @param message GuangBo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IGuangBo, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified GuangBo message, length delimited. Does not implicitly {@link pb.GuangBo.verify|verify} messages.
         * @param message GuangBo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IGuangBo, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a GuangBo message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns GuangBo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.GuangBo;

        /**
         * Decodes a GuangBo message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns GuangBo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.GuangBo;

        /**
         * Verifies a GuangBo message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a GuangBo message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns GuangBo
         */
        public static fromObject(object: { [k: string]: any }): pb.GuangBo;

        /**
         * Creates a plain object from a GuangBo message. Also converts values to other types if specified.
         * @param message GuangBo
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.GuangBo, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this GuangBo to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TongJiDayAsk. */
    interface ITongJiDayAsk {

        /** TongJiDayAsk start */
        start?: string;

        /** TongJiDayAsk end */
        end?: string;

        /** TongJiDayAsk game */
        game?: string;

        /** TongJiDayAsk qd */
        qd?: string;

        /** TongJiDayAsk qu */
        qu?: number;
    }

    /** Represents a TongJiDayAsk. */
    class TongJiDayAsk {

        /**
         * Constructs a new TongJiDayAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ITongJiDayAsk);

        /** TongJiDayAsk start. */
        public start: string;

        /** TongJiDayAsk end. */
        public end: string;

        /** TongJiDayAsk game. */
        public game: string;

        /** TongJiDayAsk qd. */
        public qd: string;

        /** TongJiDayAsk qu. */
        public qu: number;

        /**
         * Creates a new TongJiDayAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TongJiDayAsk instance
         */
        public static create(properties?: pb.ITongJiDayAsk): pb.TongJiDayAsk;

        /**
         * Encodes the specified TongJiDayAsk message. Does not implicitly {@link pb.TongJiDayAsk.verify|verify} messages.
         * @param message TongJiDayAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ITongJiDayAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TongJiDayAsk message, length delimited. Does not implicitly {@link pb.TongJiDayAsk.verify|verify} messages.
         * @param message TongJiDayAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ITongJiDayAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TongJiDayAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TongJiDayAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.TongJiDayAsk;

        /**
         * Decodes a TongJiDayAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TongJiDayAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.TongJiDayAsk;

        /**
         * Verifies a TongJiDayAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TongJiDayAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TongJiDayAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.TongJiDayAsk;

        /**
         * Creates a plain object from a TongJiDayAsk message. Also converts values to other types if specified.
         * @param message TongJiDayAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.TongJiDayAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TongJiDayAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TongJiMongXiAsk. */
    interface ITongJiMongXiAsk {

        /** TongJiMongXiAsk game */
        game?: string;

        /** TongJiMongXiAsk qd */
        qd?: string;

        /** TongJiMongXiAsk qu */
        qu?: number;
    }

    /** Represents a TongJiMongXiAsk. */
    class TongJiMongXiAsk {

        /**
         * Constructs a new TongJiMongXiAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ITongJiMongXiAsk);

        /** TongJiMongXiAsk game. */
        public game: string;

        /** TongJiMongXiAsk qd. */
        public qd: string;

        /** TongJiMongXiAsk qu. */
        public qu: number;

        /**
         * Creates a new TongJiMongXiAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TongJiMongXiAsk instance
         */
        public static create(properties?: pb.ITongJiMongXiAsk): pb.TongJiMongXiAsk;

        /**
         * Encodes the specified TongJiMongXiAsk message. Does not implicitly {@link pb.TongJiMongXiAsk.verify|verify} messages.
         * @param message TongJiMongXiAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ITongJiMongXiAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TongJiMongXiAsk message, length delimited. Does not implicitly {@link pb.TongJiMongXiAsk.verify|verify} messages.
         * @param message TongJiMongXiAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ITongJiMongXiAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TongJiMongXiAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TongJiMongXiAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.TongJiMongXiAsk;

        /**
         * Decodes a TongJiMongXiAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TongJiMongXiAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.TongJiMongXiAsk;

        /**
         * Verifies a TongJiMongXiAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TongJiMongXiAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TongJiMongXiAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.TongJiMongXiAsk;

        /**
         * Creates a plain object from a TongJiMongXiAsk message. Also converts values to other types if specified.
         * @param message TongJiMongXiAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.TongJiMongXiAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TongJiMongXiAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TongJiBangAsk. */
    interface ITongJiBangAsk {

        /** TongJiBangAsk game */
        game?: string;

        /** TongJiBangAsk qd */
        qd?: string;

        /** TongJiBangAsk qu */
        qu?: number;
    }

    /** Represents a TongJiBangAsk. */
    class TongJiBangAsk {

        /**
         * Constructs a new TongJiBangAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ITongJiBangAsk);

        /** TongJiBangAsk game. */
        public game: string;

        /** TongJiBangAsk qd. */
        public qd: string;

        /** TongJiBangAsk qu. */
        public qu: number;

        /**
         * Creates a new TongJiBangAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TongJiBangAsk instance
         */
        public static create(properties?: pb.ITongJiBangAsk): pb.TongJiBangAsk;

        /**
         * Encodes the specified TongJiBangAsk message. Does not implicitly {@link pb.TongJiBangAsk.verify|verify} messages.
         * @param message TongJiBangAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ITongJiBangAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TongJiBangAsk message, length delimited. Does not implicitly {@link pb.TongJiBangAsk.verify|verify} messages.
         * @param message TongJiBangAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ITongJiBangAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TongJiBangAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TongJiBangAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.TongJiBangAsk;

        /**
         * Decodes a TongJiBangAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TongJiBangAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.TongJiBangAsk;

        /**
         * Verifies a TongJiBangAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TongJiBangAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TongJiBangAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.TongJiBangAsk;

        /**
         * Creates a plain object from a TongJiBangAsk message. Also converts values to other types if specified.
         * @param message TongJiBangAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.TongJiBangAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TongJiBangAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TongJiShiXiAsk. */
    interface ITongJiShiXiAsk {

        /** TongJiShiXiAsk game */
        game?: string;

        /** TongJiShiXiAsk qd */
        qd?: string;

        /** TongJiShiXiAsk qu */
        qu?: number;
    }

    /** Represents a TongJiShiXiAsk. */
    class TongJiShiXiAsk {

        /**
         * Constructs a new TongJiShiXiAsk.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ITongJiShiXiAsk);

        /** TongJiShiXiAsk game. */
        public game: string;

        /** TongJiShiXiAsk qd. */
        public qd: string;

        /** TongJiShiXiAsk qu. */
        public qu: number;

        /**
         * Creates a new TongJiShiXiAsk instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TongJiShiXiAsk instance
         */
        public static create(properties?: pb.ITongJiShiXiAsk): pb.TongJiShiXiAsk;

        /**
         * Encodes the specified TongJiShiXiAsk message. Does not implicitly {@link pb.TongJiShiXiAsk.verify|verify} messages.
         * @param message TongJiShiXiAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ITongJiShiXiAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TongJiShiXiAsk message, length delimited. Does not implicitly {@link pb.TongJiShiXiAsk.verify|verify} messages.
         * @param message TongJiShiXiAsk message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ITongJiShiXiAsk, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TongJiShiXiAsk message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TongJiShiXiAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.TongJiShiXiAsk;

        /**
         * Decodes a TongJiShiXiAsk message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TongJiShiXiAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.TongJiShiXiAsk;

        /**
         * Verifies a TongJiShiXiAsk message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TongJiShiXiAsk message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TongJiShiXiAsk
         */
        public static fromObject(object: { [k: string]: any }): pb.TongJiShiXiAsk;

        /**
         * Creates a plain object from a TongJiShiXiAsk message. Also converts values to other types if specified.
         * @param message TongJiShiXiAsk
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.TongJiShiXiAsk, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TongJiShiXiAsk to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TongJiDayRes. */
    interface ITongJiDayRes {

        /** TongJiDayRes game */
        game?: string;

        /** TongJiDayRes qd */
        qd?: string;

        /** TongJiDayRes qu */
        qu?: number;

        /** TongJiDayRes tjs */
        tjs?: pb.IDayTongJi[];
    }

    /** Represents a TongJiDayRes. */
    class TongJiDayRes {

        /**
         * Constructs a new TongJiDayRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ITongJiDayRes);

        /** TongJiDayRes game. */
        public game: string;

        /** TongJiDayRes qd. */
        public qd: string;

        /** TongJiDayRes qu. */
        public qu: number;

        /** TongJiDayRes tjs. */
        public tjs: pb.IDayTongJi[];

        /**
         * Creates a new TongJiDayRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TongJiDayRes instance
         */
        public static create(properties?: pb.ITongJiDayRes): pb.TongJiDayRes;

        /**
         * Encodes the specified TongJiDayRes message. Does not implicitly {@link pb.TongJiDayRes.verify|verify} messages.
         * @param message TongJiDayRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ITongJiDayRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TongJiDayRes message, length delimited. Does not implicitly {@link pb.TongJiDayRes.verify|verify} messages.
         * @param message TongJiDayRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ITongJiDayRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TongJiDayRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TongJiDayRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.TongJiDayRes;

        /**
         * Decodes a TongJiDayRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TongJiDayRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.TongJiDayRes;

        /**
         * Verifies a TongJiDayRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TongJiDayRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TongJiDayRes
         */
        public static fromObject(object: { [k: string]: any }): pb.TongJiDayRes;

        /**
         * Creates a plain object from a TongJiDayRes message. Also converts values to other types if specified.
         * @param message TongJiDayRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.TongJiDayRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TongJiDayRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TongJiMongXiRes. */
    interface ITongJiMongXiRes {

        /** TongJiMongXiRes game */
        game?: string;

        /** TongJiMongXiRes qd */
        qd?: string;

        /** TongJiMongXiRes qu */
        qu?: number;

        /** TongJiMongXiRes mxs */
        mxs?: pb.IMoneyXi[];
    }

    /** Represents a TongJiMongXiRes. */
    class TongJiMongXiRes {

        /**
         * Constructs a new TongJiMongXiRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ITongJiMongXiRes);

        /** TongJiMongXiRes game. */
        public game: string;

        /** TongJiMongXiRes qd. */
        public qd: string;

        /** TongJiMongXiRes qu. */
        public qu: number;

        /** TongJiMongXiRes mxs. */
        public mxs: pb.IMoneyXi[];

        /**
         * Creates a new TongJiMongXiRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TongJiMongXiRes instance
         */
        public static create(properties?: pb.ITongJiMongXiRes): pb.TongJiMongXiRes;

        /**
         * Encodes the specified TongJiMongXiRes message. Does not implicitly {@link pb.TongJiMongXiRes.verify|verify} messages.
         * @param message TongJiMongXiRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ITongJiMongXiRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TongJiMongXiRes message, length delimited. Does not implicitly {@link pb.TongJiMongXiRes.verify|verify} messages.
         * @param message TongJiMongXiRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ITongJiMongXiRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TongJiMongXiRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TongJiMongXiRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.TongJiMongXiRes;

        /**
         * Decodes a TongJiMongXiRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TongJiMongXiRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.TongJiMongXiRes;

        /**
         * Verifies a TongJiMongXiRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TongJiMongXiRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TongJiMongXiRes
         */
        public static fromObject(object: { [k: string]: any }): pb.TongJiMongXiRes;

        /**
         * Creates a plain object from a TongJiMongXiRes message. Also converts values to other types if specified.
         * @param message TongJiMongXiRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.TongJiMongXiRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TongJiMongXiRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TongJiBangRes. */
    interface ITongJiBangRes {

        /** TongJiBangRes game */
        game?: string;

        /** TongJiBangRes qd */
        qd?: string;

        /** TongJiBangRes qu */
        qu?: number;

        /** TongJiBangRes bangs */
        bangs?: pb.IMoneyBang[];
    }

    /** Represents a TongJiBangRes. */
    class TongJiBangRes {

        /**
         * Constructs a new TongJiBangRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ITongJiBangRes);

        /** TongJiBangRes game. */
        public game: string;

        /** TongJiBangRes qd. */
        public qd: string;

        /** TongJiBangRes qu. */
        public qu: number;

        /** TongJiBangRes bangs. */
        public bangs: pb.IMoneyBang[];

        /**
         * Creates a new TongJiBangRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TongJiBangRes instance
         */
        public static create(properties?: pb.ITongJiBangRes): pb.TongJiBangRes;

        /**
         * Encodes the specified TongJiBangRes message. Does not implicitly {@link pb.TongJiBangRes.verify|verify} messages.
         * @param message TongJiBangRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ITongJiBangRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TongJiBangRes message, length delimited. Does not implicitly {@link pb.TongJiBangRes.verify|verify} messages.
         * @param message TongJiBangRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ITongJiBangRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TongJiBangRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TongJiBangRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.TongJiBangRes;

        /**
         * Decodes a TongJiBangRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TongJiBangRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.TongJiBangRes;

        /**
         * Verifies a TongJiBangRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TongJiBangRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TongJiBangRes
         */
        public static fromObject(object: { [k: string]: any }): pb.TongJiBangRes;

        /**
         * Creates a plain object from a TongJiBangRes message. Also converts values to other types if specified.
         * @param message TongJiBangRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.TongJiBangRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TongJiBangRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TongJiShiXiRes. */
    interface ITongJiShiXiRes {

        /** TongJiShiXiRes game */
        game?: string;

        /** TongJiShiXiRes qd */
        qd?: string;

        /** TongJiShiXiRes qu */
        qu?: number;

        /** TongJiShiXiRes shiXs */
        shiXs?: pb.IShiXi[];
    }

    /** Represents a TongJiShiXiRes. */
    class TongJiShiXiRes {

        /**
         * Constructs a new TongJiShiXiRes.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ITongJiShiXiRes);

        /** TongJiShiXiRes game. */
        public game: string;

        /** TongJiShiXiRes qd. */
        public qd: string;

        /** TongJiShiXiRes qu. */
        public qu: number;

        /** TongJiShiXiRes shiXs. */
        public shiXs: pb.IShiXi[];

        /**
         * Creates a new TongJiShiXiRes instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TongJiShiXiRes instance
         */
        public static create(properties?: pb.ITongJiShiXiRes): pb.TongJiShiXiRes;

        /**
         * Encodes the specified TongJiShiXiRes message. Does not implicitly {@link pb.TongJiShiXiRes.verify|verify} messages.
         * @param message TongJiShiXiRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ITongJiShiXiRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TongJiShiXiRes message, length delimited. Does not implicitly {@link pb.TongJiShiXiRes.verify|verify} messages.
         * @param message TongJiShiXiRes message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ITongJiShiXiRes, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TongJiShiXiRes message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TongJiShiXiRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.TongJiShiXiRes;

        /**
         * Decodes a TongJiShiXiRes message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TongJiShiXiRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.TongJiShiXiRes;

        /**
         * Verifies a TongJiShiXiRes message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TongJiShiXiRes message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TongJiShiXiRes
         */
        public static fromObject(object: { [k: string]: any }): pb.TongJiShiXiRes;

        /**
         * Creates a plain object from a TongJiShiXiRes message. Also converts values to other types if specified.
         * @param message TongJiShiXiRes
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.TongJiShiXiRes, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TongJiShiXiRes to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a DayTongJi. */
    interface IDayTongJi {

        /** DayTongJi day */
        day?: string;

        /** DayTongJi peopleAdd */
        peopleAdd?: number;

        /** DayTongJi liu */
        liu?: number;

        /** DayTongJi liu1 */
        liu1?: number;

        /** DayTongJi liu3 */
        liu3?: number;

        /** DayTongJi liu7 */
        liu7?: number;

        /** DayTongJi moneyNew */
        moneyNew?: number;

        /** DayTongJi moneyDay */
        moneyDay?: number;

        /** DayTongJi moneyAll */
        moneyAll?: number;

        /** DayTongJi moneyNewRen */
        moneyNewRen?: number;

        /** DayTongJi moneyDayRen */
        moneyDayRen?: number;
    }

    /** Represents a DayTongJi. */
    class DayTongJi {

        /**
         * Constructs a new DayTongJi.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IDayTongJi);

        /** DayTongJi day. */
        public day: string;

        /** DayTongJi peopleAdd. */
        public peopleAdd: number;

        /** DayTongJi liu. */
        public liu: number;

        /** DayTongJi liu1. */
        public liu1: number;

        /** DayTongJi liu3. */
        public liu3: number;

        /** DayTongJi liu7. */
        public liu7: number;

        /** DayTongJi moneyNew. */
        public moneyNew: number;

        /** DayTongJi moneyDay. */
        public moneyDay: number;

        /** DayTongJi moneyAll. */
        public moneyAll: number;

        /** DayTongJi moneyNewRen. */
        public moneyNewRen: number;

        /** DayTongJi moneyDayRen. */
        public moneyDayRen: number;

        /**
         * Creates a new DayTongJi instance using the specified properties.
         * @param [properties] Properties to set
         * @returns DayTongJi instance
         */
        public static create(properties?: pb.IDayTongJi): pb.DayTongJi;

        /**
         * Encodes the specified DayTongJi message. Does not implicitly {@link pb.DayTongJi.verify|verify} messages.
         * @param message DayTongJi message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IDayTongJi, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified DayTongJi message, length delimited. Does not implicitly {@link pb.DayTongJi.verify|verify} messages.
         * @param message DayTongJi message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IDayTongJi, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a DayTongJi message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns DayTongJi
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.DayTongJi;

        /**
         * Decodes a DayTongJi message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns DayTongJi
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.DayTongJi;

        /**
         * Verifies a DayTongJi message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a DayTongJi message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns DayTongJi
         */
        public static fromObject(object: { [k: string]: any }): pb.DayTongJi;

        /**
         * Creates a plain object from a DayTongJi message. Also converts values to other types if specified.
         * @param message DayTongJi
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.DayTongJi, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this DayTongJi to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a MoneyXi. */
    interface IMoneyXi {

        /** MoneyXi tile */
        tile?: string;

        /** MoneyXi num */
        num?: number;

        /** MoneyXi money */
        money?: number;
    }

    /** Represents a MoneyXi. */
    class MoneyXi {

        /**
         * Constructs a new MoneyXi.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IMoneyXi);

        /** MoneyXi tile. */
        public tile: string;

        /** MoneyXi num. */
        public num: number;

        /** MoneyXi money. */
        public money: number;

        /**
         * Creates a new MoneyXi instance using the specified properties.
         * @param [properties] Properties to set
         * @returns MoneyXi instance
         */
        public static create(properties?: pb.IMoneyXi): pb.MoneyXi;

        /**
         * Encodes the specified MoneyXi message. Does not implicitly {@link pb.MoneyXi.verify|verify} messages.
         * @param message MoneyXi message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IMoneyXi, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified MoneyXi message, length delimited. Does not implicitly {@link pb.MoneyXi.verify|verify} messages.
         * @param message MoneyXi message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IMoneyXi, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a MoneyXi message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns MoneyXi
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.MoneyXi;

        /**
         * Decodes a MoneyXi message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns MoneyXi
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.MoneyXi;

        /**
         * Verifies a MoneyXi message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a MoneyXi message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns MoneyXi
         */
        public static fromObject(object: { [k: string]: any }): pb.MoneyXi;

        /**
         * Creates a plain object from a MoneyXi message. Also converts values to other types if specified.
         * @param message MoneyXi
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.MoneyXi, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this MoneyXi to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a MoneyBang. */
    interface IMoneyBang {

        /** MoneyBang accId */
        accId?: string;

        /** MoneyBang money */
        money?: number;

        /** MoneyBang name */
        name?: string;
    }

    /** Represents a MoneyBang. */
    class MoneyBang {

        /**
         * Constructs a new MoneyBang.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IMoneyBang);

        /** MoneyBang accId. */
        public accId: string;

        /** MoneyBang money. */
        public money: number;

        /** MoneyBang name. */
        public name: string;

        /**
         * Creates a new MoneyBang instance using the specified properties.
         * @param [properties] Properties to set
         * @returns MoneyBang instance
         */
        public static create(properties?: pb.IMoneyBang): pb.MoneyBang;

        /**
         * Encodes the specified MoneyBang message. Does not implicitly {@link pb.MoneyBang.verify|verify} messages.
         * @param message MoneyBang message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IMoneyBang, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified MoneyBang message, length delimited. Does not implicitly {@link pb.MoneyBang.verify|verify} messages.
         * @param message MoneyBang message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IMoneyBang, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a MoneyBang message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns MoneyBang
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.MoneyBang;

        /**
         * Decodes a MoneyBang message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns MoneyBang
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.MoneyBang;

        /**
         * Verifies a MoneyBang message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a MoneyBang message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns MoneyBang
         */
        public static fromObject(object: { [k: string]: any }): pb.MoneyBang;

        /**
         * Creates a plain object from a MoneyBang message. Also converts values to other types if specified.
         * @param message MoneyBang
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.MoneyBang, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this MoneyBang to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ZaiXians. */
    interface IZaiXians {

        /** ZaiXians game */
        game?: string;
    }

    /** Represents a ZaiXians. */
    class ZaiXians {

        /**
         * Constructs a new ZaiXians.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IZaiXians);

        /** ZaiXians game. */
        public game: string;

        /**
         * Creates a new ZaiXians instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ZaiXians instance
         */
        public static create(properties?: pb.IZaiXians): pb.ZaiXians;

        /**
         * Encodes the specified ZaiXians message. Does not implicitly {@link pb.ZaiXians.verify|verify} messages.
         * @param message ZaiXians message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IZaiXians, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ZaiXians message, length delimited. Does not implicitly {@link pb.ZaiXians.verify|verify} messages.
         * @param message ZaiXians message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IZaiXians, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ZaiXians message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ZaiXians
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.ZaiXians;

        /**
         * Decodes a ZaiXians message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ZaiXians
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.ZaiXians;

        /**
         * Verifies a ZaiXians message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ZaiXians message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ZaiXians
         */
        public static fromObject(object: { [k: string]: any }): pb.ZaiXians;

        /**
         * Creates a plain object from a ZaiXians message. Also converts values to other types if specified.
         * @param message ZaiXians
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.ZaiXians, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ZaiXians to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ZaiXian. */
    interface IZaiXian {

        /** ZaiXian game */
        game?: string;

        /** ZaiXian qd */
        qd?: string;

        /** ZaiXian qu */
        qu?: number;

        /** ZaiXian num */
        num?: number;
    }

    /** Represents a ZaiXian. */
    class ZaiXian {

        /**
         * Constructs a new ZaiXian.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IZaiXian);

        /** ZaiXian game. */
        public game: string;

        /** ZaiXian qd. */
        public qd: string;

        /** ZaiXian qu. */
        public qu: number;

        /** ZaiXian num. */
        public num: number;

        /**
         * Creates a new ZaiXian instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ZaiXian instance
         */
        public static create(properties?: pb.IZaiXian): pb.ZaiXian;

        /**
         * Encodes the specified ZaiXian message. Does not implicitly {@link pb.ZaiXian.verify|verify} messages.
         * @param message ZaiXian message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IZaiXian, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ZaiXian message, length delimited. Does not implicitly {@link pb.ZaiXian.verify|verify} messages.
         * @param message ZaiXian message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IZaiXian, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ZaiXian message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ZaiXian
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.ZaiXian;

        /**
         * Decodes a ZaiXian message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ZaiXian
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.ZaiXian;

        /**
         * Verifies a ZaiXian message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ZaiXian message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ZaiXian
         */
        public static fromObject(object: { [k: string]: any }): pb.ZaiXian;

        /**
         * Creates a plain object from a ZaiXian message. Also converts values to other types if specified.
         * @param message ZaiXian
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.ZaiXian, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ZaiXian to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ShiXi. */
    interface IShiXi {

        /** ShiXi tile */
        tile?: string;

        /** ShiXi num */
        num?: number;

        /** ShiXi shi */
        shi?: number;
    }

    /** Represents a ShiXi. */
    class ShiXi {

        /**
         * Constructs a new ShiXi.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.IShiXi);

        /** ShiXi tile. */
        public tile: string;

        /** ShiXi num. */
        public num: number;

        /** ShiXi shi. */
        public shi: number;

        /**
         * Creates a new ShiXi instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ShiXi instance
         */
        public static create(properties?: pb.IShiXi): pb.ShiXi;

        /**
         * Encodes the specified ShiXi message. Does not implicitly {@link pb.ShiXi.verify|verify} messages.
         * @param message ShiXi message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.IShiXi, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ShiXi message, length delimited. Does not implicitly {@link pb.ShiXi.verify|verify} messages.
         * @param message ShiXi message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.IShiXi, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ShiXi message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ShiXi
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.ShiXi;

        /**
         * Decodes a ShiXi message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ShiXi
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.ShiXi;

        /**
         * Verifies a ShiXi message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ShiXi message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ShiXi
         */
        public static fromObject(object: { [k: string]: any }): pb.ShiXi;

        /**
         * Creates a plain object from a ShiXi message. Also converts values to other types if specified.
         * @param message ShiXi
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.ShiXi, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ShiXi to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a LoadRole. */
    interface ILoadRole {

        /** LoadRole roleId */
        roleId?: string;

        /** LoadRole game */
        game?: string;

        /** LoadRole qd */
        qd?: string;

        /** LoadRole qu */
        qu?: number;
    }

    /** Represents a LoadRole. */
    class LoadRole {

        /**
         * Constructs a new LoadRole.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ILoadRole);

        /** LoadRole roleId. */
        public roleId: string;

        /** LoadRole game. */
        public game: string;

        /** LoadRole qd. */
        public qd: string;

        /** LoadRole qu. */
        public qu: number;

        /**
         * Creates a new LoadRole instance using the specified properties.
         * @param [properties] Properties to set
         * @returns LoadRole instance
         */
        public static create(properties?: pb.ILoadRole): pb.LoadRole;

        /**
         * Encodes the specified LoadRole message. Does not implicitly {@link pb.LoadRole.verify|verify} messages.
         * @param message LoadRole message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ILoadRole, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified LoadRole message, length delimited. Does not implicitly {@link pb.LoadRole.verify|verify} messages.
         * @param message LoadRole message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ILoadRole, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a LoadRole message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns LoadRole
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.LoadRole;

        /**
         * Decodes a LoadRole message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns LoadRole
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.LoadRole;

        /**
         * Verifies a LoadRole message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a LoadRole message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns LoadRole
         */
        public static fromObject(object: { [k: string]: any }): pb.LoadRole;

        /**
         * Creates a plain object from a LoadRole message. Also converts values to other types if specified.
         * @param message LoadRole
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.LoadRole, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this LoadRole to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TiRen. */
    interface ITiRen {

        /** TiRen roleId */
        roleId?: string;

        /** TiRen game */
        game?: string;

        /** TiRen qd */
        qd?: string;

        /** TiRen qu */
        qu?: number;
    }

    /** Represents a TiRen. */
    class TiRen {

        /**
         * Constructs a new TiRen.
         * @param [properties] Properties to set
         */
        constructor(properties?: pb.ITiRen);

        /** TiRen roleId. */
        public roleId: string;

        /** TiRen game. */
        public game: string;

        /** TiRen qd. */
        public qd: string;

        /** TiRen qu. */
        public qu: number;

        /**
         * Creates a new TiRen instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TiRen instance
         */
        public static create(properties?: pb.ITiRen): pb.TiRen;

        /**
         * Encodes the specified TiRen message. Does not implicitly {@link pb.TiRen.verify|verify} messages.
         * @param message TiRen message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: pb.ITiRen, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TiRen message, length delimited. Does not implicitly {@link pb.TiRen.verify|verify} messages.
         * @param message TiRen message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: pb.ITiRen, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TiRen message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TiRen
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): pb.TiRen;

        /**
         * Decodes a TiRen message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TiRen
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): pb.TiRen;

        /**
         * Verifies a TiRen message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TiRen message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TiRen
         */
        public static fromObject(object: { [k: string]: any }): pb.TiRen;

        /**
         * Creates a plain object from a TiRen message. Also converts values to other types if specified.
         * @param message TiRen
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: pb.TiRen, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TiRen to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }
}
