/*eslint-disable block-scoped-var, no-redeclare, no-control-regex, no-prototype-builtins*/
"use strict";

var $protobuf = require("protobufjs/minimal");

// Common aliases
var $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;

// Exported root namespace
var $root = $protobuf.roots["default"] || ($protobuf.roots["default"] = {});

$root.pb = (function() {

    /**
     * Namespace pb.
     * @exports pb
     * @namespace
     */
    var pb = {};

    /**
     * ValType enum.
     * @enum {string}
     * @property {number} int=0 int value
     * @property {number} float=1 float value
     * @property {number} bool=2 bool value
     * @property {number} string=3 string value
     * @property {number} ints=4 ints value
     */
    pb.ValType = (function() {
        var valuesById = {}, values = Object.create(valuesById);
        values[valuesById[0] = "int"] = 0;
        values[valuesById[1] = "float"] = 1;
        values[valuesById[2] = "bool"] = 2;
        values[valuesById[3] = "string"] = 3;
        values[valuesById[4] = "ints"] = 4;
        return values;
    })();

    pb.Excel = (function() {

        /**
         * Properties of an Excel.
         * @memberof pb
         * @interface IExcel
         * @property {Object.<string,pb.ISheet>} [sheetDic] Excel sheetDic
         */

        /**
         * Constructs a new Excel.
         * @memberof pb
         * @classdesc Represents an Excel.
         * @constructor
         * @param {pb.IExcel=} [properties] Properties to set
         */
        function Excel(properties) {
            this.sheetDic = {};
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Excel sheetDic.
         * @member {Object.<string,pb.ISheet>}sheetDic
         * @memberof pb.Excel
         * @instance
         */
        Excel.prototype.sheetDic = $util.emptyObject;

        /**
         * Creates a new Excel instance using the specified properties.
         * @function create
         * @memberof pb.Excel
         * @static
         * @param {pb.IExcel=} [properties] Properties to set
         * @returns {pb.Excel} Excel instance
         */
        Excel.create = function create(properties) {
            return new Excel(properties);
        };

        /**
         * Encodes the specified Excel message. Does not implicitly {@link pb.Excel.verify|verify} messages.
         * @function encode
         * @memberof pb.Excel
         * @static
         * @param {pb.IExcel} message Excel message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Excel.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.sheetDic != null && message.hasOwnProperty("sheetDic"))
                for (var keys = Object.keys(message.sheetDic), i = 0; i < keys.length; ++i) {
                    writer.uint32(/* id 1, wireType 2 =*/10).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]);
                    $root.pb.Sheet.encode(message.sheetDic[keys[i]], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim().ldelim();
                }
            return writer;
        };

        /**
         * Encodes the specified Excel message, length delimited. Does not implicitly {@link pb.Excel.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.Excel
         * @static
         * @param {pb.IExcel} message Excel message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Excel.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an Excel message from the specified reader or buffer.
         * @function decode
         * @memberof pb.Excel
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.Excel} Excel
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Excel.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.Excel(), key;
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    reader.skip().pos++;
                    if (message.sheetDic === $util.emptyObject)
                        message.sheetDic = {};
                    key = reader.string();
                    reader.pos++;
                    message.sheetDic[key] = $root.pb.Sheet.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an Excel message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.Excel
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.Excel} Excel
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Excel.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an Excel message.
         * @function verify
         * @memberof pb.Excel
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Excel.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.sheetDic != null && message.hasOwnProperty("sheetDic")) {
                if (!$util.isObject(message.sheetDic))
                    return "sheetDic: object expected";
                var key = Object.keys(message.sheetDic);
                for (var i = 0; i < key.length; ++i) {
                    var error = $root.pb.Sheet.verify(message.sheetDic[key[i]]);
                    if (error)
                        return "sheetDic." + error;
                }
            }
            return null;
        };

        /**
         * Creates an Excel message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.Excel
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.Excel} Excel
         */
        Excel.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.Excel)
                return object;
            var message = new $root.pb.Excel();
            if (object.sheetDic) {
                if (typeof object.sheetDic !== "object")
                    throw TypeError(".pb.Excel.sheetDic: object expected");
                message.sheetDic = {};
                for (var keys = Object.keys(object.sheetDic), i = 0; i < keys.length; ++i) {
                    if (typeof object.sheetDic[keys[i]] !== "object")
                        throw TypeError(".pb.Excel.sheetDic: object expected");
                    message.sheetDic[keys[i]] = $root.pb.Sheet.fromObject(object.sheetDic[keys[i]]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from an Excel message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.Excel
         * @static
         * @param {pb.Excel} message Excel
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Excel.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.objects || options.defaults)
                object.sheetDic = {};
            var keys2;
            if (message.sheetDic && (keys2 = Object.keys(message.sheetDic)).length) {
                object.sheetDic = {};
                for (var j = 0; j < keys2.length; ++j)
                    object.sheetDic[keys2[j]] = $root.pb.Sheet.toObject(message.sheetDic[keys2[j]], options);
            }
            return object;
        };

        /**
         * Converts this Excel to JSON.
         * @function toJSON
         * @memberof pb.Excel
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Excel.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Excel;
    })();

    pb.Sheet = (function() {

        /**
         * Properties of a Sheet.
         * @memberof pb
         * @interface ISheet
         * @property {Object.<string,number>} [tagDic] Sheet tagDic
         * @property {Array.<pb.ITag>} [tags] Sheet tags
         * @property {Object.<string,pb.IRow>} [rowDic] Sheet rowDic
         */

        /**
         * Constructs a new Sheet.
         * @memberof pb
         * @classdesc Represents a Sheet.
         * @constructor
         * @param {pb.ISheet=} [properties] Properties to set
         */
        function Sheet(properties) {
            this.tagDic = {};
            this.tags = [];
            this.rowDic = {};
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Sheet tagDic.
         * @member {Object.<string,number>}tagDic
         * @memberof pb.Sheet
         * @instance
         */
        Sheet.prototype.tagDic = $util.emptyObject;

        /**
         * Sheet tags.
         * @member {Array.<pb.ITag>}tags
         * @memberof pb.Sheet
         * @instance
         */
        Sheet.prototype.tags = $util.emptyArray;

        /**
         * Sheet rowDic.
         * @member {Object.<string,pb.IRow>}rowDic
         * @memberof pb.Sheet
         * @instance
         */
        Sheet.prototype.rowDic = $util.emptyObject;

        /**
         * Creates a new Sheet instance using the specified properties.
         * @function create
         * @memberof pb.Sheet
         * @static
         * @param {pb.ISheet=} [properties] Properties to set
         * @returns {pb.Sheet} Sheet instance
         */
        Sheet.create = function create(properties) {
            return new Sheet(properties);
        };

        /**
         * Encodes the specified Sheet message. Does not implicitly {@link pb.Sheet.verify|verify} messages.
         * @function encode
         * @memberof pb.Sheet
         * @static
         * @param {pb.ISheet} message Sheet message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Sheet.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.tagDic != null && message.hasOwnProperty("tagDic"))
                for (var keys = Object.keys(message.tagDic), i = 0; i < keys.length; ++i)
                    writer.uint32(/* id 1, wireType 2 =*/10).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 0 =*/16).int32(message.tagDic[keys[i]]).ldelim();
            if (message.tags != null && message.tags.length)
                for (var i = 0; i < message.tags.length; ++i)
                    $root.pb.Tag.encode(message.tags[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.rowDic != null && message.hasOwnProperty("rowDic"))
                for (var keys = Object.keys(message.rowDic), i = 0; i < keys.length; ++i) {
                    writer.uint32(/* id 3, wireType 2 =*/26).fork().uint32(/* id 1, wireType 0 =*/8).int32(keys[i]);
                    $root.pb.Row.encode(message.rowDic[keys[i]], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim().ldelim();
                }
            return writer;
        };

        /**
         * Encodes the specified Sheet message, length delimited. Does not implicitly {@link pb.Sheet.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.Sheet
         * @static
         * @param {pb.ISheet} message Sheet message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Sheet.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Sheet message from the specified reader or buffer.
         * @function decode
         * @memberof pb.Sheet
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.Sheet} Sheet
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Sheet.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.Sheet(), key;
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    reader.skip().pos++;
                    if (message.tagDic === $util.emptyObject)
                        message.tagDic = {};
                    key = reader.string();
                    reader.pos++;
                    message.tagDic[key] = reader.int32();
                    break;
                case 2:
                    if (!(message.tags && message.tags.length))
                        message.tags = [];
                    message.tags.push($root.pb.Tag.decode(reader, reader.uint32()));
                    break;
                case 3:
                    reader.skip().pos++;
                    if (message.rowDic === $util.emptyObject)
                        message.rowDic = {};
                    key = reader.int32();
                    reader.pos++;
                    message.rowDic[key] = $root.pb.Row.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a Sheet message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.Sheet
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.Sheet} Sheet
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Sheet.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Sheet message.
         * @function verify
         * @memberof pb.Sheet
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Sheet.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.tagDic != null && message.hasOwnProperty("tagDic")) {
                if (!$util.isObject(message.tagDic))
                    return "tagDic: object expected";
                var key = Object.keys(message.tagDic);
                for (var i = 0; i < key.length; ++i)
                    if (!$util.isInteger(message.tagDic[key[i]]))
                        return "tagDic: integer{k:string} expected";
            }
            if (message.tags != null && message.hasOwnProperty("tags")) {
                if (!Array.isArray(message.tags))
                    return "tags: array expected";
                for (var i = 0; i < message.tags.length; ++i) {
                    var error = $root.pb.Tag.verify(message.tags[i]);
                    if (error)
                        return "tags." + error;
                }
            }
            if (message.rowDic != null && message.hasOwnProperty("rowDic")) {
                if (!$util.isObject(message.rowDic))
                    return "rowDic: object expected";
                var key = Object.keys(message.rowDic);
                for (var i = 0; i < key.length; ++i) {
                    if (!$util.key32Re.test(key[i]))
                        return "rowDic: integer key{k:int32} expected";
                    error = $root.pb.Row.verify(message.rowDic[key[i]]);
                    if (error)
                        return "rowDic." + error;
                }
            }
            return null;
        };

        /**
         * Creates a Sheet message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.Sheet
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.Sheet} Sheet
         */
        Sheet.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.Sheet)
                return object;
            var message = new $root.pb.Sheet();
            if (object.tagDic) {
                if (typeof object.tagDic !== "object")
                    throw TypeError(".pb.Sheet.tagDic: object expected");
                message.tagDic = {};
                for (var keys = Object.keys(object.tagDic), i = 0; i < keys.length; ++i)
                    message.tagDic[keys[i]] = object.tagDic[keys[i]] | 0;
            }
            if (object.tags) {
                if (!Array.isArray(object.tags))
                    throw TypeError(".pb.Sheet.tags: array expected");
                message.tags = [];
                for (var i = 0; i < object.tags.length; ++i) {
                    if (typeof object.tags[i] !== "object")
                        throw TypeError(".pb.Sheet.tags: object expected");
                    message.tags[i] = $root.pb.Tag.fromObject(object.tags[i]);
                }
            }
            if (object.rowDic) {
                if (typeof object.rowDic !== "object")
                    throw TypeError(".pb.Sheet.rowDic: object expected");
                message.rowDic = {};
                for (var keys = Object.keys(object.rowDic), i = 0; i < keys.length; ++i) {
                    if (typeof object.rowDic[keys[i]] !== "object")
                        throw TypeError(".pb.Sheet.rowDic: object expected");
                    message.rowDic[keys[i]] = $root.pb.Row.fromObject(object.rowDic[keys[i]]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a Sheet message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.Sheet
         * @static
         * @param {pb.Sheet} message Sheet
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Sheet.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.tags = [];
            if (options.objects || options.defaults) {
                object.tagDic = {};
                object.rowDic = {};
            }
            var keys2;
            if (message.tagDic && (keys2 = Object.keys(message.tagDic)).length) {
                object.tagDic = {};
                for (var j = 0; j < keys2.length; ++j)
                    object.tagDic[keys2[j]] = message.tagDic[keys2[j]];
            }
            if (message.tags && message.tags.length) {
                object.tags = [];
                for (var j = 0; j < message.tags.length; ++j)
                    object.tags[j] = $root.pb.Tag.toObject(message.tags[j], options);
            }
            if (message.rowDic && (keys2 = Object.keys(message.rowDic)).length) {
                object.rowDic = {};
                for (var j = 0; j < keys2.length; ++j)
                    object.rowDic[keys2[j]] = $root.pb.Row.toObject(message.rowDic[keys2[j]], options);
            }
            return object;
        };

        /**
         * Converts this Sheet to JSON.
         * @function toJSON
         * @memberof pb.Sheet
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Sheet.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Sheet;
    })();

    pb.Tag = (function() {

        /**
         * Properties of a Tag.
         * @memberof pb
         * @interface ITag
         * @property {pb.ValType} [type] Tag type
         * @property {string} [yinyong] Tag yinyong
         */

        /**
         * Constructs a new Tag.
         * @memberof pb
         * @classdesc Represents a Tag.
         * @constructor
         * @param {pb.ITag=} [properties] Properties to set
         */
        function Tag(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Tag type.
         * @member {pb.ValType}type
         * @memberof pb.Tag
         * @instance
         */
        Tag.prototype.type = 0;

        /**
         * Tag yinyong.
         * @member {string}yinyong
         * @memberof pb.Tag
         * @instance
         */
        Tag.prototype.yinyong = "";

        /**
         * Creates a new Tag instance using the specified properties.
         * @function create
         * @memberof pb.Tag
         * @static
         * @param {pb.ITag=} [properties] Properties to set
         * @returns {pb.Tag} Tag instance
         */
        Tag.create = function create(properties) {
            return new Tag(properties);
        };

        /**
         * Encodes the specified Tag message. Does not implicitly {@link pb.Tag.verify|verify} messages.
         * @function encode
         * @memberof pb.Tag
         * @static
         * @param {pb.ITag} message Tag message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Tag.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.type != null && message.hasOwnProperty("type"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.type);
            if (message.yinyong != null && message.hasOwnProperty("yinyong"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.yinyong);
            return writer;
        };

        /**
         * Encodes the specified Tag message, length delimited. Does not implicitly {@link pb.Tag.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.Tag
         * @static
         * @param {pb.ITag} message Tag message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Tag.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Tag message from the specified reader or buffer.
         * @function decode
         * @memberof pb.Tag
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.Tag} Tag
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Tag.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.Tag();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.type = reader.int32();
                    break;
                case 2:
                    message.yinyong = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a Tag message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.Tag
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.Tag} Tag
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Tag.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Tag message.
         * @function verify
         * @memberof pb.Tag
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Tag.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.type != null && message.hasOwnProperty("type"))
                switch (message.type) {
                default:
                    return "type: enum value expected";
                case 0:
                case 1:
                case 2:
                case 3:
                case 4:
                    break;
                }
            if (message.yinyong != null && message.hasOwnProperty("yinyong"))
                if (!$util.isString(message.yinyong))
                    return "yinyong: string expected";
            return null;
        };

        /**
         * Creates a Tag message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.Tag
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.Tag} Tag
         */
        Tag.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.Tag)
                return object;
            var message = new $root.pb.Tag();
            switch (object.type) {
            case "int":
            case 0:
                message.type = 0;
                break;
            case "float":
            case 1:
                message.type = 1;
                break;
            case "bool":
            case 2:
                message.type = 2;
                break;
            case "string":
            case 3:
                message.type = 3;
                break;
            case "ints":
            case 4:
                message.type = 4;
                break;
            }
            if (object.yinyong != null)
                message.yinyong = String(object.yinyong);
            return message;
        };

        /**
         * Creates a plain object from a Tag message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.Tag
         * @static
         * @param {pb.Tag} message Tag
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Tag.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.type = options.enums === String ? "int" : 0;
                object.yinyong = "";
            }
            if (message.type != null && message.hasOwnProperty("type"))
                object.type = options.enums === String ? $root.pb.ValType[message.type] : message.type;
            if (message.yinyong != null && message.hasOwnProperty("yinyong"))
                object.yinyong = message.yinyong;
            return object;
        };

        /**
         * Converts this Tag to JSON.
         * @function toJSON
         * @memberof pb.Tag
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Tag.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Tag;
    })();

    pb.Row = (function() {

        /**
         * Properties of a Row.
         * @memberof pb
         * @interface IRow
         * @property {Object.<string,number>} [cellDic] Row cellDic
         * @property {Array.<pb.ICell>} [cells] Row cells
         */

        /**
         * Constructs a new Row.
         * @memberof pb
         * @classdesc Represents a Row.
         * @constructor
         * @param {pb.IRow=} [properties] Properties to set
         */
        function Row(properties) {
            this.cellDic = {};
            this.cells = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Row cellDic.
         * @member {Object.<string,number>}cellDic
         * @memberof pb.Row
         * @instance
         */
        Row.prototype.cellDic = $util.emptyObject;

        /**
         * Row cells.
         * @member {Array.<pb.ICell>}cells
         * @memberof pb.Row
         * @instance
         */
        Row.prototype.cells = $util.emptyArray;

        /**
         * Creates a new Row instance using the specified properties.
         * @function create
         * @memberof pb.Row
         * @static
         * @param {pb.IRow=} [properties] Properties to set
         * @returns {pb.Row} Row instance
         */
        Row.create = function create(properties) {
            return new Row(properties);
        };

        /**
         * Encodes the specified Row message. Does not implicitly {@link pb.Row.verify|verify} messages.
         * @function encode
         * @memberof pb.Row
         * @static
         * @param {pb.IRow} message Row message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Row.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.cellDic != null && message.hasOwnProperty("cellDic"))
                for (var keys = Object.keys(message.cellDic), i = 0; i < keys.length; ++i)
                    writer.uint32(/* id 1, wireType 2 =*/10).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 0 =*/16).int32(message.cellDic[keys[i]]).ldelim();
            if (message.cells != null && message.cells.length)
                for (var i = 0; i < message.cells.length; ++i)
                    $root.pb.Cell.encode(message.cells[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified Row message, length delimited. Does not implicitly {@link pb.Row.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.Row
         * @static
         * @param {pb.IRow} message Row message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Row.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Row message from the specified reader or buffer.
         * @function decode
         * @memberof pb.Row
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.Row} Row
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Row.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.Row(), key;
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    reader.skip().pos++;
                    if (message.cellDic === $util.emptyObject)
                        message.cellDic = {};
                    key = reader.string();
                    reader.pos++;
                    message.cellDic[key] = reader.int32();
                    break;
                case 2:
                    if (!(message.cells && message.cells.length))
                        message.cells = [];
                    message.cells.push($root.pb.Cell.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a Row message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.Row
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.Row} Row
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Row.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Row message.
         * @function verify
         * @memberof pb.Row
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Row.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.cellDic != null && message.hasOwnProperty("cellDic")) {
                if (!$util.isObject(message.cellDic))
                    return "cellDic: object expected";
                var key = Object.keys(message.cellDic);
                for (var i = 0; i < key.length; ++i)
                    if (!$util.isInteger(message.cellDic[key[i]]))
                        return "cellDic: integer{k:string} expected";
            }
            if (message.cells != null && message.hasOwnProperty("cells")) {
                if (!Array.isArray(message.cells))
                    return "cells: array expected";
                for (var i = 0; i < message.cells.length; ++i) {
                    var error = $root.pb.Cell.verify(message.cells[i]);
                    if (error)
                        return "cells." + error;
                }
            }
            return null;
        };

        /**
         * Creates a Row message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.Row
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.Row} Row
         */
        Row.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.Row)
                return object;
            var message = new $root.pb.Row();
            if (object.cellDic) {
                if (typeof object.cellDic !== "object")
                    throw TypeError(".pb.Row.cellDic: object expected");
                message.cellDic = {};
                for (var keys = Object.keys(object.cellDic), i = 0; i < keys.length; ++i)
                    message.cellDic[keys[i]] = object.cellDic[keys[i]] | 0;
            }
            if (object.cells) {
                if (!Array.isArray(object.cells))
                    throw TypeError(".pb.Row.cells: array expected");
                message.cells = [];
                for (var i = 0; i < object.cells.length; ++i) {
                    if (typeof object.cells[i] !== "object")
                        throw TypeError(".pb.Row.cells: object expected");
                    message.cells[i] = $root.pb.Cell.fromObject(object.cells[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a Row message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.Row
         * @static
         * @param {pb.Row} message Row
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Row.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.cells = [];
            if (options.objects || options.defaults)
                object.cellDic = {};
            var keys2;
            if (message.cellDic && (keys2 = Object.keys(message.cellDic)).length) {
                object.cellDic = {};
                for (var j = 0; j < keys2.length; ++j)
                    object.cellDic[keys2[j]] = message.cellDic[keys2[j]];
            }
            if (message.cells && message.cells.length) {
                object.cells = [];
                for (var j = 0; j < message.cells.length; ++j)
                    object.cells[j] = $root.pb.Cell.toObject(message.cells[j], options);
            }
            return object;
        };

        /**
         * Converts this Row to JSON.
         * @function toJSON
         * @memberof pb.Row
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Row.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Row;
    })();

    pb.Cell = (function() {

        /**
         * Properties of a Cell.
         * @memberof pb
         * @interface ICell
         * @property {pb.ITag} [tag] Cell tag
         * @property {number} [valInt] Cell valInt
         * @property {boolean} [valBool] Cell valBool
         * @property {number} [valFloat] Cell valFloat
         * @property {string} [valString] Cell valString
         * @property {Array.<number>} [valInts] Cell valInts
         */

        /**
         * Constructs a new Cell.
         * @memberof pb
         * @classdesc Represents a Cell.
         * @constructor
         * @param {pb.ICell=} [properties] Properties to set
         */
        function Cell(properties) {
            this.valInts = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Cell tag.
         * @member {(pb.ITag|null|undefined)}tag
         * @memberof pb.Cell
         * @instance
         */
        Cell.prototype.tag = null;

        /**
         * Cell valInt.
         * @member {number}valInt
         * @memberof pb.Cell
         * @instance
         */
        Cell.prototype.valInt = 0;

        /**
         * Cell valBool.
         * @member {boolean}valBool
         * @memberof pb.Cell
         * @instance
         */
        Cell.prototype.valBool = false;

        /**
         * Cell valFloat.
         * @member {number}valFloat
         * @memberof pb.Cell
         * @instance
         */
        Cell.prototype.valFloat = 0;

        /**
         * Cell valString.
         * @member {string}valString
         * @memberof pb.Cell
         * @instance
         */
        Cell.prototype.valString = "";

        /**
         * Cell valInts.
         * @member {Array.<number>}valInts
         * @memberof pb.Cell
         * @instance
         */
        Cell.prototype.valInts = $util.emptyArray;

        /**
         * Creates a new Cell instance using the specified properties.
         * @function create
         * @memberof pb.Cell
         * @static
         * @param {pb.ICell=} [properties] Properties to set
         * @returns {pb.Cell} Cell instance
         */
        Cell.create = function create(properties) {
            return new Cell(properties);
        };

        /**
         * Encodes the specified Cell message. Does not implicitly {@link pb.Cell.verify|verify} messages.
         * @function encode
         * @memberof pb.Cell
         * @static
         * @param {pb.ICell} message Cell message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Cell.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.tag != null && message.hasOwnProperty("tag"))
                $root.pb.Tag.encode(message.tag, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.valInt != null && message.hasOwnProperty("valInt"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.valInt);
            if (message.valBool != null && message.hasOwnProperty("valBool"))
                writer.uint32(/* id 3, wireType 0 =*/24).bool(message.valBool);
            if (message.valFloat != null && message.hasOwnProperty("valFloat"))
                writer.uint32(/* id 4, wireType 5 =*/37).float(message.valFloat);
            if (message.valString != null && message.hasOwnProperty("valString"))
                writer.uint32(/* id 5, wireType 2 =*/42).string(message.valString);
            if (message.valInts != null && message.valInts.length) {
                writer.uint32(/* id 6, wireType 2 =*/50).fork();
                for (var i = 0; i < message.valInts.length; ++i)
                    writer.int32(message.valInts[i]);
                writer.ldelim();
            }
            return writer;
        };

        /**
         * Encodes the specified Cell message, length delimited. Does not implicitly {@link pb.Cell.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.Cell
         * @static
         * @param {pb.ICell} message Cell message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Cell.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Cell message from the specified reader or buffer.
         * @function decode
         * @memberof pb.Cell
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.Cell} Cell
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Cell.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.Cell();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.tag = $root.pb.Tag.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.valInt = reader.int32();
                    break;
                case 3:
                    message.valBool = reader.bool();
                    break;
                case 4:
                    message.valFloat = reader.float();
                    break;
                case 5:
                    message.valString = reader.string();
                    break;
                case 6:
                    if (!(message.valInts && message.valInts.length))
                        message.valInts = [];
                    if ((tag & 7) === 2) {
                        var end2 = reader.uint32() + reader.pos;
                        while (reader.pos < end2)
                            message.valInts.push(reader.int32());
                    } else
                        message.valInts.push(reader.int32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a Cell message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.Cell
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.Cell} Cell
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Cell.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Cell message.
         * @function verify
         * @memberof pb.Cell
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Cell.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.tag != null && message.hasOwnProperty("tag")) {
                var error = $root.pb.Tag.verify(message.tag);
                if (error)
                    return "tag." + error;
            }
            if (message.valInt != null && message.hasOwnProperty("valInt"))
                if (!$util.isInteger(message.valInt))
                    return "valInt: integer expected";
            if (message.valBool != null && message.hasOwnProperty("valBool"))
                if (typeof message.valBool !== "boolean")
                    return "valBool: boolean expected";
            if (message.valFloat != null && message.hasOwnProperty("valFloat"))
                if (typeof message.valFloat !== "number")
                    return "valFloat: number expected";
            if (message.valString != null && message.hasOwnProperty("valString"))
                if (!$util.isString(message.valString))
                    return "valString: string expected";
            if (message.valInts != null && message.hasOwnProperty("valInts")) {
                if (!Array.isArray(message.valInts))
                    return "valInts: array expected";
                for (var i = 0; i < message.valInts.length; ++i)
                    if (!$util.isInteger(message.valInts[i]))
                        return "valInts: integer[] expected";
            }
            return null;
        };

        /**
         * Creates a Cell message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.Cell
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.Cell} Cell
         */
        Cell.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.Cell)
                return object;
            var message = new $root.pb.Cell();
            if (object.tag != null) {
                if (typeof object.tag !== "object")
                    throw TypeError(".pb.Cell.tag: object expected");
                message.tag = $root.pb.Tag.fromObject(object.tag);
            }
            if (object.valInt != null)
                message.valInt = object.valInt | 0;
            if (object.valBool != null)
                message.valBool = Boolean(object.valBool);
            if (object.valFloat != null)
                message.valFloat = Number(object.valFloat);
            if (object.valString != null)
                message.valString = String(object.valString);
            if (object.valInts) {
                if (!Array.isArray(object.valInts))
                    throw TypeError(".pb.Cell.valInts: array expected");
                message.valInts = [];
                for (var i = 0; i < object.valInts.length; ++i)
                    message.valInts[i] = object.valInts[i] | 0;
            }
            return message;
        };

        /**
         * Creates a plain object from a Cell message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.Cell
         * @static
         * @param {pb.Cell} message Cell
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Cell.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.valInts = [];
            if (options.defaults) {
                object.tag = null;
                object.valInt = 0;
                object.valBool = false;
                object.valFloat = 0;
                object.valString = "";
            }
            if (message.tag != null && message.hasOwnProperty("tag"))
                object.tag = $root.pb.Tag.toObject(message.tag, options);
            if (message.valInt != null && message.hasOwnProperty("valInt"))
                object.valInt = message.valInt;
            if (message.valBool != null && message.hasOwnProperty("valBool"))
                object.valBool = message.valBool;
            if (message.valFloat != null && message.hasOwnProperty("valFloat"))
                object.valFloat = options.json && !isFinite(message.valFloat) ? String(message.valFloat) : message.valFloat;
            if (message.valString != null && message.hasOwnProperty("valString"))
                object.valString = message.valString;
            if (message.valInts && message.valInts.length) {
                object.valInts = [];
                for (var j = 0; j < message.valInts.length; ++j)
                    object.valInts[j] = message.valInts[j];
            }
            return object;
        };

        /**
         * Converts this Cell to JSON.
         * @function toJSON
         * @memberof pb.Cell
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Cell.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Cell;
    })();

    pb.ResultRes = (function() {

        /**
         * Properties of a ResultRes.
         * @memberof pb
         * @interface IResultRes
         * @property {string} [desc] ResultRes desc
         */

        /**
         * Constructs a new ResultRes.
         * @memberof pb
         * @classdesc Represents a ResultRes.
         * @constructor
         * @param {pb.IResultRes=} [properties] Properties to set
         */
        function ResultRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ResultRes desc.
         * @member {string}desc
         * @memberof pb.ResultRes
         * @instance
         */
        ResultRes.prototype.desc = "";

        /**
         * Creates a new ResultRes instance using the specified properties.
         * @function create
         * @memberof pb.ResultRes
         * @static
         * @param {pb.IResultRes=} [properties] Properties to set
         * @returns {pb.ResultRes} ResultRes instance
         */
        ResultRes.create = function create(properties) {
            return new ResultRes(properties);
        };

        /**
         * Encodes the specified ResultRes message. Does not implicitly {@link pb.ResultRes.verify|verify} messages.
         * @function encode
         * @memberof pb.ResultRes
         * @static
         * @param {pb.IResultRes} message ResultRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ResultRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.desc != null && message.hasOwnProperty("desc"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.desc);
            return writer;
        };

        /**
         * Encodes the specified ResultRes message, length delimited. Does not implicitly {@link pb.ResultRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.ResultRes
         * @static
         * @param {pb.IResultRes} message ResultRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ResultRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ResultRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.ResultRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.ResultRes} ResultRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ResultRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.ResultRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.desc = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ResultRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.ResultRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.ResultRes} ResultRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ResultRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ResultRes message.
         * @function verify
         * @memberof pb.ResultRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ResultRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.desc != null && message.hasOwnProperty("desc"))
                if (!$util.isString(message.desc))
                    return "desc: string expected";
            return null;
        };

        /**
         * Creates a ResultRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.ResultRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.ResultRes} ResultRes
         */
        ResultRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.ResultRes)
                return object;
            var message = new $root.pb.ResultRes();
            if (object.desc != null)
                message.desc = String(object.desc);
            return message;
        };

        /**
         * Creates a plain object from a ResultRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.ResultRes
         * @static
         * @param {pb.ResultRes} message ResultRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ResultRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.desc = "";
            if (message.desc != null && message.hasOwnProperty("desc"))
                object.desc = message.desc;
            return object;
        };

        /**
         * Converts this ResultRes to JSON.
         * @function toJSON
         * @memberof pb.ResultRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ResultRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ResultRes;
    })();

    pb.RenWuRes = (function() {

        /**
         * Properties of a RenWuRes.
         * @memberof pb
         * @interface IRenWuRes
         */

        /**
         * Constructs a new RenWuRes.
         * @memberof pb
         * @classdesc Represents a RenWuRes.
         * @constructor
         * @param {pb.IRenWuRes=} [properties] Properties to set
         */
        function RenWuRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new RenWuRes instance using the specified properties.
         * @function create
         * @memberof pb.RenWuRes
         * @static
         * @param {pb.IRenWuRes=} [properties] Properties to set
         * @returns {pb.RenWuRes} RenWuRes instance
         */
        RenWuRes.create = function create(properties) {
            return new RenWuRes(properties);
        };

        /**
         * Encodes the specified RenWuRes message. Does not implicitly {@link pb.RenWuRes.verify|verify} messages.
         * @function encode
         * @memberof pb.RenWuRes
         * @static
         * @param {pb.IRenWuRes} message RenWuRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        RenWuRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified RenWuRes message, length delimited. Does not implicitly {@link pb.RenWuRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.RenWuRes
         * @static
         * @param {pb.IRenWuRes} message RenWuRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        RenWuRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a RenWuRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.RenWuRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.RenWuRes} RenWuRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        RenWuRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.RenWuRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a RenWuRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.RenWuRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.RenWuRes} RenWuRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        RenWuRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a RenWuRes message.
         * @function verify
         * @memberof pb.RenWuRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        RenWuRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a RenWuRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.RenWuRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.RenWuRes} RenWuRes
         */
        RenWuRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.RenWuRes)
                return object;
            return new $root.pb.RenWuRes();
        };

        /**
         * Creates a plain object from a RenWuRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.RenWuRes
         * @static
         * @param {pb.RenWuRes} message RenWuRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        RenWuRes.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this RenWuRes to JSON.
         * @function toJSON
         * @memberof pb.RenWuRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        RenWuRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return RenWuRes;
    })();

    pb.DuiHhuanAsk = (function() {

        /**
         * Properties of a DuiHhuanAsk.
         * @memberof pb
         * @interface IDuiHhuanAsk
         * @property {number} [code] DuiHhuanAsk code
         */

        /**
         * Constructs a new DuiHhuanAsk.
         * @memberof pb
         * @classdesc Represents a DuiHhuanAsk.
         * @constructor
         * @param {pb.IDuiHhuanAsk=} [properties] Properties to set
         */
        function DuiHhuanAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DuiHhuanAsk code.
         * @member {number}code
         * @memberof pb.DuiHhuanAsk
         * @instance
         */
        DuiHhuanAsk.prototype.code = 0;

        /**
         * Creates a new DuiHhuanAsk instance using the specified properties.
         * @function create
         * @memberof pb.DuiHhuanAsk
         * @static
         * @param {pb.IDuiHhuanAsk=} [properties] Properties to set
         * @returns {pb.DuiHhuanAsk} DuiHhuanAsk instance
         */
        DuiHhuanAsk.create = function create(properties) {
            return new DuiHhuanAsk(properties);
        };

        /**
         * Encodes the specified DuiHhuanAsk message. Does not implicitly {@link pb.DuiHhuanAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.DuiHhuanAsk
         * @static
         * @param {pb.IDuiHhuanAsk} message DuiHhuanAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DuiHhuanAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.code != null && message.hasOwnProperty("code"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.code);
            return writer;
        };

        /**
         * Encodes the specified DuiHhuanAsk message, length delimited. Does not implicitly {@link pb.DuiHhuanAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.DuiHhuanAsk
         * @static
         * @param {pb.IDuiHhuanAsk} message DuiHhuanAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DuiHhuanAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DuiHhuanAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.DuiHhuanAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.DuiHhuanAsk} DuiHhuanAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DuiHhuanAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.DuiHhuanAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.code = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DuiHhuanAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.DuiHhuanAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.DuiHhuanAsk} DuiHhuanAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DuiHhuanAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DuiHhuanAsk message.
         * @function verify
         * @memberof pb.DuiHhuanAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DuiHhuanAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.code != null && message.hasOwnProperty("code"))
                if (!$util.isInteger(message.code))
                    return "code: integer expected";
            return null;
        };

        /**
         * Creates a DuiHhuanAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.DuiHhuanAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.DuiHhuanAsk} DuiHhuanAsk
         */
        DuiHhuanAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.DuiHhuanAsk)
                return object;
            var message = new $root.pb.DuiHhuanAsk();
            if (object.code != null)
                message.code = object.code | 0;
            return message;
        };

        /**
         * Creates a plain object from a DuiHhuanAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.DuiHhuanAsk
         * @static
         * @param {pb.DuiHhuanAsk} message DuiHhuanAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DuiHhuanAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.code = 0;
            if (message.code != null && message.hasOwnProperty("code"))
                object.code = message.code;
            return object;
        };

        /**
         * Converts this DuiHhuanAsk to JSON.
         * @function toJSON
         * @memberof pb.DuiHhuanAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DuiHhuanAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DuiHhuanAsk;
    })();

    pb.DuiHhuanRes = (function() {

        /**
         * Properties of a DuiHhuanRes.
         * @memberof pb
         * @interface IDuiHhuanRes
         * @property {number} [res] DuiHhuanRes res
         */

        /**
         * Constructs a new DuiHhuanRes.
         * @memberof pb
         * @classdesc Represents a DuiHhuanRes.
         * @constructor
         * @param {pb.IDuiHhuanRes=} [properties] Properties to set
         */
        function DuiHhuanRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DuiHhuanRes res.
         * @member {number}res
         * @memberof pb.DuiHhuanRes
         * @instance
         */
        DuiHhuanRes.prototype.res = 0;

        /**
         * Creates a new DuiHhuanRes instance using the specified properties.
         * @function create
         * @memberof pb.DuiHhuanRes
         * @static
         * @param {pb.IDuiHhuanRes=} [properties] Properties to set
         * @returns {pb.DuiHhuanRes} DuiHhuanRes instance
         */
        DuiHhuanRes.create = function create(properties) {
            return new DuiHhuanRes(properties);
        };

        /**
         * Encodes the specified DuiHhuanRes message. Does not implicitly {@link pb.DuiHhuanRes.verify|verify} messages.
         * @function encode
         * @memberof pb.DuiHhuanRes
         * @static
         * @param {pb.IDuiHhuanRes} message DuiHhuanRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DuiHhuanRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.res != null && message.hasOwnProperty("res"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.res);
            return writer;
        };

        /**
         * Encodes the specified DuiHhuanRes message, length delimited. Does not implicitly {@link pb.DuiHhuanRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.DuiHhuanRes
         * @static
         * @param {pb.IDuiHhuanRes} message DuiHhuanRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DuiHhuanRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DuiHhuanRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.DuiHhuanRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.DuiHhuanRes} DuiHhuanRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DuiHhuanRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.DuiHhuanRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.res = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DuiHhuanRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.DuiHhuanRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.DuiHhuanRes} DuiHhuanRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DuiHhuanRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DuiHhuanRes message.
         * @function verify
         * @memberof pb.DuiHhuanRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DuiHhuanRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.res != null && message.hasOwnProperty("res"))
                if (!$util.isInteger(message.res))
                    return "res: integer expected";
            return null;
        };

        /**
         * Creates a DuiHhuanRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.DuiHhuanRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.DuiHhuanRes} DuiHhuanRes
         */
        DuiHhuanRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.DuiHhuanRes)
                return object;
            var message = new $root.pb.DuiHhuanRes();
            if (object.res != null)
                message.res = object.res | 0;
            return message;
        };

        /**
         * Creates a plain object from a DuiHhuanRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.DuiHhuanRes
         * @static
         * @param {pb.DuiHhuanRes} message DuiHhuanRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DuiHhuanRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.res = 0;
            if (message.res != null && message.hasOwnProperty("res"))
                object.res = message.res;
            return object;
        };

        /**
         * Converts this DuiHhuanRes to JSON.
         * @function toJSON
         * @memberof pb.DuiHhuanRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DuiHhuanRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DuiHhuanRes;
    })();

    pb.DelMailAsk = (function() {

        /**
         * Properties of a DelMailAsk.
         * @memberof pb
         * @interface IDelMailAsk
         * @property {number} [tpe] DelMailAsk tpe
         * @property {number} [idx] DelMailAsk idx
         */

        /**
         * Constructs a new DelMailAsk.
         * @memberof pb
         * @classdesc Represents a DelMailAsk.
         * @constructor
         * @param {pb.IDelMailAsk=} [properties] Properties to set
         */
        function DelMailAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DelMailAsk tpe.
         * @member {number}tpe
         * @memberof pb.DelMailAsk
         * @instance
         */
        DelMailAsk.prototype.tpe = 0;

        /**
         * DelMailAsk idx.
         * @member {number}idx
         * @memberof pb.DelMailAsk
         * @instance
         */
        DelMailAsk.prototype.idx = 0;

        /**
         * Creates a new DelMailAsk instance using the specified properties.
         * @function create
         * @memberof pb.DelMailAsk
         * @static
         * @param {pb.IDelMailAsk=} [properties] Properties to set
         * @returns {pb.DelMailAsk} DelMailAsk instance
         */
        DelMailAsk.create = function create(properties) {
            return new DelMailAsk(properties);
        };

        /**
         * Encodes the specified DelMailAsk message. Does not implicitly {@link pb.DelMailAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.DelMailAsk
         * @static
         * @param {pb.IDelMailAsk} message DelMailAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DelMailAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.tpe);
            if (message.idx != null && message.hasOwnProperty("idx"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.idx);
            return writer;
        };

        /**
         * Encodes the specified DelMailAsk message, length delimited. Does not implicitly {@link pb.DelMailAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.DelMailAsk
         * @static
         * @param {pb.IDelMailAsk} message DelMailAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DelMailAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DelMailAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.DelMailAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.DelMailAsk} DelMailAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DelMailAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.DelMailAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.tpe = reader.int32();
                    break;
                case 2:
                    message.idx = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DelMailAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.DelMailAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.DelMailAsk} DelMailAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DelMailAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DelMailAsk message.
         * @function verify
         * @memberof pb.DelMailAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DelMailAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                if (!$util.isInteger(message.tpe))
                    return "tpe: integer expected";
            if (message.idx != null && message.hasOwnProperty("idx"))
                if (!$util.isInteger(message.idx))
                    return "idx: integer expected";
            return null;
        };

        /**
         * Creates a DelMailAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.DelMailAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.DelMailAsk} DelMailAsk
         */
        DelMailAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.DelMailAsk)
                return object;
            var message = new $root.pb.DelMailAsk();
            if (object.tpe != null)
                message.tpe = object.tpe | 0;
            if (object.idx != null)
                message.idx = object.idx | 0;
            return message;
        };

        /**
         * Creates a plain object from a DelMailAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.DelMailAsk
         * @static
         * @param {pb.DelMailAsk} message DelMailAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DelMailAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.tpe = 0;
                object.idx = 0;
            }
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                object.tpe = message.tpe;
            if (message.idx != null && message.hasOwnProperty("idx"))
                object.idx = message.idx;
            return object;
        };

        /**
         * Converts this DelMailAsk to JSON.
         * @function toJSON
         * @memberof pb.DelMailAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DelMailAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DelMailAsk;
    })();

    pb.FightAsk = (function() {

        /**
         * Properties of a FightAsk.
         * @memberof pb
         * @interface IFightAsk
         * @property {number} [tpe] FightAsk tpe
         * @property {number} [idx] FightAsk idx
         */

        /**
         * Constructs a new FightAsk.
         * @memberof pb
         * @classdesc Represents a FightAsk.
         * @constructor
         * @param {pb.IFightAsk=} [properties] Properties to set
         */
        function FightAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * FightAsk tpe.
         * @member {number}tpe
         * @memberof pb.FightAsk
         * @instance
         */
        FightAsk.prototype.tpe = 0;

        /**
         * FightAsk idx.
         * @member {number}idx
         * @memberof pb.FightAsk
         * @instance
         */
        FightAsk.prototype.idx = 0;

        /**
         * Creates a new FightAsk instance using the specified properties.
         * @function create
         * @memberof pb.FightAsk
         * @static
         * @param {pb.IFightAsk=} [properties] Properties to set
         * @returns {pb.FightAsk} FightAsk instance
         */
        FightAsk.create = function create(properties) {
            return new FightAsk(properties);
        };

        /**
         * Encodes the specified FightAsk message. Does not implicitly {@link pb.FightAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.FightAsk
         * @static
         * @param {pb.IFightAsk} message FightAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FightAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.tpe);
            if (message.idx != null && message.hasOwnProperty("idx"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.idx);
            return writer;
        };

        /**
         * Encodes the specified FightAsk message, length delimited. Does not implicitly {@link pb.FightAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.FightAsk
         * @static
         * @param {pb.IFightAsk} message FightAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FightAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a FightAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.FightAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.FightAsk} FightAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FightAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.FightAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.tpe = reader.int32();
                    break;
                case 2:
                    message.idx = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a FightAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.FightAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.FightAsk} FightAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FightAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a FightAsk message.
         * @function verify
         * @memberof pb.FightAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        FightAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                if (!$util.isInteger(message.tpe))
                    return "tpe: integer expected";
            if (message.idx != null && message.hasOwnProperty("idx"))
                if (!$util.isInteger(message.idx))
                    return "idx: integer expected";
            return null;
        };

        /**
         * Creates a FightAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.FightAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.FightAsk} FightAsk
         */
        FightAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.FightAsk)
                return object;
            var message = new $root.pb.FightAsk();
            if (object.tpe != null)
                message.tpe = object.tpe | 0;
            if (object.idx != null)
                message.idx = object.idx | 0;
            return message;
        };

        /**
         * Creates a plain object from a FightAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.FightAsk
         * @static
         * @param {pb.FightAsk} message FightAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        FightAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.tpe = 0;
                object.idx = 0;
            }
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                object.tpe = message.tpe;
            if (message.idx != null && message.hasOwnProperty("idx"))
                object.idx = message.idx;
            return object;
        };

        /**
         * Converts this FightAsk to JSON.
         * @function toJSON
         * @memberof pb.FightAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        FightAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return FightAsk;
    })();

    pb.FightRes = (function() {

        /**
         * Properties of a FightRes.
         * @memberof pb
         * @interface IFightRes
         * @property {number} [ste] FightRes ste
         */

        /**
         * Constructs a new FightRes.
         * @memberof pb
         * @classdesc Represents a FightRes.
         * @constructor
         * @param {pb.IFightRes=} [properties] Properties to set
         */
        function FightRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * FightRes ste.
         * @member {number}ste
         * @memberof pb.FightRes
         * @instance
         */
        FightRes.prototype.ste = 0;

        /**
         * Creates a new FightRes instance using the specified properties.
         * @function create
         * @memberof pb.FightRes
         * @static
         * @param {pb.IFightRes=} [properties] Properties to set
         * @returns {pb.FightRes} FightRes instance
         */
        FightRes.create = function create(properties) {
            return new FightRes(properties);
        };

        /**
         * Encodes the specified FightRes message. Does not implicitly {@link pb.FightRes.verify|verify} messages.
         * @function encode
         * @memberof pb.FightRes
         * @static
         * @param {pb.IFightRes} message FightRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FightRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.ste != null && message.hasOwnProperty("ste"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.ste);
            return writer;
        };

        /**
         * Encodes the specified FightRes message, length delimited. Does not implicitly {@link pb.FightRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.FightRes
         * @static
         * @param {pb.IFightRes} message FightRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FightRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a FightRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.FightRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.FightRes} FightRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FightRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.FightRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.ste = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a FightRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.FightRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.FightRes} FightRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FightRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a FightRes message.
         * @function verify
         * @memberof pb.FightRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        FightRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.ste != null && message.hasOwnProperty("ste"))
                if (!$util.isInteger(message.ste))
                    return "ste: integer expected";
            return null;
        };

        /**
         * Creates a FightRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.FightRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.FightRes} FightRes
         */
        FightRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.FightRes)
                return object;
            var message = new $root.pb.FightRes();
            if (object.ste != null)
                message.ste = object.ste | 0;
            return message;
        };

        /**
         * Creates a plain object from a FightRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.FightRes
         * @static
         * @param {pb.FightRes} message FightRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        FightRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.ste = 0;
            if (message.ste != null && message.hasOwnProperty("ste"))
                object.ste = message.ste;
            return object;
        };

        /**
         * Converts this FightRes to JSON.
         * @function toJSON
         * @memberof pb.FightRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        FightRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return FightRes;
    })();

    pb.FightReadyAsk = (function() {

        /**
         * Properties of a FightReadyAsk.
         * @memberof pb
         * @interface IFightReadyAsk
         */

        /**
         * Constructs a new FightReadyAsk.
         * @memberof pb
         * @classdesc Represents a FightReadyAsk.
         * @constructor
         * @param {pb.IFightReadyAsk=} [properties] Properties to set
         */
        function FightReadyAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new FightReadyAsk instance using the specified properties.
         * @function create
         * @memberof pb.FightReadyAsk
         * @static
         * @param {pb.IFightReadyAsk=} [properties] Properties to set
         * @returns {pb.FightReadyAsk} FightReadyAsk instance
         */
        FightReadyAsk.create = function create(properties) {
            return new FightReadyAsk(properties);
        };

        /**
         * Encodes the specified FightReadyAsk message. Does not implicitly {@link pb.FightReadyAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.FightReadyAsk
         * @static
         * @param {pb.IFightReadyAsk} message FightReadyAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FightReadyAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified FightReadyAsk message, length delimited. Does not implicitly {@link pb.FightReadyAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.FightReadyAsk
         * @static
         * @param {pb.IFightReadyAsk} message FightReadyAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FightReadyAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a FightReadyAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.FightReadyAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.FightReadyAsk} FightReadyAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FightReadyAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.FightReadyAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a FightReadyAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.FightReadyAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.FightReadyAsk} FightReadyAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FightReadyAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a FightReadyAsk message.
         * @function verify
         * @memberof pb.FightReadyAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        FightReadyAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a FightReadyAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.FightReadyAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.FightReadyAsk} FightReadyAsk
         */
        FightReadyAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.FightReadyAsk)
                return object;
            return new $root.pb.FightReadyAsk();
        };

        /**
         * Creates a plain object from a FightReadyAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.FightReadyAsk
         * @static
         * @param {pb.FightReadyAsk} message FightReadyAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        FightReadyAsk.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this FightReadyAsk to JSON.
         * @function toJSON
         * @memberof pb.FightReadyAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        FightReadyAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return FightReadyAsk;
    })();

    pb.FightReadyRes = (function() {

        /**
         * Properties of a FightReadyRes.
         * @memberof pb
         * @interface IFightReadyRes
         */

        /**
         * Constructs a new FightReadyRes.
         * @memberof pb
         * @classdesc Represents a FightReadyRes.
         * @constructor
         * @param {pb.IFightReadyRes=} [properties] Properties to set
         */
        function FightReadyRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new FightReadyRes instance using the specified properties.
         * @function create
         * @memberof pb.FightReadyRes
         * @static
         * @param {pb.IFightReadyRes=} [properties] Properties to set
         * @returns {pb.FightReadyRes} FightReadyRes instance
         */
        FightReadyRes.create = function create(properties) {
            return new FightReadyRes(properties);
        };

        /**
         * Encodes the specified FightReadyRes message. Does not implicitly {@link pb.FightReadyRes.verify|verify} messages.
         * @function encode
         * @memberof pb.FightReadyRes
         * @static
         * @param {pb.IFightReadyRes} message FightReadyRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FightReadyRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified FightReadyRes message, length delimited. Does not implicitly {@link pb.FightReadyRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.FightReadyRes
         * @static
         * @param {pb.IFightReadyRes} message FightReadyRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FightReadyRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a FightReadyRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.FightReadyRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.FightReadyRes} FightReadyRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FightReadyRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.FightReadyRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a FightReadyRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.FightReadyRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.FightReadyRes} FightReadyRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FightReadyRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a FightReadyRes message.
         * @function verify
         * @memberof pb.FightReadyRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        FightReadyRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a FightReadyRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.FightReadyRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.FightReadyRes} FightReadyRes
         */
        FightReadyRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.FightReadyRes)
                return object;
            return new $root.pb.FightReadyRes();
        };

        /**
         * Creates a plain object from a FightReadyRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.FightReadyRes
         * @static
         * @param {pb.FightReadyRes} message FightReadyRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        FightReadyRes.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this FightReadyRes to JSON.
         * @function toJSON
         * @memberof pb.FightReadyRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        FightReadyRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return FightReadyRes;
    })();

    pb.FightLockAsk = (function() {

        /**
         * Properties of a FightLockAsk.
         * @memberof pb
         * @interface IFightLockAsk
         */

        /**
         * Constructs a new FightLockAsk.
         * @memberof pb
         * @classdesc Represents a FightLockAsk.
         * @constructor
         * @param {pb.IFightLockAsk=} [properties] Properties to set
         */
        function FightLockAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new FightLockAsk instance using the specified properties.
         * @function create
         * @memberof pb.FightLockAsk
         * @static
         * @param {pb.IFightLockAsk=} [properties] Properties to set
         * @returns {pb.FightLockAsk} FightLockAsk instance
         */
        FightLockAsk.create = function create(properties) {
            return new FightLockAsk(properties);
        };

        /**
         * Encodes the specified FightLockAsk message. Does not implicitly {@link pb.FightLockAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.FightLockAsk
         * @static
         * @param {pb.IFightLockAsk} message FightLockAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FightLockAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified FightLockAsk message, length delimited. Does not implicitly {@link pb.FightLockAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.FightLockAsk
         * @static
         * @param {pb.IFightLockAsk} message FightLockAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FightLockAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a FightLockAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.FightLockAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.FightLockAsk} FightLockAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FightLockAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.FightLockAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a FightLockAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.FightLockAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.FightLockAsk} FightLockAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FightLockAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a FightLockAsk message.
         * @function verify
         * @memberof pb.FightLockAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        FightLockAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a FightLockAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.FightLockAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.FightLockAsk} FightLockAsk
         */
        FightLockAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.FightLockAsk)
                return object;
            return new $root.pb.FightLockAsk();
        };

        /**
         * Creates a plain object from a FightLockAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.FightLockAsk
         * @static
         * @param {pb.FightLockAsk} message FightLockAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        FightLockAsk.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this FightLockAsk to JSON.
         * @function toJSON
         * @memberof pb.FightLockAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        FightLockAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return FightLockAsk;
    })();

    pb.FightLockRes = (function() {

        /**
         * Properties of a FightLockRes.
         * @memberof pb
         * @interface IFightLockRes
         */

        /**
         * Constructs a new FightLockRes.
         * @memberof pb
         * @classdesc Represents a FightLockRes.
         * @constructor
         * @param {pb.IFightLockRes=} [properties] Properties to set
         */
        function FightLockRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new FightLockRes instance using the specified properties.
         * @function create
         * @memberof pb.FightLockRes
         * @static
         * @param {pb.IFightLockRes=} [properties] Properties to set
         * @returns {pb.FightLockRes} FightLockRes instance
         */
        FightLockRes.create = function create(properties) {
            return new FightLockRes(properties);
        };

        /**
         * Encodes the specified FightLockRes message. Does not implicitly {@link pb.FightLockRes.verify|verify} messages.
         * @function encode
         * @memberof pb.FightLockRes
         * @static
         * @param {pb.IFightLockRes} message FightLockRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FightLockRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified FightLockRes message, length delimited. Does not implicitly {@link pb.FightLockRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.FightLockRes
         * @static
         * @param {pb.IFightLockRes} message FightLockRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FightLockRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a FightLockRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.FightLockRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.FightLockRes} FightLockRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FightLockRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.FightLockRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a FightLockRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.FightLockRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.FightLockRes} FightLockRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FightLockRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a FightLockRes message.
         * @function verify
         * @memberof pb.FightLockRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        FightLockRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a FightLockRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.FightLockRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.FightLockRes} FightLockRes
         */
        FightLockRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.FightLockRes)
                return object;
            return new $root.pb.FightLockRes();
        };

        /**
         * Creates a plain object from a FightLockRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.FightLockRes
         * @static
         * @param {pb.FightLockRes} message FightLockRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        FightLockRes.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this FightLockRes to JSON.
         * @function toJSON
         * @memberof pb.FightLockRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        FightLockRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return FightLockRes;
    })();

    pb.FightWinRes = (function() {

        /**
         * Properties of a FightWinRes.
         * @memberof pb
         * @interface IFightWinRes
         * @property {pb.IProperty} [pro] FightWinRes pro
         */

        /**
         * Constructs a new FightWinRes.
         * @memberof pb
         * @classdesc Represents a FightWinRes.
         * @constructor
         * @param {pb.IFightWinRes=} [properties] Properties to set
         */
        function FightWinRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * FightWinRes pro.
         * @member {(pb.IProperty|null|undefined)}pro
         * @memberof pb.FightWinRes
         * @instance
         */
        FightWinRes.prototype.pro = null;

        /**
         * Creates a new FightWinRes instance using the specified properties.
         * @function create
         * @memberof pb.FightWinRes
         * @static
         * @param {pb.IFightWinRes=} [properties] Properties to set
         * @returns {pb.FightWinRes} FightWinRes instance
         */
        FightWinRes.create = function create(properties) {
            return new FightWinRes(properties);
        };

        /**
         * Encodes the specified FightWinRes message. Does not implicitly {@link pb.FightWinRes.verify|verify} messages.
         * @function encode
         * @memberof pb.FightWinRes
         * @static
         * @param {pb.IFightWinRes} message FightWinRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FightWinRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.pro != null && message.hasOwnProperty("pro"))
                $root.pb.Property.encode(message.pro, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified FightWinRes message, length delimited. Does not implicitly {@link pb.FightWinRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.FightWinRes
         * @static
         * @param {pb.IFightWinRes} message FightWinRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FightWinRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a FightWinRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.FightWinRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.FightWinRes} FightWinRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FightWinRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.FightWinRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.pro = $root.pb.Property.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a FightWinRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.FightWinRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.FightWinRes} FightWinRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FightWinRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a FightWinRes message.
         * @function verify
         * @memberof pb.FightWinRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        FightWinRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.pro != null && message.hasOwnProperty("pro")) {
                var error = $root.pb.Property.verify(message.pro);
                if (error)
                    return "pro." + error;
            }
            return null;
        };

        /**
         * Creates a FightWinRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.FightWinRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.FightWinRes} FightWinRes
         */
        FightWinRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.FightWinRes)
                return object;
            var message = new $root.pb.FightWinRes();
            if (object.pro != null) {
                if (typeof object.pro !== "object")
                    throw TypeError(".pb.FightWinRes.pro: object expected");
                message.pro = $root.pb.Property.fromObject(object.pro);
            }
            return message;
        };

        /**
         * Creates a plain object from a FightWinRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.FightWinRes
         * @static
         * @param {pb.FightWinRes} message FightWinRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        FightWinRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.pro = null;
            if (message.pro != null && message.hasOwnProperty("pro"))
                object.pro = $root.pb.Property.toObject(message.pro, options);
            return object;
        };

        /**
         * Converts this FightWinRes to JSON.
         * @function toJSON
         * @memberof pb.FightWinRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        FightWinRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return FightWinRes;
    })();

    pb.FightFailRes = (function() {

        /**
         * Properties of a FightFailRes.
         * @memberof pb
         * @interface IFightFailRes
         */

        /**
         * Constructs a new FightFailRes.
         * @memberof pb
         * @classdesc Represents a FightFailRes.
         * @constructor
         * @param {pb.IFightFailRes=} [properties] Properties to set
         */
        function FightFailRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new FightFailRes instance using the specified properties.
         * @function create
         * @memberof pb.FightFailRes
         * @static
         * @param {pb.IFightFailRes=} [properties] Properties to set
         * @returns {pb.FightFailRes} FightFailRes instance
         */
        FightFailRes.create = function create(properties) {
            return new FightFailRes(properties);
        };

        /**
         * Encodes the specified FightFailRes message. Does not implicitly {@link pb.FightFailRes.verify|verify} messages.
         * @function encode
         * @memberof pb.FightFailRes
         * @static
         * @param {pb.IFightFailRes} message FightFailRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FightFailRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified FightFailRes message, length delimited. Does not implicitly {@link pb.FightFailRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.FightFailRes
         * @static
         * @param {pb.IFightFailRes} message FightFailRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FightFailRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a FightFailRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.FightFailRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.FightFailRes} FightFailRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FightFailRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.FightFailRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a FightFailRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.FightFailRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.FightFailRes} FightFailRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FightFailRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a FightFailRes message.
         * @function verify
         * @memberof pb.FightFailRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        FightFailRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a FightFailRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.FightFailRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.FightFailRes} FightFailRes
         */
        FightFailRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.FightFailRes)
                return object;
            return new $root.pb.FightFailRes();
        };

        /**
         * Creates a plain object from a FightFailRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.FightFailRes
         * @static
         * @param {pb.FightFailRes} message FightFailRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        FightFailRes.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this FightFailRes to JSON.
         * @function toJSON
         * @memberof pb.FightFailRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        FightFailRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return FightFailRes;
    })();

    pb.TipRes = (function() {

        /**
         * Properties of a TipRes.
         * @memberof pb
         * @interface ITipRes
         * @property {pb.IProperty} [pro] TipRes pro
         */

        /**
         * Constructs a new TipRes.
         * @memberof pb
         * @classdesc Represents a TipRes.
         * @constructor
         * @param {pb.ITipRes=} [properties] Properties to set
         */
        function TipRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TipRes pro.
         * @member {(pb.IProperty|null|undefined)}pro
         * @memberof pb.TipRes
         * @instance
         */
        TipRes.prototype.pro = null;

        /**
         * Creates a new TipRes instance using the specified properties.
         * @function create
         * @memberof pb.TipRes
         * @static
         * @param {pb.ITipRes=} [properties] Properties to set
         * @returns {pb.TipRes} TipRes instance
         */
        TipRes.create = function create(properties) {
            return new TipRes(properties);
        };

        /**
         * Encodes the specified TipRes message. Does not implicitly {@link pb.TipRes.verify|verify} messages.
         * @function encode
         * @memberof pb.TipRes
         * @static
         * @param {pb.ITipRes} message TipRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TipRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.pro != null && message.hasOwnProperty("pro"))
                $root.pb.Property.encode(message.pro, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TipRes message, length delimited. Does not implicitly {@link pb.TipRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.TipRes
         * @static
         * @param {pb.ITipRes} message TipRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TipRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TipRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.TipRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.TipRes} TipRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TipRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.TipRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.pro = $root.pb.Property.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TipRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.TipRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.TipRes} TipRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TipRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TipRes message.
         * @function verify
         * @memberof pb.TipRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TipRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.pro != null && message.hasOwnProperty("pro")) {
                var error = $root.pb.Property.verify(message.pro);
                if (error)
                    return "pro." + error;
            }
            return null;
        };

        /**
         * Creates a TipRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.TipRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.TipRes} TipRes
         */
        TipRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.TipRes)
                return object;
            var message = new $root.pb.TipRes();
            if (object.pro != null) {
                if (typeof object.pro !== "object")
                    throw TypeError(".pb.TipRes.pro: object expected");
                message.pro = $root.pb.Property.fromObject(object.pro);
            }
            return message;
        };

        /**
         * Creates a plain object from a TipRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.TipRes
         * @static
         * @param {pb.TipRes} message TipRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TipRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.pro = null;
            if (message.pro != null && message.hasOwnProperty("pro"))
                object.pro = $root.pb.Property.toObject(message.pro, options);
            return object;
        };

        /**
         * Converts this TipRes to JSON.
         * @function toJSON
         * @memberof pb.TipRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TipRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TipRes;
    })();

    pb.ReceiveRewardAsk = (function() {

        /**
         * Properties of a ReceiveRewardAsk.
         * @memberof pb
         * @interface IReceiveRewardAsk
         * @property {number} [tpe] ReceiveRewardAsk tpe
         * @property {number} [idx] ReceiveRewardAsk idx
         */

        /**
         * Constructs a new ReceiveRewardAsk.
         * @memberof pb
         * @classdesc Represents a ReceiveRewardAsk.
         * @constructor
         * @param {pb.IReceiveRewardAsk=} [properties] Properties to set
         */
        function ReceiveRewardAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ReceiveRewardAsk tpe.
         * @member {number}tpe
         * @memberof pb.ReceiveRewardAsk
         * @instance
         */
        ReceiveRewardAsk.prototype.tpe = 0;

        /**
         * ReceiveRewardAsk idx.
         * @member {number}idx
         * @memberof pb.ReceiveRewardAsk
         * @instance
         */
        ReceiveRewardAsk.prototype.idx = 0;

        /**
         * Creates a new ReceiveRewardAsk instance using the specified properties.
         * @function create
         * @memberof pb.ReceiveRewardAsk
         * @static
         * @param {pb.IReceiveRewardAsk=} [properties] Properties to set
         * @returns {pb.ReceiveRewardAsk} ReceiveRewardAsk instance
         */
        ReceiveRewardAsk.create = function create(properties) {
            return new ReceiveRewardAsk(properties);
        };

        /**
         * Encodes the specified ReceiveRewardAsk message. Does not implicitly {@link pb.ReceiveRewardAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.ReceiveRewardAsk
         * @static
         * @param {pb.IReceiveRewardAsk} message ReceiveRewardAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ReceiveRewardAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.tpe);
            if (message.idx != null && message.hasOwnProperty("idx"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.idx);
            return writer;
        };

        /**
         * Encodes the specified ReceiveRewardAsk message, length delimited. Does not implicitly {@link pb.ReceiveRewardAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.ReceiveRewardAsk
         * @static
         * @param {pb.IReceiveRewardAsk} message ReceiveRewardAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ReceiveRewardAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ReceiveRewardAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.ReceiveRewardAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.ReceiveRewardAsk} ReceiveRewardAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ReceiveRewardAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.ReceiveRewardAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.tpe = reader.int32();
                    break;
                case 2:
                    message.idx = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ReceiveRewardAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.ReceiveRewardAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.ReceiveRewardAsk} ReceiveRewardAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ReceiveRewardAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ReceiveRewardAsk message.
         * @function verify
         * @memberof pb.ReceiveRewardAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ReceiveRewardAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                if (!$util.isInteger(message.tpe))
                    return "tpe: integer expected";
            if (message.idx != null && message.hasOwnProperty("idx"))
                if (!$util.isInteger(message.idx))
                    return "idx: integer expected";
            return null;
        };

        /**
         * Creates a ReceiveRewardAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.ReceiveRewardAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.ReceiveRewardAsk} ReceiveRewardAsk
         */
        ReceiveRewardAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.ReceiveRewardAsk)
                return object;
            var message = new $root.pb.ReceiveRewardAsk();
            if (object.tpe != null)
                message.tpe = object.tpe | 0;
            if (object.idx != null)
                message.idx = object.idx | 0;
            return message;
        };

        /**
         * Creates a plain object from a ReceiveRewardAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.ReceiveRewardAsk
         * @static
         * @param {pb.ReceiveRewardAsk} message ReceiveRewardAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ReceiveRewardAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.tpe = 0;
                object.idx = 0;
            }
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                object.tpe = message.tpe;
            if (message.idx != null && message.hasOwnProperty("idx"))
                object.idx = message.idx;
            return object;
        };

        /**
         * Converts this ReceiveRewardAsk to JSON.
         * @function toJSON
         * @memberof pb.ReceiveRewardAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ReceiveRewardAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ReceiveRewardAsk;
    })();

    pb.ReceiveRewardRes = (function() {

        /**
         * Properties of a ReceiveRewardRes.
         * @memberof pb
         * @interface IReceiveRewardRes
         * @property {pb.IProperty} [pro] ReceiveRewardRes pro
         */

        /**
         * Constructs a new ReceiveRewardRes.
         * @memberof pb
         * @classdesc Represents a ReceiveRewardRes.
         * @constructor
         * @param {pb.IReceiveRewardRes=} [properties] Properties to set
         */
        function ReceiveRewardRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ReceiveRewardRes pro.
         * @member {(pb.IProperty|null|undefined)}pro
         * @memberof pb.ReceiveRewardRes
         * @instance
         */
        ReceiveRewardRes.prototype.pro = null;

        /**
         * Creates a new ReceiveRewardRes instance using the specified properties.
         * @function create
         * @memberof pb.ReceiveRewardRes
         * @static
         * @param {pb.IReceiveRewardRes=} [properties] Properties to set
         * @returns {pb.ReceiveRewardRes} ReceiveRewardRes instance
         */
        ReceiveRewardRes.create = function create(properties) {
            return new ReceiveRewardRes(properties);
        };

        /**
         * Encodes the specified ReceiveRewardRes message. Does not implicitly {@link pb.ReceiveRewardRes.verify|verify} messages.
         * @function encode
         * @memberof pb.ReceiveRewardRes
         * @static
         * @param {pb.IReceiveRewardRes} message ReceiveRewardRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ReceiveRewardRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.pro != null && message.hasOwnProperty("pro"))
                $root.pb.Property.encode(message.pro, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified ReceiveRewardRes message, length delimited. Does not implicitly {@link pb.ReceiveRewardRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.ReceiveRewardRes
         * @static
         * @param {pb.IReceiveRewardRes} message ReceiveRewardRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ReceiveRewardRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ReceiveRewardRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.ReceiveRewardRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.ReceiveRewardRes} ReceiveRewardRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ReceiveRewardRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.ReceiveRewardRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.pro = $root.pb.Property.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ReceiveRewardRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.ReceiveRewardRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.ReceiveRewardRes} ReceiveRewardRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ReceiveRewardRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ReceiveRewardRes message.
         * @function verify
         * @memberof pb.ReceiveRewardRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ReceiveRewardRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.pro != null && message.hasOwnProperty("pro")) {
                var error = $root.pb.Property.verify(message.pro);
                if (error)
                    return "pro." + error;
            }
            return null;
        };

        /**
         * Creates a ReceiveRewardRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.ReceiveRewardRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.ReceiveRewardRes} ReceiveRewardRes
         */
        ReceiveRewardRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.ReceiveRewardRes)
                return object;
            var message = new $root.pb.ReceiveRewardRes();
            if (object.pro != null) {
                if (typeof object.pro !== "object")
                    throw TypeError(".pb.ReceiveRewardRes.pro: object expected");
                message.pro = $root.pb.Property.fromObject(object.pro);
            }
            return message;
        };

        /**
         * Creates a plain object from a ReceiveRewardRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.ReceiveRewardRes
         * @static
         * @param {pb.ReceiveRewardRes} message ReceiveRewardRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ReceiveRewardRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.pro = null;
            if (message.pro != null && message.hasOwnProperty("pro"))
                object.pro = $root.pb.Property.toObject(message.pro, options);
            return object;
        };

        /**
         * Converts this ReceiveRewardRes to JSON.
         * @function toJSON
         * @memberof pb.ReceiveRewardRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ReceiveRewardRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ReceiveRewardRes;
    })();

    pb.QueryAsk = (function() {

        /**
         * Properties of a QueryAsk.
         * @memberof pb
         * @interface IQueryAsk
         * @property {number} [tpe] QueryAsk tpe
         */

        /**
         * Constructs a new QueryAsk.
         * @memberof pb
         * @classdesc Represents a QueryAsk.
         * @constructor
         * @param {pb.IQueryAsk=} [properties] Properties to set
         */
        function QueryAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * QueryAsk tpe.
         * @member {number}tpe
         * @memberof pb.QueryAsk
         * @instance
         */
        QueryAsk.prototype.tpe = 0;

        /**
         * Creates a new QueryAsk instance using the specified properties.
         * @function create
         * @memberof pb.QueryAsk
         * @static
         * @param {pb.IQueryAsk=} [properties] Properties to set
         * @returns {pb.QueryAsk} QueryAsk instance
         */
        QueryAsk.create = function create(properties) {
            return new QueryAsk(properties);
        };

        /**
         * Encodes the specified QueryAsk message. Does not implicitly {@link pb.QueryAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.QueryAsk
         * @static
         * @param {pb.IQueryAsk} message QueryAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        QueryAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.tpe);
            return writer;
        };

        /**
         * Encodes the specified QueryAsk message, length delimited. Does not implicitly {@link pb.QueryAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.QueryAsk
         * @static
         * @param {pb.IQueryAsk} message QueryAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        QueryAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a QueryAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.QueryAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.QueryAsk} QueryAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        QueryAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.QueryAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.tpe = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a QueryAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.QueryAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.QueryAsk} QueryAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        QueryAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a QueryAsk message.
         * @function verify
         * @memberof pb.QueryAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        QueryAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                if (!$util.isInteger(message.tpe))
                    return "tpe: integer expected";
            return null;
        };

        /**
         * Creates a QueryAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.QueryAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.QueryAsk} QueryAsk
         */
        QueryAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.QueryAsk)
                return object;
            var message = new $root.pb.QueryAsk();
            if (object.tpe != null)
                message.tpe = object.tpe | 0;
            return message;
        };

        /**
         * Creates a plain object from a QueryAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.QueryAsk
         * @static
         * @param {pb.QueryAsk} message QueryAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        QueryAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.tpe = 0;
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                object.tpe = message.tpe;
            return object;
        };

        /**
         * Converts this QueryAsk to JSON.
         * @function toJSON
         * @memberof pb.QueryAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        QueryAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return QueryAsk;
    })();

    pb.QueryRes = (function() {

        /**
         * Properties of a QueryRes.
         * @memberof pb
         * @interface IQueryRes
         * @property {number} [tpe] QueryRes tpe
         * @property {pb.IProperty} [pro] QueryRes pro
         */

        /**
         * Constructs a new QueryRes.
         * @memberof pb
         * @classdesc Represents a QueryRes.
         * @constructor
         * @param {pb.IQueryRes=} [properties] Properties to set
         */
        function QueryRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * QueryRes tpe.
         * @member {number}tpe
         * @memberof pb.QueryRes
         * @instance
         */
        QueryRes.prototype.tpe = 0;

        /**
         * QueryRes pro.
         * @member {(pb.IProperty|null|undefined)}pro
         * @memberof pb.QueryRes
         * @instance
         */
        QueryRes.prototype.pro = null;

        /**
         * Creates a new QueryRes instance using the specified properties.
         * @function create
         * @memberof pb.QueryRes
         * @static
         * @param {pb.IQueryRes=} [properties] Properties to set
         * @returns {pb.QueryRes} QueryRes instance
         */
        QueryRes.create = function create(properties) {
            return new QueryRes(properties);
        };

        /**
         * Encodes the specified QueryRes message. Does not implicitly {@link pb.QueryRes.verify|verify} messages.
         * @function encode
         * @memberof pb.QueryRes
         * @static
         * @param {pb.IQueryRes} message QueryRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        QueryRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.tpe);
            if (message.pro != null && message.hasOwnProperty("pro"))
                $root.pb.Property.encode(message.pro, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified QueryRes message, length delimited. Does not implicitly {@link pb.QueryRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.QueryRes
         * @static
         * @param {pb.IQueryRes} message QueryRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        QueryRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a QueryRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.QueryRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.QueryRes} QueryRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        QueryRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.QueryRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.tpe = reader.int32();
                    break;
                case 2:
                    message.pro = $root.pb.Property.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a QueryRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.QueryRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.QueryRes} QueryRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        QueryRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a QueryRes message.
         * @function verify
         * @memberof pb.QueryRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        QueryRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                if (!$util.isInteger(message.tpe))
                    return "tpe: integer expected";
            if (message.pro != null && message.hasOwnProperty("pro")) {
                var error = $root.pb.Property.verify(message.pro);
                if (error)
                    return "pro." + error;
            }
            return null;
        };

        /**
         * Creates a QueryRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.QueryRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.QueryRes} QueryRes
         */
        QueryRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.QueryRes)
                return object;
            var message = new $root.pb.QueryRes();
            if (object.tpe != null)
                message.tpe = object.tpe | 0;
            if (object.pro != null) {
                if (typeof object.pro !== "object")
                    throw TypeError(".pb.QueryRes.pro: object expected");
                message.pro = $root.pb.Property.fromObject(object.pro);
            }
            return message;
        };

        /**
         * Creates a plain object from a QueryRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.QueryRes
         * @static
         * @param {pb.QueryRes} message QueryRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        QueryRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.tpe = 0;
                object.pro = null;
            }
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                object.tpe = message.tpe;
            if (message.pro != null && message.hasOwnProperty("pro"))
                object.pro = $root.pb.Property.toObject(message.pro, options);
            return object;
        };

        /**
         * Converts this QueryRes to JSON.
         * @function toJSON
         * @memberof pb.QueryRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        QueryRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return QueryRes;
    })();

    pb.QueryFightAsk = (function() {

        /**
         * Properties of a QueryFightAsk.
         * @memberof pb
         * @interface IQueryFightAsk
         * @property {string} [id] QueryFightAsk id
         */

        /**
         * Constructs a new QueryFightAsk.
         * @memberof pb
         * @classdesc Represents a QueryFightAsk.
         * @constructor
         * @param {pb.IQueryFightAsk=} [properties] Properties to set
         */
        function QueryFightAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * QueryFightAsk id.
         * @member {string}id
         * @memberof pb.QueryFightAsk
         * @instance
         */
        QueryFightAsk.prototype.id = "";

        /**
         * Creates a new QueryFightAsk instance using the specified properties.
         * @function create
         * @memberof pb.QueryFightAsk
         * @static
         * @param {pb.IQueryFightAsk=} [properties] Properties to set
         * @returns {pb.QueryFightAsk} QueryFightAsk instance
         */
        QueryFightAsk.create = function create(properties) {
            return new QueryFightAsk(properties);
        };

        /**
         * Encodes the specified QueryFightAsk message. Does not implicitly {@link pb.QueryFightAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.QueryFightAsk
         * @static
         * @param {pb.IQueryFightAsk} message QueryFightAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        QueryFightAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.id != null && message.hasOwnProperty("id"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.id);
            return writer;
        };

        /**
         * Encodes the specified QueryFightAsk message, length delimited. Does not implicitly {@link pb.QueryFightAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.QueryFightAsk
         * @static
         * @param {pb.IQueryFightAsk} message QueryFightAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        QueryFightAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a QueryFightAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.QueryFightAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.QueryFightAsk} QueryFightAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        QueryFightAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.QueryFightAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.id = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a QueryFightAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.QueryFightAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.QueryFightAsk} QueryFightAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        QueryFightAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a QueryFightAsk message.
         * @function verify
         * @memberof pb.QueryFightAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        QueryFightAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.id != null && message.hasOwnProperty("id"))
                if (!$util.isString(message.id))
                    return "id: string expected";
            return null;
        };

        /**
         * Creates a QueryFightAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.QueryFightAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.QueryFightAsk} QueryFightAsk
         */
        QueryFightAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.QueryFightAsk)
                return object;
            var message = new $root.pb.QueryFightAsk();
            if (object.id != null)
                message.id = String(object.id);
            return message;
        };

        /**
         * Creates a plain object from a QueryFightAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.QueryFightAsk
         * @static
         * @param {pb.QueryFightAsk} message QueryFightAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        QueryFightAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.id = "";
            if (message.id != null && message.hasOwnProperty("id"))
                object.id = message.id;
            return object;
        };

        /**
         * Converts this QueryFightAsk to JSON.
         * @function toJSON
         * @memberof pb.QueryFightAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        QueryFightAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return QueryFightAsk;
    })();

    pb.QueryFightRes = (function() {

        /**
         * Properties of a QueryFightRes.
         * @memberof pb
         * @interface IQueryFightRes
         * @property {pb.IPropertyDown} [pd] QueryFightRes pd
         */

        /**
         * Constructs a new QueryFightRes.
         * @memberof pb
         * @classdesc Represents a QueryFightRes.
         * @constructor
         * @param {pb.IQueryFightRes=} [properties] Properties to set
         */
        function QueryFightRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * QueryFightRes pd.
         * @member {(pb.IPropertyDown|null|undefined)}pd
         * @memberof pb.QueryFightRes
         * @instance
         */
        QueryFightRes.prototype.pd = null;

        /**
         * Creates a new QueryFightRes instance using the specified properties.
         * @function create
         * @memberof pb.QueryFightRes
         * @static
         * @param {pb.IQueryFightRes=} [properties] Properties to set
         * @returns {pb.QueryFightRes} QueryFightRes instance
         */
        QueryFightRes.create = function create(properties) {
            return new QueryFightRes(properties);
        };

        /**
         * Encodes the specified QueryFightRes message. Does not implicitly {@link pb.QueryFightRes.verify|verify} messages.
         * @function encode
         * @memberof pb.QueryFightRes
         * @static
         * @param {pb.IQueryFightRes} message QueryFightRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        QueryFightRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.pd != null && message.hasOwnProperty("pd"))
                $root.pb.PropertyDown.encode(message.pd, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified QueryFightRes message, length delimited. Does not implicitly {@link pb.QueryFightRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.QueryFightRes
         * @static
         * @param {pb.IQueryFightRes} message QueryFightRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        QueryFightRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a QueryFightRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.QueryFightRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.QueryFightRes} QueryFightRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        QueryFightRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.QueryFightRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 2:
                    message.pd = $root.pb.PropertyDown.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a QueryFightRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.QueryFightRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.QueryFightRes} QueryFightRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        QueryFightRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a QueryFightRes message.
         * @function verify
         * @memberof pb.QueryFightRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        QueryFightRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.pd != null && message.hasOwnProperty("pd")) {
                var error = $root.pb.PropertyDown.verify(message.pd);
                if (error)
                    return "pd." + error;
            }
            return null;
        };

        /**
         * Creates a QueryFightRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.QueryFightRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.QueryFightRes} QueryFightRes
         */
        QueryFightRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.QueryFightRes)
                return object;
            var message = new $root.pb.QueryFightRes();
            if (object.pd != null) {
                if (typeof object.pd !== "object")
                    throw TypeError(".pb.QueryFightRes.pd: object expected");
                message.pd = $root.pb.PropertyDown.fromObject(object.pd);
            }
            return message;
        };

        /**
         * Creates a plain object from a QueryFightRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.QueryFightRes
         * @static
         * @param {pb.QueryFightRes} message QueryFightRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        QueryFightRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.pd = null;
            if (message.pd != null && message.hasOwnProperty("pd"))
                object.pd = $root.pb.PropertyDown.toObject(message.pd, options);
            return object;
        };

        /**
         * Converts this QueryFightRes to JSON.
         * @function toJSON
         * @memberof pb.QueryFightRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        QueryFightRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return QueryFightRes;
    })();

    pb.FightYouAsk = (function() {

        /**
         * Properties of a FightYouAsk.
         * @memberof pb
         * @interface IFightYouAsk
         * @property {string} [id] FightYouAsk id
         */

        /**
         * Constructs a new FightYouAsk.
         * @memberof pb
         * @classdesc Represents a FightYouAsk.
         * @constructor
         * @param {pb.IFightYouAsk=} [properties] Properties to set
         */
        function FightYouAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * FightYouAsk id.
         * @member {string}id
         * @memberof pb.FightYouAsk
         * @instance
         */
        FightYouAsk.prototype.id = "";

        /**
         * Creates a new FightYouAsk instance using the specified properties.
         * @function create
         * @memberof pb.FightYouAsk
         * @static
         * @param {pb.IFightYouAsk=} [properties] Properties to set
         * @returns {pb.FightYouAsk} FightYouAsk instance
         */
        FightYouAsk.create = function create(properties) {
            return new FightYouAsk(properties);
        };

        /**
         * Encodes the specified FightYouAsk message. Does not implicitly {@link pb.FightYouAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.FightYouAsk
         * @static
         * @param {pb.IFightYouAsk} message FightYouAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FightYouAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.id != null && message.hasOwnProperty("id"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.id);
            return writer;
        };

        /**
         * Encodes the specified FightYouAsk message, length delimited. Does not implicitly {@link pb.FightYouAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.FightYouAsk
         * @static
         * @param {pb.IFightYouAsk} message FightYouAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FightYouAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a FightYouAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.FightYouAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.FightYouAsk} FightYouAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FightYouAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.FightYouAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.id = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a FightYouAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.FightYouAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.FightYouAsk} FightYouAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FightYouAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a FightYouAsk message.
         * @function verify
         * @memberof pb.FightYouAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        FightYouAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.id != null && message.hasOwnProperty("id"))
                if (!$util.isString(message.id))
                    return "id: string expected";
            return null;
        };

        /**
         * Creates a FightYouAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.FightYouAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.FightYouAsk} FightYouAsk
         */
        FightYouAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.FightYouAsk)
                return object;
            var message = new $root.pb.FightYouAsk();
            if (object.id != null)
                message.id = String(object.id);
            return message;
        };

        /**
         * Creates a plain object from a FightYouAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.FightYouAsk
         * @static
         * @param {pb.FightYouAsk} message FightYouAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        FightYouAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.id = "";
            if (message.id != null && message.hasOwnProperty("id"))
                object.id = message.id;
            return object;
        };

        /**
         * Converts this FightYouAsk to JSON.
         * @function toJSON
         * @memberof pb.FightYouAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        FightYouAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return FightYouAsk;
    })();

    pb.QueryKingAsk = (function() {

        /**
         * Properties of a QueryKingAsk.
         * @memberof pb
         * @interface IQueryKingAsk
         * @property {number} [id] QueryKingAsk id
         * @property {string} [uid] QueryKingAsk uid
         */

        /**
         * Constructs a new QueryKingAsk.
         * @memberof pb
         * @classdesc Represents a QueryKingAsk.
         * @constructor
         * @param {pb.IQueryKingAsk=} [properties] Properties to set
         */
        function QueryKingAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * QueryKingAsk id.
         * @member {number}id
         * @memberof pb.QueryKingAsk
         * @instance
         */
        QueryKingAsk.prototype.id = 0;

        /**
         * QueryKingAsk uid.
         * @member {string}uid
         * @memberof pb.QueryKingAsk
         * @instance
         */
        QueryKingAsk.prototype.uid = "";

        /**
         * Creates a new QueryKingAsk instance using the specified properties.
         * @function create
         * @memberof pb.QueryKingAsk
         * @static
         * @param {pb.IQueryKingAsk=} [properties] Properties to set
         * @returns {pb.QueryKingAsk} QueryKingAsk instance
         */
        QueryKingAsk.create = function create(properties) {
            return new QueryKingAsk(properties);
        };

        /**
         * Encodes the specified QueryKingAsk message. Does not implicitly {@link pb.QueryKingAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.QueryKingAsk
         * @static
         * @param {pb.IQueryKingAsk} message QueryKingAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        QueryKingAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.id != null && message.hasOwnProperty("id"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.id);
            if (message.uid != null && message.hasOwnProperty("uid"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.uid);
            return writer;
        };

        /**
         * Encodes the specified QueryKingAsk message, length delimited. Does not implicitly {@link pb.QueryKingAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.QueryKingAsk
         * @static
         * @param {pb.IQueryKingAsk} message QueryKingAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        QueryKingAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a QueryKingAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.QueryKingAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.QueryKingAsk} QueryKingAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        QueryKingAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.QueryKingAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.id = reader.int32();
                    break;
                case 2:
                    message.uid = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a QueryKingAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.QueryKingAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.QueryKingAsk} QueryKingAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        QueryKingAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a QueryKingAsk message.
         * @function verify
         * @memberof pb.QueryKingAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        QueryKingAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.id != null && message.hasOwnProperty("id"))
                if (!$util.isInteger(message.id))
                    return "id: integer expected";
            if (message.uid != null && message.hasOwnProperty("uid"))
                if (!$util.isString(message.uid))
                    return "uid: string expected";
            return null;
        };

        /**
         * Creates a QueryKingAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.QueryKingAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.QueryKingAsk} QueryKingAsk
         */
        QueryKingAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.QueryKingAsk)
                return object;
            var message = new $root.pb.QueryKingAsk();
            if (object.id != null)
                message.id = object.id | 0;
            if (object.uid != null)
                message.uid = String(object.uid);
            return message;
        };

        /**
         * Creates a plain object from a QueryKingAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.QueryKingAsk
         * @static
         * @param {pb.QueryKingAsk} message QueryKingAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        QueryKingAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.id = 0;
                object.uid = "";
            }
            if (message.id != null && message.hasOwnProperty("id"))
                object.id = message.id;
            if (message.uid != null && message.hasOwnProperty("uid"))
                object.uid = message.uid;
            return object;
        };

        /**
         * Converts this QueryKingAsk to JSON.
         * @function toJSON
         * @memberof pb.QueryKingAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        QueryKingAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return QueryKingAsk;
    })();

    pb.FightKingAsk = (function() {

        /**
         * Properties of a FightKingAsk.
         * @memberof pb
         * @interface IFightKingAsk
         * @property {number} [id] FightKingAsk id
         * @property {string} [uid] FightKingAsk uid
         */

        /**
         * Constructs a new FightKingAsk.
         * @memberof pb
         * @classdesc Represents a FightKingAsk.
         * @constructor
         * @param {pb.IFightKingAsk=} [properties] Properties to set
         */
        function FightKingAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * FightKingAsk id.
         * @member {number}id
         * @memberof pb.FightKingAsk
         * @instance
         */
        FightKingAsk.prototype.id = 0;

        /**
         * FightKingAsk uid.
         * @member {string}uid
         * @memberof pb.FightKingAsk
         * @instance
         */
        FightKingAsk.prototype.uid = "";

        /**
         * Creates a new FightKingAsk instance using the specified properties.
         * @function create
         * @memberof pb.FightKingAsk
         * @static
         * @param {pb.IFightKingAsk=} [properties] Properties to set
         * @returns {pb.FightKingAsk} FightKingAsk instance
         */
        FightKingAsk.create = function create(properties) {
            return new FightKingAsk(properties);
        };

        /**
         * Encodes the specified FightKingAsk message. Does not implicitly {@link pb.FightKingAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.FightKingAsk
         * @static
         * @param {pb.IFightKingAsk} message FightKingAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FightKingAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.id != null && message.hasOwnProperty("id"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.id);
            if (message.uid != null && message.hasOwnProperty("uid"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.uid);
            return writer;
        };

        /**
         * Encodes the specified FightKingAsk message, length delimited. Does not implicitly {@link pb.FightKingAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.FightKingAsk
         * @static
         * @param {pb.IFightKingAsk} message FightKingAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FightKingAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a FightKingAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.FightKingAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.FightKingAsk} FightKingAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FightKingAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.FightKingAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.id = reader.int32();
                    break;
                case 2:
                    message.uid = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a FightKingAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.FightKingAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.FightKingAsk} FightKingAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FightKingAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a FightKingAsk message.
         * @function verify
         * @memberof pb.FightKingAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        FightKingAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.id != null && message.hasOwnProperty("id"))
                if (!$util.isInteger(message.id))
                    return "id: integer expected";
            if (message.uid != null && message.hasOwnProperty("uid"))
                if (!$util.isString(message.uid))
                    return "uid: string expected";
            return null;
        };

        /**
         * Creates a FightKingAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.FightKingAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.FightKingAsk} FightKingAsk
         */
        FightKingAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.FightKingAsk)
                return object;
            var message = new $root.pb.FightKingAsk();
            if (object.id != null)
                message.id = object.id | 0;
            if (object.uid != null)
                message.uid = String(object.uid);
            return message;
        };

        /**
         * Creates a plain object from a FightKingAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.FightKingAsk
         * @static
         * @param {pb.FightKingAsk} message FightKingAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        FightKingAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.id = 0;
                object.uid = "";
            }
            if (message.id != null && message.hasOwnProperty("id"))
                object.id = message.id;
            if (message.uid != null && message.hasOwnProperty("uid"))
                object.uid = message.uid;
            return object;
        };

        /**
         * Converts this FightKingAsk to JSON.
         * @function toJSON
         * @memberof pb.FightKingAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        FightKingAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return FightKingAsk;
    })();

    pb.ShuaRes = (function() {

        /**
         * Properties of a ShuaRes.
         * @memberof pb
         * @interface IShuaRes
         * @property {number} [tpe] ShuaRes tpe
         */

        /**
         * Constructs a new ShuaRes.
         * @memberof pb
         * @classdesc Represents a ShuaRes.
         * @constructor
         * @param {pb.IShuaRes=} [properties] Properties to set
         */
        function ShuaRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ShuaRes tpe.
         * @member {number}tpe
         * @memberof pb.ShuaRes
         * @instance
         */
        ShuaRes.prototype.tpe = 0;

        /**
         * Creates a new ShuaRes instance using the specified properties.
         * @function create
         * @memberof pb.ShuaRes
         * @static
         * @param {pb.IShuaRes=} [properties] Properties to set
         * @returns {pb.ShuaRes} ShuaRes instance
         */
        ShuaRes.create = function create(properties) {
            return new ShuaRes(properties);
        };

        /**
         * Encodes the specified ShuaRes message. Does not implicitly {@link pb.ShuaRes.verify|verify} messages.
         * @function encode
         * @memberof pb.ShuaRes
         * @static
         * @param {pb.IShuaRes} message ShuaRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ShuaRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.tpe);
            return writer;
        };

        /**
         * Encodes the specified ShuaRes message, length delimited. Does not implicitly {@link pb.ShuaRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.ShuaRes
         * @static
         * @param {pb.IShuaRes} message ShuaRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ShuaRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ShuaRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.ShuaRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.ShuaRes} ShuaRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ShuaRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.ShuaRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.tpe = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ShuaRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.ShuaRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.ShuaRes} ShuaRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ShuaRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ShuaRes message.
         * @function verify
         * @memberof pb.ShuaRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ShuaRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                if (!$util.isInteger(message.tpe))
                    return "tpe: integer expected";
            return null;
        };

        /**
         * Creates a ShuaRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.ShuaRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.ShuaRes} ShuaRes
         */
        ShuaRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.ShuaRes)
                return object;
            var message = new $root.pb.ShuaRes();
            if (object.tpe != null)
                message.tpe = object.tpe | 0;
            return message;
        };

        /**
         * Creates a plain object from a ShuaRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.ShuaRes
         * @static
         * @param {pb.ShuaRes} message ShuaRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ShuaRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.tpe = 0;
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                object.tpe = message.tpe;
            return object;
        };

        /**
         * Converts this ShuaRes to JSON.
         * @function toJSON
         * @memberof pb.ShuaRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ShuaRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ShuaRes;
    })();

    pb.MoneyGoAsk = (function() {

        /**
         * Properties of a MoneyGoAsk.
         * @memberof pb
         * @interface IMoneyGoAsk
         * @property {number} [idx] MoneyGoAsk idx
         * @property {number} [itemid] MoneyGoAsk itemid
         */

        /**
         * Constructs a new MoneyGoAsk.
         * @memberof pb
         * @classdesc Represents a MoneyGoAsk.
         * @constructor
         * @param {pb.IMoneyGoAsk=} [properties] Properties to set
         */
        function MoneyGoAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * MoneyGoAsk idx.
         * @member {number}idx
         * @memberof pb.MoneyGoAsk
         * @instance
         */
        MoneyGoAsk.prototype.idx = 0;

        /**
         * MoneyGoAsk itemid.
         * @member {number}itemid
         * @memberof pb.MoneyGoAsk
         * @instance
         */
        MoneyGoAsk.prototype.itemid = 0;

        /**
         * Creates a new MoneyGoAsk instance using the specified properties.
         * @function create
         * @memberof pb.MoneyGoAsk
         * @static
         * @param {pb.IMoneyGoAsk=} [properties] Properties to set
         * @returns {pb.MoneyGoAsk} MoneyGoAsk instance
         */
        MoneyGoAsk.create = function create(properties) {
            return new MoneyGoAsk(properties);
        };

        /**
         * Encodes the specified MoneyGoAsk message. Does not implicitly {@link pb.MoneyGoAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.MoneyGoAsk
         * @static
         * @param {pb.IMoneyGoAsk} message MoneyGoAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        MoneyGoAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.idx != null && message.hasOwnProperty("idx"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.idx);
            if (message.itemid != null && message.hasOwnProperty("itemid"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.itemid);
            return writer;
        };

        /**
         * Encodes the specified MoneyGoAsk message, length delimited. Does not implicitly {@link pb.MoneyGoAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.MoneyGoAsk
         * @static
         * @param {pb.IMoneyGoAsk} message MoneyGoAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        MoneyGoAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a MoneyGoAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.MoneyGoAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.MoneyGoAsk} MoneyGoAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        MoneyGoAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.MoneyGoAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.idx = reader.int32();
                    break;
                case 2:
                    message.itemid = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a MoneyGoAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.MoneyGoAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.MoneyGoAsk} MoneyGoAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        MoneyGoAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a MoneyGoAsk message.
         * @function verify
         * @memberof pb.MoneyGoAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        MoneyGoAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.idx != null && message.hasOwnProperty("idx"))
                if (!$util.isInteger(message.idx))
                    return "idx: integer expected";
            if (message.itemid != null && message.hasOwnProperty("itemid"))
                if (!$util.isInteger(message.itemid))
                    return "itemid: integer expected";
            return null;
        };

        /**
         * Creates a MoneyGoAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.MoneyGoAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.MoneyGoAsk} MoneyGoAsk
         */
        MoneyGoAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.MoneyGoAsk)
                return object;
            var message = new $root.pb.MoneyGoAsk();
            if (object.idx != null)
                message.idx = object.idx | 0;
            if (object.itemid != null)
                message.itemid = object.itemid | 0;
            return message;
        };

        /**
         * Creates a plain object from a MoneyGoAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.MoneyGoAsk
         * @static
         * @param {pb.MoneyGoAsk} message MoneyGoAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        MoneyGoAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.idx = 0;
                object.itemid = 0;
            }
            if (message.idx != null && message.hasOwnProperty("idx"))
                object.idx = message.idx;
            if (message.itemid != null && message.hasOwnProperty("itemid"))
                object.itemid = message.itemid;
            return object;
        };

        /**
         * Converts this MoneyGoAsk to JSON.
         * @function toJSON
         * @memberof pb.MoneyGoAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        MoneyGoAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return MoneyGoAsk;
    })();

    pb.MoneyChaRes = (function() {

        /**
         * Properties of a MoneyChaRes.
         * @memberof pb
         * @interface IMoneyChaRes
         * @property {number} [idx] MoneyChaRes idx
         * @property {number} [itemid] MoneyChaRes itemid
         * @property {number} [val] MoneyChaRes val
         */

        /**
         * Constructs a new MoneyChaRes.
         * @memberof pb
         * @classdesc Represents a MoneyChaRes.
         * @constructor
         * @param {pb.IMoneyChaRes=} [properties] Properties to set
         */
        function MoneyChaRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * MoneyChaRes idx.
         * @member {number}idx
         * @memberof pb.MoneyChaRes
         * @instance
         */
        MoneyChaRes.prototype.idx = 0;

        /**
         * MoneyChaRes itemid.
         * @member {number}itemid
         * @memberof pb.MoneyChaRes
         * @instance
         */
        MoneyChaRes.prototype.itemid = 0;

        /**
         * MoneyChaRes val.
         * @member {number}val
         * @memberof pb.MoneyChaRes
         * @instance
         */
        MoneyChaRes.prototype.val = 0;

        /**
         * Creates a new MoneyChaRes instance using the specified properties.
         * @function create
         * @memberof pb.MoneyChaRes
         * @static
         * @param {pb.IMoneyChaRes=} [properties] Properties to set
         * @returns {pb.MoneyChaRes} MoneyChaRes instance
         */
        MoneyChaRes.create = function create(properties) {
            return new MoneyChaRes(properties);
        };

        /**
         * Encodes the specified MoneyChaRes message. Does not implicitly {@link pb.MoneyChaRes.verify|verify} messages.
         * @function encode
         * @memberof pb.MoneyChaRes
         * @static
         * @param {pb.IMoneyChaRes} message MoneyChaRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        MoneyChaRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.idx != null && message.hasOwnProperty("idx"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.idx);
            if (message.itemid != null && message.hasOwnProperty("itemid"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.itemid);
            if (message.val != null && message.hasOwnProperty("val"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.val);
            return writer;
        };

        /**
         * Encodes the specified MoneyChaRes message, length delimited. Does not implicitly {@link pb.MoneyChaRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.MoneyChaRes
         * @static
         * @param {pb.IMoneyChaRes} message MoneyChaRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        MoneyChaRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a MoneyChaRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.MoneyChaRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.MoneyChaRes} MoneyChaRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        MoneyChaRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.MoneyChaRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.idx = reader.int32();
                    break;
                case 2:
                    message.itemid = reader.int32();
                    break;
                case 3:
                    message.val = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a MoneyChaRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.MoneyChaRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.MoneyChaRes} MoneyChaRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        MoneyChaRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a MoneyChaRes message.
         * @function verify
         * @memberof pb.MoneyChaRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        MoneyChaRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.idx != null && message.hasOwnProperty("idx"))
                if (!$util.isInteger(message.idx))
                    return "idx: integer expected";
            if (message.itemid != null && message.hasOwnProperty("itemid"))
                if (!$util.isInteger(message.itemid))
                    return "itemid: integer expected";
            if (message.val != null && message.hasOwnProperty("val"))
                if (!$util.isInteger(message.val))
                    return "val: integer expected";
            return null;
        };

        /**
         * Creates a MoneyChaRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.MoneyChaRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.MoneyChaRes} MoneyChaRes
         */
        MoneyChaRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.MoneyChaRes)
                return object;
            var message = new $root.pb.MoneyChaRes();
            if (object.idx != null)
                message.idx = object.idx | 0;
            if (object.itemid != null)
                message.itemid = object.itemid | 0;
            if (object.val != null)
                message.val = object.val | 0;
            return message;
        };

        /**
         * Creates a plain object from a MoneyChaRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.MoneyChaRes
         * @static
         * @param {pb.MoneyChaRes} message MoneyChaRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        MoneyChaRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.idx = 0;
                object.itemid = 0;
                object.val = 0;
            }
            if (message.idx != null && message.hasOwnProperty("idx"))
                object.idx = message.idx;
            if (message.itemid != null && message.hasOwnProperty("itemid"))
                object.itemid = message.itemid;
            if (message.val != null && message.hasOwnProperty("val"))
                object.val = message.val;
            return object;
        };

        /**
         * Converts this MoneyChaRes to JSON.
         * @function toJSON
         * @memberof pb.MoneyChaRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        MoneyChaRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return MoneyChaRes;
    })();

    pb.MoneyBuyOkRes = (function() {

        /**
         * Properties of a MoneyBuyOkRes.
         * @memberof pb
         * @interface IMoneyBuyOkRes
         * @property {number} [idx] MoneyBuyOkRes idx
         * @property {number} [itemid] MoneyBuyOkRes itemid
         */

        /**
         * Constructs a new MoneyBuyOkRes.
         * @memberof pb
         * @classdesc Represents a MoneyBuyOkRes.
         * @constructor
         * @param {pb.IMoneyBuyOkRes=} [properties] Properties to set
         */
        function MoneyBuyOkRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * MoneyBuyOkRes idx.
         * @member {number}idx
         * @memberof pb.MoneyBuyOkRes
         * @instance
         */
        MoneyBuyOkRes.prototype.idx = 0;

        /**
         * MoneyBuyOkRes itemid.
         * @member {number}itemid
         * @memberof pb.MoneyBuyOkRes
         * @instance
         */
        MoneyBuyOkRes.prototype.itemid = 0;

        /**
         * Creates a new MoneyBuyOkRes instance using the specified properties.
         * @function create
         * @memberof pb.MoneyBuyOkRes
         * @static
         * @param {pb.IMoneyBuyOkRes=} [properties] Properties to set
         * @returns {pb.MoneyBuyOkRes} MoneyBuyOkRes instance
         */
        MoneyBuyOkRes.create = function create(properties) {
            return new MoneyBuyOkRes(properties);
        };

        /**
         * Encodes the specified MoneyBuyOkRes message. Does not implicitly {@link pb.MoneyBuyOkRes.verify|verify} messages.
         * @function encode
         * @memberof pb.MoneyBuyOkRes
         * @static
         * @param {pb.IMoneyBuyOkRes} message MoneyBuyOkRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        MoneyBuyOkRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.idx != null && message.hasOwnProperty("idx"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.idx);
            if (message.itemid != null && message.hasOwnProperty("itemid"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.itemid);
            return writer;
        };

        /**
         * Encodes the specified MoneyBuyOkRes message, length delimited. Does not implicitly {@link pb.MoneyBuyOkRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.MoneyBuyOkRes
         * @static
         * @param {pb.IMoneyBuyOkRes} message MoneyBuyOkRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        MoneyBuyOkRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a MoneyBuyOkRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.MoneyBuyOkRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.MoneyBuyOkRes} MoneyBuyOkRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        MoneyBuyOkRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.MoneyBuyOkRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.idx = reader.int32();
                    break;
                case 2:
                    message.itemid = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a MoneyBuyOkRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.MoneyBuyOkRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.MoneyBuyOkRes} MoneyBuyOkRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        MoneyBuyOkRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a MoneyBuyOkRes message.
         * @function verify
         * @memberof pb.MoneyBuyOkRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        MoneyBuyOkRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.idx != null && message.hasOwnProperty("idx"))
                if (!$util.isInteger(message.idx))
                    return "idx: integer expected";
            if (message.itemid != null && message.hasOwnProperty("itemid"))
                if (!$util.isInteger(message.itemid))
                    return "itemid: integer expected";
            return null;
        };

        /**
         * Creates a MoneyBuyOkRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.MoneyBuyOkRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.MoneyBuyOkRes} MoneyBuyOkRes
         */
        MoneyBuyOkRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.MoneyBuyOkRes)
                return object;
            var message = new $root.pb.MoneyBuyOkRes();
            if (object.idx != null)
                message.idx = object.idx | 0;
            if (object.itemid != null)
                message.itemid = object.itemid | 0;
            return message;
        };

        /**
         * Creates a plain object from a MoneyBuyOkRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.MoneyBuyOkRes
         * @static
         * @param {pb.MoneyBuyOkRes} message MoneyBuyOkRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        MoneyBuyOkRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.idx = 0;
                object.itemid = 0;
            }
            if (message.idx != null && message.hasOwnProperty("idx"))
                object.idx = message.idx;
            if (message.itemid != null && message.hasOwnProperty("itemid"))
                object.itemid = message.itemid;
            return object;
        };

        /**
         * Converts this MoneyBuyOkRes to JSON.
         * @function toJSON
         * @memberof pb.MoneyBuyOkRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        MoneyBuyOkRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return MoneyBuyOkRes;
    })();

    pb.FiveChangeAsk = (function() {

        /**
         * Properties of a FiveChangeAsk.
         * @memberof pb
         * @interface IFiveChangeAsk
         * @property {string} [index] FiveChangeAsk index
         */

        /**
         * Constructs a new FiveChangeAsk.
         * @memberof pb
         * @classdesc Represents a FiveChangeAsk.
         * @constructor
         * @param {pb.IFiveChangeAsk=} [properties] Properties to set
         */
        function FiveChangeAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * FiveChangeAsk index.
         * @member {string}index
         * @memberof pb.FiveChangeAsk
         * @instance
         */
        FiveChangeAsk.prototype.index = "";

        /**
         * Creates a new FiveChangeAsk instance using the specified properties.
         * @function create
         * @memberof pb.FiveChangeAsk
         * @static
         * @param {pb.IFiveChangeAsk=} [properties] Properties to set
         * @returns {pb.FiveChangeAsk} FiveChangeAsk instance
         */
        FiveChangeAsk.create = function create(properties) {
            return new FiveChangeAsk(properties);
        };

        /**
         * Encodes the specified FiveChangeAsk message. Does not implicitly {@link pb.FiveChangeAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.FiveChangeAsk
         * @static
         * @param {pb.IFiveChangeAsk} message FiveChangeAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FiveChangeAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.index != null && message.hasOwnProperty("index"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.index);
            return writer;
        };

        /**
         * Encodes the specified FiveChangeAsk message, length delimited. Does not implicitly {@link pb.FiveChangeAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.FiveChangeAsk
         * @static
         * @param {pb.IFiveChangeAsk} message FiveChangeAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FiveChangeAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a FiveChangeAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.FiveChangeAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.FiveChangeAsk} FiveChangeAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FiveChangeAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.FiveChangeAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.index = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a FiveChangeAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.FiveChangeAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.FiveChangeAsk} FiveChangeAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FiveChangeAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a FiveChangeAsk message.
         * @function verify
         * @memberof pb.FiveChangeAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        FiveChangeAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.index != null && message.hasOwnProperty("index"))
                if (!$util.isString(message.index))
                    return "index: string expected";
            return null;
        };

        /**
         * Creates a FiveChangeAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.FiveChangeAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.FiveChangeAsk} FiveChangeAsk
         */
        FiveChangeAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.FiveChangeAsk)
                return object;
            var message = new $root.pb.FiveChangeAsk();
            if (object.index != null)
                message.index = String(object.index);
            return message;
        };

        /**
         * Creates a plain object from a FiveChangeAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.FiveChangeAsk
         * @static
         * @param {pb.FiveChangeAsk} message FiveChangeAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        FiveChangeAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.index = "";
            if (message.index != null && message.hasOwnProperty("index"))
                object.index = message.index;
            return object;
        };

        /**
         * Converts this FiveChangeAsk to JSON.
         * @function toJSON
         * @memberof pb.FiveChangeAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        FiveChangeAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return FiveChangeAsk;
    })();

    pb.FiveChangeRes = (function() {

        /**
         * Properties of a FiveChangeRes.
         * @memberof pb
         * @interface IFiveChangeRes
         */

        /**
         * Constructs a new FiveChangeRes.
         * @memberof pb
         * @classdesc Represents a FiveChangeRes.
         * @constructor
         * @param {pb.IFiveChangeRes=} [properties] Properties to set
         */
        function FiveChangeRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new FiveChangeRes instance using the specified properties.
         * @function create
         * @memberof pb.FiveChangeRes
         * @static
         * @param {pb.IFiveChangeRes=} [properties] Properties to set
         * @returns {pb.FiveChangeRes} FiveChangeRes instance
         */
        FiveChangeRes.create = function create(properties) {
            return new FiveChangeRes(properties);
        };

        /**
         * Encodes the specified FiveChangeRes message. Does not implicitly {@link pb.FiveChangeRes.verify|verify} messages.
         * @function encode
         * @memberof pb.FiveChangeRes
         * @static
         * @param {pb.IFiveChangeRes} message FiveChangeRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FiveChangeRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified FiveChangeRes message, length delimited. Does not implicitly {@link pb.FiveChangeRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.FiveChangeRes
         * @static
         * @param {pb.IFiveChangeRes} message FiveChangeRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FiveChangeRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a FiveChangeRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.FiveChangeRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.FiveChangeRes} FiveChangeRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FiveChangeRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.FiveChangeRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a FiveChangeRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.FiveChangeRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.FiveChangeRes} FiveChangeRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FiveChangeRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a FiveChangeRes message.
         * @function verify
         * @memberof pb.FiveChangeRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        FiveChangeRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a FiveChangeRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.FiveChangeRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.FiveChangeRes} FiveChangeRes
         */
        FiveChangeRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.FiveChangeRes)
                return object;
            return new $root.pb.FiveChangeRes();
        };

        /**
         * Creates a plain object from a FiveChangeRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.FiveChangeRes
         * @static
         * @param {pb.FiveChangeRes} message FiveChangeRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        FiveChangeRes.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this FiveChangeRes to JSON.
         * @function toJSON
         * @memberof pb.FiveChangeRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        FiveChangeRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return FiveChangeRes;
    })();

    pb.FuckEggAsk = (function() {

        /**
         * Properties of a FuckEggAsk.
         * @memberof pb
         * @interface IFuckEggAsk
         * @property {number} [type] FuckEggAsk type
         */

        /**
         * Constructs a new FuckEggAsk.
         * @memberof pb
         * @classdesc Represents a FuckEggAsk.
         * @constructor
         * @param {pb.IFuckEggAsk=} [properties] Properties to set
         */
        function FuckEggAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * FuckEggAsk type.
         * @member {number}type
         * @memberof pb.FuckEggAsk
         * @instance
         */
        FuckEggAsk.prototype.type = 0;

        /**
         * Creates a new FuckEggAsk instance using the specified properties.
         * @function create
         * @memberof pb.FuckEggAsk
         * @static
         * @param {pb.IFuckEggAsk=} [properties] Properties to set
         * @returns {pb.FuckEggAsk} FuckEggAsk instance
         */
        FuckEggAsk.create = function create(properties) {
            return new FuckEggAsk(properties);
        };

        /**
         * Encodes the specified FuckEggAsk message. Does not implicitly {@link pb.FuckEggAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.FuckEggAsk
         * @static
         * @param {pb.IFuckEggAsk} message FuckEggAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FuckEggAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.type != null && message.hasOwnProperty("type"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.type);
            return writer;
        };

        /**
         * Encodes the specified FuckEggAsk message, length delimited. Does not implicitly {@link pb.FuckEggAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.FuckEggAsk
         * @static
         * @param {pb.IFuckEggAsk} message FuckEggAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FuckEggAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a FuckEggAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.FuckEggAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.FuckEggAsk} FuckEggAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FuckEggAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.FuckEggAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.type = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a FuckEggAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.FuckEggAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.FuckEggAsk} FuckEggAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FuckEggAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a FuckEggAsk message.
         * @function verify
         * @memberof pb.FuckEggAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        FuckEggAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.type != null && message.hasOwnProperty("type"))
                if (!$util.isInteger(message.type))
                    return "type: integer expected";
            return null;
        };

        /**
         * Creates a FuckEggAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.FuckEggAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.FuckEggAsk} FuckEggAsk
         */
        FuckEggAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.FuckEggAsk)
                return object;
            var message = new $root.pb.FuckEggAsk();
            if (object.type != null)
                message.type = object.type | 0;
            return message;
        };

        /**
         * Creates a plain object from a FuckEggAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.FuckEggAsk
         * @static
         * @param {pb.FuckEggAsk} message FuckEggAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        FuckEggAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.type = 0;
            if (message.type != null && message.hasOwnProperty("type"))
                object.type = message.type;
            return object;
        };

        /**
         * Converts this FuckEggAsk to JSON.
         * @function toJSON
         * @memberof pb.FuckEggAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        FuckEggAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return FuckEggAsk;
    })();

    pb.FuckEggRes = (function() {

        /**
         * Properties of a FuckEggRes.
         * @memberof pb
         * @interface IFuckEggRes
         * @property {string} [index] FuckEggRes index
         */

        /**
         * Constructs a new FuckEggRes.
         * @memberof pb
         * @classdesc Represents a FuckEggRes.
         * @constructor
         * @param {pb.IFuckEggRes=} [properties] Properties to set
         */
        function FuckEggRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * FuckEggRes index.
         * @member {string}index
         * @memberof pb.FuckEggRes
         * @instance
         */
        FuckEggRes.prototype.index = "";

        /**
         * Creates a new FuckEggRes instance using the specified properties.
         * @function create
         * @memberof pb.FuckEggRes
         * @static
         * @param {pb.IFuckEggRes=} [properties] Properties to set
         * @returns {pb.FuckEggRes} FuckEggRes instance
         */
        FuckEggRes.create = function create(properties) {
            return new FuckEggRes(properties);
        };

        /**
         * Encodes the specified FuckEggRes message. Does not implicitly {@link pb.FuckEggRes.verify|verify} messages.
         * @function encode
         * @memberof pb.FuckEggRes
         * @static
         * @param {pb.IFuckEggRes} message FuckEggRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FuckEggRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.index != null && message.hasOwnProperty("index"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.index);
            return writer;
        };

        /**
         * Encodes the specified FuckEggRes message, length delimited. Does not implicitly {@link pb.FuckEggRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.FuckEggRes
         * @static
         * @param {pb.IFuckEggRes} message FuckEggRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FuckEggRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a FuckEggRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.FuckEggRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.FuckEggRes} FuckEggRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FuckEggRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.FuckEggRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.index = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a FuckEggRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.FuckEggRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.FuckEggRes} FuckEggRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FuckEggRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a FuckEggRes message.
         * @function verify
         * @memberof pb.FuckEggRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        FuckEggRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.index != null && message.hasOwnProperty("index"))
                if (!$util.isString(message.index))
                    return "index: string expected";
            return null;
        };

        /**
         * Creates a FuckEggRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.FuckEggRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.FuckEggRes} FuckEggRes
         */
        FuckEggRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.FuckEggRes)
                return object;
            var message = new $root.pb.FuckEggRes();
            if (object.index != null)
                message.index = String(object.index);
            return message;
        };

        /**
         * Creates a plain object from a FuckEggRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.FuckEggRes
         * @static
         * @param {pb.FuckEggRes} message FuckEggRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        FuckEggRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.index = "";
            if (message.index != null && message.hasOwnProperty("index"))
                object.index = message.index;
            return object;
        };

        /**
         * Converts this FuckEggRes to JSON.
         * @function toJSON
         * @memberof pb.FuckEggRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        FuckEggRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return FuckEggRes;
    })();

    pb.FuckEggFreeAsk = (function() {

        /**
         * Properties of a FuckEggFreeAsk.
         * @memberof pb
         * @interface IFuckEggFreeAsk
         */

        /**
         * Constructs a new FuckEggFreeAsk.
         * @memberof pb
         * @classdesc Represents a FuckEggFreeAsk.
         * @constructor
         * @param {pb.IFuckEggFreeAsk=} [properties] Properties to set
         */
        function FuckEggFreeAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new FuckEggFreeAsk instance using the specified properties.
         * @function create
         * @memberof pb.FuckEggFreeAsk
         * @static
         * @param {pb.IFuckEggFreeAsk=} [properties] Properties to set
         * @returns {pb.FuckEggFreeAsk} FuckEggFreeAsk instance
         */
        FuckEggFreeAsk.create = function create(properties) {
            return new FuckEggFreeAsk(properties);
        };

        /**
         * Encodes the specified FuckEggFreeAsk message. Does not implicitly {@link pb.FuckEggFreeAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.FuckEggFreeAsk
         * @static
         * @param {pb.IFuckEggFreeAsk} message FuckEggFreeAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FuckEggFreeAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified FuckEggFreeAsk message, length delimited. Does not implicitly {@link pb.FuckEggFreeAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.FuckEggFreeAsk
         * @static
         * @param {pb.IFuckEggFreeAsk} message FuckEggFreeAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FuckEggFreeAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a FuckEggFreeAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.FuckEggFreeAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.FuckEggFreeAsk} FuckEggFreeAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FuckEggFreeAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.FuckEggFreeAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a FuckEggFreeAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.FuckEggFreeAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.FuckEggFreeAsk} FuckEggFreeAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FuckEggFreeAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a FuckEggFreeAsk message.
         * @function verify
         * @memberof pb.FuckEggFreeAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        FuckEggFreeAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a FuckEggFreeAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.FuckEggFreeAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.FuckEggFreeAsk} FuckEggFreeAsk
         */
        FuckEggFreeAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.FuckEggFreeAsk)
                return object;
            return new $root.pb.FuckEggFreeAsk();
        };

        /**
         * Creates a plain object from a FuckEggFreeAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.FuckEggFreeAsk
         * @static
         * @param {pb.FuckEggFreeAsk} message FuckEggFreeAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        FuckEggFreeAsk.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this FuckEggFreeAsk to JSON.
         * @function toJSON
         * @memberof pb.FuckEggFreeAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        FuckEggFreeAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return FuckEggFreeAsk;
    })();

    pb.FuckEggFreeRes = (function() {

        /**
         * Properties of a FuckEggFreeRes.
         * @memberof pb
         * @interface IFuckEggFreeRes
         * @property {number} [val] FuckEggFreeRes val
         */

        /**
         * Constructs a new FuckEggFreeRes.
         * @memberof pb
         * @classdesc Represents a FuckEggFreeRes.
         * @constructor
         * @param {pb.IFuckEggFreeRes=} [properties] Properties to set
         */
        function FuckEggFreeRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * FuckEggFreeRes val.
         * @member {number}val
         * @memberof pb.FuckEggFreeRes
         * @instance
         */
        FuckEggFreeRes.prototype.val = 0;

        /**
         * Creates a new FuckEggFreeRes instance using the specified properties.
         * @function create
         * @memberof pb.FuckEggFreeRes
         * @static
         * @param {pb.IFuckEggFreeRes=} [properties] Properties to set
         * @returns {pb.FuckEggFreeRes} FuckEggFreeRes instance
         */
        FuckEggFreeRes.create = function create(properties) {
            return new FuckEggFreeRes(properties);
        };

        /**
         * Encodes the specified FuckEggFreeRes message. Does not implicitly {@link pb.FuckEggFreeRes.verify|verify} messages.
         * @function encode
         * @memberof pb.FuckEggFreeRes
         * @static
         * @param {pb.IFuckEggFreeRes} message FuckEggFreeRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FuckEggFreeRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.val != null && message.hasOwnProperty("val"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.val);
            return writer;
        };

        /**
         * Encodes the specified FuckEggFreeRes message, length delimited. Does not implicitly {@link pb.FuckEggFreeRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.FuckEggFreeRes
         * @static
         * @param {pb.IFuckEggFreeRes} message FuckEggFreeRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FuckEggFreeRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a FuckEggFreeRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.FuckEggFreeRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.FuckEggFreeRes} FuckEggFreeRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FuckEggFreeRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.FuckEggFreeRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.val = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a FuckEggFreeRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.FuckEggFreeRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.FuckEggFreeRes} FuckEggFreeRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FuckEggFreeRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a FuckEggFreeRes message.
         * @function verify
         * @memberof pb.FuckEggFreeRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        FuckEggFreeRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.val != null && message.hasOwnProperty("val"))
                if (!$util.isInteger(message.val))
                    return "val: integer expected";
            return null;
        };

        /**
         * Creates a FuckEggFreeRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.FuckEggFreeRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.FuckEggFreeRes} FuckEggFreeRes
         */
        FuckEggFreeRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.FuckEggFreeRes)
                return object;
            var message = new $root.pb.FuckEggFreeRes();
            if (object.val != null)
                message.val = object.val | 0;
            return message;
        };

        /**
         * Creates a plain object from a FuckEggFreeRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.FuckEggFreeRes
         * @static
         * @param {pb.FuckEggFreeRes} message FuckEggFreeRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        FuckEggFreeRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.val = 0;
            if (message.val != null && message.hasOwnProperty("val"))
                object.val = message.val;
            return object;
        };

        /**
         * Converts this FuckEggFreeRes to JSON.
         * @function toJSON
         * @memberof pb.FuckEggFreeRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        FuckEggFreeRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return FuckEggFreeRes;
    })();

    pb.EatCardAsk = (function() {

        /**
         * Properties of an EatCardAsk.
         * @memberof pb
         * @interface IEatCardAsk
         * @property {string} [index] EatCardAsk index
         * @property {Array.<string>} [indexCards] EatCardAsk indexCards
         */

        /**
         * Constructs a new EatCardAsk.
         * @memberof pb
         * @classdesc Represents an EatCardAsk.
         * @constructor
         * @param {pb.IEatCardAsk=} [properties] Properties to set
         */
        function EatCardAsk(properties) {
            this.indexCards = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * EatCardAsk index.
         * @member {string}index
         * @memberof pb.EatCardAsk
         * @instance
         */
        EatCardAsk.prototype.index = "";

        /**
         * EatCardAsk indexCards.
         * @member {Array.<string>}indexCards
         * @memberof pb.EatCardAsk
         * @instance
         */
        EatCardAsk.prototype.indexCards = $util.emptyArray;

        /**
         * Creates a new EatCardAsk instance using the specified properties.
         * @function create
         * @memberof pb.EatCardAsk
         * @static
         * @param {pb.IEatCardAsk=} [properties] Properties to set
         * @returns {pb.EatCardAsk} EatCardAsk instance
         */
        EatCardAsk.create = function create(properties) {
            return new EatCardAsk(properties);
        };

        /**
         * Encodes the specified EatCardAsk message. Does not implicitly {@link pb.EatCardAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.EatCardAsk
         * @static
         * @param {pb.IEatCardAsk} message EatCardAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        EatCardAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.index != null && message.hasOwnProperty("index"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.index);
            if (message.indexCards != null && message.indexCards.length)
                for (var i = 0; i < message.indexCards.length; ++i)
                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.indexCards[i]);
            return writer;
        };

        /**
         * Encodes the specified EatCardAsk message, length delimited. Does not implicitly {@link pb.EatCardAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.EatCardAsk
         * @static
         * @param {pb.IEatCardAsk} message EatCardAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        EatCardAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an EatCardAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.EatCardAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.EatCardAsk} EatCardAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        EatCardAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.EatCardAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.index = reader.string();
                    break;
                case 2:
                    if (!(message.indexCards && message.indexCards.length))
                        message.indexCards = [];
                    message.indexCards.push(reader.string());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an EatCardAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.EatCardAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.EatCardAsk} EatCardAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        EatCardAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an EatCardAsk message.
         * @function verify
         * @memberof pb.EatCardAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        EatCardAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.index != null && message.hasOwnProperty("index"))
                if (!$util.isString(message.index))
                    return "index: string expected";
            if (message.indexCards != null && message.hasOwnProperty("indexCards")) {
                if (!Array.isArray(message.indexCards))
                    return "indexCards: array expected";
                for (var i = 0; i < message.indexCards.length; ++i)
                    if (!$util.isString(message.indexCards[i]))
                        return "indexCards: string[] expected";
            }
            return null;
        };

        /**
         * Creates an EatCardAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.EatCardAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.EatCardAsk} EatCardAsk
         */
        EatCardAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.EatCardAsk)
                return object;
            var message = new $root.pb.EatCardAsk();
            if (object.index != null)
                message.index = String(object.index);
            if (object.indexCards) {
                if (!Array.isArray(object.indexCards))
                    throw TypeError(".pb.EatCardAsk.indexCards: array expected");
                message.indexCards = [];
                for (var i = 0; i < object.indexCards.length; ++i)
                    message.indexCards[i] = String(object.indexCards[i]);
            }
            return message;
        };

        /**
         * Creates a plain object from an EatCardAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.EatCardAsk
         * @static
         * @param {pb.EatCardAsk} message EatCardAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        EatCardAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.indexCards = [];
            if (options.defaults)
                object.index = "";
            if (message.index != null && message.hasOwnProperty("index"))
                object.index = message.index;
            if (message.indexCards && message.indexCards.length) {
                object.indexCards = [];
                for (var j = 0; j < message.indexCards.length; ++j)
                    object.indexCards[j] = message.indexCards[j];
            }
            return object;
        };

        /**
         * Converts this EatCardAsk to JSON.
         * @function toJSON
         * @memberof pb.EatCardAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        EatCardAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return EatCardAsk;
    })();

    pb.EatCardRes = (function() {

        /**
         * Properties of an EatCardRes.
         * @memberof pb
         * @interface IEatCardRes
         */

        /**
         * Constructs a new EatCardRes.
         * @memberof pb
         * @classdesc Represents an EatCardRes.
         * @constructor
         * @param {pb.IEatCardRes=} [properties] Properties to set
         */
        function EatCardRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new EatCardRes instance using the specified properties.
         * @function create
         * @memberof pb.EatCardRes
         * @static
         * @param {pb.IEatCardRes=} [properties] Properties to set
         * @returns {pb.EatCardRes} EatCardRes instance
         */
        EatCardRes.create = function create(properties) {
            return new EatCardRes(properties);
        };

        /**
         * Encodes the specified EatCardRes message. Does not implicitly {@link pb.EatCardRes.verify|verify} messages.
         * @function encode
         * @memberof pb.EatCardRes
         * @static
         * @param {pb.IEatCardRes} message EatCardRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        EatCardRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified EatCardRes message, length delimited. Does not implicitly {@link pb.EatCardRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.EatCardRes
         * @static
         * @param {pb.IEatCardRes} message EatCardRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        EatCardRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an EatCardRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.EatCardRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.EatCardRes} EatCardRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        EatCardRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.EatCardRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an EatCardRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.EatCardRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.EatCardRes} EatCardRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        EatCardRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an EatCardRes message.
         * @function verify
         * @memberof pb.EatCardRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        EatCardRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates an EatCardRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.EatCardRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.EatCardRes} EatCardRes
         */
        EatCardRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.EatCardRes)
                return object;
            return new $root.pb.EatCardRes();
        };

        /**
         * Creates a plain object from an EatCardRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.EatCardRes
         * @static
         * @param {pb.EatCardRes} message EatCardRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        EatCardRes.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this EatCardRes to JSON.
         * @function toJSON
         * @memberof pb.EatCardRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        EatCardRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return EatCardRes;
    })();

    pb.SkillUpAsk = (function() {

        /**
         * Properties of a SkillUpAsk.
         * @memberof pb
         * @interface ISkillUpAsk
         * @property {string} [index] SkillUpAsk index
         * @property {number} [indexSkill] SkillUpAsk indexSkill
         */

        /**
         * Constructs a new SkillUpAsk.
         * @memberof pb
         * @classdesc Represents a SkillUpAsk.
         * @constructor
         * @param {pb.ISkillUpAsk=} [properties] Properties to set
         */
        function SkillUpAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * SkillUpAsk index.
         * @member {string}index
         * @memberof pb.SkillUpAsk
         * @instance
         */
        SkillUpAsk.prototype.index = "";

        /**
         * SkillUpAsk indexSkill.
         * @member {number}indexSkill
         * @memberof pb.SkillUpAsk
         * @instance
         */
        SkillUpAsk.prototype.indexSkill = 0;

        /**
         * Creates a new SkillUpAsk instance using the specified properties.
         * @function create
         * @memberof pb.SkillUpAsk
         * @static
         * @param {pb.ISkillUpAsk=} [properties] Properties to set
         * @returns {pb.SkillUpAsk} SkillUpAsk instance
         */
        SkillUpAsk.create = function create(properties) {
            return new SkillUpAsk(properties);
        };

        /**
         * Encodes the specified SkillUpAsk message. Does not implicitly {@link pb.SkillUpAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.SkillUpAsk
         * @static
         * @param {pb.ISkillUpAsk} message SkillUpAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SkillUpAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.index != null && message.hasOwnProperty("index"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.index);
            if (message.indexSkill != null && message.hasOwnProperty("indexSkill"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.indexSkill);
            return writer;
        };

        /**
         * Encodes the specified SkillUpAsk message, length delimited. Does not implicitly {@link pb.SkillUpAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.SkillUpAsk
         * @static
         * @param {pb.ISkillUpAsk} message SkillUpAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SkillUpAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a SkillUpAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.SkillUpAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.SkillUpAsk} SkillUpAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SkillUpAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.SkillUpAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.index = reader.string();
                    break;
                case 2:
                    message.indexSkill = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a SkillUpAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.SkillUpAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.SkillUpAsk} SkillUpAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SkillUpAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a SkillUpAsk message.
         * @function verify
         * @memberof pb.SkillUpAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        SkillUpAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.index != null && message.hasOwnProperty("index"))
                if (!$util.isString(message.index))
                    return "index: string expected";
            if (message.indexSkill != null && message.hasOwnProperty("indexSkill"))
                if (!$util.isInteger(message.indexSkill))
                    return "indexSkill: integer expected";
            return null;
        };

        /**
         * Creates a SkillUpAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.SkillUpAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.SkillUpAsk} SkillUpAsk
         */
        SkillUpAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.SkillUpAsk)
                return object;
            var message = new $root.pb.SkillUpAsk();
            if (object.index != null)
                message.index = String(object.index);
            if (object.indexSkill != null)
                message.indexSkill = object.indexSkill | 0;
            return message;
        };

        /**
         * Creates a plain object from a SkillUpAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.SkillUpAsk
         * @static
         * @param {pb.SkillUpAsk} message SkillUpAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        SkillUpAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.index = "";
                object.indexSkill = 0;
            }
            if (message.index != null && message.hasOwnProperty("index"))
                object.index = message.index;
            if (message.indexSkill != null && message.hasOwnProperty("indexSkill"))
                object.indexSkill = message.indexSkill;
            return object;
        };

        /**
         * Converts this SkillUpAsk to JSON.
         * @function toJSON
         * @memberof pb.SkillUpAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        SkillUpAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return SkillUpAsk;
    })();

    pb.SkillUpRes = (function() {

        /**
         * Properties of a SkillUpRes.
         * @memberof pb
         * @interface ISkillUpRes
         */

        /**
         * Constructs a new SkillUpRes.
         * @memberof pb
         * @classdesc Represents a SkillUpRes.
         * @constructor
         * @param {pb.ISkillUpRes=} [properties] Properties to set
         */
        function SkillUpRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new SkillUpRes instance using the specified properties.
         * @function create
         * @memberof pb.SkillUpRes
         * @static
         * @param {pb.ISkillUpRes=} [properties] Properties to set
         * @returns {pb.SkillUpRes} SkillUpRes instance
         */
        SkillUpRes.create = function create(properties) {
            return new SkillUpRes(properties);
        };

        /**
         * Encodes the specified SkillUpRes message. Does not implicitly {@link pb.SkillUpRes.verify|verify} messages.
         * @function encode
         * @memberof pb.SkillUpRes
         * @static
         * @param {pb.ISkillUpRes} message SkillUpRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SkillUpRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified SkillUpRes message, length delimited. Does not implicitly {@link pb.SkillUpRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.SkillUpRes
         * @static
         * @param {pb.ISkillUpRes} message SkillUpRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SkillUpRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a SkillUpRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.SkillUpRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.SkillUpRes} SkillUpRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SkillUpRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.SkillUpRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a SkillUpRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.SkillUpRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.SkillUpRes} SkillUpRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SkillUpRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a SkillUpRes message.
         * @function verify
         * @memberof pb.SkillUpRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        SkillUpRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a SkillUpRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.SkillUpRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.SkillUpRes} SkillUpRes
         */
        SkillUpRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.SkillUpRes)
                return object;
            return new $root.pb.SkillUpRes();
        };

        /**
         * Creates a plain object from a SkillUpRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.SkillUpRes
         * @static
         * @param {pb.SkillUpRes} message SkillUpRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        SkillUpRes.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this SkillUpRes to JSON.
         * @function toJSON
         * @memberof pb.SkillUpRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        SkillUpRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return SkillUpRes;
    })();

    pb.SkillBreakAsk = (function() {

        /**
         * Properties of a SkillBreakAsk.
         * @memberof pb
         * @interface ISkillBreakAsk
         * @property {string} [index] SkillBreakAsk index
         * @property {number} [indexSkill] SkillBreakAsk indexSkill
         */

        /**
         * Constructs a new SkillBreakAsk.
         * @memberof pb
         * @classdesc Represents a SkillBreakAsk.
         * @constructor
         * @param {pb.ISkillBreakAsk=} [properties] Properties to set
         */
        function SkillBreakAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * SkillBreakAsk index.
         * @member {string}index
         * @memberof pb.SkillBreakAsk
         * @instance
         */
        SkillBreakAsk.prototype.index = "";

        /**
         * SkillBreakAsk indexSkill.
         * @member {number}indexSkill
         * @memberof pb.SkillBreakAsk
         * @instance
         */
        SkillBreakAsk.prototype.indexSkill = 0;

        /**
         * Creates a new SkillBreakAsk instance using the specified properties.
         * @function create
         * @memberof pb.SkillBreakAsk
         * @static
         * @param {pb.ISkillBreakAsk=} [properties] Properties to set
         * @returns {pb.SkillBreakAsk} SkillBreakAsk instance
         */
        SkillBreakAsk.create = function create(properties) {
            return new SkillBreakAsk(properties);
        };

        /**
         * Encodes the specified SkillBreakAsk message. Does not implicitly {@link pb.SkillBreakAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.SkillBreakAsk
         * @static
         * @param {pb.ISkillBreakAsk} message SkillBreakAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SkillBreakAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.index != null && message.hasOwnProperty("index"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.index);
            if (message.indexSkill != null && message.hasOwnProperty("indexSkill"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.indexSkill);
            return writer;
        };

        /**
         * Encodes the specified SkillBreakAsk message, length delimited. Does not implicitly {@link pb.SkillBreakAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.SkillBreakAsk
         * @static
         * @param {pb.ISkillBreakAsk} message SkillBreakAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SkillBreakAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a SkillBreakAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.SkillBreakAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.SkillBreakAsk} SkillBreakAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SkillBreakAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.SkillBreakAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.index = reader.string();
                    break;
                case 2:
                    message.indexSkill = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a SkillBreakAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.SkillBreakAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.SkillBreakAsk} SkillBreakAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SkillBreakAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a SkillBreakAsk message.
         * @function verify
         * @memberof pb.SkillBreakAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        SkillBreakAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.index != null && message.hasOwnProperty("index"))
                if (!$util.isString(message.index))
                    return "index: string expected";
            if (message.indexSkill != null && message.hasOwnProperty("indexSkill"))
                if (!$util.isInteger(message.indexSkill))
                    return "indexSkill: integer expected";
            return null;
        };

        /**
         * Creates a SkillBreakAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.SkillBreakAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.SkillBreakAsk} SkillBreakAsk
         */
        SkillBreakAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.SkillBreakAsk)
                return object;
            var message = new $root.pb.SkillBreakAsk();
            if (object.index != null)
                message.index = String(object.index);
            if (object.indexSkill != null)
                message.indexSkill = object.indexSkill | 0;
            return message;
        };

        /**
         * Creates a plain object from a SkillBreakAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.SkillBreakAsk
         * @static
         * @param {pb.SkillBreakAsk} message SkillBreakAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        SkillBreakAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.index = "";
                object.indexSkill = 0;
            }
            if (message.index != null && message.hasOwnProperty("index"))
                object.index = message.index;
            if (message.indexSkill != null && message.hasOwnProperty("indexSkill"))
                object.indexSkill = message.indexSkill;
            return object;
        };

        /**
         * Converts this SkillBreakAsk to JSON.
         * @function toJSON
         * @memberof pb.SkillBreakAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        SkillBreakAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return SkillBreakAsk;
    })();

    pb.SkillBreakRes = (function() {

        /**
         * Properties of a SkillBreakRes.
         * @memberof pb
         * @interface ISkillBreakRes
         * @property {boolean} [res] SkillBreakRes res
         */

        /**
         * Constructs a new SkillBreakRes.
         * @memberof pb
         * @classdesc Represents a SkillBreakRes.
         * @constructor
         * @param {pb.ISkillBreakRes=} [properties] Properties to set
         */
        function SkillBreakRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * SkillBreakRes res.
         * @member {boolean}res
         * @memberof pb.SkillBreakRes
         * @instance
         */
        SkillBreakRes.prototype.res = false;

        /**
         * Creates a new SkillBreakRes instance using the specified properties.
         * @function create
         * @memberof pb.SkillBreakRes
         * @static
         * @param {pb.ISkillBreakRes=} [properties] Properties to set
         * @returns {pb.SkillBreakRes} SkillBreakRes instance
         */
        SkillBreakRes.create = function create(properties) {
            return new SkillBreakRes(properties);
        };

        /**
         * Encodes the specified SkillBreakRes message. Does not implicitly {@link pb.SkillBreakRes.verify|verify} messages.
         * @function encode
         * @memberof pb.SkillBreakRes
         * @static
         * @param {pb.ISkillBreakRes} message SkillBreakRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SkillBreakRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.res != null && message.hasOwnProperty("res"))
                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.res);
            return writer;
        };

        /**
         * Encodes the specified SkillBreakRes message, length delimited. Does not implicitly {@link pb.SkillBreakRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.SkillBreakRes
         * @static
         * @param {pb.ISkillBreakRes} message SkillBreakRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SkillBreakRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a SkillBreakRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.SkillBreakRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.SkillBreakRes} SkillBreakRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SkillBreakRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.SkillBreakRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.res = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a SkillBreakRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.SkillBreakRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.SkillBreakRes} SkillBreakRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SkillBreakRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a SkillBreakRes message.
         * @function verify
         * @memberof pb.SkillBreakRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        SkillBreakRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.res != null && message.hasOwnProperty("res"))
                if (typeof message.res !== "boolean")
                    return "res: boolean expected";
            return null;
        };

        /**
         * Creates a SkillBreakRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.SkillBreakRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.SkillBreakRes} SkillBreakRes
         */
        SkillBreakRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.SkillBreakRes)
                return object;
            var message = new $root.pb.SkillBreakRes();
            if (object.res != null)
                message.res = Boolean(object.res);
            return message;
        };

        /**
         * Creates a plain object from a SkillBreakRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.SkillBreakRes
         * @static
         * @param {pb.SkillBreakRes} message SkillBreakRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        SkillBreakRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.res = false;
            if (message.res != null && message.hasOwnProperty("res"))
                object.res = message.res;
            return object;
        };

        /**
         * Converts this SkillBreakRes to JSON.
         * @function toJSON
         * @memberof pb.SkillBreakRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        SkillBreakRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return SkillBreakRes;
    })();

    pb.LockAsk = (function() {

        /**
         * Properties of a LockAsk.
         * @memberof pb
         * @interface ILockAsk
         * @property {string} [index] LockAsk index
         */

        /**
         * Constructs a new LockAsk.
         * @memberof pb
         * @classdesc Represents a LockAsk.
         * @constructor
         * @param {pb.ILockAsk=} [properties] Properties to set
         */
        function LockAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * LockAsk index.
         * @member {string}index
         * @memberof pb.LockAsk
         * @instance
         */
        LockAsk.prototype.index = "";

        /**
         * Creates a new LockAsk instance using the specified properties.
         * @function create
         * @memberof pb.LockAsk
         * @static
         * @param {pb.ILockAsk=} [properties] Properties to set
         * @returns {pb.LockAsk} LockAsk instance
         */
        LockAsk.create = function create(properties) {
            return new LockAsk(properties);
        };

        /**
         * Encodes the specified LockAsk message. Does not implicitly {@link pb.LockAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.LockAsk
         * @static
         * @param {pb.ILockAsk} message LockAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        LockAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.index != null && message.hasOwnProperty("index"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.index);
            return writer;
        };

        /**
         * Encodes the specified LockAsk message, length delimited. Does not implicitly {@link pb.LockAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.LockAsk
         * @static
         * @param {pb.ILockAsk} message LockAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        LockAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a LockAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.LockAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.LockAsk} LockAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        LockAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.LockAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.index = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a LockAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.LockAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.LockAsk} LockAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        LockAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a LockAsk message.
         * @function verify
         * @memberof pb.LockAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        LockAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.index != null && message.hasOwnProperty("index"))
                if (!$util.isString(message.index))
                    return "index: string expected";
            return null;
        };

        /**
         * Creates a LockAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.LockAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.LockAsk} LockAsk
         */
        LockAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.LockAsk)
                return object;
            var message = new $root.pb.LockAsk();
            if (object.index != null)
                message.index = String(object.index);
            return message;
        };

        /**
         * Creates a plain object from a LockAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.LockAsk
         * @static
         * @param {pb.LockAsk} message LockAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        LockAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.index = "";
            if (message.index != null && message.hasOwnProperty("index"))
                object.index = message.index;
            return object;
        };

        /**
         * Converts this LockAsk to JSON.
         * @function toJSON
         * @memberof pb.LockAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        LockAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return LockAsk;
    })();

    pb.LockRes = (function() {

        /**
         * Properties of a LockRes.
         * @memberof pb
         * @interface ILockRes
         */

        /**
         * Constructs a new LockRes.
         * @memberof pb
         * @classdesc Represents a LockRes.
         * @constructor
         * @param {pb.ILockRes=} [properties] Properties to set
         */
        function LockRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new LockRes instance using the specified properties.
         * @function create
         * @memberof pb.LockRes
         * @static
         * @param {pb.ILockRes=} [properties] Properties to set
         * @returns {pb.LockRes} LockRes instance
         */
        LockRes.create = function create(properties) {
            return new LockRes(properties);
        };

        /**
         * Encodes the specified LockRes message. Does not implicitly {@link pb.LockRes.verify|verify} messages.
         * @function encode
         * @memberof pb.LockRes
         * @static
         * @param {pb.ILockRes} message LockRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        LockRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified LockRes message, length delimited. Does not implicitly {@link pb.LockRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.LockRes
         * @static
         * @param {pb.ILockRes} message LockRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        LockRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a LockRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.LockRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.LockRes} LockRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        LockRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.LockRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a LockRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.LockRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.LockRes} LockRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        LockRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a LockRes message.
         * @function verify
         * @memberof pb.LockRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        LockRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a LockRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.LockRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.LockRes} LockRes
         */
        LockRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.LockRes)
                return object;
            return new $root.pb.LockRes();
        };

        /**
         * Creates a plain object from a LockRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.LockRes
         * @static
         * @param {pb.LockRes} message LockRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        LockRes.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this LockRes to JSON.
         * @function toJSON
         * @memberof pb.LockRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        LockRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return LockRes;
    })();

    pb.SkillChangeAsk = (function() {

        /**
         * Properties of a SkillChangeAsk.
         * @memberof pb
         * @interface ISkillChangeAsk
         * @property {string} [index] SkillChangeAsk index
         * @property {number} [indexSkill] SkillChangeAsk indexSkill
         */

        /**
         * Constructs a new SkillChangeAsk.
         * @memberof pb
         * @classdesc Represents a SkillChangeAsk.
         * @constructor
         * @param {pb.ISkillChangeAsk=} [properties] Properties to set
         */
        function SkillChangeAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * SkillChangeAsk index.
         * @member {string}index
         * @memberof pb.SkillChangeAsk
         * @instance
         */
        SkillChangeAsk.prototype.index = "";

        /**
         * SkillChangeAsk indexSkill.
         * @member {number}indexSkill
         * @memberof pb.SkillChangeAsk
         * @instance
         */
        SkillChangeAsk.prototype.indexSkill = 0;

        /**
         * Creates a new SkillChangeAsk instance using the specified properties.
         * @function create
         * @memberof pb.SkillChangeAsk
         * @static
         * @param {pb.ISkillChangeAsk=} [properties] Properties to set
         * @returns {pb.SkillChangeAsk} SkillChangeAsk instance
         */
        SkillChangeAsk.create = function create(properties) {
            return new SkillChangeAsk(properties);
        };

        /**
         * Encodes the specified SkillChangeAsk message. Does not implicitly {@link pb.SkillChangeAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.SkillChangeAsk
         * @static
         * @param {pb.ISkillChangeAsk} message SkillChangeAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SkillChangeAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.index != null && message.hasOwnProperty("index"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.index);
            if (message.indexSkill != null && message.hasOwnProperty("indexSkill"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.indexSkill);
            return writer;
        };

        /**
         * Encodes the specified SkillChangeAsk message, length delimited. Does not implicitly {@link pb.SkillChangeAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.SkillChangeAsk
         * @static
         * @param {pb.ISkillChangeAsk} message SkillChangeAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SkillChangeAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a SkillChangeAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.SkillChangeAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.SkillChangeAsk} SkillChangeAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SkillChangeAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.SkillChangeAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.index = reader.string();
                    break;
                case 2:
                    message.indexSkill = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a SkillChangeAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.SkillChangeAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.SkillChangeAsk} SkillChangeAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SkillChangeAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a SkillChangeAsk message.
         * @function verify
         * @memberof pb.SkillChangeAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        SkillChangeAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.index != null && message.hasOwnProperty("index"))
                if (!$util.isString(message.index))
                    return "index: string expected";
            if (message.indexSkill != null && message.hasOwnProperty("indexSkill"))
                if (!$util.isInteger(message.indexSkill))
                    return "indexSkill: integer expected";
            return null;
        };

        /**
         * Creates a SkillChangeAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.SkillChangeAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.SkillChangeAsk} SkillChangeAsk
         */
        SkillChangeAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.SkillChangeAsk)
                return object;
            var message = new $root.pb.SkillChangeAsk();
            if (object.index != null)
                message.index = String(object.index);
            if (object.indexSkill != null)
                message.indexSkill = object.indexSkill | 0;
            return message;
        };

        /**
         * Creates a plain object from a SkillChangeAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.SkillChangeAsk
         * @static
         * @param {pb.SkillChangeAsk} message SkillChangeAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        SkillChangeAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.index = "";
                object.indexSkill = 0;
            }
            if (message.index != null && message.hasOwnProperty("index"))
                object.index = message.index;
            if (message.indexSkill != null && message.hasOwnProperty("indexSkill"))
                object.indexSkill = message.indexSkill;
            return object;
        };

        /**
         * Converts this SkillChangeAsk to JSON.
         * @function toJSON
         * @memberof pb.SkillChangeAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        SkillChangeAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return SkillChangeAsk;
    })();

    pb.SkillChangeRes = (function() {

        /**
         * Properties of a SkillChangeRes.
         * @memberof pb
         * @interface ISkillChangeRes
         */

        /**
         * Constructs a new SkillChangeRes.
         * @memberof pb
         * @classdesc Represents a SkillChangeRes.
         * @constructor
         * @param {pb.ISkillChangeRes=} [properties] Properties to set
         */
        function SkillChangeRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new SkillChangeRes instance using the specified properties.
         * @function create
         * @memberof pb.SkillChangeRes
         * @static
         * @param {pb.ISkillChangeRes=} [properties] Properties to set
         * @returns {pb.SkillChangeRes} SkillChangeRes instance
         */
        SkillChangeRes.create = function create(properties) {
            return new SkillChangeRes(properties);
        };

        /**
         * Encodes the specified SkillChangeRes message. Does not implicitly {@link pb.SkillChangeRes.verify|verify} messages.
         * @function encode
         * @memberof pb.SkillChangeRes
         * @static
         * @param {pb.ISkillChangeRes} message SkillChangeRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SkillChangeRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified SkillChangeRes message, length delimited. Does not implicitly {@link pb.SkillChangeRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.SkillChangeRes
         * @static
         * @param {pb.ISkillChangeRes} message SkillChangeRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        SkillChangeRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a SkillChangeRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.SkillChangeRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.SkillChangeRes} SkillChangeRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SkillChangeRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.SkillChangeRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a SkillChangeRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.SkillChangeRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.SkillChangeRes} SkillChangeRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        SkillChangeRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a SkillChangeRes message.
         * @function verify
         * @memberof pb.SkillChangeRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        SkillChangeRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a SkillChangeRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.SkillChangeRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.SkillChangeRes} SkillChangeRes
         */
        SkillChangeRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.SkillChangeRes)
                return object;
            return new $root.pb.SkillChangeRes();
        };

        /**
         * Creates a plain object from a SkillChangeRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.SkillChangeRes
         * @static
         * @param {pb.SkillChangeRes} message SkillChangeRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        SkillChangeRes.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this SkillChangeRes to JSON.
         * @function toJSON
         * @memberof pb.SkillChangeRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        SkillChangeRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return SkillChangeRes;
    })();

    pb.CreatAsk = (function() {

        /**
         * Properties of a CreatAsk.
         * @memberof pb
         * @interface ICreatAsk
         * @property {number} [id] CreatAsk id
         */

        /**
         * Constructs a new CreatAsk.
         * @memberof pb
         * @classdesc Represents a CreatAsk.
         * @constructor
         * @param {pb.ICreatAsk=} [properties] Properties to set
         */
        function CreatAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * CreatAsk id.
         * @member {number}id
         * @memberof pb.CreatAsk
         * @instance
         */
        CreatAsk.prototype.id = 0;

        /**
         * Creates a new CreatAsk instance using the specified properties.
         * @function create
         * @memberof pb.CreatAsk
         * @static
         * @param {pb.ICreatAsk=} [properties] Properties to set
         * @returns {pb.CreatAsk} CreatAsk instance
         */
        CreatAsk.create = function create(properties) {
            return new CreatAsk(properties);
        };

        /**
         * Encodes the specified CreatAsk message. Does not implicitly {@link pb.CreatAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.CreatAsk
         * @static
         * @param {pb.ICreatAsk} message CreatAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CreatAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.id != null && message.hasOwnProperty("id"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.id);
            return writer;
        };

        /**
         * Encodes the specified CreatAsk message, length delimited. Does not implicitly {@link pb.CreatAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.CreatAsk
         * @static
         * @param {pb.ICreatAsk} message CreatAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CreatAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a CreatAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.CreatAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.CreatAsk} CreatAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CreatAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.CreatAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.id = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a CreatAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.CreatAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.CreatAsk} CreatAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CreatAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a CreatAsk message.
         * @function verify
         * @memberof pb.CreatAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        CreatAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.id != null && message.hasOwnProperty("id"))
                if (!$util.isInteger(message.id))
                    return "id: integer expected";
            return null;
        };

        /**
         * Creates a CreatAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.CreatAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.CreatAsk} CreatAsk
         */
        CreatAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.CreatAsk)
                return object;
            var message = new $root.pb.CreatAsk();
            if (object.id != null)
                message.id = object.id | 0;
            return message;
        };

        /**
         * Creates a plain object from a CreatAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.CreatAsk
         * @static
         * @param {pb.CreatAsk} message CreatAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        CreatAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.id = 0;
            if (message.id != null && message.hasOwnProperty("id"))
                object.id = message.id;
            return object;
        };

        /**
         * Converts this CreatAsk to JSON.
         * @function toJSON
         * @memberof pb.CreatAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        CreatAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return CreatAsk;
    })();

    pb.CreatRes = (function() {

        /**
         * Properties of a CreatRes.
         * @memberof pb
         * @interface ICreatRes
         * @property {boolean} [res] CreatRes res
         */

        /**
         * Constructs a new CreatRes.
         * @memberof pb
         * @classdesc Represents a CreatRes.
         * @constructor
         * @param {pb.ICreatRes=} [properties] Properties to set
         */
        function CreatRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * CreatRes res.
         * @member {boolean}res
         * @memberof pb.CreatRes
         * @instance
         */
        CreatRes.prototype.res = false;

        /**
         * Creates a new CreatRes instance using the specified properties.
         * @function create
         * @memberof pb.CreatRes
         * @static
         * @param {pb.ICreatRes=} [properties] Properties to set
         * @returns {pb.CreatRes} CreatRes instance
         */
        CreatRes.create = function create(properties) {
            return new CreatRes(properties);
        };

        /**
         * Encodes the specified CreatRes message. Does not implicitly {@link pb.CreatRes.verify|verify} messages.
         * @function encode
         * @memberof pb.CreatRes
         * @static
         * @param {pb.ICreatRes} message CreatRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CreatRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.res != null && message.hasOwnProperty("res"))
                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.res);
            return writer;
        };

        /**
         * Encodes the specified CreatRes message, length delimited. Does not implicitly {@link pb.CreatRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.CreatRes
         * @static
         * @param {pb.ICreatRes} message CreatRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CreatRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a CreatRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.CreatRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.CreatRes} CreatRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CreatRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.CreatRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.res = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a CreatRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.CreatRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.CreatRes} CreatRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CreatRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a CreatRes message.
         * @function verify
         * @memberof pb.CreatRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        CreatRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.res != null && message.hasOwnProperty("res"))
                if (typeof message.res !== "boolean")
                    return "res: boolean expected";
            return null;
        };

        /**
         * Creates a CreatRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.CreatRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.CreatRes} CreatRes
         */
        CreatRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.CreatRes)
                return object;
            var message = new $root.pb.CreatRes();
            if (object.res != null)
                message.res = Boolean(object.res);
            return message;
        };

        /**
         * Creates a plain object from a CreatRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.CreatRes
         * @static
         * @param {pb.CreatRes} message CreatRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        CreatRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.res = false;
            if (message.res != null && message.hasOwnProperty("res"))
                object.res = message.res;
            return object;
        };

        /**
         * Converts this CreatRes to JSON.
         * @function toJSON
         * @memberof pb.CreatRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        CreatRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return CreatRes;
    })();

    pb.GGRes = (function() {

        /**
         * Properties of a GGRes.
         * @memberof pb
         * @interface IGGRes
         * @property {string} [res] GGRes res
         */

        /**
         * Constructs a new GGRes.
         * @memberof pb
         * @classdesc Represents a GGRes.
         * @constructor
         * @param {pb.IGGRes=} [properties] Properties to set
         */
        function GGRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * GGRes res.
         * @member {string}res
         * @memberof pb.GGRes
         * @instance
         */
        GGRes.prototype.res = "";

        /**
         * Creates a new GGRes instance using the specified properties.
         * @function create
         * @memberof pb.GGRes
         * @static
         * @param {pb.IGGRes=} [properties] Properties to set
         * @returns {pb.GGRes} GGRes instance
         */
        GGRes.create = function create(properties) {
            return new GGRes(properties);
        };

        /**
         * Encodes the specified GGRes message. Does not implicitly {@link pb.GGRes.verify|verify} messages.
         * @function encode
         * @memberof pb.GGRes
         * @static
         * @param {pb.IGGRes} message GGRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        GGRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.res != null && message.hasOwnProperty("res"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.res);
            return writer;
        };

        /**
         * Encodes the specified GGRes message, length delimited. Does not implicitly {@link pb.GGRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.GGRes
         * @static
         * @param {pb.IGGRes} message GGRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        GGRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a GGRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.GGRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.GGRes} GGRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        GGRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.GGRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.res = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a GGRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.GGRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.GGRes} GGRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        GGRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a GGRes message.
         * @function verify
         * @memberof pb.GGRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        GGRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.res != null && message.hasOwnProperty("res"))
                if (!$util.isString(message.res))
                    return "res: string expected";
            return null;
        };

        /**
         * Creates a GGRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.GGRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.GGRes} GGRes
         */
        GGRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.GGRes)
                return object;
            var message = new $root.pb.GGRes();
            if (object.res != null)
                message.res = String(object.res);
            return message;
        };

        /**
         * Creates a plain object from a GGRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.GGRes
         * @static
         * @param {pb.GGRes} message GGRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        GGRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.res = "";
            if (message.res != null && message.hasOwnProperty("res"))
                object.res = message.res;
            return object;
        };

        /**
         * Converts this GGRes to JSON.
         * @function toJSON
         * @memberof pb.GGRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        GGRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return GGRes;
    })();

    pb.StartAsk = (function() {

        /**
         * Properties of a StartAsk.
         * @memberof pb
         * @interface IStartAsk
         */

        /**
         * Constructs a new StartAsk.
         * @memberof pb
         * @classdesc Represents a StartAsk.
         * @constructor
         * @param {pb.IStartAsk=} [properties] Properties to set
         */
        function StartAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new StartAsk instance using the specified properties.
         * @function create
         * @memberof pb.StartAsk
         * @static
         * @param {pb.IStartAsk=} [properties] Properties to set
         * @returns {pb.StartAsk} StartAsk instance
         */
        StartAsk.create = function create(properties) {
            return new StartAsk(properties);
        };

        /**
         * Encodes the specified StartAsk message. Does not implicitly {@link pb.StartAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.StartAsk
         * @static
         * @param {pb.IStartAsk} message StartAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        StartAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified StartAsk message, length delimited. Does not implicitly {@link pb.StartAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.StartAsk
         * @static
         * @param {pb.IStartAsk} message StartAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        StartAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a StartAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.StartAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.StartAsk} StartAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        StartAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.StartAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a StartAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.StartAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.StartAsk} StartAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        StartAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a StartAsk message.
         * @function verify
         * @memberof pb.StartAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        StartAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a StartAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.StartAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.StartAsk} StartAsk
         */
        StartAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.StartAsk)
                return object;
            return new $root.pb.StartAsk();
        };

        /**
         * Creates a plain object from a StartAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.StartAsk
         * @static
         * @param {pb.StartAsk} message StartAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        StartAsk.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this StartAsk to JSON.
         * @function toJSON
         * @memberof pb.StartAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        StartAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return StartAsk;
    })();

    pb.FeedAsk = (function() {

        /**
         * Properties of a FeedAsk.
         * @memberof pb
         * @interface IFeedAsk
         * @property {string} [index] FeedAsk index
         * @property {number} [idItem] FeedAsk idItem
         * @property {string} [sidItem] FeedAsk sidItem
         */

        /**
         * Constructs a new FeedAsk.
         * @memberof pb
         * @classdesc Represents a FeedAsk.
         * @constructor
         * @param {pb.IFeedAsk=} [properties] Properties to set
         */
        function FeedAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * FeedAsk index.
         * @member {string}index
         * @memberof pb.FeedAsk
         * @instance
         */
        FeedAsk.prototype.index = "";

        /**
         * FeedAsk idItem.
         * @member {number}idItem
         * @memberof pb.FeedAsk
         * @instance
         */
        FeedAsk.prototype.idItem = 0;

        /**
         * FeedAsk sidItem.
         * @member {string}sidItem
         * @memberof pb.FeedAsk
         * @instance
         */
        FeedAsk.prototype.sidItem = "";

        /**
         * Creates a new FeedAsk instance using the specified properties.
         * @function create
         * @memberof pb.FeedAsk
         * @static
         * @param {pb.IFeedAsk=} [properties] Properties to set
         * @returns {pb.FeedAsk} FeedAsk instance
         */
        FeedAsk.create = function create(properties) {
            return new FeedAsk(properties);
        };

        /**
         * Encodes the specified FeedAsk message. Does not implicitly {@link pb.FeedAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.FeedAsk
         * @static
         * @param {pb.IFeedAsk} message FeedAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FeedAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.index != null && message.hasOwnProperty("index"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.index);
            if (message.idItem != null && message.hasOwnProperty("idItem"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.idItem);
            if (message.sidItem != null && message.hasOwnProperty("sidItem"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.sidItem);
            return writer;
        };

        /**
         * Encodes the specified FeedAsk message, length delimited. Does not implicitly {@link pb.FeedAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.FeedAsk
         * @static
         * @param {pb.IFeedAsk} message FeedAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FeedAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a FeedAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.FeedAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.FeedAsk} FeedAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FeedAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.FeedAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.index = reader.string();
                    break;
                case 2:
                    message.idItem = reader.int32();
                    break;
                case 3:
                    message.sidItem = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a FeedAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.FeedAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.FeedAsk} FeedAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FeedAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a FeedAsk message.
         * @function verify
         * @memberof pb.FeedAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        FeedAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.index != null && message.hasOwnProperty("index"))
                if (!$util.isString(message.index))
                    return "index: string expected";
            if (message.idItem != null && message.hasOwnProperty("idItem"))
                if (!$util.isInteger(message.idItem))
                    return "idItem: integer expected";
            if (message.sidItem != null && message.hasOwnProperty("sidItem"))
                if (!$util.isString(message.sidItem))
                    return "sidItem: string expected";
            return null;
        };

        /**
         * Creates a FeedAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.FeedAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.FeedAsk} FeedAsk
         */
        FeedAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.FeedAsk)
                return object;
            var message = new $root.pb.FeedAsk();
            if (object.index != null)
                message.index = String(object.index);
            if (object.idItem != null)
                message.idItem = object.idItem | 0;
            if (object.sidItem != null)
                message.sidItem = String(object.sidItem);
            return message;
        };

        /**
         * Creates a plain object from a FeedAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.FeedAsk
         * @static
         * @param {pb.FeedAsk} message FeedAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        FeedAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.index = "";
                object.idItem = 0;
                object.sidItem = "";
            }
            if (message.index != null && message.hasOwnProperty("index"))
                object.index = message.index;
            if (message.idItem != null && message.hasOwnProperty("idItem"))
                object.idItem = message.idItem;
            if (message.sidItem != null && message.hasOwnProperty("sidItem"))
                object.sidItem = message.sidItem;
            return object;
        };

        /**
         * Converts this FeedAsk to JSON.
         * @function toJSON
         * @memberof pb.FeedAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        FeedAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return FeedAsk;
    })();

    pb.FeedRes = (function() {

        /**
         * Properties of a FeedRes.
         * @memberof pb
         * @interface IFeedRes
         */

        /**
         * Constructs a new FeedRes.
         * @memberof pb
         * @classdesc Represents a FeedRes.
         * @constructor
         * @param {pb.IFeedRes=} [properties] Properties to set
         */
        function FeedRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new FeedRes instance using the specified properties.
         * @function create
         * @memberof pb.FeedRes
         * @static
         * @param {pb.IFeedRes=} [properties] Properties to set
         * @returns {pb.FeedRes} FeedRes instance
         */
        FeedRes.create = function create(properties) {
            return new FeedRes(properties);
        };

        /**
         * Encodes the specified FeedRes message. Does not implicitly {@link pb.FeedRes.verify|verify} messages.
         * @function encode
         * @memberof pb.FeedRes
         * @static
         * @param {pb.IFeedRes} message FeedRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FeedRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified FeedRes message, length delimited. Does not implicitly {@link pb.FeedRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.FeedRes
         * @static
         * @param {pb.IFeedRes} message FeedRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FeedRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a FeedRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.FeedRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.FeedRes} FeedRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FeedRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.FeedRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a FeedRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.FeedRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.FeedRes} FeedRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FeedRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a FeedRes message.
         * @function verify
         * @memberof pb.FeedRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        FeedRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a FeedRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.FeedRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.FeedRes} FeedRes
         */
        FeedRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.FeedRes)
                return object;
            return new $root.pb.FeedRes();
        };

        /**
         * Creates a plain object from a FeedRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.FeedRes
         * @static
         * @param {pb.FeedRes} message FeedRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        FeedRes.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this FeedRes to JSON.
         * @function toJSON
         * @memberof pb.FeedRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        FeedRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return FeedRes;
    })();

    pb.OpenBoxAsk = (function() {

        /**
         * Properties of an OpenBoxAsk.
         * @memberof pb
         * @interface IOpenBoxAsk
         * @property {number} [index] OpenBoxAsk index
         */

        /**
         * Constructs a new OpenBoxAsk.
         * @memberof pb
         * @classdesc Represents an OpenBoxAsk.
         * @constructor
         * @param {pb.IOpenBoxAsk=} [properties] Properties to set
         */
        function OpenBoxAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * OpenBoxAsk index.
         * @member {number}index
         * @memberof pb.OpenBoxAsk
         * @instance
         */
        OpenBoxAsk.prototype.index = 0;

        /**
         * Creates a new OpenBoxAsk instance using the specified properties.
         * @function create
         * @memberof pb.OpenBoxAsk
         * @static
         * @param {pb.IOpenBoxAsk=} [properties] Properties to set
         * @returns {pb.OpenBoxAsk} OpenBoxAsk instance
         */
        OpenBoxAsk.create = function create(properties) {
            return new OpenBoxAsk(properties);
        };

        /**
         * Encodes the specified OpenBoxAsk message. Does not implicitly {@link pb.OpenBoxAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.OpenBoxAsk
         * @static
         * @param {pb.IOpenBoxAsk} message OpenBoxAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        OpenBoxAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.index != null && message.hasOwnProperty("index"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.index);
            return writer;
        };

        /**
         * Encodes the specified OpenBoxAsk message, length delimited. Does not implicitly {@link pb.OpenBoxAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.OpenBoxAsk
         * @static
         * @param {pb.IOpenBoxAsk} message OpenBoxAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        OpenBoxAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an OpenBoxAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.OpenBoxAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.OpenBoxAsk} OpenBoxAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        OpenBoxAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.OpenBoxAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.index = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an OpenBoxAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.OpenBoxAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.OpenBoxAsk} OpenBoxAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        OpenBoxAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an OpenBoxAsk message.
         * @function verify
         * @memberof pb.OpenBoxAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        OpenBoxAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.index != null && message.hasOwnProperty("index"))
                if (!$util.isInteger(message.index))
                    return "index: integer expected";
            return null;
        };

        /**
         * Creates an OpenBoxAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.OpenBoxAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.OpenBoxAsk} OpenBoxAsk
         */
        OpenBoxAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.OpenBoxAsk)
                return object;
            var message = new $root.pb.OpenBoxAsk();
            if (object.index != null)
                message.index = object.index | 0;
            return message;
        };

        /**
         * Creates a plain object from an OpenBoxAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.OpenBoxAsk
         * @static
         * @param {pb.OpenBoxAsk} message OpenBoxAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        OpenBoxAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.index = 0;
            if (message.index != null && message.hasOwnProperty("index"))
                object.index = message.index;
            return object;
        };

        /**
         * Converts this OpenBoxAsk to JSON.
         * @function toJSON
         * @memberof pb.OpenBoxAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        OpenBoxAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return OpenBoxAsk;
    })();

    pb.OpenBoxRes = (function() {

        /**
         * Properties of an OpenBoxRes.
         * @memberof pb
         * @interface IOpenBoxRes
         * @property {pb.IProperty} [pro] OpenBoxRes pro
         */

        /**
         * Constructs a new OpenBoxRes.
         * @memberof pb
         * @classdesc Represents an OpenBoxRes.
         * @constructor
         * @param {pb.IOpenBoxRes=} [properties] Properties to set
         */
        function OpenBoxRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * OpenBoxRes pro.
         * @member {(pb.IProperty|null|undefined)}pro
         * @memberof pb.OpenBoxRes
         * @instance
         */
        OpenBoxRes.prototype.pro = null;

        /**
         * Creates a new OpenBoxRes instance using the specified properties.
         * @function create
         * @memberof pb.OpenBoxRes
         * @static
         * @param {pb.IOpenBoxRes=} [properties] Properties to set
         * @returns {pb.OpenBoxRes} OpenBoxRes instance
         */
        OpenBoxRes.create = function create(properties) {
            return new OpenBoxRes(properties);
        };

        /**
         * Encodes the specified OpenBoxRes message. Does not implicitly {@link pb.OpenBoxRes.verify|verify} messages.
         * @function encode
         * @memberof pb.OpenBoxRes
         * @static
         * @param {pb.IOpenBoxRes} message OpenBoxRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        OpenBoxRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.pro != null && message.hasOwnProperty("pro"))
                $root.pb.Property.encode(message.pro, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified OpenBoxRes message, length delimited. Does not implicitly {@link pb.OpenBoxRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.OpenBoxRes
         * @static
         * @param {pb.IOpenBoxRes} message OpenBoxRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        OpenBoxRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an OpenBoxRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.OpenBoxRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.OpenBoxRes} OpenBoxRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        OpenBoxRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.OpenBoxRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.pro = $root.pb.Property.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an OpenBoxRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.OpenBoxRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.OpenBoxRes} OpenBoxRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        OpenBoxRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an OpenBoxRes message.
         * @function verify
         * @memberof pb.OpenBoxRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        OpenBoxRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.pro != null && message.hasOwnProperty("pro")) {
                var error = $root.pb.Property.verify(message.pro);
                if (error)
                    return "pro." + error;
            }
            return null;
        };

        /**
         * Creates an OpenBoxRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.OpenBoxRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.OpenBoxRes} OpenBoxRes
         */
        OpenBoxRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.OpenBoxRes)
                return object;
            var message = new $root.pb.OpenBoxRes();
            if (object.pro != null) {
                if (typeof object.pro !== "object")
                    throw TypeError(".pb.OpenBoxRes.pro: object expected");
                message.pro = $root.pb.Property.fromObject(object.pro);
            }
            return message;
        };

        /**
         * Creates a plain object from an OpenBoxRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.OpenBoxRes
         * @static
         * @param {pb.OpenBoxRes} message OpenBoxRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        OpenBoxRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.pro = null;
            if (message.pro != null && message.hasOwnProperty("pro"))
                object.pro = $root.pb.Property.toObject(message.pro, options);
            return object;
        };

        /**
         * Converts this OpenBoxRes to JSON.
         * @function toJSON
         * @memberof pb.OpenBoxRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        OpenBoxRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return OpenBoxRes;
    })();

    pb.CardNumChangeRes = (function() {

        /**
         * Properties of a CardNumChangeRes.
         * @memberof pb
         * @interface ICardNumChangeRes
         */

        /**
         * Constructs a new CardNumChangeRes.
         * @memberof pb
         * @classdesc Represents a CardNumChangeRes.
         * @constructor
         * @param {pb.ICardNumChangeRes=} [properties] Properties to set
         */
        function CardNumChangeRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new CardNumChangeRes instance using the specified properties.
         * @function create
         * @memberof pb.CardNumChangeRes
         * @static
         * @param {pb.ICardNumChangeRes=} [properties] Properties to set
         * @returns {pb.CardNumChangeRes} CardNumChangeRes instance
         */
        CardNumChangeRes.create = function create(properties) {
            return new CardNumChangeRes(properties);
        };

        /**
         * Encodes the specified CardNumChangeRes message. Does not implicitly {@link pb.CardNumChangeRes.verify|verify} messages.
         * @function encode
         * @memberof pb.CardNumChangeRes
         * @static
         * @param {pb.ICardNumChangeRes} message CardNumChangeRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CardNumChangeRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified CardNumChangeRes message, length delimited. Does not implicitly {@link pb.CardNumChangeRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.CardNumChangeRes
         * @static
         * @param {pb.ICardNumChangeRes} message CardNumChangeRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CardNumChangeRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a CardNumChangeRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.CardNumChangeRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.CardNumChangeRes} CardNumChangeRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CardNumChangeRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.CardNumChangeRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a CardNumChangeRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.CardNumChangeRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.CardNumChangeRes} CardNumChangeRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CardNumChangeRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a CardNumChangeRes message.
         * @function verify
         * @memberof pb.CardNumChangeRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        CardNumChangeRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a CardNumChangeRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.CardNumChangeRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.CardNumChangeRes} CardNumChangeRes
         */
        CardNumChangeRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.CardNumChangeRes)
                return object;
            return new $root.pb.CardNumChangeRes();
        };

        /**
         * Creates a plain object from a CardNumChangeRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.CardNumChangeRes
         * @static
         * @param {pb.CardNumChangeRes} message CardNumChangeRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        CardNumChangeRes.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this CardNumChangeRes to JSON.
         * @function toJSON
         * @memberof pb.CardNumChangeRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        CardNumChangeRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return CardNumChangeRes;
    })();

    pb.FormationRes = (function() {

        /**
         * Properties of a FormationRes.
         * @memberof pb
         * @interface IFormationRes
         */

        /**
         * Constructs a new FormationRes.
         * @memberof pb
         * @classdesc Represents a FormationRes.
         * @constructor
         * @param {pb.IFormationRes=} [properties] Properties to set
         */
        function FormationRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new FormationRes instance using the specified properties.
         * @function create
         * @memberof pb.FormationRes
         * @static
         * @param {pb.IFormationRes=} [properties] Properties to set
         * @returns {pb.FormationRes} FormationRes instance
         */
        FormationRes.create = function create(properties) {
            return new FormationRes(properties);
        };

        /**
         * Encodes the specified FormationRes message. Does not implicitly {@link pb.FormationRes.verify|verify} messages.
         * @function encode
         * @memberof pb.FormationRes
         * @static
         * @param {pb.IFormationRes} message FormationRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FormationRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified FormationRes message, length delimited. Does not implicitly {@link pb.FormationRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.FormationRes
         * @static
         * @param {pb.IFormationRes} message FormationRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FormationRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a FormationRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.FormationRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.FormationRes} FormationRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FormationRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.FormationRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a FormationRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.FormationRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.FormationRes} FormationRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FormationRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a FormationRes message.
         * @function verify
         * @memberof pb.FormationRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        FormationRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a FormationRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.FormationRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.FormationRes} FormationRes
         */
        FormationRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.FormationRes)
                return object;
            return new $root.pb.FormationRes();
        };

        /**
         * Creates a plain object from a FormationRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.FormationRes
         * @static
         * @param {pb.FormationRes} message FormationRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        FormationRes.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this FormationRes to JSON.
         * @function toJSON
         * @memberof pb.FormationRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        FormationRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return FormationRes;
    })();

    pb.WearXAsk = (function() {

        /**
         * Properties of a WearXAsk.
         * @memberof pb
         * @interface IWearXAsk
         * @property {number} [index] WearXAsk index
         */

        /**
         * Constructs a new WearXAsk.
         * @memberof pb
         * @classdesc Represents a WearXAsk.
         * @constructor
         * @param {pb.IWearXAsk=} [properties] Properties to set
         */
        function WearXAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * WearXAsk index.
         * @member {number}index
         * @memberof pb.WearXAsk
         * @instance
         */
        WearXAsk.prototype.index = 0;

        /**
         * Creates a new WearXAsk instance using the specified properties.
         * @function create
         * @memberof pb.WearXAsk
         * @static
         * @param {pb.IWearXAsk=} [properties] Properties to set
         * @returns {pb.WearXAsk} WearXAsk instance
         */
        WearXAsk.create = function create(properties) {
            return new WearXAsk(properties);
        };

        /**
         * Encodes the specified WearXAsk message. Does not implicitly {@link pb.WearXAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.WearXAsk
         * @static
         * @param {pb.IWearXAsk} message WearXAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        WearXAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.index != null && message.hasOwnProperty("index"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.index);
            return writer;
        };

        /**
         * Encodes the specified WearXAsk message, length delimited. Does not implicitly {@link pb.WearXAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.WearXAsk
         * @static
         * @param {pb.IWearXAsk} message WearXAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        WearXAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a WearXAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.WearXAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.WearXAsk} WearXAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        WearXAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.WearXAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.index = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a WearXAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.WearXAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.WearXAsk} WearXAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        WearXAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a WearXAsk message.
         * @function verify
         * @memberof pb.WearXAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        WearXAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.index != null && message.hasOwnProperty("index"))
                if (!$util.isInteger(message.index))
                    return "index: integer expected";
            return null;
        };

        /**
         * Creates a WearXAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.WearXAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.WearXAsk} WearXAsk
         */
        WearXAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.WearXAsk)
                return object;
            var message = new $root.pb.WearXAsk();
            if (object.index != null)
                message.index = object.index | 0;
            return message;
        };

        /**
         * Creates a plain object from a WearXAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.WearXAsk
         * @static
         * @param {pb.WearXAsk} message WearXAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        WearXAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.index = 0;
            if (message.index != null && message.hasOwnProperty("index"))
                object.index = message.index;
            return object;
        };

        /**
         * Converts this WearXAsk to JSON.
         * @function toJSON
         * @memberof pb.WearXAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        WearXAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return WearXAsk;
    })();

    pb.PassAsk = (function() {

        /**
         * Properties of a PassAsk.
         * @memberof pb
         * @interface IPassAsk
         * @property {string} [index] PassAsk index
         */

        /**
         * Constructs a new PassAsk.
         * @memberof pb
         * @classdesc Represents a PassAsk.
         * @constructor
         * @param {pb.IPassAsk=} [properties] Properties to set
         */
        function PassAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * PassAsk index.
         * @member {string}index
         * @memberof pb.PassAsk
         * @instance
         */
        PassAsk.prototype.index = "";

        /**
         * Creates a new PassAsk instance using the specified properties.
         * @function create
         * @memberof pb.PassAsk
         * @static
         * @param {pb.IPassAsk=} [properties] Properties to set
         * @returns {pb.PassAsk} PassAsk instance
         */
        PassAsk.create = function create(properties) {
            return new PassAsk(properties);
        };

        /**
         * Encodes the specified PassAsk message. Does not implicitly {@link pb.PassAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.PassAsk
         * @static
         * @param {pb.IPassAsk} message PassAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        PassAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.index != null && message.hasOwnProperty("index"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.index);
            return writer;
        };

        /**
         * Encodes the specified PassAsk message, length delimited. Does not implicitly {@link pb.PassAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.PassAsk
         * @static
         * @param {pb.IPassAsk} message PassAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        PassAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a PassAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.PassAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.PassAsk} PassAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        PassAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.PassAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.index = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a PassAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.PassAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.PassAsk} PassAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        PassAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a PassAsk message.
         * @function verify
         * @memberof pb.PassAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        PassAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.index != null && message.hasOwnProperty("index"))
                if (!$util.isString(message.index))
                    return "index: string expected";
            return null;
        };

        /**
         * Creates a PassAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.PassAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.PassAsk} PassAsk
         */
        PassAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.PassAsk)
                return object;
            var message = new $root.pb.PassAsk();
            if (object.index != null)
                message.index = String(object.index);
            return message;
        };

        /**
         * Creates a plain object from a PassAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.PassAsk
         * @static
         * @param {pb.PassAsk} message PassAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        PassAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.index = "";
            if (message.index != null && message.hasOwnProperty("index"))
                object.index = message.index;
            return object;
        };

        /**
         * Converts this PassAsk to JSON.
         * @function toJSON
         * @memberof pb.PassAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        PassAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return PassAsk;
    })();

    pb.PassRes = (function() {

        /**
         * Properties of a PassRes.
         * @memberof pb
         * @interface IPassRes
         * @property {boolean} [res] PassRes res
         */

        /**
         * Constructs a new PassRes.
         * @memberof pb
         * @classdesc Represents a PassRes.
         * @constructor
         * @param {pb.IPassRes=} [properties] Properties to set
         */
        function PassRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * PassRes res.
         * @member {boolean}res
         * @memberof pb.PassRes
         * @instance
         */
        PassRes.prototype.res = false;

        /**
         * Creates a new PassRes instance using the specified properties.
         * @function create
         * @memberof pb.PassRes
         * @static
         * @param {pb.IPassRes=} [properties] Properties to set
         * @returns {pb.PassRes} PassRes instance
         */
        PassRes.create = function create(properties) {
            return new PassRes(properties);
        };

        /**
         * Encodes the specified PassRes message. Does not implicitly {@link pb.PassRes.verify|verify} messages.
         * @function encode
         * @memberof pb.PassRes
         * @static
         * @param {pb.IPassRes} message PassRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        PassRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.res != null && message.hasOwnProperty("res"))
                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.res);
            return writer;
        };

        /**
         * Encodes the specified PassRes message, length delimited. Does not implicitly {@link pb.PassRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.PassRes
         * @static
         * @param {pb.IPassRes} message PassRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        PassRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a PassRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.PassRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.PassRes} PassRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        PassRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.PassRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.res = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a PassRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.PassRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.PassRes} PassRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        PassRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a PassRes message.
         * @function verify
         * @memberof pb.PassRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        PassRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.res != null && message.hasOwnProperty("res"))
                if (typeof message.res !== "boolean")
                    return "res: boolean expected";
            return null;
        };

        /**
         * Creates a PassRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.PassRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.PassRes} PassRes
         */
        PassRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.PassRes)
                return object;
            var message = new $root.pb.PassRes();
            if (object.res != null)
                message.res = Boolean(object.res);
            return message;
        };

        /**
         * Creates a plain object from a PassRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.PassRes
         * @static
         * @param {pb.PassRes} message PassRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        PassRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.res = false;
            if (message.res != null && message.hasOwnProperty("res"))
                object.res = message.res;
            return object;
        };

        /**
         * Converts this PassRes to JSON.
         * @function toJSON
         * @memberof pb.PassRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        PassRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return PassRes;
    })();

    pb.JianUpAsk = (function() {

        /**
         * Properties of a JianUpAsk.
         * @memberof pb
         * @interface IJianUpAsk
         */

        /**
         * Constructs a new JianUpAsk.
         * @memberof pb
         * @classdesc Represents a JianUpAsk.
         * @constructor
         * @param {pb.IJianUpAsk=} [properties] Properties to set
         */
        function JianUpAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new JianUpAsk instance using the specified properties.
         * @function create
         * @memberof pb.JianUpAsk
         * @static
         * @param {pb.IJianUpAsk=} [properties] Properties to set
         * @returns {pb.JianUpAsk} JianUpAsk instance
         */
        JianUpAsk.create = function create(properties) {
            return new JianUpAsk(properties);
        };

        /**
         * Encodes the specified JianUpAsk message. Does not implicitly {@link pb.JianUpAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.JianUpAsk
         * @static
         * @param {pb.IJianUpAsk} message JianUpAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        JianUpAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified JianUpAsk message, length delimited. Does not implicitly {@link pb.JianUpAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.JianUpAsk
         * @static
         * @param {pb.IJianUpAsk} message JianUpAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        JianUpAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a JianUpAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.JianUpAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.JianUpAsk} JianUpAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        JianUpAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.JianUpAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a JianUpAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.JianUpAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.JianUpAsk} JianUpAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        JianUpAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a JianUpAsk message.
         * @function verify
         * @memberof pb.JianUpAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        JianUpAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a JianUpAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.JianUpAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.JianUpAsk} JianUpAsk
         */
        JianUpAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.JianUpAsk)
                return object;
            return new $root.pb.JianUpAsk();
        };

        /**
         * Creates a plain object from a JianUpAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.JianUpAsk
         * @static
         * @param {pb.JianUpAsk} message JianUpAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        JianUpAsk.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this JianUpAsk to JSON.
         * @function toJSON
         * @memberof pb.JianUpAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        JianUpAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return JianUpAsk;
    })();

    pb.JianUpRes = (function() {

        /**
         * Properties of a JianUpRes.
         * @memberof pb
         * @interface IJianUpRes
         */

        /**
         * Constructs a new JianUpRes.
         * @memberof pb
         * @classdesc Represents a JianUpRes.
         * @constructor
         * @param {pb.IJianUpRes=} [properties] Properties to set
         */
        function JianUpRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new JianUpRes instance using the specified properties.
         * @function create
         * @memberof pb.JianUpRes
         * @static
         * @param {pb.IJianUpRes=} [properties] Properties to set
         * @returns {pb.JianUpRes} JianUpRes instance
         */
        JianUpRes.create = function create(properties) {
            return new JianUpRes(properties);
        };

        /**
         * Encodes the specified JianUpRes message. Does not implicitly {@link pb.JianUpRes.verify|verify} messages.
         * @function encode
         * @memberof pb.JianUpRes
         * @static
         * @param {pb.IJianUpRes} message JianUpRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        JianUpRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified JianUpRes message, length delimited. Does not implicitly {@link pb.JianUpRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.JianUpRes
         * @static
         * @param {pb.IJianUpRes} message JianUpRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        JianUpRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a JianUpRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.JianUpRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.JianUpRes} JianUpRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        JianUpRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.JianUpRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a JianUpRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.JianUpRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.JianUpRes} JianUpRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        JianUpRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a JianUpRes message.
         * @function verify
         * @memberof pb.JianUpRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        JianUpRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a JianUpRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.JianUpRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.JianUpRes} JianUpRes
         */
        JianUpRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.JianUpRes)
                return object;
            return new $root.pb.JianUpRes();
        };

        /**
         * Creates a plain object from a JianUpRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.JianUpRes
         * @static
         * @param {pb.JianUpRes} message JianUpRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        JianUpRes.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this JianUpRes to JSON.
         * @function toJSON
         * @memberof pb.JianUpRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        JianUpRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return JianUpRes;
    })();

    pb.FaBaoKillAsk = (function() {

        /**
         * Properties of a FaBaoKillAsk.
         * @memberof pb
         * @interface IFaBaoKillAsk
         * @property {number} [tpe] FaBaoKillAsk tpe
         * @property {number} [index] FaBaoKillAsk index
         * @property {boolean} [isMine] FaBaoKillAsk isMine
         */

        /**
         * Constructs a new FaBaoKillAsk.
         * @memberof pb
         * @classdesc Represents a FaBaoKillAsk.
         * @constructor
         * @param {pb.IFaBaoKillAsk=} [properties] Properties to set
         */
        function FaBaoKillAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * FaBaoKillAsk tpe.
         * @member {number}tpe
         * @memberof pb.FaBaoKillAsk
         * @instance
         */
        FaBaoKillAsk.prototype.tpe = 0;

        /**
         * FaBaoKillAsk index.
         * @member {number}index
         * @memberof pb.FaBaoKillAsk
         * @instance
         */
        FaBaoKillAsk.prototype.index = 0;

        /**
         * FaBaoKillAsk isMine.
         * @member {boolean}isMine
         * @memberof pb.FaBaoKillAsk
         * @instance
         */
        FaBaoKillAsk.prototype.isMine = false;

        /**
         * Creates a new FaBaoKillAsk instance using the specified properties.
         * @function create
         * @memberof pb.FaBaoKillAsk
         * @static
         * @param {pb.IFaBaoKillAsk=} [properties] Properties to set
         * @returns {pb.FaBaoKillAsk} FaBaoKillAsk instance
         */
        FaBaoKillAsk.create = function create(properties) {
            return new FaBaoKillAsk(properties);
        };

        /**
         * Encodes the specified FaBaoKillAsk message. Does not implicitly {@link pb.FaBaoKillAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.FaBaoKillAsk
         * @static
         * @param {pb.IFaBaoKillAsk} message FaBaoKillAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FaBaoKillAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.tpe);
            if (message.index != null && message.hasOwnProperty("index"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.index);
            if (message.isMine != null && message.hasOwnProperty("isMine"))
                writer.uint32(/* id 3, wireType 0 =*/24).bool(message.isMine);
            return writer;
        };

        /**
         * Encodes the specified FaBaoKillAsk message, length delimited. Does not implicitly {@link pb.FaBaoKillAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.FaBaoKillAsk
         * @static
         * @param {pb.IFaBaoKillAsk} message FaBaoKillAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FaBaoKillAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a FaBaoKillAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.FaBaoKillAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.FaBaoKillAsk} FaBaoKillAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FaBaoKillAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.FaBaoKillAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.tpe = reader.int32();
                    break;
                case 2:
                    message.index = reader.int32();
                    break;
                case 3:
                    message.isMine = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a FaBaoKillAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.FaBaoKillAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.FaBaoKillAsk} FaBaoKillAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FaBaoKillAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a FaBaoKillAsk message.
         * @function verify
         * @memberof pb.FaBaoKillAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        FaBaoKillAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                if (!$util.isInteger(message.tpe))
                    return "tpe: integer expected";
            if (message.index != null && message.hasOwnProperty("index"))
                if (!$util.isInteger(message.index))
                    return "index: integer expected";
            if (message.isMine != null && message.hasOwnProperty("isMine"))
                if (typeof message.isMine !== "boolean")
                    return "isMine: boolean expected";
            return null;
        };

        /**
         * Creates a FaBaoKillAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.FaBaoKillAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.FaBaoKillAsk} FaBaoKillAsk
         */
        FaBaoKillAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.FaBaoKillAsk)
                return object;
            var message = new $root.pb.FaBaoKillAsk();
            if (object.tpe != null)
                message.tpe = object.tpe | 0;
            if (object.index != null)
                message.index = object.index | 0;
            if (object.isMine != null)
                message.isMine = Boolean(object.isMine);
            return message;
        };

        /**
         * Creates a plain object from a FaBaoKillAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.FaBaoKillAsk
         * @static
         * @param {pb.FaBaoKillAsk} message FaBaoKillAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        FaBaoKillAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.tpe = 0;
                object.index = 0;
                object.isMine = false;
            }
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                object.tpe = message.tpe;
            if (message.index != null && message.hasOwnProperty("index"))
                object.index = message.index;
            if (message.isMine != null && message.hasOwnProperty("isMine"))
                object.isMine = message.isMine;
            return object;
        };

        /**
         * Converts this FaBaoKillAsk to JSON.
         * @function toJSON
         * @memberof pb.FaBaoKillAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        FaBaoKillAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return FaBaoKillAsk;
    })();

    pb.DingUpAsk = (function() {

        /**
         * Properties of a DingUpAsk.
         * @memberof pb
         * @interface IDingUpAsk
         */

        /**
         * Constructs a new DingUpAsk.
         * @memberof pb
         * @classdesc Represents a DingUpAsk.
         * @constructor
         * @param {pb.IDingUpAsk=} [properties] Properties to set
         */
        function DingUpAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new DingUpAsk instance using the specified properties.
         * @function create
         * @memberof pb.DingUpAsk
         * @static
         * @param {pb.IDingUpAsk=} [properties] Properties to set
         * @returns {pb.DingUpAsk} DingUpAsk instance
         */
        DingUpAsk.create = function create(properties) {
            return new DingUpAsk(properties);
        };

        /**
         * Encodes the specified DingUpAsk message. Does not implicitly {@link pb.DingUpAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.DingUpAsk
         * @static
         * @param {pb.IDingUpAsk} message DingUpAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DingUpAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified DingUpAsk message, length delimited. Does not implicitly {@link pb.DingUpAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.DingUpAsk
         * @static
         * @param {pb.IDingUpAsk} message DingUpAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DingUpAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DingUpAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.DingUpAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.DingUpAsk} DingUpAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DingUpAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.DingUpAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DingUpAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.DingUpAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.DingUpAsk} DingUpAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DingUpAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DingUpAsk message.
         * @function verify
         * @memberof pb.DingUpAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DingUpAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a DingUpAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.DingUpAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.DingUpAsk} DingUpAsk
         */
        DingUpAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.DingUpAsk)
                return object;
            return new $root.pb.DingUpAsk();
        };

        /**
         * Creates a plain object from a DingUpAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.DingUpAsk
         * @static
         * @param {pb.DingUpAsk} message DingUpAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DingUpAsk.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this DingUpAsk to JSON.
         * @function toJSON
         * @memberof pb.DingUpAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DingUpAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DingUpAsk;
    })();

    pb.DingUpRes = (function() {

        /**
         * Properties of a DingUpRes.
         * @memberof pb
         * @interface IDingUpRes
         */

        /**
         * Constructs a new DingUpRes.
         * @memberof pb
         * @classdesc Represents a DingUpRes.
         * @constructor
         * @param {pb.IDingUpRes=} [properties] Properties to set
         */
        function DingUpRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new DingUpRes instance using the specified properties.
         * @function create
         * @memberof pb.DingUpRes
         * @static
         * @param {pb.IDingUpRes=} [properties] Properties to set
         * @returns {pb.DingUpRes} DingUpRes instance
         */
        DingUpRes.create = function create(properties) {
            return new DingUpRes(properties);
        };

        /**
         * Encodes the specified DingUpRes message. Does not implicitly {@link pb.DingUpRes.verify|verify} messages.
         * @function encode
         * @memberof pb.DingUpRes
         * @static
         * @param {pb.IDingUpRes} message DingUpRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DingUpRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified DingUpRes message, length delimited. Does not implicitly {@link pb.DingUpRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.DingUpRes
         * @static
         * @param {pb.IDingUpRes} message DingUpRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DingUpRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DingUpRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.DingUpRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.DingUpRes} DingUpRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DingUpRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.DingUpRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DingUpRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.DingUpRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.DingUpRes} DingUpRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DingUpRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DingUpRes message.
         * @function verify
         * @memberof pb.DingUpRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DingUpRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a DingUpRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.DingUpRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.DingUpRes} DingUpRes
         */
        DingUpRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.DingUpRes)
                return object;
            return new $root.pb.DingUpRes();
        };

        /**
         * Creates a plain object from a DingUpRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.DingUpRes
         * @static
         * @param {pb.DingUpRes} message DingUpRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DingUpRes.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this DingUpRes to JSON.
         * @function toJSON
         * @memberof pb.DingUpRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DingUpRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DingUpRes;
    })();

    pb.JianBreakAsk = (function() {

        /**
         * Properties of a JianBreakAsk.
         * @memberof pb
         * @interface IJianBreakAsk
         */

        /**
         * Constructs a new JianBreakAsk.
         * @memberof pb
         * @classdesc Represents a JianBreakAsk.
         * @constructor
         * @param {pb.IJianBreakAsk=} [properties] Properties to set
         */
        function JianBreakAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new JianBreakAsk instance using the specified properties.
         * @function create
         * @memberof pb.JianBreakAsk
         * @static
         * @param {pb.IJianBreakAsk=} [properties] Properties to set
         * @returns {pb.JianBreakAsk} JianBreakAsk instance
         */
        JianBreakAsk.create = function create(properties) {
            return new JianBreakAsk(properties);
        };

        /**
         * Encodes the specified JianBreakAsk message. Does not implicitly {@link pb.JianBreakAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.JianBreakAsk
         * @static
         * @param {pb.IJianBreakAsk} message JianBreakAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        JianBreakAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified JianBreakAsk message, length delimited. Does not implicitly {@link pb.JianBreakAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.JianBreakAsk
         * @static
         * @param {pb.IJianBreakAsk} message JianBreakAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        JianBreakAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a JianBreakAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.JianBreakAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.JianBreakAsk} JianBreakAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        JianBreakAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.JianBreakAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a JianBreakAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.JianBreakAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.JianBreakAsk} JianBreakAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        JianBreakAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a JianBreakAsk message.
         * @function verify
         * @memberof pb.JianBreakAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        JianBreakAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a JianBreakAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.JianBreakAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.JianBreakAsk} JianBreakAsk
         */
        JianBreakAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.JianBreakAsk)
                return object;
            return new $root.pb.JianBreakAsk();
        };

        /**
         * Creates a plain object from a JianBreakAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.JianBreakAsk
         * @static
         * @param {pb.JianBreakAsk} message JianBreakAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        JianBreakAsk.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this JianBreakAsk to JSON.
         * @function toJSON
         * @memberof pb.JianBreakAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        JianBreakAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return JianBreakAsk;
    })();

    pb.JianBreakRes = (function() {

        /**
         * Properties of a JianBreakRes.
         * @memberof pb
         * @interface IJianBreakRes
         * @property {boolean} [res] JianBreakRes res
         */

        /**
         * Constructs a new JianBreakRes.
         * @memberof pb
         * @classdesc Represents a JianBreakRes.
         * @constructor
         * @param {pb.IJianBreakRes=} [properties] Properties to set
         */
        function JianBreakRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * JianBreakRes res.
         * @member {boolean}res
         * @memberof pb.JianBreakRes
         * @instance
         */
        JianBreakRes.prototype.res = false;

        /**
         * Creates a new JianBreakRes instance using the specified properties.
         * @function create
         * @memberof pb.JianBreakRes
         * @static
         * @param {pb.IJianBreakRes=} [properties] Properties to set
         * @returns {pb.JianBreakRes} JianBreakRes instance
         */
        JianBreakRes.create = function create(properties) {
            return new JianBreakRes(properties);
        };

        /**
         * Encodes the specified JianBreakRes message. Does not implicitly {@link pb.JianBreakRes.verify|verify} messages.
         * @function encode
         * @memberof pb.JianBreakRes
         * @static
         * @param {pb.IJianBreakRes} message JianBreakRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        JianBreakRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.res != null && message.hasOwnProperty("res"))
                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.res);
            return writer;
        };

        /**
         * Encodes the specified JianBreakRes message, length delimited. Does not implicitly {@link pb.JianBreakRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.JianBreakRes
         * @static
         * @param {pb.IJianBreakRes} message JianBreakRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        JianBreakRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a JianBreakRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.JianBreakRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.JianBreakRes} JianBreakRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        JianBreakRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.JianBreakRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.res = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a JianBreakRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.JianBreakRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.JianBreakRes} JianBreakRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        JianBreakRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a JianBreakRes message.
         * @function verify
         * @memberof pb.JianBreakRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        JianBreakRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.res != null && message.hasOwnProperty("res"))
                if (typeof message.res !== "boolean")
                    return "res: boolean expected";
            return null;
        };

        /**
         * Creates a JianBreakRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.JianBreakRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.JianBreakRes} JianBreakRes
         */
        JianBreakRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.JianBreakRes)
                return object;
            var message = new $root.pb.JianBreakRes();
            if (object.res != null)
                message.res = Boolean(object.res);
            return message;
        };

        /**
         * Creates a plain object from a JianBreakRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.JianBreakRes
         * @static
         * @param {pb.JianBreakRes} message JianBreakRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        JianBreakRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.res = false;
            if (message.res != null && message.hasOwnProperty("res"))
                object.res = message.res;
            return object;
        };

        /**
         * Converts this JianBreakRes to JSON.
         * @function toJSON
         * @memberof pb.JianBreakRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        JianBreakRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return JianBreakRes;
    })();

    pb.DingBreakAsk = (function() {

        /**
         * Properties of a DingBreakAsk.
         * @memberof pb
         * @interface IDingBreakAsk
         */

        /**
         * Constructs a new DingBreakAsk.
         * @memberof pb
         * @classdesc Represents a DingBreakAsk.
         * @constructor
         * @param {pb.IDingBreakAsk=} [properties] Properties to set
         */
        function DingBreakAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new DingBreakAsk instance using the specified properties.
         * @function create
         * @memberof pb.DingBreakAsk
         * @static
         * @param {pb.IDingBreakAsk=} [properties] Properties to set
         * @returns {pb.DingBreakAsk} DingBreakAsk instance
         */
        DingBreakAsk.create = function create(properties) {
            return new DingBreakAsk(properties);
        };

        /**
         * Encodes the specified DingBreakAsk message. Does not implicitly {@link pb.DingBreakAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.DingBreakAsk
         * @static
         * @param {pb.IDingBreakAsk} message DingBreakAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DingBreakAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified DingBreakAsk message, length delimited. Does not implicitly {@link pb.DingBreakAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.DingBreakAsk
         * @static
         * @param {pb.IDingBreakAsk} message DingBreakAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DingBreakAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DingBreakAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.DingBreakAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.DingBreakAsk} DingBreakAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DingBreakAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.DingBreakAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DingBreakAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.DingBreakAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.DingBreakAsk} DingBreakAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DingBreakAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DingBreakAsk message.
         * @function verify
         * @memberof pb.DingBreakAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DingBreakAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a DingBreakAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.DingBreakAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.DingBreakAsk} DingBreakAsk
         */
        DingBreakAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.DingBreakAsk)
                return object;
            return new $root.pb.DingBreakAsk();
        };

        /**
         * Creates a plain object from a DingBreakAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.DingBreakAsk
         * @static
         * @param {pb.DingBreakAsk} message DingBreakAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DingBreakAsk.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this DingBreakAsk to JSON.
         * @function toJSON
         * @memberof pb.DingBreakAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DingBreakAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DingBreakAsk;
    })();

    pb.DingBreakRes = (function() {

        /**
         * Properties of a DingBreakRes.
         * @memberof pb
         * @interface IDingBreakRes
         * @property {boolean} [res] DingBreakRes res
         */

        /**
         * Constructs a new DingBreakRes.
         * @memberof pb
         * @classdesc Represents a DingBreakRes.
         * @constructor
         * @param {pb.IDingBreakRes=} [properties] Properties to set
         */
        function DingBreakRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DingBreakRes res.
         * @member {boolean}res
         * @memberof pb.DingBreakRes
         * @instance
         */
        DingBreakRes.prototype.res = false;

        /**
         * Creates a new DingBreakRes instance using the specified properties.
         * @function create
         * @memberof pb.DingBreakRes
         * @static
         * @param {pb.IDingBreakRes=} [properties] Properties to set
         * @returns {pb.DingBreakRes} DingBreakRes instance
         */
        DingBreakRes.create = function create(properties) {
            return new DingBreakRes(properties);
        };

        /**
         * Encodes the specified DingBreakRes message. Does not implicitly {@link pb.DingBreakRes.verify|verify} messages.
         * @function encode
         * @memberof pb.DingBreakRes
         * @static
         * @param {pb.IDingBreakRes} message DingBreakRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DingBreakRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.res != null && message.hasOwnProperty("res"))
                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.res);
            return writer;
        };

        /**
         * Encodes the specified DingBreakRes message, length delimited. Does not implicitly {@link pb.DingBreakRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.DingBreakRes
         * @static
         * @param {pb.IDingBreakRes} message DingBreakRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DingBreakRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DingBreakRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.DingBreakRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.DingBreakRes} DingBreakRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DingBreakRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.DingBreakRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.res = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DingBreakRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.DingBreakRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.DingBreakRes} DingBreakRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DingBreakRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DingBreakRes message.
         * @function verify
         * @memberof pb.DingBreakRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DingBreakRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.res != null && message.hasOwnProperty("res"))
                if (typeof message.res !== "boolean")
                    return "res: boolean expected";
            return null;
        };

        /**
         * Creates a DingBreakRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.DingBreakRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.DingBreakRes} DingBreakRes
         */
        DingBreakRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.DingBreakRes)
                return object;
            var message = new $root.pb.DingBreakRes();
            if (object.res != null)
                message.res = Boolean(object.res);
            return message;
        };

        /**
         * Creates a plain object from a DingBreakRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.DingBreakRes
         * @static
         * @param {pb.DingBreakRes} message DingBreakRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DingBreakRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.res = false;
            if (message.res != null && message.hasOwnProperty("res"))
                object.res = message.res;
            return object;
        };

        /**
         * Converts this DingBreakRes to JSON.
         * @function toJSON
         * @memberof pb.DingBreakRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DingBreakRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DingBreakRes;
    })();

    pb.BuyAsk = (function() {

        /**
         * Properties of a BuyAsk.
         * @memberof pb
         * @interface IBuyAsk
         * @property {number} [tpe] BuyAsk tpe
         * @property {number} [idx] BuyAsk idx
         */

        /**
         * Constructs a new BuyAsk.
         * @memberof pb
         * @classdesc Represents a BuyAsk.
         * @constructor
         * @param {pb.IBuyAsk=} [properties] Properties to set
         */
        function BuyAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BuyAsk tpe.
         * @member {number}tpe
         * @memberof pb.BuyAsk
         * @instance
         */
        BuyAsk.prototype.tpe = 0;

        /**
         * BuyAsk idx.
         * @member {number}idx
         * @memberof pb.BuyAsk
         * @instance
         */
        BuyAsk.prototype.idx = 0;

        /**
         * Creates a new BuyAsk instance using the specified properties.
         * @function create
         * @memberof pb.BuyAsk
         * @static
         * @param {pb.IBuyAsk=} [properties] Properties to set
         * @returns {pb.BuyAsk} BuyAsk instance
         */
        BuyAsk.create = function create(properties) {
            return new BuyAsk(properties);
        };

        /**
         * Encodes the specified BuyAsk message. Does not implicitly {@link pb.BuyAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.BuyAsk
         * @static
         * @param {pb.IBuyAsk} message BuyAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BuyAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.tpe);
            if (message.idx != null && message.hasOwnProperty("idx"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.idx);
            return writer;
        };

        /**
         * Encodes the specified BuyAsk message, length delimited. Does not implicitly {@link pb.BuyAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.BuyAsk
         * @static
         * @param {pb.IBuyAsk} message BuyAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BuyAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BuyAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.BuyAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.BuyAsk} BuyAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BuyAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.BuyAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.tpe = reader.int32();
                    break;
                case 2:
                    message.idx = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BuyAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.BuyAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.BuyAsk} BuyAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BuyAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BuyAsk message.
         * @function verify
         * @memberof pb.BuyAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BuyAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                if (!$util.isInteger(message.tpe))
                    return "tpe: integer expected";
            if (message.idx != null && message.hasOwnProperty("idx"))
                if (!$util.isInteger(message.idx))
                    return "idx: integer expected";
            return null;
        };

        /**
         * Creates a BuyAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.BuyAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.BuyAsk} BuyAsk
         */
        BuyAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.BuyAsk)
                return object;
            var message = new $root.pb.BuyAsk();
            if (object.tpe != null)
                message.tpe = object.tpe | 0;
            if (object.idx != null)
                message.idx = object.idx | 0;
            return message;
        };

        /**
         * Creates a plain object from a BuyAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.BuyAsk
         * @static
         * @param {pb.BuyAsk} message BuyAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BuyAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.tpe = 0;
                object.idx = 0;
            }
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                object.tpe = message.tpe;
            if (message.idx != null && message.hasOwnProperty("idx"))
                object.idx = message.idx;
            return object;
        };

        /**
         * Converts this BuyAsk to JSON.
         * @function toJSON
         * @memberof pb.BuyAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BuyAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return BuyAsk;
    })();

    pb.QueryTimeAsk = (function() {

        /**
         * Properties of a QueryTimeAsk.
         * @memberof pb
         * @interface IQueryTimeAsk
         * @property {number} [tpe] QueryTimeAsk tpe
         */

        /**
         * Constructs a new QueryTimeAsk.
         * @memberof pb
         * @classdesc Represents a QueryTimeAsk.
         * @constructor
         * @param {pb.IQueryTimeAsk=} [properties] Properties to set
         */
        function QueryTimeAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * QueryTimeAsk tpe.
         * @member {number}tpe
         * @memberof pb.QueryTimeAsk
         * @instance
         */
        QueryTimeAsk.prototype.tpe = 0;

        /**
         * Creates a new QueryTimeAsk instance using the specified properties.
         * @function create
         * @memberof pb.QueryTimeAsk
         * @static
         * @param {pb.IQueryTimeAsk=} [properties] Properties to set
         * @returns {pb.QueryTimeAsk} QueryTimeAsk instance
         */
        QueryTimeAsk.create = function create(properties) {
            return new QueryTimeAsk(properties);
        };

        /**
         * Encodes the specified QueryTimeAsk message. Does not implicitly {@link pb.QueryTimeAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.QueryTimeAsk
         * @static
         * @param {pb.IQueryTimeAsk} message QueryTimeAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        QueryTimeAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.tpe);
            return writer;
        };

        /**
         * Encodes the specified QueryTimeAsk message, length delimited. Does not implicitly {@link pb.QueryTimeAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.QueryTimeAsk
         * @static
         * @param {pb.IQueryTimeAsk} message QueryTimeAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        QueryTimeAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a QueryTimeAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.QueryTimeAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.QueryTimeAsk} QueryTimeAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        QueryTimeAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.QueryTimeAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.tpe = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a QueryTimeAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.QueryTimeAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.QueryTimeAsk} QueryTimeAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        QueryTimeAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a QueryTimeAsk message.
         * @function verify
         * @memberof pb.QueryTimeAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        QueryTimeAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                if (!$util.isInteger(message.tpe))
                    return "tpe: integer expected";
            return null;
        };

        /**
         * Creates a QueryTimeAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.QueryTimeAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.QueryTimeAsk} QueryTimeAsk
         */
        QueryTimeAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.QueryTimeAsk)
                return object;
            var message = new $root.pb.QueryTimeAsk();
            if (object.tpe != null)
                message.tpe = object.tpe | 0;
            return message;
        };

        /**
         * Creates a plain object from a QueryTimeAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.QueryTimeAsk
         * @static
         * @param {pb.QueryTimeAsk} message QueryTimeAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        QueryTimeAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.tpe = 0;
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                object.tpe = message.tpe;
            return object;
        };

        /**
         * Converts this QueryTimeAsk to JSON.
         * @function toJSON
         * @memberof pb.QueryTimeAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        QueryTimeAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return QueryTimeAsk;
    })();

    pb.QueryTimeRes = (function() {

        /**
         * Properties of a QueryTimeRes.
         * @memberof pb
         * @interface IQueryTimeRes
         */

        /**
         * Constructs a new QueryTimeRes.
         * @memberof pb
         * @classdesc Represents a QueryTimeRes.
         * @constructor
         * @param {pb.IQueryTimeRes=} [properties] Properties to set
         */
        function QueryTimeRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new QueryTimeRes instance using the specified properties.
         * @function create
         * @memberof pb.QueryTimeRes
         * @static
         * @param {pb.IQueryTimeRes=} [properties] Properties to set
         * @returns {pb.QueryTimeRes} QueryTimeRes instance
         */
        QueryTimeRes.create = function create(properties) {
            return new QueryTimeRes(properties);
        };

        /**
         * Encodes the specified QueryTimeRes message. Does not implicitly {@link pb.QueryTimeRes.verify|verify} messages.
         * @function encode
         * @memberof pb.QueryTimeRes
         * @static
         * @param {pb.IQueryTimeRes} message QueryTimeRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        QueryTimeRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified QueryTimeRes message, length delimited. Does not implicitly {@link pb.QueryTimeRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.QueryTimeRes
         * @static
         * @param {pb.IQueryTimeRes} message QueryTimeRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        QueryTimeRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a QueryTimeRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.QueryTimeRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.QueryTimeRes} QueryTimeRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        QueryTimeRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.QueryTimeRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a QueryTimeRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.QueryTimeRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.QueryTimeRes} QueryTimeRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        QueryTimeRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a QueryTimeRes message.
         * @function verify
         * @memberof pb.QueryTimeRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        QueryTimeRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a QueryTimeRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.QueryTimeRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.QueryTimeRes} QueryTimeRes
         */
        QueryTimeRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.QueryTimeRes)
                return object;
            return new $root.pb.QueryTimeRes();
        };

        /**
         * Creates a plain object from a QueryTimeRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.QueryTimeRes
         * @static
         * @param {pb.QueryTimeRes} message QueryTimeRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        QueryTimeRes.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this QueryTimeRes to JSON.
         * @function toJSON
         * @memberof pb.QueryTimeRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        QueryTimeRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return QueryTimeRes;
    })();

    pb.DoAsk = (function() {

        /**
         * Properties of a DoAsk.
         * @memberof pb
         * @interface IDoAsk
         * @property {number} [tpe] DoAsk tpe
         * @property {number} [idx] DoAsk idx
         */

        /**
         * Constructs a new DoAsk.
         * @memberof pb
         * @classdesc Represents a DoAsk.
         * @constructor
         * @param {pb.IDoAsk=} [properties] Properties to set
         */
        function DoAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DoAsk tpe.
         * @member {number}tpe
         * @memberof pb.DoAsk
         * @instance
         */
        DoAsk.prototype.tpe = 0;

        /**
         * DoAsk idx.
         * @member {number}idx
         * @memberof pb.DoAsk
         * @instance
         */
        DoAsk.prototype.idx = 0;

        /**
         * Creates a new DoAsk instance using the specified properties.
         * @function create
         * @memberof pb.DoAsk
         * @static
         * @param {pb.IDoAsk=} [properties] Properties to set
         * @returns {pb.DoAsk} DoAsk instance
         */
        DoAsk.create = function create(properties) {
            return new DoAsk(properties);
        };

        /**
         * Encodes the specified DoAsk message. Does not implicitly {@link pb.DoAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.DoAsk
         * @static
         * @param {pb.IDoAsk} message DoAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DoAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.tpe);
            if (message.idx != null && message.hasOwnProperty("idx"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.idx);
            return writer;
        };

        /**
         * Encodes the specified DoAsk message, length delimited. Does not implicitly {@link pb.DoAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.DoAsk
         * @static
         * @param {pb.IDoAsk} message DoAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DoAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DoAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.DoAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.DoAsk} DoAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DoAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.DoAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.tpe = reader.int32();
                    break;
                case 2:
                    message.idx = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DoAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.DoAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.DoAsk} DoAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DoAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DoAsk message.
         * @function verify
         * @memberof pb.DoAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DoAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                if (!$util.isInteger(message.tpe))
                    return "tpe: integer expected";
            if (message.idx != null && message.hasOwnProperty("idx"))
                if (!$util.isInteger(message.idx))
                    return "idx: integer expected";
            return null;
        };

        /**
         * Creates a DoAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.DoAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.DoAsk} DoAsk
         */
        DoAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.DoAsk)
                return object;
            var message = new $root.pb.DoAsk();
            if (object.tpe != null)
                message.tpe = object.tpe | 0;
            if (object.idx != null)
                message.idx = object.idx | 0;
            return message;
        };

        /**
         * Creates a plain object from a DoAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.DoAsk
         * @static
         * @param {pb.DoAsk} message DoAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DoAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.tpe = 0;
                object.idx = 0;
            }
            if (message.tpe != null && message.hasOwnProperty("tpe"))
                object.tpe = message.tpe;
            if (message.idx != null && message.hasOwnProperty("idx"))
                object.idx = message.idx;
            return object;
        };

        /**
         * Converts this DoAsk to JSON.
         * @function toJSON
         * @memberof pb.DoAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DoAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DoAsk;
    })();

    pb.DoRes = (function() {

        /**
         * Properties of a DoRes.
         * @memberof pb
         * @interface IDoRes
         */

        /**
         * Constructs a new DoRes.
         * @memberof pb
         * @classdesc Represents a DoRes.
         * @constructor
         * @param {pb.IDoRes=} [properties] Properties to set
         */
        function DoRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new DoRes instance using the specified properties.
         * @function create
         * @memberof pb.DoRes
         * @static
         * @param {pb.IDoRes=} [properties] Properties to set
         * @returns {pb.DoRes} DoRes instance
         */
        DoRes.create = function create(properties) {
            return new DoRes(properties);
        };

        /**
         * Encodes the specified DoRes message. Does not implicitly {@link pb.DoRes.verify|verify} messages.
         * @function encode
         * @memberof pb.DoRes
         * @static
         * @param {pb.IDoRes} message DoRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DoRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified DoRes message, length delimited. Does not implicitly {@link pb.DoRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.DoRes
         * @static
         * @param {pb.IDoRes} message DoRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DoRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DoRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.DoRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.DoRes} DoRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DoRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.DoRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DoRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.DoRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.DoRes} DoRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DoRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DoRes message.
         * @function verify
         * @memberof pb.DoRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DoRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a DoRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.DoRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.DoRes} DoRes
         */
        DoRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.DoRes)
                return object;
            return new $root.pb.DoRes();
        };

        /**
         * Creates a plain object from a DoRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.DoRes
         * @static
         * @param {pb.DoRes} message DoRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DoRes.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this DoRes to JSON.
         * @function toJSON
         * @memberof pb.DoRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DoRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DoRes;
    })();

    pb.GoOutAsk = (function() {

        /**
         * Properties of a GoOutAsk.
         * @memberof pb
         * @interface IGoOutAsk
         * @property {string} [index] GoOutAsk index
         */

        /**
         * Constructs a new GoOutAsk.
         * @memberof pb
         * @classdesc Represents a GoOutAsk.
         * @constructor
         * @param {pb.IGoOutAsk=} [properties] Properties to set
         */
        function GoOutAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * GoOutAsk index.
         * @member {string}index
         * @memberof pb.GoOutAsk
         * @instance
         */
        GoOutAsk.prototype.index = "";

        /**
         * Creates a new GoOutAsk instance using the specified properties.
         * @function create
         * @memberof pb.GoOutAsk
         * @static
         * @param {pb.IGoOutAsk=} [properties] Properties to set
         * @returns {pb.GoOutAsk} GoOutAsk instance
         */
        GoOutAsk.create = function create(properties) {
            return new GoOutAsk(properties);
        };

        /**
         * Encodes the specified GoOutAsk message. Does not implicitly {@link pb.GoOutAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.GoOutAsk
         * @static
         * @param {pb.IGoOutAsk} message GoOutAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        GoOutAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.index != null && message.hasOwnProperty("index"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.index);
            return writer;
        };

        /**
         * Encodes the specified GoOutAsk message, length delimited. Does not implicitly {@link pb.GoOutAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.GoOutAsk
         * @static
         * @param {pb.IGoOutAsk} message GoOutAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        GoOutAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a GoOutAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.GoOutAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.GoOutAsk} GoOutAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        GoOutAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.GoOutAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.index = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a GoOutAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.GoOutAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.GoOutAsk} GoOutAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        GoOutAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a GoOutAsk message.
         * @function verify
         * @memberof pb.GoOutAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        GoOutAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.index != null && message.hasOwnProperty("index"))
                if (!$util.isString(message.index))
                    return "index: string expected";
            return null;
        };

        /**
         * Creates a GoOutAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.GoOutAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.GoOutAsk} GoOutAsk
         */
        GoOutAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.GoOutAsk)
                return object;
            var message = new $root.pb.GoOutAsk();
            if (object.index != null)
                message.index = String(object.index);
            return message;
        };

        /**
         * Creates a plain object from a GoOutAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.GoOutAsk
         * @static
         * @param {pb.GoOutAsk} message GoOutAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        GoOutAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.index = "";
            if (message.index != null && message.hasOwnProperty("index"))
                object.index = message.index;
            return object;
        };

        /**
         * Converts this GoOutAsk to JSON.
         * @function toJSON
         * @memberof pb.GoOutAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        GoOutAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return GoOutAsk;
    })();

    pb.GoOutRes = (function() {

        /**
         * Properties of a GoOutRes.
         * @memberof pb
         * @interface IGoOutRes
         */

        /**
         * Constructs a new GoOutRes.
         * @memberof pb
         * @classdesc Represents a GoOutRes.
         * @constructor
         * @param {pb.IGoOutRes=} [properties] Properties to set
         */
        function GoOutRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new GoOutRes instance using the specified properties.
         * @function create
         * @memberof pb.GoOutRes
         * @static
         * @param {pb.IGoOutRes=} [properties] Properties to set
         * @returns {pb.GoOutRes} GoOutRes instance
         */
        GoOutRes.create = function create(properties) {
            return new GoOutRes(properties);
        };

        /**
         * Encodes the specified GoOutRes message. Does not implicitly {@link pb.GoOutRes.verify|verify} messages.
         * @function encode
         * @memberof pb.GoOutRes
         * @static
         * @param {pb.IGoOutRes} message GoOutRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        GoOutRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified GoOutRes message, length delimited. Does not implicitly {@link pb.GoOutRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.GoOutRes
         * @static
         * @param {pb.IGoOutRes} message GoOutRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        GoOutRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a GoOutRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.GoOutRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.GoOutRes} GoOutRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        GoOutRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.GoOutRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a GoOutRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.GoOutRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.GoOutRes} GoOutRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        GoOutRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a GoOutRes message.
         * @function verify
         * @memberof pb.GoOutRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        GoOutRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a GoOutRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.GoOutRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.GoOutRes} GoOutRes
         */
        GoOutRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.GoOutRes)
                return object;
            return new $root.pb.GoOutRes();
        };

        /**
         * Creates a plain object from a GoOutRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.GoOutRes
         * @static
         * @param {pb.GoOutRes} message GoOutRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        GoOutRes.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this GoOutRes to JSON.
         * @function toJSON
         * @memberof pb.GoOutRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        GoOutRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return GoOutRes;
    })();

    pb.FightBossAsk = (function() {

        /**
         * Properties of a FightBossAsk.
         * @memberof pb
         * @interface IFightBossAsk
         */

        /**
         * Constructs a new FightBossAsk.
         * @memberof pb
         * @classdesc Represents a FightBossAsk.
         * @constructor
         * @param {pb.IFightBossAsk=} [properties] Properties to set
         */
        function FightBossAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new FightBossAsk instance using the specified properties.
         * @function create
         * @memberof pb.FightBossAsk
         * @static
         * @param {pb.IFightBossAsk=} [properties] Properties to set
         * @returns {pb.FightBossAsk} FightBossAsk instance
         */
        FightBossAsk.create = function create(properties) {
            return new FightBossAsk(properties);
        };

        /**
         * Encodes the specified FightBossAsk message. Does not implicitly {@link pb.FightBossAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.FightBossAsk
         * @static
         * @param {pb.IFightBossAsk} message FightBossAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FightBossAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified FightBossAsk message, length delimited. Does not implicitly {@link pb.FightBossAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.FightBossAsk
         * @static
         * @param {pb.IFightBossAsk} message FightBossAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FightBossAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a FightBossAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.FightBossAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.FightBossAsk} FightBossAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FightBossAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.FightBossAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a FightBossAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.FightBossAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.FightBossAsk} FightBossAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FightBossAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a FightBossAsk message.
         * @function verify
         * @memberof pb.FightBossAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        FightBossAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a FightBossAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.FightBossAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.FightBossAsk} FightBossAsk
         */
        FightBossAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.FightBossAsk)
                return object;
            return new $root.pb.FightBossAsk();
        };

        /**
         * Creates a plain object from a FightBossAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.FightBossAsk
         * @static
         * @param {pb.FightBossAsk} message FightBossAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        FightBossAsk.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this FightBossAsk to JSON.
         * @function toJSON
         * @memberof pb.FightBossAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        FightBossAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return FightBossAsk;
    })();

    pb.FightBossRes = (function() {

        /**
         * Properties of a FightBossRes.
         * @memberof pb
         * @interface IFightBossRes
         */

        /**
         * Constructs a new FightBossRes.
         * @memberof pb
         * @classdesc Represents a FightBossRes.
         * @constructor
         * @param {pb.IFightBossRes=} [properties] Properties to set
         */
        function FightBossRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new FightBossRes instance using the specified properties.
         * @function create
         * @memberof pb.FightBossRes
         * @static
         * @param {pb.IFightBossRes=} [properties] Properties to set
         * @returns {pb.FightBossRes} FightBossRes instance
         */
        FightBossRes.create = function create(properties) {
            return new FightBossRes(properties);
        };

        /**
         * Encodes the specified FightBossRes message. Does not implicitly {@link pb.FightBossRes.verify|verify} messages.
         * @function encode
         * @memberof pb.FightBossRes
         * @static
         * @param {pb.IFightBossRes} message FightBossRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FightBossRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified FightBossRes message, length delimited. Does not implicitly {@link pb.FightBossRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.FightBossRes
         * @static
         * @param {pb.IFightBossRes} message FightBossRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FightBossRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a FightBossRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.FightBossRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.FightBossRes} FightBossRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FightBossRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.FightBossRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a FightBossRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.FightBossRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.FightBossRes} FightBossRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FightBossRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a FightBossRes message.
         * @function verify
         * @memberof pb.FightBossRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        FightBossRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a FightBossRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.FightBossRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.FightBossRes} FightBossRes
         */
        FightBossRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.FightBossRes)
                return object;
            return new $root.pb.FightBossRes();
        };

        /**
         * Creates a plain object from a FightBossRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.FightBossRes
         * @static
         * @param {pb.FightBossRes} message FightBossRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        FightBossRes.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this FightBossRes to JSON.
         * @function toJSON
         * @memberof pb.FightBossRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        FightBossRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return FightBossRes;
    })();

    pb.PlayEffRes = (function() {

        /**
         * Properties of a PlayEffRes.
         * @memberof pb
         * @interface IPlayEffRes
         * @property {number} [index] PlayEffRes index
         * @property {boolean} [isMine] PlayEffRes isMine
         * @property {string} [eff] PlayEffRes eff
         */

        /**
         * Constructs a new PlayEffRes.
         * @memberof pb
         * @classdesc Represents a PlayEffRes.
         * @constructor
         * @param {pb.IPlayEffRes=} [properties] Properties to set
         */
        function PlayEffRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * PlayEffRes index.
         * @member {number}index
         * @memberof pb.PlayEffRes
         * @instance
         */
        PlayEffRes.prototype.index = 0;

        /**
         * PlayEffRes isMine.
         * @member {boolean}isMine
         * @memberof pb.PlayEffRes
         * @instance
         */
        PlayEffRes.prototype.isMine = false;

        /**
         * PlayEffRes eff.
         * @member {string}eff
         * @memberof pb.PlayEffRes
         * @instance
         */
        PlayEffRes.prototype.eff = "";

        /**
         * Creates a new PlayEffRes instance using the specified properties.
         * @function create
         * @memberof pb.PlayEffRes
         * @static
         * @param {pb.IPlayEffRes=} [properties] Properties to set
         * @returns {pb.PlayEffRes} PlayEffRes instance
         */
        PlayEffRes.create = function create(properties) {
            return new PlayEffRes(properties);
        };

        /**
         * Encodes the specified PlayEffRes message. Does not implicitly {@link pb.PlayEffRes.verify|verify} messages.
         * @function encode
         * @memberof pb.PlayEffRes
         * @static
         * @param {pb.IPlayEffRes} message PlayEffRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        PlayEffRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.index != null && message.hasOwnProperty("index"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.index);
            if (message.isMine != null && message.hasOwnProperty("isMine"))
                writer.uint32(/* id 2, wireType 0 =*/16).bool(message.isMine);
            if (message.eff != null && message.hasOwnProperty("eff"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.eff);
            return writer;
        };

        /**
         * Encodes the specified PlayEffRes message, length delimited. Does not implicitly {@link pb.PlayEffRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.PlayEffRes
         * @static
         * @param {pb.IPlayEffRes} message PlayEffRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        PlayEffRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a PlayEffRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.PlayEffRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.PlayEffRes} PlayEffRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        PlayEffRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.PlayEffRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.index = reader.int32();
                    break;
                case 2:
                    message.isMine = reader.bool();
                    break;
                case 3:
                    message.eff = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a PlayEffRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.PlayEffRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.PlayEffRes} PlayEffRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        PlayEffRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a PlayEffRes message.
         * @function verify
         * @memberof pb.PlayEffRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        PlayEffRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.index != null && message.hasOwnProperty("index"))
                if (!$util.isInteger(message.index))
                    return "index: integer expected";
            if (message.isMine != null && message.hasOwnProperty("isMine"))
                if (typeof message.isMine !== "boolean")
                    return "isMine: boolean expected";
            if (message.eff != null && message.hasOwnProperty("eff"))
                if (!$util.isString(message.eff))
                    return "eff: string expected";
            return null;
        };

        /**
         * Creates a PlayEffRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.PlayEffRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.PlayEffRes} PlayEffRes
         */
        PlayEffRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.PlayEffRes)
                return object;
            var message = new $root.pb.PlayEffRes();
            if (object.index != null)
                message.index = object.index | 0;
            if (object.isMine != null)
                message.isMine = Boolean(object.isMine);
            if (object.eff != null)
                message.eff = String(object.eff);
            return message;
        };

        /**
         * Creates a plain object from a PlayEffRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.PlayEffRes
         * @static
         * @param {pb.PlayEffRes} message PlayEffRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        PlayEffRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.index = 0;
                object.isMine = false;
                object.eff = "";
            }
            if (message.index != null && message.hasOwnProperty("index"))
                object.index = message.index;
            if (message.isMine != null && message.hasOwnProperty("isMine"))
                object.isMine = message.isMine;
            if (message.eff != null && message.hasOwnProperty("eff"))
                object.eff = message.eff;
            return object;
        };

        /**
         * Converts this PlayEffRes to JSON.
         * @function toJSON
         * @memberof pb.PlayEffRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        PlayEffRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return PlayEffRes;
    })();

    pb.PlayAniRes = (function() {

        /**
         * Properties of a PlayAniRes.
         * @memberof pb
         * @interface IPlayAniRes
         * @property {number} [index] PlayAniRes index
         * @property {boolean} [isMine] PlayAniRes isMine
         * @property {number} [ani] PlayAniRes ani
         */

        /**
         * Constructs a new PlayAniRes.
         * @memberof pb
         * @classdesc Represents a PlayAniRes.
         * @constructor
         * @param {pb.IPlayAniRes=} [properties] Properties to set
         */
        function PlayAniRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * PlayAniRes index.
         * @member {number}index
         * @memberof pb.PlayAniRes
         * @instance
         */
        PlayAniRes.prototype.index = 0;

        /**
         * PlayAniRes isMine.
         * @member {boolean}isMine
         * @memberof pb.PlayAniRes
         * @instance
         */
        PlayAniRes.prototype.isMine = false;

        /**
         * PlayAniRes ani.
         * @member {number}ani
         * @memberof pb.PlayAniRes
         * @instance
         */
        PlayAniRes.prototype.ani = 0;

        /**
         * Creates a new PlayAniRes instance using the specified properties.
         * @function create
         * @memberof pb.PlayAniRes
         * @static
         * @param {pb.IPlayAniRes=} [properties] Properties to set
         * @returns {pb.PlayAniRes} PlayAniRes instance
         */
        PlayAniRes.create = function create(properties) {
            return new PlayAniRes(properties);
        };

        /**
         * Encodes the specified PlayAniRes message. Does not implicitly {@link pb.PlayAniRes.verify|verify} messages.
         * @function encode
         * @memberof pb.PlayAniRes
         * @static
         * @param {pb.IPlayAniRes} message PlayAniRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        PlayAniRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.index != null && message.hasOwnProperty("index"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.index);
            if (message.isMine != null && message.hasOwnProperty("isMine"))
                writer.uint32(/* id 2, wireType 0 =*/16).bool(message.isMine);
            if (message.ani != null && message.hasOwnProperty("ani"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.ani);
            return writer;
        };

        /**
         * Encodes the specified PlayAniRes message, length delimited. Does not implicitly {@link pb.PlayAniRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.PlayAniRes
         * @static
         * @param {pb.IPlayAniRes} message PlayAniRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        PlayAniRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a PlayAniRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.PlayAniRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.PlayAniRes} PlayAniRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        PlayAniRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.PlayAniRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.index = reader.int32();
                    break;
                case 2:
                    message.isMine = reader.bool();
                    break;
                case 3:
                    message.ani = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a PlayAniRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.PlayAniRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.PlayAniRes} PlayAniRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        PlayAniRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a PlayAniRes message.
         * @function verify
         * @memberof pb.PlayAniRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        PlayAniRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.index != null && message.hasOwnProperty("index"))
                if (!$util.isInteger(message.index))
                    return "index: integer expected";
            if (message.isMine != null && message.hasOwnProperty("isMine"))
                if (typeof message.isMine !== "boolean")
                    return "isMine: boolean expected";
            if (message.ani != null && message.hasOwnProperty("ani"))
                if (!$util.isInteger(message.ani))
                    return "ani: integer expected";
            return null;
        };

        /**
         * Creates a PlayAniRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.PlayAniRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.PlayAniRes} PlayAniRes
         */
        PlayAniRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.PlayAniRes)
                return object;
            var message = new $root.pb.PlayAniRes();
            if (object.index != null)
                message.index = object.index | 0;
            if (object.isMine != null)
                message.isMine = Boolean(object.isMine);
            if (object.ani != null)
                message.ani = object.ani | 0;
            return message;
        };

        /**
         * Creates a plain object from a PlayAniRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.PlayAniRes
         * @static
         * @param {pb.PlayAniRes} message PlayAniRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        PlayAniRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.index = 0;
                object.isMine = false;
                object.ani = 0;
            }
            if (message.index != null && message.hasOwnProperty("index"))
                object.index = message.index;
            if (message.isMine != null && message.hasOwnProperty("isMine"))
                object.isMine = message.isMine;
            if (message.ani != null && message.hasOwnProperty("ani"))
                object.ani = message.ani;
            return object;
        };

        /**
         * Converts this PlayAniRes to JSON.
         * @function toJSON
         * @memberof pb.PlayAniRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        PlayAniRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return PlayAniRes;
    })();

    pb.PlayHudRes = (function() {

        /**
         * Properties of a PlayHudRes.
         * @memberof pb
         * @interface IPlayHudRes
         * @property {number} [index] PlayHudRes index
         * @property {boolean} [isMine] PlayHudRes isMine
         * @property {number} [hud] PlayHudRes hud
         * @property {number} [val] PlayHudRes val
         */

        /**
         * Constructs a new PlayHudRes.
         * @memberof pb
         * @classdesc Represents a PlayHudRes.
         * @constructor
         * @param {pb.IPlayHudRes=} [properties] Properties to set
         */
        function PlayHudRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * PlayHudRes index.
         * @member {number}index
         * @memberof pb.PlayHudRes
         * @instance
         */
        PlayHudRes.prototype.index = 0;

        /**
         * PlayHudRes isMine.
         * @member {boolean}isMine
         * @memberof pb.PlayHudRes
         * @instance
         */
        PlayHudRes.prototype.isMine = false;

        /**
         * PlayHudRes hud.
         * @member {number}hud
         * @memberof pb.PlayHudRes
         * @instance
         */
        PlayHudRes.prototype.hud = 0;

        /**
         * PlayHudRes val.
         * @member {number}val
         * @memberof pb.PlayHudRes
         * @instance
         */
        PlayHudRes.prototype.val = 0;

        /**
         * Creates a new PlayHudRes instance using the specified properties.
         * @function create
         * @memberof pb.PlayHudRes
         * @static
         * @param {pb.IPlayHudRes=} [properties] Properties to set
         * @returns {pb.PlayHudRes} PlayHudRes instance
         */
        PlayHudRes.create = function create(properties) {
            return new PlayHudRes(properties);
        };

        /**
         * Encodes the specified PlayHudRes message. Does not implicitly {@link pb.PlayHudRes.verify|verify} messages.
         * @function encode
         * @memberof pb.PlayHudRes
         * @static
         * @param {pb.IPlayHudRes} message PlayHudRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        PlayHudRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.index != null && message.hasOwnProperty("index"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.index);
            if (message.isMine != null && message.hasOwnProperty("isMine"))
                writer.uint32(/* id 2, wireType 0 =*/16).bool(message.isMine);
            if (message.hud != null && message.hasOwnProperty("hud"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.hud);
            if (message.val != null && message.hasOwnProperty("val"))
                writer.uint32(/* id 4, wireType 0 =*/32).int32(message.val);
            return writer;
        };

        /**
         * Encodes the specified PlayHudRes message, length delimited. Does not implicitly {@link pb.PlayHudRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.PlayHudRes
         * @static
         * @param {pb.IPlayHudRes} message PlayHudRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        PlayHudRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a PlayHudRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.PlayHudRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.PlayHudRes} PlayHudRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        PlayHudRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.PlayHudRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.index = reader.int32();
                    break;
                case 2:
                    message.isMine = reader.bool();
                    break;
                case 3:
                    message.hud = reader.int32();
                    break;
                case 4:
                    message.val = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a PlayHudRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.PlayHudRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.PlayHudRes} PlayHudRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        PlayHudRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a PlayHudRes message.
         * @function verify
         * @memberof pb.PlayHudRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        PlayHudRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.index != null && message.hasOwnProperty("index"))
                if (!$util.isInteger(message.index))
                    return "index: integer expected";
            if (message.isMine != null && message.hasOwnProperty("isMine"))
                if (typeof message.isMine !== "boolean")
                    return "isMine: boolean expected";
            if (message.hud != null && message.hasOwnProperty("hud"))
                if (!$util.isInteger(message.hud))
                    return "hud: integer expected";
            if (message.val != null && message.hasOwnProperty("val"))
                if (!$util.isInteger(message.val))
                    return "val: integer expected";
            return null;
        };

        /**
         * Creates a PlayHudRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.PlayHudRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.PlayHudRes} PlayHudRes
         */
        PlayHudRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.PlayHudRes)
                return object;
            var message = new $root.pb.PlayHudRes();
            if (object.index != null)
                message.index = object.index | 0;
            if (object.isMine != null)
                message.isMine = Boolean(object.isMine);
            if (object.hud != null)
                message.hud = object.hud | 0;
            if (object.val != null)
                message.val = object.val | 0;
            return message;
        };

        /**
         * Creates a plain object from a PlayHudRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.PlayHudRes
         * @static
         * @param {pb.PlayHudRes} message PlayHudRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        PlayHudRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.index = 0;
                object.isMine = false;
                object.hud = 0;
                object.val = 0;
            }
            if (message.index != null && message.hasOwnProperty("index"))
                object.index = message.index;
            if (message.isMine != null && message.hasOwnProperty("isMine"))
                object.isMine = message.isMine;
            if (message.hud != null && message.hasOwnProperty("hud"))
                object.hud = message.hud;
            if (message.val != null && message.hasOwnProperty("val"))
                object.val = message.val;
            return object;
        };

        /**
         * Converts this PlayHudRes to JSON.
         * @function toJSON
         * @memberof pb.PlayHudRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        PlayHudRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return PlayHudRes;
    })();

    pb.PlayBuffRes = (function() {

        /**
         * Properties of a PlayBuffRes.
         * @memberof pb
         * @interface IPlayBuffRes
         * @property {number} [index] PlayBuffRes index
         * @property {boolean} [isMine] PlayBuffRes isMine
         * @property {number} [val] PlayBuffRes val
         * @property {boolean} [isShow] PlayBuffRes isShow
         */

        /**
         * Constructs a new PlayBuffRes.
         * @memberof pb
         * @classdesc Represents a PlayBuffRes.
         * @constructor
         * @param {pb.IPlayBuffRes=} [properties] Properties to set
         */
        function PlayBuffRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * PlayBuffRes index.
         * @member {number}index
         * @memberof pb.PlayBuffRes
         * @instance
         */
        PlayBuffRes.prototype.index = 0;

        /**
         * PlayBuffRes isMine.
         * @member {boolean}isMine
         * @memberof pb.PlayBuffRes
         * @instance
         */
        PlayBuffRes.prototype.isMine = false;

        /**
         * PlayBuffRes val.
         * @member {number}val
         * @memberof pb.PlayBuffRes
         * @instance
         */
        PlayBuffRes.prototype.val = 0;

        /**
         * PlayBuffRes isShow.
         * @member {boolean}isShow
         * @memberof pb.PlayBuffRes
         * @instance
         */
        PlayBuffRes.prototype.isShow = false;

        /**
         * Creates a new PlayBuffRes instance using the specified properties.
         * @function create
         * @memberof pb.PlayBuffRes
         * @static
         * @param {pb.IPlayBuffRes=} [properties] Properties to set
         * @returns {pb.PlayBuffRes} PlayBuffRes instance
         */
        PlayBuffRes.create = function create(properties) {
            return new PlayBuffRes(properties);
        };

        /**
         * Encodes the specified PlayBuffRes message. Does not implicitly {@link pb.PlayBuffRes.verify|verify} messages.
         * @function encode
         * @memberof pb.PlayBuffRes
         * @static
         * @param {pb.IPlayBuffRes} message PlayBuffRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        PlayBuffRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.index != null && message.hasOwnProperty("index"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.index);
            if (message.isMine != null && message.hasOwnProperty("isMine"))
                writer.uint32(/* id 2, wireType 0 =*/16).bool(message.isMine);
            if (message.val != null && message.hasOwnProperty("val"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.val);
            if (message.isShow != null && message.hasOwnProperty("isShow"))
                writer.uint32(/* id 4, wireType 0 =*/32).bool(message.isShow);
            return writer;
        };

        /**
         * Encodes the specified PlayBuffRes message, length delimited. Does not implicitly {@link pb.PlayBuffRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.PlayBuffRes
         * @static
         * @param {pb.IPlayBuffRes} message PlayBuffRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        PlayBuffRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a PlayBuffRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.PlayBuffRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.PlayBuffRes} PlayBuffRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        PlayBuffRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.PlayBuffRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.index = reader.int32();
                    break;
                case 2:
                    message.isMine = reader.bool();
                    break;
                case 3:
                    message.val = reader.int32();
                    break;
                case 4:
                    message.isShow = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a PlayBuffRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.PlayBuffRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.PlayBuffRes} PlayBuffRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        PlayBuffRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a PlayBuffRes message.
         * @function verify
         * @memberof pb.PlayBuffRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        PlayBuffRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.index != null && message.hasOwnProperty("index"))
                if (!$util.isInteger(message.index))
                    return "index: integer expected";
            if (message.isMine != null && message.hasOwnProperty("isMine"))
                if (typeof message.isMine !== "boolean")
                    return "isMine: boolean expected";
            if (message.val != null && message.hasOwnProperty("val"))
                if (!$util.isInteger(message.val))
                    return "val: integer expected";
            if (message.isShow != null && message.hasOwnProperty("isShow"))
                if (typeof message.isShow !== "boolean")
                    return "isShow: boolean expected";
            return null;
        };

        /**
         * Creates a PlayBuffRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.PlayBuffRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.PlayBuffRes} PlayBuffRes
         */
        PlayBuffRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.PlayBuffRes)
                return object;
            var message = new $root.pb.PlayBuffRes();
            if (object.index != null)
                message.index = object.index | 0;
            if (object.isMine != null)
                message.isMine = Boolean(object.isMine);
            if (object.val != null)
                message.val = object.val | 0;
            if (object.isShow != null)
                message.isShow = Boolean(object.isShow);
            return message;
        };

        /**
         * Creates a plain object from a PlayBuffRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.PlayBuffRes
         * @static
         * @param {pb.PlayBuffRes} message PlayBuffRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        PlayBuffRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.index = 0;
                object.isMine = false;
                object.val = 0;
                object.isShow = false;
            }
            if (message.index != null && message.hasOwnProperty("index"))
                object.index = message.index;
            if (message.isMine != null && message.hasOwnProperty("isMine"))
                object.isMine = message.isMine;
            if (message.val != null && message.hasOwnProperty("val"))
                object.val = message.val;
            if (message.isShow != null && message.hasOwnProperty("isShow"))
                object.isShow = message.isShow;
            return object;
        };

        /**
         * Converts this PlayBuffRes to JSON.
         * @function toJSON
         * @memberof pb.PlayBuffRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        PlayBuffRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return PlayBuffRes;
    })();

    pb.DoRenWuRes = (function() {

        /**
         * Properties of a DoRenWuRes.
         * @memberof pb
         * @interface IDoRenWuRes
         * @property {string} [tag] DoRenWuRes tag
         * @property {number} [num] DoRenWuRes num
         * @property {boolean} [id] DoRenWuRes id
         */

        /**
         * Constructs a new DoRenWuRes.
         * @memberof pb
         * @classdesc Represents a DoRenWuRes.
         * @constructor
         * @param {pb.IDoRenWuRes=} [properties] Properties to set
         */
        function DoRenWuRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DoRenWuRes tag.
         * @member {string}tag
         * @memberof pb.DoRenWuRes
         * @instance
         */
        DoRenWuRes.prototype.tag = "";

        /**
         * DoRenWuRes num.
         * @member {number}num
         * @memberof pb.DoRenWuRes
         * @instance
         */
        DoRenWuRes.prototype.num = 0;

        /**
         * DoRenWuRes id.
         * @member {boolean}id
         * @memberof pb.DoRenWuRes
         * @instance
         */
        DoRenWuRes.prototype.id = false;

        /**
         * Creates a new DoRenWuRes instance using the specified properties.
         * @function create
         * @memberof pb.DoRenWuRes
         * @static
         * @param {pb.IDoRenWuRes=} [properties] Properties to set
         * @returns {pb.DoRenWuRes} DoRenWuRes instance
         */
        DoRenWuRes.create = function create(properties) {
            return new DoRenWuRes(properties);
        };

        /**
         * Encodes the specified DoRenWuRes message. Does not implicitly {@link pb.DoRenWuRes.verify|verify} messages.
         * @function encode
         * @memberof pb.DoRenWuRes
         * @static
         * @param {pb.IDoRenWuRes} message DoRenWuRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DoRenWuRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.tag != null && message.hasOwnProperty("tag"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.tag);
            if (message.num != null && message.hasOwnProperty("num"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.num);
            if (message.id != null && message.hasOwnProperty("id"))
                writer.uint32(/* id 3, wireType 0 =*/24).bool(message.id);
            return writer;
        };

        /**
         * Encodes the specified DoRenWuRes message, length delimited. Does not implicitly {@link pb.DoRenWuRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.DoRenWuRes
         * @static
         * @param {pb.IDoRenWuRes} message DoRenWuRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DoRenWuRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DoRenWuRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.DoRenWuRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.DoRenWuRes} DoRenWuRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DoRenWuRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.DoRenWuRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.tag = reader.string();
                    break;
                case 2:
                    message.num = reader.int32();
                    break;
                case 3:
                    message.id = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DoRenWuRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.DoRenWuRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.DoRenWuRes} DoRenWuRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DoRenWuRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DoRenWuRes message.
         * @function verify
         * @memberof pb.DoRenWuRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DoRenWuRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.tag != null && message.hasOwnProperty("tag"))
                if (!$util.isString(message.tag))
                    return "tag: string expected";
            if (message.num != null && message.hasOwnProperty("num"))
                if (!$util.isInteger(message.num))
                    return "num: integer expected";
            if (message.id != null && message.hasOwnProperty("id"))
                if (typeof message.id !== "boolean")
                    return "id: boolean expected";
            return null;
        };

        /**
         * Creates a DoRenWuRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.DoRenWuRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.DoRenWuRes} DoRenWuRes
         */
        DoRenWuRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.DoRenWuRes)
                return object;
            var message = new $root.pb.DoRenWuRes();
            if (object.tag != null)
                message.tag = String(object.tag);
            if (object.num != null)
                message.num = object.num | 0;
            if (object.id != null)
                message.id = Boolean(object.id);
            return message;
        };

        /**
         * Creates a plain object from a DoRenWuRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.DoRenWuRes
         * @static
         * @param {pb.DoRenWuRes} message DoRenWuRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DoRenWuRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.tag = "";
                object.num = 0;
                object.id = false;
            }
            if (message.tag != null && message.hasOwnProperty("tag"))
                object.tag = message.tag;
            if (message.num != null && message.hasOwnProperty("num"))
                object.num = message.num;
            if (message.id != null && message.hasOwnProperty("id"))
                object.id = message.id;
            return object;
        };

        /**
         * Converts this DoRenWuRes to JSON.
         * @function toJSON
         * @memberof pb.DoRenWuRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DoRenWuRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DoRenWuRes;
    })();

    pb.DayLiBaoRes = (function() {

        /**
         * Properties of a DayLiBaoRes.
         * @memberof pb
         * @interface IDayLiBaoRes
         * @property {boolean} [res] DayLiBaoRes res
         */

        /**
         * Constructs a new DayLiBaoRes.
         * @memberof pb
         * @classdesc Represents a DayLiBaoRes.
         * @constructor
         * @param {pb.IDayLiBaoRes=} [properties] Properties to set
         */
        function DayLiBaoRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DayLiBaoRes res.
         * @member {boolean}res
         * @memberof pb.DayLiBaoRes
         * @instance
         */
        DayLiBaoRes.prototype.res = false;

        /**
         * Creates a new DayLiBaoRes instance using the specified properties.
         * @function create
         * @memberof pb.DayLiBaoRes
         * @static
         * @param {pb.IDayLiBaoRes=} [properties] Properties to set
         * @returns {pb.DayLiBaoRes} DayLiBaoRes instance
         */
        DayLiBaoRes.create = function create(properties) {
            return new DayLiBaoRes(properties);
        };

        /**
         * Encodes the specified DayLiBaoRes message. Does not implicitly {@link pb.DayLiBaoRes.verify|verify} messages.
         * @function encode
         * @memberof pb.DayLiBaoRes
         * @static
         * @param {pb.IDayLiBaoRes} message DayLiBaoRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DayLiBaoRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.res != null && message.hasOwnProperty("res"))
                writer.uint32(/* id 3, wireType 0 =*/24).bool(message.res);
            return writer;
        };

        /**
         * Encodes the specified DayLiBaoRes message, length delimited. Does not implicitly {@link pb.DayLiBaoRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.DayLiBaoRes
         * @static
         * @param {pb.IDayLiBaoRes} message DayLiBaoRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DayLiBaoRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DayLiBaoRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.DayLiBaoRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.DayLiBaoRes} DayLiBaoRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DayLiBaoRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.DayLiBaoRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 3:
                    message.res = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DayLiBaoRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.DayLiBaoRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.DayLiBaoRes} DayLiBaoRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DayLiBaoRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DayLiBaoRes message.
         * @function verify
         * @memberof pb.DayLiBaoRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DayLiBaoRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.res != null && message.hasOwnProperty("res"))
                if (typeof message.res !== "boolean")
                    return "res: boolean expected";
            return null;
        };

        /**
         * Creates a DayLiBaoRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.DayLiBaoRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.DayLiBaoRes} DayLiBaoRes
         */
        DayLiBaoRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.DayLiBaoRes)
                return object;
            var message = new $root.pb.DayLiBaoRes();
            if (object.res != null)
                message.res = Boolean(object.res);
            return message;
        };

        /**
         * Creates a plain object from a DayLiBaoRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.DayLiBaoRes
         * @static
         * @param {pb.DayLiBaoRes} message DayLiBaoRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DayLiBaoRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.res = false;
            if (message.res != null && message.hasOwnProperty("res"))
                object.res = message.res;
            return object;
        };

        /**
         * Converts this DayLiBaoRes to JSON.
         * @function toJSON
         * @memberof pb.DayLiBaoRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DayLiBaoRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DayLiBaoRes;
    })();

    pb.XinShouAsk = (function() {

        /**
         * Properties of a XinShouAsk.
         * @memberof pb
         * @interface IXinShouAsk
         */

        /**
         * Constructs a new XinShouAsk.
         * @memberof pb
         * @classdesc Represents a XinShouAsk.
         * @constructor
         * @param {pb.IXinShouAsk=} [properties] Properties to set
         */
        function XinShouAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new XinShouAsk instance using the specified properties.
         * @function create
         * @memberof pb.XinShouAsk
         * @static
         * @param {pb.IXinShouAsk=} [properties] Properties to set
         * @returns {pb.XinShouAsk} XinShouAsk instance
         */
        XinShouAsk.create = function create(properties) {
            return new XinShouAsk(properties);
        };

        /**
         * Encodes the specified XinShouAsk message. Does not implicitly {@link pb.XinShouAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.XinShouAsk
         * @static
         * @param {pb.IXinShouAsk} message XinShouAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        XinShouAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified XinShouAsk message, length delimited. Does not implicitly {@link pb.XinShouAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.XinShouAsk
         * @static
         * @param {pb.IXinShouAsk} message XinShouAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        XinShouAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a XinShouAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.XinShouAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.XinShouAsk} XinShouAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        XinShouAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.XinShouAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a XinShouAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.XinShouAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.XinShouAsk} XinShouAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        XinShouAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a XinShouAsk message.
         * @function verify
         * @memberof pb.XinShouAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        XinShouAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a XinShouAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.XinShouAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.XinShouAsk} XinShouAsk
         */
        XinShouAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.XinShouAsk)
                return object;
            return new $root.pb.XinShouAsk();
        };

        /**
         * Creates a plain object from a XinShouAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.XinShouAsk
         * @static
         * @param {pb.XinShouAsk} message XinShouAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        XinShouAsk.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this XinShouAsk to JSON.
         * @function toJSON
         * @memberof pb.XinShouAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        XinShouAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return XinShouAsk;
    })();

    pb.XinShouRes = (function() {

        /**
         * Properties of a XinShouRes.
         * @memberof pb
         * @interface IXinShouRes
         */

        /**
         * Constructs a new XinShouRes.
         * @memberof pb
         * @classdesc Represents a XinShouRes.
         * @constructor
         * @param {pb.IXinShouRes=} [properties] Properties to set
         */
        function XinShouRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new XinShouRes instance using the specified properties.
         * @function create
         * @memberof pb.XinShouRes
         * @static
         * @param {pb.IXinShouRes=} [properties] Properties to set
         * @returns {pb.XinShouRes} XinShouRes instance
         */
        XinShouRes.create = function create(properties) {
            return new XinShouRes(properties);
        };

        /**
         * Encodes the specified XinShouRes message. Does not implicitly {@link pb.XinShouRes.verify|verify} messages.
         * @function encode
         * @memberof pb.XinShouRes
         * @static
         * @param {pb.IXinShouRes} message XinShouRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        XinShouRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified XinShouRes message, length delimited. Does not implicitly {@link pb.XinShouRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.XinShouRes
         * @static
         * @param {pb.IXinShouRes} message XinShouRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        XinShouRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a XinShouRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.XinShouRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.XinShouRes} XinShouRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        XinShouRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.XinShouRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a XinShouRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.XinShouRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.XinShouRes} XinShouRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        XinShouRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a XinShouRes message.
         * @function verify
         * @memberof pb.XinShouRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        XinShouRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a XinShouRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.XinShouRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.XinShouRes} XinShouRes
         */
        XinShouRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.XinShouRes)
                return object;
            return new $root.pb.XinShouRes();
        };

        /**
         * Creates a plain object from a XinShouRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.XinShouRes
         * @static
         * @param {pb.XinShouRes} message XinShouRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        XinShouRes.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this XinShouRes to JSON.
         * @function toJSON
         * @memberof pb.XinShouRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        XinShouRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return XinShouRes;
    })();

    pb.HongBaoOutRes = (function() {

        /**
         * Properties of an HongBaoOutRes.
         * @memberof pb
         * @interface IHongBaoOutRes
         * @property {number} [index] HongBaoOutRes index
         */

        /**
         * Constructs a new HongBaoOutRes.
         * @memberof pb
         * @classdesc Represents an HongBaoOutRes.
         * @constructor
         * @param {pb.IHongBaoOutRes=} [properties] Properties to set
         */
        function HongBaoOutRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * HongBaoOutRes index.
         * @member {number}index
         * @memberof pb.HongBaoOutRes
         * @instance
         */
        HongBaoOutRes.prototype.index = 0;

        /**
         * Creates a new HongBaoOutRes instance using the specified properties.
         * @function create
         * @memberof pb.HongBaoOutRes
         * @static
         * @param {pb.IHongBaoOutRes=} [properties] Properties to set
         * @returns {pb.HongBaoOutRes} HongBaoOutRes instance
         */
        HongBaoOutRes.create = function create(properties) {
            return new HongBaoOutRes(properties);
        };

        /**
         * Encodes the specified HongBaoOutRes message. Does not implicitly {@link pb.HongBaoOutRes.verify|verify} messages.
         * @function encode
         * @memberof pb.HongBaoOutRes
         * @static
         * @param {pb.IHongBaoOutRes} message HongBaoOutRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HongBaoOutRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.index != null && message.hasOwnProperty("index"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.index);
            return writer;
        };

        /**
         * Encodes the specified HongBaoOutRes message, length delimited. Does not implicitly {@link pb.HongBaoOutRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.HongBaoOutRes
         * @static
         * @param {pb.IHongBaoOutRes} message HongBaoOutRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HongBaoOutRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an HongBaoOutRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.HongBaoOutRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.HongBaoOutRes} HongBaoOutRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HongBaoOutRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.HongBaoOutRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.index = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an HongBaoOutRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.HongBaoOutRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.HongBaoOutRes} HongBaoOutRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HongBaoOutRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an HongBaoOutRes message.
         * @function verify
         * @memberof pb.HongBaoOutRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        HongBaoOutRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.index != null && message.hasOwnProperty("index"))
                if (!$util.isInteger(message.index))
                    return "index: integer expected";
            return null;
        };

        /**
         * Creates an HongBaoOutRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.HongBaoOutRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.HongBaoOutRes} HongBaoOutRes
         */
        HongBaoOutRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.HongBaoOutRes)
                return object;
            var message = new $root.pb.HongBaoOutRes();
            if (object.index != null)
                message.index = object.index | 0;
            return message;
        };

        /**
         * Creates a plain object from an HongBaoOutRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.HongBaoOutRes
         * @static
         * @param {pb.HongBaoOutRes} message HongBaoOutRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        HongBaoOutRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.index = 0;
            if (message.index != null && message.hasOwnProperty("index"))
                object.index = message.index;
            return object;
        };

        /**
         * Converts this HongBaoOutRes to JSON.
         * @function toJSON
         * @memberof pb.HongBaoOutRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        HongBaoOutRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return HongBaoOutRes;
    })();

    pb.HongBaoAsk = (function() {

        /**
         * Properties of an HongBaoAsk.
         * @memberof pb
         * @interface IHongBaoAsk
         * @property {number} [index] HongBaoAsk index
         */

        /**
         * Constructs a new HongBaoAsk.
         * @memberof pb
         * @classdesc Represents an HongBaoAsk.
         * @constructor
         * @param {pb.IHongBaoAsk=} [properties] Properties to set
         */
        function HongBaoAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * HongBaoAsk index.
         * @member {number}index
         * @memberof pb.HongBaoAsk
         * @instance
         */
        HongBaoAsk.prototype.index = 0;

        /**
         * Creates a new HongBaoAsk instance using the specified properties.
         * @function create
         * @memberof pb.HongBaoAsk
         * @static
         * @param {pb.IHongBaoAsk=} [properties] Properties to set
         * @returns {pb.HongBaoAsk} HongBaoAsk instance
         */
        HongBaoAsk.create = function create(properties) {
            return new HongBaoAsk(properties);
        };

        /**
         * Encodes the specified HongBaoAsk message. Does not implicitly {@link pb.HongBaoAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.HongBaoAsk
         * @static
         * @param {pb.IHongBaoAsk} message HongBaoAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HongBaoAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.index != null && message.hasOwnProperty("index"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.index);
            return writer;
        };

        /**
         * Encodes the specified HongBaoAsk message, length delimited. Does not implicitly {@link pb.HongBaoAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.HongBaoAsk
         * @static
         * @param {pb.IHongBaoAsk} message HongBaoAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HongBaoAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an HongBaoAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.HongBaoAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.HongBaoAsk} HongBaoAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HongBaoAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.HongBaoAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.index = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an HongBaoAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.HongBaoAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.HongBaoAsk} HongBaoAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HongBaoAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an HongBaoAsk message.
         * @function verify
         * @memberof pb.HongBaoAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        HongBaoAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.index != null && message.hasOwnProperty("index"))
                if (!$util.isInteger(message.index))
                    return "index: integer expected";
            return null;
        };

        /**
         * Creates an HongBaoAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.HongBaoAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.HongBaoAsk} HongBaoAsk
         */
        HongBaoAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.HongBaoAsk)
                return object;
            var message = new $root.pb.HongBaoAsk();
            if (object.index != null)
                message.index = object.index | 0;
            return message;
        };

        /**
         * Creates a plain object from an HongBaoAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.HongBaoAsk
         * @static
         * @param {pb.HongBaoAsk} message HongBaoAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        HongBaoAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.index = 0;
            if (message.index != null && message.hasOwnProperty("index"))
                object.index = message.index;
            return object;
        };

        /**
         * Converts this HongBaoAsk to JSON.
         * @function toJSON
         * @memberof pb.HongBaoAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        HongBaoAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return HongBaoAsk;
    })();

    pb.HongBaoRes = (function() {

        /**
         * Properties of an HongBaoRes.
         * @memberof pb
         * @interface IHongBaoRes
         * @property {number} [res] HongBaoRes res
         */

        /**
         * Constructs a new HongBaoRes.
         * @memberof pb
         * @classdesc Represents an HongBaoRes.
         * @constructor
         * @param {pb.IHongBaoRes=} [properties] Properties to set
         */
        function HongBaoRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * HongBaoRes res.
         * @member {number}res
         * @memberof pb.HongBaoRes
         * @instance
         */
        HongBaoRes.prototype.res = 0;

        /**
         * Creates a new HongBaoRes instance using the specified properties.
         * @function create
         * @memberof pb.HongBaoRes
         * @static
         * @param {pb.IHongBaoRes=} [properties] Properties to set
         * @returns {pb.HongBaoRes} HongBaoRes instance
         */
        HongBaoRes.create = function create(properties) {
            return new HongBaoRes(properties);
        };

        /**
         * Encodes the specified HongBaoRes message. Does not implicitly {@link pb.HongBaoRes.verify|verify} messages.
         * @function encode
         * @memberof pb.HongBaoRes
         * @static
         * @param {pb.IHongBaoRes} message HongBaoRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HongBaoRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.res != null && message.hasOwnProperty("res"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.res);
            return writer;
        };

        /**
         * Encodes the specified HongBaoRes message, length delimited. Does not implicitly {@link pb.HongBaoRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.HongBaoRes
         * @static
         * @param {pb.IHongBaoRes} message HongBaoRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HongBaoRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an HongBaoRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.HongBaoRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.HongBaoRes} HongBaoRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HongBaoRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.HongBaoRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.res = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an HongBaoRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.HongBaoRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.HongBaoRes} HongBaoRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HongBaoRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an HongBaoRes message.
         * @function verify
         * @memberof pb.HongBaoRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        HongBaoRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.res != null && message.hasOwnProperty("res"))
                if (!$util.isInteger(message.res))
                    return "res: integer expected";
            return null;
        };

        /**
         * Creates an HongBaoRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.HongBaoRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.HongBaoRes} HongBaoRes
         */
        HongBaoRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.HongBaoRes)
                return object;
            var message = new $root.pb.HongBaoRes();
            if (object.res != null)
                message.res = object.res | 0;
            return message;
        };

        /**
         * Creates a plain object from an HongBaoRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.HongBaoRes
         * @static
         * @param {pb.HongBaoRes} message HongBaoRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        HongBaoRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.res = 0;
            if (message.res != null && message.hasOwnProperty("res"))
                object.res = message.res;
            return object;
        };

        /**
         * Converts this HongBaoRes to JSON.
         * @function toJSON
         * @memberof pb.HongBaoRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        HongBaoRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return HongBaoRes;
    })();

    pb.OpenMenuRes = (function() {

        /**
         * Properties of an OpenMenuRes.
         * @memberof pb
         * @interface IOpenMenuRes
         * @property {string} [menu] OpenMenuRes menu
         */

        /**
         * Constructs a new OpenMenuRes.
         * @memberof pb
         * @classdesc Represents an OpenMenuRes.
         * @constructor
         * @param {pb.IOpenMenuRes=} [properties] Properties to set
         */
        function OpenMenuRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * OpenMenuRes menu.
         * @member {string}menu
         * @memberof pb.OpenMenuRes
         * @instance
         */
        OpenMenuRes.prototype.menu = "";

        /**
         * Creates a new OpenMenuRes instance using the specified properties.
         * @function create
         * @memberof pb.OpenMenuRes
         * @static
         * @param {pb.IOpenMenuRes=} [properties] Properties to set
         * @returns {pb.OpenMenuRes} OpenMenuRes instance
         */
        OpenMenuRes.create = function create(properties) {
            return new OpenMenuRes(properties);
        };

        /**
         * Encodes the specified OpenMenuRes message. Does not implicitly {@link pb.OpenMenuRes.verify|verify} messages.
         * @function encode
         * @memberof pb.OpenMenuRes
         * @static
         * @param {pb.IOpenMenuRes} message OpenMenuRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        OpenMenuRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.menu != null && message.hasOwnProperty("menu"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.menu);
            return writer;
        };

        /**
         * Encodes the specified OpenMenuRes message, length delimited. Does not implicitly {@link pb.OpenMenuRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.OpenMenuRes
         * @static
         * @param {pb.IOpenMenuRes} message OpenMenuRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        OpenMenuRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an OpenMenuRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.OpenMenuRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.OpenMenuRes} OpenMenuRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        OpenMenuRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.OpenMenuRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.menu = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an OpenMenuRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.OpenMenuRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.OpenMenuRes} OpenMenuRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        OpenMenuRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an OpenMenuRes message.
         * @function verify
         * @memberof pb.OpenMenuRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        OpenMenuRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.menu != null && message.hasOwnProperty("menu"))
                if (!$util.isString(message.menu))
                    return "menu: string expected";
            return null;
        };

        /**
         * Creates an OpenMenuRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.OpenMenuRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.OpenMenuRes} OpenMenuRes
         */
        OpenMenuRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.OpenMenuRes)
                return object;
            var message = new $root.pb.OpenMenuRes();
            if (object.menu != null)
                message.menu = String(object.menu);
            return message;
        };

        /**
         * Creates a plain object from an OpenMenuRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.OpenMenuRes
         * @static
         * @param {pb.OpenMenuRes} message OpenMenuRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        OpenMenuRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.menu = "";
            if (message.menu != null && message.hasOwnProperty("menu"))
                object.menu = message.menu;
            return object;
        };

        /**
         * Converts this OpenMenuRes to JSON.
         * @function toJSON
         * @memberof pb.OpenMenuRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        OpenMenuRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return OpenMenuRes;
    })();

    /**
     * Sync enum.
     * @enum {string}
     * @property {number} Add=0 Add value
     * @property {number} Set=1 Set value
     * @property {number} Del=2 Del value
     * @property {number} Swp=3 Swp value
     * @property {number} Sort=4 Sort value
     */
    pb.Sync = (function() {
        var valuesById = {}, values = Object.create(valuesById);
        values[valuesById[0] = "Add"] = 0;
        values[valuesById[1] = "Set"] = 1;
        values[valuesById[2] = "Del"] = 2;
        values[valuesById[3] = "Swp"] = 3;
        values[valuesById[4] = "Sort"] = 4;
        return values;
    })();

    pb.Property = (function() {

        /**
         * Properties of a Property.
         * @memberof pb
         * @interface IProperty
         * @property {number} [vType] Property vType
         * @property {number} [valInt] Property valInt
         * @property {number|Long} [valUint64] Property valUint64
         * @property {boolean} [valBool] Property valBool
         * @property {number} [valFloat] Property valFloat
         * @property {string} [valString] Property valString
         * @property {Array.<pb.IProperty>} [lst] Property lst
         * @property {Object.<string,pb.IProperty>} [map] Property map
         */

        /**
         * Constructs a new Property.
         * @memberof pb
         * @classdesc Represents a Property.
         * @constructor
         * @param {pb.IProperty=} [properties] Properties to set
         */
        function Property(properties) {
            this.lst = [];
            this.map = {};
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Property vType.
         * @member {number}vType
         * @memberof pb.Property
         * @instance
         */
        Property.prototype.vType = 0;

        /**
         * Property valInt.
         * @member {number}valInt
         * @memberof pb.Property
         * @instance
         */
        Property.prototype.valInt = 0;

        /**
         * Property valUint64.
         * @member {number|Long}valUint64
         * @memberof pb.Property
         * @instance
         */
        Property.prototype.valUint64 = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Property valBool.
         * @member {boolean}valBool
         * @memberof pb.Property
         * @instance
         */
        Property.prototype.valBool = false;

        /**
         * Property valFloat.
         * @member {number}valFloat
         * @memberof pb.Property
         * @instance
         */
        Property.prototype.valFloat = 0;

        /**
         * Property valString.
         * @member {string}valString
         * @memberof pb.Property
         * @instance
         */
        Property.prototype.valString = "";

        /**
         * Property lst.
         * @member {Array.<pb.IProperty>}lst
         * @memberof pb.Property
         * @instance
         */
        Property.prototype.lst = $util.emptyArray;

        /**
         * Property map.
         * @member {Object.<string,pb.IProperty>}map
         * @memberof pb.Property
         * @instance
         */
        Property.prototype.map = $util.emptyObject;

        /**
         * Creates a new Property instance using the specified properties.
         * @function create
         * @memberof pb.Property
         * @static
         * @param {pb.IProperty=} [properties] Properties to set
         * @returns {pb.Property} Property instance
         */
        Property.create = function create(properties) {
            return new Property(properties);
        };

        /**
         * Encodes the specified Property message. Does not implicitly {@link pb.Property.verify|verify} messages.
         * @function encode
         * @memberof pb.Property
         * @static
         * @param {pb.IProperty} message Property message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Property.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.vType != null && message.hasOwnProperty("vType"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.vType);
            if (message.valInt != null && message.hasOwnProperty("valInt"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.valInt);
            if (message.valUint64 != null && message.hasOwnProperty("valUint64"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint64(message.valUint64);
            if (message.valBool != null && message.hasOwnProperty("valBool"))
                writer.uint32(/* id 4, wireType 0 =*/32).bool(message.valBool);
            if (message.valFloat != null && message.hasOwnProperty("valFloat"))
                writer.uint32(/* id 5, wireType 5 =*/45).float(message.valFloat);
            if (message.valString != null && message.hasOwnProperty("valString"))
                writer.uint32(/* id 6, wireType 2 =*/50).string(message.valString);
            if (message.lst != null && message.lst.length)
                for (var i = 0; i < message.lst.length; ++i)
                    $root.pb.Property.encode(message.lst[i], writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
            if (message.map != null && message.hasOwnProperty("map"))
                for (var keys = Object.keys(message.map), i = 0; i < keys.length; ++i) {
                    writer.uint32(/* id 8, wireType 2 =*/66).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]);
                    $root.pb.Property.encode(message.map[keys[i]], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim().ldelim();
                }
            return writer;
        };

        /**
         * Encodes the specified Property message, length delimited. Does not implicitly {@link pb.Property.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.Property
         * @static
         * @param {pb.IProperty} message Property message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Property.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Property message from the specified reader or buffer.
         * @function decode
         * @memberof pb.Property
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.Property} Property
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Property.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.Property(), key;
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.vType = reader.int32();
                    break;
                case 2:
                    message.valInt = reader.int32();
                    break;
                case 3:
                    message.valUint64 = reader.uint64();
                    break;
                case 4:
                    message.valBool = reader.bool();
                    break;
                case 5:
                    message.valFloat = reader.float();
                    break;
                case 6:
                    message.valString = reader.string();
                    break;
                case 7:
                    if (!(message.lst && message.lst.length))
                        message.lst = [];
                    message.lst.push($root.pb.Property.decode(reader, reader.uint32()));
                    break;
                case 8:
                    reader.skip().pos++;
                    if (message.map === $util.emptyObject)
                        message.map = {};
                    key = reader.string();
                    reader.pos++;
                    message.map[key] = $root.pb.Property.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a Property message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.Property
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.Property} Property
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Property.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Property message.
         * @function verify
         * @memberof pb.Property
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Property.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.vType != null && message.hasOwnProperty("vType"))
                if (!$util.isInteger(message.vType))
                    return "vType: integer expected";
            if (message.valInt != null && message.hasOwnProperty("valInt"))
                if (!$util.isInteger(message.valInt))
                    return "valInt: integer expected";
            if (message.valUint64 != null && message.hasOwnProperty("valUint64"))
                if (!$util.isInteger(message.valUint64) && !(message.valUint64 && $util.isInteger(message.valUint64.low) && $util.isInteger(message.valUint64.high)))
                    return "valUint64: integer|Long expected";
            if (message.valBool != null && message.hasOwnProperty("valBool"))
                if (typeof message.valBool !== "boolean")
                    return "valBool: boolean expected";
            if (message.valFloat != null && message.hasOwnProperty("valFloat"))
                if (typeof message.valFloat !== "number")
                    return "valFloat: number expected";
            if (message.valString != null && message.hasOwnProperty("valString"))
                if (!$util.isString(message.valString))
                    return "valString: string expected";
            if (message.lst != null && message.hasOwnProperty("lst")) {
                if (!Array.isArray(message.lst))
                    return "lst: array expected";
                for (var i = 0; i < message.lst.length; ++i) {
                    var error = $root.pb.Property.verify(message.lst[i]);
                    if (error)
                        return "lst." + error;
                }
            }
            if (message.map != null && message.hasOwnProperty("map")) {
                if (!$util.isObject(message.map))
                    return "map: object expected";
                var key = Object.keys(message.map);
                for (var i = 0; i < key.length; ++i) {
                    error = $root.pb.Property.verify(message.map[key[i]]);
                    if (error)
                        return "map." + error;
                }
            }
            return null;
        };

        /**
         * Creates a Property message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.Property
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.Property} Property
         */
        Property.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.Property)
                return object;
            var message = new $root.pb.Property();
            if (object.vType != null)
                message.vType = object.vType | 0;
            if (object.valInt != null)
                message.valInt = object.valInt | 0;
            if (object.valUint64 != null)
                if ($util.Long)
                    (message.valUint64 = $util.Long.fromValue(object.valUint64)).unsigned = true;
                else if (typeof object.valUint64 === "string")
                    message.valUint64 = parseInt(object.valUint64, 10);
                else if (typeof object.valUint64 === "number")
                    message.valUint64 = object.valUint64;
                else if (typeof object.valUint64 === "object")
                    message.valUint64 = new $util.LongBits(object.valUint64.low >>> 0, object.valUint64.high >>> 0).toNumber(true);
            if (object.valBool != null)
                message.valBool = Boolean(object.valBool);
            if (object.valFloat != null)
                message.valFloat = Number(object.valFloat);
            if (object.valString != null)
                message.valString = String(object.valString);
            if (object.lst) {
                if (!Array.isArray(object.lst))
                    throw TypeError(".pb.Property.lst: array expected");
                message.lst = [];
                for (var i = 0; i < object.lst.length; ++i) {
                    if (typeof object.lst[i] !== "object")
                        throw TypeError(".pb.Property.lst: object expected");
                    message.lst[i] = $root.pb.Property.fromObject(object.lst[i]);
                }
            }
            if (object.map) {
                if (typeof object.map !== "object")
                    throw TypeError(".pb.Property.map: object expected");
                message.map = {};
                for (var keys = Object.keys(object.map), i = 0; i < keys.length; ++i) {
                    if (typeof object.map[keys[i]] !== "object")
                        throw TypeError(".pb.Property.map: object expected");
                    message.map[keys[i]] = $root.pb.Property.fromObject(object.map[keys[i]]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a Property message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.Property
         * @static
         * @param {pb.Property} message Property
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Property.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.lst = [];
            if (options.objects || options.defaults)
                object.map = {};
            if (options.defaults) {
                object.vType = 0;
                object.valInt = 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.valUint64 = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.valUint64 = options.longs === String ? "0" : 0;
                object.valBool = false;
                object.valFloat = 0;
                object.valString = "";
            }
            if (message.vType != null && message.hasOwnProperty("vType"))
                object.vType = message.vType;
            if (message.valInt != null && message.hasOwnProperty("valInt"))
                object.valInt = message.valInt;
            if (message.valUint64 != null && message.hasOwnProperty("valUint64"))
                if (typeof message.valUint64 === "number")
                    object.valUint64 = options.longs === String ? String(message.valUint64) : message.valUint64;
                else
                    object.valUint64 = options.longs === String ? $util.Long.prototype.toString.call(message.valUint64) : options.longs === Number ? new $util.LongBits(message.valUint64.low >>> 0, message.valUint64.high >>> 0).toNumber(true) : message.valUint64;
            if (message.valBool != null && message.hasOwnProperty("valBool"))
                object.valBool = message.valBool;
            if (message.valFloat != null && message.hasOwnProperty("valFloat"))
                object.valFloat = options.json && !isFinite(message.valFloat) ? String(message.valFloat) : message.valFloat;
            if (message.valString != null && message.hasOwnProperty("valString"))
                object.valString = message.valString;
            if (message.lst && message.lst.length) {
                object.lst = [];
                for (var j = 0; j < message.lst.length; ++j)
                    object.lst[j] = $root.pb.Property.toObject(message.lst[j], options);
            }
            var keys2;
            if (message.map && (keys2 = Object.keys(message.map)).length) {
                object.map = {};
                for (var j = 0; j < keys2.length; ++j)
                    object.map[keys2[j]] = $root.pb.Property.toObject(message.map[keys2[j]], options);
            }
            return object;
        };

        /**
         * Converts this Property to JSON.
         * @function toJSON
         * @memberof pb.Property
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Property.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Property;
    })();

    pb.PropertyDown = (function() {

        /**
         * Properties of a PropertyDown.
         * @memberof pb
         * @interface IPropertyDown
         * @property {Array.<string>} [key] PropertyDown key
         * @property {pb.IProperty} [pro] PropertyDown pro
         */

        /**
         * Constructs a new PropertyDown.
         * @memberof pb
         * @classdesc Represents a PropertyDown.
         * @constructor
         * @param {pb.IPropertyDown=} [properties] Properties to set
         */
        function PropertyDown(properties) {
            this.key = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * PropertyDown key.
         * @member {Array.<string>}key
         * @memberof pb.PropertyDown
         * @instance
         */
        PropertyDown.prototype.key = $util.emptyArray;

        /**
         * PropertyDown pro.
         * @member {(pb.IProperty|null|undefined)}pro
         * @memberof pb.PropertyDown
         * @instance
         */
        PropertyDown.prototype.pro = null;

        /**
         * Creates a new PropertyDown instance using the specified properties.
         * @function create
         * @memberof pb.PropertyDown
         * @static
         * @param {pb.IPropertyDown=} [properties] Properties to set
         * @returns {pb.PropertyDown} PropertyDown instance
         */
        PropertyDown.create = function create(properties) {
            return new PropertyDown(properties);
        };

        /**
         * Encodes the specified PropertyDown message. Does not implicitly {@link pb.PropertyDown.verify|verify} messages.
         * @function encode
         * @memberof pb.PropertyDown
         * @static
         * @param {pb.IPropertyDown} message PropertyDown message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        PropertyDown.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.key != null && message.key.length)
                for (var i = 0; i < message.key.length; ++i)
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.key[i]);
            if (message.pro != null && message.hasOwnProperty("pro"))
                $root.pb.Property.encode(message.pro, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified PropertyDown message, length delimited. Does not implicitly {@link pb.PropertyDown.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.PropertyDown
         * @static
         * @param {pb.IPropertyDown} message PropertyDown message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        PropertyDown.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a PropertyDown message from the specified reader or buffer.
         * @function decode
         * @memberof pb.PropertyDown
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.PropertyDown} PropertyDown
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        PropertyDown.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.PropertyDown();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.key && message.key.length))
                        message.key = [];
                    message.key.push(reader.string());
                    break;
                case 2:
                    message.pro = $root.pb.Property.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a PropertyDown message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.PropertyDown
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.PropertyDown} PropertyDown
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        PropertyDown.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a PropertyDown message.
         * @function verify
         * @memberof pb.PropertyDown
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        PropertyDown.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.key != null && message.hasOwnProperty("key")) {
                if (!Array.isArray(message.key))
                    return "key: array expected";
                for (var i = 0; i < message.key.length; ++i)
                    if (!$util.isString(message.key[i]))
                        return "key: string[] expected";
            }
            if (message.pro != null && message.hasOwnProperty("pro")) {
                var error = $root.pb.Property.verify(message.pro);
                if (error)
                    return "pro." + error;
            }
            return null;
        };

        /**
         * Creates a PropertyDown message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.PropertyDown
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.PropertyDown} PropertyDown
         */
        PropertyDown.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.PropertyDown)
                return object;
            var message = new $root.pb.PropertyDown();
            if (object.key) {
                if (!Array.isArray(object.key))
                    throw TypeError(".pb.PropertyDown.key: array expected");
                message.key = [];
                for (var i = 0; i < object.key.length; ++i)
                    message.key[i] = String(object.key[i]);
            }
            if (object.pro != null) {
                if (typeof object.pro !== "object")
                    throw TypeError(".pb.PropertyDown.pro: object expected");
                message.pro = $root.pb.Property.fromObject(object.pro);
            }
            return message;
        };

        /**
         * Creates a plain object from a PropertyDown message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.PropertyDown
         * @static
         * @param {pb.PropertyDown} message PropertyDown
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        PropertyDown.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.key = [];
            if (options.defaults)
                object.pro = null;
            if (message.key && message.key.length) {
                object.key = [];
                for (var j = 0; j < message.key.length; ++j)
                    object.key[j] = message.key[j];
            }
            if (message.pro != null && message.hasOwnProperty("pro"))
                object.pro = $root.pb.Property.toObject(message.pro, options);
            return object;
        };

        /**
         * Converts this PropertyDown to JSON.
         * @function toJSON
         * @memberof pb.PropertyDown
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        PropertyDown.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return PropertyDown;
    })();

    pb.AddLastPro = (function() {

        /**
         * Properties of an AddLastPro.
         * @memberof pb
         * @interface IAddLastPro
         * @property {Array.<string>} [key] AddLastPro key
         * @property {pb.IProperty} [pro] AddLastPro pro
         */

        /**
         * Constructs a new AddLastPro.
         * @memberof pb
         * @classdesc Represents an AddLastPro.
         * @constructor
         * @param {pb.IAddLastPro=} [properties] Properties to set
         */
        function AddLastPro(properties) {
            this.key = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AddLastPro key.
         * @member {Array.<string>}key
         * @memberof pb.AddLastPro
         * @instance
         */
        AddLastPro.prototype.key = $util.emptyArray;

        /**
         * AddLastPro pro.
         * @member {(pb.IProperty|null|undefined)}pro
         * @memberof pb.AddLastPro
         * @instance
         */
        AddLastPro.prototype.pro = null;

        /**
         * Creates a new AddLastPro instance using the specified properties.
         * @function create
         * @memberof pb.AddLastPro
         * @static
         * @param {pb.IAddLastPro=} [properties] Properties to set
         * @returns {pb.AddLastPro} AddLastPro instance
         */
        AddLastPro.create = function create(properties) {
            return new AddLastPro(properties);
        };

        /**
         * Encodes the specified AddLastPro message. Does not implicitly {@link pb.AddLastPro.verify|verify} messages.
         * @function encode
         * @memberof pb.AddLastPro
         * @static
         * @param {pb.IAddLastPro} message AddLastPro message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AddLastPro.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.key != null && message.key.length)
                for (var i = 0; i < message.key.length; ++i)
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.key[i]);
            if (message.pro != null && message.hasOwnProperty("pro"))
                $root.pb.Property.encode(message.pro, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified AddLastPro message, length delimited. Does not implicitly {@link pb.AddLastPro.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.AddLastPro
         * @static
         * @param {pb.IAddLastPro} message AddLastPro message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AddLastPro.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AddLastPro message from the specified reader or buffer.
         * @function decode
         * @memberof pb.AddLastPro
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.AddLastPro} AddLastPro
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AddLastPro.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.AddLastPro();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.key && message.key.length))
                        message.key = [];
                    message.key.push(reader.string());
                    break;
                case 2:
                    message.pro = $root.pb.Property.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AddLastPro message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.AddLastPro
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.AddLastPro} AddLastPro
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AddLastPro.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AddLastPro message.
         * @function verify
         * @memberof pb.AddLastPro
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AddLastPro.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.key != null && message.hasOwnProperty("key")) {
                if (!Array.isArray(message.key))
                    return "key: array expected";
                for (var i = 0; i < message.key.length; ++i)
                    if (!$util.isString(message.key[i]))
                        return "key: string[] expected";
            }
            if (message.pro != null && message.hasOwnProperty("pro")) {
                var error = $root.pb.Property.verify(message.pro);
                if (error)
                    return "pro." + error;
            }
            return null;
        };

        /**
         * Creates an AddLastPro message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.AddLastPro
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.AddLastPro} AddLastPro
         */
        AddLastPro.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.AddLastPro)
                return object;
            var message = new $root.pb.AddLastPro();
            if (object.key) {
                if (!Array.isArray(object.key))
                    throw TypeError(".pb.AddLastPro.key: array expected");
                message.key = [];
                for (var i = 0; i < object.key.length; ++i)
                    message.key[i] = String(object.key[i]);
            }
            if (object.pro != null) {
                if (typeof object.pro !== "object")
                    throw TypeError(".pb.AddLastPro.pro: object expected");
                message.pro = $root.pb.Property.fromObject(object.pro);
            }
            return message;
        };

        /**
         * Creates a plain object from an AddLastPro message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.AddLastPro
         * @static
         * @param {pb.AddLastPro} message AddLastPro
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AddLastPro.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.key = [];
            if (options.defaults)
                object.pro = null;
            if (message.key && message.key.length) {
                object.key = [];
                for (var j = 0; j < message.key.length; ++j)
                    object.key[j] = message.key[j];
            }
            if (message.pro != null && message.hasOwnProperty("pro"))
                object.pro = $root.pb.Property.toObject(message.pro, options);
            return object;
        };

        /**
         * Converts this AddLastPro to JSON.
         * @function toJSON
         * @memberof pb.AddLastPro
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AddLastPro.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return AddLastPro;
    })();

    pb.RemoveProAt = (function() {

        /**
         * Properties of a RemoveProAt.
         * @memberof pb
         * @interface IRemoveProAt
         * @property {Array.<string>} [key] RemoveProAt key
         * @property {number} [index] RemoveProAt index
         */

        /**
         * Constructs a new RemoveProAt.
         * @memberof pb
         * @classdesc Represents a RemoveProAt.
         * @constructor
         * @param {pb.IRemoveProAt=} [properties] Properties to set
         */
        function RemoveProAt(properties) {
            this.key = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * RemoveProAt key.
         * @member {Array.<string>}key
         * @memberof pb.RemoveProAt
         * @instance
         */
        RemoveProAt.prototype.key = $util.emptyArray;

        /**
         * RemoveProAt index.
         * @member {number}index
         * @memberof pb.RemoveProAt
         * @instance
         */
        RemoveProAt.prototype.index = 0;

        /**
         * Creates a new RemoveProAt instance using the specified properties.
         * @function create
         * @memberof pb.RemoveProAt
         * @static
         * @param {pb.IRemoveProAt=} [properties] Properties to set
         * @returns {pb.RemoveProAt} RemoveProAt instance
         */
        RemoveProAt.create = function create(properties) {
            return new RemoveProAt(properties);
        };

        /**
         * Encodes the specified RemoveProAt message. Does not implicitly {@link pb.RemoveProAt.verify|verify} messages.
         * @function encode
         * @memberof pb.RemoveProAt
         * @static
         * @param {pb.IRemoveProAt} message RemoveProAt message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        RemoveProAt.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.key != null && message.key.length)
                for (var i = 0; i < message.key.length; ++i)
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.key[i]);
            if (message.index != null && message.hasOwnProperty("index"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.index);
            return writer;
        };

        /**
         * Encodes the specified RemoveProAt message, length delimited. Does not implicitly {@link pb.RemoveProAt.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.RemoveProAt
         * @static
         * @param {pb.IRemoveProAt} message RemoveProAt message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        RemoveProAt.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a RemoveProAt message from the specified reader or buffer.
         * @function decode
         * @memberof pb.RemoveProAt
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.RemoveProAt} RemoveProAt
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        RemoveProAt.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.RemoveProAt();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.key && message.key.length))
                        message.key = [];
                    message.key.push(reader.string());
                    break;
                case 2:
                    message.index = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a RemoveProAt message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.RemoveProAt
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.RemoveProAt} RemoveProAt
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        RemoveProAt.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a RemoveProAt message.
         * @function verify
         * @memberof pb.RemoveProAt
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        RemoveProAt.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.key != null && message.hasOwnProperty("key")) {
                if (!Array.isArray(message.key))
                    return "key: array expected";
                for (var i = 0; i < message.key.length; ++i)
                    if (!$util.isString(message.key[i]))
                        return "key: string[] expected";
            }
            if (message.index != null && message.hasOwnProperty("index"))
                if (!$util.isInteger(message.index))
                    return "index: integer expected";
            return null;
        };

        /**
         * Creates a RemoveProAt message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.RemoveProAt
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.RemoveProAt} RemoveProAt
         */
        RemoveProAt.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.RemoveProAt)
                return object;
            var message = new $root.pb.RemoveProAt();
            if (object.key) {
                if (!Array.isArray(object.key))
                    throw TypeError(".pb.RemoveProAt.key: array expected");
                message.key = [];
                for (var i = 0; i < object.key.length; ++i)
                    message.key[i] = String(object.key[i]);
            }
            if (object.index != null)
                message.index = object.index | 0;
            return message;
        };

        /**
         * Creates a plain object from a RemoveProAt message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.RemoveProAt
         * @static
         * @param {pb.RemoveProAt} message RemoveProAt
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        RemoveProAt.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.key = [];
            if (options.defaults)
                object.index = 0;
            if (message.key && message.key.length) {
                object.key = [];
                for (var j = 0; j < message.key.length; ++j)
                    object.key[j] = message.key[j];
            }
            if (message.index != null && message.hasOwnProperty("index"))
                object.index = message.index;
            return object;
        };

        /**
         * Converts this RemoveProAt to JSON.
         * @function toJSON
         * @memberof pb.RemoveProAt
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        RemoveProAt.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return RemoveProAt;
    })();

    pb.AddMapPro = (function() {

        /**
         * Properties of an AddMapPro.
         * @memberof pb
         * @interface IAddMapPro
         * @property {Array.<string>} [key] AddMapPro key
         * @property {string} [k] AddMapPro k
         * @property {pb.IProperty} [pro] AddMapPro pro
         */

        /**
         * Constructs a new AddMapPro.
         * @memberof pb
         * @classdesc Represents an AddMapPro.
         * @constructor
         * @param {pb.IAddMapPro=} [properties] Properties to set
         */
        function AddMapPro(properties) {
            this.key = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AddMapPro key.
         * @member {Array.<string>}key
         * @memberof pb.AddMapPro
         * @instance
         */
        AddMapPro.prototype.key = $util.emptyArray;

        /**
         * AddMapPro k.
         * @member {string}k
         * @memberof pb.AddMapPro
         * @instance
         */
        AddMapPro.prototype.k = "";

        /**
         * AddMapPro pro.
         * @member {(pb.IProperty|null|undefined)}pro
         * @memberof pb.AddMapPro
         * @instance
         */
        AddMapPro.prototype.pro = null;

        /**
         * Creates a new AddMapPro instance using the specified properties.
         * @function create
         * @memberof pb.AddMapPro
         * @static
         * @param {pb.IAddMapPro=} [properties] Properties to set
         * @returns {pb.AddMapPro} AddMapPro instance
         */
        AddMapPro.create = function create(properties) {
            return new AddMapPro(properties);
        };

        /**
         * Encodes the specified AddMapPro message. Does not implicitly {@link pb.AddMapPro.verify|verify} messages.
         * @function encode
         * @memberof pb.AddMapPro
         * @static
         * @param {pb.IAddMapPro} message AddMapPro message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AddMapPro.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.key != null && message.key.length)
                for (var i = 0; i < message.key.length; ++i)
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.key[i]);
            if (message.k != null && message.hasOwnProperty("k"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.k);
            if (message.pro != null && message.hasOwnProperty("pro"))
                $root.pb.Property.encode(message.pro, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified AddMapPro message, length delimited. Does not implicitly {@link pb.AddMapPro.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.AddMapPro
         * @static
         * @param {pb.IAddMapPro} message AddMapPro message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AddMapPro.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AddMapPro message from the specified reader or buffer.
         * @function decode
         * @memberof pb.AddMapPro
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.AddMapPro} AddMapPro
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AddMapPro.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.AddMapPro();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.key && message.key.length))
                        message.key = [];
                    message.key.push(reader.string());
                    break;
                case 2:
                    message.k = reader.string();
                    break;
                case 3:
                    message.pro = $root.pb.Property.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AddMapPro message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.AddMapPro
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.AddMapPro} AddMapPro
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AddMapPro.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AddMapPro message.
         * @function verify
         * @memberof pb.AddMapPro
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AddMapPro.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.key != null && message.hasOwnProperty("key")) {
                if (!Array.isArray(message.key))
                    return "key: array expected";
                for (var i = 0; i < message.key.length; ++i)
                    if (!$util.isString(message.key[i]))
                        return "key: string[] expected";
            }
            if (message.k != null && message.hasOwnProperty("k"))
                if (!$util.isString(message.k))
                    return "k: string expected";
            if (message.pro != null && message.hasOwnProperty("pro")) {
                var error = $root.pb.Property.verify(message.pro);
                if (error)
                    return "pro." + error;
            }
            return null;
        };

        /**
         * Creates an AddMapPro message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.AddMapPro
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.AddMapPro} AddMapPro
         */
        AddMapPro.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.AddMapPro)
                return object;
            var message = new $root.pb.AddMapPro();
            if (object.key) {
                if (!Array.isArray(object.key))
                    throw TypeError(".pb.AddMapPro.key: array expected");
                message.key = [];
                for (var i = 0; i < object.key.length; ++i)
                    message.key[i] = String(object.key[i]);
            }
            if (object.k != null)
                message.k = String(object.k);
            if (object.pro != null) {
                if (typeof object.pro !== "object")
                    throw TypeError(".pb.AddMapPro.pro: object expected");
                message.pro = $root.pb.Property.fromObject(object.pro);
            }
            return message;
        };

        /**
         * Creates a plain object from an AddMapPro message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.AddMapPro
         * @static
         * @param {pb.AddMapPro} message AddMapPro
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AddMapPro.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.key = [];
            if (options.defaults) {
                object.k = "";
                object.pro = null;
            }
            if (message.key && message.key.length) {
                object.key = [];
                for (var j = 0; j < message.key.length; ++j)
                    object.key[j] = message.key[j];
            }
            if (message.k != null && message.hasOwnProperty("k"))
                object.k = message.k;
            if (message.pro != null && message.hasOwnProperty("pro"))
                object.pro = $root.pb.Property.toObject(message.pro, options);
            return object;
        };

        /**
         * Converts this AddMapPro to JSON.
         * @function toJSON
         * @memberof pb.AddMapPro
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AddMapPro.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return AddMapPro;
    })();

    pb.DelMapPro = (function() {

        /**
         * Properties of a DelMapPro.
         * @memberof pb
         * @interface IDelMapPro
         * @property {Array.<string>} [key] DelMapPro key
         * @property {string} [k] DelMapPro k
         */

        /**
         * Constructs a new DelMapPro.
         * @memberof pb
         * @classdesc Represents a DelMapPro.
         * @constructor
         * @param {pb.IDelMapPro=} [properties] Properties to set
         */
        function DelMapPro(properties) {
            this.key = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DelMapPro key.
         * @member {Array.<string>}key
         * @memberof pb.DelMapPro
         * @instance
         */
        DelMapPro.prototype.key = $util.emptyArray;

        /**
         * DelMapPro k.
         * @member {string}k
         * @memberof pb.DelMapPro
         * @instance
         */
        DelMapPro.prototype.k = "";

        /**
         * Creates a new DelMapPro instance using the specified properties.
         * @function create
         * @memberof pb.DelMapPro
         * @static
         * @param {pb.IDelMapPro=} [properties] Properties to set
         * @returns {pb.DelMapPro} DelMapPro instance
         */
        DelMapPro.create = function create(properties) {
            return new DelMapPro(properties);
        };

        /**
         * Encodes the specified DelMapPro message. Does not implicitly {@link pb.DelMapPro.verify|verify} messages.
         * @function encode
         * @memberof pb.DelMapPro
         * @static
         * @param {pb.IDelMapPro} message DelMapPro message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DelMapPro.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.key != null && message.key.length)
                for (var i = 0; i < message.key.length; ++i)
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.key[i]);
            if (message.k != null && message.hasOwnProperty("k"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.k);
            return writer;
        };

        /**
         * Encodes the specified DelMapPro message, length delimited. Does not implicitly {@link pb.DelMapPro.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.DelMapPro
         * @static
         * @param {pb.IDelMapPro} message DelMapPro message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DelMapPro.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DelMapPro message from the specified reader or buffer.
         * @function decode
         * @memberof pb.DelMapPro
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.DelMapPro} DelMapPro
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DelMapPro.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.DelMapPro();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.key && message.key.length))
                        message.key = [];
                    message.key.push(reader.string());
                    break;
                case 2:
                    message.k = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DelMapPro message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.DelMapPro
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.DelMapPro} DelMapPro
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DelMapPro.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DelMapPro message.
         * @function verify
         * @memberof pb.DelMapPro
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DelMapPro.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.key != null && message.hasOwnProperty("key")) {
                if (!Array.isArray(message.key))
                    return "key: array expected";
                for (var i = 0; i < message.key.length; ++i)
                    if (!$util.isString(message.key[i]))
                        return "key: string[] expected";
            }
            if (message.k != null && message.hasOwnProperty("k"))
                if (!$util.isString(message.k))
                    return "k: string expected";
            return null;
        };

        /**
         * Creates a DelMapPro message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.DelMapPro
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.DelMapPro} DelMapPro
         */
        DelMapPro.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.DelMapPro)
                return object;
            var message = new $root.pb.DelMapPro();
            if (object.key) {
                if (!Array.isArray(object.key))
                    throw TypeError(".pb.DelMapPro.key: array expected");
                message.key = [];
                for (var i = 0; i < object.key.length; ++i)
                    message.key[i] = String(object.key[i]);
            }
            if (object.k != null)
                message.k = String(object.k);
            return message;
        };

        /**
         * Creates a plain object from a DelMapPro message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.DelMapPro
         * @static
         * @param {pb.DelMapPro} message DelMapPro
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DelMapPro.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.key = [];
            if (options.defaults)
                object.k = "";
            if (message.key && message.key.length) {
                object.key = [];
                for (var j = 0; j < message.key.length; ++j)
                    object.key[j] = message.key[j];
            }
            if (message.k != null && message.hasOwnProperty("k"))
                object.k = message.k;
            return object;
        };

        /**
         * Converts this DelMapPro to JSON.
         * @function toJSON
         * @memberof pb.DelMapPro
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DelMapPro.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DelMapPro;
    })();

    /**
     * LoginEnum enum.
     * @enum {string}
     * @property {number} VerifyOK=0 VerifyOK value
     * @property {number} DataException=1 DataException value
     * @property {number} AccountBlocked=2 AccountBlocked value
     * @property {number} GameUserFull=3 GameUserFull value
     */
    pb.LoginEnum = (function() {
        var valuesById = {}, values = Object.create(valuesById);
        values[valuesById[0] = "VerifyOK"] = 0;
        values[valuesById[1] = "DataException"] = 1;
        values[valuesById[2] = "AccountBlocked"] = 2;
        values[valuesById[3] = "GameUserFull"] = 3;
        return values;
    })();

    pb.LoginAsk = (function() {

        /**
         * Properties of a LoginAsk.
         * @memberof pb
         * @interface ILoginAsk
         * @property {string} [account] LoginAsk account
         * @property {string} [code] LoginAsk code
         * @property {string} [token] LoginAsk token
         */

        /**
         * Constructs a new LoginAsk.
         * @memberof pb
         * @classdesc Represents a LoginAsk.
         * @constructor
         * @param {pb.ILoginAsk=} [properties] Properties to set
         */
        function LoginAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * LoginAsk account.
         * @member {string}account
         * @memberof pb.LoginAsk
         * @instance
         */
        LoginAsk.prototype.account = "";

        /**
         * LoginAsk code.
         * @member {string}code
         * @memberof pb.LoginAsk
         * @instance
         */
        LoginAsk.prototype.code = "";

        /**
         * LoginAsk token.
         * @member {string}token
         * @memberof pb.LoginAsk
         * @instance
         */
        LoginAsk.prototype.token = "";

        /**
         * Creates a new LoginAsk instance using the specified properties.
         * @function create
         * @memberof pb.LoginAsk
         * @static
         * @param {pb.ILoginAsk=} [properties] Properties to set
         * @returns {pb.LoginAsk} LoginAsk instance
         */
        LoginAsk.create = function create(properties) {
            return new LoginAsk(properties);
        };

        /**
         * Encodes the specified LoginAsk message. Does not implicitly {@link pb.LoginAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.LoginAsk
         * @static
         * @param {pb.ILoginAsk} message LoginAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        LoginAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.account != null && message.hasOwnProperty("account"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.account);
            if (message.code != null && message.hasOwnProperty("code"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.code);
            if (message.token != null && message.hasOwnProperty("token"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.token);
            return writer;
        };

        /**
         * Encodes the specified LoginAsk message, length delimited. Does not implicitly {@link pb.LoginAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.LoginAsk
         * @static
         * @param {pb.ILoginAsk} message LoginAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        LoginAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a LoginAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.LoginAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.LoginAsk} LoginAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        LoginAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.LoginAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.account = reader.string();
                    break;
                case 2:
                    message.code = reader.string();
                    break;
                case 3:
                    message.token = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a LoginAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.LoginAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.LoginAsk} LoginAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        LoginAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a LoginAsk message.
         * @function verify
         * @memberof pb.LoginAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        LoginAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.account != null && message.hasOwnProperty("account"))
                if (!$util.isString(message.account))
                    return "account: string expected";
            if (message.code != null && message.hasOwnProperty("code"))
                if (!$util.isString(message.code))
                    return "code: string expected";
            if (message.token != null && message.hasOwnProperty("token"))
                if (!$util.isString(message.token))
                    return "token: string expected";
            return null;
        };

        /**
         * Creates a LoginAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.LoginAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.LoginAsk} LoginAsk
         */
        LoginAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.LoginAsk)
                return object;
            var message = new $root.pb.LoginAsk();
            if (object.account != null)
                message.account = String(object.account);
            if (object.code != null)
                message.code = String(object.code);
            if (object.token != null)
                message.token = String(object.token);
            return message;
        };

        /**
         * Creates a plain object from a LoginAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.LoginAsk
         * @static
         * @param {pb.LoginAsk} message LoginAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        LoginAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.account = "";
                object.code = "";
                object.token = "";
            }
            if (message.account != null && message.hasOwnProperty("account"))
                object.account = message.account;
            if (message.code != null && message.hasOwnProperty("code"))
                object.code = message.code;
            if (message.token != null && message.hasOwnProperty("token"))
                object.token = message.token;
            return object;
        };

        /**
         * Converts this LoginAsk to JSON.
         * @function toJSON
         * @memberof pb.LoginAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        LoginAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return LoginAsk;
    })();

    pb.QuDaoLoginAsk = (function() {

        /**
         * Properties of a QuDaoLoginAsk.
         * @memberof pb
         * @interface IQuDaoLoginAsk
         * @property {string} [quDao] QuDaoLoginAsk quDao
         * @property {string} [code] QuDaoLoginAsk code
         * @property {string} [openid] QuDaoLoginAsk openid
         * @property {string} [openkey] QuDaoLoginAsk openkey
         * @property {string} [pf] QuDaoLoginAsk pf
         * @property {string} [platform] QuDaoLoginAsk platform
         */

        /**
         * Constructs a new QuDaoLoginAsk.
         * @memberof pb
         * @classdesc Represents a QuDaoLoginAsk.
         * @constructor
         * @param {pb.IQuDaoLoginAsk=} [properties] Properties to set
         */
        function QuDaoLoginAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * QuDaoLoginAsk quDao.
         * @member {string}quDao
         * @memberof pb.QuDaoLoginAsk
         * @instance
         */
        QuDaoLoginAsk.prototype.quDao = "";

        /**
         * QuDaoLoginAsk code.
         * @member {string}code
         * @memberof pb.QuDaoLoginAsk
         * @instance
         */
        QuDaoLoginAsk.prototype.code = "";

        /**
         * QuDaoLoginAsk openid.
         * @member {string}openid
         * @memberof pb.QuDaoLoginAsk
         * @instance
         */
        QuDaoLoginAsk.prototype.openid = "";

        /**
         * QuDaoLoginAsk openkey.
         * @member {string}openkey
         * @memberof pb.QuDaoLoginAsk
         * @instance
         */
        QuDaoLoginAsk.prototype.openkey = "";

        /**
         * QuDaoLoginAsk pf.
         * @member {string}pf
         * @memberof pb.QuDaoLoginAsk
         * @instance
         */
        QuDaoLoginAsk.prototype.pf = "";

        /**
         * QuDaoLoginAsk platform.
         * @member {string}platform
         * @memberof pb.QuDaoLoginAsk
         * @instance
         */
        QuDaoLoginAsk.prototype.platform = "";

        /**
         * Creates a new QuDaoLoginAsk instance using the specified properties.
         * @function create
         * @memberof pb.QuDaoLoginAsk
         * @static
         * @param {pb.IQuDaoLoginAsk=} [properties] Properties to set
         * @returns {pb.QuDaoLoginAsk} QuDaoLoginAsk instance
         */
        QuDaoLoginAsk.create = function create(properties) {
            return new QuDaoLoginAsk(properties);
        };

        /**
         * Encodes the specified QuDaoLoginAsk message. Does not implicitly {@link pb.QuDaoLoginAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.QuDaoLoginAsk
         * @static
         * @param {pb.IQuDaoLoginAsk} message QuDaoLoginAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        QuDaoLoginAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.quDao != null && message.hasOwnProperty("quDao"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.quDao);
            if (message.code != null && message.hasOwnProperty("code"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.code);
            if (message.openid != null && message.hasOwnProperty("openid"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.openid);
            if (message.openkey != null && message.hasOwnProperty("openkey"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.openkey);
            if (message.pf != null && message.hasOwnProperty("pf"))
                writer.uint32(/* id 5, wireType 2 =*/42).string(message.pf);
            if (message.platform != null && message.hasOwnProperty("platform"))
                writer.uint32(/* id 6, wireType 2 =*/50).string(message.platform);
            return writer;
        };

        /**
         * Encodes the specified QuDaoLoginAsk message, length delimited. Does not implicitly {@link pb.QuDaoLoginAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.QuDaoLoginAsk
         * @static
         * @param {pb.IQuDaoLoginAsk} message QuDaoLoginAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        QuDaoLoginAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a QuDaoLoginAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.QuDaoLoginAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.QuDaoLoginAsk} QuDaoLoginAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        QuDaoLoginAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.QuDaoLoginAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.quDao = reader.string();
                    break;
                case 2:
                    message.code = reader.string();
                    break;
                case 3:
                    message.openid = reader.string();
                    break;
                case 4:
                    message.openkey = reader.string();
                    break;
                case 5:
                    message.pf = reader.string();
                    break;
                case 6:
                    message.platform = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a QuDaoLoginAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.QuDaoLoginAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.QuDaoLoginAsk} QuDaoLoginAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        QuDaoLoginAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a QuDaoLoginAsk message.
         * @function verify
         * @memberof pb.QuDaoLoginAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        QuDaoLoginAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.quDao != null && message.hasOwnProperty("quDao"))
                if (!$util.isString(message.quDao))
                    return "quDao: string expected";
            if (message.code != null && message.hasOwnProperty("code"))
                if (!$util.isString(message.code))
                    return "code: string expected";
            if (message.openid != null && message.hasOwnProperty("openid"))
                if (!$util.isString(message.openid))
                    return "openid: string expected";
            if (message.openkey != null && message.hasOwnProperty("openkey"))
                if (!$util.isString(message.openkey))
                    return "openkey: string expected";
            if (message.pf != null && message.hasOwnProperty("pf"))
                if (!$util.isString(message.pf))
                    return "pf: string expected";
            if (message.platform != null && message.hasOwnProperty("platform"))
                if (!$util.isString(message.platform))
                    return "platform: string expected";
            return null;
        };

        /**
         * Creates a QuDaoLoginAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.QuDaoLoginAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.QuDaoLoginAsk} QuDaoLoginAsk
         */
        QuDaoLoginAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.QuDaoLoginAsk)
                return object;
            var message = new $root.pb.QuDaoLoginAsk();
            if (object.quDao != null)
                message.quDao = String(object.quDao);
            if (object.code != null)
                message.code = String(object.code);
            if (object.openid != null)
                message.openid = String(object.openid);
            if (object.openkey != null)
                message.openkey = String(object.openkey);
            if (object.pf != null)
                message.pf = String(object.pf);
            if (object.platform != null)
                message.platform = String(object.platform);
            return message;
        };

        /**
         * Creates a plain object from a QuDaoLoginAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.QuDaoLoginAsk
         * @static
         * @param {pb.QuDaoLoginAsk} message QuDaoLoginAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        QuDaoLoginAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.quDao = "";
                object.code = "";
                object.openid = "";
                object.openkey = "";
                object.pf = "";
                object.platform = "";
            }
            if (message.quDao != null && message.hasOwnProperty("quDao"))
                object.quDao = message.quDao;
            if (message.code != null && message.hasOwnProperty("code"))
                object.code = message.code;
            if (message.openid != null && message.hasOwnProperty("openid"))
                object.openid = message.openid;
            if (message.openkey != null && message.hasOwnProperty("openkey"))
                object.openkey = message.openkey;
            if (message.pf != null && message.hasOwnProperty("pf"))
                object.pf = message.pf;
            if (message.platform != null && message.hasOwnProperty("platform"))
                object.platform = message.platform;
            return object;
        };

        /**
         * Converts this QuDaoLoginAsk to JSON.
         * @function toJSON
         * @memberof pb.QuDaoLoginAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        QuDaoLoginAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return QuDaoLoginAsk;
    })();

    pb.LoginRes = (function() {

        /**
         * Properties of a LoginRes.
         * @memberof pb
         * @interface ILoginRes
         * @property {pb.LoginEnum} [res] LoginRes res
         */

        /**
         * Constructs a new LoginRes.
         * @memberof pb
         * @classdesc Represents a LoginRes.
         * @constructor
         * @param {pb.ILoginRes=} [properties] Properties to set
         */
        function LoginRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * LoginRes res.
         * @member {pb.LoginEnum}res
         * @memberof pb.LoginRes
         * @instance
         */
        LoginRes.prototype.res = 0;

        /**
         * Creates a new LoginRes instance using the specified properties.
         * @function create
         * @memberof pb.LoginRes
         * @static
         * @param {pb.ILoginRes=} [properties] Properties to set
         * @returns {pb.LoginRes} LoginRes instance
         */
        LoginRes.create = function create(properties) {
            return new LoginRes(properties);
        };

        /**
         * Encodes the specified LoginRes message. Does not implicitly {@link pb.LoginRes.verify|verify} messages.
         * @function encode
         * @memberof pb.LoginRes
         * @static
         * @param {pb.ILoginRes} message LoginRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        LoginRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.res != null && message.hasOwnProperty("res"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.res);
            return writer;
        };

        /**
         * Encodes the specified LoginRes message, length delimited. Does not implicitly {@link pb.LoginRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.LoginRes
         * @static
         * @param {pb.ILoginRes} message LoginRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        LoginRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a LoginRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.LoginRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.LoginRes} LoginRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        LoginRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.LoginRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.res = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a LoginRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.LoginRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.LoginRes} LoginRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        LoginRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a LoginRes message.
         * @function verify
         * @memberof pb.LoginRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        LoginRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.res != null && message.hasOwnProperty("res"))
                switch (message.res) {
                default:
                    return "res: enum value expected";
                case 0:
                case 1:
                case 2:
                case 3:
                    break;
                }
            return null;
        };

        /**
         * Creates a LoginRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.LoginRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.LoginRes} LoginRes
         */
        LoginRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.LoginRes)
                return object;
            var message = new $root.pb.LoginRes();
            switch (object.res) {
            case "VerifyOK":
            case 0:
                message.res = 0;
                break;
            case "DataException":
            case 1:
                message.res = 1;
                break;
            case "AccountBlocked":
            case 2:
                message.res = 2;
                break;
            case "GameUserFull":
            case 3:
                message.res = 3;
                break;
            }
            return message;
        };

        /**
         * Creates a plain object from a LoginRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.LoginRes
         * @static
         * @param {pb.LoginRes} message LoginRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        LoginRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.res = options.enums === String ? "VerifyOK" : 0;
            if (message.res != null && message.hasOwnProperty("res"))
                object.res = options.enums === String ? $root.pb.LoginEnum[message.res] : message.res;
            return object;
        };

        /**
         * Converts this LoginRes to JSON.
         * @function toJSON
         * @memberof pb.LoginRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        LoginRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return LoginRes;
    })();

    pb.ServerRes = (function() {

        /**
         * Properties of a ServerRes.
         * @memberof pb
         * @interface IServerRes
         * @property {string} [ModelID] ServerRes ModelID
         * @property {boolean} [ModelDelete] ServerRes ModelDelete
         * @property {string} [DisplayName] ServerRes DisplayName
         * @property {string} [Address] ServerRes Address
         */

        /**
         * Constructs a new ServerRes.
         * @memberof pb
         * @classdesc Represents a ServerRes.
         * @constructor
         * @param {pb.IServerRes=} [properties] Properties to set
         */
        function ServerRes(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ServerRes ModelID.
         * @member {string}ModelID
         * @memberof pb.ServerRes
         * @instance
         */
        ServerRes.prototype.ModelID = "";

        /**
         * ServerRes ModelDelete.
         * @member {boolean}ModelDelete
         * @memberof pb.ServerRes
         * @instance
         */
        ServerRes.prototype.ModelDelete = false;

        /**
         * ServerRes DisplayName.
         * @member {string}DisplayName
         * @memberof pb.ServerRes
         * @instance
         */
        ServerRes.prototype.DisplayName = "";

        /**
         * ServerRes Address.
         * @member {string}Address
         * @memberof pb.ServerRes
         * @instance
         */
        ServerRes.prototype.Address = "";

        /**
         * Creates a new ServerRes instance using the specified properties.
         * @function create
         * @memberof pb.ServerRes
         * @static
         * @param {pb.IServerRes=} [properties] Properties to set
         * @returns {pb.ServerRes} ServerRes instance
         */
        ServerRes.create = function create(properties) {
            return new ServerRes(properties);
        };

        /**
         * Encodes the specified ServerRes message. Does not implicitly {@link pb.ServerRes.verify|verify} messages.
         * @function encode
         * @memberof pb.ServerRes
         * @static
         * @param {pb.IServerRes} message ServerRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ServerRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.ModelID != null && message.hasOwnProperty("ModelID"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.ModelID);
            if (message.ModelDelete != null && message.hasOwnProperty("ModelDelete"))
                writer.uint32(/* id 2, wireType 0 =*/16).bool(message.ModelDelete);
            if (message.DisplayName != null && message.hasOwnProperty("DisplayName"))
                writer.uint32(/* id 11, wireType 2 =*/90).string(message.DisplayName);
            if (message.Address != null && message.hasOwnProperty("Address"))
                writer.uint32(/* id 12, wireType 2 =*/98).string(message.Address);
            return writer;
        };

        /**
         * Encodes the specified ServerRes message, length delimited. Does not implicitly {@link pb.ServerRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.ServerRes
         * @static
         * @param {pb.IServerRes} message ServerRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ServerRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ServerRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.ServerRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.ServerRes} ServerRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ServerRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.ServerRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.ModelID = reader.string();
                    break;
                case 2:
                    message.ModelDelete = reader.bool();
                    break;
                case 11:
                    message.DisplayName = reader.string();
                    break;
                case 12:
                    message.Address = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ServerRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.ServerRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.ServerRes} ServerRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ServerRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ServerRes message.
         * @function verify
         * @memberof pb.ServerRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ServerRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.ModelID != null && message.hasOwnProperty("ModelID"))
                if (!$util.isString(message.ModelID))
                    return "ModelID: string expected";
            if (message.ModelDelete != null && message.hasOwnProperty("ModelDelete"))
                if (typeof message.ModelDelete !== "boolean")
                    return "ModelDelete: boolean expected";
            if (message.DisplayName != null && message.hasOwnProperty("DisplayName"))
                if (!$util.isString(message.DisplayName))
                    return "DisplayName: string expected";
            if (message.Address != null && message.hasOwnProperty("Address"))
                if (!$util.isString(message.Address))
                    return "Address: string expected";
            return null;
        };

        /**
         * Creates a ServerRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.ServerRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.ServerRes} ServerRes
         */
        ServerRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.ServerRes)
                return object;
            var message = new $root.pb.ServerRes();
            if (object.ModelID != null)
                message.ModelID = String(object.ModelID);
            if (object.ModelDelete != null)
                message.ModelDelete = Boolean(object.ModelDelete);
            if (object.DisplayName != null)
                message.DisplayName = String(object.DisplayName);
            if (object.Address != null)
                message.Address = String(object.Address);
            return message;
        };

        /**
         * Creates a plain object from a ServerRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.ServerRes
         * @static
         * @param {pb.ServerRes} message ServerRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ServerRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.ModelID = "";
                object.ModelDelete = false;
                object.DisplayName = "";
                object.Address = "";
            }
            if (message.ModelID != null && message.hasOwnProperty("ModelID"))
                object.ModelID = message.ModelID;
            if (message.ModelDelete != null && message.hasOwnProperty("ModelDelete"))
                object.ModelDelete = message.ModelDelete;
            if (message.DisplayName != null && message.hasOwnProperty("DisplayName"))
                object.DisplayName = message.DisplayName;
            if (message.Address != null && message.hasOwnProperty("Address"))
                object.Address = message.Address;
            return object;
        };

        /**
         * Converts this ServerRes to JSON.
         * @function toJSON
         * @memberof pb.ServerRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ServerRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ServerRes;
    })();

    pb.ServersRes = (function() {

        /**
         * Properties of a ServersRes.
         * @memberof pb
         * @interface IServersRes
         * @property {Array.<pb.IServerRes>} [Servers] ServersRes Servers
         */

        /**
         * Constructs a new ServersRes.
         * @memberof pb
         * @classdesc Represents a ServersRes.
         * @constructor
         * @param {pb.IServersRes=} [properties] Properties to set
         */
        function ServersRes(properties) {
            this.Servers = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ServersRes Servers.
         * @member {Array.<pb.IServerRes>}Servers
         * @memberof pb.ServersRes
         * @instance
         */
        ServersRes.prototype.Servers = $util.emptyArray;

        /**
         * Creates a new ServersRes instance using the specified properties.
         * @function create
         * @memberof pb.ServersRes
         * @static
         * @param {pb.IServersRes=} [properties] Properties to set
         * @returns {pb.ServersRes} ServersRes instance
         */
        ServersRes.create = function create(properties) {
            return new ServersRes(properties);
        };

        /**
         * Encodes the specified ServersRes message. Does not implicitly {@link pb.ServersRes.verify|verify} messages.
         * @function encode
         * @memberof pb.ServersRes
         * @static
         * @param {pb.IServersRes} message ServersRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ServersRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.Servers != null && message.Servers.length)
                for (var i = 0; i < message.Servers.length; ++i)
                    $root.pb.ServerRes.encode(message.Servers[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified ServersRes message, length delimited. Does not implicitly {@link pb.ServersRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.ServersRes
         * @static
         * @param {pb.IServersRes} message ServersRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ServersRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ServersRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.ServersRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.ServersRes} ServersRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ServersRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.ServersRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.Servers && message.Servers.length))
                        message.Servers = [];
                    message.Servers.push($root.pb.ServerRes.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ServersRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.ServersRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.ServersRes} ServersRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ServersRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ServersRes message.
         * @function verify
         * @memberof pb.ServersRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ServersRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.Servers != null && message.hasOwnProperty("Servers")) {
                if (!Array.isArray(message.Servers))
                    return "Servers: array expected";
                for (var i = 0; i < message.Servers.length; ++i) {
                    var error = $root.pb.ServerRes.verify(message.Servers[i]);
                    if (error)
                        return "Servers." + error;
                }
            }
            return null;
        };

        /**
         * Creates a ServersRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.ServersRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.ServersRes} ServersRes
         */
        ServersRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.ServersRes)
                return object;
            var message = new $root.pb.ServersRes();
            if (object.Servers) {
                if (!Array.isArray(object.Servers))
                    throw TypeError(".pb.ServersRes.Servers: array expected");
                message.Servers = [];
                for (var i = 0; i < object.Servers.length; ++i) {
                    if (typeof object.Servers[i] !== "object")
                        throw TypeError(".pb.ServersRes.Servers: object expected");
                    message.Servers[i] = $root.pb.ServerRes.fromObject(object.Servers[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a ServersRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.ServersRes
         * @static
         * @param {pb.ServersRes} message ServersRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ServersRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.Servers = [];
            if (message.Servers && message.Servers.length) {
                object.Servers = [];
                for (var j = 0; j < message.Servers.length; ++j)
                    object.Servers[j] = $root.pb.ServerRes.toObject(message.Servers[j], options);
            }
            return object;
        };

        /**
         * Converts this ServersRes to JSON.
         * @function toJSON
         * @memberof pb.ServersRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ServersRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ServersRes;
    })();

    pb.Qu = (function() {

        /**
         * Properties of a Qu.
         * @memberof pb
         * @interface IQu
         * @property {number} [id] Qu id
         * @property {string} [name] Qu name
         * @property {string} [addr] Qu addr
         * @property {string} [gm] Qu gm
         * @property {number} [pid] Qu pid
         * @property {boolean} [enable] Qu enable
         * @property {string} [path] Qu path
         * @property {string} [exe] Qu exe
         * @property {string} [addr2] Qu addr2
         * @property {string} [gm2] Qu gm2
         * @property {number} [num] Qu num
         */

        /**
         * Constructs a new Qu.
         * @memberof pb
         * @classdesc Represents a Qu.
         * @constructor
         * @param {pb.IQu=} [properties] Properties to set
         */
        function Qu(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Qu id.
         * @member {number}id
         * @memberof pb.Qu
         * @instance
         */
        Qu.prototype.id = 0;

        /**
         * Qu name.
         * @member {string}name
         * @memberof pb.Qu
         * @instance
         */
        Qu.prototype.name = "";

        /**
         * Qu addr.
         * @member {string}addr
         * @memberof pb.Qu
         * @instance
         */
        Qu.prototype.addr = "";

        /**
         * Qu gm.
         * @member {string}gm
         * @memberof pb.Qu
         * @instance
         */
        Qu.prototype.gm = "";

        /**
         * Qu pid.
         * @member {number}pid
         * @memberof pb.Qu
         * @instance
         */
        Qu.prototype.pid = 0;

        /**
         * Qu enable.
         * @member {boolean}enable
         * @memberof pb.Qu
         * @instance
         */
        Qu.prototype.enable = false;

        /**
         * Qu path.
         * @member {string}path
         * @memberof pb.Qu
         * @instance
         */
        Qu.prototype.path = "";

        /**
         * Qu exe.
         * @member {string}exe
         * @memberof pb.Qu
         * @instance
         */
        Qu.prototype.exe = "";

        /**
         * Qu addr2.
         * @member {string}addr2
         * @memberof pb.Qu
         * @instance
         */
        Qu.prototype.addr2 = "";

        /**
         * Qu gm2.
         * @member {string}gm2
         * @memberof pb.Qu
         * @instance
         */
        Qu.prototype.gm2 = "";

        /**
         * Qu num.
         * @member {number}num
         * @memberof pb.Qu
         * @instance
         */
        Qu.prototype.num = 0;

        /**
         * Creates a new Qu instance using the specified properties.
         * @function create
         * @memberof pb.Qu
         * @static
         * @param {pb.IQu=} [properties] Properties to set
         * @returns {pb.Qu} Qu instance
         */
        Qu.create = function create(properties) {
            return new Qu(properties);
        };

        /**
         * Encodes the specified Qu message. Does not implicitly {@link pb.Qu.verify|verify} messages.
         * @function encode
         * @memberof pb.Qu
         * @static
         * @param {pb.IQu} message Qu message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Qu.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.id != null && message.hasOwnProperty("id"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.id);
            if (message.name != null && message.hasOwnProperty("name"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.name);
            if (message.addr != null && message.hasOwnProperty("addr"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.addr);
            if (message.gm != null && message.hasOwnProperty("gm"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.gm);
            if (message.pid != null && message.hasOwnProperty("pid"))
                writer.uint32(/* id 5, wireType 0 =*/40).int32(message.pid);
            if (message.enable != null && message.hasOwnProperty("enable"))
                writer.uint32(/* id 6, wireType 0 =*/48).bool(message.enable);
            if (message.path != null && message.hasOwnProperty("path"))
                writer.uint32(/* id 7, wireType 2 =*/58).string(message.path);
            if (message.exe != null && message.hasOwnProperty("exe"))
                writer.uint32(/* id 8, wireType 2 =*/66).string(message.exe);
            if (message.addr2 != null && message.hasOwnProperty("addr2"))
                writer.uint32(/* id 9, wireType 2 =*/74).string(message.addr2);
            if (message.gm2 != null && message.hasOwnProperty("gm2"))
                writer.uint32(/* id 10, wireType 2 =*/82).string(message.gm2);
            if (message.num != null && message.hasOwnProperty("num"))
                writer.uint32(/* id 11, wireType 0 =*/88).int32(message.num);
            return writer;
        };

        /**
         * Encodes the specified Qu message, length delimited. Does not implicitly {@link pb.Qu.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.Qu
         * @static
         * @param {pb.IQu} message Qu message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Qu.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Qu message from the specified reader or buffer.
         * @function decode
         * @memberof pb.Qu
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.Qu} Qu
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Qu.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.Qu();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.id = reader.uint32();
                    break;
                case 2:
                    message.name = reader.string();
                    break;
                case 3:
                    message.addr = reader.string();
                    break;
                case 4:
                    message.gm = reader.string();
                    break;
                case 5:
                    message.pid = reader.int32();
                    break;
                case 6:
                    message.enable = reader.bool();
                    break;
                case 7:
                    message.path = reader.string();
                    break;
                case 8:
                    message.exe = reader.string();
                    break;
                case 9:
                    message.addr2 = reader.string();
                    break;
                case 10:
                    message.gm2 = reader.string();
                    break;
                case 11:
                    message.num = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a Qu message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.Qu
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.Qu} Qu
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Qu.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Qu message.
         * @function verify
         * @memberof pb.Qu
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Qu.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.id != null && message.hasOwnProperty("id"))
                if (!$util.isInteger(message.id))
                    return "id: integer expected";
            if (message.name != null && message.hasOwnProperty("name"))
                if (!$util.isString(message.name))
                    return "name: string expected";
            if (message.addr != null && message.hasOwnProperty("addr"))
                if (!$util.isString(message.addr))
                    return "addr: string expected";
            if (message.gm != null && message.hasOwnProperty("gm"))
                if (!$util.isString(message.gm))
                    return "gm: string expected";
            if (message.pid != null && message.hasOwnProperty("pid"))
                if (!$util.isInteger(message.pid))
                    return "pid: integer expected";
            if (message.enable != null && message.hasOwnProperty("enable"))
                if (typeof message.enable !== "boolean")
                    return "enable: boolean expected";
            if (message.path != null && message.hasOwnProperty("path"))
                if (!$util.isString(message.path))
                    return "path: string expected";
            if (message.exe != null && message.hasOwnProperty("exe"))
                if (!$util.isString(message.exe))
                    return "exe: string expected";
            if (message.addr2 != null && message.hasOwnProperty("addr2"))
                if (!$util.isString(message.addr2))
                    return "addr2: string expected";
            if (message.gm2 != null && message.hasOwnProperty("gm2"))
                if (!$util.isString(message.gm2))
                    return "gm2: string expected";
            if (message.num != null && message.hasOwnProperty("num"))
                if (!$util.isInteger(message.num))
                    return "num: integer expected";
            return null;
        };

        /**
         * Creates a Qu message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.Qu
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.Qu} Qu
         */
        Qu.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.Qu)
                return object;
            var message = new $root.pb.Qu();
            if (object.id != null)
                message.id = object.id >>> 0;
            if (object.name != null)
                message.name = String(object.name);
            if (object.addr != null)
                message.addr = String(object.addr);
            if (object.gm != null)
                message.gm = String(object.gm);
            if (object.pid != null)
                message.pid = object.pid | 0;
            if (object.enable != null)
                message.enable = Boolean(object.enable);
            if (object.path != null)
                message.path = String(object.path);
            if (object.exe != null)
                message.exe = String(object.exe);
            if (object.addr2 != null)
                message.addr2 = String(object.addr2);
            if (object.gm2 != null)
                message.gm2 = String(object.gm2);
            if (object.num != null)
                message.num = object.num | 0;
            return message;
        };

        /**
         * Creates a plain object from a Qu message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.Qu
         * @static
         * @param {pb.Qu} message Qu
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Qu.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.id = 0;
                object.name = "";
                object.addr = "";
                object.gm = "";
                object.pid = 0;
                object.enable = false;
                object.path = "";
                object.exe = "";
                object.addr2 = "";
                object.gm2 = "";
                object.num = 0;
            }
            if (message.id != null && message.hasOwnProperty("id"))
                object.id = message.id;
            if (message.name != null && message.hasOwnProperty("name"))
                object.name = message.name;
            if (message.addr != null && message.hasOwnProperty("addr"))
                object.addr = message.addr;
            if (message.gm != null && message.hasOwnProperty("gm"))
                object.gm = message.gm;
            if (message.pid != null && message.hasOwnProperty("pid"))
                object.pid = message.pid;
            if (message.enable != null && message.hasOwnProperty("enable"))
                object.enable = message.enable;
            if (message.path != null && message.hasOwnProperty("path"))
                object.path = message.path;
            if (message.exe != null && message.hasOwnProperty("exe"))
                object.exe = message.exe;
            if (message.addr2 != null && message.hasOwnProperty("addr2"))
                object.addr2 = message.addr2;
            if (message.gm2 != null && message.hasOwnProperty("gm2"))
                object.gm2 = message.gm2;
            if (message.num != null && message.hasOwnProperty("num"))
                object.num = message.num;
            return object;
        };

        /**
         * Converts this Qu to JSON.
         * @function toJSON
         * @memberof pb.Qu
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Qu.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Qu;
    })();

    pb.QuDao = (function() {

        /**
         * Properties of a QuDao.
         * @memberof pb
         * @interface IQuDao
         * @property {string} [name] QuDao name
         * @property {Array.<pb.IQu>} [qus] QuDao qus
         * @property {string} [qqQun] QuDao qqQun
         * @property {number} [num] QuDao num
         */

        /**
         * Constructs a new QuDao.
         * @memberof pb
         * @classdesc Represents a QuDao.
         * @constructor
         * @param {pb.IQuDao=} [properties] Properties to set
         */
        function QuDao(properties) {
            this.qus = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * QuDao name.
         * @member {string}name
         * @memberof pb.QuDao
         * @instance
         */
        QuDao.prototype.name = "";

        /**
         * QuDao qus.
         * @member {Array.<pb.IQu>}qus
         * @memberof pb.QuDao
         * @instance
         */
        QuDao.prototype.qus = $util.emptyArray;

        /**
         * QuDao qqQun.
         * @member {string}qqQun
         * @memberof pb.QuDao
         * @instance
         */
        QuDao.prototype.qqQun = "";

        /**
         * QuDao num.
         * @member {number}num
         * @memberof pb.QuDao
         * @instance
         */
        QuDao.prototype.num = 0;

        /**
         * Creates a new QuDao instance using the specified properties.
         * @function create
         * @memberof pb.QuDao
         * @static
         * @param {pb.IQuDao=} [properties] Properties to set
         * @returns {pb.QuDao} QuDao instance
         */
        QuDao.create = function create(properties) {
            return new QuDao(properties);
        };

        /**
         * Encodes the specified QuDao message. Does not implicitly {@link pb.QuDao.verify|verify} messages.
         * @function encode
         * @memberof pb.QuDao
         * @static
         * @param {pb.IQuDao} message QuDao message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        QuDao.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.name != null && message.hasOwnProperty("name"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
            if (message.qus != null && message.qus.length)
                for (var i = 0; i < message.qus.length; ++i)
                    $root.pb.Qu.encode(message.qus[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.qqQun != null && message.hasOwnProperty("qqQun"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.qqQun);
            if (message.num != null && message.hasOwnProperty("num"))
                writer.uint32(/* id 4, wireType 0 =*/32).int32(message.num);
            return writer;
        };

        /**
         * Encodes the specified QuDao message, length delimited. Does not implicitly {@link pb.QuDao.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.QuDao
         * @static
         * @param {pb.IQuDao} message QuDao message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        QuDao.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a QuDao message from the specified reader or buffer.
         * @function decode
         * @memberof pb.QuDao
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.QuDao} QuDao
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        QuDao.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.QuDao();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.name = reader.string();
                    break;
                case 2:
                    if (!(message.qus && message.qus.length))
                        message.qus = [];
                    message.qus.push($root.pb.Qu.decode(reader, reader.uint32()));
                    break;
                case 3:
                    message.qqQun = reader.string();
                    break;
                case 4:
                    message.num = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a QuDao message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.QuDao
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.QuDao} QuDao
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        QuDao.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a QuDao message.
         * @function verify
         * @memberof pb.QuDao
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        QuDao.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.name != null && message.hasOwnProperty("name"))
                if (!$util.isString(message.name))
                    return "name: string expected";
            if (message.qus != null && message.hasOwnProperty("qus")) {
                if (!Array.isArray(message.qus))
                    return "qus: array expected";
                for (var i = 0; i < message.qus.length; ++i) {
                    var error = $root.pb.Qu.verify(message.qus[i]);
                    if (error)
                        return "qus." + error;
                }
            }
            if (message.qqQun != null && message.hasOwnProperty("qqQun"))
                if (!$util.isString(message.qqQun))
                    return "qqQun: string expected";
            if (message.num != null && message.hasOwnProperty("num"))
                if (!$util.isInteger(message.num))
                    return "num: integer expected";
            return null;
        };

        /**
         * Creates a QuDao message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.QuDao
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.QuDao} QuDao
         */
        QuDao.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.QuDao)
                return object;
            var message = new $root.pb.QuDao();
            if (object.name != null)
                message.name = String(object.name);
            if (object.qus) {
                if (!Array.isArray(object.qus))
                    throw TypeError(".pb.QuDao.qus: array expected");
                message.qus = [];
                for (var i = 0; i < object.qus.length; ++i) {
                    if (typeof object.qus[i] !== "object")
                        throw TypeError(".pb.QuDao.qus: object expected");
                    message.qus[i] = $root.pb.Qu.fromObject(object.qus[i]);
                }
            }
            if (object.qqQun != null)
                message.qqQun = String(object.qqQun);
            if (object.num != null)
                message.num = object.num | 0;
            return message;
        };

        /**
         * Creates a plain object from a QuDao message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.QuDao
         * @static
         * @param {pb.QuDao} message QuDao
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        QuDao.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.qus = [];
            if (options.defaults) {
                object.name = "";
                object.qqQun = "";
                object.num = 0;
            }
            if (message.name != null && message.hasOwnProperty("name"))
                object.name = message.name;
            if (message.qus && message.qus.length) {
                object.qus = [];
                for (var j = 0; j < message.qus.length; ++j)
                    object.qus[j] = $root.pb.Qu.toObject(message.qus[j], options);
            }
            if (message.qqQun != null && message.hasOwnProperty("qqQun"))
                object.qqQun = message.qqQun;
            if (message.num != null && message.hasOwnProperty("num"))
                object.num = message.num;
            return object;
        };

        /**
         * Converts this QuDao to JSON.
         * @function toJSON
         * @memberof pb.QuDao
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        QuDao.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return QuDao;
    })();

    pb.YouXi = (function() {

        /**
         * Properties of a YouXi.
         * @memberof pb
         * @interface IYouXi
         * @property {string} [name] YouXi name
         * @property {Object.<string,pb.IQuDao>} [quDaoMap] YouXi quDaoMap
         * @property {number} [num] YouXi num
         */

        /**
         * Constructs a new YouXi.
         * @memberof pb
         * @classdesc Represents a YouXi.
         * @constructor
         * @param {pb.IYouXi=} [properties] Properties to set
         */
        function YouXi(properties) {
            this.quDaoMap = {};
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * YouXi name.
         * @member {string}name
         * @memberof pb.YouXi
         * @instance
         */
        YouXi.prototype.name = "";

        /**
         * YouXi quDaoMap.
         * @member {Object.<string,pb.IQuDao>}quDaoMap
         * @memberof pb.YouXi
         * @instance
         */
        YouXi.prototype.quDaoMap = $util.emptyObject;

        /**
         * YouXi num.
         * @member {number}num
         * @memberof pb.YouXi
         * @instance
         */
        YouXi.prototype.num = 0;

        /**
         * Creates a new YouXi instance using the specified properties.
         * @function create
         * @memberof pb.YouXi
         * @static
         * @param {pb.IYouXi=} [properties] Properties to set
         * @returns {pb.YouXi} YouXi instance
         */
        YouXi.create = function create(properties) {
            return new YouXi(properties);
        };

        /**
         * Encodes the specified YouXi message. Does not implicitly {@link pb.YouXi.verify|verify} messages.
         * @function encode
         * @memberof pb.YouXi
         * @static
         * @param {pb.IYouXi} message YouXi message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        YouXi.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.name != null && message.hasOwnProperty("name"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
            if (message.quDaoMap != null && message.hasOwnProperty("quDaoMap"))
                for (var keys = Object.keys(message.quDaoMap), i = 0; i < keys.length; ++i) {
                    writer.uint32(/* id 2, wireType 2 =*/18).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]);
                    $root.pb.QuDao.encode(message.quDaoMap[keys[i]], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim().ldelim();
                }
            if (message.num != null && message.hasOwnProperty("num"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.num);
            return writer;
        };

        /**
         * Encodes the specified YouXi message, length delimited. Does not implicitly {@link pb.YouXi.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.YouXi
         * @static
         * @param {pb.IYouXi} message YouXi message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        YouXi.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a YouXi message from the specified reader or buffer.
         * @function decode
         * @memberof pb.YouXi
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.YouXi} YouXi
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        YouXi.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.YouXi(), key;
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.name = reader.string();
                    break;
                case 2:
                    reader.skip().pos++;
                    if (message.quDaoMap === $util.emptyObject)
                        message.quDaoMap = {};
                    key = reader.string();
                    reader.pos++;
                    message.quDaoMap[key] = $root.pb.QuDao.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.num = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a YouXi message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.YouXi
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.YouXi} YouXi
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        YouXi.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a YouXi message.
         * @function verify
         * @memberof pb.YouXi
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        YouXi.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.name != null && message.hasOwnProperty("name"))
                if (!$util.isString(message.name))
                    return "name: string expected";
            if (message.quDaoMap != null && message.hasOwnProperty("quDaoMap")) {
                if (!$util.isObject(message.quDaoMap))
                    return "quDaoMap: object expected";
                var key = Object.keys(message.quDaoMap);
                for (var i = 0; i < key.length; ++i) {
                    var error = $root.pb.QuDao.verify(message.quDaoMap[key[i]]);
                    if (error)
                        return "quDaoMap." + error;
                }
            }
            if (message.num != null && message.hasOwnProperty("num"))
                if (!$util.isInteger(message.num))
                    return "num: integer expected";
            return null;
        };

        /**
         * Creates a YouXi message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.YouXi
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.YouXi} YouXi
         */
        YouXi.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.YouXi)
                return object;
            var message = new $root.pb.YouXi();
            if (object.name != null)
                message.name = String(object.name);
            if (object.quDaoMap) {
                if (typeof object.quDaoMap !== "object")
                    throw TypeError(".pb.YouXi.quDaoMap: object expected");
                message.quDaoMap = {};
                for (var keys = Object.keys(object.quDaoMap), i = 0; i < keys.length; ++i) {
                    if (typeof object.quDaoMap[keys[i]] !== "object")
                        throw TypeError(".pb.YouXi.quDaoMap: object expected");
                    message.quDaoMap[keys[i]] = $root.pb.QuDao.fromObject(object.quDaoMap[keys[i]]);
                }
            }
            if (object.num != null)
                message.num = object.num | 0;
            return message;
        };

        /**
         * Creates a plain object from a YouXi message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.YouXi
         * @static
         * @param {pb.YouXi} message YouXi
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        YouXi.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.objects || options.defaults)
                object.quDaoMap = {};
            if (options.defaults) {
                object.name = "";
                object.num = 0;
            }
            if (message.name != null && message.hasOwnProperty("name"))
                object.name = message.name;
            var keys2;
            if (message.quDaoMap && (keys2 = Object.keys(message.quDaoMap)).length) {
                object.quDaoMap = {};
                for (var j = 0; j < keys2.length; ++j)
                    object.quDaoMap[keys2[j]] = $root.pb.QuDao.toObject(message.quDaoMap[keys2[j]], options);
            }
            if (message.num != null && message.hasOwnProperty("num"))
                object.num = message.num;
            return object;
        };

        /**
         * Converts this YouXi to JSON.
         * @function toJSON
         * @memberof pb.YouXi
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        YouXi.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return YouXi;
    })();

    pb.YouXis = (function() {

        /**
         * Properties of a YouXis.
         * @memberof pb
         * @interface IYouXis
         * @property {string} [accId] YouXis accId
         * @property {Object.<string,pb.IYouXi>} [gameMap] YouXis gameMap
         */

        /**
         * Constructs a new YouXis.
         * @memberof pb
         * @classdesc Represents a YouXis.
         * @constructor
         * @param {pb.IYouXis=} [properties] Properties to set
         */
        function YouXis(properties) {
            this.gameMap = {};
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * YouXis accId.
         * @member {string}accId
         * @memberof pb.YouXis
         * @instance
         */
        YouXis.prototype.accId = "";

        /**
         * YouXis gameMap.
         * @member {Object.<string,pb.IYouXi>}gameMap
         * @memberof pb.YouXis
         * @instance
         */
        YouXis.prototype.gameMap = $util.emptyObject;

        /**
         * Creates a new YouXis instance using the specified properties.
         * @function create
         * @memberof pb.YouXis
         * @static
         * @param {pb.IYouXis=} [properties] Properties to set
         * @returns {pb.YouXis} YouXis instance
         */
        YouXis.create = function create(properties) {
            return new YouXis(properties);
        };

        /**
         * Encodes the specified YouXis message. Does not implicitly {@link pb.YouXis.verify|verify} messages.
         * @function encode
         * @memberof pb.YouXis
         * @static
         * @param {pb.IYouXis} message YouXis message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        YouXis.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.accId != null && message.hasOwnProperty("accId"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.accId);
            if (message.gameMap != null && message.hasOwnProperty("gameMap"))
                for (var keys = Object.keys(message.gameMap), i = 0; i < keys.length; ++i) {
                    writer.uint32(/* id 2, wireType 2 =*/18).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]);
                    $root.pb.YouXi.encode(message.gameMap[keys[i]], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim().ldelim();
                }
            return writer;
        };

        /**
         * Encodes the specified YouXis message, length delimited. Does not implicitly {@link pb.YouXis.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.YouXis
         * @static
         * @param {pb.IYouXis} message YouXis message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        YouXis.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a YouXis message from the specified reader or buffer.
         * @function decode
         * @memberof pb.YouXis
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.YouXis} YouXis
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        YouXis.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.YouXis(), key;
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.accId = reader.string();
                    break;
                case 2:
                    reader.skip().pos++;
                    if (message.gameMap === $util.emptyObject)
                        message.gameMap = {};
                    key = reader.string();
                    reader.pos++;
                    message.gameMap[key] = $root.pb.YouXi.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a YouXis message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.YouXis
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.YouXis} YouXis
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        YouXis.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a YouXis message.
         * @function verify
         * @memberof pb.YouXis
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        YouXis.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.accId != null && message.hasOwnProperty("accId"))
                if (!$util.isString(message.accId))
                    return "accId: string expected";
            if (message.gameMap != null && message.hasOwnProperty("gameMap")) {
                if (!$util.isObject(message.gameMap))
                    return "gameMap: object expected";
                var key = Object.keys(message.gameMap);
                for (var i = 0; i < key.length; ++i) {
                    var error = $root.pb.YouXi.verify(message.gameMap[key[i]]);
                    if (error)
                        return "gameMap." + error;
                }
            }
            return null;
        };

        /**
         * Creates a YouXis message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.YouXis
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.YouXis} YouXis
         */
        YouXis.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.YouXis)
                return object;
            var message = new $root.pb.YouXis();
            if (object.accId != null)
                message.accId = String(object.accId);
            if (object.gameMap) {
                if (typeof object.gameMap !== "object")
                    throw TypeError(".pb.YouXis.gameMap: object expected");
                message.gameMap = {};
                for (var keys = Object.keys(object.gameMap), i = 0; i < keys.length; ++i) {
                    if (typeof object.gameMap[keys[i]] !== "object")
                        throw TypeError(".pb.YouXis.gameMap: object expected");
                    message.gameMap[keys[i]] = $root.pb.YouXi.fromObject(object.gameMap[keys[i]]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a YouXis message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.YouXis
         * @static
         * @param {pb.YouXis} message YouXis
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        YouXis.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.objects || options.defaults)
                object.gameMap = {};
            if (options.defaults)
                object.accId = "";
            if (message.accId != null && message.hasOwnProperty("accId"))
                object.accId = message.accId;
            var keys2;
            if (message.gameMap && (keys2 = Object.keys(message.gameMap)).length) {
                object.gameMap = {};
                for (var j = 0; j < keys2.length; ++j)
                    object.gameMap[keys2[j]] = $root.pb.YouXi.toObject(message.gameMap[keys2[j]], options);
            }
            return object;
        };

        /**
         * Converts this YouXis to JSON.
         * @function toJSON
         * @memberof pb.YouXis
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        YouXis.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return YouXis;
    })();

    pb.YouXiChange = (function() {

        /**
         * Properties of a YouXiChange.
         * @memberof pb
         * @interface IYouXiChange
         * @property {string} [nameOld] YouXiChange nameOld
         * @property {pb.IYouXi} [yx] YouXiChange yx
         */

        /**
         * Constructs a new YouXiChange.
         * @memberof pb
         * @classdesc Represents a YouXiChange.
         * @constructor
         * @param {pb.IYouXiChange=} [properties] Properties to set
         */
        function YouXiChange(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * YouXiChange nameOld.
         * @member {string}nameOld
         * @memberof pb.YouXiChange
         * @instance
         */
        YouXiChange.prototype.nameOld = "";

        /**
         * YouXiChange yx.
         * @member {(pb.IYouXi|null|undefined)}yx
         * @memberof pb.YouXiChange
         * @instance
         */
        YouXiChange.prototype.yx = null;

        /**
         * Creates a new YouXiChange instance using the specified properties.
         * @function create
         * @memberof pb.YouXiChange
         * @static
         * @param {pb.IYouXiChange=} [properties] Properties to set
         * @returns {pb.YouXiChange} YouXiChange instance
         */
        YouXiChange.create = function create(properties) {
            return new YouXiChange(properties);
        };

        /**
         * Encodes the specified YouXiChange message. Does not implicitly {@link pb.YouXiChange.verify|verify} messages.
         * @function encode
         * @memberof pb.YouXiChange
         * @static
         * @param {pb.IYouXiChange} message YouXiChange message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        YouXiChange.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.nameOld != null && message.hasOwnProperty("nameOld"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.nameOld);
            if (message.yx != null && message.hasOwnProperty("yx"))
                $root.pb.YouXi.encode(message.yx, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified YouXiChange message, length delimited. Does not implicitly {@link pb.YouXiChange.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.YouXiChange
         * @static
         * @param {pb.IYouXiChange} message YouXiChange message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        YouXiChange.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a YouXiChange message from the specified reader or buffer.
         * @function decode
         * @memberof pb.YouXiChange
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.YouXiChange} YouXiChange
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        YouXiChange.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.YouXiChange();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.nameOld = reader.string();
                    break;
                case 2:
                    message.yx = $root.pb.YouXi.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a YouXiChange message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.YouXiChange
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.YouXiChange} YouXiChange
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        YouXiChange.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a YouXiChange message.
         * @function verify
         * @memberof pb.YouXiChange
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        YouXiChange.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.nameOld != null && message.hasOwnProperty("nameOld"))
                if (!$util.isString(message.nameOld))
                    return "nameOld: string expected";
            if (message.yx != null && message.hasOwnProperty("yx")) {
                var error = $root.pb.YouXi.verify(message.yx);
                if (error)
                    return "yx." + error;
            }
            return null;
        };

        /**
         * Creates a YouXiChange message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.YouXiChange
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.YouXiChange} YouXiChange
         */
        YouXiChange.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.YouXiChange)
                return object;
            var message = new $root.pb.YouXiChange();
            if (object.nameOld != null)
                message.nameOld = String(object.nameOld);
            if (object.yx != null) {
                if (typeof object.yx !== "object")
                    throw TypeError(".pb.YouXiChange.yx: object expected");
                message.yx = $root.pb.YouXi.fromObject(object.yx);
            }
            return message;
        };

        /**
         * Creates a plain object from a YouXiChange message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.YouXiChange
         * @static
         * @param {pb.YouXiChange} message YouXiChange
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        YouXiChange.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.nameOld = "";
                object.yx = null;
            }
            if (message.nameOld != null && message.hasOwnProperty("nameOld"))
                object.nameOld = message.nameOld;
            if (message.yx != null && message.hasOwnProperty("yx"))
                object.yx = $root.pb.YouXi.toObject(message.yx, options);
            return object;
        };

        /**
         * Converts this YouXiChange to JSON.
         * @function toJSON
         * @memberof pb.YouXiChange
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        YouXiChange.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return YouXiChange;
    })();

    pb.YouXiDel = (function() {

        /**
         * Properties of a YouXiDel.
         * @memberof pb
         * @interface IYouXiDel
         * @property {string} [name] YouXiDel name
         */

        /**
         * Constructs a new YouXiDel.
         * @memberof pb
         * @classdesc Represents a YouXiDel.
         * @constructor
         * @param {pb.IYouXiDel=} [properties] Properties to set
         */
        function YouXiDel(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * YouXiDel name.
         * @member {string}name
         * @memberof pb.YouXiDel
         * @instance
         */
        YouXiDel.prototype.name = "";

        /**
         * Creates a new YouXiDel instance using the specified properties.
         * @function create
         * @memberof pb.YouXiDel
         * @static
         * @param {pb.IYouXiDel=} [properties] Properties to set
         * @returns {pb.YouXiDel} YouXiDel instance
         */
        YouXiDel.create = function create(properties) {
            return new YouXiDel(properties);
        };

        /**
         * Encodes the specified YouXiDel message. Does not implicitly {@link pb.YouXiDel.verify|verify} messages.
         * @function encode
         * @memberof pb.YouXiDel
         * @static
         * @param {pb.IYouXiDel} message YouXiDel message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        YouXiDel.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.name != null && message.hasOwnProperty("name"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
            return writer;
        };

        /**
         * Encodes the specified YouXiDel message, length delimited. Does not implicitly {@link pb.YouXiDel.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.YouXiDel
         * @static
         * @param {pb.IYouXiDel} message YouXiDel message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        YouXiDel.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a YouXiDel message from the specified reader or buffer.
         * @function decode
         * @memberof pb.YouXiDel
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.YouXiDel} YouXiDel
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        YouXiDel.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.YouXiDel();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.name = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a YouXiDel message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.YouXiDel
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.YouXiDel} YouXiDel
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        YouXiDel.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a YouXiDel message.
         * @function verify
         * @memberof pb.YouXiDel
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        YouXiDel.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.name != null && message.hasOwnProperty("name"))
                if (!$util.isString(message.name))
                    return "name: string expected";
            return null;
        };

        /**
         * Creates a YouXiDel message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.YouXiDel
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.YouXiDel} YouXiDel
         */
        YouXiDel.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.YouXiDel)
                return object;
            var message = new $root.pb.YouXiDel();
            if (object.name != null)
                message.name = String(object.name);
            return message;
        };

        /**
         * Creates a plain object from a YouXiDel message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.YouXiDel
         * @static
         * @param {pb.YouXiDel} message YouXiDel
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        YouXiDel.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.name = "";
            if (message.name != null && message.hasOwnProperty("name"))
                object.name = message.name;
            return object;
        };

        /**
         * Converts this YouXiDel to JSON.
         * @function toJSON
         * @memberof pb.YouXiDel
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        YouXiDel.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return YouXiDel;
    })();

    pb.ResString = (function() {

        /**
         * Properties of a ResString.
         * @memberof pb
         * @interface IResString
         * @property {string} [res] ResString res
         */

        /**
         * Constructs a new ResString.
         * @memberof pb
         * @classdesc Represents a ResString.
         * @constructor
         * @param {pb.IResString=} [properties] Properties to set
         */
        function ResString(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ResString res.
         * @member {string}res
         * @memberof pb.ResString
         * @instance
         */
        ResString.prototype.res = "";

        /**
         * Creates a new ResString instance using the specified properties.
         * @function create
         * @memberof pb.ResString
         * @static
         * @param {pb.IResString=} [properties] Properties to set
         * @returns {pb.ResString} ResString instance
         */
        ResString.create = function create(properties) {
            return new ResString(properties);
        };

        /**
         * Encodes the specified ResString message. Does not implicitly {@link pb.ResString.verify|verify} messages.
         * @function encode
         * @memberof pb.ResString
         * @static
         * @param {pb.IResString} message ResString message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ResString.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.res != null && message.hasOwnProperty("res"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.res);
            return writer;
        };

        /**
         * Encodes the specified ResString message, length delimited. Does not implicitly {@link pb.ResString.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.ResString
         * @static
         * @param {pb.IResString} message ResString message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ResString.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ResString message from the specified reader or buffer.
         * @function decode
         * @memberof pb.ResString
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.ResString} ResString
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ResString.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.ResString();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.res = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ResString message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.ResString
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.ResString} ResString
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ResString.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ResString message.
         * @function verify
         * @memberof pb.ResString
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ResString.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.res != null && message.hasOwnProperty("res"))
                if (!$util.isString(message.res))
                    return "res: string expected";
            return null;
        };

        /**
         * Creates a ResString message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.ResString
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.ResString} ResString
         */
        ResString.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.ResString)
                return object;
            var message = new $root.pb.ResString();
            if (object.res != null)
                message.res = String(object.res);
            return message;
        };

        /**
         * Creates a plain object from a ResString message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.ResString
         * @static
         * @param {pb.ResString} message ResString
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ResString.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.res = "";
            if (message.res != null && message.hasOwnProperty("res"))
                object.res = message.res;
            return object;
        };

        /**
         * Converts this ResString to JSON.
         * @function toJSON
         * @memberof pb.ResString
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ResString.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ResString;
    })();

    pb.GiveItem = (function() {

        /**
         * Properties of a GiveItem.
         * @memberof pb
         * @interface IGiveItem
         * @property {string} [roleId] GiveItem roleId
         * @property {string} [title] GiveItem title
         * @property {string} [content] GiveItem content
         * @property {string} [items] GiveItem items
         * @property {string} [game] GiveItem game
         * @property {string} [qd] GiveItem qd
         * @property {number} [qu] GiveItem qu
         * @property {boolean} [isAll] GiveItem isAll
         */

        /**
         * Constructs a new GiveItem.
         * @memberof pb
         * @classdesc Represents a GiveItem.
         * @constructor
         * @param {pb.IGiveItem=} [properties] Properties to set
         */
        function GiveItem(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * GiveItem roleId.
         * @member {string}roleId
         * @memberof pb.GiveItem
         * @instance
         */
        GiveItem.prototype.roleId = "";

        /**
         * GiveItem title.
         * @member {string}title
         * @memberof pb.GiveItem
         * @instance
         */
        GiveItem.prototype.title = "";

        /**
         * GiveItem content.
         * @member {string}content
         * @memberof pb.GiveItem
         * @instance
         */
        GiveItem.prototype.content = "";

        /**
         * GiveItem items.
         * @member {string}items
         * @memberof pb.GiveItem
         * @instance
         */
        GiveItem.prototype.items = "";

        /**
         * GiveItem game.
         * @member {string}game
         * @memberof pb.GiveItem
         * @instance
         */
        GiveItem.prototype.game = "";

        /**
         * GiveItem qd.
         * @member {string}qd
         * @memberof pb.GiveItem
         * @instance
         */
        GiveItem.prototype.qd = "";

        /**
         * GiveItem qu.
         * @member {number}qu
         * @memberof pb.GiveItem
         * @instance
         */
        GiveItem.prototype.qu = 0;

        /**
         * GiveItem isAll.
         * @member {boolean}isAll
         * @memberof pb.GiveItem
         * @instance
         */
        GiveItem.prototype.isAll = false;

        /**
         * Creates a new GiveItem instance using the specified properties.
         * @function create
         * @memberof pb.GiveItem
         * @static
         * @param {pb.IGiveItem=} [properties] Properties to set
         * @returns {pb.GiveItem} GiveItem instance
         */
        GiveItem.create = function create(properties) {
            return new GiveItem(properties);
        };

        /**
         * Encodes the specified GiveItem message. Does not implicitly {@link pb.GiveItem.verify|verify} messages.
         * @function encode
         * @memberof pb.GiveItem
         * @static
         * @param {pb.IGiveItem} message GiveItem message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        GiveItem.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.roleId != null && message.hasOwnProperty("roleId"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.roleId);
            if (message.title != null && message.hasOwnProperty("title"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.title);
            if (message.content != null && message.hasOwnProperty("content"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.content);
            if (message.items != null && message.hasOwnProperty("items"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.items);
            if (message.game != null && message.hasOwnProperty("game"))
                writer.uint32(/* id 5, wireType 2 =*/42).string(message.game);
            if (message.qd != null && message.hasOwnProperty("qd"))
                writer.uint32(/* id 6, wireType 2 =*/50).string(message.qd);
            if (message.qu != null && message.hasOwnProperty("qu"))
                writer.uint32(/* id 7, wireType 0 =*/56).int32(message.qu);
            if (message.isAll != null && message.hasOwnProperty("isAll"))
                writer.uint32(/* id 8, wireType 0 =*/64).bool(message.isAll);
            return writer;
        };

        /**
         * Encodes the specified GiveItem message, length delimited. Does not implicitly {@link pb.GiveItem.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.GiveItem
         * @static
         * @param {pb.IGiveItem} message GiveItem message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        GiveItem.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a GiveItem message from the specified reader or buffer.
         * @function decode
         * @memberof pb.GiveItem
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.GiveItem} GiveItem
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        GiveItem.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.GiveItem();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.roleId = reader.string();
                    break;
                case 2:
                    message.title = reader.string();
                    break;
                case 3:
                    message.content = reader.string();
                    break;
                case 4:
                    message.items = reader.string();
                    break;
                case 5:
                    message.game = reader.string();
                    break;
                case 6:
                    message.qd = reader.string();
                    break;
                case 7:
                    message.qu = reader.int32();
                    break;
                case 8:
                    message.isAll = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a GiveItem message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.GiveItem
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.GiveItem} GiveItem
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        GiveItem.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a GiveItem message.
         * @function verify
         * @memberof pb.GiveItem
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        GiveItem.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.roleId != null && message.hasOwnProperty("roleId"))
                if (!$util.isString(message.roleId))
                    return "roleId: string expected";
            if (message.title != null && message.hasOwnProperty("title"))
                if (!$util.isString(message.title))
                    return "title: string expected";
            if (message.content != null && message.hasOwnProperty("content"))
                if (!$util.isString(message.content))
                    return "content: string expected";
            if (message.items != null && message.hasOwnProperty("items"))
                if (!$util.isString(message.items))
                    return "items: string expected";
            if (message.game != null && message.hasOwnProperty("game"))
                if (!$util.isString(message.game))
                    return "game: string expected";
            if (message.qd != null && message.hasOwnProperty("qd"))
                if (!$util.isString(message.qd))
                    return "qd: string expected";
            if (message.qu != null && message.hasOwnProperty("qu"))
                if (!$util.isInteger(message.qu))
                    return "qu: integer expected";
            if (message.isAll != null && message.hasOwnProperty("isAll"))
                if (typeof message.isAll !== "boolean")
                    return "isAll: boolean expected";
            return null;
        };

        /**
         * Creates a GiveItem message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.GiveItem
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.GiveItem} GiveItem
         */
        GiveItem.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.GiveItem)
                return object;
            var message = new $root.pb.GiveItem();
            if (object.roleId != null)
                message.roleId = String(object.roleId);
            if (object.title != null)
                message.title = String(object.title);
            if (object.content != null)
                message.content = String(object.content);
            if (object.items != null)
                message.items = String(object.items);
            if (object.game != null)
                message.game = String(object.game);
            if (object.qd != null)
                message.qd = String(object.qd);
            if (object.qu != null)
                message.qu = object.qu | 0;
            if (object.isAll != null)
                message.isAll = Boolean(object.isAll);
            return message;
        };

        /**
         * Creates a plain object from a GiveItem message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.GiveItem
         * @static
         * @param {pb.GiveItem} message GiveItem
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        GiveItem.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.roleId = "";
                object.title = "";
                object.content = "";
                object.items = "";
                object.game = "";
                object.qd = "";
                object.qu = 0;
                object.isAll = false;
            }
            if (message.roleId != null && message.hasOwnProperty("roleId"))
                object.roleId = message.roleId;
            if (message.title != null && message.hasOwnProperty("title"))
                object.title = message.title;
            if (message.content != null && message.hasOwnProperty("content"))
                object.content = message.content;
            if (message.items != null && message.hasOwnProperty("items"))
                object.items = message.items;
            if (message.game != null && message.hasOwnProperty("game"))
                object.game = message.game;
            if (message.qd != null && message.hasOwnProperty("qd"))
                object.qd = message.qd;
            if (message.qu != null && message.hasOwnProperty("qu"))
                object.qu = message.qu;
            if (message.isAll != null && message.hasOwnProperty("isAll"))
                object.isAll = message.isAll;
            return object;
        };

        /**
         * Converts this GiveItem to JSON.
         * @function toJSON
         * @memberof pb.GiveItem
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        GiveItem.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return GiveItem;
    })();

    pb.GiveLiBao = (function() {

        /**
         * Properties of a GiveLiBao.
         * @memberof pb
         * @interface IGiveLiBao
         * @property {string} [roleId] GiveLiBao roleId
         * @property {number} [liBaoId] GiveLiBao liBaoId
         * @property {string} [game] GiveLiBao game
         * @property {string} [qd] GiveLiBao qd
         * @property {number} [qu] GiveLiBao qu
         * @property {boolean} [isAll] GiveLiBao isAll
         */

        /**
         * Constructs a new GiveLiBao.
         * @memberof pb
         * @classdesc Represents a GiveLiBao.
         * @constructor
         * @param {pb.IGiveLiBao=} [properties] Properties to set
         */
        function GiveLiBao(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * GiveLiBao roleId.
         * @member {string}roleId
         * @memberof pb.GiveLiBao
         * @instance
         */
        GiveLiBao.prototype.roleId = "";

        /**
         * GiveLiBao liBaoId.
         * @member {number}liBaoId
         * @memberof pb.GiveLiBao
         * @instance
         */
        GiveLiBao.prototype.liBaoId = 0;

        /**
         * GiveLiBao game.
         * @member {string}game
         * @memberof pb.GiveLiBao
         * @instance
         */
        GiveLiBao.prototype.game = "";

        /**
         * GiveLiBao qd.
         * @member {string}qd
         * @memberof pb.GiveLiBao
         * @instance
         */
        GiveLiBao.prototype.qd = "";

        /**
         * GiveLiBao qu.
         * @member {number}qu
         * @memberof pb.GiveLiBao
         * @instance
         */
        GiveLiBao.prototype.qu = 0;

        /**
         * GiveLiBao isAll.
         * @member {boolean}isAll
         * @memberof pb.GiveLiBao
         * @instance
         */
        GiveLiBao.prototype.isAll = false;

        /**
         * Creates a new GiveLiBao instance using the specified properties.
         * @function create
         * @memberof pb.GiveLiBao
         * @static
         * @param {pb.IGiveLiBao=} [properties] Properties to set
         * @returns {pb.GiveLiBao} GiveLiBao instance
         */
        GiveLiBao.create = function create(properties) {
            return new GiveLiBao(properties);
        };

        /**
         * Encodes the specified GiveLiBao message. Does not implicitly {@link pb.GiveLiBao.verify|verify} messages.
         * @function encode
         * @memberof pb.GiveLiBao
         * @static
         * @param {pb.IGiveLiBao} message GiveLiBao message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        GiveLiBao.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.roleId != null && message.hasOwnProperty("roleId"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.roleId);
            if (message.liBaoId != null && message.hasOwnProperty("liBaoId"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.liBaoId);
            if (message.game != null && message.hasOwnProperty("game"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.game);
            if (message.qd != null && message.hasOwnProperty("qd"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.qd);
            if (message.qu != null && message.hasOwnProperty("qu"))
                writer.uint32(/* id 5, wireType 0 =*/40).int32(message.qu);
            if (message.isAll != null && message.hasOwnProperty("isAll"))
                writer.uint32(/* id 6, wireType 0 =*/48).bool(message.isAll);
            return writer;
        };

        /**
         * Encodes the specified GiveLiBao message, length delimited. Does not implicitly {@link pb.GiveLiBao.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.GiveLiBao
         * @static
         * @param {pb.IGiveLiBao} message GiveLiBao message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        GiveLiBao.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a GiveLiBao message from the specified reader or buffer.
         * @function decode
         * @memberof pb.GiveLiBao
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.GiveLiBao} GiveLiBao
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        GiveLiBao.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.GiveLiBao();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.roleId = reader.string();
                    break;
                case 2:
                    message.liBaoId = reader.int32();
                    break;
                case 3:
                    message.game = reader.string();
                    break;
                case 4:
                    message.qd = reader.string();
                    break;
                case 5:
                    message.qu = reader.int32();
                    break;
                case 6:
                    message.isAll = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a GiveLiBao message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.GiveLiBao
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.GiveLiBao} GiveLiBao
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        GiveLiBao.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a GiveLiBao message.
         * @function verify
         * @memberof pb.GiveLiBao
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        GiveLiBao.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.roleId != null && message.hasOwnProperty("roleId"))
                if (!$util.isString(message.roleId))
                    return "roleId: string expected";
            if (message.liBaoId != null && message.hasOwnProperty("liBaoId"))
                if (!$util.isInteger(message.liBaoId))
                    return "liBaoId: integer expected";
            if (message.game != null && message.hasOwnProperty("game"))
                if (!$util.isString(message.game))
                    return "game: string expected";
            if (message.qd != null && message.hasOwnProperty("qd"))
                if (!$util.isString(message.qd))
                    return "qd: string expected";
            if (message.qu != null && message.hasOwnProperty("qu"))
                if (!$util.isInteger(message.qu))
                    return "qu: integer expected";
            if (message.isAll != null && message.hasOwnProperty("isAll"))
                if (typeof message.isAll !== "boolean")
                    return "isAll: boolean expected";
            return null;
        };

        /**
         * Creates a GiveLiBao message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.GiveLiBao
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.GiveLiBao} GiveLiBao
         */
        GiveLiBao.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.GiveLiBao)
                return object;
            var message = new $root.pb.GiveLiBao();
            if (object.roleId != null)
                message.roleId = String(object.roleId);
            if (object.liBaoId != null)
                message.liBaoId = object.liBaoId | 0;
            if (object.game != null)
                message.game = String(object.game);
            if (object.qd != null)
                message.qd = String(object.qd);
            if (object.qu != null)
                message.qu = object.qu | 0;
            if (object.isAll != null)
                message.isAll = Boolean(object.isAll);
            return message;
        };

        /**
         * Creates a plain object from a GiveLiBao message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.GiveLiBao
         * @static
         * @param {pb.GiveLiBao} message GiveLiBao
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        GiveLiBao.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.roleId = "";
                object.liBaoId = 0;
                object.game = "";
                object.qd = "";
                object.qu = 0;
                object.isAll = false;
            }
            if (message.roleId != null && message.hasOwnProperty("roleId"))
                object.roleId = message.roleId;
            if (message.liBaoId != null && message.hasOwnProperty("liBaoId"))
                object.liBaoId = message.liBaoId;
            if (message.game != null && message.hasOwnProperty("game"))
                object.game = message.game;
            if (message.qd != null && message.hasOwnProperty("qd"))
                object.qd = message.qd;
            if (message.qu != null && message.hasOwnProperty("qu"))
                object.qu = message.qu;
            if (message.isAll != null && message.hasOwnProperty("isAll"))
                object.isAll = message.isAll;
            return object;
        };

        /**
         * Converts this GiveLiBao to JSON.
         * @function toJSON
         * @memberof pb.GiveLiBao
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        GiveLiBao.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return GiveLiBao;
    })();

    pb.Look = (function() {

        /**
         * Properties of a Look.
         * @memberof pb
         * @interface ILook
         * @property {string} [game] Look game
         * @property {string} [qd] Look qd
         */

        /**
         * Constructs a new Look.
         * @memberof pb
         * @classdesc Represents a Look.
         * @constructor
         * @param {pb.ILook=} [properties] Properties to set
         */
        function Look(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Look game.
         * @member {string}game
         * @memberof pb.Look
         * @instance
         */
        Look.prototype.game = "";

        /**
         * Look qd.
         * @member {string}qd
         * @memberof pb.Look
         * @instance
         */
        Look.prototype.qd = "";

        /**
         * Creates a new Look instance using the specified properties.
         * @function create
         * @memberof pb.Look
         * @static
         * @param {pb.ILook=} [properties] Properties to set
         * @returns {pb.Look} Look instance
         */
        Look.create = function create(properties) {
            return new Look(properties);
        };

        /**
         * Encodes the specified Look message. Does not implicitly {@link pb.Look.verify|verify} messages.
         * @function encode
         * @memberof pb.Look
         * @static
         * @param {pb.ILook} message Look message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Look.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.game != null && message.hasOwnProperty("game"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.game);
            if (message.qd != null && message.hasOwnProperty("qd"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.qd);
            return writer;
        };

        /**
         * Encodes the specified Look message, length delimited. Does not implicitly {@link pb.Look.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.Look
         * @static
         * @param {pb.ILook} message Look message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Look.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Look message from the specified reader or buffer.
         * @function decode
         * @memberof pb.Look
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.Look} Look
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Look.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.Look();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.game = reader.string();
                    break;
                case 2:
                    message.qd = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a Look message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.Look
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.Look} Look
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Look.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Look message.
         * @function verify
         * @memberof pb.Look
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Look.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.game != null && message.hasOwnProperty("game"))
                if (!$util.isString(message.game))
                    return "game: string expected";
            if (message.qd != null && message.hasOwnProperty("qd"))
                if (!$util.isString(message.qd))
                    return "qd: string expected";
            return null;
        };

        /**
         * Creates a Look message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.Look
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.Look} Look
         */
        Look.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.Look)
                return object;
            var message = new $root.pb.Look();
            if (object.game != null)
                message.game = String(object.game);
            if (object.qd != null)
                message.qd = String(object.qd);
            return message;
        };

        /**
         * Creates a plain object from a Look message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.Look
         * @static
         * @param {pb.Look} message Look
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Look.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.game = "";
                object.qd = "";
            }
            if (message.game != null && message.hasOwnProperty("game"))
                object.game = message.game;
            if (message.qd != null && message.hasOwnProperty("qd"))
                object.qd = message.qd;
            return object;
        };

        /**
         * Converts this Look to JSON.
         * @function toJSON
         * @memberof pb.Look
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Look.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Look;
    })();

    pb.OpenQu = (function() {

        /**
         * Properties of an OpenQu.
         * @memberof pb
         * @interface IOpenQu
         * @property {string} [game] OpenQu game
         * @property {string} [qd] OpenQu qd
         * @property {number} [qu] OpenQu qu
         * @property {boolean} [isAll] OpenQu isAll
         */

        /**
         * Constructs a new OpenQu.
         * @memberof pb
         * @classdesc Represents an OpenQu.
         * @constructor
         * @param {pb.IOpenQu=} [properties] Properties to set
         */
        function OpenQu(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * OpenQu game.
         * @member {string}game
         * @memberof pb.OpenQu
         * @instance
         */
        OpenQu.prototype.game = "";

        /**
         * OpenQu qd.
         * @member {string}qd
         * @memberof pb.OpenQu
         * @instance
         */
        OpenQu.prototype.qd = "";

        /**
         * OpenQu qu.
         * @member {number}qu
         * @memberof pb.OpenQu
         * @instance
         */
        OpenQu.prototype.qu = 0;

        /**
         * OpenQu isAll.
         * @member {boolean}isAll
         * @memberof pb.OpenQu
         * @instance
         */
        OpenQu.prototype.isAll = false;

        /**
         * Creates a new OpenQu instance using the specified properties.
         * @function create
         * @memberof pb.OpenQu
         * @static
         * @param {pb.IOpenQu=} [properties] Properties to set
         * @returns {pb.OpenQu} OpenQu instance
         */
        OpenQu.create = function create(properties) {
            return new OpenQu(properties);
        };

        /**
         * Encodes the specified OpenQu message. Does not implicitly {@link pb.OpenQu.verify|verify} messages.
         * @function encode
         * @memberof pb.OpenQu
         * @static
         * @param {pb.IOpenQu} message OpenQu message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        OpenQu.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.game != null && message.hasOwnProperty("game"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.game);
            if (message.qd != null && message.hasOwnProperty("qd"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.qd);
            if (message.qu != null && message.hasOwnProperty("qu"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.qu);
            if (message.isAll != null && message.hasOwnProperty("isAll"))
                writer.uint32(/* id 4, wireType 0 =*/32).bool(message.isAll);
            return writer;
        };

        /**
         * Encodes the specified OpenQu message, length delimited. Does not implicitly {@link pb.OpenQu.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.OpenQu
         * @static
         * @param {pb.IOpenQu} message OpenQu message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        OpenQu.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an OpenQu message from the specified reader or buffer.
         * @function decode
         * @memberof pb.OpenQu
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.OpenQu} OpenQu
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        OpenQu.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.OpenQu();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.game = reader.string();
                    break;
                case 2:
                    message.qd = reader.string();
                    break;
                case 3:
                    message.qu = reader.int32();
                    break;
                case 4:
                    message.isAll = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an OpenQu message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.OpenQu
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.OpenQu} OpenQu
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        OpenQu.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an OpenQu message.
         * @function verify
         * @memberof pb.OpenQu
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        OpenQu.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.game != null && message.hasOwnProperty("game"))
                if (!$util.isString(message.game))
                    return "game: string expected";
            if (message.qd != null && message.hasOwnProperty("qd"))
                if (!$util.isString(message.qd))
                    return "qd: string expected";
            if (message.qu != null && message.hasOwnProperty("qu"))
                if (!$util.isInteger(message.qu))
                    return "qu: integer expected";
            if (message.isAll != null && message.hasOwnProperty("isAll"))
                if (typeof message.isAll !== "boolean")
                    return "isAll: boolean expected";
            return null;
        };

        /**
         * Creates an OpenQu message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.OpenQu
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.OpenQu} OpenQu
         */
        OpenQu.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.OpenQu)
                return object;
            var message = new $root.pb.OpenQu();
            if (object.game != null)
                message.game = String(object.game);
            if (object.qd != null)
                message.qd = String(object.qd);
            if (object.qu != null)
                message.qu = object.qu | 0;
            if (object.isAll != null)
                message.isAll = Boolean(object.isAll);
            return message;
        };

        /**
         * Creates a plain object from an OpenQu message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.OpenQu
         * @static
         * @param {pb.OpenQu} message OpenQu
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        OpenQu.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.game = "";
                object.qd = "";
                object.qu = 0;
                object.isAll = false;
            }
            if (message.game != null && message.hasOwnProperty("game"))
                object.game = message.game;
            if (message.qd != null && message.hasOwnProperty("qd"))
                object.qd = message.qd;
            if (message.qu != null && message.hasOwnProperty("qu"))
                object.qu = message.qu;
            if (message.isAll != null && message.hasOwnProperty("isAll"))
                object.isAll = message.isAll;
            return object;
        };

        /**
         * Converts this OpenQu to JSON.
         * @function toJSON
         * @memberof pb.OpenQu
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        OpenQu.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return OpenQu;
    })();

    pb.CloseQu = (function() {

        /**
         * Properties of a CloseQu.
         * @memberof pb
         * @interface ICloseQu
         * @property {string} [game] CloseQu game
         * @property {string} [qd] CloseQu qd
         * @property {number} [qu] CloseQu qu
         * @property {boolean} [isAll] CloseQu isAll
         */

        /**
         * Constructs a new CloseQu.
         * @memberof pb
         * @classdesc Represents a CloseQu.
         * @constructor
         * @param {pb.ICloseQu=} [properties] Properties to set
         */
        function CloseQu(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * CloseQu game.
         * @member {string}game
         * @memberof pb.CloseQu
         * @instance
         */
        CloseQu.prototype.game = "";

        /**
         * CloseQu qd.
         * @member {string}qd
         * @memberof pb.CloseQu
         * @instance
         */
        CloseQu.prototype.qd = "";

        /**
         * CloseQu qu.
         * @member {number}qu
         * @memberof pb.CloseQu
         * @instance
         */
        CloseQu.prototype.qu = 0;

        /**
         * CloseQu isAll.
         * @member {boolean}isAll
         * @memberof pb.CloseQu
         * @instance
         */
        CloseQu.prototype.isAll = false;

        /**
         * Creates a new CloseQu instance using the specified properties.
         * @function create
         * @memberof pb.CloseQu
         * @static
         * @param {pb.ICloseQu=} [properties] Properties to set
         * @returns {pb.CloseQu} CloseQu instance
         */
        CloseQu.create = function create(properties) {
            return new CloseQu(properties);
        };

        /**
         * Encodes the specified CloseQu message. Does not implicitly {@link pb.CloseQu.verify|verify} messages.
         * @function encode
         * @memberof pb.CloseQu
         * @static
         * @param {pb.ICloseQu} message CloseQu message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CloseQu.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.game != null && message.hasOwnProperty("game"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.game);
            if (message.qd != null && message.hasOwnProperty("qd"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.qd);
            if (message.qu != null && message.hasOwnProperty("qu"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.qu);
            if (message.isAll != null && message.hasOwnProperty("isAll"))
                writer.uint32(/* id 4, wireType 0 =*/32).bool(message.isAll);
            return writer;
        };

        /**
         * Encodes the specified CloseQu message, length delimited. Does not implicitly {@link pb.CloseQu.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.CloseQu
         * @static
         * @param {pb.ICloseQu} message CloseQu message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CloseQu.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a CloseQu message from the specified reader or buffer.
         * @function decode
         * @memberof pb.CloseQu
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.CloseQu} CloseQu
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CloseQu.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.CloseQu();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.game = reader.string();
                    break;
                case 2:
                    message.qd = reader.string();
                    break;
                case 3:
                    message.qu = reader.int32();
                    break;
                case 4:
                    message.isAll = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a CloseQu message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.CloseQu
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.CloseQu} CloseQu
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CloseQu.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a CloseQu message.
         * @function verify
         * @memberof pb.CloseQu
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        CloseQu.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.game != null && message.hasOwnProperty("game"))
                if (!$util.isString(message.game))
                    return "game: string expected";
            if (message.qd != null && message.hasOwnProperty("qd"))
                if (!$util.isString(message.qd))
                    return "qd: string expected";
            if (message.qu != null && message.hasOwnProperty("qu"))
                if (!$util.isInteger(message.qu))
                    return "qu: integer expected";
            if (message.isAll != null && message.hasOwnProperty("isAll"))
                if (typeof message.isAll !== "boolean")
                    return "isAll: boolean expected";
            return null;
        };

        /**
         * Creates a CloseQu message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.CloseQu
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.CloseQu} CloseQu
         */
        CloseQu.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.CloseQu)
                return object;
            var message = new $root.pb.CloseQu();
            if (object.game != null)
                message.game = String(object.game);
            if (object.qd != null)
                message.qd = String(object.qd);
            if (object.qu != null)
                message.qu = object.qu | 0;
            if (object.isAll != null)
                message.isAll = Boolean(object.isAll);
            return message;
        };

        /**
         * Creates a plain object from a CloseQu message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.CloseQu
         * @static
         * @param {pb.CloseQu} message CloseQu
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        CloseQu.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.game = "";
                object.qd = "";
                object.qu = 0;
                object.isAll = false;
            }
            if (message.game != null && message.hasOwnProperty("game"))
                object.game = message.game;
            if (message.qd != null && message.hasOwnProperty("qd"))
                object.qd = message.qd;
            if (message.qu != null && message.hasOwnProperty("qu"))
                object.qu = message.qu;
            if (message.isAll != null && message.hasOwnProperty("isAll"))
                object.isAll = message.isAll;
            return object;
        };

        /**
         * Converts this CloseQu to JSON.
         * @function toJSON
         * @memberof pb.CloseQu
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        CloseQu.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return CloseQu;
    })();

    pb.GuangBo = (function() {

        /**
         * Properties of a GuangBo.
         * @memberof pb
         * @interface IGuangBo
         * @property {string} [game] GuangBo game
         * @property {string} [qd] GuangBo qd
         * @property {number} [qu] GuangBo qu
         * @property {boolean} [isAll] GuangBo isAll
         * @property {string} [content] GuangBo content
         */

        /**
         * Constructs a new GuangBo.
         * @memberof pb
         * @classdesc Represents a GuangBo.
         * @constructor
         * @param {pb.IGuangBo=} [properties] Properties to set
         */
        function GuangBo(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * GuangBo game.
         * @member {string}game
         * @memberof pb.GuangBo
         * @instance
         */
        GuangBo.prototype.game = "";

        /**
         * GuangBo qd.
         * @member {string}qd
         * @memberof pb.GuangBo
         * @instance
         */
        GuangBo.prototype.qd = "";

        /**
         * GuangBo qu.
         * @member {number}qu
         * @memberof pb.GuangBo
         * @instance
         */
        GuangBo.prototype.qu = 0;

        /**
         * GuangBo isAll.
         * @member {boolean}isAll
         * @memberof pb.GuangBo
         * @instance
         */
        GuangBo.prototype.isAll = false;

        /**
         * GuangBo content.
         * @member {string}content
         * @memberof pb.GuangBo
         * @instance
         */
        GuangBo.prototype.content = "";

        /**
         * Creates a new GuangBo instance using the specified properties.
         * @function create
         * @memberof pb.GuangBo
         * @static
         * @param {pb.IGuangBo=} [properties] Properties to set
         * @returns {pb.GuangBo} GuangBo instance
         */
        GuangBo.create = function create(properties) {
            return new GuangBo(properties);
        };

        /**
         * Encodes the specified GuangBo message. Does not implicitly {@link pb.GuangBo.verify|verify} messages.
         * @function encode
         * @memberof pb.GuangBo
         * @static
         * @param {pb.IGuangBo} message GuangBo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        GuangBo.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.game != null && message.hasOwnProperty("game"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.game);
            if (message.qd != null && message.hasOwnProperty("qd"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.qd);
            if (message.qu != null && message.hasOwnProperty("qu"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.qu);
            if (message.isAll != null && message.hasOwnProperty("isAll"))
                writer.uint32(/* id 4, wireType 0 =*/32).bool(message.isAll);
            if (message.content != null && message.hasOwnProperty("content"))
                writer.uint32(/* id 5, wireType 2 =*/42).string(message.content);
            return writer;
        };

        /**
         * Encodes the specified GuangBo message, length delimited. Does not implicitly {@link pb.GuangBo.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.GuangBo
         * @static
         * @param {pb.IGuangBo} message GuangBo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        GuangBo.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a GuangBo message from the specified reader or buffer.
         * @function decode
         * @memberof pb.GuangBo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.GuangBo} GuangBo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        GuangBo.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.GuangBo();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.game = reader.string();
                    break;
                case 2:
                    message.qd = reader.string();
                    break;
                case 3:
                    message.qu = reader.int32();
                    break;
                case 4:
                    message.isAll = reader.bool();
                    break;
                case 5:
                    message.content = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a GuangBo message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.GuangBo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.GuangBo} GuangBo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        GuangBo.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a GuangBo message.
         * @function verify
         * @memberof pb.GuangBo
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        GuangBo.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.game != null && message.hasOwnProperty("game"))
                if (!$util.isString(message.game))
                    return "game: string expected";
            if (message.qd != null && message.hasOwnProperty("qd"))
                if (!$util.isString(message.qd))
                    return "qd: string expected";
            if (message.qu != null && message.hasOwnProperty("qu"))
                if (!$util.isInteger(message.qu))
                    return "qu: integer expected";
            if (message.isAll != null && message.hasOwnProperty("isAll"))
                if (typeof message.isAll !== "boolean")
                    return "isAll: boolean expected";
            if (message.content != null && message.hasOwnProperty("content"))
                if (!$util.isString(message.content))
                    return "content: string expected";
            return null;
        };

        /**
         * Creates a GuangBo message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.GuangBo
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.GuangBo} GuangBo
         */
        GuangBo.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.GuangBo)
                return object;
            var message = new $root.pb.GuangBo();
            if (object.game != null)
                message.game = String(object.game);
            if (object.qd != null)
                message.qd = String(object.qd);
            if (object.qu != null)
                message.qu = object.qu | 0;
            if (object.isAll != null)
                message.isAll = Boolean(object.isAll);
            if (object.content != null)
                message.content = String(object.content);
            return message;
        };

        /**
         * Creates a plain object from a GuangBo message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.GuangBo
         * @static
         * @param {pb.GuangBo} message GuangBo
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        GuangBo.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.game = "";
                object.qd = "";
                object.qu = 0;
                object.isAll = false;
                object.content = "";
            }
            if (message.game != null && message.hasOwnProperty("game"))
                object.game = message.game;
            if (message.qd != null && message.hasOwnProperty("qd"))
                object.qd = message.qd;
            if (message.qu != null && message.hasOwnProperty("qu"))
                object.qu = message.qu;
            if (message.isAll != null && message.hasOwnProperty("isAll"))
                object.isAll = message.isAll;
            if (message.content != null && message.hasOwnProperty("content"))
                object.content = message.content;
            return object;
        };

        /**
         * Converts this GuangBo to JSON.
         * @function toJSON
         * @memberof pb.GuangBo
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        GuangBo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return GuangBo;
    })();

    pb.TongJiDayAsk = (function() {

        /**
         * Properties of a TongJiDayAsk.
         * @memberof pb
         * @interface ITongJiDayAsk
         * @property {string} [start] TongJiDayAsk start
         * @property {string} [end] TongJiDayAsk end
         * @property {string} [game] TongJiDayAsk game
         * @property {string} [qd] TongJiDayAsk qd
         * @property {number} [qu] TongJiDayAsk qu
         */

        /**
         * Constructs a new TongJiDayAsk.
         * @memberof pb
         * @classdesc Represents a TongJiDayAsk.
         * @constructor
         * @param {pb.ITongJiDayAsk=} [properties] Properties to set
         */
        function TongJiDayAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TongJiDayAsk start.
         * @member {string}start
         * @memberof pb.TongJiDayAsk
         * @instance
         */
        TongJiDayAsk.prototype.start = "";

        /**
         * TongJiDayAsk end.
         * @member {string}end
         * @memberof pb.TongJiDayAsk
         * @instance
         */
        TongJiDayAsk.prototype.end = "";

        /**
         * TongJiDayAsk game.
         * @member {string}game
         * @memberof pb.TongJiDayAsk
         * @instance
         */
        TongJiDayAsk.prototype.game = "";

        /**
         * TongJiDayAsk qd.
         * @member {string}qd
         * @memberof pb.TongJiDayAsk
         * @instance
         */
        TongJiDayAsk.prototype.qd = "";

        /**
         * TongJiDayAsk qu.
         * @member {number}qu
         * @memberof pb.TongJiDayAsk
         * @instance
         */
        TongJiDayAsk.prototype.qu = 0;

        /**
         * Creates a new TongJiDayAsk instance using the specified properties.
         * @function create
         * @memberof pb.TongJiDayAsk
         * @static
         * @param {pb.ITongJiDayAsk=} [properties] Properties to set
         * @returns {pb.TongJiDayAsk} TongJiDayAsk instance
         */
        TongJiDayAsk.create = function create(properties) {
            return new TongJiDayAsk(properties);
        };

        /**
         * Encodes the specified TongJiDayAsk message. Does not implicitly {@link pb.TongJiDayAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.TongJiDayAsk
         * @static
         * @param {pb.ITongJiDayAsk} message TongJiDayAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TongJiDayAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.start != null && message.hasOwnProperty("start"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.start);
            if (message.end != null && message.hasOwnProperty("end"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.end);
            if (message.game != null && message.hasOwnProperty("game"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.game);
            if (message.qd != null && message.hasOwnProperty("qd"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.qd);
            if (message.qu != null && message.hasOwnProperty("qu"))
                writer.uint32(/* id 5, wireType 0 =*/40).int32(message.qu);
            return writer;
        };

        /**
         * Encodes the specified TongJiDayAsk message, length delimited. Does not implicitly {@link pb.TongJiDayAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.TongJiDayAsk
         * @static
         * @param {pb.ITongJiDayAsk} message TongJiDayAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TongJiDayAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TongJiDayAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.TongJiDayAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.TongJiDayAsk} TongJiDayAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TongJiDayAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.TongJiDayAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.start = reader.string();
                    break;
                case 2:
                    message.end = reader.string();
                    break;
                case 3:
                    message.game = reader.string();
                    break;
                case 4:
                    message.qd = reader.string();
                    break;
                case 5:
                    message.qu = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TongJiDayAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.TongJiDayAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.TongJiDayAsk} TongJiDayAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TongJiDayAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TongJiDayAsk message.
         * @function verify
         * @memberof pb.TongJiDayAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TongJiDayAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.start != null && message.hasOwnProperty("start"))
                if (!$util.isString(message.start))
                    return "start: string expected";
            if (message.end != null && message.hasOwnProperty("end"))
                if (!$util.isString(message.end))
                    return "end: string expected";
            if (message.game != null && message.hasOwnProperty("game"))
                if (!$util.isString(message.game))
                    return "game: string expected";
            if (message.qd != null && message.hasOwnProperty("qd"))
                if (!$util.isString(message.qd))
                    return "qd: string expected";
            if (message.qu != null && message.hasOwnProperty("qu"))
                if (!$util.isInteger(message.qu))
                    return "qu: integer expected";
            return null;
        };

        /**
         * Creates a TongJiDayAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.TongJiDayAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.TongJiDayAsk} TongJiDayAsk
         */
        TongJiDayAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.TongJiDayAsk)
                return object;
            var message = new $root.pb.TongJiDayAsk();
            if (object.start != null)
                message.start = String(object.start);
            if (object.end != null)
                message.end = String(object.end);
            if (object.game != null)
                message.game = String(object.game);
            if (object.qd != null)
                message.qd = String(object.qd);
            if (object.qu != null)
                message.qu = object.qu | 0;
            return message;
        };

        /**
         * Creates a plain object from a TongJiDayAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.TongJiDayAsk
         * @static
         * @param {pb.TongJiDayAsk} message TongJiDayAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TongJiDayAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.start = "";
                object.end = "";
                object.game = "";
                object.qd = "";
                object.qu = 0;
            }
            if (message.start != null && message.hasOwnProperty("start"))
                object.start = message.start;
            if (message.end != null && message.hasOwnProperty("end"))
                object.end = message.end;
            if (message.game != null && message.hasOwnProperty("game"))
                object.game = message.game;
            if (message.qd != null && message.hasOwnProperty("qd"))
                object.qd = message.qd;
            if (message.qu != null && message.hasOwnProperty("qu"))
                object.qu = message.qu;
            return object;
        };

        /**
         * Converts this TongJiDayAsk to JSON.
         * @function toJSON
         * @memberof pb.TongJiDayAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TongJiDayAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TongJiDayAsk;
    })();

    pb.TongJiMongXiAsk = (function() {

        /**
         * Properties of a TongJiMongXiAsk.
         * @memberof pb
         * @interface ITongJiMongXiAsk
         * @property {string} [game] TongJiMongXiAsk game
         * @property {string} [qd] TongJiMongXiAsk qd
         * @property {number} [qu] TongJiMongXiAsk qu
         */

        /**
         * Constructs a new TongJiMongXiAsk.
         * @memberof pb
         * @classdesc Represents a TongJiMongXiAsk.
         * @constructor
         * @param {pb.ITongJiMongXiAsk=} [properties] Properties to set
         */
        function TongJiMongXiAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TongJiMongXiAsk game.
         * @member {string}game
         * @memberof pb.TongJiMongXiAsk
         * @instance
         */
        TongJiMongXiAsk.prototype.game = "";

        /**
         * TongJiMongXiAsk qd.
         * @member {string}qd
         * @memberof pb.TongJiMongXiAsk
         * @instance
         */
        TongJiMongXiAsk.prototype.qd = "";

        /**
         * TongJiMongXiAsk qu.
         * @member {number}qu
         * @memberof pb.TongJiMongXiAsk
         * @instance
         */
        TongJiMongXiAsk.prototype.qu = 0;

        /**
         * Creates a new TongJiMongXiAsk instance using the specified properties.
         * @function create
         * @memberof pb.TongJiMongXiAsk
         * @static
         * @param {pb.ITongJiMongXiAsk=} [properties] Properties to set
         * @returns {pb.TongJiMongXiAsk} TongJiMongXiAsk instance
         */
        TongJiMongXiAsk.create = function create(properties) {
            return new TongJiMongXiAsk(properties);
        };

        /**
         * Encodes the specified TongJiMongXiAsk message. Does not implicitly {@link pb.TongJiMongXiAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.TongJiMongXiAsk
         * @static
         * @param {pb.ITongJiMongXiAsk} message TongJiMongXiAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TongJiMongXiAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.game != null && message.hasOwnProperty("game"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.game);
            if (message.qd != null && message.hasOwnProperty("qd"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.qd);
            if (message.qu != null && message.hasOwnProperty("qu"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.qu);
            return writer;
        };

        /**
         * Encodes the specified TongJiMongXiAsk message, length delimited. Does not implicitly {@link pb.TongJiMongXiAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.TongJiMongXiAsk
         * @static
         * @param {pb.ITongJiMongXiAsk} message TongJiMongXiAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TongJiMongXiAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TongJiMongXiAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.TongJiMongXiAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.TongJiMongXiAsk} TongJiMongXiAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TongJiMongXiAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.TongJiMongXiAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.game = reader.string();
                    break;
                case 2:
                    message.qd = reader.string();
                    break;
                case 3:
                    message.qu = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TongJiMongXiAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.TongJiMongXiAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.TongJiMongXiAsk} TongJiMongXiAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TongJiMongXiAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TongJiMongXiAsk message.
         * @function verify
         * @memberof pb.TongJiMongXiAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TongJiMongXiAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.game != null && message.hasOwnProperty("game"))
                if (!$util.isString(message.game))
                    return "game: string expected";
            if (message.qd != null && message.hasOwnProperty("qd"))
                if (!$util.isString(message.qd))
                    return "qd: string expected";
            if (message.qu != null && message.hasOwnProperty("qu"))
                if (!$util.isInteger(message.qu))
                    return "qu: integer expected";
            return null;
        };

        /**
         * Creates a TongJiMongXiAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.TongJiMongXiAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.TongJiMongXiAsk} TongJiMongXiAsk
         */
        TongJiMongXiAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.TongJiMongXiAsk)
                return object;
            var message = new $root.pb.TongJiMongXiAsk();
            if (object.game != null)
                message.game = String(object.game);
            if (object.qd != null)
                message.qd = String(object.qd);
            if (object.qu != null)
                message.qu = object.qu | 0;
            return message;
        };

        /**
         * Creates a plain object from a TongJiMongXiAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.TongJiMongXiAsk
         * @static
         * @param {pb.TongJiMongXiAsk} message TongJiMongXiAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TongJiMongXiAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.game = "";
                object.qd = "";
                object.qu = 0;
            }
            if (message.game != null && message.hasOwnProperty("game"))
                object.game = message.game;
            if (message.qd != null && message.hasOwnProperty("qd"))
                object.qd = message.qd;
            if (message.qu != null && message.hasOwnProperty("qu"))
                object.qu = message.qu;
            return object;
        };

        /**
         * Converts this TongJiMongXiAsk to JSON.
         * @function toJSON
         * @memberof pb.TongJiMongXiAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TongJiMongXiAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TongJiMongXiAsk;
    })();

    pb.TongJiBangAsk = (function() {

        /**
         * Properties of a TongJiBangAsk.
         * @memberof pb
         * @interface ITongJiBangAsk
         * @property {string} [game] TongJiBangAsk game
         * @property {string} [qd] TongJiBangAsk qd
         * @property {number} [qu] TongJiBangAsk qu
         */

        /**
         * Constructs a new TongJiBangAsk.
         * @memberof pb
         * @classdesc Represents a TongJiBangAsk.
         * @constructor
         * @param {pb.ITongJiBangAsk=} [properties] Properties to set
         */
        function TongJiBangAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TongJiBangAsk game.
         * @member {string}game
         * @memberof pb.TongJiBangAsk
         * @instance
         */
        TongJiBangAsk.prototype.game = "";

        /**
         * TongJiBangAsk qd.
         * @member {string}qd
         * @memberof pb.TongJiBangAsk
         * @instance
         */
        TongJiBangAsk.prototype.qd = "";

        /**
         * TongJiBangAsk qu.
         * @member {number}qu
         * @memberof pb.TongJiBangAsk
         * @instance
         */
        TongJiBangAsk.prototype.qu = 0;

        /**
         * Creates a new TongJiBangAsk instance using the specified properties.
         * @function create
         * @memberof pb.TongJiBangAsk
         * @static
         * @param {pb.ITongJiBangAsk=} [properties] Properties to set
         * @returns {pb.TongJiBangAsk} TongJiBangAsk instance
         */
        TongJiBangAsk.create = function create(properties) {
            return new TongJiBangAsk(properties);
        };

        /**
         * Encodes the specified TongJiBangAsk message. Does not implicitly {@link pb.TongJiBangAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.TongJiBangAsk
         * @static
         * @param {pb.ITongJiBangAsk} message TongJiBangAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TongJiBangAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.game != null && message.hasOwnProperty("game"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.game);
            if (message.qd != null && message.hasOwnProperty("qd"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.qd);
            if (message.qu != null && message.hasOwnProperty("qu"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.qu);
            return writer;
        };

        /**
         * Encodes the specified TongJiBangAsk message, length delimited. Does not implicitly {@link pb.TongJiBangAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.TongJiBangAsk
         * @static
         * @param {pb.ITongJiBangAsk} message TongJiBangAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TongJiBangAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TongJiBangAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.TongJiBangAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.TongJiBangAsk} TongJiBangAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TongJiBangAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.TongJiBangAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.game = reader.string();
                    break;
                case 2:
                    message.qd = reader.string();
                    break;
                case 3:
                    message.qu = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TongJiBangAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.TongJiBangAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.TongJiBangAsk} TongJiBangAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TongJiBangAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TongJiBangAsk message.
         * @function verify
         * @memberof pb.TongJiBangAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TongJiBangAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.game != null && message.hasOwnProperty("game"))
                if (!$util.isString(message.game))
                    return "game: string expected";
            if (message.qd != null && message.hasOwnProperty("qd"))
                if (!$util.isString(message.qd))
                    return "qd: string expected";
            if (message.qu != null && message.hasOwnProperty("qu"))
                if (!$util.isInteger(message.qu))
                    return "qu: integer expected";
            return null;
        };

        /**
         * Creates a TongJiBangAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.TongJiBangAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.TongJiBangAsk} TongJiBangAsk
         */
        TongJiBangAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.TongJiBangAsk)
                return object;
            var message = new $root.pb.TongJiBangAsk();
            if (object.game != null)
                message.game = String(object.game);
            if (object.qd != null)
                message.qd = String(object.qd);
            if (object.qu != null)
                message.qu = object.qu | 0;
            return message;
        };

        /**
         * Creates a plain object from a TongJiBangAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.TongJiBangAsk
         * @static
         * @param {pb.TongJiBangAsk} message TongJiBangAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TongJiBangAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.game = "";
                object.qd = "";
                object.qu = 0;
            }
            if (message.game != null && message.hasOwnProperty("game"))
                object.game = message.game;
            if (message.qd != null && message.hasOwnProperty("qd"))
                object.qd = message.qd;
            if (message.qu != null && message.hasOwnProperty("qu"))
                object.qu = message.qu;
            return object;
        };

        /**
         * Converts this TongJiBangAsk to JSON.
         * @function toJSON
         * @memberof pb.TongJiBangAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TongJiBangAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TongJiBangAsk;
    })();

    pb.TongJiShiXiAsk = (function() {

        /**
         * Properties of a TongJiShiXiAsk.
         * @memberof pb
         * @interface ITongJiShiXiAsk
         * @property {string} [game] TongJiShiXiAsk game
         * @property {string} [qd] TongJiShiXiAsk qd
         * @property {number} [qu] TongJiShiXiAsk qu
         */

        /**
         * Constructs a new TongJiShiXiAsk.
         * @memberof pb
         * @classdesc Represents a TongJiShiXiAsk.
         * @constructor
         * @param {pb.ITongJiShiXiAsk=} [properties] Properties to set
         */
        function TongJiShiXiAsk(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TongJiShiXiAsk game.
         * @member {string}game
         * @memberof pb.TongJiShiXiAsk
         * @instance
         */
        TongJiShiXiAsk.prototype.game = "";

        /**
         * TongJiShiXiAsk qd.
         * @member {string}qd
         * @memberof pb.TongJiShiXiAsk
         * @instance
         */
        TongJiShiXiAsk.prototype.qd = "";

        /**
         * TongJiShiXiAsk qu.
         * @member {number}qu
         * @memberof pb.TongJiShiXiAsk
         * @instance
         */
        TongJiShiXiAsk.prototype.qu = 0;

        /**
         * Creates a new TongJiShiXiAsk instance using the specified properties.
         * @function create
         * @memberof pb.TongJiShiXiAsk
         * @static
         * @param {pb.ITongJiShiXiAsk=} [properties] Properties to set
         * @returns {pb.TongJiShiXiAsk} TongJiShiXiAsk instance
         */
        TongJiShiXiAsk.create = function create(properties) {
            return new TongJiShiXiAsk(properties);
        };

        /**
         * Encodes the specified TongJiShiXiAsk message. Does not implicitly {@link pb.TongJiShiXiAsk.verify|verify} messages.
         * @function encode
         * @memberof pb.TongJiShiXiAsk
         * @static
         * @param {pb.ITongJiShiXiAsk} message TongJiShiXiAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TongJiShiXiAsk.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.game != null && message.hasOwnProperty("game"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.game);
            if (message.qd != null && message.hasOwnProperty("qd"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.qd);
            if (message.qu != null && message.hasOwnProperty("qu"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.qu);
            return writer;
        };

        /**
         * Encodes the specified TongJiShiXiAsk message, length delimited. Does not implicitly {@link pb.TongJiShiXiAsk.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.TongJiShiXiAsk
         * @static
         * @param {pb.ITongJiShiXiAsk} message TongJiShiXiAsk message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TongJiShiXiAsk.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TongJiShiXiAsk message from the specified reader or buffer.
         * @function decode
         * @memberof pb.TongJiShiXiAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.TongJiShiXiAsk} TongJiShiXiAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TongJiShiXiAsk.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.TongJiShiXiAsk();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.game = reader.string();
                    break;
                case 2:
                    message.qd = reader.string();
                    break;
                case 3:
                    message.qu = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TongJiShiXiAsk message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.TongJiShiXiAsk
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.TongJiShiXiAsk} TongJiShiXiAsk
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TongJiShiXiAsk.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TongJiShiXiAsk message.
         * @function verify
         * @memberof pb.TongJiShiXiAsk
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TongJiShiXiAsk.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.game != null && message.hasOwnProperty("game"))
                if (!$util.isString(message.game))
                    return "game: string expected";
            if (message.qd != null && message.hasOwnProperty("qd"))
                if (!$util.isString(message.qd))
                    return "qd: string expected";
            if (message.qu != null && message.hasOwnProperty("qu"))
                if (!$util.isInteger(message.qu))
                    return "qu: integer expected";
            return null;
        };

        /**
         * Creates a TongJiShiXiAsk message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.TongJiShiXiAsk
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.TongJiShiXiAsk} TongJiShiXiAsk
         */
        TongJiShiXiAsk.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.TongJiShiXiAsk)
                return object;
            var message = new $root.pb.TongJiShiXiAsk();
            if (object.game != null)
                message.game = String(object.game);
            if (object.qd != null)
                message.qd = String(object.qd);
            if (object.qu != null)
                message.qu = object.qu | 0;
            return message;
        };

        /**
         * Creates a plain object from a TongJiShiXiAsk message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.TongJiShiXiAsk
         * @static
         * @param {pb.TongJiShiXiAsk} message TongJiShiXiAsk
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TongJiShiXiAsk.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.game = "";
                object.qd = "";
                object.qu = 0;
            }
            if (message.game != null && message.hasOwnProperty("game"))
                object.game = message.game;
            if (message.qd != null && message.hasOwnProperty("qd"))
                object.qd = message.qd;
            if (message.qu != null && message.hasOwnProperty("qu"))
                object.qu = message.qu;
            return object;
        };

        /**
         * Converts this TongJiShiXiAsk to JSON.
         * @function toJSON
         * @memberof pb.TongJiShiXiAsk
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TongJiShiXiAsk.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TongJiShiXiAsk;
    })();

    pb.TongJiDayRes = (function() {

        /**
         * Properties of a TongJiDayRes.
         * @memberof pb
         * @interface ITongJiDayRes
         * @property {string} [game] TongJiDayRes game
         * @property {string} [qd] TongJiDayRes qd
         * @property {number} [qu] TongJiDayRes qu
         * @property {Array.<pb.IDayTongJi>} [tjs] TongJiDayRes tjs
         */

        /**
         * Constructs a new TongJiDayRes.
         * @memberof pb
         * @classdesc Represents a TongJiDayRes.
         * @constructor
         * @param {pb.ITongJiDayRes=} [properties] Properties to set
         */
        function TongJiDayRes(properties) {
            this.tjs = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TongJiDayRes game.
         * @member {string}game
         * @memberof pb.TongJiDayRes
         * @instance
         */
        TongJiDayRes.prototype.game = "";

        /**
         * TongJiDayRes qd.
         * @member {string}qd
         * @memberof pb.TongJiDayRes
         * @instance
         */
        TongJiDayRes.prototype.qd = "";

        /**
         * TongJiDayRes qu.
         * @member {number}qu
         * @memberof pb.TongJiDayRes
         * @instance
         */
        TongJiDayRes.prototype.qu = 0;

        /**
         * TongJiDayRes tjs.
         * @member {Array.<pb.IDayTongJi>}tjs
         * @memberof pb.TongJiDayRes
         * @instance
         */
        TongJiDayRes.prototype.tjs = $util.emptyArray;

        /**
         * Creates a new TongJiDayRes instance using the specified properties.
         * @function create
         * @memberof pb.TongJiDayRes
         * @static
         * @param {pb.ITongJiDayRes=} [properties] Properties to set
         * @returns {pb.TongJiDayRes} TongJiDayRes instance
         */
        TongJiDayRes.create = function create(properties) {
            return new TongJiDayRes(properties);
        };

        /**
         * Encodes the specified TongJiDayRes message. Does not implicitly {@link pb.TongJiDayRes.verify|verify} messages.
         * @function encode
         * @memberof pb.TongJiDayRes
         * @static
         * @param {pb.ITongJiDayRes} message TongJiDayRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TongJiDayRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.game != null && message.hasOwnProperty("game"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.game);
            if (message.qd != null && message.hasOwnProperty("qd"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.qd);
            if (message.qu != null && message.hasOwnProperty("qu"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.qu);
            if (message.tjs != null && message.tjs.length)
                for (var i = 0; i < message.tjs.length; ++i)
                    $root.pb.DayTongJi.encode(message.tjs[i], writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TongJiDayRes message, length delimited. Does not implicitly {@link pb.TongJiDayRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.TongJiDayRes
         * @static
         * @param {pb.ITongJiDayRes} message TongJiDayRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TongJiDayRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TongJiDayRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.TongJiDayRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.TongJiDayRes} TongJiDayRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TongJiDayRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.TongJiDayRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.game = reader.string();
                    break;
                case 2:
                    message.qd = reader.string();
                    break;
                case 3:
                    message.qu = reader.int32();
                    break;
                case 4:
                    if (!(message.tjs && message.tjs.length))
                        message.tjs = [];
                    message.tjs.push($root.pb.DayTongJi.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TongJiDayRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.TongJiDayRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.TongJiDayRes} TongJiDayRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TongJiDayRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TongJiDayRes message.
         * @function verify
         * @memberof pb.TongJiDayRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TongJiDayRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.game != null && message.hasOwnProperty("game"))
                if (!$util.isString(message.game))
                    return "game: string expected";
            if (message.qd != null && message.hasOwnProperty("qd"))
                if (!$util.isString(message.qd))
                    return "qd: string expected";
            if (message.qu != null && message.hasOwnProperty("qu"))
                if (!$util.isInteger(message.qu))
                    return "qu: integer expected";
            if (message.tjs != null && message.hasOwnProperty("tjs")) {
                if (!Array.isArray(message.tjs))
                    return "tjs: array expected";
                for (var i = 0; i < message.tjs.length; ++i) {
                    var error = $root.pb.DayTongJi.verify(message.tjs[i]);
                    if (error)
                        return "tjs." + error;
                }
            }
            return null;
        };

        /**
         * Creates a TongJiDayRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.TongJiDayRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.TongJiDayRes} TongJiDayRes
         */
        TongJiDayRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.TongJiDayRes)
                return object;
            var message = new $root.pb.TongJiDayRes();
            if (object.game != null)
                message.game = String(object.game);
            if (object.qd != null)
                message.qd = String(object.qd);
            if (object.qu != null)
                message.qu = object.qu | 0;
            if (object.tjs) {
                if (!Array.isArray(object.tjs))
                    throw TypeError(".pb.TongJiDayRes.tjs: array expected");
                message.tjs = [];
                for (var i = 0; i < object.tjs.length; ++i) {
                    if (typeof object.tjs[i] !== "object")
                        throw TypeError(".pb.TongJiDayRes.tjs: object expected");
                    message.tjs[i] = $root.pb.DayTongJi.fromObject(object.tjs[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a TongJiDayRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.TongJiDayRes
         * @static
         * @param {pb.TongJiDayRes} message TongJiDayRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TongJiDayRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.tjs = [];
            if (options.defaults) {
                object.game = "";
                object.qd = "";
                object.qu = 0;
            }
            if (message.game != null && message.hasOwnProperty("game"))
                object.game = message.game;
            if (message.qd != null && message.hasOwnProperty("qd"))
                object.qd = message.qd;
            if (message.qu != null && message.hasOwnProperty("qu"))
                object.qu = message.qu;
            if (message.tjs && message.tjs.length) {
                object.tjs = [];
                for (var j = 0; j < message.tjs.length; ++j)
                    object.tjs[j] = $root.pb.DayTongJi.toObject(message.tjs[j], options);
            }
            return object;
        };

        /**
         * Converts this TongJiDayRes to JSON.
         * @function toJSON
         * @memberof pb.TongJiDayRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TongJiDayRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TongJiDayRes;
    })();

    pb.TongJiMongXiRes = (function() {

        /**
         * Properties of a TongJiMongXiRes.
         * @memberof pb
         * @interface ITongJiMongXiRes
         * @property {string} [game] TongJiMongXiRes game
         * @property {string} [qd] TongJiMongXiRes qd
         * @property {number} [qu] TongJiMongXiRes qu
         * @property {Array.<pb.IMoneyXi>} [mxs] TongJiMongXiRes mxs
         */

        /**
         * Constructs a new TongJiMongXiRes.
         * @memberof pb
         * @classdesc Represents a TongJiMongXiRes.
         * @constructor
         * @param {pb.ITongJiMongXiRes=} [properties] Properties to set
         */
        function TongJiMongXiRes(properties) {
            this.mxs = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TongJiMongXiRes game.
         * @member {string}game
         * @memberof pb.TongJiMongXiRes
         * @instance
         */
        TongJiMongXiRes.prototype.game = "";

        /**
         * TongJiMongXiRes qd.
         * @member {string}qd
         * @memberof pb.TongJiMongXiRes
         * @instance
         */
        TongJiMongXiRes.prototype.qd = "";

        /**
         * TongJiMongXiRes qu.
         * @member {number}qu
         * @memberof pb.TongJiMongXiRes
         * @instance
         */
        TongJiMongXiRes.prototype.qu = 0;

        /**
         * TongJiMongXiRes mxs.
         * @member {Array.<pb.IMoneyXi>}mxs
         * @memberof pb.TongJiMongXiRes
         * @instance
         */
        TongJiMongXiRes.prototype.mxs = $util.emptyArray;

        /**
         * Creates a new TongJiMongXiRes instance using the specified properties.
         * @function create
         * @memberof pb.TongJiMongXiRes
         * @static
         * @param {pb.ITongJiMongXiRes=} [properties] Properties to set
         * @returns {pb.TongJiMongXiRes} TongJiMongXiRes instance
         */
        TongJiMongXiRes.create = function create(properties) {
            return new TongJiMongXiRes(properties);
        };

        /**
         * Encodes the specified TongJiMongXiRes message. Does not implicitly {@link pb.TongJiMongXiRes.verify|verify} messages.
         * @function encode
         * @memberof pb.TongJiMongXiRes
         * @static
         * @param {pb.ITongJiMongXiRes} message TongJiMongXiRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TongJiMongXiRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.game != null && message.hasOwnProperty("game"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.game);
            if (message.qd != null && message.hasOwnProperty("qd"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.qd);
            if (message.qu != null && message.hasOwnProperty("qu"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.qu);
            if (message.mxs != null && message.mxs.length)
                for (var i = 0; i < message.mxs.length; ++i)
                    $root.pb.MoneyXi.encode(message.mxs[i], writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TongJiMongXiRes message, length delimited. Does not implicitly {@link pb.TongJiMongXiRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.TongJiMongXiRes
         * @static
         * @param {pb.ITongJiMongXiRes} message TongJiMongXiRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TongJiMongXiRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TongJiMongXiRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.TongJiMongXiRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.TongJiMongXiRes} TongJiMongXiRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TongJiMongXiRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.TongJiMongXiRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.game = reader.string();
                    break;
                case 2:
                    message.qd = reader.string();
                    break;
                case 3:
                    message.qu = reader.int32();
                    break;
                case 4:
                    if (!(message.mxs && message.mxs.length))
                        message.mxs = [];
                    message.mxs.push($root.pb.MoneyXi.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TongJiMongXiRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.TongJiMongXiRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.TongJiMongXiRes} TongJiMongXiRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TongJiMongXiRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TongJiMongXiRes message.
         * @function verify
         * @memberof pb.TongJiMongXiRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TongJiMongXiRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.game != null && message.hasOwnProperty("game"))
                if (!$util.isString(message.game))
                    return "game: string expected";
            if (message.qd != null && message.hasOwnProperty("qd"))
                if (!$util.isString(message.qd))
                    return "qd: string expected";
            if (message.qu != null && message.hasOwnProperty("qu"))
                if (!$util.isInteger(message.qu))
                    return "qu: integer expected";
            if (message.mxs != null && message.hasOwnProperty("mxs")) {
                if (!Array.isArray(message.mxs))
                    return "mxs: array expected";
                for (var i = 0; i < message.mxs.length; ++i) {
                    var error = $root.pb.MoneyXi.verify(message.mxs[i]);
                    if (error)
                        return "mxs." + error;
                }
            }
            return null;
        };

        /**
         * Creates a TongJiMongXiRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.TongJiMongXiRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.TongJiMongXiRes} TongJiMongXiRes
         */
        TongJiMongXiRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.TongJiMongXiRes)
                return object;
            var message = new $root.pb.TongJiMongXiRes();
            if (object.game != null)
                message.game = String(object.game);
            if (object.qd != null)
                message.qd = String(object.qd);
            if (object.qu != null)
                message.qu = object.qu | 0;
            if (object.mxs) {
                if (!Array.isArray(object.mxs))
                    throw TypeError(".pb.TongJiMongXiRes.mxs: array expected");
                message.mxs = [];
                for (var i = 0; i < object.mxs.length; ++i) {
                    if (typeof object.mxs[i] !== "object")
                        throw TypeError(".pb.TongJiMongXiRes.mxs: object expected");
                    message.mxs[i] = $root.pb.MoneyXi.fromObject(object.mxs[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a TongJiMongXiRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.TongJiMongXiRes
         * @static
         * @param {pb.TongJiMongXiRes} message TongJiMongXiRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TongJiMongXiRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.mxs = [];
            if (options.defaults) {
                object.game = "";
                object.qd = "";
                object.qu = 0;
            }
            if (message.game != null && message.hasOwnProperty("game"))
                object.game = message.game;
            if (message.qd != null && message.hasOwnProperty("qd"))
                object.qd = message.qd;
            if (message.qu != null && message.hasOwnProperty("qu"))
                object.qu = message.qu;
            if (message.mxs && message.mxs.length) {
                object.mxs = [];
                for (var j = 0; j < message.mxs.length; ++j)
                    object.mxs[j] = $root.pb.MoneyXi.toObject(message.mxs[j], options);
            }
            return object;
        };

        /**
         * Converts this TongJiMongXiRes to JSON.
         * @function toJSON
         * @memberof pb.TongJiMongXiRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TongJiMongXiRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TongJiMongXiRes;
    })();

    pb.TongJiBangRes = (function() {

        /**
         * Properties of a TongJiBangRes.
         * @memberof pb
         * @interface ITongJiBangRes
         * @property {string} [game] TongJiBangRes game
         * @property {string} [qd] TongJiBangRes qd
         * @property {number} [qu] TongJiBangRes qu
         * @property {Array.<pb.IMoneyBang>} [bangs] TongJiBangRes bangs
         */

        /**
         * Constructs a new TongJiBangRes.
         * @memberof pb
         * @classdesc Represents a TongJiBangRes.
         * @constructor
         * @param {pb.ITongJiBangRes=} [properties] Properties to set
         */
        function TongJiBangRes(properties) {
            this.bangs = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TongJiBangRes game.
         * @member {string}game
         * @memberof pb.TongJiBangRes
         * @instance
         */
        TongJiBangRes.prototype.game = "";

        /**
         * TongJiBangRes qd.
         * @member {string}qd
         * @memberof pb.TongJiBangRes
         * @instance
         */
        TongJiBangRes.prototype.qd = "";

        /**
         * TongJiBangRes qu.
         * @member {number}qu
         * @memberof pb.TongJiBangRes
         * @instance
         */
        TongJiBangRes.prototype.qu = 0;

        /**
         * TongJiBangRes bangs.
         * @member {Array.<pb.IMoneyBang>}bangs
         * @memberof pb.TongJiBangRes
         * @instance
         */
        TongJiBangRes.prototype.bangs = $util.emptyArray;

        /**
         * Creates a new TongJiBangRes instance using the specified properties.
         * @function create
         * @memberof pb.TongJiBangRes
         * @static
         * @param {pb.ITongJiBangRes=} [properties] Properties to set
         * @returns {pb.TongJiBangRes} TongJiBangRes instance
         */
        TongJiBangRes.create = function create(properties) {
            return new TongJiBangRes(properties);
        };

        /**
         * Encodes the specified TongJiBangRes message. Does not implicitly {@link pb.TongJiBangRes.verify|verify} messages.
         * @function encode
         * @memberof pb.TongJiBangRes
         * @static
         * @param {pb.ITongJiBangRes} message TongJiBangRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TongJiBangRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.game != null && message.hasOwnProperty("game"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.game);
            if (message.qd != null && message.hasOwnProperty("qd"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.qd);
            if (message.qu != null && message.hasOwnProperty("qu"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.qu);
            if (message.bangs != null && message.bangs.length)
                for (var i = 0; i < message.bangs.length; ++i)
                    $root.pb.MoneyBang.encode(message.bangs[i], writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TongJiBangRes message, length delimited. Does not implicitly {@link pb.TongJiBangRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.TongJiBangRes
         * @static
         * @param {pb.ITongJiBangRes} message TongJiBangRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TongJiBangRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TongJiBangRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.TongJiBangRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.TongJiBangRes} TongJiBangRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TongJiBangRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.TongJiBangRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.game = reader.string();
                    break;
                case 2:
                    message.qd = reader.string();
                    break;
                case 3:
                    message.qu = reader.int32();
                    break;
                case 4:
                    if (!(message.bangs && message.bangs.length))
                        message.bangs = [];
                    message.bangs.push($root.pb.MoneyBang.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TongJiBangRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.TongJiBangRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.TongJiBangRes} TongJiBangRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TongJiBangRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TongJiBangRes message.
         * @function verify
         * @memberof pb.TongJiBangRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TongJiBangRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.game != null && message.hasOwnProperty("game"))
                if (!$util.isString(message.game))
                    return "game: string expected";
            if (message.qd != null && message.hasOwnProperty("qd"))
                if (!$util.isString(message.qd))
                    return "qd: string expected";
            if (message.qu != null && message.hasOwnProperty("qu"))
                if (!$util.isInteger(message.qu))
                    return "qu: integer expected";
            if (message.bangs != null && message.hasOwnProperty("bangs")) {
                if (!Array.isArray(message.bangs))
                    return "bangs: array expected";
                for (var i = 0; i < message.bangs.length; ++i) {
                    var error = $root.pb.MoneyBang.verify(message.bangs[i]);
                    if (error)
                        return "bangs." + error;
                }
            }
            return null;
        };

        /**
         * Creates a TongJiBangRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.TongJiBangRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.TongJiBangRes} TongJiBangRes
         */
        TongJiBangRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.TongJiBangRes)
                return object;
            var message = new $root.pb.TongJiBangRes();
            if (object.game != null)
                message.game = String(object.game);
            if (object.qd != null)
                message.qd = String(object.qd);
            if (object.qu != null)
                message.qu = object.qu | 0;
            if (object.bangs) {
                if (!Array.isArray(object.bangs))
                    throw TypeError(".pb.TongJiBangRes.bangs: array expected");
                message.bangs = [];
                for (var i = 0; i < object.bangs.length; ++i) {
                    if (typeof object.bangs[i] !== "object")
                        throw TypeError(".pb.TongJiBangRes.bangs: object expected");
                    message.bangs[i] = $root.pb.MoneyBang.fromObject(object.bangs[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a TongJiBangRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.TongJiBangRes
         * @static
         * @param {pb.TongJiBangRes} message TongJiBangRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TongJiBangRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.bangs = [];
            if (options.defaults) {
                object.game = "";
                object.qd = "";
                object.qu = 0;
            }
            if (message.game != null && message.hasOwnProperty("game"))
                object.game = message.game;
            if (message.qd != null && message.hasOwnProperty("qd"))
                object.qd = message.qd;
            if (message.qu != null && message.hasOwnProperty("qu"))
                object.qu = message.qu;
            if (message.bangs && message.bangs.length) {
                object.bangs = [];
                for (var j = 0; j < message.bangs.length; ++j)
                    object.bangs[j] = $root.pb.MoneyBang.toObject(message.bangs[j], options);
            }
            return object;
        };

        /**
         * Converts this TongJiBangRes to JSON.
         * @function toJSON
         * @memberof pb.TongJiBangRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TongJiBangRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TongJiBangRes;
    })();

    pb.TongJiShiXiRes = (function() {

        /**
         * Properties of a TongJiShiXiRes.
         * @memberof pb
         * @interface ITongJiShiXiRes
         * @property {string} [game] TongJiShiXiRes game
         * @property {string} [qd] TongJiShiXiRes qd
         * @property {number} [qu] TongJiShiXiRes qu
         * @property {Array.<pb.IShiXi>} [shiXs] TongJiShiXiRes shiXs
         */

        /**
         * Constructs a new TongJiShiXiRes.
         * @memberof pb
         * @classdesc Represents a TongJiShiXiRes.
         * @constructor
         * @param {pb.ITongJiShiXiRes=} [properties] Properties to set
         */
        function TongJiShiXiRes(properties) {
            this.shiXs = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TongJiShiXiRes game.
         * @member {string}game
         * @memberof pb.TongJiShiXiRes
         * @instance
         */
        TongJiShiXiRes.prototype.game = "";

        /**
         * TongJiShiXiRes qd.
         * @member {string}qd
         * @memberof pb.TongJiShiXiRes
         * @instance
         */
        TongJiShiXiRes.prototype.qd = "";

        /**
         * TongJiShiXiRes qu.
         * @member {number}qu
         * @memberof pb.TongJiShiXiRes
         * @instance
         */
        TongJiShiXiRes.prototype.qu = 0;

        /**
         * TongJiShiXiRes shiXs.
         * @member {Array.<pb.IShiXi>}shiXs
         * @memberof pb.TongJiShiXiRes
         * @instance
         */
        TongJiShiXiRes.prototype.shiXs = $util.emptyArray;

        /**
         * Creates a new TongJiShiXiRes instance using the specified properties.
         * @function create
         * @memberof pb.TongJiShiXiRes
         * @static
         * @param {pb.ITongJiShiXiRes=} [properties] Properties to set
         * @returns {pb.TongJiShiXiRes} TongJiShiXiRes instance
         */
        TongJiShiXiRes.create = function create(properties) {
            return new TongJiShiXiRes(properties);
        };

        /**
         * Encodes the specified TongJiShiXiRes message. Does not implicitly {@link pb.TongJiShiXiRes.verify|verify} messages.
         * @function encode
         * @memberof pb.TongJiShiXiRes
         * @static
         * @param {pb.ITongJiShiXiRes} message TongJiShiXiRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TongJiShiXiRes.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.game != null && message.hasOwnProperty("game"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.game);
            if (message.qd != null && message.hasOwnProperty("qd"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.qd);
            if (message.qu != null && message.hasOwnProperty("qu"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.qu);
            if (message.shiXs != null && message.shiXs.length)
                for (var i = 0; i < message.shiXs.length; ++i)
                    $root.pb.ShiXi.encode(message.shiXs[i], writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TongJiShiXiRes message, length delimited. Does not implicitly {@link pb.TongJiShiXiRes.verify|verify} messages.
         * @function encodeDelimited
         * @memberof pb.TongJiShiXiRes
         * @static
         * @param {pb.ITongJiShiXiRes} message TongJiShiXiRes message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TongJiShiXiRes.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TongJiShiXiRes message from the specified reader or buffer.
         * @function decode
         * @memberof pb.TongJiShiXiRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {pb.TongJiShiXiRes} TongJiShiXiRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TongJiShiXiRes.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.pb.TongJiShiXiRes();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.game = reader.string();
                    break;
                case 2:
                    message.qd = reader.string();
                    break;
                case 3:
                    message.qu = reader.int32();
                    break;
                case 4:
                    if (!(message.shiXs && message.shiXs.length))
                        message.shiXs = [];
                    message.shiXs.push($root.pb.ShiXi.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TongJiShiXiRes message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof pb.TongJiShiXiRes
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {pb.TongJiShiXiRes} TongJiShiXiRes
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TongJiShiXiRes.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TongJiShiXiRes message.
         * @function verify
         * @memberof pb.TongJiShiXiRes
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TongJiShiXiRes.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.game != null && message.hasOwnProperty("game"))
                if (!$util.isString(message.game))
                    return "game: string expected";
            if (message.qd != null && message.hasOwnProperty("qd"))
                if (!$util.isString(message.qd))
                    return "qd: string expected";
            if (message.qu != null && message.hasOwnProperty("qu"))
                if (!$util.isInteger(message.qu))
                    return "qu: integer expected";
            if (message.shiXs != null && message.hasOwnProperty("shiXs")) {
                if (!Array.isArray(message.shiXs))
                    return "shiXs: array expected";
                for (var i = 0; i < message.shiXs.length; ++i) {
                    var error = $root.pb.ShiXi.verify(message.shiXs[i]);
                    if (error)
                        return "shiXs." + error;
                }
            }
            return null;
        };

        /**
         * Creates a TongJiShiXiRes message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof pb.TongJiShiXiRes
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {pb.TongJiShiXiRes} TongJiShiXiRes
         */
        TongJiShiXiRes.fromObject = function fromObject(object) {
            if (object instanceof $root.pb.TongJiShiXiRes)
                return object;
            var message = new $root.pb.TongJiShiXiRes();
            if (object.game != null)
                message.game = String(object.game);
            if (object.qd != null)
                message.qd = String(object.qd);
            if (object.qu != null)
                message.qu = object.qu | 0;
            if (object.shiXs) {
                if (!Array.isArray(object.shiXs))
                    throw TypeError(".pb.TongJiShiXiRes.shiXs: array expected");
                message.shiXs = [];
                for (var i = 0; i < object.shiXs.length; ++i) {
                    if (typeof object.shiXs[i] !== "object")
                        throw TypeError(".pb.TongJiShiXiRes.shiXs: object expected");
                    message.shiXs[i] = $root.pb.ShiXi.fromObject(object.shiXs[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a TongJiShiXiRes message. Also converts values to other types if specified.
         * @function toObject
         * @memberof pb.TongJiShiXiRes
         * @static
         * @param {pb.TongJiShiXiRes} message TongJiShiXiRes
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TongJiShiXiRes.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.shiXs = [];
            if (options.defaults) {
                object.game = "";
                object.qd = "";
                object.qu = 0;
            }
            if (message.game != null && message.hasOwnProperty("game"))
                object.game = message.game;
            if (message.qd != null && message.hasOwnProperty("qd"))
                object.qd = message.qd;
            if (message.qu != null && message.hasOwnProperty("qu"))
                object.qu = message.qu;
            if (message.shiXs && message.shiXs.length) {
                object.shiXs = [];
                for (var j = 0; j < message.shiXs.length; ++j)
                    object.shiXs[j] = $root.pb.ShiXi.toObject(message.shiXs[j], options);
            }
            return object;
        };

        /**
         * Converts this TongJiShiXiRes to JSON.
         * @function toJSON
         * @memberof pb.TongJiShiXiRes
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TongJiShiXiRes.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TongJiShiXiRes;
    })();

    pb.DayTongJi = (function() {

        /**
         * Properties of a DayTongJi.
         * @memberof pb
         * @interface IDayTongJi
         * @property {string} [day] DayTongJi day
         * @property {number} [peopleAdd] DayTongJi peopleAdd
         * @property {number} [liu] DayTongJi liu
         * @property {number} [liu1] DayTongJi liu1
         * @property {number} [liu3] DayTongJi liu3
         * @property {number} [liu7] DayTongJi liu7
         * @property {number} [moneyNew] DayTongJi moneyNew
         * @property {number} [moneyDay] DayTongJi moneyDay
         * @property {number} [moneyAll] DayTongJi moneyAll
         * @property {number} [moneyNewRen] DayTongJi moneyNewRen
         * @property {number} [moneyDayRen] DayTongJi moneyDayRen
         */

        /**
         * Constructs a new DayTongJi.
         * @memberof pb
         * @classdesc Represents a DayTongJi.
         * @constructor
         * @param {pb.IDayTongJi=} [properties] Properties to set
         */
        function DayTongJi(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DayTongJi day.
         * @member {string}day
         * @memberof pb.DayTongJi
         * @instance
         */
        DayTongJi.prototype.day = "";

        /**
         * DayTongJi peopleAdd.
         * @member {number}peopleAdd
         * @memberof pb.DayTongJi
         * @instance
         */
        DayTongJi.prototype.peopleAdd = 0;

        /**
         * DayTongJi liu.
         * @member {number}liu
         * @memberof pb.DayTongJi
         * @instance
         */
        DayTongJi.prototype.liu = 0;

        /**
         * DayTongJi liu1.
         * @member {number}liu1
         * @memberof pb.DayTongJi
         * @instance
         */
        DayTongJi.prototype.liu1 = 0;

        /**
         * DayTongJi liu3.
         * @member {number}liu3
         * @memberof pb.DayTongJi
         * @instance
         */
        DayTongJi.prototype.liu3 = 0;

        /**
         * DayTongJi liu7.
         * @member {number}liu7
         * @memberof pb.DayTongJi
         * @instance
         */
        DayTongJi.prototype.liu7 = 0;

        /**
         * DayTongJi moneyNew.
         * @member {number}moneyNew
         * @memberof pb.DayTongJi
         * @instance
         */
        DayTongJi.prototype.moneyNew = 0;

        /**
         * DayTongJi moneyDay.
         * @member {number}moneyDay
         * @memberof pb.DayTongJi
         * @instance
         */
        DayTongJi.prototype.moneyDay = 0;

        /**
         * DayTongJi moneyAll.
         * @member {number}moneyAll
         * @memberof pb.DayTongJi
         * @instance
         */
        DayTongJi.prototype.moneyAll = 0;

        /**
         * DayTongJi moneyNewRen.
         * @member {number}moneyNewRen
         * @memberof pb.DayTongJi
         * @instance
         */
        DayTongJi.prototype.moneyNewRen = 0;

        /**
         * DayTongJi moneyDayRen.
         * @member {number}moneyDayRen
         * @memberof pb.DayTongJi
         * @instance
         */
        DayTongJi.prototype.moneyDayRen = 0;

        /**
         * Creates a new DayTongJi instance using the specified properties.
         * @function create
         * @memberof pb.DayTongJi
         * @static
         * @param {pb.IDayTongJi=} [properties] Properties to set
         * @returns {pb.DayTongJi} DayTongJi instance
         */
        DayTongJi.create = function create(properties) {
            return new DayTongJi(properties);
        };

        /**
         * Encodes the specified DayTongJi message. Does not implicitly {@link pb.DayTongJi.verify|verify} messages.
         * @function encode
         * @memberof pb.DayTongJi
         * @static
         * @param {pb.IDayTongJi} message DayTongJi message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DayTongJi.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.day != null && message.hasOwnProperty("day"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.day);
            if (message.peopleAdd != null && message.hasOwnProperty("peopleAdd"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.peopleAdd);
            if (message.liu != null && message.hasOwnProperty("liu"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.liu);
            if (message.liu1 != null && message.hasOwnProperty("liu1"))
                writer.uint32(/* id 4, wireType 0 =*/32).int32(message.liu1);
            if (message.liu3 != null && message.hasOwnProperty("