/**
 * Cocos Creator版本1.6.2
 * 
 * Creat by Bob
 * QQ交流群 465070023
 * 欢迎小伙伴们一起来研究技术
 * 
*/


//行间距  列间距
var RowSpacing = 0;
var LineSpacing = 0;
//计算item的单位
var WIDTH = 0;
var HIGHT = 0;
//列数 
var ROWS = 1;
//可视行数
var VisualLines = 0;
//上边距，左边距
var HEAD = 5;
var LEFT = 5;
var RIGHT = 5;
//当前显示的items的索引idx
var CUR_IDX = 0;

cc.Class({
    extends: cc.Component,

    properties: {
        EmojiAtlas:cc.SpriteAtlas,//表情图集
        view:cc.Node,//遮挡视图
        content:cc.Node,//滚动视图
        item:cc.Node,//自定义item
        isLayout:true,//是否自动布局，自动计算列数
        rows:0,//固定列数（开启自动布局时，列数无效）
        rowSpacing:0,//行间距
        lineSpacing:0,//列间距
        head:0,//上边距
        left:0,//左边距
        right:0,//右边距
    },

    //配置list参数
    setConfig:function(){
        if(this.head > 0) HEAD = this.head;
        if(this.left > 0) LEFT = this.left;
        if(this.right > 0) RIGHT = this.right;
        
        if(this.rowSpacing > 0) RowSpacing = this.rowSpacing;
        if(this.lineSpacing > 0) LineSpacing = this.lineSpacing;
        this.item.anchorX = 0;
        this.item.anchorY = 1;
        WIDTH = this.item.width + RowSpacing;
        HIGHT = this.item.height + LineSpacing;
        this.view.width = this.node.width;
        this.view.height = this.node.height;
        this.content.width = this.node.width;
        if(WIDTH == 0 || HIGHT == 0){
            cc.log("######## 参数错误，请检查item的宽高的值 #######");
            return;
        }
        if(this.isLayout){
            ROWS = parseInt((this.content.width - LEFT - RIGHT) / WIDTH);
        }else{
            ROWS = this.rows;
        }
        if(ROWS < 1){
            cc.log("######## 参数错误，item宽度过大，列数为0 #######");
            return;
        }
        VisualLines = parseInt(this.view.height / HIGHT) + 2;
        cc.log("****************************VisualLines："+ VisualLines);
        
    },

    onLoad: function () {
        //配置参数
        this.setConfig();
        this.itemPool = new cc.NodePool();
        this.itemPool.put(this.item);

        
        this.init(this.EmojiAtlas.getSpriteFrames());
    },

    /**
     * 初始化
     * @param {[]} data
    */
    init:function(data){
        this.data = data;
        this.loadList(this.data);
        this.initScrollViewEvent();
        //设置滚动视图的高度
        let lines = ((data.length - 1) == 0 ? 0 : parseInt((data.length - 1) / ROWS)) + 1;
        this.content.height = HIGHT * lines + HEAD;
    },

    /**
     * *****************************************************************************************
     */
    initScrollViewEvent:function(){
        //滚动监听
        var scrollViewEventHandler = new cc.Component.EventHandler();
        scrollViewEventHandler.target = this.node; //这个 node 节点是你的事件处理代码组件所属的节点
        scrollViewEventHandler.component = "listView";//这个是代码文件名
        scrollViewEventHandler.handler = "scrollviewDidScroll";
        scrollViewEventHandler.customEventData = "foobar";
        var scrollview = this.node.getComponent(cc.ScrollView);
        scrollview.scrollEvents.push(scrollViewEventHandler);
    },

    scrollviewDidScroll:function(scrollview, eventType, customEventData){
        // scrollview 是一个 Scrollview 组件对象实例
        // eventType === cc.ScrollView.EventType enum 里面的值
        // customEventData 参数就等于你之前设置的 "foobar"
        if(eventType == cc.ScrollView.EventType.SCROLLING){
            let p = scrollview.getScrollOffset();
            // cc.log("p:"+p);
            let topLine = p.y > 0 ? p.y : 0;//可视区域的上边
            let bottomLine = p.y + this.view.height;//可视区域下边
            
            //当前显示的行标
            let first_line_idx = parseInt(topLine / HIGHT);
            let last_line_idx = first_line_idx + VisualLines;
    
            let cur_idx = first_line_idx * ROWS - 1;
            if(cur_idx != CUR_IDX){
                cc.log(cur_idx);
                CUR_IDX = cur_idx;
                this.loadList(this.data);
            }
        }
    },

    /**
     * *****************************************************************************************
     */
    /**
     * 加载内容
     */
    loadList:function(data){
        var last;
        if((CUR_IDX + VisualLines * ROWS) > data.length){
            last = data.length;
        }else{
            last = CUR_IDX + VisualLines * ROWS;
        }

        let childs = this.content.getChildren();
        for(var i = CUR_IDX; i <= last; i++){
            let isNew = true;
            for(let j = 0; j < childs.length; j++){
                if(childs[j].tag < CUR_IDX || (childs[j].tag > last)){
                    cc.log("Recovery item");
                    this.itemPool.put(childs[j]);
                }else{
                    if(childs[j].tag == i){
                        isNew = false;
                    }
                }
            }
            if(isNew){
                let item = this.getItem();
                item.tag = i;
                let y_id = i == 0 ? 0 : parseInt(i / ROWS);
                let x_id = i % ROWS;
                item.x = x_id * WIDTH + LEFT;
                item.y = -y_id * HIGHT - HEAD;
                this.loadItem(item, i, data[i]);
            }            
        }
    },

    /**
     * 加载 iItem  
     * 
     */
    loadItem:function(item, tag, data){
        let img = item.getChildByName("img").getComponent(cc.Sprite);
        img.spriteFrame = data;
        item.on(cc.Node.EventType.TOUCH_END,()=>{
            cc.log("TOUCH EMOJI ITEM TAG:"+ tag);
        });
    },

    //对象池获取数据
    getItem:function(){
        let item = null;
        if (this.itemPool.size() > 0) { // 通过 size 接口判断对象池中是否有空闲的对象
            item = this.itemPool.get();
            cc.log("GET Item");
        } else { // 如果没有空闲对象，也就是对象池中备用对象不够时，我们就用 cc.instantiate 重新创建
            item = cc.instantiate(this.item);
            cc.log("Create Item");
        }
        item.parent = this.content;
        return item;
    },
});
