cc.Class({
    extends: cc.Component,

    properties: {
        layout: cc.Node,
    },

    onLoad() {
        this.loadFile();
    },


    button1() {
        let layoutChild = this.layout.children;
        for (let i = 0; i < layoutChild.length; i++) {

            if (layoutChild[i].childrenCount > 0) {
                layoutChild[i].children[0].destroy();
            }

            let image_rand = this.getRandNumber(0, 5);
            let url = this.blocks_image[image_rand]._textureFilename;

            let prefab_rand = this.getRandNumber(0, 21);
            let prefab = cc.instantiate(this.prefabs[prefab_rand]);

            for (let key in prefab.children) {
                let iKey = parseInt(key);
                let sprite = prefab.children[iKey].getComponent(cc.Sprite);
                sprite.spriteFrame = new cc.SpriteFrame();
                sprite.spriteFrame.setTexture(url);

                sprite.spriteFrame._texture.height = 63;
                sprite.spriteFrame._texture.width = 63;
            }
            layoutChild[i].addChild(prefab);
        }
    },


    button2() {
        let layoutChild = this.layout.children;
        for (let i = 0; i < layoutChild.length; i++) {

            if (layoutChild[i].childrenCount > 0) {
                layoutChild[i].children[0].destroy();
            }

            let image_rand = this.getRandNumber(0, 5);
            let image = this.blocks_image[image_rand];

            let prefab_rand = this.getRandNumber(0, 21);
            let array = [prefab_rand, 8];
            let index = array[this.getRandNumber(0, 1)];
            let prefab = cc.instantiate(this.prefabs[index]);

            for (let key in prefab.children) {
                let iKey = parseInt(key);
                let sprite = prefab.children[iKey].getComponent(cc.Sprite);
                sprite.spriteFrame = image;
            }
            layoutChild[i].addChild(prefab);
        }
    },


    getRandNumber(min, max) {
        return Math.floor(Math.random() * (max - min + 1)) + min;
    },


    loadFile(self = this) {

        cc.loader.loadResDir("BlocksImage", cc.SpriteFrame, function (err, object) {
            self.blocks_image = {}; // 方块图片
            for (let i = 0; i < object.length; i++) {
                self.blocks_image[i] = object[i];
            }
        });

        cc.loader.loadResDir("BlocksPrefab", function (err, object) {
            self.prefabs = {}; // 预制体
            for (let i = 0; i < object.length; i++) {
                self.prefabs[i] = object[i];
            }
        });
    }
});
