(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Game.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '4596dgGIBBJc5FLEvhLtB82', 'Game', __filename);
// Game.js

"use strict";

cc.Class({
    extends: cc.Component,

    properties: {
        layout: cc.Node
    },

    onLoad: function onLoad() {
        this.loadFile();
    },
    button1: function button1() {
        var layoutChild = this.layout.children;
        for (var i = 0; i < layoutChild.length; i++) {

            if (layoutChild[i].childrenCount > 0) {
                layoutChild[i].children[0].destroy();
            }

            var image_rand = this.getRandNumber(0, 5);
            var url = this.blocks_image[image_rand]._textureFilename;

            var prefab_rand = this.getRandNumber(0, 21);
            var prefab = cc.instantiate(this.prefabs[prefab_rand]);

            for (var key in prefab.children) {
                var iKey = parseInt(key);
                var sprite = prefab.children[iKey].getComponent(cc.Sprite);
                sprite.spriteFrame = new cc.SpriteFrame();
                sprite.spriteFrame.setTexture(url);

                sprite.spriteFrame._texture.height = 63;
                sprite.spriteFrame._texture.width = 63;
            }
            layoutChild[i].addChild(prefab);
        }
    },
    button2: function button2() {
        var layoutChild = this.layout.children;
        for (var i = 0; i < layoutChild.length; i++) {

            if (layoutChild[i].childrenCount > 0) {
                layoutChild[i].children[0].destroy();
            }

            var image_rand = this.getRandNumber(0, 5);
            var image = this.blocks_image[image_rand];

            var prefab_rand = this.getRandNumber(0, 21);
            var array = [prefab_rand, 8];
            var index = array[this.getRandNumber(0, 1)];
            var prefab = cc.instantiate(this.prefabs[index]);

            for (var key in prefab.children) {
                var iKey = parseInt(key);
                var sprite = prefab.children[iKey].getComponent(cc.Sprite);
                sprite.spriteFrame = image;
            }
            layoutChild[i].addChild(prefab);
        }
    },
    getRandNumber: function getRandNumber(min, max) {
        return Math.floor(Math.random() * (max - min + 1)) + min;
    },
    loadFile: function loadFile() {
        var self = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this;


        cc.loader.loadResDir("BlocksImage", cc.SpriteFrame, function (err, object) {
            self.blocks_image = {}; // 方块图片
            for (var i = 0; i < object.length; i++) {
                self.blocks_image[i] = object[i];
            }
        });

        cc.loader.loadResDir("BlocksPrefab", function (err, object) {
            self.prefabs = {}; // 预制体
            for (var i = 0; i < object.length; i++) {
                self.prefabs[i] = object[i];
            }
        });
    }
});

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=Game.js.map
        