const {ccclass, property} = cc._decorator;
const TIME = 2;
@ccclass
export default class Helloworld extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';

    @property(cc.Sprite)
    img:cc.Sprite = null;

    start () {
        // init logic
        this.label.string = this.text;
    }

    time1 = 0;
    time2 = 0;
    
    update(dt){
        this.time1 += dt;
        if(this.time1<1){
            return;
        }
        this.time1 = 0;

        this.time2 += dt;
        let bar = this.img.getComponent(cc.ProgressBar);
        bar.progress = this.time2 / TIME;
        console.log("bar.progress" , bar.progress)
        if(this.time2 > TIME){
            this.time2 = 0;
        }
    }
}
