System.register(["cc", "code-quality:cr", "./AStarNode.js"], function (_export, _context) {
  "use strict";

  var _cclegacy, _reporterNs, _decorator, Component, Vec2, AStarNode, E_Node_Type, _dec, _class, _class2, _temp, _crd, ccclass, property, AStarMgr;

  function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

  function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

  function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

  function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

  function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

  function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

  function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

  function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

  function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

  function _reportPossibleCrUseOfAStarNode(extras) {
    _reporterNs.report("AStarNode", "./AStarNode", _context.meta, extras);
  }

  function _reportPossibleCrUseOfE_Node_Type(extras) {
    _reporterNs.report("E_Node_Type", "./AStarNode", _context.meta, extras);
  }

  _export({
    _dec: void 0,
    _class: void 0,
    _class2: void 0,
    _temp: void 0
  });

  return {
    setters: [function (_cc) {
      _cclegacy = _cc.cclegacy;
      _decorator = _cc._decorator;
      Component = _cc.Component;
      Vec2 = _cc.Vec2;
    }, function (_codeQualityCr) {
      _reporterNs = _codeQualityCr;
    }, function (_AStarNodeJs) {
      AStarNode = _AStarNodeJs.AStarNode;
      E_Node_Type = _AStarNodeJs.E_Node_Type;
    }],
    execute: function () {
      _cclegacy._RF.push({}, "7823cv6QmlMkb4FfyafPntl", "AStarMgr", _context.meta);

      _crd = true;
      ccclass = _decorator.ccclass;
      property = _decorator.property; /// <summary>
      /// AStar寻路算法的基本原理就是不停的找自己周围的点，选出一个新的点作为起点再循环的找
      /// 1.寻路消耗公式：
      ///           f(寻路消耗)=g(离起点的距离)+h(离终点的距离)
      /// 2.开启列表：
      /// 每次从新的点找周围的点时，如果周围的点已经在开启列表或者关闭列表中了，我们就不去管它了
      /// 3.关闭列表：
      /// 每次往关闭列表中放点时，我们都应该判断这个点是不是和终点一样，如果是一样证明路径找完了，如果不一样，继续找。
      /// 4.格子对象的父对象
      /// </summary>

      _export("AStarMgr", AStarMgr = (_dec = ccclass('AStartMgr'), _dec(_class = (_temp = _class2 = /*#__PURE__*/function (_Component) {
        _inherits(AStarMgr, _Component);

        _createClass(AStarMgr, null, [{
          key: "Instance",
          value: function Instance() {
            return this.instance;
          }
          /**
           * 寻路损耗 1
           *
           * @private
           * @memberof AStarMgr
           */

        }]);

        function AStarMgr() {
          var _this;

          _classCallCheck(this, AStarMgr);

          _this = _possibleConstructorReturn(this, _getPrototypeOf(AStarMgr).call(this));
          _this.g1 = 1;
          _this.g2 = 1.4;
          _this.nodes = new Array();
          _this.openLst = new Array();
          _this.closeLst = new Array();
          _this.nearLst = new Array(8);
          _this.path = new Array();
          _this.isEightTrans = false;
          _this.justTop = null;
          _this.justLeft = null;
          _this.justRight = null;
          _this.justDown = null;
          _this.leftToTop = null;
          _this.rightToTop = null;
          _this.leftToDown = null;
          _this.rightToDown = null;
          _this.isChangeTrans = false;
          AStarMgr.instance = _assertThisInitialized(_this);
          return _this;
        }

        _createClass(AStarMgr, [{
          key: "Init",
          value: function Init() {
            //AStarMgr.instance=this;
            console.log("AStarMgr Init...");
          }
        }, {
          key: "update",
          value: function update() {
            this.UpdateAStar();
          }
          /**
           * 更新AStar  寻路路径
           */

        }, {
          key: "UpdateAStar",
          value: function UpdateAStar() {
            var self = this; //如果找到了目标
            //只是暂时停止寻路
            //如果角色没有死亡，当玩家位置改变时，重新寻路
            //解决方法，定时检测，触发检测

            if (self.isChangeTrans != false) {} //self.FindPath();
            //console.log("Update AStar Path finding ...")

          }
          /**
           * 初始化地图
           * @param w 地图的宽
           * @param h 地图的高
           */

        }, {
          key: "InitMapInfo",
          value: function InitMapInfo(w, h) {
            //根据宽高 创建格子 阻挡的问题 我们可以随机阻挡
            //因为我们现在没有地图相关的数据
            var self = this; //记录宽高

            self.mapW = w;
            self.mapH = h; //声明容器可以装多少个格子
            //self.nodes= new AStarNode[w][h];
            //生成格子

            for (var i = 0; i < w; ++i) {
              //console.log("self.nodes.length:" + self.nodes.length);
              self.nodes[i] = [];

              for (var j = 0; j < h; ++j) {
                //用三目运算符随机生成阻挡格子
                //应该从地图配置表读取生成的
                //let nodeObj: AStarNode = new AStarNode(i, j, (self.RandomNum(0, 100) < 20 ? E_Node_Type.Stop : E_Node_Type.Walk));
                var nodeObj = new (_crd && AStarNode === void 0 ? (_reportPossibleCrUseOfAStarNode({
                  error: Error()
                }), AStarNode) : AStarNode)(i, j, (_crd && E_Node_Type === void 0 ? (_reportPossibleCrUseOfE_Node_Type({
                  error: Error()
                }), E_Node_Type) : E_Node_Type).Walk);
                self.nodes[i][j] = nodeObj;
              }
            } //测试用的 


            self.nodes[0][0].type = (_crd && E_Node_Type === void 0 ? (_reportPossibleCrUseOfE_Node_Type({
              error: Error()
            }), E_Node_Type) : E_Node_Type).Stop;
            self.nodes[1][0].type = (_crd && E_Node_Type === void 0 ? (_reportPossibleCrUseOfE_Node_Type({
              error: Error()
            }), E_Node_Type) : E_Node_Type).Stop;
            self.nodes[4][0].type = (_crd && E_Node_Type === void 0 ? (_reportPossibleCrUseOfE_Node_Type({
              error: Error()
            }), E_Node_Type) : E_Node_Type).Stop; //self.nodes[3][2].type = E_Node_Type.Stop;//测试对角是阻挡时取消注释这句

            self.nodes[4][2].type = (_crd && E_Node_Type === void 0 ? (_reportPossibleCrUseOfE_Node_Type({
              error: Error()
            }), E_Node_Type) : E_Node_Type).Stop;
            self.nodes[1][4].type = (_crd && E_Node_Type === void 0 ? (_reportPossibleCrUseOfE_Node_Type({
              error: Error()
            }), E_Node_Type) : E_Node_Type).Stop;
            self.nodes[2][3].type = (_crd && E_Node_Type === void 0 ? (_reportPossibleCrUseOfE_Node_Type({
              error: Error()
            }), E_Node_Type) : E_Node_Type).Stop;
            self.nodes[2][4].type = (_crd && E_Node_Type === void 0 ? (_reportPossibleCrUseOfE_Node_Type({
              error: Error()
            }), E_Node_Type) : E_Node_Type).Stop; //剔除不必要的点
            //self.WayPathMemory();
          }
          /**
           * 寻路时产生的记忆
           * 或者说生成地图时，存入不可穿越的点
           * 用于优化AStar
           * @memberof AStarMgr
           */

        }, {
          key: "WayPathMemory",
          value: function WayPathMemory() {
            //地图数据是一定的
            //所以阻挡点也是一定的
            var self = this; //可能多此一举

            self.nodes.forEach(function (element) {
              var tempNode = element;

              if (tempNode.type == (_crd && E_Node_Type === void 0 ? (_reportPossibleCrUseOfE_Node_Type({
                error: Error()
              }), E_Node_Type) : E_Node_Type).Stop) {
                delete self.nodes[tempNode.x][tempNode.y]; //self.nodes.filter(tempNode => tempNode !== self.nodes);

                console.log("Remove element at self.nodes");
              }
            });
            console.log("WayPath memory is save...");
          }
          /**
           * 寻路方法
           * @param startPos 开始点
           * @param endPos 结束点
           */

        }, {
          key: "FindPath",
          value: function FindPath(startPos, endPos) {
            console.log("StartPos is:" + startPos + " " + "EndPos is:" + endPos);
            var self = this; //实际项目中 传入的点往往是 坐标系中的点
            //我们这里省略换算的步骤 直接认为它是传进来的格子坐标
            //首先判断 传入的两个点 是否合法
            //1.首先 要在地图范围内
            //如果不合法 应该直接 返回null 意味着不能寻路

            if (startPos.x < 0 || startPos.x >= self.mapW || startPos.y < 0 || startPos.y >= self.mapH || endPos.x < 0 || endPos.x >= self.mapW || endPos.y < 0 || endPos.y >= self.mapH) {
              console.log("Start or end points are outside the map grid");
              return null;
            } //2.要不是阻挡
            //得到起点和终点  对应的格子


            var start = self.nodes[startPos.x][startPos.y];
            var end = self.nodes[endPos.x][endPos.y];

            if (start.type == (_crd && E_Node_Type === void 0 ? (_reportPossibleCrUseOfE_Node_Type({
              error: Error()
            }), E_Node_Type) : E_Node_Type).Stop || end.type == (_crd && E_Node_Type === void 0 ? (_reportPossibleCrUseOfE_Node_Type({
              error: Error()
            }), E_Node_Type) : E_Node_Type).Stop) {
              console.log("The start or end point is the block");
              return null;
            } //清空上一次相关的数据 避免他们影响  这一次的寻路计算
            //清空关闭和开启列表


            self.closeLst = [];
            self.openLst = []; //把开始点放入关闭列表中

            start.father = null;
            start.f = 0;
            start.g = 0;
            start.h = 0;
            self.closeLst.push(start);

            while (true) {
              self.nearLst = []; //存储周围8个点

              self.JustPassPath(start, end); //死路判断  开启列表为空 都还没有找到终点 就认为是死路

              if (self.openLst.length == 0) {
                console.log("Blind alley...");
                return null;
              } //选出开启列表中 寻路消耗最小的点


              self.openLst.sort(self.SortOpenLst); //console.log("****************");

              /*for (let i = 0; i < self.openLst.length; ++i) {
                   let targetNode = self.openLst[i];
                   //console.log("Point:" + targetNode.x + " ," + targetNode.y + "  :g=" + targetNode.g + "  h=" + targetNode.h + "  f=" + targetNode.f);
               }*/
              //放入关闭列表中 然后再从开启列表中移除

              self.closeLst.push(self.openLst[0]); //找得这个点 又变成新的起点 进入下一次寻路计算了

              start = self.openLst[0];
              self.openLst.shift(); //如果这个点已经是终点 那么得到最终结果返回出去
              //如果这个点 不是终点 那么继续寻路

              if (start == end) {
                //找完了 找到路径
                //返回路径
                self.path = [];
                self.path.push(end); //father是空时是找到start点，start点的father就是空

                while (end.father != null) {
                  self.path.push(end.father);
                  end = end.father;
                } //列表翻正得到正确的路径


                self.path.reverse();
                return self.path;
              }
            }
          }
          /**
           * 排序函数
           * @param a
           * @param b
           */

        }, {
          key: "SortOpenLst",
          value: function SortOpenLst(a, b) {
            if (a.f > b.f) return 1;else if (a.f == b.f) return 1;else return -1;
          }
        }, {
          key: "JustPassPath",
          value: function JustPassPath(start, end) {
            var self = this; //拿到各个节点
            //正上

            self.justTop = self.GetAStarNode(start.x, start.y + 1, self.g1); //正左

            self.justLeft = self.GetAStarNode(start.x - 1, start.y, self.g1); //正右

            self.justRight = self.GetAStarNode(start.x + 1, start.y, self.g1); //正下

            self.justDown = self.GetAStarNode(start.x, start.y - 1, self.g1); //左上

            self.leftToTop = self.GetAStarNode(start.x - 1, start.y + 1, self.g2); //左下

            self.leftToDown = self.GetAStarNode(start.x - 1, start.y - 1, self.g2); //右上

            self.rightToTop = self.GetAStarNode(start.x + 1, start.y + 1, self.g2); //右下

            self.rightToDown = self.GetAStarNode(start.x + 1, start.y - 1, self.g2); //从起点开始 找周围的点 并放入邻近列表中

            if (self.leftToTop != null && (self.justTop.type == (_crd && E_Node_Type === void 0 ? (_reportPossibleCrUseOfE_Node_Type({
              error: Error()
            }), E_Node_Type) : E_Node_Type).Stop || self.justLeft.type == (_crd && E_Node_Type === void 0 ? (_reportPossibleCrUseOfE_Node_Type({
              error: Error()
            }), E_Node_Type) : E_Node_Type).Stop)) {
              //移除左上
              self.leftToTop = null;
            }

            if (self.rightToTop != null && (self.justTop.type == (_crd && E_Node_Type === void 0 ? (_reportPossibleCrUseOfE_Node_Type({
              error: Error()
            }), E_Node_Type) : E_Node_Type).Stop || self.justRight.type == (_crd && E_Node_Type === void 0 ? (_reportPossibleCrUseOfE_Node_Type({
              error: Error()
            }), E_Node_Type) : E_Node_Type).Stop)) {
              //移除右上
              self.rightToTop = null;
            }

            if (self.leftToDown != null && (self.justDown.type == (_crd && E_Node_Type === void 0 ? (_reportPossibleCrUseOfE_Node_Type({
              error: Error()
            }), E_Node_Type) : E_Node_Type).Stop || self.justLeft.type == (_crd && E_Node_Type === void 0 ? (_reportPossibleCrUseOfE_Node_Type({
              error: Error()
            }), E_Node_Type) : E_Node_Type).Stop)) {
              //移除左下
              self.leftToDown = null;
            }

            if (self.rightToDown != null && (self.justDown.type == (_crd && E_Node_Type === void 0 ? (_reportPossibleCrUseOfE_Node_Type({
              error: Error()
            }), E_Node_Type) : E_Node_Type).Stop || self.justRight.type == (_crd && E_Node_Type === void 0 ? (_reportPossibleCrUseOfE_Node_Type({
              error: Error()
            }), E_Node_Type) : E_Node_Type).Stop)) {
              //移除右下
              self.rightToDown = null;
            } //把不为空的邻近点添加进列表


            self.AddNearLst(self.justTop);
            self.AddNearLst(self.justDown);
            self.AddNearLst(self.justLeft);
            self.AddNearLst(self.justRight);
            self.AddNearLst(self.leftToTop);
            self.AddNearLst(self.leftToDown);
            self.AddNearLst(self.rightToTop);
            self.AddNearLst(self.rightToDown); //Debug.Log("数组长度：" + nearLst.Count);
            //把符合条件的点放入开启列表

            for (var i = 0; i < self.nearLst.length; i++) {
              //Debug.Log("当前遍历哪个数组：" + i);
              self.FindNearlyNodeToOpenLst(self.nearLst[i], start, end); //Debug.Log("开启列表中有哪些数据：" + openLst[i].ToString());
            }
          }
          /**
           *  把临近的点放入开启列表中的函数
           * @param x X坐标
           * @param y Y坐标
           * @param g 寻路损耗
           * @param father 父节点
           * @param end
           */

        }, {
          key: "FindNearlyNodeToOpenLst",
          value: function FindNearlyNodeToOpenLst(tempNode, father, end) {
            var self = this; //判断这些点 是否是边界 是否是阻挡 是否在开启或者关闭列表 如果都不是 才放入开启列表

            if (tempNode == null || tempNode.type == (_crd && E_Node_Type === void 0 ? (_reportPossibleCrUseOfE_Node_Type({
              error: Error()
            }), E_Node_Type) : E_Node_Type).Stop) return;

            if (self.IsInArray(self.closeLst, tempNode) || self.IsInArray(self.openLst, tempNode)) {} else {
              //计算f值
              //f=g+h
              //记录父对象
              tempNode.father = father; //如果通过了上面的合法验证 存放到开启列表中

              self.openLst.push(tempNode);
            } //计算g  我离起点的距离  就是我父节点离起点的距离 +我离我父节点的距离


            tempNode.g = father.g + tempNode.g; //曼哈顿街区算法（这个算法有错）斜向或者任意方向不能用它 
            // tempNode.h = Math.abs(end.x - tempNode.x) + Math.abs(end.y - tempNode.y)
            //欧几里得距离公式适用于各个角度，但Astar算法八方向以上的寻路就没有必要了
            //let v1: Vec2 = new Vec2(Math.abs(end.x - tempNode.x), Math.abs(end.y - tempNode.y));
            //let v2: Vec2 = new Vec2(0, 0);
            //tempNode.h= Vec2.distance(v1, v2);
            //tempNode.h = Vec2.distance(tempNode, end);

            tempNode.h = Vec2.distance(end, tempNode); //tempNode.h = Vec2.distance(new Vec2(end.x,end.y),new Vec2(tempNode.x,tempNode.y));//为什么只有这样才可以？
            //tempNode.h = Vec2.distance(new Vec2(tempNode.x, tempNode.y), new Vec2(end.x, end.y));

            /*let dx=Math.abs(end.x-tempNode.x);
            let dy=Math.abs(end.y-tempNode.y);
            tempNode.g=1.4*Math.sqrt(dx*dx+dy*dy);*/

            tempNode.f = tempNode.g + tempNode.h;
            console.log("tempNode is:" + tempNode.x + "," + tempNode.y);
          }
          /**
           *  获取邻近节点
           * @param x 
           * @param y 
           * @param g 
           */

        }, {
          key: "GetAStarNode",
          value: function GetAStarNode(x, y, g) {
            var self = this;
            if (x < 0 || x >= self.mapW) return null;
            if (y < 0 || y >= self.mapH) return null; //在范围内 再去取点

            var node = self.nodes[x][y];
            node.g = g;
            return node;
          }
          /**
           * 添加进邻近列表
           * @param node
           */

        }, {
          key: "AddNearLst",
          value: function AddNearLst(node) {
            var self = this;
            console.log("self.nearLst.includes(node) is:" + self.nearLst.includes(node));

            if (node != null && self.IsInArray(self.nearLst, node) == false) {
              self.nearLst.push(node);
            }
          }
          /**
           * 是否在数组里
           * @param arr
           * @param target
           */

        }, {
          key: "IsInArray",
          value: function IsInArray(arr, target) {
            var isExit = false;
            arr.find(function (val) {
              if (val == target) return isExit = true;
            });
            return isExit;
          }
          /**
           * 生成随机数
           * @param min 最小值
           * @param max 最大值
           */

        }, {
          key: "RandomNum",
          value: function RandomNum(min, max) {
            switch (arguments.length) {
              case 1:
                return parseInt((Math.random() * min + 1).toString(), 10);
                break;

              case 2:
                return parseInt((Math.random() * (max - min + 1) + min).toString(), 10);
                break;

              default:
                return 0;
                break;
            }
          }
          /**
           * 获取玩家所在的格子
           * @param pos1 玩家二维坐标
           * @param pos2 追寻者二维坐标
           */

        }, {
          key: "GetPlayerGrid",
          value: function GetPlayerGrid(pos1, pos2) {
            var self = this; //通过pos去查找Grid
            //首先Grid不一定与玩家坐标对应
            //但与玩家周围的格子相邻
            //传进的坐标是Vec2，这意味着玩家Vec3坐标剔除Y坐标

            console.log("What about pos is:" + pos1); //可以采用碰撞检测，但那太耗性能

            var minDis = 0;
            var isCalDisFrist = true;
            var targetPosArr = [];
            var targetPos = Vec2.ZERO; //以玩家为中心，获取周围8个点或者any

            var nearGridLst = self.CetGridLstByPlayerPos(pos1);
            nearGridLst.forEach(function (element) {
              var tempGrid = element; //计算两点距离

              var v2 = new Vec2(tempGrid.x, tempGrid.y);
              console.log("What about v2 is:" + v2.toString());
              var curDis = self.CalDistance(pos1, v2);
              console.log("CurDis is:" + curDis); //循环检测获得最短的那个点

              if (isCalDisFrist == false) {
                if (curDis < minDis) {
                  minDis = curDis; //距离最短的点可能有多个

                  targetPosArr.push(v2);
                  console.log("Push element to targetPosArr...");
                } //会出现两种情况：
                //1.在格子里
                //2.在两个格子边界中

              } else {
                //一般来讲，两点不重合的话，距离是大于零的
                //这里用于第一次赋值minDis
                minDis = curDis; //第一次赋值时，也应该push

                targetPosArr.push(v2);
                console.log("Push element to targetPosArr in frist...");
              }
            }); //距离最短可能有多个点，我们只取与追捕者视线一致的点
            //这个想法可能也是错的
            //因为有阻挡区域

            var isCalAngleFrist = true;
            var minAngle = 0; //计算角度

            targetPosArr.forEach(function (element) {
              var tempVec2 = element; //拿到最小角度
              //会不会有问题？正负弧度应该不会出现

              var curAngle = self.CalAngle(tempVec2, pos2);
              console.log("What about curAngle is:" + curAngle);

              if (isCalAngleFrist == false) {
                if (curAngle < minAngle) {
                  minAngle = curAngle;
                  targetPos = tempVec2;
                  console.log("What about minAngle is:" + minAngle);
                }
              } else {
                minAngle = curAngle;
                targetPos = tempVec2;
              }
            }); //最后根据点拿到对应的AStarNode

            var targetPlayerNode = self.nodes[targetPos.x][targetPos.y];
            return targetPlayerNode;
          }
          /**
           *  计算两点之间的角度
           * @param v1
           * @param v2
           */

        }, {
          key: "CalAngle",
          value: function CalAngle(v1, v2) {
            var angle = Vec2.angle(v1, v2);
            console.log("The angle is:" + angle);
            var eurgle = angle * (360 / Math.PI);
            console.log("The eurgle is:" + eurgle);
            return angle;
          }
          /**
           * 获取以玩家为中心，周围8个点或三个点或两个点或一个点????
           * @param p1 玩家节点
           */

        }, {
          key: "CetGridLstByPlayerPos",
          value: function CetGridLstByPlayerPos(p1) {
            var self = this; //首先划分格子大小一定要有序并且适当、无小数
            //例如：10*10的地图，长度为10宽度也为10，（0，0）（0，1）（0，2）...
            //这样做的好处就是能使问题简单化
            //其次，玩家不可能身处阻挡区域
            //对p1的X,Y分别四舍五入
            //规整化

            var targerX = Math.round(p1.x);
            var targerY = Math.round(p1.y);
            var pos = new Vec2(targerX, targerY); //获取玩家为中心8个点或一个点

            var targetNodeLst = new Array();
            var tempGrid = null; //#region 如果玩家位于边界
            //如果玩家位于边界
            //只需取一点
            //可能位于两点之间
            //最终是哪一点取决于四舍五入的结果

            if (self.IsAtBound(pos) == true) {
              targetNodeLst.push(pos);
              console.log("Pos is at bound");
            } //#endregion
            //#region  如果玩家不位于边界
            else {
                //左上  x-1 y-1
                tempGrid = self.nodes[targerX - 1][targerY + 1];
                targetNodeLst.push(tempGrid); //上 x  y-1

                tempGrid = self.nodes[targerX][targerY + 1];
                targetNodeLst.push(tempGrid); //右上  x+1 y-1

                tempGrid = self.nodes[targerX + 1][targerY + 1];
                targetNodeLst.push(tempGrid); //左 x-1 y

                tempGrid = self.nodes[targerX - 1][targerY];
                targetNodeLst.push(tempGrid); //右 x+1 y

                tempGrid = self.nodes[targerX + 1][targerY];
                targetNodeLst.push(tempGrid); //左下 x-1 y+1

                tempGrid = self.nodes[targerX - 1][targerY - 1];
                targetNodeLst.push(tempGrid); //下 x y+1

                tempGrid = self.nodes[targerX][targerY - 1];
                targetNodeLst.push(tempGrid); //右下 x+1 y+1

                tempGrid = self.nodes[targerX + 1][targerY - 1];
                targetNodeLst.push(tempGrid);
                console.log("GetGridLstByPlayerPos return lst:" + targetNodeLst[0]);
              }

            return targetNodeLst; //#endregion
          }
          /**
           *  删除指定元素
           * @param arr
           * @param target
           */

        }, {
          key: "DelteArray",
          value: function DelteArray(arr, target) {
            var self = this;

            for (var i = 0; i < arr.length; i++) {
              if (arr[i] == target) {
                arr.splice(target, 1);
              }
            }
          }
          /**
           * 是否在边界/是否接近边界
           * @param pos 传入规整化的坐标
           */

        }, {
          key: "IsAtBound",
          value: function IsAtBound(pos) {
            var isAtBound = false; //边界判断

            if (pos.x < 0 || pos.y >= self.mapW || pos.x < 0 || pos.y >= self.mapH) isAtBound = true;
            return isAtBound;
          }
          /**
           * 计算两点之间的距离
           * @param v1 起点 (玩家二维坐标)
           * @param v2 终点 (nodes里的点)
           */

        }, {
          key: "CalDistance",
          value: function CalDistance(v1, v2) {
            var disVal = Vec2.distance(v1, v2);
            console.log("CalDistance's value is:" + disVal);
            return disVal;
          }
        }]);

        return AStarMgr;
      }(Component), _class2.instance = null, _temp)) || _class));

      _crd = false;

      _cclegacy._RF.pop();
    }
  };
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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