System.register(["cc", "code-quality:cr", "./Grid.js"], function (_export, _context) {
  "use strict";

  var _cclegacy, _reporterNs, _decorator, Component, Node, GraphicsComponent, systemEvent, SystemEventType, Color, Vec2, GridType, Grid, _dec, _dec2, _dec3, _class, _class2, _descriptor, _descriptor2, _temp, _crd, ccclass, property, AStar;

  function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

  function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

  function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

  function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

  function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

  function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

  function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

  function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  function _reportPossibleCrUseOfGridType(extras) {
    _reporterNs.report("GridType", "./Grid", _context.meta, extras);
  }

  function _reportPossibleCrUseOfGrid(extras) {
    _reporterNs.report("Grid", "./Grid", _context.meta, extras);
  }

  _export({
    _dec: void 0,
    _dec2: void 0,
    _dec3: void 0,
    _class: void 0,
    _class2: void 0,
    _descriptor: void 0,
    _descriptor2: void 0,
    _temp: void 0
  });

  return {
    setters: [function (_cc) {
      _cclegacy = _cc.cclegacy;
      _decorator = _cc._decorator;
      Component = _cc.Component;
      Node = _cc.Node;
      GraphicsComponent = _cc.GraphicsComponent;
      systemEvent = _cc.systemEvent;
      SystemEventType = _cc.SystemEventType;
      Color = _cc.Color;
      Vec2 = _cc.Vec2;
    }, function (_codeQualityCr) {
      _reporterNs = _codeQualityCr;
    }, function (_GridJs) {
      GridType = _GridJs.GridType;
      Grid = _GridJs.Grid;
    }],
    execute: function () {
      _cclegacy._RF.push({}, "f2f51STBOdFZrD5Lr/JJcb+", "AStar", _context.meta);

      _crd = true;
      ccclass = _decorator.ccclass;
      property = _decorator.property;

      _export("AStar", AStar = (_dec = ccclass('AStar'), _dec2 = property({
        type: Node
      }), _dec3 = property({
        type: GraphicsComponent
      }), _dec(_class = (_class2 = (_temp = /*#__PURE__*/function (_Component) {
        _inherits(AStar, _Component);

        /**
         * 格子列表
         */

        /**
         * 路径数组
         */

        /**
         * 开启列表
         */

        /**
         * 关闭列表
         */
        function AStar() {
          var _this;

          _classCallCheck(this, AStar);

          _this = _possibleConstructorReturn(this, _getPrototypeOf(AStar).call(this));

          _initializerDefineProperty(_this, "mapPos", _descriptor, _assertThisInitialized(_this));

          _initializerDefineProperty(_this, "map", _descriptor2, _assertThisInitialized(_this));

          _this.gridsLst = new Array();
          _this.path = null;
          _this.openLst = null;
          _this.closeLst = null;
          _this.map;
          return _this;
        }

        _createClass(AStar, [{
          key: "onLoad",
          value: function onLoad() {
            this.gridW = 50;
            this.gridH = 50;
            this.mapH = 15;
            this.mapW = 25;
            this.is8dir = true;
            systemEvent.on(SystemEventType.TOUCH_START, this.OnTouchStart, this);
            systemEvent.on(SystemEventType.TOUCH_MOVE, this.OnTouchMove, this);
            systemEvent.on(SystemEventType.TOUCH_START, this.OnTouchEnd, this); //初始化map
            //this.map=this.mapPos.getComponent<GraphicsComponent>();
            //初始化地图

            this.InitMap();
          }
          /**
           * 当触摸开始时
           */

        }, {
          key: "OnTouchStart",
          value: function OnTouchStart() {} // this.InitMap();

          /** 
           * 当触摸时
          */

        }, {
          key: "OnTouchMove",
          value: function OnTouchMove(event) {
            var pos = event.getLocation();
            var x = Math.floor(pos.x / (this.gridW + 2));
            var y = Math.floor(pos.y / (this.gridH + 2));

            if (this.gridsLst[x][y].type == (_crd && GridType === void 0 ? (_reportPossibleCrUseOfGridType({
              error: Error()
            }), GridType) : GridType).Normal) {
              this.gridsLst[x][y].type = (_crd && GridType === void 0 ? (_reportPossibleCrUseOfGridType({
                error: Error()
              }), GridType) : GridType).Barrier;
              this.Draw(x, y, Color.CYAN);
            }
          }
          /**
           * 当触摸结束时
           */

        }, {
          key: "OnTouchEnd",
          value: function OnTouchEnd() {
            // 开始寻路
            this.FindPath(new Vec2(1, 2), new Vec2(16, 3));
          }
          /**
           * 初始化地图
           */

        }, {
          key: "InitMap",
          value: function InitMap() {
            this.openLst = new Array();
            this.closeLst = new Array();
            this.path = new Array(); // 初始化格子二维数组

            this.gridsLst = new Array(this.mapW + 1);

            for (var col = 0; col < this.gridsLst.length; col++) {
              this.gridsLst[col] = new Array(this.mapH + 1);
            }

            console.log("map 是否存在：" + this.map);
            this.map.clear();

            for (var _col = 0; _col <= this.mapW; _col++) {
              for (var row = 0; row <= this.mapH; row++) {
                this.Draw(_col, row, Color.WHITE);
                this.AddGrid(_col, row, (_crd && GridType === void 0 ? (_reportPossibleCrUseOfGridType({
                  error: Error()
                }), GridType) : GridType).Normal);
              }
            } // 设置起点和终点


            var startX = 1;
            var startY = 2;
            var endX = 16;
            var endY = 3;
            this.gridsLst[startX][startY].type = (_crd && GridType === void 0 ? (_reportPossibleCrUseOfGridType({
              error: Error()
            }), GridType) : GridType).Start;
            this.Draw(startX, startY, Color.MAGENTA);
            this.gridsLst[endX][endY].type = (_crd && GridType === void 0 ? (_reportPossibleCrUseOfGridType({
              error: Error()
            }), GridType) : GridType).End;
            this.Draw(endX, endY, Color.BLUE);
          }
          /**
           * 添加格子
           * @param x 列
           * @param y 行
           * @param type 格子类型
           */

        }, {
          key: "AddGrid",
          value: function AddGrid(x, y, type) {
            var grid = new (_crd && Grid === void 0 ? (_reportPossibleCrUseOfGrid({
              error: Error()
            }), Grid) : Grid)();
            grid.x = x;
            grid.y = y;
            grid.type = type;
            this.gridsLst[x][y] = grid;
          }
          /**
           * 排序方法
           * @param x 格子1
           * @param y 格子2
           */

        }, {
          key: "SortFunc",
          value: function SortFunc(x, y) {
            return x.f - y.f;
          }
          /**
           * 生成路径
           * @param grid 
           */

        }, {
          key: "GeneratePath",
          value: function GeneratePath(grid) {
            this.path.push(grid);

            while (grid.parent) {
              grid = grid.parent;
              this.path.push(grid);
            }

            console.log("Path.length: " + this.path.length);

            for (var i = 0; i < this.path.length; i++) {
              // 起点终点不覆盖，方便看效果
              if (i != 0 && i != this.path.length - 1) {
                var _grid = this.path[i];
                this.Draw(_grid.x, _grid.y, Color.GREEN);
              }
            }
          }
          /**
            * 找到路径
            * @param startPos 起点
            * @param endPos 终点
            */

        }, {
          key: "FindPath",
          value: function FindPath(startPos, endPos) {
            //首先判断 传入的两个点 是否合法
            //1.首先 要在地图范围内
            //如果不合法 应该直接 返回null 意味着不能寻路
            if (startPos.x < 0 || startPos.x >= this.mapW || startPos.y < 0 || startPos.y >= this.mapH || endPos.x < 0 || endPos.y >= this.mapH) {
              console.log("开始或者结束点在地图格子范围外");
              return;
            } else {
              //要不是阻挡
              //得到起点和终点 对应的格子
              var startGrid = this.gridsLst[startPos.x][startPos.y];
              var endGrid = this.gridsLst[endPos.x][endPos.y];
              this.openLst.push(startGrid);
              var curGrid = this.openLst[0];

              while (this.openLst.length > 0 && curGrid.type != (_crd && GridType === void 0 ? (_reportPossibleCrUseOfGridType({
                error: Error()
              }), GridType) : GridType).Start) {
                // 每次都取出f值最小的节点进行查找
                curGrid = this.openLst[0];

                if (curGrid.type == (_crd && GridType === void 0 ? (_reportPossibleCrUseOfGridType({
                  error: Error()
                }), GridType) : GridType).Start) {
                  console.log("Find path success.");
                  this.GeneratePath(curGrid);
                  return;
                }

                for (var i = -1; i <= 1; i++) {
                  for (var j = -1; j <= 1; j++) {
                    if (i != 0 || j != 0) {
                      var col = curGrid.x + i;
                      var row = curGrid.y + j;

                      if (col >= 0 && row >= 0 && col <= this.mapW && row <= this.mapH && this.gridsLst[col][row].type != (_crd && GridType === void 0 ? (_reportPossibleCrUseOfGridType({
                        error: Error()
                      }), GridType) : GridType).Barrier && this.closeLst.indexOf(this.gridsLst[col][row]) < 0) {
                        if (this.is8dir) {
                          // 8方向 斜向走动时要考虑相邻的是不是障碍物
                          if (this.gridsLst[col - i][row].type == (_crd && GridType === void 0 ? (_reportPossibleCrUseOfGridType({
                            error: Error()
                          }), GridType) : GridType).Barrier || this.gridsLst[col][row - j].type == (_crd && GridType === void 0 ? (_reportPossibleCrUseOfGridType({
                            error: Error()
                          }), GridType) : GridType).Barrier) {
                            continue;
                          }
                        } else {
                          // 四方形行走
                          if (Math.abs(i) == Math.abs(j)) {
                            continue;
                          }
                        } // 计算g值


                        var g = curGrid.g + parseInt(Math.sqrt(Math.pow(i * 10, 2) + Math.pow(j * 10, 2)).toString());

                        if (this.gridsLst[col][row].g == 0 || this.gridsLst[col][row].g > g) {
                          this.gridsLst[col][row].g = g; // 更新父节点

                          this.gridsLst[col][row].parent = curGrid;
                        } // 计算h值 manhattan估算法


                        this.gridsLst[col][row].h = Math.abs(endPos.x - col) + Math.abs(endPos.y - row); // 更新f值

                        this.gridsLst[col][row].f = this.gridsLst[col][row].g + this.gridsLst[col][row].h; // 如果不在开放列表里则添加到开放列表里

                        if (this.openLst.indexOf(this.gridsLst[col][row]) < 0) {
                          this.openLst.push(this.gridsLst[col][row]);
                        } // // 重新按照f值排序（升序排列)
                        // this.openList.sort(this._sortFunc);

                      }
                    }
                  }
                } // 遍历完四周节点后把当前节点加入关闭列表


                this.closeLst.push(curGrid); // 从开放列表把当前节点移除

                this.openLst.splice(this.openLst.indexOf(curGrid), 1);

                if (this.openLst.length <= 0) {
                  console.log("Find path failed.");
                } // 重新按照f值排序（升序排列)


                this.openLst.sort(this.SortFunc);
              }
            }
          }
          /**
           * 划线
           * @param col 列
           * @param row 行
           * @param color 颜色
           */

        }, {
          key: "Draw",
          value: function Draw(col, row, color) {
            color = color != undefined ? color : Color.GRAY;
            this.map.fillColor = color;
            var posX = 2 + col * (this.gridW + 2);
            var posY = 2 + row * (this.gridH + 2);
            this.map.fillRect(posX, posY, this.gridW, this.gridH);
          }
        }]);

        return AStar;
      }(Component), _temp), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "mapPos", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "map", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      })), _class2)) || _class));

      _crd = false;

      _cclegacy._RF.pop();
    }
  };
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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