// Rocker.js
//新建一个空节点，空节点中建sprite作bg，再建一个sprite作遥杆
cc.Class({
    extends: cc.Component,

    properties: {
        sceneNode: {    // 场景节点
            type: cc.Node,
            default: null,
            displayName: "场景节点",
            tooltip: "当前场景的Canvas"
        },

        playerNode: {    // 角色节点
            type: cc.Node,
            default: null,
            displayName: "角色节点",
            tooltip: "需要控制的节点"
        },
        playerNodeSpeed: {    // player节点
            default: 100,
            displayName: "速度",
            tooltip: "移动速度"
        },
        Max_r: {    // 摇杆移动半径
            default: 100,
            displayName: "摇杆移动半径",
            tooltip: "摇杆移动半径，根据自己美术资源进行调整"
        },
        isact: {    // 是否隐藏遥杆
            default: true,
            displayName: "隐藏遥杆",
            tooltip: "隐藏遥杆"
        },
        ismove: {    // 是否移动遥杆
            default: true,
            displayName: "移动遥杆",
            tooltip: "移动遥杆,选中遥杆跟随手指移动，取消固定摇杆"
        },

    },

    onLoad() {
        // 隐藏摇杆组件节点
        this.node.active = !this.isact;

        // 获取摇杆节点并初始化摇杆节点位置及角度
        this.joystick = this.node.children[1]
        this.joystick.setPosition(cc.v2(0, 0));
        this.dir = cc.v2(0, 0);

        // 注册父节点的 touch 监听事件
        this.sceneNode.on(cc.Node.EventType.TOUCH_START, this.cbTouchStart, this);
        this.sceneNode.on(cc.Node.EventType.TOUCH_MOVE, this.cbTouchMove, this);
        this.sceneNode.on(cc.Node.EventType.TOUCH_END, this.cbTouchEnd, this);
        this.sceneNode.on(cc.Node.EventType.TOUCH_CANCEL, this.cbTouchCancel, this);
    },

    update(dt) {
        if (this.dir.mag() < 0.5) {     //长度
            return;
        }
        console.log(this.dir.position)
        let vx = this.dir.x * this.playerNodeSpeed;
        let vy = this.dir.y * this.playerNodeSpeed;

        let sx = vx * dt;
        let sy = vy * dt;
        //移动
        this.playerNode.x += sx;
        this.playerNode.y += sy;

        let windowsSize = cc.winSize;

        let minX = -windowsSize.width / 2 + this.playerNode.width / 2;    // 最小X坐标
        let maxX = Math.abs(minX);    // 最大X坐标
        let minY = -windowsSize.height / 2 + this.playerNode.height / 2;    // 最小Y坐标
        let maxY = Math.abs(minY);    // 最大Y坐标

        let currentPos = this.playerNode.getPosition();

        if (currentPos.x < minX) {
            currentPos.x = minX;
        } else if (currentPos.x > maxX) {
            currentPos.x = maxX;
        }

        if (currentPos.y < minY) {
            currentPos.y = minY;
        } else if (currentPos.y > maxY) {
            currentPos.y = maxY;
        }

        this.playerNode.setPosition(currentPos);

        //方向计算
        var r = Math.atan2(this.dir.y, this.dir.x);
        var degree = r * 180 / (Math.PI);
        degree = 360 - degree + 90;
        this.playerNode.angle = -degree;
    },

    cbTouchStart(event) {
        let pos = event.getLocation();

        // 点击时显示摇杆组件节点并设置位置
        this.node.active = true;

        if (this.ismove) {
            let rPos = this.sceneNode.convertToNodeSpaceAR(pos);    // 将世界坐标转化为场景节点的相对坐标
            this.node.setPosition(rPos);
        }

        // 初始化摇杆节点位置及角度
        this.joystick.setPosition(cc.v2(0, 0));
        this.dir = cc.v2(0, 0);
    },

    cbTouchMove(event) {
        var pos = event.getLocation();

        var jPos = this.node.convertToNodeSpaceAR(pos);    // 将世界坐标转化为摇杆组件节点的相对坐标

        // 获取摇杆的角度
        let len = jPos.mag();
        this.dir.x = jPos.x / len;
        this.dir.y = jPos.y / len;

        // 设置摇杆的位置
        if (len > this.Max_r) {
            jPos.x = this.Max_r * jPos.x / len;
            jPos.y = this.Max_r * jPos.y / len;
        }
        this.joystick.setPosition(jPos);
    },

    cbTouchEnd(event) {
        // 初始化摇杆节点位置及角度
        this.joystick.setPosition(cc.v2(0, 0));
        this.dir = cc.v2(0, 0);
        this.node.active = !this.isact;
    },

    cbTouchCancel(event) {
        // 初始化摇杆节点位置及角度
        this.joystick.setPosition(cc.v2(0, 0));
        this.dir = cc.v2(0, 0);
        this.node.active = !this.isact;
    }
});

