
cc.Class({
    extends: cc.Component,

    properties: {
        renderSprite: cc.Sprite,
        backNode: cc.Node,
        frontNode: cc.Node,
    },

    start: function () {
        let frontIndex = cc.game.groupList.indexOf('frontUI');
        let mask = 1 << frontIndex;

        let renderTexture = new cc.RenderTexture();
        renderTexture.initWithSize(cc.winSize.width, cc.winSize.height, cc.game._renderContext.STENCIL_INDEX8);
        for (let camera of cc.Camera.cameras) {
            if (!(camera.cullingMask & mask)) {
                camera.targetTexture = renderTexture;
            }
        }
        let spriteFrame = new cc.SpriteFrame();
        spriteFrame.setTexture(renderTexture);
        //this.renderSprite.node.scaleY = -1;
        this.renderSprite.spriteFrame = spriteFrame;

        let boo = true;
        this.node.on(cc.Node.EventType.TOUCH_START, () => {
            this.backNode.group = boo ? 'frontUI' : 'backUI';
            this.frontNode.group = boo ? 'backUI' : 'frontUI';
            boo = !boo;
        });
    }
})