#ifdef GL_ES
precision highp float;
#endif
uniform vec2      iResolution;
uniform float     iTime; 

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 z = 1.15*(-iResolution.xy+2.0*fragCoord.xy)/iResolution.y;

	vec2 an = 0.51*cos( vec2(0.0,1.5708) + 0.1*iTime ) - 0.25*cos( vec2(0.0,1.5708) + 0.2*iTime );

	float f = 1e20;
	for( int i=0; i<128; i++ ) 
	{
		z = vec2( z.x*z.x-z.y*z.y, 2.0*z.x*z.y ) + an;
		f = min( f, dot(z,z) );
	}
	
	f = 1.0+log(f)/16.0;
	//if(f >0.8)discard;
	fragColor = vec4(f,f*f,f*f*f,1.0);
}

void main(void)
{
	mainImage(gl_FragColor, gl_FragCoord.xy);
}