#ifdef GL_ES
precision mediump float;
#endif

uniform float iTime;
uniform vec2 iResolution;


#define goCount 10.
#define goSize 1.

// Anti-alias step function
float aastep(float threshold, float value) {
    float afwidth = 0.7 * length(vec2( dFdx(value), dFdy(value)));
    return smoothstep(threshold - afwidth, threshold + afwidth, value);
}

float opU(float d0, float d1) {
    return min(d0, d1);
}

float opI(float d0, float d1) {
    return max(d0, d1);
}

float opS(float d0, float d1) {
    return max(d0, -d1);
}

vec2 opRep(vec2 p, vec2 c) {
    return mod(p, c) - c * 0.5;
}

// circle: (center.x, center.y, radius)
float sdCircle(vec2 p, vec3 circle) {
    return length(p - circle.xy) - circle.z;
}

float sdHalfPlane(vec2 p, vec2 plane) {
    return dot(p, normalize(plane));
}

float sdSegment(vec2 p, vec2 a, vec2 b) {
    vec2 np = p - a;
    vec2 ns = b - a;
    float proj = dot(np, ns) / length(ns);
    float d = sdHalfPlane(np, vec2(ns.y, -ns.x));
    float s = sign(d);
    if (proj < 0.) return s * length(np);
    if (proj > length(ns)) return s * length(np - ns);
    else return d;
}

vec4 fill(float shape, vec4 color) {
    return vec4(color.rgb, color.a * (1. - smoothstep(0., 1.5, shape)));
}

vec4 stroke(float shape, vec4 color, float width) {
    //float w = 1. - aastep(width * 0.5, abs(shape));
     //float w = 1. - step(width * 0.5, abs(shape));
     float w = 1. - smoothstep(0., 1., abs(abs(shape) - width * 0.5));
    float a = min(w, 1.);
    return vec4(color.rgb, color.a * a);
}

vec3 blend(vec4 fg, vec3 bg) {
    return mix(bg, fg.rgb, fg.a);
}

float rand( vec2 co ) {
    return fract( sin( dot( co.xy, vec2( 12.9898, 78.233 ) ) ) * 43758.5453 );
}

vec2 hash22(vec2 p)
{
    p = vec2( dot(p,vec2(127.1,311.7)),
              dot(p,vec2(269.5,183.3)));

    return fract(sin(p)*43758.5453123) + 0.5;
}

float noise(vec2 p)
{
    vec2 pi = floor(p);
    vec2 pf = p-pi;

    vec2 w = pf*pf*(3.-2.*pf);

    float f00 = dot(hash22(pi+vec2(.0,.0)),pf-vec2(.0,.0));
    float f01 = dot(hash22(pi+vec2(.0,1.)),pf-vec2(.0,1.));
    float f10 = dot(hash22(pi+vec2(1.0,0.)),pf-vec2(1.0,0.));
    float f11 = dot(hash22(pi+vec2(1.0,1.)),pf-vec2(1.0,1.));

    float xm1 = mix(f00,f10,w.x);
    float xm2 = mix(f01,f11,w.x);

    float ym = mix(xm1,xm2,w.y);
    return ym + 0.5;
}

vec3 alpha_go(vec2 p) {
    // moving slowly. NOTE: artifacts appear.
    p -= iTime * 2.;
    vec3 col = vec3(.1, .2, .5);
    float r2 = iResolution.x / goCount;
    vec2 c = floor(p / r2);
    // circle
    p = opRep(p, vec2(r2));
    float r = r2 * 0.5 - 2.;
    r *= 0.2 + goSize * 0.8;
    float d = sdCircle(p, vec3(0., 0., r));
    float cd = rand(c) * 0.5;
    // ring
    float t = 2. + r * 0.15 * (0.5 + 0.5 * sin(iTime * cd * 2.));
    d = opS(d, sdCircle(p, vec3(0., 0., r - t)));
    // fill
    vec3 clr = vec3(.9, .9, .89);
    float a = 0.5 + 0.3 * sin(iTime * cd);
    col = blend(fill(d, vec4(clr, a)), col);
    // center.
    d = sdCircle(p, vec3(0., 0., 3.));
    col = blend(fill(d, vec4(.9, .9, .89, 1.)), col);
    // links.
    // ml = left middle point.
    vec2 ml = vec2(c.x - 0.5, c.y) + iTime * 0.1;
    vec2 mr = vec2(c.x + 0.5, c.y) + iTime * 0.1;
    vec2 mu = vec2(c.x, c.y + 0.5) + iTime * 0.1;
    vec2 md = vec2(c.x, c.y - 0.5) + iTime * 0.1;
    float f = noise(ml);
    float hl = r2 * 0.5;
    d = sdSegment(p, vec2(0., 0.), vec2(-hl, 0.));
    f = (clamp(f, 0.6, 0.65) - 0.6) * 20.;
    col = blend(stroke(d, vec4(vec3(1.), f), 2.), col);
    f = noise(mr);
    d = sdSegment(p, vec2(0., 0.), vec2(hl, 0.));
    f = (clamp(f, 0.6, 0.65) - 0.6) * 20.;
    col = blend(stroke(d, vec4(vec3(1.), f), 2.), col);
    f = noise(mu);
    d = sdSegment(p, vec2(0., 0.), vec2(0., hl));
    f = (clamp(f, 0.6, 0.65) - 0.6) * 20.;
    col = blend(stroke(d, vec4(vec3(1.), f), 2.), col);
    f = noise(md);
    d = sdSegment(p, vec2(0., 0.), vec2(0., -hl));
    f = (clamp(f, 0.6, 0.65) - 0.6) * 20.;
    col = blend(stroke(d, vec4(vec3(1.), f), 2.), col);

    return col;
}

void mainImage( out vec4 fragColor, in vec2 fragCoord ) {
    vec2 p = fragCoord.xy - iResolution.xy * 0.5;
    fragColor = vec4(alpha_go(p+sin(p.y*0.1+iTime)*1.5), 1.0);
}
// --------[ Original ShaderToy ends here ]---------- //

void main(void)
{
    mainImage(gl_FragColor, gl_FragCoord.xy);
}