cc.Class({
    extends: cc.Component,

    _inited: false,

    properties: {
        label: {
            default: null,
            type: cc.Label
        },
    },

    onLoad(){
        this.showMemoryStatus();
    },

    showMemoryStatus() {
        if (cc.sys.isNative) {
            return;
        }

        if (this._inited) {
            return;
        }        

        let afterVisit = function () {
            let count = 0;
            let totalBytes = 0;
            let locTexrues = cc.textureCache._textures;

            for (let key in locTexrues) {
                let selTexture = locTexrues[key];
                count++;
                totalBytes += selTexture.getPixelWidth() * selTexture.getPixelHeight() * 4;
            }

            let locTextureColorsCache = cc.textureCache._textureColorsCache;

            for (let key in locTextureColorsCache) {
                let selCanvasColorsArr = locTextureColorsCache[key];
                for (let selCanvasKey in selCanvasColorsArr) {
                    let selCanvas = selCanvasColorsArr[selCanvasKey];
                    count++;
                    totalBytes += selCanvas.width * selCanvas.height * 4;
                }
            }

            if (this.label)
            {
                this.label.string = "  Memory  " + (totalBytes / (1024.0 * 1024.0)).toFixed(2) + " M";
            }
           
        }

        cc.director.on(cc.Director.EVENT_AFTER_VISIT, afterVisit.bind(this));
        this._inited = true;
    },
});