"use strict";
cc._RF.push(module, '3601aEZLVdOGpzuWrsgJuyv', 'NewMemoryDetector');
// Script/NewMemoryDetector.js

"use strict";

cc.Class({
    extends: cc.Component,

    _inited: false,

    properties: {
        label: {
            default: null,
            type: cc.Label
        }
    },

    onLoad: function onLoad() {
        this.showMemoryStatus();
    },
    showMemoryStatus: function showMemoryStatus() {
        if (cc.sys.isNative) {
            return;
        }

        if (this._inited) {
            return;
        }

        var afterVisit = function afterVisit() {
            var count = 0;
            var totalBytes = 0;
            var locTexrues = cc.textureCache._textures;

            for (var key in locTexrues) {
                var selTexture = locTexrues[key];
                count++;
                totalBytes += selTexture.getPixelWidth() * selTexture.getPixelHeight() * 4;
            }

            var locTextureColorsCache = cc.textureCache._textureColorsCache;

            for (var _key in locTextureColorsCache) {
                var selCanvasColorsArr = locTextureColorsCache[_key];
                for (var selCanvasKey in selCanvasColorsArr) {
                    var selCanvas = selCanvasColorsArr[selCanvasKey];
                    count++;
                    totalBytes += selCanvas.width * selCanvas.height * 4;
                }
            }

            if (this.label) {
                this.label.string = "  Memory  " + (totalBytes / (1024.0 * 1024.0)).toFixed(2) + " M";
            }
        };

        cc.director.on(cc.Director.EVENT_AFTER_VISIT, afterVisit.bind(this));
        this._inited = true;
    }
});

cc._RF.pop();