(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Script/HelloWorld.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '280c3rsZJJKnZ9RqbALVwtK', 'HelloWorld', __filename);
// Script/HelloWorld.js

"use strict";

var UILoader = require("./UILoader");
var MemoryDetector = require("./MemoryDetector");

cc.Class({
    extends: cc.Component,

    properties: {
        label: {
            default: null,
            type: cc.Label
        },
        flower: {
            default: null,
            type: cc.Sprite
        },
        // defaults, set visually when attaching this script to the Canvas
        text: 'Hello, World!',

        count: 0
    },

    // use this for initialization
    onLoad: function onLoad() {
        UILoader.retainScene(this.node);
        //MemoryDetector.showMemoryStatus();
        this.label.string = this.text;
    },

    // called every frame
    update: function update(dt) {},

    onBtnAddPic: function onBtnAddPic() {
        for (i = 1; i < 10; i++) {
            var path = "icon/01";
            cc.loader.loadRes(path, function (err, texture) {
                var sprite = new cc.SpriteFrame(texture);
                this.flower.spriteFrame = sprite;
                cc.loader.setAutoRelease(texture, true);
            }.bind(this));
        }
    },

    onBtnRemovePic: function onBtnRemovePic() {
        //this.flower.destroy();
    },

    onBtnAddSpine: function onBtnAddSpine() {
        //this.flower.destroy();
        this.playEffect(this.node, "animation/skeleton", "chibang");
    },

    onBtnAddPrefab: function onBtnAddPrefab() {
        for (i = 1; i < 10; i++) {
            cc.loader.loadRes("prefab/fb", function (err, prefab) {
                var newNode = cc.instantiate(prefab);
                newNode.y += this.count * 1;
                this.node.addChild(newNode);
                this.count++;
                //cc.loader.setAutoRelease(prefab, true);
            }.bind(this));
        }
    },

    onChangeScene: function onChangeScene() {
        //cc.loader.releaseAll();
        cc.sys.garbageCollect();
        //cc.director.loadScene("1");
    },

    playEffect: function playEffect(parent, path, animation, loop, callback, shaderName) {
        var effectNode = new cc.Node();
        effectNode.parent = parent;
        cc.loader.loadRes("prefab/spine", function (err, prefab) {
            cc.loader.setAutoReleaseRecursively(prefab, true);
            var newNode = cc.instantiate(prefab);
            effectNode.addChild(newNode);
            cc.loader.loadRes(path, sp.SkeletonData, function (err, spData) {
                if (err) {
                    return;
                }
                cc.loader.setAutoRelease(path, true);
                var spine = newNode.getComponent('sp.Skeleton');

                spine.setCompleteListener(function (trackEntry, loopCount) {
                    //var animationName = trackEntry.animation ? trackEntry.animation.name : "";
                    //log("[track %s][animation %s] complete: %s", trackEntry.trackIndex, animationName, loopCount);                    
                    if (!loop) {
                        if (callback) {
                            callback();
                        }
                        effectNode.removeFromParent();
                    }
                });
                //spine.setCompleteListener(callback);
                spine.skeletonData = spData;
                spine.setAnimation(0, animation, loop);
                if (shaderName) {
                    ShaderUtils.setShader(spine, shaderName);
                }
            });
        });

        return effectNode;
    }
});

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=HelloWorld.js.map
        