(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/script/Game.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '64d683G4+pFN70+6uwObBKO', 'Game', __filename);
// script/Game.ts

/**
 * 游戏逻辑
 * @author yxx0
 * 绑定场景 Canvas
 */
Object.defineProperty(exports, "__esModule", { value: true });
// require('./liquidfun');
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var Game = /** @class */ (function (_super) {
    __extends(Game, _super);
    function Game() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.nodeBox = null;
        _this.nodeOut = null;
        _this.graphics = null;
        _this.world = null;
        _this.canUpDate = false;
        return _this;
    }
    Game.prototype.onLoad = function () {
        this.createB2();
    };
    Game.prototype.onDestroy = function () {
    };
    /**
     * 初始化
     */
    Game.prototype.init = function () {
    };
    /**
     * 销毁
     */
    Game.prototype.clear = function () {
    };
    /**
     * 初始化水源
     */
    Game.prototype.createB2 = function () {
        var _this = this;
        var gravity = new b2Vec2(0, -10); //重力值
        window.world = new b2World(gravity, true);
        var shape = new b2PolygonShape;
        shape.SetAsBoxXYCenterAngle(50 / 2 / 15, 50 / 2 / 15, this.convertToPWorld(this.nodeBox.position), 0);
        var psd = new b2ParticleSystemDef();
        psd.radius = 0.05;
        var particleSystem = window.world.CreateParticleSystem(psd);
        var pd = new b2ParticleGroupDef();
        pd.shape = shape;
        var group = particleSystem.CreateParticleGroup(pd);
        this.scheduleOnce(function () { _this.canUpDate = true; }, 1);
    };
    Game.prototype.update = function (dt) {
        if (!this.canUpDate)
            return;
        window.world.Step(dt, 8, 3);
        for (var i = 0, max = window.world.particleSystems.length; i < max; i++) {
            this.drawParticleSystem(window.world.particleSystems[i]);
        }
    };
    Game.prototype.drawParticleSystem = function (system) {
        var particles = system.GetPositionBuffer();
        var maxParticles = particles.length;
        var count = 0;
        var minX = this.nodeOut.x - this.nodeOut.width / 2;
        var maxX = this.nodeOut.x + this.nodeOut.width / 2;
        var minY = this.nodeOut.y - this.nodeOut.height / 2;
        var maxY = minY + this.nodeOut.height * 0.6;
        this.graphics.clear();
        for (var i = 0; i < maxParticles; i += 2) {
            var x = particles[i] * 32;
            var y = particles[i + 1] * 32;
            this.graphics.circle(x, y, 0.055 * 32);
            this.graphics.fill();
            if ((minX < x && x < maxX) && (minY < y && y < maxY)) {
                ++count;
            }
        }
        // if (!this.schedulefalg) {
        //     this.scheduleOnce(this.failed, 10);
        //     this.schedulefalg = true;
        // }
        // if (!this.passfalg && count > LIQUID_COUNT) {
        //     this.unschedule(this.failed);
        //     this.scheduleOnce(this.pass, 2);
        //     this.passfalg = true;
        // }
    };
    Game.prototype.convertToPWorld = function (pos) {
        return new b2Vec2(pos.x / 32, pos.y / 32);
    };
    __decorate([
        property(cc.Node)
    ], Game.prototype, "nodeBox", void 0);
    __decorate([
        property(cc.Node)
    ], Game.prototype, "nodeOut", void 0);
    __decorate([
        property(cc.Graphics)
    ], Game.prototype, "graphics", void 0);
    Game = __decorate([
        ccclass
    ], Game);
    return Game;
}(cc.Component));
exports.default = Game;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=Game.js.map
        