(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/script/Line.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '85d5f0pwXNN3ZEKYD0/Us9Y', 'Line', __filename);
// script/Line.ts

// Learn TypeScript:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var Line = /** @class */ (function (_super) {
    __extends(Line, _super);
    function Line() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.body = null;
        _this.canUpDate = false;
        return _this;
    }
    Line.prototype.onLoad = function () {
        this.init();
    };
    Line.prototype.onDestroy = function () {
    };
    Line.prototype.init = function () {
        // let gravity = new b2Vec2(0, -10);    //重力值
        // this.world = new b2World(gravity, true);
        var _this = this;
        var position = this.node.position;
        var width = this.node.width;
        var height = this.node.height;
        var bd = new b2BodyDef();
        bd.angle = -this.node.angle * Math.PI / 180;
        bd.position = this.convertToPWorld(position);
        bd.gravityScale = 0.5;
        this.body = window.world.CreateBody(bd);
        var shape = new b2PolygonShape();
        shape.SetAsBoxXY(width / 32 / 2, height / 32 / 2);
        this.body.CreateFixtureFromShape(shape, 0.1);
        this.scheduleOnce(function () { _this.canUpDate = true; }, .8);
    };
    Line.prototype.convertToPWorld = function (pos) {
        return new b2Vec2(pos.x / 32, pos.y / 32);
    };
    Line.prototype.convertToNode = function (worldPoint) {
        var leftUpPos = cc.v2(worldPoint).mul(32);
        var leftDownPos = cc.v2(leftUpPos.x, leftUpPos.y);
        return leftDownPos;
    };
    Line.prototype.update = function (dt) {
        if (!this.canUpDate)
            return;
        this.node.position = this.convertToNode(this.body.GetPosition());
        this.node.angle = -this.body.GetAngle() / Math.PI / 180;
    };
    Line = __decorate([
        ccclass
    ], Line);
    return Line;
}(cc.Component));
exports.default = Line;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=Line.js.map
        