import { _decorator, Component, Node, ParticleSystemComponent } from "cc";
const { ccclass, property, executeInEditMode } = _decorator;

@ccclass("EditorPlayParticles")
@executeInEditMode
export class EditorPlayParticles extends Component {


    @property
    private _playParticles: boolean = false;
    public get playParticles(): boolean {
        return this._playParticles;
    }
    @property
    public set playParticles(v: boolean) {
        this._playParticles = v;
        this.updateParticles();
    }

    updateParticles() {
        if (CC_EDITOR) {
            let arr = this.getComponentsInChildren(ParticleSystemComponent);
            arr.forEach((particle) => {
                if (this._playParticles) {
                    particle.play();
                } else {
                    particle.stop();
                }
            });
        }


    }


}

