
cc.Class({
    extends: cc.Component,

    //编辑器 赋值的对应节点
    properties: {


        nodeWidth:{
            default : 350,
            type : cc.Integer
        }, 

        nodeHeight:{
            default : 350,
            type : cc.Integer
        }, 

        wNum:{
            default : 4,
            type : cc.Integer
        }, 

        scrComponet:{
            default : null,
            type : cc.Prefab
        },

        view:{
            default : null,
            type : cc.Node
        },

        content:{
            default : null,
            type : cc.Node
        },
    },


    onDestroy() {
        
    },
    

    onLoad: function () {

        this.initdata();
        this.setData();
    },

    refreshData :function()
    {
        console.log("关卡 刷新 初始化数据")
        this.initdata();

        for(var k in this.objVt)
        {
            var ko = this.objVt[k];
            var id = ko.getComponent("LvNode").data.id;
            ko.getComponent("LvNode").setData(this.data[id]);
        }

    },

    initdata: function () {
        console.log("关卡初始化数据")
        var data = []; 
        var levList = _G.IPlayer.getKey("levList"); 
        var maxUkLev = _G.IPlayer.getKey("maxUkLev"); 
        for(var i = 1; i <= GameConfig.gameLvMax ; i++)
        {   

            if( i > maxUkLev){
                //没解锁
                data.push({id:i,level:null})
            }else{
                if(levList[i])
                {
                    data.push({id:i,level:levList[i]}); 
                }
                else
                {   
                    //数据填充
                    data.push({id:i,level:{0:3,1:1,2:1}})
                }
            }  
        }
        this.data = data;
    },

    setData: function () {
        console.log("关卡 创建关卡")

        var width = this.content.width;
        var height = this.content.height;

        this.widDis = width/this.wNum;

        var length = this.data.length;

        this.content.height = Math.ceil(length / this.wNum) * this.nodeHeight; 

        var minHNum = Math.floor(height/this.nodeHeight);
        this.showAddNum = minHNum+1;
        var srcNum =  this.showAddNum * this.wNum;

        this.maxH = Math.ceil(length / this.wNum)

        this.objVt = [];
        for(var i = 0 ; i < srcNum ; i++)
        {
            var obj = cc.instantiate(this.scrComponet);
            obj.parent = this.content;   
            var numA = Math.floor(i % this.wNum);
            var numB = Math.floor(i / this.wNum);
            obj.x = this.widDis/2  + this.widDis* numA - width/2;
            obj.y =  -this.nodeHeight * numB - this.nodeHeight/2;
            this.objVt.push(obj);
            obj.getComponent("LvNode").setData(this.data[i]);
            obj.active = true;
        }

        this.outObj = [];
        for(var i = 0 ; i < (this.wNum*3) ; i++)
        {
            var obj = cc.instantiate(this.scrComponet);
            obj.parent = this.content;   
            var numA = Math.floor(i % this.wNum);
            var numB = Math.floor(i / this.wNum);
            obj.x = this.widDis/2  + this.widDis* numA - width/2;
            obj.y =  -this.nodeHeight * numB - this.nodeHeight/2;
            this.outObj.push(obj);
            obj.active = false; 
        }

        this.lastYIndex = 0;
    },
    
    callback:function () {
        var showNum = Math.floor((this.content.y - this.view.height/2)/this.nodeHeight);
        showNum = showNum <= 0 ? 0 : showNum;
        showNum = showNum >= this.maxH ? this.maxH : showNum;
        if(this.lastYIndex != showNum)
        {
            this.lastYIndex = showNum;

            var showVt = [];

            var min = this.wNum * showNum;
            var max = this.wNum * (showNum + this.showAddNum);

            max = max > this.data.length ? this.data.length : max

            for(var i = min; i< max; i++)
            {
                showVt.push({id: i , obj : 0});
            }


            console.log("只显示",min,"到",max);
            //移除超出范围的东西
            for(var k = this.objVt.length - 1; k>=0; k--)
            {
                var ko = this.objVt[k];
                var id = ko.getComponent("LvNode").data.id;
                if(id< min || id > max)
                {
                    console.log("移除id:",id);
                    this.outObj.push(ko);
                    this.objVt.splice(k,1);
                    ko.active = false;
                }
                else
                {
                    for(var i in showVt)
                    {
                        var is = showVt[i];
                        if(is.id == id)
                        {
                            is.obj = 1;
                            break;
                        }
                    }
            }
            } 
            var width = this.content.width;
            for(var k in showVt)
            {
                var ks = showVt[k];
                if(ks.obj == 0)
                {
                    var i = ks.id;
                    var obj = this.outObj[0];
                    var numA = Math.floor(i % this.wNum);
                    var numB = Math.floor(i / this.wNum);
                    obj.x = this.widDis/2  + this.widDis* numA - width/2;
                    obj.y =  -this.nodeHeight * numB - this.nodeHeight/2;
                    this.objVt.push(obj);
                    obj.getComponent("LvNode").setData(this.data[i]);
                    this.outObj.splice(0,1);
                    obj.active = true;
                    console.log(i,obj.x,obj.y);
                }
            }

        }

    },

    updateContentData:function () {

    },

});
