(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/script/ScrollViewHelper.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '4d7d6p/sIlJcp5wQmGFUoXy', 'ScrollViewHelper', __filename);
// script/ScrollViewHelper.js

"use strict";

/**
 * 优化scroller
 */
cc.Class({
    extends: cc.Component,

    properties: {
        itemTemplate: cc.Prefab,
        spacing: 10, //item之间的间隔
        rowCount: 5, // view中能显示多少行
        colCount: 2 //每行有多少个item
    },

    // LIFE-CYCLE CALLBACKS:

    onLoad: function onLoad() {
        this.cacheRow = this.rowCount + 8; //缓存多少行
        this.rowCount = Math.ceil(this.rowCount);
        this.items = []; // 存储实际创建的项数组

        var item = cc.instantiate(this.itemTemplate);
        this.itemHeight = item.height;
        this.itemWidth = item.width;
        this.spawnCount = this.cacheRow * this.colCount;
        this.bufferZone = this.cacheRow * (this.itemHeight + this.spacing) / 2;

        this.scrollView = this.node.getComponent(cc.ScrollView);
        this.content = this.scrollView.content;
        this.content.on("position-changed", this._updateContentView.bind(this));
    },
    resetData: function resetData(data, callBack) {
        this.isInit = false;
        this.canUpdateFrame = true;
        this.isInit = this.initialize(data, callBack);
    },

    // 列表初始化
    initialize: function initialize(data, callBack) {
        if (!callBack || !data || data.length === 0 || !this.itemTemplate || !this.scrollView) {
            console.log('初始化失败，请检查所有必要参数');
            return false;
        }
        this.data = data;
        this.itemUpdateFunc = callBack;
        this.totalRow = Math.ceil(data.length / this.colCount);
        this.lastContentPosY = 0;

        this.content.removeAllChildren();
        //layout组件会使item的位置无法正确更新，先移除
        if (this.content.getComponent(cc.Layout)) {
            this.content.removeComponent(cc.Layout);
        }
        // 获取整个content的高度和宽度
        this.content.height = this.totalRow * (this.itemHeight + this.spacing) + this.spacing;
        this.content.width = this.colCount * (this.itemWidth + this.spacing) + this.spacing;
        var row = 0;
        // 创建item实例
        for (var i = 0; i < this.spawnCount; i += this.colCount) {
            //遍历行
            var itemY = -this.itemHeight * (0.5 + row) - this.spacing * (row + 1);
            for (var j = 0; j < this.colCount; j++) {
                //遍历列
                var itemId = i + j;
                var item = null;
                //items有就直接拿，否则创建新的放进去
                if (itemId >= this.items.length) {
                    item = cc.instantiate(this.itemTemplate);
                    this.items.push(item);
                } else {
                    item = this.items[itemId];
                }

                this.content.addChild(item);
                // 设置该item的坐标和itemId, itemId是指item显示的第几个数据
                //（注意父节点content的Anchor坐标是(0.5, 1)，所以item的y坐标总是负值）
                var itemX = (j + 0.5) * this.itemWidth + this.spacing * (j + 1) - this.content.width / 2;
                item.setPosition(itemX, itemY);
                item.itemId = itemId;

                // 当前列有数据显示，没有就隐藏
                if (itemId >= this.data.length) {
                    item.active = false;
                } else {
                    item.active = true;
                    this.itemUpdateFunc(itemId, item, this.data[itemId]);
                }
            }
            row++;
        }
        return true;
    },

    // 返回item在ScrollView空间的坐标值
    getPositionInView: function getPositionInView(item) {
        var worldPos = item.parent.convertToWorldSpaceAR(item.position);
        var viewPos = this.scrollView.node.convertToNodeSpaceAR(worldPos);
        return viewPos;
    },


    // content位置改变时调用，根据滚动位置动态更新item的坐标和显示(所以spawnCount可以比totalCount少很多)
    _updateContentView: function _updateContentView() {
        if (!this.isInit || !this.canUpdateFrame) {
            return; // we don't need to do the math every frame
        }
        this.canUpdateFrame = false;
        var items = this.items;
        var isDown = this.scrollView.content.y < this.lastContentPosY;
        // offset为缓冲区高度，item总是上移或下移一个缓冲区高度
        // BufferZone和-BufferZone为ScrollView中，缓冲区上边界和下边界的位置
        var offset = (this.itemHeight + this.spacing) * this.cacheRow;
        var newY = 0;

        for (var i = 0; i < items.length; i += this.colCount) {
            var viewPos = this.getPositionInView(items[i]);
            if (isDown) {
                newY = items[i].y + offset;
                if (viewPos.y < -this.bufferZone && newY < 0) {
                    for (var j = 0; j < this.colCount; j++) {
                        var index = j + i;
                        items[index].y = newY;
                        var itemId = items[index].itemId - this.spawnCount; // update item id
                        items[index].itemId = itemId;
                        if (itemId >= 0) {
                            items[index].active = true;
                            this.itemUpdateFunc(itemId, items[index], this.data[itemId]);
                        } else {
                            items[index].active = false;
                        }
                    }
                }
            } else {
                newY = items[i].y - offset;
                if (viewPos.y > this.bufferZone && newY > -this.content.height) {
                    for (var _j = 0; _j < this.colCount; _j++) {
                        var _index = _j + i;
                        items[_index].y = newY;
                        var _itemId = items[_index].itemId + this.spawnCount; // update item id
                        items[_index].itemId = _itemId;
                        if (_itemId < this.data.length) {
                            items[_index].active = true;
                            this.itemUpdateFunc(_itemId, items[_index], this.data[_itemId]);
                        } else {
                            items[_index].active = false;
                        }
                    }
                }
            }
        }

        // 更新lastContentPosY和总项数显示
        this.lastContentPosY = this.scrollView.content.y;
        this.canUpdateFrame = true;
    }
}
//初始化定位到指定位置 

);

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=ScrollViewHelper.js.map
        