import ShaderComponent from "./ShaderComponent";
import { ShaderType } from "./ShaderManager";

// Learn TypeScript:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;

@ccclass
export default class ShaderController extends cc.Component {

    public static instance:ShaderController=null;

    @property(ShaderComponent)
    public shaderArray:ShaderComponent[]=[];

    // LIFE-CYCLE CALLBACKS:
    onLoad()
    {
        ShaderController.instance=this;
    }

    public setToGrayByName(name:string):void
    {
        this.shaderArray.forEach((item)=>{
            if(item.shaderObjectName==name)
            {
                item.applyShader(ShaderType.Gray);
                console.log("shaderObject finded.");
                return;
            }
        });
    }

    public setToNormalByName(name:string):void
    {
        this.shaderArray.forEach((item)=>{
            if(item.shaderObjectName==name)
            {
                item.applyShader(ShaderType.Normal);
                console.log("shaderObject finded.");
                return;
            }
        });
    }

    public setToGray(target,index):void
    {
        this.setToGrayByName(index);
    }

    public setToNormal(target,index):void{
        this.setToNormalByName(index);
    }

    // update (dt) {}
}
