"use strict";
cc._RF.push(module, 'ea02bv5u9VEI4f+Xi3Di95c', 'ShaderComponent');
// Script/ShaderComponent.ts

Object.defineProperty(exports, "__esModule", { value: true });
var ShaderManager_1 = require("./ShaderManager");
var ShaderController_1 = require("./ShaderController");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var ShaderComponent = /** @class */ (function (_super) {
    __extends(ShaderComponent, _super);
    function ShaderComponent() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.shaderObjectName = "";
        _this.shaderType = ShaderManager_1.ShaderType.Default;
        _this.playOnLoad = false;
        _this.applyFlag = false;
        _this.shaderObj = null;
        _this.shaderMaterial = null;
        return _this;
    }
    ShaderComponent.prototype.onLoad = function () {
        //this.playOnLoad && this.applyShader(this.shaderType);
    };
    ShaderComponent.prototype.start = function () {
        ShaderController_1.default.instance.shaderArray.push(this);
    };
    ShaderComponent.prototype.getApplyNode = function () {
        return this.getComponent(cc.Sprite) || this.getComponent(sp.Skeleton);
    };
    ShaderComponent.prototype.update = function (dt) {
        /*if (CC_EDITOR || !this.applyFlag) {
            return;
        }*/
        if (this.shaderObj && this.shaderObj.update) {
            this.shaderObj.update(this.getApplyNode(), this.shaderMaterial, dt);
        }
    };
    ShaderComponent.prototype.applyShader = function (type) {
        var _this = this;
        this.shaderType = type;
        this.createShader();
        /*if (!this.shaderObj || this.applyFlag || !this.shaderMaterial) {
            return;
        }
        this.applyFlag = true;*/
        if (!this.shaderMaterial) {
            console.error("material is null.");
            return;
        }
        var sp = this.getApplyNode();
        var texture = sp.skeletonData.textures[0];
        if (this.shaderMaterial.texture !== texture) {
            this.shaderMaterial.texture = texture;
            sp._updateMaterial(this.shaderMaterial);
        }
        else if (this.shaderMaterial !== sp._material) {
            sp._updateMaterial(this.shaderMaterial);
        }
        if (sp._renderDatas) {
            sp._renderDatas.forEach(function (renderData) { return renderData.material = _this.shaderMaterial; });
        }
        sp.markForUpdateRenderData(true);
        sp.markForRender(true);
        if (this.shaderObj.params) {
            this.shaderObj.params.forEach(function (item) {
                if (item.defaultValue !== undefined) {
                    _this.shaderMaterial.setParamValue(item.name, item.defaultValue);
                }
            });
        }
        if (this.shaderObj.start) {
            this.shaderObj.start(this.getApplyNode(), this.shaderMaterial);
        }
    };
    ShaderComponent.prototype.createShader = function () {
        this.shaderObj = ShaderManager_1.shaderManager.getShaderByType(this.shaderType);
        var sp = this.getApplyNode();
        /*if (CC_EDITOR || !this.shaderObj || this.shaderMaterial) {
            return;
        }*/
        if (!this.shaderObj) {
            console.error("shader not found.");
            return;
        }
        this.shaderMaterial = ShaderManager_1.shaderManager.createShaderMaterial(sp, this.shaderType);
        if (sp.node) {
            this.shaderMaterial.color = sp.node.color;
        }
        if (sp.skeletonData) {
            this.shaderMaterial.texture = sp.skeletonData.textures[0];
        }
    };
    __decorate([
        property
    ], ShaderComponent.prototype, "shaderObjectName", void 0);
    __decorate([
        property({ type: cc.Enum(ShaderManager_1.ShaderType) })
    ], ShaderComponent.prototype, "shaderType", void 0);
    __decorate([
        property()
    ], ShaderComponent.prototype, "playOnLoad", void 0);
    ShaderComponent = __decorate([
        ccclass
    ], ShaderComponent);
    return ShaderComponent;
}(cc.Component));
exports.default = ShaderComponent;

cc._RF.pop();