(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Script/ShaderFunc/Shader.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '3bf38pLDFZG96bh3nUrMIUA', 'Shader', __filename);
// Script/ShaderFunc/Shader.ts

Object.defineProperty(exports, "__esModule", { value: true });
var ShaderManager_1 = require("../ShaderManager");
var renderEngine = cc.renderer.renderEngine;
var renderer = renderEngine.renderer;
var Fluxay = {
    name: 'Fluxay',
    params: [
        { name: 'time', type: renderer.PARAM_FLOAT, defaultValue: 0 },
    ],
    start: function () {
        this._time = 0;
    },
    update: function (sprite, material, dt) {
        this._time += dt;
        if (this._time >= 1.414) {
            this._time = 0;
        }
        material.setParamValue('time', this._time);
    },
    defines: [],
    vert: "\n    uniform mat4 viewProj;\n    uniform mat4 model;\n    attribute vec3 a_position;\n    attribute vec2 a_uv0;\n    varying vec2 uv0;\n    void main () {\n        mat4 mvp;\n        mvp = viewProj * model;\n        vec4 pos = mvp * vec4(a_position, 1);\n        gl_Position = pos;\n        uv0 = a_uv0;\n    }",
    frag: "uniform sampler2D texture;\n        uniform vec4 color;\n        uniform float time;\n        varying vec2 uv0;\n        \n        void main()\n        {\n            vec4 src_color = color * texture2D(texture, uv0).rgba;\n        \n            float width = 0.03;       //\u6D41\u5149\u7684\u5BBD\u5EA6\u8303\u56F4 (\u8C03\u6574\u8BE5\u503C\u6539\u53D8\u6D41\u5149\u7684\u5BBD\u5EA6)\n            float start = tan(time/1.414);  //\u6D41\u5149\u7684\u8D77\u59CBx\u5750\u6807\n            float strength = 0.05;   //\u6D41\u5149\u589E\u4EAE\u5F3A\u5EA6   (\u8C03\u6574\u8BE5\u503C\u6539\u53D8\u6D41\u5149\u7684\u589E\u4EAE\u5F3A\u5EA6)\n            float offset = 0.5;      //\u504F\u79FB\u503C         (\u8C03\u6574\u8BE5\u503C\u6539\u53D8\u6D41\u5149\u7684\u503E\u659C\u7A0B\u5EA6)\n            if(uv0.x < (start - offset * uv0.y) &&  uv0.x > (start - offset * uv0.y - width))\n            {\n                vec3 improve = strength * vec3(255, 255, 255);\n                vec3 result = improve * vec3( src_color.r, src_color.g, src_color.b);\n                gl_FragColor = vec4(result, src_color.a);\n        \n            }else{\n                gl_FragColor = src_color;\n            }\n        }",
};
var Gray = {
    name: 'Gray',
    defines: [],
    vert: "\n    uniform mat4 viewProj;\n    uniform mat4 model;\n    attribute vec3 a_position;\n    attribute vec2 a_uv0;\n    varying vec2 uv0;\n    void main () {\n        mat4 mvp;\n        mvp = viewProj * model;\n        vec4 pos = mvp * vec4(a_position, 1);\n        gl_Position = pos;\n        uv0 = a_uv0;\n    }",
    frag: "uniform sampler2D texture;\n    uniform vec4 color;\n    uniform float bGray;\n    varying vec2 uv0;\n    void main()\n    {\n        vec4 c = color * texture2D(texture, uv0);\n        float gray = 0.2126*c.r + 0.7152*c.g + 0.0722*c.b;\n        gl_FragColor = vec4(gray, gray, gray, c.a);\n    }",
};
var Normal = {
    name: 'Normal',
    defines: [],
    vert: "\n    uniform mat4 viewProj;\n    uniform mat4 model;\n    attribute vec3 a_position;\n    attribute vec2 a_uv0;\n    varying vec2 uv0;\n    void main () {\n        mat4 mvp;\n        mvp = viewProj * model;\n        vec4 pos = mvp * vec4(a_position, 1);\n        gl_Position = pos;\n        uv0 = a_uv0;\n    }",
    frag: "uniform sampler2D texture;\n        uniform vec4 color;\n        varying vec2 uv0;\n        void main () {\n            vec4 c = color * texture2D(texture, uv0);\n            gl_FragColor = c;\n        }",
};
ShaderManager_1.shaderManager.addShader(Fluxay);
ShaderManager_1.shaderManager.addShader(Gray);
ShaderManager_1.shaderManager.addShader(Normal);

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=Shader.js.map
        