(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Script/ShaderManager.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, 'bd3dfRmTHhKOZLvkxvC0XRp', 'ShaderManager', __filename);
// Script/ShaderManager.ts

Object.defineProperty(exports, "__esModule", { value: true });
var ShaderMaterial_1 = require("./ShaderMaterial");
var ShaderType;
(function (ShaderType) {
    ShaderType[ShaderType["Default"] = 0] = "Default";
    ShaderType[ShaderType["Gray"] = 1] = "Gray";
    ShaderType[ShaderType["Fluxay"] = 101] = "Fluxay";
    ShaderType[ShaderType["Normal"] = 102] = "Normal";
})(ShaderType = exports.ShaderType || (exports.ShaderType = {}));
var ShaderManager = /** @class */ (function () {
    function ShaderManager() {
        this.shaders = {};
    }
    ShaderManager.prototype.addShader = function (shader) {
        if (this.shaders[shader.name]) {
            return;
        }
        var renderer = cc.renderer;
        if (renderer._forward) {
            var lib = renderer._forward._programLib;
            !lib._templates[shader.name] && lib.define(shader.name, shader.vert, shader.frag, shader.defines || []);
            this.shaders[shader.name] = shader;
        }
        else {
            var gameEvent = cc.game;
            var thisObj_1 = this;
            gameEvent.once(cc.game.EVENT_ENGINE_INITED, function () {
                var lib = renderer._forward._programLib;
                !lib._templates[shader.name] && lib.define(shader.name, shader.vert, shader.frag, shader.defines || []);
                thisObj_1.shaders[shader.name] = shader;
            });
        }
    };
    ShaderManager.prototype.getShaderByType = function (type) {
        return this.shaders[ShaderType[type]];
    };
    ShaderManager.prototype.createShaderMaterial = function (sprite, type) {
        if (!sprite || cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) {
            return null;
        }
        var shader = this.getShaderByType(type);
        if (shader === null) {
            if (sprite instanceof cc.Sprite) {
                sprite.setState(shader);
            }
            return null;
        }
        return new ShaderMaterial_1.ShaderMaterial(shader);
    };
    return ShaderManager;
}());
exports.shaderManager = new ShaderManager();

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=ShaderManager.js.map
        