(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Script/ShaderMaterial.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, 'cf7b8WhTnhLFrKtwALlVBd0', 'ShaderMaterial', __filename);
// Script/ShaderMaterial.ts

Object.defineProperty(exports, "__esModule", { value: true });
var renderEngine = cc.renderer.renderEngine;
var Material = renderEngine.Material;
var ShaderMaterial = /** @class */ (function (_super) {
    __extends(ShaderMaterial, _super);
    function ShaderMaterial(shader) {
        var _this = _super.call(this, false) || this;
        var renderer = renderEngine.renderer;
        var gfx = renderEngine.gfx;
        var pass = new renderer.Pass(shader.name);
        pass.setDepth(false, false);
        pass.setCullMode(gfx.CULL_NONE);
        pass.setBlend(gfx.BLEND_FUNC_ADD, gfx.BLEND_SRC_ALPHA, gfx.BLEND_ONE_MINUS_SRC_ALPHA, gfx.BLEND_FUNC_ADD, gfx.BLEND_SRC_ALPHA, gfx.BLEND_ONE_MINUS_SRC_ALPHA);
        var techParams = [
            { name: 'texture', type: renderer.PARAM_TEXTURE_2D },
            { name: 'color', type: renderer.PARAM_COLOR4 }
        ];
        if (shader.params) {
            techParams = techParams.concat(shader.params);
        }
        var mainTech = new renderer.Technique(['transparent'], techParams, [pass]);
        _this._texture = null;
        _this._color = { r: 1.0, g: 1.0, b: 1.0, a: 1.0 };
        _this._effect = new renderer.Effect([mainTech], {}, []);
        _this._mainTech = mainTech;
        return _this;
    }
    Object.defineProperty(ShaderMaterial.prototype, "effect", {
        get: function () {
            return this._effect;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ShaderMaterial.prototype, "texture", {
        set: function (val) {
            if (this._texture !== val) {
                this._texture = val;
                this._effect.setProperty('texture', val.getImpl());
                this._texIds['texture'] = val.getId();
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ShaderMaterial.prototype, "color", {
        set: function (val) {
            this._color.r = val.r / 255;
            this._color.g = val.g / 255;
            this._color.b = val.b / 255;
            this._color.a = val.a / 255;
            this._effect.setProperty('color', this._color);
        },
        enumerable: true,
        configurable: true
    });
    ShaderMaterial.prototype.setParamValue = function (name, value) {
        this._effect.setProperty(name, value);
    };
    ShaderMaterial.prototype.getParamValue = function (name) {
        return this._effect.getProperty(name);
    };
    ShaderMaterial.prototype.setDefine = function (name, value) {
        this._effect.define(name, value);
    };
    return ShaderMaterial;
}(Material));
exports.ShaderMaterial = ShaderMaterial;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=ShaderMaterial.js.map
        