interface CacheInfo {
    dbAtlas: dragonBones.DragonBonesAtlasAsset;
    dbData: dragonBones.DragonBonesAsset;
}

declare type loadCallback = (dbAtlas: dragonBones.DragonBonesAtlasAsset, dbData: dragonBones.DragonBonesAsset) => void;

// 缓存
const cache: { [key: string]: CacheInfo } = {};

// 加载任务
const loadingTasks: { [key: string]: loadCallback[] } = {};

/**
 * 加载骨骼动画
 * @param name 名称
 * @param callback 回调
 */
export function loadArmatureRes(name, callback: loadCallback, useCache: boolean) {

    if (!useCache) {
        // 加载
        doLoadArmatureRes(name, callback);
        return;
    }

    // todo...经测试，如果使用相同的DragonBonesAtlasAsset DragonBonesAsset，workclock会有问题
    let cacheInfo = cache[name];
    if (cacheInfo) {
        console.log('从缓存中加载骨骼', name);
        callback(cacheInfo.dbAtlas, cacheInfo.dbData);
        return;
    }

    // 添加到回调列表
    let needToLoad = false;
    let callbackList = loadingTasks[name];
    if (!callbackList) {
        callbackList = [];
        loadingTasks[name] = callbackList;
        needToLoad = true;
    }
    callbackList.push(callback);

    if (!needToLoad) {
        return;
    }

    // 执行加载
    doLoadArmatureRes(name, (dbAtlas, dbData) => {
        // 添加到缓存
        cache[name] = {
            dbAtlas, dbData,
        };
        const callbackList = loadingTasks[name];
        if (callbackList) {
            // 回调
            for (const callback of callbackList) {
                callback(dbAtlas, dbData);
            }
            // 清除任务
            delete loadingTasks[name];
        }
    });
}

function doLoadArmatureRes(name: string, callback: loadCallback) {
    console.log('加载骨骼', name);
    const image = name + '_tex';
    const ske = name + '_ske';
    const atlas = name + '_tex';
    const basePath = '';
    // 加载 plist
    cc.loader.loadRes(basePath + atlas, dragonBones.DragonBonesAtlasAsset, (err, dbAtlas: dragonBones.DragonBonesAtlasAsset) => {
        if (err) {
            // 重试
            doLoadArmatureRes(name, callback);
            return;
        }
        // 加载骨骼
        cc.loader.loadRes(basePath + ske, dragonBones.DragonBonesAsset, (err, dbData: dragonBones.DragonBonesAsset) => {
            if (err) {
                // 重试
                doLoadArmatureRes(name, callback);
                return;
            }
            console.log('骨骼加载完毕', name);
            callback(dbAtlas, dbData);
        });
    });
}