import Actor from './actor';
import * as ArmatureRes from './armatureRes';

const { ccclass, property } = cc._decorator;

@ccclass
export default class Test extends cc.Component {

    @property(cc.Button)
    button: cc.Button = null;

    @property(cc.Button)
    buttonGen: cc.Button = null;

    @property(cc.Button)
    buttonRecycle: cc.Button = null;

    @property(cc.Label)
    poolCount: cc.Label = null;

    @property(cc.Node)
    container: cc.Node = null;

    _pause = false;

    _nodePool = new cc.NodePool();
    _actors: Actor[] = [];

    onLoad() {
        this.button.node.on('click', () => {
            this._pause = !this._pause;
            this.button.getComponentInChildren(cc.Label).string = this._pause ? '继续' : '暂停';
        });
        this.buttonGen.node.on('click', () => {
            const node = this._nodePool.get();
            if (node) {
                //
                console.log('gen from pool');
                node.parent = this.container;
                const actor = node.getComponent(Actor);
                this._actors.push(actor);
                this.refreshPool();

                // 添加db组件
                const dragonDisplay = node.getComponent(dragonBones.ArmatureDisplay);
                dragonDisplay.playAnimation('test', 0);
            } else {
                console.log('gen new');
                // 生成
                // 加载资源
                ArmatureRes.loadArmatureRes('test', (dbAtlas, dbData) => {
                    const node = new cc.Node();
                    node.width = 100;
                    node.height = 100;
                    node.parent = this.container;
                    const actor = node.addComponent(Actor);

                    // 添加db组件
                    const dragonDisplay = node.addComponent(dragonBones.ArmatureDisplay);
                    // 设置数据
                    dragonDisplay.dragonAtlasAsset = dbAtlas;
                    dragonDisplay.dragonAsset = dbData;
                    // 设置默认arm
                    dragonDisplay.armatureName = 'Armature';
                    const armature: dragonBones.Armature = dragonDisplay.armature();
                    const clock = new dragonBones.WorldClock();
                    armature.clock = clock;
                    clock.add(armature);
                    //
                    dragonDisplay.playAnimation('test', 0);

                    actor.workClock = clock;
                    this._actors.push(actor);
                },
                    true
                );
            }
        });
        this.buttonRecycle.node.on('click', () => {
            if (this._actors.length > 0) {
                this._nodePool.put(this._actors.pop().node);
                this.refreshPool();
            }
        });
        this.refreshPool();
    }

    refreshPool() {
        this.poolCount.string = '缓存：' + this._nodePool.size();
    }


    start() {

    }

    update(dt) {
        if (this._pause) {
            return;
        }
        for (const actor of this._actors) {
            actor.workClock.advanceTime(dt);
        }
    }
}
