
var isDrawing = false;
var pressed = false;
var localTouchPoint = cc.v2(0, 0);
var globalTouchPoint = cc.v2(0, 0);
var lineCount = 0;
var touchID = 0;
var preLocalPoint = cc.v2(0, 0);
var preGlobalPoint = cc.v2(0, 0);
var flag = false;

const { ccclass, property } = cc._decorator;
@ccclass
export default class DrawBoday extends cc.Component {
    private physicsManager: cc.PhysicsManager = null;
    private errNode: cc.Node = null;

    public onLoad() {
        lineCount = 0;
        this.physicsManager = cc.director.getPhysicsManager();
        this.physicsManager.enabled = true;
        this.errNode = new cc.Node("errNode");
        this.errNode.addComponent(cc.Graphics);
        this.node.addChild(this.errNode);


        //源码碰撞值检测了静态刚体，覆盖源码里面的检测方法，允许检测所有刚体
        cc['PhysicsAABBQueryCallback'].prototype.ReportFixture = function (e) {
            if (e.GetBody(), this._isPoint) {
                if (e.TestPoint(this._point)) return this._fixtures.push(e), false;
            } else this._fixtures.push(e);
            return true;
        };

        this.node.on(cc.Node.EventType.TOUCH_START, this.onTouchStart, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this.onTouchMove, this);
        this.node.on(cc.Node.EventType.TOUCH_END, this.onTouchEnd, this);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, this.onTouchEnd, this);
    }

    /**触摸 开始 */
    private onTouchStart(evt: cc.Event.EventTouch) {
        touchID = evt.getID();

        isDrawing = true;
        globalTouchPoint = evt.getLocation();
        localTouchPoint = this.node.convertToNodeSpaceAR(globalTouchPoint);
        preLocalPoint = localTouchPoint;
        preGlobalPoint = globalTouchPoint;
        if (this.physicsManager.testPoint(cc.v2(globalTouchPoint.x, globalTouchPoint.y))) {
            isDrawing = false;
            return;
        }
        pressed = true;
        flag = false;

        lineCount++;
        var line = new cc.Node("line" + lineCount);
        var grap = line.addComponent(cc.Graphics);
        var rgBody = line.addComponent(cc.RigidBody);
        this.node.addChild(line);
        rgBody.gravityScale = 0;
        rgBody.type = cc.RigidBodyType.Static;
        rgBody.bullet = true;
        line.group = "line";

        grap.lineWidth = 9;
        grap.lineCap = cc.Graphics.LineCap.ROUND;
        grap.moveTo(localTouchPoint.x, localTouchPoint.y);

    }
    /**触摸 移动 */
    private onTouchMove(evt: cc.Event.EventTouch) {
        var curLine: cc.Node = this.node.getChildByName("line" + lineCount);
        if (pressed) {
            if (touchID === evt.getID()) {
                this.errNode.getComponent(cc.Graphics).clear();

                globalTouchPoint = evt.getLocation();
                localTouchPoint = this.node.convertToNodeSpaceAR(globalTouchPoint);

                var isRect = this.physicsManager.testPoint(cc.v2(globalTouchPoint.x, globalTouchPoint.y));
                this._wideRaycast(preGlobalPoint.x, preGlobalPoint.y, globalTouchPoint.x, globalTouchPoint.y)
                if (!isRect && !flag) {
                    var distance = Math.sqrt(Math.pow(localTouchPoint.x - preLocalPoint.x, 2) + Math.pow(localTouchPoint.y - preLocalPoint.y, 2));
                    curLine.getComponent(cc.Graphics).lineTo(localTouchPoint.x, localTouchPoint.y)
                    curLine.getComponent(cc.Graphics).stroke()
                    curLine.getComponent(cc.Graphics).moveTo(localTouchPoint.x, localTouchPoint.y)
                    var circleCollider: cc.PhysicsCircleCollider;
                    if (distance > 8) {
                        if (distance < 10) {
                            circleCollider = curLine.addComponent(cc.PhysicsCircleCollider);
                            circleCollider.offset = cc.v2(localTouchPoint.x, localTouchPoint.y);
                            circleCollider.radius = 4.5;
                            circleCollider.density = 1;
                            circleCollider.apply();
                        } else {
                            for (var C = 1; C < distance / 10; C++) {
                                circleCollider = curLine.addComponent(cc.PhysicsCircleCollider)
                                circleCollider.offset = cc.v2(preLocalPoint.x + 10 * C * (localTouchPoint.x - preLocalPoint.x) / distance, preLocalPoint.y + 10 * C * (localTouchPoint.y - preLocalPoint.y) / distance);
                                circleCollider.radius = 4.5;
                                circleCollider.density = 1;
                                circleCollider.apply();
                            }
                            circleCollider = curLine.addComponent(cc.PhysicsCircleCollider);
                            circleCollider.offset = cc.v2(localTouchPoint.x, localTouchPoint.y);
                            circleCollider.radius = 4.5;
                            circleCollider.density = 1;
                            circleCollider.apply();
                        }
                        preLocalPoint = localTouchPoint;
                        preGlobalPoint = globalTouchPoint;
                    }

                } else {
                    var grap = this.errNode.getComponent(cc.Graphics);
                    grap.moveTo(preLocalPoint.x, preLocalPoint.y);
                    grap.strokeColor = cc.color(255, 0, 0);
                    grap.lineCap = cc.Graphics.LineCap.ROUND;
                    grap.lineWidth = 9;
                    grap.lineTo(localTouchPoint.x, localTouchPoint.y);
                    grap.stroke();
                }
            }
        } else if (!isDrawing) {
            isDrawing = true;
            touchID = evt.getID();
            globalTouchPoint = evt.getLocation();
            localTouchPoint = this.node.convertToNodeSpaceAR(globalTouchPoint);
            preLocalPoint = localTouchPoint;
            preGlobalPoint = globalTouchPoint;
            let isRect = this.physicsManager.testPoint(cc.v2(globalTouchPoint.x, globalTouchPoint.y))
            if (isRect) {
                isDrawing = false;
                return
            }
            pressed = true;
            flag = false;
            lineCount++;
            var line = new cc.Node("line" + lineCount);
            var grap = line.addComponent(cc.Graphics);
            var rgBody = line.addComponent(cc.RigidBody);
            this.node.addChild(line);
            rgBody.gravityScale = 0;
            rgBody.type = cc.RigidBodyType.Static;
            grap.lineCap = cc.Graphics.LineCap.ROUND;
            grap.lineWidth = 9;
            grap.moveTo(localTouchPoint.x, localTouchPoint.y);
        }
    }

    // /**划线结束， 判断输赢 */
    private onTouchEnd(event) {
        if (pressed && touchID === event.getID()) {
            this.touchEndEvent();
        }
    }

    private touchEndEvent() {
        this.node.getChildByName("errNode").getComponent(cc.Graphics).clear();

        var line = this.node.getChildByName("line" + lineCount).getComponent(cc.RigidBody);
        line.node.group = "line";
        line.type = cc.RigidBodyType.Dynamic;
        line.enabledContactListener = false;
        line.gravityScale = 3.5;
        line.bullet = true;

        // let ball1 = this.node.parent.getChildByName("ball1");
        // let ball2 = this.node.parent.getChildByName("ball2");
        // ball1.getComponent(cc.RigidBody).type = cc.RigidBodyType.Dynamic;
        // ball1.getComponent(cc.RigidBody).gravityScale = 2;
        // ball2.getComponent(cc.RigidBody).type = cc.RigidBodyType.Dynamic;
        // ball2.getComponent(cc.RigidBody).gravityScale = 2;
        pressed = isDrawing = false;
    }

    private _wideRaycast(px1: number, py1: number, px2: number, py2: number) {
        var physicsManager = cc.director.getPhysicsManager();
        var a = Math.sqrt(Math.pow(px2 - px1, 2) + Math.pow(py2 - py1, 2));
        var c = 4.5 * -(py2 - py1) / a;
        var s = 4.5 * (px2 - px1) / a;
        var r = physicsManager.rayCast(cc.v2(px1 - c, py1 - s), cc.v2(px2 - c, py2 - s), cc.RayCastType.All);
        if (r.length > 0) for (var l = 0; l < r.length; l++) {
            if (r[l].collider.node.name != "line" + lineCount) {
                flag = true;
                break;
            }
            flag = false;
        }
        var d = physicsManager.rayCast(cc.v2(px1 + c, py1 + s), cc.v2(px2 + c, py2 + s), cc.RayCastType.All);
        if (d.length > 0) for (l = 0; l < d.length; l++) {
            if (d[l].collider.node.name != "line" + lineCount) {
                flag = true;
                break;
            }
            flag = false;
        }
    }


    public clearBoard() {
        this.node.removeAllChildren();
        this.errNode = new cc.Node("errNode");
        this.errNode.addComponent(cc.Graphics);
        this.node.addChild(this.errNode);
    }


    public onDestroy() {
    }
}
