
const {ccclass, property} = cc._decorator;

@ccclass
export default class TestScene extends cc.Component {

    @property(cc.Label)
    resultLabel: cc.Label = null;

    private wasm = null;

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start () {
        this.scheduleOnce(()=>{
            this.createWASM();
            let showString = this.webAssemblyCalculate();
            if(this.resultLabel) this.resultLabel.string = '{' + showString + '}';
        }, 8);
    }

    // update (dt) {}


    createWASM(){
        try {
            if(typeof WebAssembly == 'undefined') {
                console.error('未找到WebAssembly NameSpace');
            }

            let wasmUint8Array = new Uint8Array([
                0, 97, 115, 109, 1, 0, 0, 0, 1, 13, 2, 96, 0, 1, 127, 96, 4, 127, 127, 127, 127, 1, 127, 3, 7, 6, 0, 1, 1, 1, 1, 1, 6, 6, 1, 127, 1, 65, 0, 11, 7, 50, 6, 3, 109, 117, 108, 0, 1, 5, 100, 105, 118, 95, 115, 0, 2, 5, 100, 105, 118, 95, 117, 0, 3, 5, 114, 101, 109, 95, 115, 0, 4, 5, 114, 101, 109, 95, 117, 0, 5, 8, 103, 101, 116, 95, 104, 105, 103, 104, 0, 0, 10, 191, 1, 6, 4, 0, 35, 0, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 126, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 127, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 128, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 129, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 130, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11]);
            this.wasm = new WebAssembly.Instance(new WebAssembly.Module(wasmUint8Array), {}).exports;
        } catch (e) {
            console.error('no wasm support :(', JSON.stringify(e));
        }

        console.log('create WASM Result:'+ (this.wasm ? '成功' : '失败'));
    }

    webAssemblyCalculate():string {
        let low :number;
        if(this.wasm){
            low = this.wasm.mul(35968142, 0, 100000000, 0);
            console.log('wasm calcul result:'+low);
        }
        
        if(low) return ''+low;
        else return "不支持";
    }

}
