import { Observable } from '../Observable';
import { SchedulerLike } from '../RxTypes';
import { subscribeToIterable } from '../util/subscribeToIterable';

export function fromIterable<T>(input: Iterable<T>) {
  if (!input) {
    throw new Error('Iterable cannot be null');
  }
  return new Observable<T>(subscribeToIterable(input));
}
