
cc.Class({
    extends: cc.Component,

    properties: {
        lbl_test: cc.Label,
    },

    onLoad: function () {
        this.lbl_test.string = "onLoad";

        // 绑定注册监听UITest事件
        this.node.on("UITest",function (argument) {
            // cc.log("UITest:",this.test_str);
            // cc.log("UITest:",this.lbl_test.string);
            this.lbl_test.string = this.test_str;
        }.bind(this));
    },

    // called every frame
    update: function (dt) {

    },

    btn_test_click: function () {
        this.test_str = "btn_test_click";
        // this.lbl_test.string = "xxx test"

        if(this.ws){
            this.lbl_test.string = "请稍等。。。"
            return;
        }
        this.ws = new WebSocket( "ws://192.168.2.220:8988" );
        this.ws.binaryType = 'arraybuffer';
        this.ws.onopen = function (argument) {
            this.node.emit("UITest");
        }.bind(this);
        this.ws.onmessage = function (argument) {
        }.bind(this);
        this.ws.onclose = function (argument) {
            if(this.ws){
                this.ws.close();
                this.ws = null;
            }
            this.node.emit("UITest");
        }.bind(this);
        this.ws.onerror = function (argument) {
            if(this.ws){
                this.ws.close();
                this.ws = null;
            }
            this.node.emit("UITest");
        }.bind(this);
    },

    btn_cocos_click: function () {
        this.test_str = "btn_cocos_click";
        // this.lbl_test.string = "xxx cocos"
        this.node.emit("UITest")
    }
});
