import ccclass = cc._decorator.ccclass;
import property = cc._decorator.property;

@ccclass("UI/Ranking/UIMyRankingInfo")
export class UIMyRankingInfo extends cc.Component {
    @property(cc.Label)
    RankingLabel: cc.Label;
    @property(cc.Label)
    Name: cc.Label;
    @property(cc.Label)
    Score: cc.Label;
    @property(cc.Label)
    ScoreName: cc.Label;

    updateItem(rankData: wx.UserGameData) {
        let data = rankData;
        this.Name.string = data.nickname;
        this.Score.string = `x ${data['score']}`;
        this.ScoreName.string = data['scoreName'];
        this.RankingLabel.string = data['number'] > 0 ? `${data['number']}` : "未入榜";
    }
}