import ccclass = cc._decorator.ccclass;
import property = cc._decorator.property;
import {UIMyRankingInfo} from "./UIMyRankingInfo";

@ccclass("UI/Ranking/wechatFriendsRankingList")
export class wechatFriendsRankingList extends cc.Component {
    @property(cc.Node)
    Template: cc.Node;
    @property(cc.Node)
    Container: cc.Node;
    @property(cc.ScrollView)
    ScrollView: cc.ScrollView;
    @property(UIMyRankingInfo)
    MyRanking: UIMyRankingInfo;

    rankKeys: string[] = ['dmScore', 'dmScoreName'];

    _itemList: cc.Node[] = [];

    onLoad() {
        if (this.rankKeys) {
            this.updateList();
        }
    }
    
    async updateList() {
        console.info("updateList!!!");
        for (let i = 0; i < 10; i++) {
            this.createItem();
        }

        this.ScrollView.scrollToTop();
    }

    createItem() {
        let newNode = cc.instantiate(this.Template);
        newNode.active = true;
        this.Container.addChild(newNode);
        this._itemList.push(newNode);
    }
}