declare namespace wx {
    // login(callbacks: {
    //     success?(code:string),
    //     fail?(),
    //     complete?()
    // });

    declare interface KVData {
        key: string;
        value: string;
    }

    declare interface UserGameData {
        avatarUrl: string;
        nickname: string;
        openid: string;
        KVDataList: Array<KVData>;
    }

    declare interface UserInfo {
        avatarUrl: string;
        city: string;
        country: string;
        gender: number;
        language: string;
        nickName: string;
        openid: string;
        province: string;
    }

    export function getFriendCloudStorage(object: { keyList: string[], success?: (res: { data: Array<UserGameData> }) => void, fail?: (err) => void, complete?: () => void }): void;

    export function getUserCloudStorage(object: { keyList: string[], success?: (data: { KVDataList: Array<KVData> }) => void, fail?: (err) => void, complete?: () => void }): void;

    export function createImage(): HTMLImageElement;

    export function getUserInfo(data: { openIdList?: string[], lang?: string, success?: (data: { data: Array<UserInfo> }) => void, fail?: (err) => void, complete?: () => void });

    export function onMessage(onMessage: (data: any) => void);
}