import { Hall } from "./Hall";

const { ccclass, property } = cc._decorator;

@ccclass
export class LoadHall extends cc.Component {

    private readonly hallUrl: string = "UI/HallBoard";

    public onLoad(): void {
        cc.loader.loadRes(this.hallUrl, cc.Prefab, (error, res) => {
            if (error) {
                console.error("动态加载出错");
                return;
            }

            let instance = cc.instantiate<cc.Node>(res);

            instance.setParent(this.node);

            let hall = instance.getComponent(Hall);
            if (!hall) {
                console.error("节点脚本获取失败");
            }
        });
    }
}
