// Learn TypeScript:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

import InfiniteCell from "../InfiniteList/InfiniteCell";
import { ChatType } from "../Enum/Enum";

const {ccclass, property} = cc._decorator;

@ccclass
export default class ChatCellView extends InfiniteCell {
    @property(cc.RichText)
    public nameText:cc.RichText;

    @property(cc.RichText)
    public richText:cc.RichText;

    // LIFE-CYCLE CALLBACKS:

    onLoad () {
        
    }

    public UpdateContent(data:any) {
        if(!data) {
            return;
        }
        let chatType:number = data.chatType;
        let title:string = data.title;
        let content:string = data.content;

        // chatType = ChatType.OtherUser;
        // title = "一朵梨花压海棠";
        
        let nameStr = "";
        let str = "";
        if(chatType == ChatType.System) {
            nameStr = "<color=#49A2F0>【系统】</color>";
            str = "<color=#FFE0E0E0>"+content+"</color>";
        }
        else if(chatType == ChatType.OtherUser) {
            nameStr = "<color=#58B333>【" + title +"】</color>";
            str = "<color=#FFE0E0E0>"+content+"</color>";
        }
        else if(chatType == ChatType.Mine) {
            nameStr = "<color=#FFD856>【自己】</color>";
            str = "<color=#FFE0E0E0>"+content+"</color>";
        }
        this.nameText.string = nameStr;
        this.richText.node.x = this.nameText.node.x + this.nameText.node.width;
        this.richText.maxWidth = 580 - this.nameText.node.width;

        this.richText.string = str;

        // printLog("-----ChatCellView UpdateContent height:------", this.richText.node.height);
        // printLog(content);
        // printLog(this.richText);

        this.node.setContentSize(cc.size(this.node.getContentSize().width, this.richText.node.height + 12));
    }
}
