// Learn TypeScript:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html

import InfiniteList from "../InfiniteList/InfiniteList";
import ChatCellView from "./ChatCellView";
import { ChatType } from "../Enum/Enum";

//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html
const {ccclass, property} = cc._decorator;

@ccclass
export default class ChatView extends cc.Component {

    @property(cc.Prefab)
    public chatCellPrefab:cc.Prefab = null;

    @property({
        type: cc.Node,
    })
    public listNode:cc.Node | null = null;

    private list:InfiniteList;

    private m_cellDatas:Array<any> = [];
    // LIFE-CYCLE CALLBACKS:

    onLoad () {
        this.list = this.listNode!.getComponent(InfiniteList);
        this.list.Init({
            getCellNumber: this._getCellNumber,
            getCellSize: this._getCellSize,
            getCellIdentifer: this._getCellIdentifer,
            getCellView: this._getCellView,
            getCellData: this._getCellData,
        })

        this.test();
    }

    public initData(showHeight:number):void {
        this.node.height = showHeight;
        this.listNode.height = showHeight;
        this.listNode.y = -showHeight / 2;
    }

    public clearChatInfo():void {
        // printLog("-----清掉聊天框数据------");
        this.m_cellDatas.splice(0, this.m_cellDatas.length);
        this.list.stopAutoScroll();
        this.list.Reload(false);
        this.list.emptyData();
    }

    private scrollToEnd():void {
        // printLog("----ChatView scrollToEnd---");
        this.unschedule(this.scrollToEnd);
        this.list.scrollToPercentVertical(0, 0.1);
    }

    start () {
        // this.list.scrollToBottom();
        // this.test();
        // this.list.scrollToPercentVertical(0, 0.1);
    }

    // update (dt) {}

    private _getCellData = (index:number):any => {
        return this.m_cellDatas[index]
    }

    private _getCellNumber = ():number => {
        return this.m_cellDatas.length;
    }

    private _getCellSize = (index:number):number => {
        return 80;
    }

    private _getCellView = ():ChatCellView => {
        let node = cc.instantiate(this.chatCellPrefab);
        return node.getComponent(ChatCellView);
    }

    private _getCellIdentifer = ():string => {
        return "ChatCellView";
    }

    private test():void {
        this.m_cellDatas.push({
            chatType: ChatType.System,
            title: "",
            content: "张三进入聊天室"
        });
        this.m_cellDatas.push({
            chatType: ChatType.OtherUser,
            title: "鹿晗",
            content: "哈哈，我知道谁是卧底"
        });
        this.m_cellDatas.push({
            chatType: ChatType.OtherUser,
            title: "王祖蓝",
            content: "我是好人"
        });
        this.m_cellDatas.push({
            chatType: ChatType.OtherUser,
            title: "黄渤",
            content: "最后一次警告，缴枪不杀"
        });
        this.m_cellDatas.push({
            chatType: ChatType.OtherUser,
            title: "范冰冰",
            content: "让我再回一次娱乐圈吧，娃哈哈是否第三方司法所发生地方"
        });
        this.m_cellDatas.push({
            chatType: ChatType.OtherUser,
            title: "鹿晗2",
            content: "哈哈，我知道谁是卧底司法所发生地方第三方第三方水电费第三方第三是否打算公司gas公司方"
        });
        this.m_cellDatas.push({
            chatType: ChatType.OtherUser,
            title: "王祖蓝2",
            content: "我是好人"
        });
        this.m_cellDatas.push({
            chatType: ChatType.OtherUser,
            title: "黄渤2",
            content: "最后一次警告，缴枪不杀"
        });
        this.m_cellDatas.push({
            chatType: ChatType.OtherUser,
            title: "范冰冰2",
            content: "让我再回一次娱乐圈吧，娃哈哈"
        });
    }
}
