"use strict";
cc._RF.push(module, 'b52b7EJdXZPXryE5+Imurt6', 'ChatCellView');
// Script/View/ChatCellView.ts

"use strict";
// Learn TypeScript:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var InfiniteCell_1 = require("../InfiniteList/InfiniteCell");
var Enum_1 = require("../Enum/Enum");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var ChatCellView = /** @class */ (function (_super) {
    __extends(ChatCellView, _super);
    function ChatCellView() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    // LIFE-CYCLE CALLBACKS:
    ChatCellView.prototype.onLoad = function () {
    };
    ChatCellView.prototype.UpdateContent = function (data) {
        if (!data) {
            return;
        }
        var chatType = data.chatType;
        var title = data.title;
        var content = data.content;
        // chatType = ChatType.OtherUser;
        // title = "一朵梨花压海棠";
        var nameStr = "";
        var str = "";
        if (chatType == Enum_1.ChatType.System) {
            nameStr = "<color=#49A2F0>【系统】</color>";
            str = "<color=#FFE0E0E0>" + content + "</color>";
        }
        else if (chatType == Enum_1.ChatType.OtherUser) {
            nameStr = "<color=#58B333>【" + title + "】</color>";
            str = "<color=#FFE0E0E0>" + content + "</color>";
        }
        else if (chatType == Enum_1.ChatType.Mine) {
            nameStr = "<color=#FFD856>【自己】</color>";
            str = "<color=#FFE0E0E0>" + content + "</color>";
        }
        this.nameText.string = nameStr;
        this.richText.node.x = this.nameText.node.x + this.nameText.node.width;
        this.richText.maxWidth = 580 - this.nameText.node.width;
        this.richText.string = str;
        // printLog("-----ChatCellView UpdateContent height:------", this.richText.node.height);
        // printLog(content);
        // printLog(this.richText);
        this.node.setContentSize(cc.size(this.node.getContentSize().width, this.richText.node.height + 12));
    };
    __decorate([
        property(cc.RichText)
    ], ChatCellView.prototype, "nameText", void 0);
    __decorate([
        property(cc.RichText)
    ], ChatCellView.prototype, "richText", void 0);
    ChatCellView = __decorate([
        ccclass
    ], ChatCellView);
    return ChatCellView;
}(InfiniteCell_1.default));
exports.default = ChatCellView;

cc._RF.pop();