
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/__qc_index__.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}
require('./assets/Script/Enum/Enum');
require('./assets/Script/InfiniteList/InfiniteCell');
require('./assets/Script/InfiniteList/InfiniteList');
require('./assets/Script/View/ChatCellView');
require('./assets/Script/View/ChatView');

                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/View/ChatCellView.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'b52b7EJdXZPXryE5+Imurt6', 'ChatCellView');
// Script/View/ChatCellView.ts

"use strict";
// Learn TypeScript:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var InfiniteCell_1 = require("../InfiniteList/InfiniteCell");
var Enum_1 = require("../Enum/Enum");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var ChatCellView = /** @class */ (function (_super) {
    __extends(ChatCellView, _super);
    function ChatCellView() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    // LIFE-CYCLE CALLBACKS:
    ChatCellView.prototype.onLoad = function () {
    };
    ChatCellView.prototype.UpdateContent = function (data) {
        if (!data) {
            return;
        }
        var chatType = data.chatType;
        var title = data.title;
        var content = data.content;
        // chatType = ChatType.OtherUser;
        // title = "一朵梨花压海棠";
        var nameStr = "";
        var str = "";
        if (chatType == Enum_1.ChatType.System) {
            nameStr = "<color=#49A2F0>【系统】</color>";
            str = "<color=#FFE0E0E0>" + content + "</color>";
        }
        else if (chatType == Enum_1.ChatType.OtherUser) {
            nameStr = "<color=#58B333>【" + title + "】</color>";
            str = "<color=#FFE0E0E0>" + content + "</color>";
        }
        else if (chatType == Enum_1.ChatType.Mine) {
            nameStr = "<color=#FFD856>【自己】</color>";
            str = "<color=#FFE0E0E0>" + content + "</color>";
        }
        this.nameText.string = nameStr;
        this.richText.node.x = this.nameText.node.x + this.nameText.node.width;
        this.richText.maxWidth = 580 - this.nameText.node.width;
        this.richText.string = str;
        // printLog("-----ChatCellView UpdateContent height:------", this.richText.node.height);
        // printLog(content);
        // printLog(this.richText);
        this.node.setContentSize(cc.size(this.node.getContentSize().width, this.richText.node.height + 12));
    };
    __decorate([
        property(cc.RichText)
    ], ChatCellView.prototype, "nameText", void 0);
    __decorate([
        property(cc.RichText)
    ], ChatCellView.prototype, "richText", void 0);
    ChatCellView = __decorate([
        ccclass
    ], ChatCellView);
    return ChatCellView;
}(InfiniteCell_1.default));
exports.default = ChatCellView;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/InfiniteList/InfiniteList.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '9230dvjPnZLh4KTrxLSP/vr', 'InfiniteList');
// Script/InfiniteList/InfiniteList.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var InfiniteCell_1 = require("./InfiniteCell");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var Direction;
(function (Direction) {
    Direction[Direction["vertical"] = 1] = "vertical";
    Direction[Direction["horizontal"] = 2] = "horizontal";
})(Direction || (Direction = {}));
var InfiniteList = /** @class */ (function (_super) {
    __extends(InfiniteList, _super);
    function InfiniteList() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.direction = Direction.vertical;
        _this.spacing = 0;
        _this.headPadding = 0;
        _this.bottomPadding = 0;
        _this.sidePadding = new cc.Vec2(0, 0);
        ////////////////////////////////////////////////////////////
        // Implenmentions
        ////////////////////////////////////////////////////////////
        _this._debug = false;
        _this._inited = false;
        _this._scrollPosition = 0;
        _this._cellPools = {};
        _this._activeCellViews = new Array();
        return _this;
    }
    InfiniteList.prototype.Init = function (p) {
        this._init(p);
    };
    /**
     * Reload 整个 List，这时获取数据的回调函数会重新触发一遍，所有的 cell 也会更新一遍内容
     */
    InfiniteList.prototype.Reload = function (keepPos) {
        if (keepPos === void 0) { keepPos = false; }
        this._clear(keepPos);
        this._load();
    };
    /**
     * 重新刷新当前显示 cell 的内容，不会重新载入整个列表
     * 所以如果列表的数据数量发生了变化，或是想要修改 Cell 的尺寸，调用 Refresh 是没有用处的，请调用 Reload
     */
    InfiniteList.prototype.Refresh = function () {
        this._updateActiveCellContent();
    };
    /**
     * 返回相对于 ScrollView 的这个 Cell 的滚动坐标
     * @param idx Cell 的索引下标
     */
    InfiniteList.prototype.GetScrollPosOfCell = function (idx) {
        var sp = this._getCellPosOfIndex(idx);
        if (this.direction == Direction.vertical) {
            return new cc.Vec2(0, sp);
        }
        else {
            return new cc.Vec2(sp * -1, 0);
        }
    };
    /**
     * 在规定的时间里滚动到指定的 Cell
     * @param idx 目标的 Cell 的下标
     */
    InfiniteList.prototype.ScrollToCell = function (idx, timeInSecond, attenuated) {
        if (timeInSecond === void 0) { timeInSecond = 1; }
        if (attenuated === void 0) { attenuated = true; }
        var pos = this.GetScrollPosOfCell(idx);
        this._scrollView.scrollTo(pos, timeInSecond, attenuated);
    };
    /**
     * 在规定的时间里滚动到指定百分比
     * @param percent 目标的百分比值
     */
    InfiniteList.prototype.scrollToPercentHorizontal = function (percent, timeInSecond, attenuated) {
        this._scrollView.scrollToPercentHorizontal(percent, timeInSecond, attenuated);
    };
    InfiniteList.prototype.scrollToPercentVertical = function (percent, timeInSecond, attenuated) {
        this._scrollView.scrollToPercentVertical(percent, timeInSecond, attenuated);
    };
    InfiniteList.prototype.scrollToBottom = function () {
        // this._scrollView.scrollToBottom(timeInSecond, attenuated);
        this._content.y = this._content.getContentSize().height;
        // printLog(this._content.y, this._content.getContentSize());
    };
    InfiniteList.prototype.emptyData = function () {
        this._content.y = 0;
    };
    InfiniteList.prototype.stopAutoScroll = function () {
        // printLog("-----停止自动滑动----");
        this._scrollView.stopAutoScroll();
    };
    InfiniteList.prototype.getScrollView = function () {
        return this._scrollView;
    };
    /**
     * 查看一个 Cell 是否当前可见
     * @param idx Cell 的下标
     */
    InfiniteList.prototype.IsCellVisible = function (idx) {
        if (idx >= this._activeCellIndexRange.x && idx <= this._activeCellIndexRange.y)
            return true;
        else
            return false;
    };
    InfiniteList.prototype.onLoad = function () {
        // setup scrollview component
        this._scrollView = this.node.getComponent(cc.ScrollView);
        if (!this._scrollView) {
            this._scrollView = this.node.addComponent(cc.ScrollView);
            if (this.direction == Direction.horizontal) {
                this._scrollView.vertical = false;
                this._scrollView.horizontal = true;
            }
            else {
                this._scrollView.vertical = true;
                this._scrollView.horizontal = false;
            }
        }
        var scrollViewEventHandler = new cc.Component.EventHandler();
        scrollViewEventHandler.target = this.node; // 这个 node 节点是你的事件处理代码组件所属的节点
        scrollViewEventHandler.component = "InfiniteList"; // 这个是代码文件名
        scrollViewEventHandler.handler = "scrollCallBack";
        this._scrollView.scrollEvents.push(scrollViewEventHandler);
        // setup content node(which is root of every cell)
        this._content = new cc.Node();
        this._content.setAnchorPoint(0, 1);
        this.node.addChild(this._content);
        this._scrollView.content = this._content;
        if (this._debug) {
            // set background color to content for debug use
            this._content.addComponent(cc.Graphics);
        }
        // Everything OK, let's start
        this._inited = true;
        if (this._delegate) {
            this._load();
        }
    };
    InfiniteList.prototype.scrollCallBack = function (scrollview, eventType, customEventData) {
        if (this._delegate.scrollCallBack) {
            this._delegate.scrollCallBack(scrollview, eventType, customEventData);
        }
        // printLog("------scrollCallBack-----", eventType);
        // printLog(customEventData);
        // if(eventType == cc.ScrollView.EventType.TOUCH_UP) {
        // 	printLog("----手抬起来---");
        // }
    };
    InfiniteList.prototype.update = function () {
        if (this._debug) {
            var g = this._content.getComponent(cc.Graphics);
            g.clear();
            g.fillColor = cc.Color.YELLOW;
            g.fillRect(0, 0, this._content.width, this._content.height);
        }
    };
    InfiniteList.prototype.onEnable = function () {
        // bind event to scrollview
        this.node.on("scrolling", this._onScrolling, this);
    };
    InfiniteList.prototype.onDisable = function () {
        this.node.targetOff(this);
    };
    InfiniteList.prototype._onScrolling = function () {
        if (!this._delegate)
            return;
        var dataLen = this._delegate.getCellNumber();
        if (dataLen <= 0)
            return;
        var offset = this._scrollView.getScrollOffset();
        if (this.direction == Direction.vertical) {
            this._scrollPosition = offset.y;
        }
        else {
            this._scrollPosition = offset.x * -1;
        }
        // refresh active cell with new scroll position
        this._refreshActiveCells();
        // printLog("------_onScrolling------", this._scrollPosition);
    };
    InfiniteList.prototype._init = function (p) {
        var needClear = false;
        if (this._delegate)
            needClear = true;
        this._delegate = p;
        if (this._inited) {
            if (needClear)
                this._clear();
            this._load();
        }
    };
    InfiniteList.prototype._clear = function (keepPos) {
        if (keepPos === void 0) { keepPos = false; }
        if (this._activeCellViews) {
            while (this._activeCellViews.length > 0) {
                this._recycleCell(this._activeCellViews.length - 1);
            }
        }
        this._activeCellIndexRange = new cc.Vec2(-1, -1);
        if (!keepPos) {
            this._scrollPosition = 0;
            this._content.x = 0;
            this._content.y = 0;
        }
    };
    InfiniteList.prototype._load = function () {
        // get all cell offset with spacing and padding
        var dataLen = this._delegate.getCellNumber();
        if (dataLen <= 0)
            return;
        // printLog("-----InfiniteList _load 111-----", dataLen);
        var offset = this.headPadding;
        this._cellsOffset = new Array(dataLen);
        this._cellsSize = new Array(dataLen);
        for (var i = 0; i < dataLen; i++) {
            if (i < this._activeCellViews.length) {
                var cell = this._activeCellViews[i];
                // printLog(cell.node.height);
            }
            var s = this._delegate.getCellSize(i);
            this._cellsSize[i] = s;
            offset = s + (i == 0 ? 0 : this.spacing) + offset;
            this._cellsOffset[i] = offset;
        }
        // offset += this.bottomPadding;
        // if (this.direction == Direction.vertical) {
        // 	this._content.setContentSize(this.node.width, offset);
        // } else {
        // 	this._content.setContentSize(offset, this.node.height);
        // }
        // create visible cells
        var range = this._getActiveCellIndexRange();
        this._activeCellIndexRange = range;
        // printLog("---------InfiniteList _load: --------", range.x, range.y);
        for (var i = range.x; i <= range.y; i++) {
            // printLog("-----InfiniteList _load 222-----", i);
            this._addCellView(i);
        }
        this.updateContentSize();
    };
    InfiniteList.prototype.updateContentSize = function () {
        var dataLen = this._delegate.getCellNumber();
        if (dataLen <= 0)
            return;
        var offset = this._cellsOffset[dataLen - 1] + this.bottomPadding;
        if (this.direction == Direction.vertical) {
            this._content.setContentSize(this.node.width, offset);
        }
        else {
            this._content.setContentSize(offset, this.node.height);
        }
    };
    InfiniteList.prototype._refreshActiveCells = function () {
        // printLog("-----InfiniteList _refreshActiveCells-----");
        // update current active cells with new scroll position
        var range = this._getActiveCellIndexRange();
        // check if any cell need update
        if (range.equals(this._activeCellIndexRange))
            return;
        // recycle all out of range cell
        var i = 0;
        while (i < this._activeCellViews.length) {
            var cell = this._activeCellViews[i];
            if (cell.dataIndex < range.x || cell.dataIndex > range.y) {
                this._recycleCell(i);
            }
            else {
                i++;
            }
        }
        // add any not exist cell
        // !TODO: boost this part effecient
        for (var i_1 = range.x; i_1 <= range.y; i_1++) {
            var needadd = true;
            var cell = void 0;
            for (var j = 0; j < this._activeCellViews.length; j++) {
                if (this._activeCellViews[j].dataIndex == i_1) {
                    needadd = false;
                    cell = this._activeCellViews[j];
                    break;
                }
            }
            if (needadd) {
                // printLog("---------InfiniteList _refreshActiveCells: --------", range.x, range.y, i);
                this._addCellView(i_1);
            }
            else {
                this.updateCellPosition(cell, i_1);
            }
        }
        // update current active cell range
        this._activeCellIndexRange = range;
        this.updateContentSize();
    };
    /**
     * remove one active cell from _activeCellViews array
     * @param cellIndex index of active cell views array
     */
    InfiniteList.prototype._recycleCell = function (cellIndex) {
        // !TODO: need store this cell in node pool
        var cell = this._activeCellViews[cellIndex];
        this._activeCellViews.splice(cellIndex, 1);
        cell.node.removeFromParent(false);
        cell.dataIndex = -1;
        if (!this._cellPools[cell.cellIdentifier]) {
            this._cellPools[cell.cellIdentifier] = new cc.NodePool();
        }
        var pool = this._cellPools[cell.cellIdentifier];
        pool.put(cell.node);
    };
    InfiniteList.prototype._getCellViewFromPool = function (id) {
        // printLog("----InfiniteList _getCellViewFromPool-----", id);
        if (!this._cellPools[id])
            return null;
        var pool = this._cellPools[id];
        var cellNode = pool.get();
        if (!cellNode)
            return null;
        return cellNode.getComponent(InfiniteCell_1.default);
    };
    /**
     * Return vector2 for start and end cell index of current scroll position
     */
    InfiniteList.prototype._getActiveCellIndexRange = function () {
        var startPos = this._scrollPosition;
        var endPos = startPos + (this.direction == Direction.vertical ? this.node.height : this.node.width);
        return new cc.Vec2(this._getCellIndexOfPos(startPos), this._getCellIndexOfPos(endPos));
    };
    InfiniteList.prototype._getCellIndexOfPos = function (pos) {
        // !TODO: boost this function speed by using binary search
        for (var i = 0; i < this._cellsOffset.length; i++) {
            if (this._cellsOffset[i] >= pos)
                return i;
        }
        return this._cellsOffset.length - 1;
    };
    /**
     * Get cell top position by its index
     * @param idx Cell index
     */
    InfiniteList.prototype._getCellPosOfIndex = function (idx) {
        return this._cellsOffset[idx] - this._cellsSize[idx];
    };
    InfiniteList.prototype._addCellView = function (dataIndex) {
        // printLog("------InfiniteList _addCellView-----", dataIndex);
        var id = this._delegate.getCellIdentifer(dataIndex);
        var cell = this._getCellViewFromPool(id);
        if (!cell) {
            cell = this._delegate.getCellView(dataIndex);
            cell.node.setAnchorPoint(0, 1);
            cell.cellIdentifier = id;
        }
        cell.dataIndex = dataIndex;
        cell.enabled = true;
        this._activeCellViews.push(cell);
        this._content.addChild(cell.node);
        this._updateCellContent(cell);
        this.updateCellPosition(cell, dataIndex);
    };
    InfiniteList.prototype.updateCellPosition = function (cell, dataIndex) {
        if (this.direction == Direction.vertical) {
            var s = cell.node.getContentSize().height;
            this._cellsSize[dataIndex] = s;
            var offset = 0;
            if (dataIndex == 0) {
                offset = this.headPadding + s;
            }
            else {
                offset = s + (dataIndex == 0 ? 0 : this.spacing) + this._cellsOffset[dataIndex - 1];
            }
            var diffY = offset - this._cellsOffset[dataIndex];
            this._cellsOffset[dataIndex] = offset;
            for (var i = (dataIndex + 1); i < this._cellsOffset.length; i++) {
                this._cellsOffset[i] = this._cellsOffset[i] + diffY;
            }
            cell.node.x = this.sidePadding.x;
            cell.node.y = (this._cellsOffset[dataIndex] - this._cellsSize[dataIndex]) * -1;
            cell.node.setContentSize(this.node.width - this.sidePadding.x - this.sidePadding.y, this._cellsSize[dataIndex]);
        }
        else {
            var s = cell.node.getContentSize().width;
            this._cellsSize[dataIndex] = s;
            var offset = 0;
            if (dataIndex == 0) {
                offset = this.headPadding + s;
            }
            else {
                offset = s + (dataIndex == 0 ? 0 : this.spacing) + this._cellsOffset[dataIndex - 1];
            }
            var diffX = offset - this._cellsOffset[dataIndex];
            this._cellsOffset[dataIndex] = offset;
            for (var i = (dataIndex + 1); i < this._cellsOffset.length; i++) {
                this._cellsOffset[i] = this._cellsOffset[i] + diffX;
            }
            cell.node.x = (this._cellsOffset[dataIndex] - this._cellsSize[dataIndex]);
            cell.node.y = this.sidePadding.x * -1;
            cell.node.setContentSize(this._cellsSize[dataIndex], this.node.height - this.sidePadding.x - this.sidePadding.y);
        }
    };
    InfiniteList.prototype._updateActiveCellContent = function () {
        var _this = this;
        this._activeCellViews.forEach(function (cell) {
            _this._updateCellContent(cell);
        });
    };
    InfiniteList.prototype._updateCellContent = function (cell) {
        var data = null;
        if (this._delegate.getCellData) {
            data = this._delegate.getCellData(cell.dataIndex);
        }
        cell.UpdateContent(data);
    };
    __decorate([
        property({
            type: cc.Enum(Direction),
            tooltip: "List 滚动的方向，可以选择垂直或者水平"
        })
    ], InfiniteList.prototype, "direction", void 0);
    __decorate([
        property({
            tooltip: "cell 之间的像素间隔，最开始和最后面不会添加"
        })
    ], InfiniteList.prototype, "spacing", void 0);
    __decorate([
        property({ tooltip: "List 顶部（水平滚动则是最左边）的间隔空间" })
    ], InfiniteList.prototype, "headPadding", void 0);
    __decorate([
        property({ tooltip: "List 底部（水平滚动则是最右边）的间隔空间" })
    ], InfiniteList.prototype, "bottomPadding", void 0);
    __decorate([
        property({ tooltip: "侧边的间距，垂直滚动就是左右边的间距，水平滚动就是上下边的间距" })
    ], InfiniteList.prototype, "sidePadding", void 0);
    InfiniteList = __decorate([
        ccclass
    ], InfiniteList);
    return InfiniteList;
}(cc.Component));
exports.default = InfiniteList;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/Enum/Enum.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '28e8cF9vQdDlIxfFursL+Xm', 'Enum');
// Script/Enum/Enum.ts

"use strict";
// Learn TypeScript:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html
Object.defineProperty(exports, "__esModule", { value: true });
// 消息类型
var ChatType;
(function (ChatType) {
    ChatType[ChatType["System"] = 0] = "System";
    ChatType[ChatType["OtherUser"] = 1] = "OtherUser";
    ChatType[ChatType["Mine"] = 2] = "Mine";
})(ChatType = exports.ChatType || (exports.ChatType = {}));

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFzc2V0cy9TY3JpcHQvRW51bS9FbnVtLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7Ozs7QUFBQSxvQkFBb0I7QUFDcEIsa0ZBQWtGO0FBQ2xGLHlGQUF5RjtBQUN6RixtQkFBbUI7QUFDbkIsNEZBQTRGO0FBQzVGLG1HQUFtRztBQUNuRyw4QkFBOEI7QUFDOUIsNEZBQTRGO0FBQzVGLG1HQUFtRzs7QUFFbkcsT0FBTztBQUNQLElBQVksUUFJWDtBQUpELFdBQVksUUFBUTtJQUNoQiwyQ0FBVSxDQUFBO0lBQ1YsaURBQWEsQ0FBQTtJQUNiLHVDQUFRLENBQUE7QUFDWixDQUFDLEVBSlcsUUFBUSxHQUFSLGdCQUFRLEtBQVIsZ0JBQVEsUUFJbkIiLCJmaWxlIjoiIiwic291cmNlUm9vdCI6Ii8iLCJzb3VyY2VzQ29udGVudCI6WyIvLyBMZWFybiBUeXBlU2NyaXB0OlxuLy8gIC0gW0NoaW5lc2VdIGh0dHBzOi8vZG9jcy5jb2Nvcy5jb20vY3JlYXRvci9tYW51YWwvemgvc2NyaXB0aW5nL3R5cGVzY3JpcHQuaHRtbFxuLy8gIC0gW0VuZ2xpc2hdIGh0dHA6Ly93d3cuY29jb3MyZC14Lm9yZy9kb2NzL2NyZWF0b3IvbWFudWFsL2VuL3NjcmlwdGluZy90eXBlc2NyaXB0Lmh0bWxcbi8vIExlYXJuIEF0dHJpYnV0ZTpcbi8vICAtIFtDaGluZXNlXSBodHRwczovL2RvY3MuY29jb3MuY29tL2NyZWF0b3IvbWFudWFsL3poL3NjcmlwdGluZy9yZWZlcmVuY2UvYXR0cmlidXRlcy5odG1sXG4vLyAgLSBbRW5nbGlzaF0gaHR0cDovL3d3dy5jb2NvczJkLXgub3JnL2RvY3MvY3JlYXRvci9tYW51YWwvZW4vc2NyaXB0aW5nL3JlZmVyZW5jZS9hdHRyaWJ1dGVzLmh0bWxcbi8vIExlYXJuIGxpZmUtY3ljbGUgY2FsbGJhY2tzOlxuLy8gIC0gW0NoaW5lc2VdIGh0dHBzOi8vZG9jcy5jb2Nvcy5jb20vY3JlYXRvci9tYW51YWwvemgvc2NyaXB0aW5nL2xpZmUtY3ljbGUtY2FsbGJhY2tzLmh0bWxcbi8vICAtIFtFbmdsaXNoXSBodHRwOi8vd3d3LmNvY29zMmQteC5vcmcvZG9jcy9jcmVhdG9yL21hbnVhbC9lbi9zY3JpcHRpbmcvbGlmZS1jeWNsZS1jYWxsYmFja3MuaHRtbFxuXG4vLyDmtojmga/nsbvlnotcbmV4cG9ydCBlbnVtIENoYXRUeXBlIHtcbiAgICBTeXN0ZW0gPSAwLCAgLy/ns7vnu59cbiAgICBPdGhlclVzZXIgPSAxLCAvL+WFtuS7lueOqeWutlxuICAgIE1pbmUgPSAyLCAvL+iHquW3sVxufVxuXG5cbiJdfQ==
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/View/ChatView.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '76ddboxkCVEVpLRjApSmlf6', 'ChatView');
// Script/View/ChatView.ts

"use strict";
// Learn TypeScript:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var InfiniteList_1 = require("../InfiniteList/InfiniteList");
var ChatCellView_1 = require("./ChatCellView");
var Enum_1 = require("../Enum/Enum");
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var ChatView = /** @class */ (function (_super) {
    __extends(ChatView, _super);
    function ChatView() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.chatCellPrefab = null;
        _this.listNode = null;
        _this.m_cellDatas = [];
        // update (dt) {}
        _this._getCellData = function (index) {
            return _this.m_cellDatas[index];
        };
        _this._getCellNumber = function () {
            return _this.m_cellDatas.length;
        };
        _this._getCellSize = function (index) {
            return 80;
        };
        _this._getCellView = function () {
            var node = cc.instantiate(_this.chatCellPrefab);
            return node.getComponent(ChatCellView_1.default);
        };
        _this._getCellIdentifer = function () {
            return "ChatCellView";
        };
        return _this;
    }
    // LIFE-CYCLE CALLBACKS:
    ChatView.prototype.onLoad = function () {
        this.list = this.listNode.getComponent(InfiniteList_1.default);
        this.list.Init({
            getCellNumber: this._getCellNumber,
            getCellSize: this._getCellSize,
            getCellIdentifer: this._getCellIdentifer,
            getCellView: this._getCellView,
            getCellData: this._getCellData,
        });
        this.test();
    };
    ChatView.prototype.initData = function (showHeight) {
        this.node.height = showHeight;
        this.listNode.height = showHeight;
        this.listNode.y = -showHeight / 2;
    };
    ChatView.prototype.clearChatInfo = function () {
        // printLog("-----清掉聊天框数据------");
        this.m_cellDatas.splice(0, this.m_cellDatas.length);
        this.list.stopAutoScroll();
        this.list.Reload(false);
        this.list.emptyData();
    };
    ChatView.prototype.scrollToEnd = function () {
        // printLog("----ChatView scrollToEnd---");
        this.unschedule(this.scrollToEnd);
        this.list.scrollToPercentVertical(0, 0.1);
    };
    ChatView.prototype.start = function () {
        // this.list.scrollToBottom();
        // this.test();
        // this.list.scrollToPercentVertical(0, 0.1);
    };
    ChatView.prototype.test = function () {
        this.m_cellDatas.push({
            chatType: Enum_1.ChatType.System,
            title: "",
            content: "张三进入聊天室"
        });
        this.m_cellDatas.push({
            chatType: Enum_1.ChatType.OtherUser,
            title: "鹿晗",
            content: "哈哈，我知道谁是卧底"
        });
        this.m_cellDatas.push({
            chatType: Enum_1.ChatType.OtherUser,
            title: "王祖蓝",
            content: "我是好人"
        });
        this.m_cellDatas.push({
            chatType: Enum_1.ChatType.OtherUser,
            title: "黄渤",
            content: "最后一次警告，缴枪不杀"
        });
        this.m_cellDatas.push({
            chatType: Enum_1.ChatType.OtherUser,
            title: "范冰冰",
            content: "让我再回一次娱乐圈吧，娃哈哈是否第三方司法所发生地方"
        });
        this.m_cellDatas.push({
            chatType: Enum_1.ChatType.OtherUser,
            title: "鹿晗2",
            content: "哈哈，我知道谁是卧底司法所发生地方第三方第三方水电费第三方第三是否打算公司gas公司方"
        });
        this.m_cellDatas.push({
            chatType: Enum_1.ChatType.OtherUser,
            title: "王祖蓝2",
            content: "我是好人"
        });
        this.m_cellDatas.push({
            chatType: Enum_1.ChatType.OtherUser,
            title: "黄渤2",
            content: "最后一次警告，缴枪不杀"
        });
        this.m_cellDatas.push({
            chatType: Enum_1.ChatType.OtherUser,
            title: "范冰冰2",
            content: "让我再回一次娱乐圈吧，娃哈哈"
        });
    };
    __decorate([
        property(cc.Prefab)
    ], ChatView.prototype, "chatCellPrefab", void 0);
    __decorate([
        property({
            type: cc.Node,
        })
    ], ChatView.prototype, "listNode", void 0);
    ChatView = __decorate([
        ccclass
    ], ChatView);
    return ChatView;
}(cc.Component));
exports.default = ChatView;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/InfiniteList/InfiniteCell.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '87303raMm1GZZKWVBEZpPSq', 'InfiniteCell');
// Script/InfiniteList/InfiniteCell.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
/**
 * InfiniteCell base class
 * Author: Louis Huang
 * Date: 2018.10.03
 *
 * 每一个使用 InfiniteList 的用户，都需要实现这个 cell 的 interface
 */
var InfiniteCell = /** @class */ (function (_super) {
    __extends(InfiniteCell, _super);
    function InfiniteCell() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * cellIdentifier 是一个独特的字符串，用来表示这个 cell 使用的是哪种类型的资源，
         * 这样在同一个 scroll 中可以使用多种不同的 cell 类型
         */
        _this.cellIdentifier = "";
        /**
         * 表示这个 cell 使用的数据，在整个数据中的索引值
         */
        _this.dataIndex = -1;
        return _this;
    }
    __decorate([
        property
    ], InfiniteCell.prototype, "cellIdentifier", void 0);
    InfiniteCell = __decorate([
        ccclass
    ], InfiniteCell);
    return InfiniteCell;
}(cc.Component));
exports.default = InfiniteCell;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------
