"use strict";
cc._RF.push(module, '9230dvjPnZLh4KTrxLSP/vr', 'InfiniteList');
// Script/InfiniteList/InfiniteList.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var InfiniteCell_1 = require("./InfiniteCell");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var Direction;
(function (Direction) {
    Direction[Direction["vertical"] = 1] = "vertical";
    Direction[Direction["horizontal"] = 2] = "horizontal";
})(Direction || (Direction = {}));
var InfiniteList = /** @class */ (function (_super) {
    __extends(InfiniteList, _super);
    function InfiniteList() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.direction = Direction.vertical;
        _this.spacing = 0;
        _this.headPadding = 0;
        _this.bottomPadding = 0;
        _this.sidePadding = new cc.Vec2(0, 0);
        ////////////////////////////////////////////////////////////
        // Implenmentions
        ////////////////////////////////////////////////////////////
        _this._debug = false;
        _this._inited = false;
        _this._scrollPosition = 0;
        _this._cellPools = {};
        _this._activeCellViews = new Array();
        return _this;
    }
    InfiniteList.prototype.Init = function (p) {
        this._init(p);
    };
    /**
     * Reload 整个 List，这时获取数据的回调函数会重新触发一遍，所有的 cell 也会更新一遍内容
     */
    InfiniteList.prototype.Reload = function (keepPos) {
        if (keepPos === void 0) { keepPos = false; }
        this._clear(keepPos);
        this._load();
    };
    /**
     * 重新刷新当前显示 cell 的内容，不会重新载入整个列表
     * 所以如果列表的数据数量发生了变化，或是想要修改 Cell 的尺寸，调用 Refresh 是没有用处的，请调用 Reload
     */
    InfiniteList.prototype.Refresh = function () {
        this._updateActiveCellContent();
    };
    /**
     * 返回相对于 ScrollView 的这个 Cell 的滚动坐标
     * @param idx Cell 的索引下标
     */
    InfiniteList.prototype.GetScrollPosOfCell = function (idx) {
        var sp = this._getCellPosOfIndex(idx);
        if (this.direction == Direction.vertical) {
            return new cc.Vec2(0, sp);
        }
        else {
            return new cc.Vec2(sp * -1, 0);
        }
    };
    /**
     * 在规定的时间里滚动到指定的 Cell
     * @param idx 目标的 Cell 的下标
     */
    InfiniteList.prototype.ScrollToCell = function (idx, timeInSecond, attenuated) {
        if (timeInSecond === void 0) { timeInSecond = 1; }
        if (attenuated === void 0) { attenuated = true; }
        var pos = this.GetScrollPosOfCell(idx);
        this._scrollView.scrollTo(pos, timeInSecond, attenuated);
    };
    /**
     * 在规定的时间里滚动到指定百分比
     * @param percent 目标的百分比值
     */
    InfiniteList.prototype.scrollToPercentHorizontal = function (percent, timeInSecond, attenuated) {
        this._scrollView.scrollToPercentHorizontal(percent, timeInSecond, attenuated);
    };
    InfiniteList.prototype.scrollToPercentVertical = function (percent, timeInSecond, attenuated) {
        this._scrollView.scrollToPercentVertical(percent, timeInSecond, attenuated);
    };
    InfiniteList.prototype.scrollToBottom = function () {
        // this._scrollView.scrollToBottom(timeInSecond, attenuated);
        this._content.y = this._content.getContentSize().height;
        // printLog(this._content.y, this._content.getContentSize());
    };
    InfiniteList.prototype.emptyData = function () {
        this._content.y = 0;
    };
    InfiniteList.prototype.stopAutoScroll = function () {
        // printLog("-----停止自动滑动----");
        this._scrollView.stopAutoScroll();
    };
    InfiniteList.prototype.getScrollView = function () {
        return this._scrollView;
    };
    /**
     * 查看一个 Cell 是否当前可见
     * @param idx Cell 的下标
     */
    InfiniteList.prototype.IsCellVisible = function (idx) {
        if (idx >= this._activeCellIndexRange.x && idx <= this._activeCellIndexRange.y)
            return true;
        else
            return false;
    };
    InfiniteList.prototype.onLoad = function () {
        // setup scrollview component
        this._scrollView = this.node.getComponent(cc.ScrollView);
        if (!this._scrollView) {
            this._scrollView = this.node.addComponent(cc.ScrollView);
            if (this.direction == Direction.horizontal) {
                this._scrollView.vertical = false;
                this._scrollView.horizontal = true;
            }
            else {
                this._scrollView.vertical = true;
                this._scrollView.horizontal = false;
            }
        }
        var scrollViewEventHandler = new cc.Component.EventHandler();
        scrollViewEventHandler.target = this.node; // 这个 node 节点是你的事件处理代码组件所属的节点
        scrollViewEventHandler.component = "InfiniteList"; // 这个是代码文件名
        scrollViewEventHandler.handler = "scrollCallBack";
        this._scrollView.scrollEvents.push(scrollViewEventHandler);
        // setup content node(which is root of every cell)
        this._content = new cc.Node();
        this._content.setAnchorPoint(0, 1);
        this.node.addChild(this._content);
        this._scrollView.content = this._content;
        if (this._debug) {
            // set background color to content for debug use
            this._content.addComponent(cc.Graphics);
        }
        // Everything OK, let's start
        this._inited = true;
        if (this._delegate) {
            this._load();
        }
    };
    InfiniteList.prototype.scrollCallBack = function (scrollview, eventType, customEventData) {
        if (this._delegate.scrollCallBack) {
            this._delegate.scrollCallBack(scrollview, eventType, customEventData);
        }
        // printLog("------scrollCallBack-----", eventType);
        // printLog(customEventData);
        // if(eventType == cc.ScrollView.EventType.TOUCH_UP) {
        // 	printLog("----手抬起来---");
        // }
    };
    InfiniteList.prototype.update = function () {
        if (this._debug) {
            var g = this._content.getComponent(cc.Graphics);
            g.clear();
            g.fillColor = cc.Color.YELLOW;
            g.fillRect(0, 0, this._content.width, this._content.height);
        }
    };
    InfiniteList.prototype.onEnable = function () {
        // bind event to scrollview
        this.node.on("scrolling", this._onScrolling, this);
    };
    InfiniteList.prototype.onDisable = function () {
        this.node.targetOff(this);
    };
    InfiniteList.prototype._onScrolling = function () {
        if (!this._delegate)
            return;
        var dataLen = this._delegate.getCellNumber();
        if (dataLen <= 0)
            return;
        var offset = this._scrollView.getScrollOffset();
        if (this.direction == Direction.vertical) {
            this._scrollPosition = offset.y;
        }
        else {
            this._scrollPosition = offset.x * -1;
        }
        // refresh active cell with new scroll position
        this._refreshActiveCells();
        // printLog("------_onScrolling------", this._scrollPosition);
    };
    InfiniteList.prototype._init = function (p) {
        var needClear = false;
        if (this._delegate)
            needClear = true;
        this._delegate = p;
        if (this._inited) {
            if (needClear)
                this._clear();
            this._load();
        }
    };
    InfiniteList.prototype._clear = function (keepPos) {
        if (keepPos === void 0) { keepPos = false; }
        if (this._activeCellViews) {
            while (this._activeCellViews.length > 0) {
                this._recycleCell(this._activeCellViews.length - 1);
            }
        }
        this._activeCellIndexRange = new cc.Vec2(-1, -1);
        if (!keepPos) {
            this._scrollPosition = 0;
            this._content.x = 0;
            this._content.y = 0;
        }
    };
    InfiniteList.prototype._load = function () {
        // get all cell offset with spacing and padding
        var dataLen = this._delegate.getCellNumber();
        if (dataLen <= 0)
            return;
        // printLog("-----InfiniteList _load 111-----", dataLen);
        var offset = this.headPadding;
        this._cellsOffset = new Array(dataLen);
        this._cellsSize = new Array(dataLen);
        for (var i = 0; i < dataLen; i++) {
            if (i < this._activeCellViews.length) {
                var cell = this._activeCellViews[i];
                // printLog(cell.node.height);
            }
            var s = this._delegate.getCellSize(i);
            this._cellsSize[i] = s;
            offset = s + (i == 0 ? 0 : this.spacing) + offset;
            this._cellsOffset[i] = offset;
        }
        // offset += this.bottomPadding;
        // if (this.direction == Direction.vertical) {
        // 	this._content.setContentSize(this.node.width, offset);
        // } else {
        // 	this._content.setContentSize(offset, this.node.height);
        // }
        // create visible cells
        var range = this._getActiveCellIndexRange();
        this._activeCellIndexRange = range;
        // printLog("---------InfiniteList _load: --------", range.x, range.y);
        for (var i = range.x; i <= range.y; i++) {
            // printLog("-----InfiniteList _load 222-----", i);
            this._addCellView(i);
        }
        this.updateContentSize();
    };
    InfiniteList.prototype.updateContentSize = function () {
        var dataLen = this._delegate.getCellNumber();
        if (dataLen <= 0)
            return;
        var offset = this._cellsOffset[dataLen - 1] + this.bottomPadding;
        if (this.direction == Direction.vertical) {
            this._content.setContentSize(this.node.width, offset);
        }
        else {
            this._content.setContentSize(offset, this.node.height);
        }
    };
    InfiniteList.prototype._refreshActiveCells = function () {
        // printLog("-----InfiniteList _refreshActiveCells-----");
        // update current active cells with new scroll position
        var range = this._getActiveCellIndexRange();
        // check if any cell need update
        if (range.equals(this._activeCellIndexRange))
            return;
        // recycle all out of range cell
        var i = 0;
        while (i < this._activeCellViews.length) {
            var cell = this._activeCellViews[i];
            if (cell.dataIndex < range.x || cell.dataIndex > range.y) {
                this._recycleCell(i);
            }
            else {
                i++;
            }
        }
        // add any not exist cell
        // !TODO: boost this part effecient
        for (var i_1 = range.x; i_1 <= range.y; i_1++) {
            var needadd = true;
            var cell = void 0;
            for (var j = 0; j < this._activeCellViews.length; j++) {
                if (this._activeCellViews[j].dataIndex == i_1) {
                    needadd = false;
                    cell = this._activeCellViews[j];
                    break;
                }
            }
            if (needadd) {
                // printLog("---------InfiniteList _refreshActiveCells: --------", range.x, range.y, i);
                this._addCellView(i_1);
            }
            else {
                this.updateCellPosition(cell, i_1);
            }
        }
        // update current active cell range
        this._activeCellIndexRange = range;
        this.updateContentSize();
    };
    /**
     * remove one active cell from _activeCellViews array
     * @param cellIndex index of active cell views array
     */
    InfiniteList.prototype._recycleCell = function (cellIndex) {
        // !TODO: need store this cell in node pool
        var cell = this._activeCellViews[cellIndex];
        this._activeCellViews.splice(cellIndex, 1);
        cell.node.removeFromParent(false);
        cell.dataIndex = -1;
        if (!this._cellPools[cell.cellIdentifier]) {
            this._cellPools[cell.cellIdentifier] = new cc.NodePool();
        }
        var pool = this._cellPools[cell.cellIdentifier];
        pool.put(cell.node);
    };
    InfiniteList.prototype._getCellViewFromPool = function (id) {
        // printLog("----InfiniteList _getCellViewFromPool-----", id);
        if (!this._cellPools[id])
            return null;
        var pool = this._cellPools[id];
        var cellNode = pool.get();
        if (!cellNode)
            return null;
        return cellNode.getComponent(InfiniteCell_1.default);
    };
    /**
     * Return vector2 for start and end cell index of current scroll position
     */
    InfiniteList.prototype._getActiveCellIndexRange = function () {
        var startPos = this._scrollPosition;
        var endPos = startPos + (this.direction == Direction.vertical ? this.node.height : this.node.width);
        return new cc.Vec2(this._getCellIndexOfPos(startPos), this._getCellIndexOfPos(endPos));
    };
    InfiniteList.prototype._getCellIndexOfPos = function (pos) {
        // !TODO: boost this function speed by using binary search
        for (var i = 0; i < this._cellsOffset.length; i++) {
            if (this._cellsOffset[i] >= pos)
                return i;
        }
        return this._cellsOffset.length - 1;
    };
    /**
     * Get cell top position by its index
     * @param idx Cell index
     */
    InfiniteList.prototype._getCellPosOfIndex = function (idx) {
        return this._cellsOffset[idx] - this._cellsSize[idx];
    };
    InfiniteList.prototype._addCellView = function (dataIndex) {
        // printLog("------InfiniteList _addCellView-----", dataIndex);
        var id = this._delegate.getCellIdentifer(dataIndex);
        var cell = this._getCellViewFromPool(id);
        if (!cell) {
            cell = this._delegate.getCellView(dataIndex);
            cell.node.setAnchorPoint(0, 1);
            cell.cellIdentifier = id;
        }
        cell.dataIndex = dataIndex;
        cell.enabled = true;
        this._activeCellViews.push(cell);
        this._content.addChild(cell.node);
        this._updateCellContent(cell);
        this.updateCellPosition(cell, dataIndex);
    };
    InfiniteList.prototype.updateCellPosition = function (cell, dataIndex) {
        if (this.direction == Direction.vertical) {
            var s = cell.node.getContentSize().height;
            this._cellsSize[dataIndex] = s;
            var offset = 0;
            if (dataIndex == 0) {
                offset = this.headPadding + s;
            }
            else {
                offset = s + (dataIndex == 0 ? 0 : this.spacing) + this._cellsOffset[dataIndex - 1];
            }
            var diffY = offset - this._cellsOffset[dataIndex];
            this._cellsOffset[dataIndex] = offset;
            for (var i = (dataIndex + 1); i < this._cellsOffset.length; i++) {
                this._cellsOffset[i] = this._cellsOffset[i] + diffY;
            }
            cell.node.x = this.sidePadding.x;
            cell.node.y = (this._cellsOffset[dataIndex] - this._cellsSize[dataIndex]) * -1;
            cell.node.setContentSize(this.node.width - this.sidePadding.x - this.sidePadding.y, this._cellsSize[dataIndex]);
        }
        else {
            var s = cell.node.getContentSize().width;
            this._cellsSize[dataIndex] = s;
            var offset = 0;
            if (dataIndex == 0) {
                offset = this.headPadding + s;
            }
            else {
                offset = s + (dataIndex == 0 ? 0 : this.spacing) + this._cellsOffset[dataIndex - 1];
            }
            var diffX = offset - this._cellsOffset[dataIndex];
            this._cellsOffset[dataIndex] = offset;
            for (var i = (dataIndex + 1); i < this._cellsOffset.length; i++) {
                this._cellsOffset[i] = this._cellsOffset[i] + diffX;
            }
            cell.node.x = (this._cellsOffset[dataIndex] - this._cellsSize[dataIndex]);
            cell.node.y = this.sidePadding.x * -1;
            cell.node.setContentSize(this._cellsSize[dataIndex], this.node.height - this.sidePadding.x - this.sidePadding.y);
        }
    };
    InfiniteList.prototype._updateActiveCellContent = function () {
        var _this = this;
        this._activeCellViews.forEach(function (cell) {
            _this._updateCellContent(cell);
        });
    };
    InfiniteList.prototype._updateCellContent = function (cell) {
        var data = null;
        if (this._delegate.getCellData) {
            data = this._delegate.getCellData(cell.dataIndex);
        }
        cell.UpdateContent(data);
    };
    __decorate([
        property({
            type: cc.Enum(Direction),
            tooltip: "List 滚动的方向，可以选择垂直或者水平"
        })
    ], InfiniteList.prototype, "direction", void 0);
    __decorate([
        property({
            tooltip: "cell 之间的像素间隔，最开始和最后面不会添加"
        })
    ], InfiniteList.prototype, "spacing", void 0);
    __decorate([
        property({ tooltip: "List 顶部（水平滚动则是最左边）的间隔空间" })
    ], InfiniteList.prototype, "headPadding", void 0);
    __decorate([
        property({ tooltip: "List 底部（水平滚动则是最右边）的间隔空间" })
    ], InfiniteList.prototype, "bottomPadding", void 0);
    __decorate([
        property({ tooltip: "侧边的间距，垂直滚动就是左右边的间距，水平滚动就是上下边的间距" })
    ], InfiniteList.prototype, "sidePadding", void 0);
    InfiniteList = __decorate([
        ccclass
    ], InfiniteList);
    return InfiniteList;
}(cc.Component));
exports.default = InfiniteList;

cc._RF.pop();