"use strict";
cc._RF.push(module, '76ddboxkCVEVpLRjApSmlf6', 'ChatView');
// Script/View/ChatView.ts

"use strict";
// Learn TypeScript:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var InfiniteList_1 = require("../InfiniteList/InfiniteList");
var ChatCellView_1 = require("./ChatCellView");
var Enum_1 = require("../Enum/Enum");
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var ChatView = /** @class */ (function (_super) {
    __extends(ChatView, _super);
    function ChatView() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.chatCellPrefab = null;
        _this.listNode = null;
        _this.m_cellDatas = [];
        // update (dt) {}
        _this._getCellData = function (index) {
            return _this.m_cellDatas[index];
        };
        _this._getCellNumber = function () {
            return _this.m_cellDatas.length;
        };
        _this._getCellSize = function (index) {
            return 80;
        };
        _this._getCellView = function () {
            var node = cc.instantiate(_this.chatCellPrefab);
            return node.getComponent(ChatCellView_1.default);
        };
        _this._getCellIdentifer = function () {
            return "ChatCellView";
        };
        return _this;
    }
    // LIFE-CYCLE CALLBACKS:
    ChatView.prototype.onLoad = function () {
        this.list = this.listNode.getComponent(InfiniteList_1.default);
        this.list.Init({
            getCellNumber: this._getCellNumber,
            getCellSize: this._getCellSize,
            getCellIdentifer: this._getCellIdentifer,
            getCellView: this._getCellView,
            getCellData: this._getCellData,
        });
        this.test();
    };
    ChatView.prototype.initData = function (showHeight) {
        this.node.height = showHeight;
        this.listNode.height = showHeight;
        this.listNode.y = -showHeight / 2;
    };
    ChatView.prototype.clearChatInfo = function () {
        // printLog("-----清掉聊天框数据------");
        this.m_cellDatas.splice(0, this.m_cellDatas.length);
        this.list.stopAutoScroll();
        this.list.Reload(false);
        this.list.emptyData();
    };
    ChatView.prototype.scrollToEnd = function () {
        // printLog("----ChatView scrollToEnd---");
        this.unschedule(this.scrollToEnd);
        this.list.scrollToPercentVertical(0, 0.1);
    };
    ChatView.prototype.start = function () {
        // this.list.scrollToBottom();
        // this.test();
        // this.list.scrollToPercentVertical(0, 0.1);
    };
    ChatView.prototype.test = function () {
        this.m_cellDatas.push({
            chatType: Enum_1.ChatType.System,
            title: "",
            content: "张三进入聊天室"
        });
        this.m_cellDatas.push({
            chatType: Enum_1.ChatType.OtherUser,
            title: "鹿晗",
            content: "哈哈，我知道谁是卧底"
        });
        this.m_cellDatas.push({
            chatType: Enum_1.ChatType.OtherUser,
            title: "王祖蓝",
            content: "我是好人"
        });
        this.m_cellDatas.push({
            chatType: Enum_1.ChatType.OtherUser,
            title: "黄渤",
            content: "最后一次警告，缴枪不杀"
        });
        this.m_cellDatas.push({
            chatType: Enum_1.ChatType.OtherUser,
            title: "范冰冰",
            content: "让我再回一次娱乐圈吧，娃哈哈是否第三方司法所发生地方"
        });
        this.m_cellDatas.push({
            chatType: Enum_1.ChatType.OtherUser,
            title: "鹿晗2",
            content: "哈哈，我知道谁是卧底司法所发生地方第三方第三方水电费第三方第三是否打算公司gas公司方"
        });
        this.m_cellDatas.push({
            chatType: Enum_1.ChatType.OtherUser,
            title: "王祖蓝2",
            content: "我是好人"
        });
        this.m_cellDatas.push({
            chatType: Enum_1.ChatType.OtherUser,
            title: "黄渤2",
            content: "最后一次警告，缴枪不杀"
        });
        this.m_cellDatas.push({
            chatType: Enum_1.ChatType.OtherUser,
            title: "范冰冰2",
            content: "让我再回一次娱乐圈吧，娃哈哈"
        });
    };
    __decorate([
        property(cc.Prefab)
    ], ChatView.prototype, "chatCellPrefab", void 0);
    __decorate([
        property({
            type: cc.Node,
        })
    ], ChatView.prototype, "listNode", void 0);
    ChatView = __decorate([
        ccclass
    ], ChatView);
    return ChatView;
}(cc.Component));
exports.default = ChatView;

cc._RF.pop();