/**
 * 资源加载器相关的优化
 * @Author: sthoo.huang 
 * @Date: 2019-02-14 18:07:15
 * @Last Modified by: Tree
 * @Last Modified time: 2020-05-26 17:24:00
 */

if (CC_EDITOR) {
    // 针对编辑器不做任何处理
} else {
    const Buffer = require('buffer').Buffer;
    const amf = require('ham-amf');
    const pako = require('pako');
    const Timer = require("../core/gdk_Timer");

    var downloader = cc.loader.downloader;
    var proto = downloader.__proto__;
    var jsonMap = window._ResImportJsonMd5Map;
    var jsonMapNum = window._ResImportJsonMd5MapNumber;
    window._ResImportJsonMd5Map = undefined;
    window._ResImportJsonMd5MapNumber = undefined;

    // 存在合并的JSON映射数据时，才修改原引擎代码
    if (jsonMap) {

        function getMjname(url) {
            return (parseInt(url.split('res/import/')[1].split('/')[0], 16) % jsonMapNum).toString(16);
        };

        // mjson文件缓存
        var MJsonCache = {
            length: 0, // 加载完成的数量
            caches: {},

            get: function (key) {
                var value = this.caches[key];
                value && (value.lastUseTime = Date.now());
                return value;
            },

            set: function (key, value) {
                this.caches[key] = value;
                value && (value.lastUseTime = Date.now());
                return value;
            },

            releaseHandler: function () {
                if (this.length === 0) {
                    Timer.clear(this, this.releaseHandler);
                    return;
                }
                var now = Date.now();
                for (var key in this.caches) {
                    if (key == 'length') continue;
                    var e = this.caches[key];
                    if (e.loaded &&
                        e.queue.length < 1 &&
                        now - e.lastUseTime > 30000) {
                        // 清除缓存的数据
                        delete this.caches[key];
                        this.length--;
                    }
                }
            },
        };

        var downloadText = downloader.extMap['json'];
        var downloadBinary = downloader.extMap['binary'];
        var downloadMjson = function (item, callback) {
            var names = item.url.split('/');
            var jsname = names.pop();
            var mjname = getMjname(item.url);
            var rev = jsonMap[mjname];
            names[names.length - 1] = mjname + '.' + rev + '.mjson';
            var res = {
                'url': names.join('/')
            };
            var cache = MJsonCache.get(res.url);
            if (cache && cache.loaded) {
                cache.lastUseTime = Date.now();
                callback && callback(null, cache.data[jsname]);
            } else {
                if (cache) {
                    cache.queue.push({
                        'cb': callback,
                        'key': jsname
                    });
                } else {
                    cache = MJsonCache.set(res.url, {
                        'lastUseTime': Date.now(),
                        'data': null,
                        'loaded': false,
                        'queue': [{
                            'cb': callback,
                            'key': jsname
                        }],
                    });
                    downloadBinary.call(this, res, function (err, result) {
                        if (!err) {
                            cache.data = amf.decodeObject(Buffer.from(pako.inflate(result)));
                            cache.loaded = true;
                            cache.lastUseTime = Date.now();

                            // MJson数据回收
                            // MJsonCache.length++;
                            // MJsonCache.length === 1 && Timer.loop(15000, MJsonCache, MJsonCache.releaseHandler);
                        }
                        while (cache.queue.length > 0) {
                            var e = cache.queue.shift();
                            (e && e.cb) && e.cb(err, (cache && cache.data) ? cache.data[e.key] : null);
                        }
                    });
                }
            }
        };

        downloader.extMap['json'] = function (item, callback) {
            var names = item.url.split('res/import/');
            if (names.length > 1) {
                var mjname = getMjname(item.url);
                var rev = jsonMap[mjname];
                if (rev) {
                    return downloadMjson.call(this, item, callback);
                }
            }
            // 不在合并的JSON列表中，调用原函数
            return downloadText.call(this, item, callback);
        };
    }

    function urlAppendTimestamp(url) {
        if (cc.game.config['noCache'] && typeof url === 'string') {
            if (_noCacheRex.test(url))
                url += '&_t=' + (new Date() - 0);
            else
                url += '?_t=' + (new Date() - 0);
        }
        return url;
    };



    function downloadScript(item, callback, isAsync) {
        var url = item.url,
            d = document,
            s = document.createElement('script');

        if (window.location.protocol !== 'file:') {
            s.crossOrigin = 'anonymous';
        }

        s.async = isAsync;
        s.src = urlAppendTimestamp(url);

        function loadHandler() {
            s.parentNode.removeChild(s);
            s.removeEventListener('load', loadHandler, false);
            s.removeEventListener('error', errorHandler, false);
            callback(null, url);
        }

        function errorHandler() {
            s.parentNode.removeChild(s);
            s.removeEventListener('load', loadHandler, false);
            s.removeEventListener('error', errorHandler, false);
            callback(new Error(debug.getError(4928, url)));
        }
        s.addEventListener('load', loadHandler, false);
        s.addEventListener('error', errorHandler, false);
        d.body.appendChild(s);
    }

    //重写分包加载的逻辑  2.3.x 版本加了一个 progressCallback 的参数
    proto.loadSubpackage = function (name, progressCallback, completeCallback, version) {
        if (!completeCallback && progressCallback) {
            completeCallback = progressCallback;
            progressCallback = null;
        }
        let pac = this._subpackages[name];
        if (pac) {
            if (pac.loaded) {
                if (completeCallback) completeCallback();
            } else {
                downloadScript({
                    url: pac.path + "index.js?v=" + version
                }, function (err) {
                    if (!err) {
                        pac.loaded = true;
                    }
                    if (completeCallback) completeCallback(err);
                });
            }
        } else if (completeCallback) {
            completeCallback(new Error(`Can't find subpackage ${name}`));
        }
    };
}