// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    @property(cc.Node)
    testBtn1: cc.Node = null
    @property(cc.Node)
    testBtn2: cc.Node = null
    @property(cc.Node)
    testBtn3: cc.Node = null


    start() {
        this.testBtn1.on(cc.Node.EventType.TOUCH_END, this.test1, this)
        this.testBtn2.on(cc.Node.EventType.TOUCH_END, this.test2, this)
        this.testBtn3.on(cc.Node.EventType.TOUCH_END, this.test3, this)
    }

    private getPrefab() {
        return new Promise<cc.Prefab>(resolve => {
            cc.resources.load('EditBox', cc.Prefab, (err: Error, asset: cc.Prefab) => {
                if (!err) {
                    if (asset) {
                        resolve(asset)
                    }
                }
            });
        });
    }

    private async test1() {
        let testEditBoxPrefab = await this.getPrefab()
        let testEditBoxNode = cc.instantiate(testEditBoxPrefab)
        this.node.addChild(testEditBoxNode)
        testEditBoxNode.setPosition(100, 100, 0)
        let targetInput = testEditBoxNode.getComponent(cc.EditBox)
        targetInput.textLabel.node.color = cc.Color.ORANGE;
        targetInput.placeholderLabel.node.color = cc.Color.ORANGE;
    }

    private async test2() {
        let testEditBoxPrefab = await this.getPrefab()
        let testEditBoxNode = cc.instantiate(testEditBoxPrefab)
        this.node.addChild(testEditBoxNode)
        testEditBoxNode.setPosition(200, 200, 0)
        let targetInput = testEditBoxNode.getComponent(cc.EditBox)
        targetInput.textLabel.node.color = cc.Color.BLUE;
        targetInput.placeholderLabel.node.color = cc.Color.BLUE;
    }

    private async test3() {
        let testEditBoxPrefab = await this.getPrefab()
        let testEditBoxNode = cc.instantiate(testEditBoxPrefab)
        this.node.addChild(testEditBoxNode)
        testEditBoxNode.setPosition(300, 300, 0)
        let targetInput = testEditBoxNode.getComponent(cc.EditBox)
        targetInput.textLabel.node.color = cc.Color.GREEN;
        targetInput.placeholderLabel.node.color = cc.Color.GREEN;
        // update (dt) {}
    }
}
